

CREATE TABLE `BXzlkOCF_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `BXzlkOCF_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO BXzlkOCF_comments VALUES("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2023-04-14 08:02:31","2023-04-14 08:02:31","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://en.gravatar.com/\">Gravatar</a>.","0","1","","comment","0","0");



CREATE TABLE `BXzlkOCF_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `BXzlkOCF_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `BXzlkOCF_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=379 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO BXzlkOCF_options VALUES("1","siteurl","https://oo-uae.com","yes");
INSERT INTO BXzlkOCF_options VALUES("2","home","https://oo-uae.com","yes");
INSERT INTO BXzlkOCF_options VALUES("3","blogname","Orpheus Oriens","yes");
INSERT INTO BXzlkOCF_options VALUES("4","blogdescription","Structured Product Specialists","yes");
INSERT INTO BXzlkOCF_options VALUES("5","users_can_register","0","yes");
INSERT INTO BXzlkOCF_options VALUES("6","admin_email","admin@oo-uae.com","yes");
INSERT INTO BXzlkOCF_options VALUES("7","start_of_week","1","yes");
INSERT INTO BXzlkOCF_options VALUES("8","use_balanceTags","0","yes");
INSERT INTO BXzlkOCF_options VALUES("9","use_smilies","1","yes");
INSERT INTO BXzlkOCF_options VALUES("10","require_name_email","1","yes");
INSERT INTO BXzlkOCF_options VALUES("11","comments_notify","1","yes");
INSERT INTO BXzlkOCF_options VALUES("12","posts_per_rss","10","yes");
INSERT INTO BXzlkOCF_options VALUES("13","rss_use_excerpt","0","yes");
INSERT INTO BXzlkOCF_options VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO BXzlkOCF_options VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO BXzlkOCF_options VALUES("16","mailserver_pass","password","yes");
INSERT INTO BXzlkOCF_options VALUES("17","mailserver_port","110","yes");
INSERT INTO BXzlkOCF_options VALUES("18","default_category","1","yes");
INSERT INTO BXzlkOCF_options VALUES("19","default_comment_status","open","yes");
INSERT INTO BXzlkOCF_options VALUES("20","default_ping_status","closed","yes");
INSERT INTO BXzlkOCF_options VALUES("21","default_pingback_flag","","yes");
INSERT INTO BXzlkOCF_options VALUES("22","posts_per_page","10","yes");
INSERT INTO BXzlkOCF_options VALUES("23","date_format","F j, Y","yes");
INSERT INTO BXzlkOCF_options VALUES("24","time_format","g:i a","yes");
INSERT INTO BXzlkOCF_options VALUES("25","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO BXzlkOCF_options VALUES("26","comment_moderation","0","yes");
INSERT INTO BXzlkOCF_options VALUES("27","moderation_notify","1","yes");
INSERT INTO BXzlkOCF_options VALUES("28","permalink_structure","/%year%/%monthnum%/%day%/%postname%/","yes");
INSERT INTO BXzlkOCF_options VALUES("29","rewrite_rules","a:201:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:39:\"index.php?yoast-sitemap-xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio-category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio-category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio-category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:54:\"portfolio-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:49:\"portfolio-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?portfolio_tag=$matches[1]&feed=$matches[2]\";s:30:\"portfolio-tag/([^/]+)/embed/?$\";s:46:\"index.php?portfolio_tag=$matches[1]&embed=true\";s:42:\"portfolio-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?portfolio_tag=$matches[1]&paged=$matches[2]\";s:24:\"portfolio-tag/([^/]+)/?$\";s:35:\"index.php?portfolio_tag=$matches[1]\";s:42:\"jupiterx-codes/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"jupiterx-codes/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"jupiterx-codes/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"jupiterx-codes/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"jupiterx-codes/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"jupiterx-codes/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"jupiterx-codes/([^/]+)/embed/?$\";s:47:\"index.php?jupiterx-codes=$matches[1]&embed=true\";s:35:\"jupiterx-codes/([^/]+)/trackback/?$\";s:41:\"index.php?jupiterx-codes=$matches[1]&tb=1\";s:43:\"jupiterx-codes/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-codes=$matches[1]&paged=$matches[2]\";s:50:\"jupiterx-codes/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-codes=$matches[1]&cpage=$matches[2]\";s:39:\"jupiterx-codes/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?jupiterx-codes=$matches[1]&page=$matches[2]\";s:31:\"jupiterx-codes/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"jupiterx-codes/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"jupiterx-codes/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"jupiterx-codes/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"jupiterx-codes/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"jupiterx-codes/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"jupiterx-fonts/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"jupiterx-fonts/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"jupiterx-fonts/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"jupiterx-fonts/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"jupiterx-fonts/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"jupiterx-fonts/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"jupiterx-fonts/([^/]+)/embed/?$\";s:47:\"index.php?jupiterx-fonts=$matches[1]&embed=true\";s:35:\"jupiterx-fonts/([^/]+)/trackback/?$\";s:41:\"index.php?jupiterx-fonts=$matches[1]&tb=1\";s:43:\"jupiterx-fonts/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-fonts=$matches[1]&paged=$matches[2]\";s:50:\"jupiterx-fonts/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-fonts=$matches[1]&cpage=$matches[2]\";s:39:\"jupiterx-fonts/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?jupiterx-fonts=$matches[1]&page=$matches[2]\";s:31:\"jupiterx-fonts/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"jupiterx-fonts/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"jupiterx-fonts/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"jupiterx-fonts/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"jupiterx-fonts/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"jupiterx-fonts/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"jupiterx-icons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"jupiterx-icons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"jupiterx-icons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"jupiterx-icons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"jupiterx-icons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"jupiterx-icons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"jupiterx-icons/([^/]+)/embed/?$\";s:47:\"index.php?jupiterx-icons=$matches[1]&embed=true\";s:35:\"jupiterx-icons/([^/]+)/trackback/?$\";s:41:\"index.php?jupiterx-icons=$matches[1]&tb=1\";s:43:\"jupiterx-icons/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-icons=$matches[1]&paged=$matches[2]\";s:50:\"jupiterx-icons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?jupiterx-icons=$matches[1]&cpage=$matches[2]\";s:39:\"jupiterx-icons/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?jupiterx-icons=$matches[1]&page=$matches[2]\";s:31:\"jupiterx-icons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"jupiterx-icons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"jupiterx-icons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"jupiterx-icons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"jupiterx-icons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"jupiterx-icons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=2&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}","yes");
INSERT INTO BXzlkOCF_options VALUES("30","hack_file","0","yes");
INSERT INTO BXzlkOCF_options VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO BXzlkOCF_options VALUES("32","moderation_keys","","no");
INSERT INTO BXzlkOCF_options VALUES("33","active_plugins","a:8:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:23:\"elementor/elementor.php\";i:3;s:35:\"google-site-kit/google-site-kit.php\";i:4;s:31:\"jupiterx-core/jupiterx-core.php\";i:5;s:63:\"limit-login-attempts-reloaded/limit-login-attempts-reloaded.php\";i:6;s:24:\"wordpress-seo/wp-seo.php\";i:7;s:27:\"wp-super-cache/wp-cache.php\";}","yes");
INSERT INTO BXzlkOCF_options VALUES("34","category_base","","yes");
INSERT INTO BXzlkOCF_options VALUES("35","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO BXzlkOCF_options VALUES("36","comment_max_links","2","yes");
INSERT INTO BXzlkOCF_options VALUES("37","gmt_offset","0","yes");
INSERT INTO BXzlkOCF_options VALUES("38","default_email_category","1","yes");
INSERT INTO BXzlkOCF_options VALUES("39","recently_edited","","no");
INSERT INTO BXzlkOCF_options VALUES("40","template","jupiterx","yes");
INSERT INTO BXzlkOCF_options VALUES("41","stylesheet","jupiterx","yes");
INSERT INTO BXzlkOCF_options VALUES("42","comment_registration","0","yes");
INSERT INTO BXzlkOCF_options VALUES("43","html_type","text/html","yes");
INSERT INTO BXzlkOCF_options VALUES("44","use_trackback","0","yes");
INSERT INTO BXzlkOCF_options VALUES("45","default_role","subscriber","yes");
INSERT INTO BXzlkOCF_options VALUES("46","db_version","53496","yes");
INSERT INTO BXzlkOCF_options VALUES("47","uploads_use_yearmonth_folders","1","yes");
INSERT INTO BXzlkOCF_options VALUES("48","upload_path","","yes");
INSERT INTO BXzlkOCF_options VALUES("49","blog_public","1","yes");
INSERT INTO BXzlkOCF_options VALUES("50","default_link_category","2","yes");
INSERT INTO BXzlkOCF_options VALUES("51","show_on_front","page","yes");
INSERT INTO BXzlkOCF_options VALUES("52","tag_base","","yes");
INSERT INTO BXzlkOCF_options VALUES("53","show_avatars","1","yes");
INSERT INTO BXzlkOCF_options VALUES("54","avatar_rating","G","yes");
INSERT INTO BXzlkOCF_options VALUES("55","upload_url_path","","yes");
INSERT INTO BXzlkOCF_options VALUES("56","thumbnail_size_w","150","yes");
INSERT INTO BXzlkOCF_options VALUES("57","thumbnail_size_h","150","yes");
INSERT INTO BXzlkOCF_options VALUES("58","thumbnail_crop","1","yes");
INSERT INTO BXzlkOCF_options VALUES("59","medium_size_w","300","yes");
INSERT INTO BXzlkOCF_options VALUES("60","medium_size_h","300","yes");
INSERT INTO BXzlkOCF_options VALUES("61","avatar_default","mystery","yes");
INSERT INTO BXzlkOCF_options VALUES("62","large_size_w","1024","yes");
INSERT INTO BXzlkOCF_options VALUES("63","large_size_h","1024","yes");
INSERT INTO BXzlkOCF_options VALUES("64","image_default_link_type","none","yes");
INSERT INTO BXzlkOCF_options VALUES("65","image_default_size","","yes");
INSERT INTO BXzlkOCF_options VALUES("66","image_default_align","","yes");
INSERT INTO BXzlkOCF_options VALUES("67","close_comments_for_old_posts","0","yes");
INSERT INTO BXzlkOCF_options VALUES("68","close_comments_days_old","14","yes");
INSERT INTO BXzlkOCF_options VALUES("69","thread_comments","1","yes");
INSERT INTO BXzlkOCF_options VALUES("70","thread_comments_depth","5","yes");
INSERT INTO BXzlkOCF_options VALUES("71","page_comments","0","yes");
INSERT INTO BXzlkOCF_options VALUES("72","comments_per_page","50","yes");
INSERT INTO BXzlkOCF_options VALUES("73","default_comments_page","newest","yes");
INSERT INTO BXzlkOCF_options VALUES("74","comment_order","asc","yes");
INSERT INTO BXzlkOCF_options VALUES("75","sticky_posts","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("76","widget_categories","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("77","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("78","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("79","uninstall_plugins","a:3:{s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";s:27:\"wp-super-cache/wp-cache.php\";s:22:\"wpsupercache_uninstall\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}","no");
INSERT INTO BXzlkOCF_options VALUES("80","timezone_string","","yes");
INSERT INTO BXzlkOCF_options VALUES("81","page_for_posts","0","yes");
INSERT INTO BXzlkOCF_options VALUES("82","page_on_front","2","yes");
INSERT INTO BXzlkOCF_options VALUES("83","default_post_format","0","yes");
INSERT INTO BXzlkOCF_options VALUES("84","link_manager_enabled","0","yes");
INSERT INTO BXzlkOCF_options VALUES("85","finished_splitting_shared_terms","1","yes");
INSERT INTO BXzlkOCF_options VALUES("86","site_icon","0","yes");
INSERT INTO BXzlkOCF_options VALUES("87","medium_large_size_w","768","yes");
INSERT INTO BXzlkOCF_options VALUES("88","medium_large_size_h","0","yes");
INSERT INTO BXzlkOCF_options VALUES("89","wp_page_for_privacy_policy","3","yes");
INSERT INTO BXzlkOCF_options VALUES("90","show_comments_cookies_opt_in","1","yes");
INSERT INTO BXzlkOCF_options VALUES("91","admin_email_lifespan","1697011351","yes");
INSERT INTO BXzlkOCF_options VALUES("92","disallowed_keys","","no");
INSERT INTO BXzlkOCF_options VALUES("93","comment_previously_approved","1","yes");
INSERT INTO BXzlkOCF_options VALUES("94","auto_plugin_theme_update_emails","a:0:{}","no");
INSERT INTO BXzlkOCF_options VALUES("95","auto_update_core_dev","enabled","yes");
INSERT INTO BXzlkOCF_options VALUES("96","auto_update_core_minor","enabled","yes");
INSERT INTO BXzlkOCF_options VALUES("97","auto_update_core_major","enabled","yes");
INSERT INTO BXzlkOCF_options VALUES("98","wp_force_deactivated_plugins","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("99","initial_db_version","53496","yes");
INSERT INTO BXzlkOCF_options VALUES("100","BXzlkOCF_user_roles","a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}","yes");
INSERT INTO BXzlkOCF_options VALUES("101","fresh_site","0","yes");
INSERT INTO BXzlkOCF_options VALUES("102","user_count","1","no");
INSERT INTO BXzlkOCF_options VALUES("103","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("104","sidebars_widgets","a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar_primary\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:17:\"sidebar_secondary\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:23:\"footer_widgets_column_1\";a:0:{}s:23:\"footer_widgets_column_2\";a:0:{}s:23:\"footer_widgets_column_3\";a:0:{}s:23:\"footer_widgets_column_4\";a:0:{}s:23:\"footer_widgets_column_5\";a:0:{}s:23:\"footer_widgets_column_6\";a:0:{}s:13:\"array_version\";i:3;}","yes");
INSERT INTO BXzlkOCF_options VALUES("105","cron","a:11:{i:1681488151;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1681502551;a:3:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1681502644;a:1:{s:41:\"googlesitekit_cron_update_remote_features\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1681502743;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1681545751;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1681545893;a:1:{s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1681545942;a:3:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1681545946;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1681546045;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1681632169;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO BXzlkOCF_options VALUES("106","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("107","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("108","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("109","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("110","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("111","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("112","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("113","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("114","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("115","nonce_key","a*?.3GxVXM0Rw.I.MB/j8L&yr-1C:Tz<_LRCkUiV%feZxS5QX;qrqD|&U-61EPF3","no");
INSERT INTO BXzlkOCF_options VALUES("116","nonce_salt",")q}b42sN~Cj/9t;$s0=wv_<G .*54*A)6W/*|6|!j<V,%w1hobzKM{JcOw!;7q(Q","no");
INSERT INTO BXzlkOCF_options VALUES("117","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("118","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("119","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("120","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("121","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("123","theme_mods_twentytwentythree","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1681459598;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","yes");
INSERT INTO BXzlkOCF_options VALUES("124","recovery_keys","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("125","https_detection_errors","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("126","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-6.2.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-6.2-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-6.2-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.2\";s:7:\"version\";s:3:\"6.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1681459595;s:15:\"version_checked\";s:3:\"6.2\";s:12:\"translations\";a:0:{}}","no");
INSERT INTO BXzlkOCF_options VALUES("141","yoast_migrations_free","a:1:{s:7:\"version\";s:4:\"20.5\";}","yes");
INSERT INTO BXzlkOCF_options VALUES("142","wpseo","a:101:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:20:\"taxonomy_made_public\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"20.5\";s:16:\"previous_version\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1681459493;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:36:\"/%year%/%monthnum%/%day%/%postname%/\";s:8:\"home_url\";s:18:\"https://oo-uae.com\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:0:{}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:34:\"dismiss_old_premium_version_notice\";s:0:\"\";s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:28:\"wordproof_integration_active\";b:0;s:29:\"wordproof_integration_changed\";b:0;s:18:\"first_time_install\";b:1;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1681459493;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:9:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:10:\"attachment\";i:3;s:14:\"e-landing-page\";i:4;s:17:\"elementor_library\";i:5;s:9:\"portfolio\";i:6;s:14:\"jupiterx-codes\";i:7;s:14:\"jupiterx-fonts\";i:8;s:14:\"jupiterx-icons\";}s:28:\"last_known_public_taxonomies\";a:5:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";i:3;s:18:\"portfolio_category\";i:4;s:13:\"portfolio_tag\";}}","yes");
INSERT INTO BXzlkOCF_options VALUES("143","wpseo_titles","a:110:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}","yes");
INSERT INTO BXzlkOCF_options VALUES("144","wpseo_social","a:20:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}s:12:\"mastodon_url\";s:0:\"\";}","yes");
INSERT INTO BXzlkOCF_options VALUES("148","wpcf7","a:2:{s:7:\"version\";s:7:\"5.7.5.1\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1681459519;s:7:\"version\";s:7:\"5.7.5.1\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}","yes");
INSERT INTO BXzlkOCF_options VALUES("152","googlesitekit_db_version","1.3.0","yes");
INSERT INTO BXzlkOCF_options VALUES("157","_transient_timeout_wpseo_total_unindexed_post_type_archives","1681545943","no");
INSERT INTO BXzlkOCF_options VALUES("158","_transient_wpseo_total_unindexed_post_type_archives","0","no");
INSERT INTO BXzlkOCF_options VALUES("159","_transient_timeout_wpseo_total_unindexed_general_items","1681545946","no");
INSERT INTO BXzlkOCF_options VALUES("160","_transient_wpseo_total_unindexed_general_items","0","no");
INSERT INTO BXzlkOCF_options VALUES("171","limit_login_activation_timestamp","1681459544","yes");
INSERT INTO BXzlkOCF_options VALUES("172","limit_login_notice_enable_notify_timestamp","1678694744","yes");
INSERT INTO BXzlkOCF_options VALUES("173","_site_transient_timeout_browser_35dad70abc601e229e115d200cb9a0ba","1682064344","no");
INSERT INTO BXzlkOCF_options VALUES("174","_site_transient_browser_35dad70abc601e229e115d200cb9a0ba","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"112.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no");
INSERT INTO BXzlkOCF_options VALUES("175","_site_transient_timeout_php_check_3fde9d06ba9e4fd20d08658e6f30b792","1682064346","no");
INSERT INTO BXzlkOCF_options VALUES("176","_site_transient_php_check_3fde9d06ba9e4fd20d08658e6f30b792","a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","no");
INSERT INTO BXzlkOCF_options VALUES("182","_transient_timeout_wpseo_unindexed_post_link_count","1681545948","no");
INSERT INTO BXzlkOCF_options VALUES("183","_transient_wpseo_unindexed_post_link_count","0","no");
INSERT INTO BXzlkOCF_options VALUES("184","_transient_timeout_wpseo_unindexed_term_link_count","1681545948","no");
INSERT INTO BXzlkOCF_options VALUES("185","_transient_wpseo_unindexed_term_link_count","0","no");
INSERT INTO BXzlkOCF_options VALUES("186","limit_login_lockouts","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("187","limit_login_logged","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("188","limit_login_retries","a:3:{s:13:\"103.147.35.54\";i:1;s:13:\"185.15.196.34\";i:2;s:14:\"188.166.46.146\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("189","limit_login_retries_valid","a:3:{s:13:\"103.147.35.54\";i:1681550665;s:13:\"185.15.196.34\";i:1681550721;s:14:\"188.166.46.146\";i:1681553387;}","yes");
INSERT INTO BXzlkOCF_options VALUES("190","can_compress_scripts","1","no");
INSERT INTO BXzlkOCF_options VALUES("191","_site_transient_timeout_community-events-9467a16480922a610a23ed970b73aab3","1681502750","no");
INSERT INTO BXzlkOCF_options VALUES("192","_site_transient_community-events-9467a16480922a610a23ed970b73aab3","a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:13:\"102.182.190.0\";}s:6:\"events\";a:0:{}}","no");
INSERT INTO BXzlkOCF_options VALUES("193","_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3","1681502750","no");
INSERT INTO BXzlkOCF_options VALUES("194","_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Apr 2023 11:27:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.3-alpha-55650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WP Briefing: Episode 53: A Look at WordPress 6.2 “Dolphy”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wordpress.org/news/2023/04/episode-53-a-look-at-wordpress-6-2-dolphy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Apr 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=14818\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:218:\"Named after the multi-instrumentalist Eric Allan Dolphy Jr., WordPress 6.2 \"Dolphy\"\'s high notes are riffed on by WordPress\'s Executive Director, Josepha Haden Chomphosy, in this 53rd episode of the WordPress Briefing.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2023/04/WP-Briefing-053.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9292:\"\n<p>Named after the multi-instrumentalist Eric Allan Dolphy Jr., WordPress 6.2 &#8220;Dolphy&#8221;&#8216;s high notes are riffed on by WordPress&#8217;s Executive Director, Josepha Haden Chomphosy, in this 53rd episode of the WordPress Briefing.</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production:&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a><br>Song: Fearless First by Kevin MacLeod </p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2023/03/dolphy/\">WordPress 6.2 &#8220;Dolphy&#8221;</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2023/03/introducing-the-wordpress-developer-blog/\">Introducing the WordPress Developer Blog</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/project/?p=251\">WordPress Contributor Mentorship Program</a></li>\n\n\n\n<li><a href=\"https://wp.me/p2U65r-9Nl\">Call for Volunteers: Contributor Working Group</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/design/?p=11037\">Why Jazz</a></li>\n\n\n\n<li>Make Slack channels <a href=\"https://wordpress.slack.com/archives/C04QZCREJ9W\">#kidscamp</a> and <a href=\"https://wordpress.slack.com/archives/C03JNV77Y57\">#sustainability</a> </li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-14818\"></span>\n\n\n\n<p>[Josepha Haden Chomphosy 00:00:00] </p>\n\n\n\n<p>Hello everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress Open Source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks.</p>\n\n\n\n<p>I&#8217;m your host, Josepha Haden Chomphosy. Here we go.</p>\n\n\n\n<p>[00:00:28]</p>\n\n\n\n<p>The latest version of WordPress has shipped. WordPress 6.2, which was named after Eric Dolphy, was released on March 29th. And as is the way with software, there&#8217;s already a minor release underway to catch a few errant issues that folks like you have reported to us.</p>\n\n\n\n<p>It&#8217;s a big release that refines a lot of our design tools, but some of the most important changes are actually to the inserter. If you haven&#8217;t had a chance to get in there and play with it yet, here are the three things that I think you should know. </p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:01:08] </p>\n\n\n\n<p>First, the pattern browser. We&#8217;re all aware of the block inserter by now, and a lot of us probably use the quick options, the keyboard shortcuts, or that kind of inline inserter, that little black box that&#8217;s in the middle of your post.</p>\n\n\n\n<p>If you use the main inserter, that&#8217;s a blue square in the top left of the screen. If you use that to add a block, you can still add individual blocks as usual. But there&#8217;s a new way to browse patterns, and in my opinion, it is so much better. It now brings out this drawer that has like thumbnails of patterns that will work with your theme.</p>\n\n\n\n<p>And if you, like me, know what you want your site to look like, but could not in a million years figure out how to build it from scratch out of individual blocks, then this is the area for you. It was like shopping, but you don&#8217;t have to go through a checkout process at the end, and you still have what you want. It&#8217;s great.&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:02:00]&nbsp;</p>\n\n\n\n<p>That&#8217;s also available when you&#8217;re working on templates or template parts, so you can make changes everywhere instead of going page by page. The second thing that I think you should know is about the media browser in that same area where you browse your patterns; you can also now browse for media.</p>\n\n\n\n<p>It lets you look through the images you&#8217;ve already added to your site, but it also lets you search for openly licensed images from Openverse. And if you choose one of those images from Openverse, it inserts the proper attribution for you. You still have to add your own alt text, but that&#8217;s the fun part anyway, right?</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:02:35]&nbsp;</p>\n\n\n\n<p>And number three, a Style Book. So this thing is available in the template editing area, specifically, as is appropriate, given what it actually does. So if you&#8217;re in the template area, toward the top right of the screen is like a half moon day mode, night mode looking icon. If you click on that, you can make changes to things inside your blocks.</p>\n\n\n\n<p>But if you click on the little eyeball icon that&#8217;s just underneath it, it pulls up a style book where you can also see and edit the styles globally. If that didn&#8217;t make sense to you, don&#8217;t worry. I&#8217;ve got you. I&#8217;m about to tell you a bunch of things you can do in here. You can edit the way headings and lists and tables, quotes, and code looks all across the site. You can edit the way images, galleries, files, and videos look using custom CSS.</p>\n\n\n\n<p>Yes. Also, all across the site. And you can edit buttons, separators, and individual blocks. Say it with me &#8212; all across the site. That is not a comprehensive list. There is a ton of stuff. You can see the styles that you have applied across the whole site. You can see them in context, and you can make any changes that you need globally, which means all across the site.</p>\n\n\n\n<p>Yeah. Style Books. What will we think of next? </p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:03:54]&nbsp;</p>\n\n\n\n<p>So those are my three things I think you should know about WordPress right now. As a former WordPress builder who was never really super great with the code, this stuff makes me feel powerful. I just love these changes, and I hope you do too.</p>\n\n\n\n<p> [00:04:07]</p>\n\n\n\n<p>Which brings us now to our small list of big things. First, we just launched the Developer Blog. It&#8217;s over at developer.wordpress.org/news. It has a bunch of content on it that not only is geared specifically toward developers that are using WordPress but especially the folks who are extending WordPress. It gives you kind of an in-depth look at various changes and projects, and implementations and what goes into each one of them.</p>\n\n\n\n<p>So it gives you a bit of like this aspirational overview of stuff that you could do with WordPress and then also gives you an inside look at how you would accomplish it yourself. It&#8217;s very cool. I like it a lot. Head on over there, but we&#8217;ll have a link to the show notes below.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:05:00]&nbsp;</p>\n\n\n\n<p>The second thing is that we have an MVP of our new mentorship program that is underway.</p>\n\n\n\n<p>It should be debuting for essentially testing any day now, a link to the posts detailing that work, just in case you want to join that important initiative. But it is an important thing for me. I think that mentorship is a key element of many of our successful contributors&#8217; onboarding journeys, a part of their story of coming to us.</p>\n\n\n\n<p>And so, creating a mentorship program that is a bit sustainable and looks toward the health of the overall project, I think, is an excellent plan.&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:05:38]&nbsp;</p>\n\n\n\n<p>The third thing on our small list of big things is that Matt put out a nice little post about kind of the history of why jazz has this strong background in the WordPress project. It&#8217;s a brief read. I&#8217;ll put a link to that in the show notes as well. But suffice it to say that he&#8217;s saying that jazz has a little bit of learned processes and rules but that the primary expectation is that you&#8217;re able to make of the jazz what you want. Like you get to make your own thing out of it. You get to be extemporaneous. You get to be very measured, whatever it is, that expresses what you are trying to do and what you are trying to say with it.</p>\n\n\n\n<p>That&#8217;s why he feels like jazz is such an important part of the DNA of the WordPress project. Like I said, it&#8217;s a short read. I&#8217;ll put a link to it in the show notes.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:06:30]&nbsp;</p>\n\n\n\n<p>And finally, there are a few working groups that folks can contribute to right now. We don&#8217;t always have working groups. We generally just kind of do stuff inside individual teams. But right now, we&#8217;ve got like the kids camp group, the sustainability group, and of course, that mentorship working group that I mentioned earlier in our list.</p>\n\n\n\n<p>So if you&#8217;re wanting a little change of pace, I&#8217;d drop by their areas in the Making WordPress Slack to see if they have anything that&#8217;s up your alley. </p>\n\n\n\n<p>And that, my friends, is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"14818\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"The Month in WordPress – March 2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2023/04/the-month-in-wordpress-march-2023/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Apr 2023 10:30:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:18:\"month in wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=14780\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"March saw the arrival of the first major release of 2023, WordPress 6.2 “Dolphy.” Planning for the project&#8217;s 20th anniversary continues with new celebratory updates and commemorative swag. Read on for the latest happenings in the WordPress space. Meet WordPress 6.2 “Dolphy” WordPress 6.2 “Dolphy” was released on March 29, 2023. Named after the acclaimed [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"rmartinezduque\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:15294:\"\n<p>March saw the arrival of the first major release of 2023, WordPress 6.2 “Dolphy.” Planning for the project&#8217;s 20th anniversary continues with new celebratory updates and commemorative swag. Read on for the latest happenings in the WordPress space.</p>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Meet WordPress 6.2 “Dolphy”</h2>\n\n\n\n<p><strong><a href=\"https://wordpress.org/news/2023/03/dolphy/\">WordPress 6.2</a> “Dolphy” was released on March 29, 2023</strong>. Named after the acclaimed jazz multi-instrumentalist and composer<strong> </strong>Eric Allan Dolphy Jr., the latest version of WordPress further enhances the site editing experience with significant updates.</p>\n\n\n\n<p>Highlights include a reimagined Site Editor interface, a more intuitive way to manage menus, and a distraction-free writing mode. A new Block Inserter design adds integration with <a href=\"https://openverse.org/\">Openverse</a>, allowing you to easily browse and insert free, openly-licensed images and audio files into your content.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" width=\"1024\" height=\"581\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/04/WordPress-6.2-highlight-grid.png?resize=1024%2C581&#038;ssl=1\" alt=\"Feature highlights in WordPress 6.2: Reimagined Site Editor, more ways to manage menus, a more powerful inserter, faster access to media—yours and Openverse\'s, the new Style Book, distraction-free writing, and more.\" class=\"wp-image-14782\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/04/WordPress-6.2-highlight-grid.png?resize=1024%2C581&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/04/WordPress-6.2-highlight-grid.png?resize=300%2C170&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/04/WordPress-6.2-highlight-grid.png?resize=768%2C436&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/04/WordPress-6.2-highlight-grid.png?resize=1536%2C871&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2023/04/WordPress-6.2-highlight-grid.png?resize=2048%2C1162&amp;ssl=1 2048w, https://i0.wp.com/wordpress.org/news/files/2023/04/WordPress-6.2-highlight-grid.png?w=3000&amp;ssl=1 3000w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Whether you&#8217;re a content creator, designer, or developer, WordPress 6.2 has something for you. <a href=\"https://wordpress.org/news/2023/03/dolphy/\"><strong>Check out the full announcement post</strong></a> for an overview of what&#8217;s new and the <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">Field Guide</a> for detailed developer notes.</p>\n\n\n\n<p>WordPress 6.2 is one of the last major releases planned for Phase 2 of the <a href=\"https://wordpress.org/about/roadmap/\">project’s development roadmap</a> and was made possible thanks to more than 600 contributors.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://make.wordpress.org/test/2023/02/07/help-test-wordpress-6-2/\"></a><a href=\"https://wordpress.org/download/\">Download WordPress 6.2 “Dolphy.”</a></p>\n</blockquote>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">WP20 swag is here</h2>\n\n\n\n<p>Show your WordPress excitement with <strong>limited edition 20th anniversary merchandise</strong>—now available at the official <a href=\"https://mercantile.wordpress.org/product-category/wp20/\"><strong>WordPress Mercantile store</strong></a>. If you prefer to create your own swag, you can use these <a href=\"https://wp20.wordpress.net/download-the-wp20-commemorative-logos/\">WP20 downloadable assets</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/04/digital-banner-1.png?resize=1024%2C576&#038;ssl=1\" alt=\"Blue background with confetti and WordPress 20th anniversary commemorative logo.\" class=\"wp-image-14785\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/04/digital-banner-1.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/04/digital-banner-1.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/04/digital-banner-1.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/04/digital-banner-1.png?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2023/04/digital-banner-1.png?resize=2048%2C1152&amp;ssl=1 2048w, https://i0.wp.com/wordpress.org/news/files/2023/04/digital-banner-1.png?w=3000&amp;ssl=1 3000w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>The 20th anniversary website <a href=\"https://wp20.wordpress.net/wp20-celebrations/\" data-type=\"URL\" data-id=\"https://wp20.wordpress.net/wp20-celebrations/\">lists celebrations</a> as organizers announce and schedule them. Check back regularly to see if there’s an event in your area to join or <a href=\"https://wordpress.org/news/2023/03/lets-party-organize-your-wp20-celebration/\">help organize one</a> to celebrate this milestone with your local community.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://wp20.wordpress.net/wapuu-coloring-giveaway-style-your-own-party-wapuu/\">Enter the Wapuu Coloring Giveaway</a> by April 17, 2023, for a chance to win some commemorative WP20 swag!</p>\n</blockquote>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">New in the Gutenberg plugin</h2>\n\n\n\n<p>Two new versions of the Gutenberg plugin have shipped in the last month:</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/03/13/whats-new-in-gutenberg-15-3-13-march/\"><strong>Gutenberg 15.3</strong></a><strong> </strong>was released on March 13, 2023. This version polishes the Site Editor experience, includes a new “Time to Read” block for displaying estimated read time to posts, and enhances the Duotone design tool.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/22/whats-new-in-gutenberg-15-4-22-march/\"><strong>Gutenberg 15.4</strong></a> is available for download as of March 22, 2023, and focuses primarily on bug fixes and testing improvements. Other additions include color and layout support for the Cover block, improved descriptions to help you understand the purpose of each template in the Site Editor, and the ability to turn paragraph blocks into columns.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://make.wordpress.org/core/2023/02/01/core-editor-improvement-strengthening-style-options/\"></a>Follow the “<a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s new in Gutenberg</a>” posts to stay on top of the latest enhancements.</p>\n</blockquote>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Team updates: Phase 3 planning, WordPress Developer Blog launch, and more</h2>\n\n\n\n<ul>\n<li>Gutenberg Lead Architect Matías Ventura <a href=\"https://make.wordpress.org/core/2023/03/24/phase-3-collaboration/\">outlined the focus areas</a> for Phase 3 of the WordPress development roadmap, known as <strong>Collaboration</strong> or <strong>Collaborative Editing</strong>.</li>\n\n\n\n<li>Last month, the <a href=\"https://wordpress.org/news/2023/03/introducing-the-wordpress-developer-blog/\">WordPress Developer Blog</a> officially launched (removing the &#8220;beta&#8221; label). <a href=\"https://developer.wordpress.org/news/#subscribe\">Subscribe</a> to keep up with the latest features, tutorials, and learning resources in the WordPress development space.</li>\n\n\n\n<li>The Documentation Team seeks volunteers to help with <a href=\"https://make.wordpress.org/docs/2023/03/15/call-for-volunteers-to-help-with-6-2-end-user-documentation/\">WordPress 6.2 end user documentation</a>.</li>\n\n\n\n<li>Are you looking to broaden your knowledge and improve your WordPress skills? See <a href=\"https://make.wordpress.org/updates/2023/04/01/whats-new-on-learn-wordpress-in-march-2023/\">what’s new on Learn WordPress in March 2023</a>, including the latest course on <a href=\"https://learn.wordpress.org/course/converting-a-shortcode-to-a-block/\">Converting a Shortcode to a Block</a>.</li>\n\n\n\n<li>A new <a href=\"https://make.wordpress.org/themes/2023/03/03/hallway-hangout-community-themes-initiative/\">Community Themes initiative</a> aims to bring together a group of contributors to collaborate and build block themes.</li>\n\n\n\n<li>The Training Team is looking for assistance in creating content to complete <a href=\"https://make.wordpress.org/training/2023/03/29/introduction-to-wordpress-development-syllabus/\">this WordPress Development syllabus</a>.</li>\n\n\n\n<li>The newly formed Contributor Working Group <a href=\"https://make.wordpress.org/community/2023/03/23/recap-of-contributor-working-group-inaugural-mentorship-chat-on-march-20-2023/\">hosted an inaugural chat</a> to kick off work on the <a href=\"https://make.wordpress.org/project/2023/02/06/proposal-creating-a-wordpress-contributor-mentorship-program/\">WordPress Mentorship Program</a>.</li>\n\n\n\n<li>The Polyglots Team is <a href=\"https://make.wordpress.org/polyglots/2023/03/29/adding-chatgpt-and-deepl-in-the-translation-memory/\">testing AI systems</a> to help with translation work.</li>\n\n\n\n<li>The WordPress.org redesign project has a new dedicated Making WordPress Slack channel to coordinate work: <a href=\"https://wordpress.slack.com/archives/C04U953K77A\">#website-redesign</a>.</li>\n\n\n\n<li>The March 2023 editions of the <a href=\"https://make.wordpress.org/polyglots/2023/03/15/polyglots-monthly-newsletter-march-2023/\">Polyglots monthly newsletter</a> and the <a href=\"https://make.wordpress.org/community/2023/03/21/meetup-organizer-newsletter-march-2023/\">Meetup Organizer newsletter</a> are available for reading.</li>\n\n\n\n<li>The Mobile Team announced a <a href=\"https://make.wordpress.org/mobile/2023/03/28/new-mobile-support-forum/\">new support forum</a> for the WordPress mobile app.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Tune in to <a href=\"https://wordpress.org/news/2023/03/episode-52-phase-three-with-hector-prieto/\">Episode 52 of WP Briefing</a> to learn more about the visioning behind Phase 3, Collaboration.</p>\n</blockquote>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Feedback &amp; testing requests</h2>\n\n\n\n<ul>\n<li>A new Full Site Editing (FSE) Program exploration looks into the Site Editor as a design tool in light of the recent WordPress 6.2 release. Participants are asked to create a block theme without coding using the current editor tools. <a href=\"https://make.wordpress.org/test/2023/03/29/fse-program-exploration-build-a-block-theme/\">Share your experience</a> by April 26, 2023.</li>\n\n\n\n<li>A group of Core contributors is working on a new <a href=\"https://make.wordpress.org/core/2023/03/30/proposal-the-interactivity-api-a-better-developer-experience-in-building-interactive-blocks/\">Interactivity API proposal</a> to provide a better developer experience for building interactive blocks.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/03/25/mobile-team-update-march-25th/\">Version 22.0</a> of the WordPress mobile app for iOS and Android is ready for testing.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Members of the Core Team are looking for user experience (UX) feedback on the <a href=\"https://make.wordpress.org/core/2023/03/28/call-for-testing-plugin-dependencies-ux/\">Plugin Dependencies feature plugin</a>.</p>\n</blockquote>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress events updates</h2>\n\n\n\n<ul>\n<li>WordCamp Asia 2024 is <a href=\"https://asia.wordcamp.org/2024/\">calling for organizers</a>. Apply by April 15, 2023.</li>\n\n\n\n<li>Registration for the <a href=\"https://europe.wordcamp.org/2023/contributor-day-registration-is-now-open/\">WordCamp Europe 2023 Contributor Day</a> is now open.</li>\n\n\n\n<li>Want to create diverse and inclusive WordPress events? Mark your calendars for the upcoming <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/diversity-speaker-training-workshop/#upcoming-wpdiversity-workshops\">#WPDiversity workshops</a>.</li>\n\n\n\n<li>Four WordCamps are taking place this month:\n<ul>\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ee-1f1f9.png\" alt=\"🇮🇹\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://torino.wordcamp.org/2023/\">WordCamp Torino</a>, Italy, on April 14-15, 2023</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e6-1f1f9.png\" alt=\"🇦🇹\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://vienna.wordcamp.org/2023/\">Wordcamp Vienna</a>, Austria, on April 15-16, 2023</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1eb-1f1f7.png\" alt=\"🇫🇷\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://paris.wordcamp.org/2023/\">WordCamp Paris</a>, France, on April 21, 2023</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e7-1f1ec.png\" alt=\"🇧🇬\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <a href=\"https://sofia.wordcamp.org/2023/\">WordCamp Sofia</a>, Bulgaria, on April 22-23, 2023</li>\n</ul>\n</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Join WordPress Executive Director Josepha Haden Chomphosy as she discusses <a href=\"https://wordpress.org/news/2023/03/episode-51-is-routine-a-rut/\">the benefits of routine and what role it plays in the WordPress project</a>.</p>\n</blockquote>\n\n\n\n<div style=\"height:3px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator has-text-color has-light-grey-color has-alpha-channel-opacity has-light-grey-background-color has-background\" />\n\n\n\n<p><strong><em><strong><em><strong><em>Have a story we should include in the next issue of The Month in WordPress? <strong><em>Fill out </em></strong><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><strong><em>this quick form</em></strong></a><strong><em> to let us know.</em></strong></em></strong></em></strong></em></strong></p>\n\n\n\n<p><em><em>The following folks contributed to this Month in WordPress: <a href=\'https://profiles.wordpress.org/bsanevans/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bsanevans</a>, <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a>, <a href=\'https://profiles.wordpress.org/eidolonnight/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>eidolonnight</a>, <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a>, <a href=\'https://profiles.wordpress.org/sereedmedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sereedmedia</a>.</em></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"14780\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 6.2 “Dolphy”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpress.org/news/2023/03/dolphy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Mar 2023 18:57:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=14659\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:202:\"WordPress 6.2 \"Dolphy\" is here! Named for Eric Allen Dolphy Jr. the celebrated jazz woodwind player and ensemblist. Over 600 contributors made this release possible. Download WordPress 6.2 Dolphy today.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:63164:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/inline-image-x2-1.png?resize=1024%2C683&#038;ssl=1\" alt=\"WordPress 6.2 &quot;Dolphy&quot;\" class=\"wp-image-14732\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/03/inline-image-x2-1.png?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2023/03/inline-image-x2-1.png?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/03/inline-image-x2-1.png?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2023/03/inline-image-x2-1.png?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2023/03/inline-image-x2-1.png?resize=2048%2C1365&amp;ssl=1 2048w, https://i0.wp.com/wordpress.org/news/files/2023/03/inline-image-x2-1.png?w=3000&amp;ssl=1 3000w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Say hello to WordPress 6.2 “Dolphy,&#8221; named for the woodwind jazz wiz, the multi-instrumentalist—<a href=\"https://en.wikipedia.org/wiki/Eric_Dolphy\">Eric Allan Dolphy Jr</a>. Dolphy is acclaimed for having brought the bass clarinet to prominence in the jazz scene, creating a place for the flute and extending the lexicon of the alto saxophone. In a career that spanned continents, his artistry was at the forefront of pushing improvisational boundaries, ensemble work, and partnerships with well-respected artists like Charles Mingus and John Coltrane.</p>\n\n\n\n<p>This latest version of WordPress reimagines your site editing experience, introduces more ways to style your site, and offers a new distraction-free way to write. Discover improvements that give you more control and freedom to express your creative vision. There’s something for everyone, whether you’re a content creator, developer, site builder, or designer. Let the <a href=\"https://open.spotify.com/artist/6rxxu32JCGDpKKMPHxnSJp?si=UEYO5JU5TXyEeINuuhN6aQ\">music of Eric Dolphy</a> delight you as you take in all that 6.2 has to offer.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/wordpress-6.2.zip\">Download WordPress 6.2 today</a></div>\n</div>\n\n\n\n<p>WordPress 6.2 is the first major release of 2023, covering over 900 enhancements and fixes. It’s also a transition point in the WordPress project’s <a href=\"https://wordpress.org/about/roadmap/\">development roadmap</a>, shifting focus from customization to <a href=\"https://make.wordpress.org/core/2023/03/24/phase-3-collaboration/\">early exploration of workflows and collaboration</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s inside</h2>\n\n\n\n<h4 class=\"wp-block-heading\">Meet&nbsp;the reimagined Site Editor</h4>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><img decoding=\"async\" loading=\"lazy\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Site-Editor.png?resize=536%2C536&#038;ssl=1\" alt=\"Image inlay of the reimagined Site Editor. WordPress 6.2 Dolphy\" class=\"wp-image-14661\" width=\"536\" height=\"536\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Site-Editor.png?w=872&amp;ssl=1 872w, https://i0.wp.com/wordpress.org/news/files/2023/03/Site-Editor.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/03/Site-Editor.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2023/03/Site-Editor.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"(max-width: 536px) 100vw, 536px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Ready for you to dive in and explore: 6.2 is your invitation to discover what the next generation of WordPress—and block themes—can do.&nbsp;</p>\n\n\n\n<p>Now out of beta, the Site Editor has an updated interface, giving you a new way to interact with your entire site. Explore full previews of your templates and template parts, then jump in and get to editing your site from wherever you choose.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Manage menus in more ways with the Navigation block</h4>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><img decoding=\"async\" loading=\"lazy\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Navigation.png?resize=532%2C532&#038;ssl=1\" alt=\"Image inlay of menu management from the Navigation block\" class=\"wp-image-14662\" width=\"532\" height=\"532\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Navigation.png?w=872&amp;ssl=1 872w, https://i0.wp.com/wordpress.org/news/files/2023/03/Navigation.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/03/Navigation.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2023/03/Navigation.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"(max-width: 532px) 100vw, 532px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Add, remove, and reorder menu items faster—with a new sidebar experience that makes editing your site’s navigation easier.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Discover a smoother experience for the Block Inserter</h4>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><img decoding=\"async\" loading=\"lazy\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Patterns-Inserter.png?resize=536%2C536&#038;ssl=1\" alt=\"Image inlay of the Block Inserter\" class=\"wp-image-14663\" width=\"536\" height=\"536\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Patterns-Inserter.png?w=872&amp;ssl=1 872w, https://i0.wp.com/wordpress.org/news/files/2023/03/Patterns-Inserter.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/03/Patterns-Inserter.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2023/03/Patterns-Inserter.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"(max-width: 536px) 100vw, 536px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>A refreshed design gives you easier access to the content you need. Use the Media tab to quickly drag and drop content from your existing Media Library. Find patterns faster with a split view that lets you navigate categories and see previews all at once.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Find the controls you want when you need them</h4>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><img decoding=\"async\" loading=\"lazy\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Settings-and-Styles-Tabs.png?resize=540%2C540&#038;ssl=1\" alt=\"Tab between settings and styles in the block settings sidebar\" class=\"wp-image-14664\" width=\"540\" height=\"540\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Settings-and-Styles-Tabs.png?w=872&amp;ssl=1 872w, https://i0.wp.com/wordpress.org/news/files/2023/03/Settings-and-Styles-Tabs.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/03/Settings-and-Styles-Tabs.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2023/03/Settings-and-Styles-Tabs.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"(max-width: 540px) 100vw, 540px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Your block settings sidebar is better organized with tabs for Settings and Styles. So the tools you need are easy to identify and access.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Build faster with headers and footers for block themes</h4>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><img decoding=\"async\" loading=\"lazy\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Block-themes.png?resize=534%2C534&#038;ssl=1\" alt=\"\" class=\"wp-image-14671\" width=\"534\" height=\"534\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Block-themes.png?w=872&amp;ssl=1 872w, https://i0.wp.com/wordpress.org/news/files/2023/03/Block-themes.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/03/Block-themes.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2023/03/Block-themes.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"(max-width: 534px) 100vw, 534px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Discover a new collection of header and footer patterns. Use them with any block theme as a quick, high-quality starting point for your site’s templates.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Explore Openverse media right from the Editor</h4>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><img decoding=\"async\" loading=\"lazy\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Openverse.png?resize=544%2C544&#038;ssl=1\" alt=\"\" class=\"wp-image-14670\" width=\"544\" height=\"544\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Openverse.png?w=872&amp;ssl=1 872w, https://i0.wp.com/wordpress.org/news/files/2023/03/Openverse.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/03/Openverse.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2023/03/Openverse.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"(max-width: 544px) 100vw, 544px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Openverse’s library catalogs over 700 million+ free, openly licensed stock images and audio—and now it’s directly integrated into the WordPress experience through the Inserter.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Focus on writing with Distraction Free mode</h4>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><img decoding=\"async\" loading=\"lazy\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Distraction-Free.png?resize=542%2C542&#038;ssl=1\" alt=\"\" class=\"wp-image-14665\" width=\"542\" height=\"542\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Distraction-Free.png?w=872&amp;ssl=1 872w, https://i0.wp.com/wordpress.org/news/files/2023/03/Distraction-Free.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/03/Distraction-Free.png?resize=150%2C150&amp;ssl=1 150w, https://i0.wp.com/wordpress.org/news/files/2023/03/Distraction-Free.png?resize=768%2C768&amp;ssl=1 768w\" sizes=\"(max-width: 542px) 100vw, 542px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>For those times you want to be alone with your ideas. You can now hide all your panels and controls, leaving you free to bring your content to life.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Meet the new Style Book</h4>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"560\" height=\"560\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Style-Book.png?resize=560%2C560&#038;ssl=1\" alt=\"\" class=\"wp-image-14667\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Style-Book.png?w=560&amp;ssl=1 560w, https://i0.wp.com/wordpress.org/news/files/2023/03/Style-Book.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/03/Style-Book.png?resize=150%2C150&amp;ssl=1 150w\" sizes=\"(max-width: 560px) 100vw, 560px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Get a complete overview of how every block in your site’s library looks. All in one place, all at a glance, directly in the Site Editor.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Copy and paste styles</h4>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"560\" height=\"560\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Copy-_-Paste.png?resize=560%2C560&#038;ssl=1\" alt=\"\" class=\"wp-image-14666\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Copy-_-Paste.png?w=560&amp;ssl=1 560w, https://i0.wp.com/wordpress.org/news/files/2023/03/Copy-_-Paste.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/03/Copy-_-Paste.png?resize=150%2C150&amp;ssl=1 150w\" sizes=\"(max-width: 560px) 100vw, 560px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Perfect the design on one type of block, then copy and paste those styles to other blocks to get just the look you want.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Custom CSS</h4>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><img decoding=\"async\" loading=\"lazy\" width=\"560\" height=\"560\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Custom-CSS.png?resize=560%2C560&#038;ssl=1\" alt=\"\" class=\"wp-image-14669\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Custom-CSS.png?w=560&amp;ssl=1 560w, https://i0.wp.com/wordpress.org/news/files/2023/03/Custom-CSS.png?resize=300%2C300&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2023/03/Custom-CSS.png?resize=150%2C150&amp;ssl=1 150w\" sizes=\"(max-width: 560px) 100vw, 560px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Power up your site any way you wish with design tools and custom CSS for another level of control over your site’s look and feel for maximum creativity and artistry in your designs.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Other highlights in 6.2</h3>\n\n\n\n<ul>\n<li><strong>Sticky positioning</strong>: Choose to keep top-level group blocks fixed to the top of a page as visitors scroll.</li>\n\n\n\n<li><strong>Importing widgets</strong>: Options to import your favorite widgets from Classic themes to Block themes.</li>\n\n\n\n<li><strong>Local fonts in themes</strong>: Default WordPress themes offer better privacy with Google Fonts now included.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Performance highlights</h3>\n\n\n\n<p>“Dolphy” includes several impressive performance improvements. You’ll note overall faster load times for block themes of 14 to 18%, and for classic themes, speed increases of 2 to 5%. Server-side performance is also significantly boosted, with an increase of 17 to 23% for block themes and 3 to 5% for classic themes, 3 to 5%. The performance team is dedicated to these kinds of improvements. You can learn more about their work by following the Making WordPress blog using the <a href=\"https://make.wordpress.org/core/tag/performance/\">#performance hashtag</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"></blockquote>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.2</h2>\n\n\n\n<p>Explore <a href=\"https://learn.wordpress.org/workshops/\">Learn WordPress</a> for quick how-to videos, courses, and other resources for the latest features in WordPress. Or join a free <a href=\"https://learn.wordpress.org/social-learning/\">live interactive online workshop</a>.</p>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">WordPress 6.2 Field Guide</a> for detailed developer notes to help you build with WordPress and get the most out of the latest release. Read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-2/\">6.2 release notes</a> for additional technical details about this release, including installation information, updates, fixes, file changes, and more.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.2 release squad</h2>\n\n\n\n<p>6.2 is made possible by the many folks who have enthusiastically helped keep the release on track and moving forward:</p>\n\n\n\n<ul>\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordinators: <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a></li>\n\n\n\n<li>Core Tech Co-Leads: <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Editor Tech Co-Leads: <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a></li>\n\n\n\n<li>Core Triage Co-Leads: <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Editor Triage Co-Leads: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a></li>\n\n\n\n<li>Design Lead: <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Documentation Co-Leads: <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseet</a>, <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a>, <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a></li>\n\n\n\n<li>Marketing &amp; Communications Co-Leads: <a href=\"https://profiles.wordpress.org/jpantani/\">Jonathan Pantani</a>, <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Test Co-Leads: <a href=\"https://profiles.wordpress.org/robinwpdeveloper/\">Robin</a>, <a href=\"https://profiles.wordpress.org/adeltahri/\">Adel Tahri</a></li>\n\n\n\n<li>Performance Lead: <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>WordPress 6.2 couldn’t be here without the countless effort and passion of more than 600 contributors in at least 50 countries. A special thank you to the 178 new contributors who joined a release for the first time. Their collaboration helped deliver hundreds of enhancements and fixes, ensuring a stable release for all—a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull\"><a href=\"https://profiles.wordpress.org/10upsimon/\">10upsimon</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">254volkan</a> · <a href=\"https://profiles.wordpress.org/mercime/\">@mercime</a> · <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a> · <a href=\"https://profiles.wordpress.org/aeg0125/\">Aaron Graham</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abidhasan112/\">Abid Hasan</a> · <a href=\"https://profiles.wordpress.org/abitofmind/\">abitofmind</a> · <a href=\"https://profiles.wordpress.org/abtop/\">ABTOP</a> · <a href=\"https://profiles.wordpress.org/ace100/\">ace100</a> · <a href=\"https://profiles.wordpress.org/bosconiandynamics/\">Adam Bosco</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/admwgn/\">Adam Wiltgen</a> · <a href=\"https://profiles.wordpress.org/adeltahri/\">Adel Tahri</a> · <a href=\"https://profiles.wordpress.org/adhun/\">Adhun Anand</a> · <a href=\"https://profiles.wordpress.org/adityaarora010196/\">adityaarora010196</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/afshanadiya/\">Afshana Diya</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/ajmaurya/\">Ajay Maurya</a> · <a href=\"https://profiles.wordpress.org/ajayver/\">ajayver</a> · <a href=\"https://profiles.wordpress.org/seakashdiu/\">Akash Mia</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanjacobmathew/\">Alan Jacob Mathew</a> · <a href=\"https://profiles.wordpress.org/albarin/\">albarin</a> · <a href=\"https://profiles.wordpress.org/alberuni-azad/\">Alberuni Azad.</a> · <a href=\"https://profiles.wordpress.org/alecgeatches/\">alecgeatches</a> · <a href=\"https://profiles.wordpress.org/aleksganev/\">Aleks Ganev</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alvastar/\">alvastar</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amin7/\">amin</a> · <a href=\"https://profiles.wordpress.org/amirrezatm/\">amirrezatm</a> · <a href=\"https://profiles.wordpress.org/amitbarai013/\">Amit Barai Alit</a> · <a href=\"https://profiles.wordpress.org/paulamit/\">Amit Paul</a> · <a href=\"https://profiles.wordpress.org/anantajitjg/\">Anantajit JG</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andreaboe/\">andreaboe</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/apmatthe/\">Andrew Matthews</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey \"Rarst\" Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antonyagrios/\">Antony Agrios</a> · <a href=\"https://profiles.wordpress.org/aparnajl/\">Aparna Adhun</a> · <a href=\"https://profiles.wordpress.org/arrasel403/\">AR Rasel</a> · <a href=\"https://profiles.wordpress.org/arafatjamil01/\">Arafat Jamil</a> · <a href=\"https://profiles.wordpress.org/aravindajith/\">Aravind Ajith</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arnolp/\">arnolp</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/artz91/\">ArtZ91</a> · <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a> · <a href=\"https://profiles.wordpress.org/mrasharirfan/\">Ashar Irfan</a> · <a href=\"https://profiles.wordpress.org/ashrafulsarkar/\">Ashraful Sarkar Naiem</a> · <a href=\"https://profiles.wordpress.org/nmutua/\">Autumn</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/azurseisme/\">azurseisme</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bart/\">Bart</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/benish74/\">benish74</a> · <a href=\"https://profiles.wordpress.org/benjgrolleau/\">Benjamin Grolleau</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernie Reiter</a> · <a href=\"https://profiles.wordpress.org/mxbclang/\">Bethany Chobanian Lang</a> · <a href=\"https://profiles.wordpress.org/bgin/\">bgin</a> · <a href=\"https://profiles.wordpress.org/albatross10/\">Bhavik Kalpesh</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bjorn2404/\">Bjorn Holine</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/bonjour52/\">bonjour52</a> · <a href=\"https://profiles.wordpress.org/bookwyrm/\">bookwyrm</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradyvercher/\">Brady Vercher</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/bgoewert/\">Brennan Goewert</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">Bronson Quick</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke Kaminski</a> · <a href=\"https://profiles.wordpress.org/brookedot/\">Brooke.</a> · <a href=\"https://profiles.wordpress.org/buutqn/\">buutqn</a> · <a href=\"https://profiles.wordpress.org/cameronjonesweb/\">Cameron Jones</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos Garcia Prim</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/critterverse/\">Channing Ritter</a> · <a href=\"https://profiles.wordpress.org/mcaskill/\">Chauncey McAskill</a> · <a href=\"https://profiles.wordpress.org/chintan1896/\">Chintan hingrajiya</a> · <a href=\"https://profiles.wordpress.org/chiragrathod103/\">Chirag Rathod</a> · <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloe Bringmann</a> · <a href=\"https://profiles.wordpress.org/chocofc1/\">chocofc1</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisbaltazar/\">chrisbaltazar</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/ckanderson22/\">ckanderson22</a> · <a href=\"https://profiles.wordpress.org/claytoncollie/\">Clayton Collie</a> · <a href=\"https://profiles.wordpress.org/cnspecialcolor/\">cnspecialcolor</a> · <a href=\"https://profiles.wordpress.org/codesdnc/\">codesdnc</a> · <a href=\"https://profiles.wordpress.org/codingchicken/\">Coding Chicken</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/conner_bw/\">conner_bw</a> · <a href=\"https://profiles.wordpress.org/copons/\">Copons</a> · <a href=\"https://profiles.wordpress.org/corentingautier/\">corentingautier</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">Cory Birdsong</a> · <a href=\"https://profiles.wordpress.org/craigfrancis/\">Craig Francis</a> · <a href=\"https://profiles.wordpress.org/craiglpeters/\">craiglpeters</a> · <a href=\"https://profiles.wordpress.org/geisthanen/\">Creative Andrew</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/daisyo/\">Daisy Olsen</a> · <a href=\"https://profiles.wordpress.org/dalirajab/\">dali-rajab</a> · <a href=\"https://profiles.wordpress.org/dalleyne/\">Damien Alleyne</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/wirecat/\">Daniel Johnson</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/datagutten/\">datagutten</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dgwyer/\">David Gwyer</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/davefx/\">David Mar&#237;n Carre&#241;o</a> · <a href=\"https://profiles.wordpress.org/dperonne/\">David P&#233;ronne</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/davidvongries/\">David Vongries</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dennisatyoast/\">Dennis Claassen</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">derekblank</a> · <a href=\"https://profiles.wordpress.org/devanshijoshi/\">Devanshi Joshi</a> · <a href=\"https://profiles.wordpress.org/dhusakovic/\">dhusakovic</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/doctorlai/\">doctorlai</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donncha/\">Donncha</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/d-signed/\">DSIGNED</a> · <a href=\"https://profiles.wordpress.org/dustinrue/\">dustinrue</a> · <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Eidolon Night</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/emanuelx/\">emanuelx</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/enej/\">Enej Bajgorić</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/edanzer/\">Erick Danzer</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik Betshammar</a> · <a href=\"https://profiles.wordpress.org/esratpopy/\">Esrat Sultana Popy</a> · <a href=\"https://profiles.wordpress.org/manuilov/\">Eugene M</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian K&#228;gy</a> · <a href=\"https://profiles.wordpress.org/fosuahmed/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fasuto/\">fasuto</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/felipelavinz/\">Felipe Lav&#237;n</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseeth</a> · <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a> · <a href=\"https://profiles.wordpress.org/fpodhorsky/\">fpodhorsky</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/bueltge/\">Frank Bueltge</a> · <a href=\"https://profiles.wordpress.org/franz00/\">franzaurus</a> · <a href=\"https://profiles.wordpress.org/fuadragib/\">Fuad Ragib</a> · <a href=\"https://profiles.wordpress.org/galbaras/\">Gal Baras</a> · <a href=\"https://profiles.wordpress.org/gamecreature/\">gamecreature</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/revgeorge/\">George Hotelling</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/gisgeo/\">gisgeo</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Zi&#243;łkowski</a> · <a href=\"https://profiles.wordpress.org/grl570810/\">grl570810</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/hvar/\">H-var</a> · <a href=\"https://profiles.wordpress.org/hakre/\">hakre</a> · <a href=\"https://profiles.wordpress.org/hanshenrik/\">hanshenrik</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/haritpanchal/\">Harit Panchal</a> · <a href=\"https://profiles.wordpress.org/hasanmisbah/\">Hasan Misbah</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/ehtmlu/\">Helmut Wandl</a> · <a href=\"https://profiles.wordpress.org/luehrsen/\">Hendrik Luehrsen</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/hiren1094/\">hiren sanja</a> · <a href=\"https://profiles.wordpress.org/patelhitesh/\">Hitesh Patel</a> · <a href=\"https://profiles.wordpress.org/hughiemolloy/\">hughie.molloy</a> · <a href=\"https://profiles.wordpress.org/hugodevos/\">hugodevos</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">hztyfoon</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/polevaultweb/\">Iain Poulson</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/iazel/\">Iazel</a> · <a href=\"https://profiles.wordpress.org/ignatggeorgiev/\">Ignat Georgiev</a> · <a href=\"https://profiles.wordpress.org/imanish003/\">imanish003</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">ingeniumed</a> · <a href=\"https://profiles.wordpress.org/innovext/\">Innovext</a> · <a href=\"https://profiles.wordpress.org/inwerpsel/\">inwerpsel</a> · <a href=\"https://profiles.wordpress.org/iqbalrony/\">iqbalrony</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/ivanjeronimo/\">ivanjeronimo</a> · <a href=\"https://profiles.wordpress.org/jhoffmann/\">j.hoffmann</a> · <a href=\"https://profiles.wordpress.org/jackreichert/\">Jack Reichert</a> · <a href=\"https://profiles.wordpress.org/jaedm97/\">Jaed Mosharraf</a> · <a href=\"https://profiles.wordpress.org/jakariaistauk/\">Jakaria Istauk</a> · <a href=\"https://profiles.wordpress.org/outrankjames/\">James</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james-roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a> · <a href=\"https://profiles.wordpress.org/janusdev/\">janusdev</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/carazo/\">Javier Carazo</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jchambo/\">jchambo</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jeanphilippegreen/\">Jean-Philippe Green</a> · <a href=\"https://profiles.wordpress.org/jeawhanlee/\">jeawhanlee</a> · <a href=\"https://profiles.wordpress.org/jeffmatson/\">Jeff Matson</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jmdodd/\">Jennifer M. Dodd</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/lobeless14/\">Jeremy Lind</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jhned/\">jhned</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">jigar bhanushali</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelmadigan/\">joelmadigan</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnwatkins0/\">John Watkins</a> · <a href=\"https://profiles.wordpress.org/jokerrs/\">Jokerrs</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/jpantani/\">Jonathan Pantani</a> · <a href=\"https://profiles.wordpress.org/jongycastillo/\">Jong</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/dunhakdis/\">Joseph G.</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jsh4/\">jsh4</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/welenofsky/\">Justin Welenofsky</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">justlevine</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kacper3355/\">kacper3355</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/kaneva/\">kaneva</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn P.</a> · <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/konyoldeath/\">konyoldeath</a> · <a href=\"https://profiles.wordpress.org/kowsar89/\">Kowsar Hossain</a> · <a href=\"https://profiles.wordpress.org/krunal265/\">Krunal Bhimajiyani</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/lanacodes/\">Lana Codes</a> · <a href=\"https://profiles.wordpress.org/larsmqller/\">larsmqller</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">Lena Stergatou</a> · <a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leo Milo</a> · <a href=\"https://profiles.wordpress.org/lifeboat/\">lifeboat</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/webaxones/\">Lo&#239;c Antignac</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/dreadlox/\">Lox</a> · <a href=\"https://profiles.wordpress.org/lozula/\">lozula</a> · <a href=\"https://profiles.wordpress.org/lucius0101/\">lucius0101</a> · <a href=\"https://profiles.wordpress.org/lucymtc/\">Lucy Tomas</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/pyrobd/\">Lukman Nakib</a> · <a href=\"https://profiles.wordpress.org/pagelab/\">M&#225;rcio Duarte</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mahbubshovan/\">Mahbub Shovan</a> · <a href=\"https://profiles.wordpress.org/mahekkalola/\">Mahek Kalola</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manojkpatil/\">Manoj Patil</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marekdedic/\">Marek Dědič</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/marissamakes/\">Marissa Matthews</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoserb/\">Marko Ivanovic</a> · <a href=\"https://profiles.wordpress.org/marksabbath/\">marksabbath</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/mkox/\">Markus Kosmal</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/matclayton/\">matclayton</a> · <a href=\"https://profiles.wordpress.org/wetah/\">Mateus Machado Luna</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu Paapst</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/mattkeys/\">Matt Keys</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matthiasreinholz/\">Matthias Reinholz</a> · <a href=\"https://profiles.wordpress.org/h4l9k/\">Mauricio</a> · <a href=\"https://profiles.wordpress.org/wppunk/\">Max</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maximej/\">Maxime J.</a> · <a href=\"https://profiles.wordpress.org/jamilbd07/\">MD Jamil Uddin</a> · <a href=\"https://profiles.wordpress.org/kawserz/\">Md Kawser Ahmed Khan Jami</a> · <a href=\"https://profiles.wordpress.org/rakibwordpress/\">Md Rakib Hossain</a> · <a href=\"https://profiles.wordpress.org/abirhasandipu/\">Md. Abir Hasan Dipu</a> · <a href=\"https://profiles.wordpress.org/reduanmasud/\">Md. Reduan Masud</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/mensmaximus/\">mensmaximus</a> · <a href=\"https://profiles.wordpress.org/meyegui/\">meyerdev.ch</a> · <a href=\"https://profiles.wordpress.org/mgol/\">mgol</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/michael-kelly/\">Michael Kelly</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michelmany/\">Michel Many</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mmtr86/\">Miguel Torres</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikestraw/\">Mike Straw</a> · <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/mitchellaustin/\">mitchellaustin</a> · <a href=\"https://profiles.wordpress.org/presents111/\">miya</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtias/\">mtias</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/amustaque97/\">Mustaque Ahmed</a> · <a href=\"https://profiles.wordpress.org/mw108/\">mw108</a> · <a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a> · <a href=\"https://profiles.wordpress.org/namithjawahar/\">Namith Jawahar</a> · <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a> · <a href=\"https://profiles.wordpress.org/nazmulhasan103/\">Nazmul Hasan</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neychok/\">Neycho Kalaydzhiev</a> · <a href=\"https://profiles.wordpress.org/nicholaswilson/\">nicholaswilson</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/nick_thegeek/\">Nick the Geek</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/itsnikhilpatel/\">NikhilPatel</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/dasnitesh780/\">Nitesh Das</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/rnitinb/\">Nitin Rathod</a> · <a href=\"https://profiles.wordpress.org/nitman43/\">nitman43</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nuvopoint/\">nuvoPoint</a> · <a href=\"https://profiles.wordpress.org/oakesjosh/\">oakesjosh</a> · <a href=\"https://profiles.wordpress.org/obayedmamur/\">Obayed Mamur</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/oh_hello/\">oh_hello</a> · <a href=\"https://profiles.wordpress.org/hideokamoto/\">Okamoto Hidetaka</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/olliejones/\">OllieJones</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoney/\">PabloHoney</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbking/\">pbking</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendon&#231;a</a> · <a href=\"https://profiles.wordpress.org/pputzer/\">pepe</a> · <a href=\"https://profiles.wordpress.org/petaryoast/\">Petar Ratković</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walb&#248; Johnsg&#229;rd</a> · <a href=\"https://profiles.wordpress.org/phil-webster/\">Phil Webster</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/iapial/\">Pial</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/knowingart_com/\">PJ Brunet</a> · <a href=\"https://profiles.wordpress.org/pkolenbr/\">pkolenbr</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pravinparmar2404/\">Pravin Parmar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/ptahdunbar/\">Ptah Dunbar</a> · <a href=\"https://profiles.wordpress.org/raduiason/\">raduiason</a> · <a href=\"https://profiles.wordpress.org/initsogar/\">Rafael Agostini</a> · <a href=\"https://profiles.wordpress.org/rafinkhan/\">Rafin</a> · <a href=\"https://profiles.wordpress.org/rajanpanchal2028/\">Rajan Panchal</a> · <a href=\"https://profiles.wordpress.org/rajeshraval786/\">Rajesh Raval</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/razthee007/\">Razthee Md. Yakini</a> · <a href=\"https://profiles.wordpress.org/renatoagds/\">Renato Augusto Gama dos Santos</a> · <a href=\"https://profiles.wordpress.org/rezakhan995/\">Reza Khan</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/riccardodicurti/\">Riccardo Di Curti</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rinkychowdhury9/\">Rinky Chowdhury</a> · <a href=\"https://profiles.wordpress.org/ritteshpatel/\">Ritesh Patel</a> · <a href=\"https://profiles.wordpress.org/rjasdfiii/\">rjasdfiii</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/robinwpdeveloper/\">Robin</a> · <a href=\"https://profiles.wordpress.org/robin-labadie/\">Robin Labadie</a> · <a href=\"https://profiles.wordpress.org/rodage/\">rodage</a> · <a href=\"https://profiles.wordpress.org/rodricus/\">rodricus</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/digical/\">Ross Gile</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/re_enter_rupok/\">Rupok</a> · <a href=\"https://profiles.wordpress.org/rryyaanndd/\">Ryan</a> · <a href=\"https://profiles.wordpress.org/ryankienstra/\">Ryan Kienstra</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">S&#233; Reed</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">S&#233;rgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren Wrede</a> · <a href=\"https://profiles.wordpress.org/andy786/\">Sahil B.</a> · <a href=\"https://profiles.wordpress.org/stalukder03/\">Sajib Talukder</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/samful/\">Sam Fullalove</a> · <a href=\"https://profiles.wordpress.org/sam1el/\">sam1el</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/samruddhikhandale/\">samruddhikhandale</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sanjucta/\">sanjucta</a> · <a href=\"https://profiles.wordpress.org/sanketchodavadiya/\">Sanket Chodavadiya</a> · <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a> · <a href=\"https://profiles.wordpress.org/sapayth/\">sapayth</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/saumil1611/\">Saumil Nerpagar</a> · <a href=\"https://profiles.wordpress.org/ira2910/\">Sazia Faizunnessa Ira</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/countrymusicchicago/\">Scott Winterroth</a> · <a href=\"https://profiles.wordpress.org/hiyascout/\">Scout James</a> · <a href=\"https://profiles.wordpress.org/seanchayes/\">Sean Hayes</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/seriouslysenpai/\">seriouslysenpai</a> · <a href=\"https://profiles.wordpress.org/wandering-aramean/\">Seth Miller</a> · <a href=\"https://profiles.wordpress.org/shahidul95/\">Shahidul Islam</a> · <a href=\"https://profiles.wordpress.org/shamayel007/\">Shamayel</a> · <a href=\"https://profiles.wordpress.org/shamimmiashuhagh/\">Shamim Mia</a> · <a href=\"https://profiles.wordpress.org/smeunus/\">Sharif Mohammad Eunus</a> · <a href=\"https://profiles.wordpress.org/shraboni/\">Shraboni</a> · <a href=\"https://profiles.wordpress.org/shubham1gupta/\">shubham1gupta</a> · <a href=\"https://profiles.wordpress.org/silicium23/\">Silicium</a> · <a href=\"https://profiles.wordpress.org/simongomes02/\">Simon Gomes</a> · <a href=\"https://profiles.wordpress.org/slieschke/\">Simon Lieschke</a> · <a href=\"https://profiles.wordpress.org/siobhan/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/calvinalkan/\">snicco.io</a> · <a href=\"https://profiles.wordpress.org/sruthi90/\">sruthi90</a> · <a href=\"https://profiles.wordpress.org/steelwagstaff/\">SteelWagstaff</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stentibbing/\">stentibbing</a> · <a href=\"https://profiles.wordpress.org/pypwalters/\">Stephanie Walters</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephym/\">Stephy Miehle</a> · <a href=\"https://profiles.wordpress.org/stephymiehle/\">stephymiehle</a> · <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sun/\">sun</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva (a11n)</a> · <a href=\"https://profiles.wordpress.org/codemonksuvro/\">Suvro</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/afrin29/\">Syeda Sanjida Afrin</a> · <a href=\"https://profiles.wordpress.org/syhc/\">syhc</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/syntaxart/\">syntaxart</a> · <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a> · <a href=\"https://profiles.wordpress.org/tahmidulkarim/\">Tahmid ul Karim</a> · <a href=\"https://profiles.wordpress.org/tahminar27/\">Tahmina Rahman</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/tanazmasaba/\">Tanaz Masaba</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanner-m/\">Tanner Moushey</a> · <a href=\"https://profiles.wordpress.org/rahmantasnia/\">Tasnia Rahman Raima</a> · <a href=\"https://profiles.wordpress.org/teebee/\">teebee</a> · <a href=\"https://profiles.wordpress.org/tekapo/\">tekapo</a> · <a href=\"https://profiles.wordpress.org/thedaysse/\">thedaysse</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/theode/\">theode</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a> · <a href=\"https://profiles.wordpress.org/thomask/\">thomask</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/dziudek/\">Tomasz Dziuda</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul I Chowdhury</a> · <a href=\"https://profiles.wordpress.org/travisaxton/\">travisaxton</a> · <a href=\"https://profiles.wordpress.org/triumvirate/\">triumvirate</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Sz&#233;pe</a> · <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a> · <a href=\"https://profiles.wordpress.org/elifvish/\">Vishal Kumar</a> · <a href=\"https://profiles.wordpress.org/vladytimy/\">Vlad T</a> · <a href=\"https://profiles.wordpress.org/vtad/\">vtad</a> · <a href=\"https://profiles.wordpress.org/vykesmac/\">vykesmac</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design &#124; Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/webrocker/\">Webrocker</a> · <a href=\"https://profiles.wordpress.org/websitegenii/\">websitegenii</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/winterpsv/\">winterpsv</a> · <a href=\"https://profiles.wordpress.org/wojsmol/\">wojsmol</a> · <a href=\"https://profiles.wordpress.org/wojtekn/\">Wojtek Naruniec</a> · <a href=\"https://profiles.wordpress.org/wojtekszkutnik/\">Wojtek Szkutnik</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/zebaafiashama/\">Zeba Afia Shama</a> · <a href=\"https://profiles.wordpress.org/zenaulislam/\">Zenaul Islam</a> · <a href=\"https://profiles.wordpress.org/zevilz/\">zevilz</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<p>By release day, <a href=\"https://translate.wordpress.org/stats/\">70 locales had translated 90 percent</a> or more of WordPress 6.2 in their language. Community translators are hard at work ensuring more translations are on their way. Thank you to everyone who helps to make WordPress 6.2 available in 200 languages.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A release haiku for 6.2&nbsp;</h2>\n\n\n\n<p>Six point two, so new<br>Shiny and ready for you<br>Congrats on hard work!</p>\n\n\n\n<p class=\"has-text-align-left has-tiny-font-size\"><em>* Portrait of Eric Allen Dolphy Jr. discovered via <a href=\"https://openverse.org/image/36720968-690c-4287-a2dd-619573cc23a6\">Openverse</a>. Colorization by D. Pountain; Original by F. Wolff</em>.<br>&#8220;<a rel=\"noreferrer noopener\" href=\"https://www.flickr.com/photos/98119031@N00/39509743850\" target=\"_blank\">eric dolphy</a>&#8221; by&nbsp;<a rel=\"noreferrer noopener\" href=\"https://www.flickr.com/photos/98119031@N00\" target=\"_blank\">dick_pountain</a>&nbsp;is licensed under&nbsp;<a rel=\"noreferrer noopener\" href=\"https://creativecommons.org/licenses/by-nc-sa/2.0/?ref=openverse\" target=\"_blank\">CC BY-NC-SA 2.0</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"14659\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WP Briefing: Episode 52: Workflows and Phase Three Visioning with Special Guest Héctor Prieto\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wordpress.org/news/2023/03/episode-52-phase-three-with-hector-prieto/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Mar 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=14697\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:147:\"On this week\'s episode, special guest Héctor Prieto joins Josepha in a discussion about phase three and why it\'s more than collaborative editing. \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2023/03/WP-Briefing-052.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:25748:\"\n<p>On Episode fifty-two of the WordPress Briefing podcast, join WordPress Executive Director Josepha Haden Chomphosy and special guest Héctor Prieto as they discuss phase three and why it&#8217;s more than just collaborative editing!</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production:&nbsp;<a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a><br>Song: Fearless First by Kevin MacLeod </p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li><a href=\"https://riad.blog/2020/06/11/write-as-blocks-in-an-encrypted-collaborative-environment/\">Write as Blocks in an Encrypted Collaborative Environment by Riad Benguella</a> </li>\n\n\n\n<li><a href=\"https://github.com/youknowriad/asblocks\" data-type=\"URL\" data-id=\"https://github.com/youknowriad/asblocks\">Riad Benguella’s collaborative editing GitHub repository</a></li>\n\n\n\n<li><a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella&#8217;s WordPress.org Profile</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/pull/23129\" data-type=\"URL\" data-id=\"https://github.com/WordPress/gutenberg/pull/23129\">Block Collab: New package, a framework for collaborative editing GitHub PR</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/24/phase-3-collaboration/\">Phase 3: Collaboration</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/48457\" data-type=\"URL\" data-id=\"https://github.com/WordPress/gutenberg/issues/48457\">Matías Ventura Quick Search GH Issue</a></li>\n\n\n\n<li><a href=\"https://profiles.wordpress.org/matveb/\">Matías Ventura WordPress.org Profile</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/23/wordpress-6-2-release-day-process/\">WordPress 6.2 Release Day Process</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2023/03/introducing-the-wordpress-developer-blog/\">Introducing the WordPress Developer Blog</a></li>\n\n\n\n<li><a href=\"https://europe.wordcamp.org/2022/contributor-day/\" data-type=\"URL\" data-id=\"https://europe.wordcamp.org/2022/contributor-day/\">WordCamp Europe Contributor Day Registration</a></li>\n\n\n\n<li><a href=\"https://wp20.wordpress.net/wapuu-coloring-giveaway-style-your-own-party-wapuu/\" data-type=\"URL\" data-id=\"https://wp20.wordpress.net/wapuu-coloring-giveaway-style-your-own-party-wapuu/\">WP20 Wapuu Coloring Giveaway</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-14697\"></span>\n\n\n\n<p>[Josepha Haden Chomphosy 00:00:00]&nbsp;</p>\n\n\n\n<p>Hello everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. Here we go.&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:00:40]<br><br>I have with me today Hécto Prieto. You all may know him from the WordPress Slack. He recently was, I believe, a release coordinator, maybe for the last release. Was that for 6.1?</p>\n\n\n\n<p>[Héctor Prieto 00:00:51]<br><br>Yes. It was for 6.1 and also 6.0, in fact.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:00:54]<br><br>All right. Well, welcome to the WordPress Briefing today. How are you doing?</p>\n\n\n\n<p>[Héctor Prieto 00:00:59]&nbsp;</p>\n\n\n\n<p>Well, I&#8217;m excited to be here. I&#8217;m a longtime listener of the podcast since the first episode. So I&#8217;m super excited to be here with you today.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:01:06]<br><br>Yes. Longtime listener. First-time caller. All right, well, we&#8217;re gonna have a topic that just dumps you right in the soup, as they say in the United States. So we are actually here to talk about phase three of Gutenberg. It&#8217;s been a long time coming, and there are a lot of questions that folks have about what&#8217;s going into it and what&#8217;s not going into it.</p>\n\n\n\n<p>And as someone who works really closely with our Gutenberg technical architect, Matías Ventura, I figured you would be exactly the right person to come and talk about your favorite things. From your perspective, what is going to be the biggest enhancement that we start to approach in phase three?</p>\n\n\n\n<p>Like which thing, which API is gonna take the most work, do you think?</p>\n\n\n\n<p>[Héctor Prieto 00:01:53]<br><br>Well, the most work, that&#8217;s a very hard question to answer because we are still we are going to start an exploration phase to determine how far we want to go with each of these APIs. So, in general, all these APIs and these products are standalone projects. And some of them are shorter, and some of them are longer.</p>\n\n\n\n<p>I would say, in general, the real-time collaboration sounds the most technically challenging because of what it represents and all the changes needed to how we interact with WordPress from async to sync, basically. That would be the hardest part. I think there are also already a few prototypes working, but we need to see how that scales, for example.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:02:32]</p>\n\n\n\n<p>Yeah. So speaking of a few prototypes, I know that there are two or three different prototypes specifically for collaborative editing, but do we have people or groups, working groups in the community that have built any other prototypes? Or is it just kind of first passes at collaborative editing that we&#8217;ve seen?</p>\n\n\n\n<p>[Héctor Prieto 00:02:52]<br><br>Well, apart from Riad Benguella’s exploration, there&#8217;s a public repository with that exploration, there are a few plugins trying the same, trying real-time collaboration.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:03:03]<br><br>Yeah, I can think of co-blocks and as blocks, and then I feel like there was a third one.</p>\n\n\n\n<p>[Héctor Prieto 00:03:09]&nbsp;</p>\n\n\n\n<p>Yeah.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:03:09]<br><br>We&#8217;ll find the links to all these</p>\n\n\n\n<p>[Héctor Prieto 00:03:12]</p>\n\n\n\n<p>Yeah. Let&#8217;s add them to the show notes.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:03:14]<br><br>Excellent. So that&#8217;s going to be the biggest one. Is there, of the list of APIs, and this is based on the post that Matías sent out last week. If you all haven&#8217;t seen that, we&#8217;ll put that in the show notes as well. But from the APIs that Matías sort of helped us to identify last week, is there any one that you are particularly excited about for fixing things in WordPress or just generally like an interesting topic of development for you?</p>\n\n\n\n<p>[Héctor Prieto 00:03:42]<br><br>Well, I would say all of them and how they all play together. But, if I need to pick one of them…</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:03:48]<br><br>Everything&#8217;s the best!&nbsp;</p>\n\n\n\n<p>[Héctor Prieto 00:03:50]<br><br>I&#8217;ll cheat anyway, and I will going to pick two out of them because they solve issues at different levels. I&#8217;m very excited about visual revisions. I think it helps a lot of users, and it affects even non-technical users.</p>\n\n\n\n<p>So it&#8217;s one of the projects that lower how hard or complex WordPress can be to use sometimes. It&#8217;s going to be a huge improvement. It&#8217;s going to, I mean, bringing blocks to the revision system. I mean, it&#8217;s just a dream come true for me. I&#8217;m also going to highlight the search everywhere or quick search feature Matías already opened an issue in the GitHub repository right now.&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:04:28]<br><br>Mm-hmm.</p>\n\n\n\n<p>[Héctor Prieto 00:04:28]<br><br>So the idea for this product is to have a power user shortcut that opens searching, an Alfred-like or Spotlight-like interface for those familiar with MacOS operating systems.</p>\n\n\n\n<p>When you can type anything, any place you want to go, or you want to search for any specific text in a document. And it&#8217;s supposed to be your power user command tool. So that you can do most things there.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:04:53]<br><br>Oh, and I mean not only power user command tool, but also there are some applications there for folks who have mobility issues, people who are using primarily keyboard as opposed to keyboard and mouse, all that kind of stuff, right?</p>\n\n\n\n<p>[Héctor Prieto 00:05:07]<br><br>Exactly. And just thinking long term with the rise of AI, it could be possible even to add some natural language processing to this interface so that users could just write in, in plain text, in natural language, what they want to do, and WordPress would provide the action for them.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:05:23]<br><br>Very nice. My two favorites, since you gave two favorites and I can&#8217;t just give one at that point, my two favorite projects, which are also probably really, really hard projects, are those explorations around fixing notifications. That is a really big project. And one that I think that, in general, the WordPress project is going to be really excited to have some input on.&nbsp;</p>\n\n\n\n<p>And so that&#8217;s one that I really will have an eye on. And the other one that I&#8217;m going to definitely have my eye on is the media gallery redesign. I realize that this shows, between you and I, that shows our two specific focuses. Because, of course, you work directly with guiding all of our developers. And I am very much like our user advocate. And WordPress “everyman.”</p>\n\n\n\n<p>I don&#8217;t know if that&#8217;s a term that makes sense outside the US. But I do a lot of advocacy for folks who are using WordPress from the user side as opposed to from the developer side because, of course, we have a lot of excellent developers. So y&#8217;all don&#8217;t need my help with your advocacy.</p>\n\n\n\n<p>But yeah, that really shows that you and I have different focuses, which I think is good too.</p>\n\n\n\n<p>[Héctor Prieto 00:06:32]<br><br>Yes. Also, it’s worth noting that at the end of the day, any improvement we make for developers is so that developers can build better things for users. So, at the end of the day, everything is in the best interest of the users.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:06:45]&nbsp;</p>\n\n\n\n<p>That&#8217;s right. That&#8217;s definitely a good point. Yeah. So, a final question about this particular thing because we&#8217;re trying to keep it a little brief and also because we&#8217;ll have a few other podcasts that are specifically about phase three as our explorations get going. Final question here: If you felt like there was one API or one project in particular that could benefit from a lot of community involvement which would you guess that was?</p>\n\n\n\n<p>[Héctor Prieto 00:07:20]<br><br>I don&#8217;t think I can single out any of them. I think getting user feedback is going to be a vital part of this phase, as always. So I would encourage our listeners to just participate in discussions and provide feedback as we start releasing the first prototypes in the Gutenberg plugin. I don&#8217;t think I can pick one of them for you, completely honest.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:07:43]&nbsp;</p>\n\n\n\n<p>Yeah. My guess for that is going to be the rework of the dashboard, the admin, WP admin. I think that a lot of people are gonna have a lot to say about what they use it for, what they would like to be able to use it for, how to make it look more modern, how to make it feel more modern. I think that that probably is going to benefit from a lot of early testing and possibly some specific user testing around the concepts of design in there.</p>\n\n\n\n<p>And so that&#8217;s one that that I think probably is going to take a lot of feedback from the community. And community, in this case, I think, is not only our developers and designers and copy folks who are working to build the CMS, but probably also all of our folks who are extending WordPress, everybody who is working in agencies, things like that.</p>\n\n\n\n<p>[Héctor Prieto 00:08:35]<br><br>Hmm, well, if I need to pick one, I would say the publishing flows could use also lots of feedback and testing because we are going to implement editorial requirements and customized user flows. And, of course, there are many, many different workflows out there that we might not be able to think of ourselves.</p>\n\n\n\n<p>So just imagine the sheer amount of different use cases. There&#8217;s going to be, or there currently is with customizations of third-party plugins. So, yeah. I would like to listen to how people would like the publishing flows to be. What are the specific use cases?&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:09:09]<br><br>So really, just everything, we need a lot of user feedback on everything.</p>\n\n\n\n<p>[Héctor Prieto 00:09:13]<br><br>Yes. That&#8217;s the summary.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:09:15]</p>\n\n\n\n<p>I don&#8217;t think that&#8217;s a bad summary. I know that we talk a bit about how WordPress is made better by the activity of our co-creators, the people who are using the software and testing the software, and telling us how it could be better. Those are the groups of people that make sure that we are the best version or headed in the best direction on any of our things with the software.</p>\n\n\n\n<p>And so I guess it&#8217;s probably not super unusual for everyone to hear like we need your feedback on everything because that&#8217;s probably what we do half the time.</p>\n\n\n\n<p>[Héctor Prieto 00:09:44]<br><br>Yeah, absolutely.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:09:47]<br><br>So the publishing workflows, that reminds me that there has been a little bit of a conversation lately around the naming of this phase, basically.</p>\n\n\n\n<p>And I know that the phases don&#8217;t necessarily need names. Like that&#8217;s why they&#8217;re numbered, and that&#8217;s a great idea. Like numbers are wonderful ways to reference things, but it also is just easier to reference it in kind of general conversation.</p>\n\n\n\n<p>So the first phase was easier editing, and it really focused on the editing experience itself. The second one was customization, and now the third phase has been called collaboration for quite a bit of time.</p>\n\n\n\n<p>But as we got closer and closer to this phase and we had more and more conversations that were coming out of phases one and two, it became really clear that really what we&#8217;re looking at here is more around workflows. And I love that that is an option for how to refer to this. Probably that&#8217;s how I will refer to it for most of the time that I talk about it as we are looking at phase three. </p>\n\n\n\n<p>Because I remember that when we were first building the prototypes of Gutenberg, one of the big flags that I had was that breaking changes are not just about what we can see or any sort of visual regressions or what causes the white screen of death. Also, some of the things that are breaking changes should be considered in those workflows when we change where things are or how you accomplish a task.</p>\n\n\n\n<p>And our users weren&#8217;t ready for it. That is something that is breaking for them, right?</p>\n\n\n\n<p>[Héctor Prieto 00:11:25]&nbsp;<br><br>Yes. As you mentioned, this phase was referenced as collaboration, real-time collaboration, for a long time, but if we think of how this collaboration looks, it&#8217;s much more than just editing at the same time. A very big part of collaboration is also asynchronous collaboration by adding in-line comments and improving these notifications when you have a comment in your draft. I think the power of this phase is how everything comes together. These individual pieces come together.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 0:11:51]<br><br>Yes, and I don&#8217;t know where that first flag that sparked the discussion around, like, okay, but collaborative editing is not quite big enough and also means a bunch of different things for a bunch of different people. It depends on the size of your organization or the type of content you&#8217;re writing.</p>\n\n\n\n<p>Like, I don&#8217;t know where that conversation started. My guess is, you know, some WordCamp somewhere, and an attendee was like, did you, did anybody ever think about these problems? And then they kind of worked their way around the Make Core site or otherwise made their way around to Matias&#8217;s ears.</p>\n\n\n\n<p>But yeah, I think that was a really smart choice. And you&#8217;re exactly right, collaborative editing; that can refer to the synchronous kind or the asynchronous kind, and both of those types of collaboration are equally valuable and probably equally used.</p>\n\n\n\n<p>[Héctor Prieto 00:12:40]<br><br>Yes. And one important point to note here is that this editorial flows, and this collaboration is crucial to implement multilingualism going into phase four. We need to think that as soon as we have posts and pages in different languages, there are going to be requirements in terms of how to translate these pieces of content.</p>\n\n\n\n<p>So this will need collaboration, all forms of collaboration.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:13:02]<br><br>Yeah, absolutely. This maybe was before your time with the project, but I was team multilingual-first for a long time. Or at least thinking that we could do the multilingual part of this work alongside the collaborative editing part of the work. I&#8217;ve spent a lot of time trying to understand what we think is going in phase three versus what probably we need to be able to do as far as having native multilingual support in the project.</p>\n\n\n\n<p>And I have softened my very hard position on that. You know, we&#8217;re big fans of strong positions loosely held, strong opinions loosely held. And this was one of those moments where I had that really strong opinion that we could just do them concurrently. We can do them at the same time.</p>\n\n\n\n<p>And I think it was a conversation that you and I were having when you were pointing out the complexities of translating WordPress at all, let alone being able to translate all your content as well. And it makes a lot of sense, and you&#8217;re right. I think that there are a lot of interactions, a lot of workflows that we&#8217;re gonna have to kind of refresh or redesign or rebuild before it really makes sense for us to help make that a nice streamlined option for multilingual offerings.</p>\n\n\n\n<p>[Héctor Prieto 00:14:17]<br><br>Yes, absolutely. As a Spanish-speaking person, I&#8217;m super excited about having multilingual in Core, but I also understand that we need some tooling ready before implementing multilingual in Core.&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:14:29]&nbsp;</p>\n\n\n\n<p>There are no, there really are no easy problems left in WordPress, right? Like, we all agree on this now?</p>\n\n\n\n<p>[Héctor Prieto 00:14:36]<br><br>That&#8217;s correct. And we&#8217;re creating something incrementally. If we look at the phases, they are ordered sequentially. But that doesn&#8217;t mean that when we start phase three, we are, finishing phase two completely in the same way. We have not finished phase one.</p>\n\n\n\n<p>That will be like saying, when is WordPress finished, when is the development finished? So it&#8217;s an incremental project, and it&#8217;s always going to be to need refining. So it&#8217;s of course, multilingual needs to come after collaboration because we need those tools.</p>\n\n\n\n<p>But that doesn&#8217;t mean we need to finish the collaboration phase or have it very advanced phase three before we can start phase four. That will be determined in the next month as we start explorations.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:15:17]&nbsp;</p>\n\n\n\n<p>So if you all, which I know you are, are interested in better workflows, more streamlined ways of working inside WordPress, and or interested in how we are gonna get multilingual settled in the future, this is a great time to get involved in this project and in the community. Like I said, we&#8217;ve got that post up that Matías shipped last week, which, again, if you have not read it, go read it because it&#8217;s got excellent, excellent information in there for you.&nbsp;</p>\n\n\n\n<p>Héctor, before we head out, is there anything that you wanna make sure that you let the listeners know, either about phase three or just about WordPress in general?</p>\n\n\n\n<p>[Héctor Prieto 00:15:57]<br><br>Well, tomorrow is WordPress 6.2 release day. So happy 6.2, everybody!</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:16:04]<br><br>Happy 6.2. Oh, yeah. Yeah. Which means today is the dry run; probably in three hours, we&#8217;re doing the dry run.</p>\n\n\n\n<p>[Héctor Prieto 00:16:14]<br><br>Depends on when we&#8217;re listening to this, but yes.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:16:18]&nbsp;</p>\n\n\n\n<p>Oh, that&#8217;s a good point. Right? Not everybody listens to this the second it becomes available. Time zones. That&#8217;s right. Oh, man. Look at us being a global project and just pretending like everybody listens to this particular thing the moment that it&#8217;s available.</p>\n\n\n\n<p>I apologize to everybody who&#8217;s listening to it after the release or in the middle of the release party or whatever you&#8217;re doing. Regardless, tomorrow, if you&#8217;re listening to it today, is the WordPress 6.2 release, and it&#8217;s gonna be great.</p>\n\n\n\n<p>Well, Héctor, thank you so much for joining me today. I really enjoyed having you on, and thanks for letting me interview you.</p>\n\n\n\n<p>[Héctor Prieto 00:16:59]<br><br>Thank you for having me. It was my pleasure to be here.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:17:10]</p>\n\n\n\n<p>So that brings us now to our small list of big things, and as is frequently the case, it&#8217;s actually kind of a big list of big things. So we&#8217;re gonna hop right in here. As Héctor and I mentioned in the episode, the release WordPress 6.2 is coming out tomorrow, depending on when you&#8217;re listening to this. If you listen to it on the 27th, it comes out on the 28th of March.&nbsp;</p>\n\n\n\n<p>If you have a chance to drop by the release party. I would encourage you to; they&#8217;re pretty interesting just to get an idea of everything that it takes to build WordPress. It is, of course, the last few hours before a release, and so you don&#8217;t get a full scope.</p>\n\n\n\n<p>But it&#8217;s always nice to see the way that everybody in the community works together, especially there in that last moment when we&#8217;re trying to package something and test it in a bunch of environments all across the world.&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:18:00]&nbsp;</p>\n\n\n\n<p>I love attending those. And so I encourage it. The next episode of the WordPress Briefing is going to have the release rundown.</p>\n\n\n\n<p>I&#8217;ll go through the key features and highlights that finally made it into 6.2. The reason we don&#8217;t do those beforehand is just in case we have to remove anything at the last minute from a release. It doesn&#8217;t happen too often, but it does happen sometimes. And so, next episode of WP Briefing, that&#8217;s what we&#8217;ll be talking about.</p>\n\n\n\n<p>The next thing on my list is a new developer blog. So there is a brand new developer blog. It was launched last Wednesday. It&#8217;s a great resource for WordPress developers to stay up to date and hear the latest in the WordPress development world. And also, we had been hearing some feedback from our developers in recent years that if you are like exploring how to extend WordPress, if you&#8217;re in that group of extenders, people who are building themes or building plugins, you&#8217;ve kind of feel like you&#8217;ve lost a place where you can have those exploratory conversations.&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:19:00]&nbsp;</p>\n\n\n\n<p>This is gonna be one of those places. We&#8217;ll put a link in the show notes. So far, the content that&#8217;s planned, I think, is really interesting.</p>\n\n\n\n<p>Next thing on our small list, big list, of big things is WordCamp Europe&#8217;s Contributor Day.</p>\n\n\n\n<p>So registration for Contributor Day is now open, and it does require a separate registration than regular attendance at WordCamp Europe. So if you are registered for WordCamp Europe, you already have your ticket for that, but you are not registered for Contributor Day, click the link in the show notes and come on down to spend a little time giving back to the WordPress Project.</p>\n\n\n\n<p>And the last thing on our list today is that we have a WP20 Wapuu coloring giveaway. So put on your little party hats, and grab your crayons. The 20th anniversary Wapuu coloring giveaway is here. There is an opportunity to color in your own community-driven Wapuu and tweet it to us using #WapuuWP20 for your chance to win a sweet haul of WP20 swag items.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:20:00]</p>\n\n\n\n<p>You can check out the full rules at the link in our show notes.</p>\n\n\n\n<p>And that, my friends, is your small list of big things. Thanks for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"14697\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Introducing the WordPress Developer Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wordpress.org/news/2023/03/introducing-the-wordpress-developer-blog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Mar 2023 13:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:17:\"Developer content\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=14649\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"The WordPr Developer blog, a dedicated   space to support devs, is available to help ideas sharing, ways of using new features, and more.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4661:\"\n<p>With much activity happening in the WordPress development space every day, keeping up-to-date with the latest updates can be challenging. The new <a href=\"https://developer.wordpress.org/news/\">WordPress Developer Blog</a> is a developer-focused resource to help you stay on top of the latest software features, tutorials, and learning materials relevant to the open source project.</p>\n\n\n\n<p>This blog is the culmination of a community effort that began last year. Formed by experienced WordPress community members and developers, the <a href=\"https://developer.wordpress.org/news/about/\">editorial group</a> has since worked on a wide range of content already available—from theme and block development tutorials to tips and tricks for leveraging WordPress in the site editing era.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A new home for developers</h2>\n\n\n\n<p>As a complementary resource to the WordPress documentation, the Developer Blog aims to provide a shared space to stay informed of development-related updates, keep up with ongoing discussions and ideas, and explore cutting-edge use cases.</p>\n\n\n\n<p>In other words, <strong>consider it as a central hub for developers and </strong><a href=\"https://make.wordpress.org/updates/2020/05/01/care-and-influence-a-theory-about-the-wordpress-community/\"><strong>extenders</strong></a> of different backgrounds and skill levels to learn with quality content from reliable sources, share knowledge, and drive WordPress development forward.</p>\n\n\n\n<p>True to the open source way, the blog will likely evolve. As its editors and readers learn and create more content, it will adapt in response to the needs of community members like you.</p>\n\n\n\n<p>Everyone is welcome to chime in on-topic discussions, share ideas or contribute. <a href=\"https://developer.wordpress.org/news/how-to-contribute/\">Learn more about how to get involved</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What about the content?</h2>\n\n\n\n<p>Content on the WordPress Developer Blog covers many topics, including tutorials on <a href=\"https://developer.wordpress.org/news/category/themes/\">theme development</a>, <a href=\"https://developer.wordpress.org/news/category/plugins/\">plugins</a>, and <a href=\"https://developer.wordpress.org/news/category/block-development/\">block development</a>. You can also expect posts on WordPress APIs, best practices for working with WordPress, updates on upcoming releases, and <a href=\"https://developer.wordpress.org/news/category/learning/\">learning resources</a> for beginners and seasoned developers.</p>\n\n\n\n<p>These articles offer a good hint at what&#8217;s already in store for you:</p>\n\n\n\n<ul>\n<li><a href=\"https://developer.wordpress.org/news/2022/11/17/demystifying-home-and-posts-templates-in-wordpress-theme-development/\">Demystifying home and posts templates in WordPress theme development</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2022/11/creating-themes-from-a-pattern-first-mindset/\">Creating themes from a pattern-first mindset</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2023/02/static-vs-dynamic-blocks-whats-the-difference/\">Static vs. dynamic blocks: What’s the difference?</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2023/02/creating-custom-block-styles-in-wordpress-themes/\">Creating custom block styles in WordPress themes</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2023/03/whats-new-for-developers-march-2023/\">What’s new for developers? (March 2023)</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Sounds interesting? </h2>\n\n\n\n<p><a href=\"https://developer.wordpress.org/news/#subscribe\">Subscribe to the Developer Blog</a> to keep up with the latest content in the WordPress development space.</p>\n\n\n\n<p><em>Props for content and peer review <a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a> <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a> <a href=\'https://profiles.wordpress.org/mburridge/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mburridge</a> <a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a> <a href=\'https://profiles.wordpress.org/bph/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bph</a>&nbsp;<a href=\'https://profiles.wordpress.org/greenshady/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>greenshady</a> <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"14649\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.2 Release Candidate 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2023/03/wordpress-6-2-release-candidate-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Mar 2023 17:43:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=14685\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:315:\"WordPress 6.2 Release Candidate 3 is now available for download and testing.\nThis version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended that you test RC3 on a test server and site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Jonathan Pantani\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4918:\"\n<p>It’s the final countdown: the third (and last) scheduled <a href=\"https://make.wordpress.org/core/handbook/glossary/#release-candidate\">release candidate</a> (RC3) for WordPress 6.2 is ready! </p>\n\n\n\n<p>The WordPress 6.2 release is scheduled for March 28, 2023—just one week away! Now is your last opportunity to test it before the general release.&nbsp;</p>\n\n\n\n<p>Just tuning in now? Catch up on the featured highlights, and dig into more 6.2 details in the <a href=\"https://wordpress.org/news/2023/03/wordpress-6-2-release-candidate-1/\">WordPress 6.2 RC1 release announcement</a>.</p>\n\n\n\n<p>Thanks to all the Beta and RC testers who have assisted in this release. Since <a href=\"https://wordpress.org/news/2023/03/wordpress-6-2-release-candidate-2/\">RC2</a> was released on March 14, there have been about 21 issues resolved in <a href=\"https://core.trac.wordpress.org/query?status=accepted&amp;status=closed&amp;changetime=03%2F15%2F2023..03%2F21%2F2023&amp;milestone=6.2&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Trac</a> and <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.2\">GitHub</a>.</p>\n\n\n\n<p>Your feedback and help in filing bug reports keep the WordPress experience stable, smooth, and delightful. It’s critical work and a great way to contribute to the project.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to install RC3 for testing</h2>\n\n\n\n<p><strong>This version of the WordPress software is under development. </strong>Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended that you test RC3 on a test server and site.&nbsp;</p>\n\n\n\n<p>You can test WordPress 6.2 RC3 in three ways:</p>\n\n\n\n<p><strong>Option 1</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (select the “Bleeding edge” channel and “Beta/RC Only” stream).</p>\n\n\n\n<p><strong>Option 2</strong>: Direct download the <a href=\"https://wordpress.org/wordpress-6.2-RC3.zip\">RC3 version (zip)</a>.</p>\n\n\n\n<p><strong>Option 3</strong>: Use the following WP-CLI command:</p>\n\n\n\n<p><code>wp core update --version=6.2-RC3</code></p>\n\n\n\n<h2 class=\"wp-block-heading\">A shout out to plugin and theme developers</h2>\n\n\n\n<p>Your products are the reason WordPress does so many things for more people across the world. As you test your latest versions against RC3, make sure you update the “<em>Tested up to”</em> version in your plugin’s readme file to 6.2. If you find compatibility problems, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>.</p>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">WordPress 6.2 Field Guide</a> for more details about the major changes in this release.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Help translate WordPress</h2>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help translate WordPress into more than 100 languages.</a>&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">Keep WordPress bug-free—help with testing</h2>\n\n\n\n<p>Without your testing support, hitting important product milestones would be a much bigger challenge. It’s also a meaningful way to contribute to the project. If you’re new to testing, or it’s been a while, <a href=\"https://make.wordpress.org/test/2023/02/07/help-test-wordpress-6-2/\">this detailed guide</a> can help you get started.&nbsp;</p>\n\n\n\n<p>If you think you have run into an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. If you are comfortable writing a reproducible bug report, you can <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Release the haiku</h2>\n\n\n\n<p>Wow, we’re oh so close<br>Test, test. Get it out the door.<br>Please no RC 4.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/laurlittle/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>laurlittle</a> <a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a> <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a> <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a> <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"14685\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.2 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2023/03/wordpress-6-2-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Mar 2023 17:59:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"6.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=14640\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:315:\"WordPress 6.2 Release Candidate 2 is now available for download and testing.\nThis version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended that you test RC2 on a test server and site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Jonathan Pantani\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4681:\"\n<p>Here it is: the second release candidate (RC2) for WordPress 6.2 is ready! </p>\n\n\n\n<p>WordPress 6.2 is scheduled for release on March 28, 2023—which is only two weeks away. Now is your perfect opportunity if you haven’t tried it out yet. Your feedback and help filing bug reports are what keep the WordPress experience stable, smooth, and delightful. It’s important work and a great way to contribute to the project.&nbsp;</p>\n\n\n\n<p>Thanks to everyone who tested the Beta and RC releases so far. Since RC1 was released on March 9, there have been about 36 issues resolved in <a href=\"https://core.trac.wordpress.org/query?status=accepted&amp;status=closed&amp;changetime=03%2F07%2F2023..03%2F13%2F2023&amp;milestone=6.2&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Trac</a> and <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.2\">GitHub</a>.&nbsp;</p>\n\n\n\n<p>Catch up on the featured highlights, and dig into more 6.2 details, in the <a href=\"https://wordpress.org/news/2023/03/wordpress-6-2-release-candidate-1/\">WordPress 6.2 RC1 release announcement</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">How to install RC2 for testing</h2>\n\n\n\n<p><strong>This version of the WordPress software is under development. </strong>Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended that you test RC2 on a test server and site.&nbsp;</p>\n\n\n\n<p>You can test WordPress 6.2 RC2 in three ways:</p>\n\n\n\n<p><strong>Option 1</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (select the “Bleeding edge” channel and “Beta/RC Only” stream).</p>\n\n\n\n<p><strong>Option 2</strong>: Direct download the <a href=\"https://wordpress.org/wordpress-6.2-RC2.zip\">RC2 version (zip)</a>.</p>\n\n\n\n<p><strong>Option 3</strong>: Use the following WP-CLI command:</p>\n\n\n\n<p><code>wp core update --version=6.2-RC2</code></p>\n\n\n\n<h2 class=\"wp-block-heading\">A shoutout to plugin and theme developers</h2>\n\n\n\n<p>Your products are the reason WordPress does so many more things for more people across the world. As you test your latest versions against RC2, make sure you update the “<em>Tested up to”</em> version in your plugin’s readme file to 6.2. If you find compatibility problems, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>.</p>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">WordPress 6.2 Field Guide</a> for more details about the major changes in this release.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Help translate WordPress</h2>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help translate WordPress into more than 100 languages.</a>&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">Join the bug hunt—test, test, test</h2>\n\n\n\n<p>Without your testing support, hitting important product milestones would be a much bigger challenge. It’s also a meaningful way to contribute to the project. If you’re new to testing, or it’s been a while, <a href=\"https://make.wordpress.org/test/2023/02/07/help-test-wordpress-6-2/\">this detailed guide</a> can help you get started.&nbsp;</p>\n\n\n\n<p>If you think you have run into an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. If you are comfortable writing a reproducible bug report, you can <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Release the haiku</h2>\n\n\n\n<p>Listen, we are close<br>One step to final RC<br>Breathe, and keep going</p>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: <a href=\'https://profiles.wordpress.org/laurlittle/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>laurlittle</a> <a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a> <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a> <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a></em></p>\n\n\n\n<p><em>Haiku by <a href=\'https://profiles.wordpress.org/sereedmedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>sereedmedia</a></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"14640\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:61:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WP Briefing: Episode 51: Is Routine a Rut?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/news/2023/03/episode-51-is-routine-a-rut/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Mar 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"wp-briefing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=14621\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Join Josepha as she discussed the benefits of routine and what role it plays in the WordPress project. \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2023/03/WP-Briefing-051.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Santana Inniss\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9299:\"\n<p>On Episode fifty-one of the WordPress Briefing podcast, join WordPress Executive Director Josepha Haden Chomphosy as she makes a case for why routine is a good thing&#8211; in life and in the WordPress project. </p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br>Production:&nbsp;<a href=\"https://profiles.wordpress.org/santanainniss/\">Santana Inniss</a><br>Song: Fearless First by Kevin MacLeod </p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/03/06/wordpress-6-2-rc1-postponed-additional-beta-5-added/\" data-type=\"URL\" data-id=\"https://make.wordpress.org/core/2023/03/06/wordpress-6-2-rc1-postponed-additional-beta-5-added/\">Beta 5, Additional Beta Released</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2023/03/wordpress-6-2-release-candidate-1/\">WordPress 6.2, Release Candidate 1</a></li>\n\n\n\n<li><a href=\"https://wp20.wordpress.net/wp20-celebrations/\" data-type=\"URL\" data-id=\"https://wp20.wordpress.net/wp20-celebrations/\">Join WordPress 20th Anniversary Celebrations</a></li>\n\n\n\n<li><a href=\"https://www.eventbrite.com/e/organizing-diverse-inclusive-wordpress-events-ameremea-tickets-561034247537\" data-type=\"URL\" data-id=\"https://www.eventbrite.com/e/organizing-diverse-inclusive-wordpress-events-ameremea-tickets-561034247537\">Organizing Diverse and Inclusive WordPress Events</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2023/02/27/proposal-modify-the-events-and-news-widget-to-show-topic-based-meetups-worldwide/\">Events News Widget Modification Proposal</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-14621\"></span>\n\n\n\n<p>[Josepha Haden Chomphosy 00:00:00]&nbsp;</p>\n\n\n\n<p>Hello everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks.</p>\n\n\n\n<p>I&#8217;m your host, Josepha Haden Chomphosy. Here we go.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:00:29]</p>\n\n\n\n<p>All right, my WordPress wonders; it&#8217;s time to join me for one of my gentle rants on basic leadership principles. Today we&#8217;re talking about the importance of routine and predictability in everyday life. But don&#8217;t worry, I&#8217;m gonna tie it all together with WordPress, too. So by now you&#8217;re probably aware that I don&#8217;t really consider myself one of those “born leaders.”&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:01:00]&nbsp;</p>\n\n\n\n<p>Over the years, I&#8217;ve put a lot of effort into researching characteristics of good leaders and general leadership methods overall. But one of the things I encountered early on in my leadership learning journey was the concept of routine.</p>\n\n\n\n<p>As with most leadership practices I hold, routine has more than one purpose. From a very pragmatic standpoint, routines provide predictability and the more predictable something is, the lower the cognitive load becomes, which in turn lets you use your thinking power for something better. For instance, if you know that in every check-in with your team lead, she&#8217;s gonna ask you what you were proud to have shipped last week, what you want to ship next week, and what things stand in the way of your plans, then you know that that is what you have to prepare for.&nbsp;</p>\n\n\n\n<p>The knowledge work, the thinking part. The thinking part stops being, what is my team lead going to ask me and starts being what is the problem that she can help me solve?&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:02:00]&nbsp;</p>\n\n\n\n<p>But from a more human standpoint, that kind of predictability helps us to understand when something that happened is out of the ordinary. Whether it&#8217;s a notification of a comment left on your blog or syntactical highlighting that lets you know that you&#8217;ve written something that&#8217;s out of voice or against grammar standards, it just lets you know that something is unusual there and deserves your attention.&nbsp;</p>\n\n\n\n<p>Now for me, this has a lot of applications across the WordPress project. There are the obvious things like the cadence of our major release cycles or our notification system, which honestly could use a bit of TLC, a little bit of elbow grease.</p>\n\n\n\n<p>But there are also less obvious things that this idea still applies to simply because of the way our brains work, the information architecture on our sites, for instance. It should make sense visually and semantically because that makes it easy for us to skim and predict where the highest value content is for us. Or the user interface across the back end of our software.&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:03:00]&nbsp;</p>\n\n\n\n<p>Having familiar tasks or actions across any type of content or area of content makes it easier for a site maintainer to flow from one area of a site to the next, fixing things as they find them without necessarily having to stop and put down their hammer and pick up a screwdriver or whatever metaphor works for you. Or if you&#8217;re doing more nuanced work, like put down your timpani mallets and pick up your xylophone mallets.&nbsp;</p>\n\n\n\n<p>So, yeah, consistency. Consistency is the topic of today&#8217;s gentle rant. I get really worked up about it because I feel like consistency ends up being this euphemism for being boring. But I honestly believe that it&#8217;s the consistency and the dependability that make it clear what is supposed to be exciting, the things that are different enough that they merit our attention.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:03:38]&nbsp;</p>\n\n\n\n<p>Which, fortunately, now brings us to our small list of big things. It&#8217;s actually a pretty big list today and also a bunch of pretty big things. So first thing to know, there was an additional beta added to this release cycle.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:04:00]&nbsp;</p>\n\n\n\n<p>It was beta five; it came out last week, I think. There was a bit of a regression that we worked our way through. And so RC1, release candidate one, is going to be postponed a little bit because of that. But don&#8217;t wait until RC to start testing, obviously RC is tomorrow, so that means you get to test, like, today!</p>\n\n\n\n<p>The second thing on our small list of big things is that we have the WordPress 20th anniversary coming up. That&#8217;s May 27th. And you can join in the celebrations. So at WordPress&#8217;s 10th anniversary and 15th anniversary, we had like a big, ongoing global set of parties, like Meetup events got together and made cakes, or did a concert, or did a hackathon for various reasons.</p>\n\n\n\n<p>Like they all got together on May 27th or thereabouts and did some really fun, like celebration of how far WordPress has gotten them and how far they hope to be able to go with WordPress.&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:05:00]&nbsp;</p>\n\n\n\n<p>So if you are from the before times WordCamp kind of organizing timeframe, you know that we always consider WordCamps to be like an annual celebration of the excellence of your community and how much you all come together and how different you are as part of this overall big WordPress-y thingy.&nbsp;</p>\n\n\n\n<p>All right. Third item that we have is that, I know that I mentioned this in the last WP Briefing as well, but we have another session of the diverse and inclusive WordPress events coming up that&#8217;s happening on March 16th. So coming up really fast, we&#8217;ll put a link to that in the show notes as well.</p>\n\n\n\n<p>And the final thing, I don&#8217;t remember what list number we&#8217;re at, but the final thing is that there is a proposal out there right now to modify the events and news widget that we use inside the WordPress dashboard. If you&#8217;re not familiar with it, it is a place where all of the local-to-you Meetup events get listed.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:06:00]&nbsp;</p>\n\n\n\n<p>It&#8217;s where all of the news items from various WordPress media outlets get published. We just have a link to it there. And so, we would like to make some changes to that so that we&#8217;re able to include not only specific location types of events but also events that are location agnostic because they&#8217;re online but might have a specific, identifying niche that you particularly find interesting.</p>\n\n\n\n<p>So it might be for Spanish speakers or for women in particular, or whatever it might be. There&#8217;s a proposal out for that. We&#8217;ll put a link to that in the show notes as well.&nbsp;</p>\n\n\n\n<p>And that, my friends, is your small list of big things. Thanks for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"14621\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:69:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 6.2 Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2023/03/wordpress-6-2-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Mar 2023 17:39:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"6.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=14619\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:316:\"WordPress 6.2 Release Candidate 1 is now available for download and testing.\nThis version of the WordPress software is under development. Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended that you test RC 1 on a test server and site.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"marybaum\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10157:\"\n<p>WordPress 6.2’s first release candidate (RC1) is here and ready for testing.</p>\n\n\n\n<p>Reaching this part of the release cycle is a key milestone. While we consider release candidates ready for final release, additional testing and use by the community can only make it better.</p>\n\n\n\n<p>The official release of 6.2 is just three short weeks away on March 28. In open source, we say with <a href=\"https://en.wiktionary.org/wiki/given_enough_eyeballs,_all_bugs_are_shallow\">many eyes, all bugs are shallow</a>, so we ask everyone across the WordPress ecosystem—theme and plugin developers, educators, agencies, and creators—<a href=\"https://make.wordpress.org/test/2023/02/07/help-test-wordpress-6-2/\">to jump in and help test</a>.</p>\n\n\n\n<p><strong>This version of the WordPress software is under development. </strong>Please do not install, run, or test this version of WordPress on production or mission-critical websites. Instead, it is recommended that you test RC1 on a test server and site.&nbsp;</p>\n\n\n\n<p>You can test WordPress 6.2 RC1 in three ways:</p>\n\n\n\n<p><strong>Option 1</strong>: Install and activate the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (select the “Bleeding edge” channel and “Beta/RC Only” stream).</p>\n\n\n\n<p><strong>Option 2</strong>: Direct download the <a href=\"https://wordpress.org/wordpress-6.2-RC1.zip\">RC1 version (zip)</a>.</p>\n\n\n\n<p><strong>Option 3</strong>: Use the following WP-CLI command:</p>\n\n\n\n<pre class=\"wp-block-code\"><code class=\"\">wp core update --version=6.2-RC1</code></pre>\n\n\n\n<p><em>First-time tester? <a href=\"https://make.wordpress.org/test/handbook/get-setup-for-testing/\">Here&#8217;s a guide to getting started</a>.</em> </p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s in WordPress 6.2 RC1</h2>\n\n\n\n<p>This release includes over 900 enhancements and fixes and is the first major release of 2023.&nbsp;</p>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.2\">Gutenberg commits on GitHub</a></li>\n\n\n\n<li><a href=\"https://core.trac.wordpress.org/query?status=accepted&amp;status=closed&amp;changetime=2023-02-21..2023-03-01&amp;milestone=6.2&amp;col=id&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=id\">Core Trac Tickets</a></li>\n</ul>\n\n\n\n<p>WordPress 6.2 comes packed with enhancements to make everything you do smoother, faster and a little more inspired:</p>\n\n\n\n<ul>\n<li>A refreshed Site Editor for easier template browsing</li>\n\n\n\n<li>A new sidebar experience in the Navigation block for simpler menu management</li>\n\n\n\n<li>Reorganized block settings with separate tabs for Settings and Styles</li>\n\n\n\n<li>New inserter design that lets you add Media—including Openverse and its more than 600-million-item catalog, plus your entire Media Library—and better categories</li>\n\n\n\n<li>More header and footer patterns for block themes</li>\n\n\n\n<li>A new Style Book that shows your entire site’s look and feel all in one place</li>\n\n\n\n<li>New controls to let you copy and paste block styles for faster, simpler design across your whole site</li>\n\n\n\n<li>Custom CSS you can add for those finishing touches, per block and globally</li>\n\n\n\n<li>Sticky positioning to keep important blocks fixed when scrolling</li>\n\n\n\n<li>Distraction Free mode for moments you want to focus on writing</li>\n\n\n\n<li>New options that let you import certain widgets from classic to block themes</li>\n\n\n\n<li>The removal of the Site Editor’s beta label—welcome to the next generation of WordPress</li>\n</ul>\n\n\n\n<p><em>Want to see some of these featured highlights in action? Check out the <a href=\"https://wordpress.org/news/2023/03/your-wordpress-6-2-preview/\">WordPress 6.2 Demo</a> recorded March 2, 2023.</em></p>\n\n\n\n<p>Do you crave a deep dive into tech specs? These recent posts cover a few of the latest technical updates. This is not an exhaustive list, but it should get you started:&nbsp;</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/03/07/patterns-api-expanded-to-include-template_types-property/\">Patterns API expanded to include template_types property</a></li>\n\n\n\n<li><a href=\"https://wp.me/p2AvED-qNP\">Introduction of Block Inspector Tabs</a></li>\n\n\n\n<li><a href=\"https://wp.me/p2AvED-qR8\">Shadows in Global Styles</a></li>\n\n\n\n<li><a href=\"https://wp.me/p2AvED-qME\">Introducing the HTML API</a></li>\n\n\n\n<li><a href=\"https://wp.me/p2AvED-qM4\">Miscellaneous Editor Changes</a></li>\n\n\n\n<li><a href=\"https://wp.me/p2AvED-qNm\">Custom CSS for global styles and per block</a>&nbsp;</li>\n\n\n\n<li><a href=\"https://wp.me/p2AvED-qLf\">Google Fonts are included locally in bundled themes</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/03/editor-components-updates-in-wordpress-6-2/\">Editor Components updates in WordPress 6.2</a></li>\n\n\n\n<li><a href=\"https://wp.me/p2AvED-qPp\">Enhanced accessibility</a></li>\n\n\n\n<li>And much, much more</li>\n</ul>\n\n\n\n<p>These are also compiled into a <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">comprehensive WordPress 6.2 Field Guide</a>.&nbsp;&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">Let&#8217;s go on a bug hunt!</h2>\n\n\n\n<p>Without your testing support, hitting important product milestones would be a much bigger challenge. It’s also a meaningful way to contribute to the project. If it’s your first time, or it’s been a while, <a href=\"https://make.wordpress.org/test/2023/02/07/help-test-wordpress-6-2/\">this detailed guide</a> is a great resource to lean on.&nbsp;</p>\n\n\n\n<p>From a global perspective, every time you test a pre-release version, you help secure the future of WordPress. How? By helping the community prove the software is stable, easy to use, and as bug-free as possible.&nbsp;</p>\n\n\n\n<p>Want to know more about testing releases in general? You can follow along with the <a href=\"https://make.wordpress.org/test/\">testing initiatives</a> that happen in Make Core. You can also join the <a href=\"https://wordpress.slack.com/messages/core-test/\">#core-test channel</a> on the <a href=\"https://wordpress.slack.com/\">Making WordPress Slack workspace</a>.</p>\n\n\n\n<p>If you think you have run into an issue, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. If you are comfortable writing a reproducible bug report, you can <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. You can also check your issue against a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>Interested in the details on the latest Gutenberg features? Find out what’s been included since WordPress 6.1 (the last major release of WordPress). You will find more details in these <em>What’s new in Gutenberg</em> posts for <a href=\"https://make.wordpress.org/core/2023/02/10/whats-new-in-gutenberg-15-0-18-january-2/\">15.1</a>, <a href=\"https://make.wordpress.org/core/2023/01/20/whats-new-in-gutenberg-15-0-18-january/\">15.0</a>, <a href=\"https://make.wordpress.org/core/2023/01/04/whats-new-in-gutenberg-14-9-4-january/\">14.9</a>, <a href=\"https://make.wordpress.org/core/2022/12/22/whats-new-in-gutenberg-14-8-21-december/\">14.8</a>, <a href=\"https://make.wordpress.org/core/2022/12/09/whats-new-in-gutenberg-14-7-7-december/\">14.7</a>, <a href=\"https://make.wordpress.org/core/2022/11/23/whats-new-in-gutenberg-14-6-23-november/\">14.6</a>, <a href=\"https://make.wordpress.org/core/2022/11/09/whats-new-in-gutenberg-14-5-9-november/\">14.5</a>, <a href=\"https://make.wordpress.org/core/2022/10/27/whats-new-in-gutenberg-14-4-26-october/\">14.4</a>, <a href=\"https://make.wordpress.org/core/2022/10/13/whats-new-in-gutenberg-14-3-12-october/\">14.3</a>, and <a href=\"https://make.wordpress.org/core/2022/09/30/whats-new-in-gutenberg-14-2-28-september/\">14.2</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A special thanks to WordPress plugin and theme developers</h2>\n\n\n\n<p>Do you build plugins and themes?&nbsp;Your products play a special role in helping WordPress do more things for more people across the world. In turn, more people in the WordPress Community mean a bigger, more robust open web.</p>\n\n\n\n<p>Chances are, you have already been testing your latest versions against the WordPress 6.2 betas. With RC1, you will want to finalize your testing and update the “<em>Tested up to”</em> version in your plugin’s readme file to 6.2.&nbsp;</p>\n\n\n\n<p>If you find compatibility problems, please post detailed information to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Help translate WordPress</h2>\n\n\n\n<p>Do you speak a language other than English? ¿Español? Français? Português? Русский? 日本? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help translate WordPress into more than 100 languages.</a> This release also marks the <a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">hard string freeze</a> point of the 6.2 release cycle.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Hungry for even more?</h2>\n\n\n\n<p>Want to know more about what went into the making of WordPress 6.2? Please check out the <a href=\"https://make.wordpress.org/core/6-2/\">6.2 release cycle</a>, the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a>, or search for <a href=\"https://make.wordpress.org/core/tag/6-2/\">all things 6.2 related</a>.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">Another haiku for 6.2—it’s tradition!&nbsp;</h2>\n\n\n\n<pre class=\"wp-block-verse\">Beta has left us<br>The code sings such happy songs<br>Six point two RC</pre>\n\n\n\n<p><em>Thank you to the following contributors for collaborating on this post: </em><a href=\"https://profiles.wordpress.org/laurlittle/\"><em>@laurlittle</em></a><em> </em><a href=\"https://profiles.wordpress.org/cbringmann/\"><em>@cbringmann</em></a><em>, <a href=\"https://profiles.wordpress.org/audrasjb/\">@audrasjb</a>, <a href=\"https://profiles.wordpress.org/jpantani/\">@jpantani</a>. Haiku by @<a href=\"https://github.com/nomad-skateboarding-dev\">nomad-skateboarding-dev</a></em>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"14619\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Your WordPress 6.2 Preview\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/news/2023/03/your-wordpress-6-2-preview/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Mar 2023 17:11:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"6.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=14573\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:179:\"Watch this ‘live product demo’ recording with release squad members Anne McCarthy and Rich Tabor as they share exciting enhancements anticipated for the WordPress 6.2 release.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Jonathan Pantani\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:67367:\"\n<p>On March 2, release squad members <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> and <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> presented a live product demo of all the delights coming in WordPress 6.2, set to release on March 28, 2023.&nbsp;</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-videopress wp-block-embed-videopress\"><div class=\"wp-block-embed__wrapper\">\n<iframe title=\"VideoPress Video Player\" aria-label=\'VideoPress Video Player\' width=\'500\' height=\'315\' src=\'https://video.wordpress.com/embed/5nQlEknZ?at=31&amp;hd=1&amp;cover=1\' frameborder=\'0\' allowfullscreen allow=\'clipboard-write\'></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1674852142\'></script>\n</div></figure>\n\n\n\n<p>A first-of-its-kind event in the world of WordPress releases, the showcase was moderated by fellow community member <a href=\"https://profiles.wordpress.org/njwrigley/\">Nathan Wrigley</a> and joined by nearly 90 participants.&nbsp;</p>\n\n\n\n<p>During the demo, Anne and Rich highlighted some of the new features and enhancements that will continue to revolutionize the way you interact with WordPress. They gave a quick tour of the Site Editor’s refreshed interface, which lets you browse and preview templates before editing. They also covered all the new and highly anticipated ways to manage styles, as well as improvements to the Navigation block, new collections of header and footer patterns, the new distraction-free mode for focusing on writing, and plenty more.&nbsp;</p>\n\n\n\n<p>It was a jam-packed hour that sparked plenty of excitement—and a lively question and answer session that wrapped up the event on a high note. The presenters weren&#8217;t able to answer all the questions that were posed so they were <a href=\"https://a8c.slack.com/archives/C04S7RYK0F3/p1678330454722129?thread_ts=1678330090.320659&amp;cid=C04S7RYK0F3\">collected and answered in a follow-up post</a> on <a href=\"https://make.wordpress.org/core/\">Make.Wordpress.org/Core</a>.</p>\n\n\n\n<p>Watch the recording of the live demo in case you missed it, or want to relive the moment (and the funky fresh demo site designed by Rich). You can find a full transcript of the live demo below.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\">Referenced Resources</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/02/2https://make.wordpress.org/core/2023/02/21/6-2-live-product-demo/%201/6-2-live-product-demo/\">Live demo announcement</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/02/06/roadmap-to-6-2/\">6.2 release roadmap</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/02/04/phase-2-finale/\">Wrapping Phase 2 of the Gutenberg project</a><strong>&nbsp;</strong></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2023/02/wordpress-6-2-beta-1/\">6.2 release enters Beta 1</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/01/wordpress-6-2-beta-4/\">Beta 4 and the latest call for testing</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/47043\">Fixed/sticky positioning GitHub issue</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/\">Learn WordPress</a></li>\n\n\n\n<li>FSE theme developers on Twitch: <a href=\"https://www.twitch.tv/daisyonwp\">daisyonwp</a> and <a href=\"https://www.twitch.tv/ryanwelchercodes\">ryanwelchercodes</a></li>\n\n\n\n<li><a href=\"https://developer.wordpress.org/news/2023/02/intrinsic-design-theming-and-rethinking-how-to-design-with-wordpress/\">Intrinsic design, theming, and rethinking how to design with WordPress</a></li>\n\n\n\n<li><a href=\"https://github.com/annezazu\">Anne McCarthy on GitHub</a></li>\n\n\n\n<li>Learn WP workshop: <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/291813021/?isFirstPublish=true\">How to create a website on mobile</a></li>\n</ul>\n\n\n\n<p><em>Props to <a href=\'https://profiles.wordpress.org/cbringmann/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>cbringmann</a> and <a href=\'https://profiles.wordpress.org/laurlittle/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>laurlittle</a> for co-authoring and editing this post, <a href=\'https://profiles.wordpress.org/evarlese/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>evarlese</a>, <a href=\'https://profiles.wordpress.org/courtneypk/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>courtneypk</a>, and <a href=\'https://profiles.wordpress.org/mysweetcate/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mysweetcate</a> for captioning, and <a href=\'https://profiles.wordpress.org/robinwpdeveloper/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>robinwpdeveloper</a> for uploading the recording files to wordpress.tv.</em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-14573\"></span>\n\n\n\n<pre class=\"wp-block-preformatted\"><strong>Nathan Wrigley </strong>0:22  <strong>\n</strong>How are we doing? Should we go for it?\n\n<strong>Anne McCarthy  </strong>0:24  <strong>\n</strong>I think we can start.\n\n<strong>Nathan Wrigley </strong> 0:26<strong> \n</strong>Why not? The recording has started. So let\'s get, let\'s get cracking.\n\nHello, welcome everybody to the WP 6.2 Live Demo outline. I\'m Nathan Wrigley. I do a few things around the WordPress community, mainly to do with video and podcasting and things like that. But it\'s not about me.\n\nToday, we\'ve got two fabulous guests. We\'ve got Anne McCarthy and Rich Tabor, and they\'re going to do a full on Product Demo. It\'s a little bit unlike things that you may have seen, because in the more recent past, lots of new features have been added. And so Rich, and Anne are going to spend the time on the screen in a moment, and they\'re going to show you all of the bits and pieces that you may find dropping into a WordPress install near you. Let\'s hope. There\'s been a lot that\'s been happening, so there really will be probably 20 or 30 minutes of live demos, so look forward to that. I\'ve got to get them to introduce themselves in a couple of moments.\n\nJust before that, though, a little bit of housekeeping. This is going to be recorded, so if you have to drop out halfway through and go elsewhere, completely fine. It\'s going to be posted at the Make/Core website, but it will also come fully complete with a transcript as well. So, if that\'s something that you\'re looking for, that will all be there. Also to say that if you want to post any questions, we\'d love that. In fact, there\'s a whole portion at the end when Rich and Anne have finished speaking, where we\'re going to field questions toward them. Now there\'s really two places to do that. If you\'re live with us on Zoom, then if you hit the Q&amp;A button at the bottom of the screen and post your questions in there, I guess specifity... specific... Whatever that word is, be specific. Help us out. Tell us exactly what you want to know and we\'ll get the questions to them. The other way to do that is to go into Slack. And there is a channel in there, #walkthrough. And if you want to post any questions in there as well, that would be great. So yeah, just to recap, Q&amp;A button if you\'re in Zoom, and use the Slack #walkthrough channel, if you are in the Making WordPress Slack. Okay, right. I think we\'ll take you guys one at a time if that\'s alright. First off a little bit of an introduction from both of you. Let\'s begin with with Anne McCarthy, shall we? Hello, Anne!\n\n<strong>Anne McCarthy  </strong>2:42<strong>\n</strong>Hello, hello. It\'s so good to be back on literally any sort of live stream with you.\n\nI appreciate that you\'re a part of this\n\n<strong>Nathan Wrigley </strong> 2:48<strong> \n</strong>Yeah, that\'s really nice.\n\n<strong>Anne McCarthy  </strong>2:49<strong>\n</strong>Well, I\'m Anne McCarthy. I\'m a product wrangler at Automattic. I live in Seattle. I also run the FSE Outreach Program, which is basically dedicated to testing all the latest and greatest of WordPress, which is part of why I\'m so excited to be part of this demo, is because so much neat stuff has come through this that I\'ve had the privilege of going through a little bit early on with the ever growing calls for testing. So that\'s a little bit about me, I\'ll pop it over to Rich.\n\n<strong>Nathan Wrigley  </strong>3:17<strong>\n</strong>Yeah. So Rich, if you want to take the baton there.\n\n<strong>Rich Tabor  </strong>3:21<strong>\n</strong>Yeah. Hey, everyone. I\'m Rich Tabor. I\'m a product manager at Automattic. And I work on WordPress and Gutenberg, in particular. From a little bit south of Atlanta, Georgia, in the US, and been building and tinkering with WordPress for I think, close to 11 years now. So it\'s, it\'s been a good run, and I\'m super stoked about where things are heading.\n\n<strong>Nathan Wrigley  </strong>3:43<strong>\n</strong>Yeah, and things definitely have been moving in a very much a forward direction, WordPress, 6.1. And WordPress 6.2. There\'s so much clear blue sky between the two of them. I think probably the best thing at this point is if we can have it, I don\'t know what whose screen is coming on. I think it might be Rich\'s, or maybe it\'s Anne\'s, I don\'t know.\n\n<strong>Rich Tabor  </strong>4:00<strong>\n</strong>Yeah.\n\n<strong>Nathan Wrigley  </strong>4:01<strong>\n</strong>If we can get that screen shared, then I will slide my way out of this call and say, Rich and Anne, it\'s... it\'s over to you. I\'ll be back soon as you\'re finished for any Q&amp;As.\n\n<strong>Anne McCarthy  </strong>4:14<strong>\n</strong>Awesome. Thank you.\n\n<strong>Rich Tabor  </strong>4:17<strong>\n</strong>Alright, everybody can see my screen right now?\n\n<strong>Anne McCarthy  </strong>4:19 <strong>\n</strong>Yes. Rich did an excellent job designing this. I do want to call this out that I love, absolutely love this.\n\n<strong>Rich Tabor  </strong>4:26<strong>\n</strong>Thanks, Anne. Yeah, this is actually running Twenty Twenty-Three. So it\'s kind of showcasing some of the things you can do just with the core theme. And some of the design tooling that we are, that has been built into 6.2. So this view here is the site editor. So I\'m going to orient you here. There\'s one big change here in particular, I want to call out visually, is this idea of the frame here on the right, and this will pull up the local template. So I\'m looking at my homepage of the site right now. If I navigate into other templates, I can pull those up here on the right as well. And then you can also navigate template parts. So this part\'s not very new to 6.2. But the idea of zooming in on different template parts and templates and having them appear here in the frame is. And that\'s important because of this concept of browse mode. And this is where you could dive into an actual page from the site editor. So here, I just pulled up the about page of the site, and I can click into it and actually start making changes. Now, the changes here within the post content block are going to be relative to this about page. But I can also modify the template which then changes the about, or changes the page on any instance of this particular template. So it\'s a new concept and how we can browse the site. But it\'s a very powerful, and really the first iteration of that way of managing a site.\n\n<strong>Anne McCarthy  </strong>5:50<strong>\n</strong>And also lightly introduced content editing in the site editor, as you mentioned. So it\'s a kind of a neat merging of the two worlds, which I know folks have long been wanting to see that unified. And same with the frame, it kind of adds a nice layer where instead of just being dropped in, like before, you kind of are given a more zoomed out view, which I think helps address a lot of the feedback that we saw around the orientation when you\'re entering the site editor.\n\n<strong>Rich Tabor  </strong>6:12 <strong>\n</strong>Yeah, exactly. And really, if we think a little bit further out than 6.2, this could also house setting to use. So we do have, you know, one view here that that is relative to 6.1, where you can see all of your different templates. But imagine if we had any other different types of settings and controls and different pages loaded within here, doesn\'t have to be just the front end templates and renders of your site.\n\nAlright, so we\'re gonna dive into this here. So you can go into it just by clicking on the frame. I\'ll do that one more time just to show, you just click on it. And now you entered right into it. You can edit it right off, so we can make changes, just as if we zoomed into it in the other way in 6.1. And then we have a bunch of styling tools that have been added to 6.2, so I want to kind of hone in on these. Like, this panel itself is not new. We have style variations, you can zoom in here, we\'ve got this new zoomed out view, where you can apply different ones at a time. And then we also have this icon here, which triggers the style book. Now the style book is a very interesting tool here that really lets you customize the theme\'s style guide, essentially. So I can go through each of these tabs, which are relative to the block categories, and see all of the blocks loaded on this particular site. So right here, I\'ve got like Button blocks and Columns block and whatnot. So if I click on one of these, it\'ll pull up the Style panel of that particular block. And then when I make changes over here, these are applied globally throughout my entire site. So if I want to change the way this button looks, let\'s say we do some smaller tags, maybe we\'ll add a little bit of letter spacing, and maybe make it capitalized. See, it\'s getting applied everywhere that the button is used. Also do some changes here to padding, perhaps. We\'ll do something custom here. I think that looks nice. And now...\n\n<strong>Anne McCarthy </strong> 8:13\nReal quick while you\'re doing this, I wanted to note that like this is something that folks have really struggled with previously with the site editor, where if you\'re editing a block that isn\'t in the template already, you\'re not able to see this. So as Rich is showing, you can actually look at any block that\'s being used in your theme and see how the change that you\'re making in styles will impact that. Where before, if the block wasn\'t present in that template that you were editing, it was hard to know exactly what was happening. And so now you have both the style book and this inline preview that you see in the Style section to rely upon, which is pretty neat.\n\n<strong>Rich Tabor</strong>  8:43\nYeah, exactly. And really, you could theoretically go in and design your entire theme with the style book. Now, I know there\'s some advantage to design in context of pages and whatnot. And I\'ll go into that in a bit. But the idea is that you really can quickly browse through all of the different blocks and tighten up what you want to within these controls. And it\'s not limited to the standard variation as well. There\'s also these style variations of each block that you can now manipulate as well. So we\'re gonna go in, say, we\'ll change the radius of this one. So we want it to be sharp like our other button. But we have these new controls. Like, this is a shadow control we\'ve added in 6.2, where you can apply, say, like this shadow here might be nice. This one here, and so some fallback shadows, within core that a theme can provide as well, its own values. But this now will apply for every single variation of the outline on my site here.\n\n<strong>Anne McCarthy  </strong>9:39 \nAnd you\'ll notice that it\'s not in the style book right now. And that\'s just part of the future feature development is showing the variations of blocks as well.\n\n<strong>Rich Tabor </strong> 9:47\nExactly, yes, I would imagine that this would this would show up the variations of the button block, yeah. Which is a nice way to really customize these, like it used to be only CSS would be used to manipulate these variations here. And now it kind of abstracts that away and you can do it within the editing experience. That\'s really nice. It really is. There\'s also this idea of block CSS, so you can add custom CSS that is scoped to a particular block. So if I add CSS here, it\'ll be applied for the button block wherever it\'s used. Now, I wouldn\'t recommend using additional CSS in most cases. I would, I would suggest using all the different controls that we\'ve built, that are built into 6.2. But the idea of using CSS to add a little pizzazz to this particular button block is fine. But just with that caveat that you wouldn\'t want to use it exclusively. Like I wouldn\'t apply a background color via CSS, I would rather use the background elements color here. There\'s also additional CSS, which emulates what was previously in the customizer. So we do have site wide CSS that can be applied within the site editor and also on the front end of your site. Again, I wouldn\'t emphasize using this exclusively, as there are a lot of new design tools that I would explore first, from the top level styles here where you can apply colors to the background, text and buttons. But if there was anything extra you wanted to add, you could do so within the stylesheet here.\n\n<strong>Anne McCarthy </strong> 11:21\nAnd I\'ll note we\'d love to hear feedback if there are certain things that you\'re repeatedly adding custom CSS for. So either commenting on a currently open issue, or if you don\'t find one, opening an issue would be super helpful, because it\'s neat to see what folks are using for CSS so we can fill those gaps.\n\n<strong>Rich Tabor </strong> 11:36\nYeah, exactly. So that\'s the global Style panel here. But there are some quite a few other improvements along with styling. So the first is the idea of pushing styles globally. So if I\'m in here, and I\'m designing, let\'s say I want to add a radius, I want to do some different typography as to appearance like this, like bold, italic look. And then we\'ll also...\n\n<strong>Anne McCarthy  </strong>12:07\nThat\'s cool.\n\n<strong>Rich Tabor  </strong>12:07\nThanks. Also, let me make the letter spacing, maybe we\'ll make it a little bit bigger, actually, and then, I think that\'ll work. Do these changes here and see I\'ve just styled this one particular block this button up here. And this button down here is still using the global styles that we designed earlier. But now I can go through my settings panel here and hit Apply globally. And I\'m going to here so we can see that happen. The styles are now pushed globally to all the other blocks. So this is really helpful for when you\'re designing in flow. And you don\'t necessarily want to abstract out into the style book and you want to push your changes that you just did here, because you like the way the button looks and want those applied everywhere, all at once. I think this is really powerful way to to quickly design within the editor. Another tool that is quite useful, I\'m going to take this heading here and manipulate this. It\'s the idea of copying and pasting styling. So we\'re going to use that same bold italic look, maybe we\'ll make that a little smaller, we can even manipulate this size to be a little bigger. Now we go here to copy styles. And then I can come all the way down here to this other heading that\'s very similar, and paste it in. And there we have that style applied just to these two headers. And you would do this when you don\'t necessarily want every single heading to have this effect. But perhaps there are like elements on this page that you want to push those changes to, specifically. So copying and pasting allows you to be very granular, whereas applying styling globally, lets you be more of a holistic design experience for pushing styles. Another neat...\n\n<strong>Anne McCarthy  </strong>13:57 \nOh, real quick, I just wanted to know like I think one of the things that\'s interesting is, as we\'ve added more design options to blocks like this is part of the experience of scaling things and making it easier to use. So when we think about like intuitive and delightful. Some of these tools coming into 6.2 really take you know, the tons of design tools that we\'ve added over the last couple releases and makes it easy so you can actually tweak things and then reuse. So I think that\'s one of the things I want to call out is it\'s kind of this crescendo. Where now the tools that are coming to 6.2 to really ease the experience and allow you to do a lot of neat stuff where rather than having to re-tweak everything through every single heading block. A lot of stuff is used. So...\n\n<strong>Rich Tabor  </strong>14:34\nYeah, exactly. WordPress is moving towards a design tool and less of like, what you see is what you can only have. It\'s more of an expression of creativity and it really does open up the doors for for designing beautiful pages on the web. I think it\'s really powerful.\n\nAnother cool bit that we\'ve added is the idea of sticky positioning. So headers would be nice sometimes if they stick to the top, so for top level group blocks, this is a group block here, there\'s this new position attribute where you can assign it to sticky. And as you can see, right in the editor, it\'s already showing me that this is sticky on the front end. And also here as well. It\'s only available for top level blocks for now, there\'s still some some odd stuff to figure out on how we communicate when something is not going to stick due to the the parent height of the elements around it. But for top level, it\'s still fine. So we have it here. But there are some iterations that are already happening for the next release that will kind of bring this into more, bring some more capabilities to this particular feature.\n\n<strong>Anne McCarthy  </strong>15:44 \nYeah, and I\'m very excited because one of the things I wanted to briefly call out was the how the header, the template part has that purple. So another neat thing coming to this release, that was a big part of feedback for the outreach program was having to look parts and reusable blocks having a different coloring, because there are different kinds of blocks are synced across the site, when you make little changes and impacts everything everywhere. So that\'s another neat thing that\'s coming with this release, is that you can kind of see those a bit differently in the List view as well as when you\'re in the editor. I see Nathan has his hand raised. Is that intentional? Oh, it\'s removed. Okay.\n\n<strong>Nathan Wrigley </strong> 16:23 \nIt was not intentional. That\'s my mistake. I\'m sorry.\n\n<strong>Rich Tabor </strong> 16:28 \nYeah, it helps you see quickly too like, what is the template part, particularly for headers and footers, it makes it easier to browse quickly.\n\nSo speaking of template parts, and patterns in particular, so headers and footers, are new patterns added within WordPress 6.2. And now that they\'re loaded, actually from the pattern directory, which is kind of neat. And I\'m going to show you how to replace a footer with one of those other patterns. So if you have your footer template parts selected, you can go to replace footer. Now this flow is not new to 6.2, but it\'s going to call out these other improvements. And then you just click one there, and you have it loaded here, that\'s the site logo that I\'m using up here as well. And you can modify this text without having to do any any funky PHP filters or moving actual templates. And if you want to change it again, you go back to replace say, let\'s pick this other one, let\'s try this one. It\'s kind of nice. And there\'s this focus view, or you can zoom in to just the footer itself. You can even check the responsiveness of it and see how it, how it reacts on mobile, and make any of your changes here and have those persist over to the actual template whenever you close it out. It\'s a nice way to really kind of clean up the editing experience. So you\'re not seeing this entire group of groups and instead kind of focusing on what you\'re actually wanting to complete. You can do the same for the header as well.\n\n<strong>Anne McCarthy  </strong>18:01\nYeah, and as Rich mentioned, there are some new patterns that are being bundled from the directory, which I think are really extensive. Regardless of what theme you\'re using, there\'s going to be some pattern for group patterns that help democratize design where you can use them in anything.\n\n<strong>Rich Tabor  </strong>18:15\nYes, that\'s right. All right. So navigation. Navigation has gone under a... quite a bit of work in the last a couple of months. And really, this is all about trying to make it easier to manage your site\'s navigation and also add pages and links and then even styling. So there\'s this new dedicated list view for the navigation block. So it\'s essentially emulating a little bit of what\'s available over here except for you had to kind of get down to it. Now it brings it top of mine and the surface area here. You can drag them around, move them up and down, even add submenu links and remove them as well. And then you can style it like normal. And now apply different styles via the styles tab to the block itself, or even individual page links and whatnot, you can dive into them and manage them all from here, instead of having to only manage them from up here. This really kind of abstracts the complexity from from this particular canvas interface into a more familiar interface here on the sidebar. It\'s really a great effort. And it\'s it\'s taken some time to refine but it\'s getting there and it\'s feels a lot nicer.\n\n<strong>Anne McCarthy  </strong>19:30 \nYeah, there\'s been a lot of good feedback about this as well just because it kind of is meant to marry the classic experience with bringing blocks into it. So it is in addition to being edit, editing on canvas, so if you really want to continue to edit as a block you still, you can continue to do that. But it does add a nice interface and the block settings where you\'re able to do it. And I\'ll briefly call out here the split settings, which we\'ll probably talk about later. But you\'ll see here for more complex blocks, there\'s some nice split settings making it a little bit easier, more intuitive to go through.\n\n<strong>Rich Tabor </strong> 20:02\nYeah, that\'s right. And if you take a look at navigation here, this is very similar to this component added here. And, and that\'s, that\'s purposeful, we want it to look and feel familiar. Either way you\'re managing navigation. So you can also add some menu items here, remove them and drag them around and reset them here, as well as browse into the individual pages. So that\'s what I have for the site editor portion of the demo. And did you have anything else you wanted to add to this, Anne?\n\n<strong>Anne McCarthy  </strong>20:37\nOh, could you resize the Browse mode for me? I just love the resizing. I think it\'s kind of cool. This is just like a fun, you know, thing to call out. But maybe you won\'t noticem but you can resize it. So as you\'re quickly going through your site, if you want to see how it looks in different ways, you can also do that. So that\'s the final thing I\'ll shout out.\n\n<strong>Rich Tabor  </strong>20:56\nYeah. So then, yeah, exactly. It\'s... there\'s a lot of fine, fine touches like that. Well, we can\'t obviously can\'t call them all out today. But it is really getting tightened up overall as an admin experience for the site.\n\n<strong>Anne McCarthy  </strong>21:12\nIt\'s such a great foundation in the future, for sure.\n\n<strong>Rich Tabor </strong> 21:15\nExactly, exactly. Alright, so if we press this back button here, it goes right back to the dashboard, I\'m gonna go and leave...\n\n<strong>Anne McCarthy </strong> 21:25\nThat back button was a big piece of feedback people had they would get into the site or not know how to get back out. So I appreciate you calling that out.\n\n<strong>Rich Tabor  </strong>21:32\nYeah, exactly. It\'s been through a number of iterations. And I think we\'ve settled on something that feels feels nice; it does feel nice.\n\n<strong>Anne McCarthy  </strong>21:41\nI agree.\n\n<strong>Rich Tabor  </strong>21:43\nSo...\n\n<strong>Anne McCarthy  </strong>21:44\nAh yes, the removal of the beta label.\n\n<strong>Rich Tabor  </strong>21:46\nYou want to talk to this, Anne?\n\n<strong>Anne McCarthy  </strong>21:48\nYeah, I would love to jump in on this actually. So you\'ll notice that the beta label is removed for this release. And part of why we wanted to show it now is to see how all the features, how the experience has changed, how much more you can do. And all of that has led to the removal of the beta label. And that doesn\'t mean that feature development is done that it\'s like, you know, gonna stay this way forever, it just means it\'s in a place where we invite you all to try to the site editor, it is out of beta. And a lot of development work has gone into testing this. So we\'ve had almost, I think, 20 calls for testing with the outreach program. It\'s been through multiple major WordPress release cycles, there is still more work to be done. But I\'m very excited to see the beta label removed, I think the features that are coming to 6.2. And the foundation that is set with 6.2 really marks a level of maturity. That is pretty exciting. So consider this an invitation to try out modern WordPress, and to check it out.\n\n<strong>Rich Tabor</strong>  22:43\nA hundred percent, I couldn\'t have said it better.\n\nAlright, so another neat part that\'s added recently for 6.2 is this idea of distraction free mode. So it\'s not turned on by default, but I have it on so we can see the results here. So you can go in and type right here. And then actually, I\'m gonna throw in some Lorem here. So you can see it in action. So this feels more like a text editor and less like a Block Editor. Whenever distraction free mode is on even the the multi block selection, it feels really nice. It doesn\'t there\'s not this idea of blocks, even it\'s kind of abstracted from here, there\'s less noise, there\'s less distraction. And just think that the idea is that it\'s just you and your words, it\'s just writing and publishing. And if you want to publish, you can hover over here, you\'ll see the toolbar come down, you can hit Publish or draft. And then this is how you would turn it off and back on here. And then you still have control of all the existing tool. And it\'s just a much simpler, streamlined interface. And you do have access to blocks, you can still add them if you\'d like to, but the idea is just being able to write without the distractions is really powerful. And a really nice publishing experience overall.\n\n<strong>Anne McCarthy  </strong>24:08 \nAnd this is for everyone. So this is like a lot of stuff we\'re coming to say it or using a block theme. This is available for anyone who\'s using the Block Editor. And to be honest, I use this for basically all my writing now. Especially for any post or page, I typically will go into this mode. So I\'m very excited about this. And I hope folks feel the same way.\n\n<strong>Rich Tabor  </strong>24:28\nYeah, exactly. I\'ve been using that too for quite a bit. But the thing is, is also not only for post editing, so I have a page here that I\'ve created. And I have distraction free mode turned on, which kind of removes all the extraneous tooling and it really lets me focus in on the actual blocks here so I can manipulate them to an extent. I can even drop in different imagery for these images here and modify the buttons and whatnot and even add more blocks but the idea is it\'s almost like a simplified editing experience for pages as well, not only for posts. And here, I\'ll come up here and turn off distraction free mode to see it all in real time.\n\n<strong>Anne McCarthy  </strong>25:13  \nAnd this isn\'t yet available for the site editor, but I have a feeling a number of folks are going to be keen to see that put in there as well.\n\n<strong>Rich Tabor </strong> 25:20  \nExactly, yeah, I don\'t see why it wouldn\'t work in the site editor as well. I think it\'d be very nice. Yeah. So we have some other improvements here that are fun. So this inserter here has gotten a couple of changes here. So blocks looks familiar, it\'s still the same, but patterns is where we started seeing some changes. Instead of having some featured patterns loaded in a block category selector, we\'ve split them out individually as their categories here, you\'re gonna load up some of the different header patterns that are loaded in WordPress 6.2. So you can load them here and see them in this tray, and then click to add them to your site. Which is really nice, it\'s a nice way to kind of go through them quickly and see a bunch of different ones. We also have the media tab up here, which is new, which splits out the images from your Media Library, videos, and audio as well, including the Openverse library. So this is a catalogue of, I believe, over 600 million free, openly licensed stock imagery. And you could search from right here in the inserter. So let\'s type in birds. And click on one, and it will add an image block with the image already added to it, we have got the caption down here. If you don\'t want the caption, you just turn it off right here, this little control that was added. And now you can manipulate it right off. So let\'s say this, drop it into here. Maybe we\'ll make these about the same size and move it over to something interesting.\n\n<strong>Anne McCarthy  </strong>26:53\nAnd I\'ll note that there was a GDPR concern around the images being properly uploaded rather than hotlinked. And I wanted to just note that that\'s been addressed. So the images are uploaded to your Media Library. That\'s why. So in case anyone has that question. Sorry, continue.\n\n<strong>Rich Tabor  </strong>27:08\nYeah, no, that\'s a good point. It\'s very important. A key benefit to have this flow here is that instead of instead of having to add an image block, and then open your Media Library, and then pick an image, and then you have it here, it\'s really this one flow of searching visually, and searching here, as well. And then having it added as an image block already. So it kind of skipping all the extra steps that you always have to do anyhow, it\'s really nice. And we have a couple of interface changes. So there\'s the settings icon up here that used to be a cog, and now it represents the sidebar itself. So when you open it, the sidebar is triggered, if that\'s closed. And that\'s changed for a couple of reasons. But one of the bigger reasons is, as I mentioned earlier, this idea of split tabs, so we have the cog for settings. And that\'s when a block has additional settings that are not per the norm of the styles that are available within WordPress, then you\'ll have a new settings tab pulled out here. And that\'s to keep the density nice whenever you\'re editing and it feels good instead of having everything kind of in your face all at once. Now for other blocks, like the paragraph block, there\'s not additional settings, so automatically not included. The tabs up top and just be everything top level. But  when a third party plugin adds like a different settings panel, or even if you extend one of these core blocks that does not have one, and a detects one should be auto added as well. So it\'s kind of just like a nice, fluid way to continue improving the experience of editing within WordPress.\n\n<strong>Anne McCarthy </strong> 28:49\nYeah, so plugin authors can also kind of make sure where they want settings and styles to show that it shows up correctly. And there\'s a dev note about that as well.\n\n<strong>Rich Tabor  </strong>28:58\nYes, that\'s right, you can you can decide as when you\'re extending or adding your own inspector controls. That\'s what these are called here, whether or not they\'re included within styles or settings as well. Yeah.\n\nThen another smaller change that\'s kind of nice is this idea of pulling the outline from its own toolbar item up here into the list view. It\'s because they\'re very relative, you know, a list of all the blocks on your page, also an outline of what\'s going on. So they\'re combined now into this one view. We also have time to read word count and character count here, which is nice. And then this is a little guide here that just helps you understand the structure of the importance of the structure of the document and making sure that it is properly structured. All right, was there anything else that we wanted to add you think, Anne?\n\n<strong>Anne McCarthy  </strong>29:51\nI\'ll add one last call out just because I\'m trying to think about like little dev tidbits if you want to disable it prefers there is a way to disable Openverse as well I know that\'s always a concern. We add something it\'s like, okay, how do we get rid of because I don\'t want a client getting into it, there is a way to disable that is documented as well. The other thing is the pattern. So there\'s new categories, the patterns. And so query is now posts, a couple of things were merged, there\'s no call to action. And there\'s also some lovely, which I\'m gonna brag on Rich, again, some new text based, query patterns. We have a lot of visual patterns for the query loop, and now there\'s wonderful, more text focused ones, which I think is really exciting. And just another great way where patterns have evolved and patterns is obviously a huge part of the future building with WordPress. So I\'m very excited about those and keen to see just more variation with query loop, I think it\'s really powerful block to make easier to use. So I\'m excited to see it. Otherwise, I think that\'s, I think that covers a lot of what we were trying to go through.\n\n<strong>Rich Tabor </strong> 30:57\nYeah, and there\'s certainly more. There\'s a lot of interesting, minute details that are, you know, quality of life improvements around editing and designing. And we can\'t cover them all today. But it\'s just, there\'s a lot of exploratory ideas and cool, interesting pieces that have been the result of lots of feedback and lots of testing, like I mentioned earlier. And, you know, it\'s really a testament to open source and contributing and really working together as a team to make this thing we call WordPress ours and making it a brilliant publishing experience. So just thank you to everyone who\'s put in time ideas, effort, code, design, marketing, copy, all of that, and more to making this what it is. It wouldn\'t be possible without you.\n\n<strong>Anne McCarthy  </strong>31:46\nTotally agree. And thank you, Rich, for doing such an excellent job building this site and demoing all this.\n\n<strong>Nathan Wrigley  </strong>31:51  \nYeah, indeed. Thank you, Rich. Thank you, Anne. Just to let you know that, in theory, there\'s possibly up to about 25 minutes left. If anybody wishes to pose a question, we\'re going to do our best to get the answer directly from Rich and Anne. Whether that means putting the screen back on, I don\'t really know. But we\'ve got a few that have come in. The place to put those, it would appear that some people have figured out how to do that in Zoom. But if you go to the walkthrough channel, in the making WordPress Slack, you can post some questions in there and all things being equal, we\'ll get them raised as quickly as we can. So we\'ve got a few. In all honesty, because they\'ve been copied and pasted from various different places, I can\'t necessarily say who the name of the person is that sent them. But first question I\'ve got over here for either of you. It says when you save globally, under the Advanced tab, does this change the stylesheet? Interesting.\n\n<strong>Rich Tabor  </strong>32:54 \nSo this will change the attributes of the blocks. So if I throw in that example, there, I pushed the attributes of that one block globally. So they\'re applied to every block. So it does affect some styles, but not writing any style sheet or writing to the core style sheets.\n\n<strong>Nathan Wrigley  </strong>33:11\nCan I ask the question? It\'s not something that\'s been submitted by anybody else, but it just occurred to me that as you were clicking the global button, I just wondered if there was a \"get out\" from there. In other words, if you inadvertently click the global button, is there an undo option in there? In other words, can you back away from all of the buttons suddenly changing or all of the H1s? \n\n<strong>Anne McCarthy  </strong>33:32 \nYou do have to hit save after. You can\'t just hit Apply globally. You have to hit save, and that\'s where the multi-entity saving pops up. The multi-entity saving is kind of strange in that it\'s not good at discarding changes. So you basically would just have to like leave. Like it would be like, Whoops, I hit that. You probably also have to hit the undo. Like there\'s - those are the two kind of options. So, yeah.\n\n<strong>Rich Tabor </strong> 33:54 \nYeah. The undo is like a global thing. It works there as well. Yes.\n\n<strong>Anne McCarthy</strong>  33:58 \nAnd there\'s a reason that feature is hidden, like under Advanced and collapsed. That\'s not necessarily for everyone. But for folks who do like to tinker, it is available.\n\n<strong>Rich Tabor  </strong>34:08  \nRight. And it\'s also only available in the site editor as well. So it\'s the more the global view of editing your site is where you can access that. \n\n<strong>Nathan Wrigley  </strong>34:17  \nPerfect.\n\nOkay, so I have a question from Zoom. Is copying and pasting styles as demonstrated just for core blocks? They go on to say more, which I\'ll read out. Some blocks collect, some block collections have their own C&amp;P, and I\'m curious what might carry over, if anything? And then there\'s a follow up. Also, if CSS classes are assigned to a block, will applying global styles to a block be to all of the same block, i.e. H2? Or, hopefully, will a custom class allow for a more granular global CSS? There\'s a lot in that question, but if we start with the: is copying and pasting styles demonstrated just for core blocks?\n\n<strong>Rich Tabor  </strong>34:56  \nSo it works for blocks that have leveraged the block support system within core. So if you have opted your block into using background color, and text color, link color, any of the layout settings, anything that was in the styles tab, then all of those would get pushed to or get copied or pasted or even pushed to the global application of styles as well. Now, if there\'s, if a block has done its own sort of background color attributes, I don\'t know that those would persist as well. But if you use what\'s available in core, it\'s really one or two lines of JSON will get you the background color support that you need. \n\n<strong>Nathan Wrigley</strong>  35:35\nAnything to add to that, Anne?\n\n<strong>Anne McCarthy  </strong>35:37  \nNo, just another reason to rely on what core is building. So it\'s a another great example of how these features will work together and how adoption helps whenever these new things come out.\n\n<strong>Nathan Wrigley  </strong>35:49  \nOkay, so we\'ll go on to the next question then. So this is from Zoom, and apologies, I don\'t know your name. Can we have this as a feature request? Can we have sticky sidebar block for some groups next release, please? \n\n<strong>Anne McCarthy </strong> 36:05 \nProbably would do a separate block, I\'m guessing. Yeah, do you have anything to add to that?\n\n<strong>Rich Tabor</strong>  36:11\nYeah, I would say we wouldn\'t need a sticky sidebar block. Right now that group lock in top level-only does support position sticky. And the only reason it was turned off like we did have it on for one of the Gutenberg releases for everything - for every group block - but it was turned off just because there was too much confusion around if you had a sticky element that wasn\'t didn\'t have enough space to stick for and enough height to stick. So it wouldn\'t actually be sticking. You wouldn\'t see a result of you applying a sticky position to it. So I think we can figure that out with some some UX to really clean that experience up so that you do expect and understand what\'s going on. When you apply that to a block. That\'s not the root level of the document. So it\'ll be there. It just takes a little bit more iteration.\n\n<strong>Nathan Wrigley</strong>  37:00\nOkay, another question. This time from Slack. When there are changes made in the site editor, are the templates still marked with the blue dots to indicate that the changes are in the database?\n\n<strong>Rich Tabor  </strong>37:14\nYes, from that Manage Templates view that I shared in the canvas, it will show up just like it did previously, when there are changes to one of the templates provided by the theme.\n\n<strong>Anne McCarthy </strong> 37:25\nYou can revert the changes, as well, as you\'re used to doing.\n\n<strong>Nathan Wrigley </strong> 37:30\nOkay, thank you. Anne\'s shared a link related to the question that we just posted. I don\'t know how Zoom works well enough to whether or not we can share the screen. \n\n<strong>Anne McCarthy  </strong>37:40\nI can briefly share my screen. \n\n<strong>Nathan Wrigley  </strong>37:42\nYeah, that\'d be great. Show us the GitHub.\n\n<strong>Anne McCarthy </strong> 37:43\nLet me try that. I just wanted to mention this in case people want to follow along in the follow up tasks related to this. I love to look at links. I\'m a nerd like that. So in case anyone else is, this is a lot of the follow up tasks and a great issue to chime in on or just follow if you\'re interested in this because there are some improvements to be made. But this is a neat report for now. So it\'s - oh, I just copied and pasted. So it\'s issue number 47043 in the GitHub repo.\n\n<strong>Nathan Wrigley </strong> 38:11\nSo 47043 related to the question that we just had. Okay, so another one from Zoom. This is Robin, who asked the question, can you show? It\'s just moved on my screen. There we go. Can you show us how to trigger the focus mode to view, say, for example, the footer on its own? So I guess we\'re back on the screen again.\n\n<strong>Rich Tabor  </strong>38:34\nSure. Everyone can see? Yep. So when you have a template part selected, you just hit the Edit button here and then it\'s focused into that as well. And then you have, again, the responsive controls here. All the existing controls, it\'s just localized to this template part.\n\n<strong>Nathan Wrigley  </strong>38:54\nHopefully that answers your question. Thank you, Robin. Just for anybody who\'s kind of lurking who has a question but hasn\'t yet posted it, please do. What are the chances that you\'re going to get Rich and Anne on the on the phone in the next few weeks? Pretty minimal, I\'d say, so make use of them while they\'re here. Ellen has done just that. She\'s in Slack. Ellen says, is there a plan to allow no title templates in the block editor as they are still included even in header and footer-only templates?\n\n<strong>Rich Tabor</strong>  39:28\nNo title templates. Like templates without a title? I\'m not quite.\n\n<strong>Anne McCarthy </strong> 39:35\nYou can just remove that block. \n\n<strong>Rich Tabor  </strong>39:36\nYeah, you can you can remove the post title block from a template. I\'m not quite sure if that\'s if that\'s what the question is asking.\n\n<strong>Nathan Wrigley  </strong>39:46\nEllen, if you\'re still in Slack and watching this, if you heard Rich and Anne queerying that, then if you can give some more clarity, we\'ll endeavor to get that answered.\n\n<strong>Anne McCarthy</strong>  39:57\nKnowing Ellen she knows exactly how to remove things. So I\'m like, I\'m curious. I\'m definitely - we\'re misinterpreting something because she\'s very - Not showing the title in the editor...?\n\n<strong>Nathan Wrigley  </strong>40:07\nYeah. Not showing the title in the editor. She says she\'s here. \n\n<strong>Anne McCarthy  </strong>40:12  \nI\'m like, \"Say more.\" \n\n<strong>Nathan Wrigley </strong> 40:14 \nYeah. Give us more. Give us more Ellen, and we\'ll get right back to you.\n\n<strong>Anne McCarthy  </strong>40:17\nLet\'s follow back up on that, because Ellen always has some good questions and good feedback.\n\n<strong>Nathan Wrigley</strong>  40:21\nAll right. We\'ll do just that. Again, another question from Zoom. This is posed by some anonymous person. Will the list views icon get the same treatment as settings?\n\n<strong>Rich Tabor  </strong>40:33\nI don\'t think it\'s in the plans. I don\'t think there are plans to change that. But list view icon, it\'s always the list view. So when you toggle it on and off, it\'s relative to what it is. Whereas on the other side, the settings can be block settings, page settings, template settings. Global styles is in that same area. So it\'s a little bit more context for the list view to stay a list view item.\n\n<strong>Anne McCarthy  </strong>40:58\nAnd I know that the question came up because the settings icon looks like there\'s that sidebar. And so there are who people have been asking like, will the same thing happened over here? Just for context. That was part of a discussion in a different GitHub issue.\n\n<strong>Nathan Wrigley </strong> 41:12\nOkay, thank you very much. I appreciate very much those people who are posing questions. That\'s really great. Again, just to prod you once more, feel free to add your own questions in no matter how big or small they are. We\'re here to help. So now we have a question on Zoom from Abdullah. And he coincides beautifully with a question I\'ve written down. Any good resources to learn FSE theme-based development? Can either of you point to a particularly good resource that you know of?\n\n<strong>Anne McCarthy  </strong>41:41\nYeah, Learn WordPress. There\'s tons of stuff on Learn WordPress that I would recommend. I also, Daisy Olson, who\'s Developer Relations at Automattic, has a Twitch stream going and some YouTube videos around block theme development. But I would recommend going to Learn WordPress. There\'s also some contributor-led initiatives. Carolina, who\'s one of the theme folks has, I think, it\'s fullsiteediting.com. And that was kind of like the original, go-to resource. And she\'s done an incredible job working on that and keeping it up to date. So yeah, there\'s tons of tons of resources. I will spare you from from sharing more, I don\'t know, Rich, you have more hands-on experience there. What\'s the most helpful for you?\n\n<strong>Rich Tabor</strong>  42:22\nYeah, there\'s some really great tutorials and guides on Learn that are relatively new, that are really helpful. And I see that the team there has been really cranking it out on the last year or two, like really putting a lot of effort into this. So I would, I would start there.\n\n<strong>Nathan Wrigley  </strong>42:38\nSo if you\'re not familiar with that, I guess it would be apropos to say go to your browser of choice and type in learn.wordpress.org and go and explore. Basically, there\'s a ton of materials that are getting updated on what feels like a daily basis at the moment. So, once more, learn.wordpress.org. Go and check that out. But also, Anne in the chat that we\'ve got going on here has linked to Daisy Olsen\'s Twitch channel, which - I\'m just going to read it out but hopefully I\'ll make it into the transcript. twitch.tv/DaisyonWP. And it\'s all one word. D-A-I-S-Y-O-N-W-P. Daisy on WP. So there\'s two great places to go. But the learn.wordpress.org is perfect.\n\n<strong>Anne McCarthy </strong> 43:24  \nI have to add one more thing, which is if you\'re not fully ready for block themes, one of the big things that I feel like needs to be emphasized more is you can gradually adopt. So all these features are being done. But maybe you want to only give access to a client to edit the header. You can do that. Maybe you want to leverage theme.json in your classic theme, you can do that. If you want to expose the template editor.\n\nBut use the rest of your themes across them, you can do that. So I want to also encourage folks to look into resources around gradual adoption, because it makes sense that this stuff isn\'t - From day one, there has been a focus on that. Adopt what you what you want, when you want and it\'s going to make sense to different people at different times. Matías once said that to me, and I think it rings really true. And so now that we\'re at this level of maturity, I think we\'re looking again and revisiting again, like okay, what can I use? What do I want to use? I think it\'s really important to mention. So if you\'re not ready to go all in, I encourage you not to just wipe it all away, but to think about how you can gradually adopt and also what would help you gradually adopt. So there is actually a label on GitHub started a couple months ago around - It\'s called blocks adoption. So if there\'s something that you see that you\'re trying to adopt the site editor, and it\'s preventing you from doing so, like we want to know about that. And you\'re welcome - I\'m going to just put this out here - @annezazu is my GitHub username, feel free to just like @ annezazu, \". This is blocking me from using the site editor.\" We want to know these things. Open issues. Please share, because that is also part of the phase of this work is making sure people can adopt as they can and that the tools are robust. There\'s a ton of resources as well. There\'s a page in the Theme Handbook around gradually adopting to block themes. So I just wanted to call that out.\n\n<strong>Nathan Wrigley </strong> 45:06 \nAnd just one more time, what was that? Give us, the give us the username.\n\n<strong>Anne McCarthy  </strong>45:11<strong>\n</strong>A-N-N-E-Z-A-Z-U. So like Zazu from The Lion King. It\'s an inside joke from middle school.\n\n<strong>Nathan Wrigley </strong> 45:19\nOkay, possibly the shortest question. This is from Sandy, I should say, Can Lotties be added to 6.2?\n\n<strong>Rich Tabor</strong>  45:28\nI would say that I did a quick search a few minutes ago and there are various blocks built by the community, which do allow you to add or embed LottieFiles to your site. I haven\'t tested any myself but feel free to dig into those. And if they\'re open source, they can contribute ideas or feedback on on those GitHub repos.\n\n<strong>Nathan Wrigley </strong> 45:49\nThank you very much. And Eagle has posted a question. When there are changes made in the site editor, are the templates still marked up - Did we have that one? We have, right? We\'ve done that. \n\n<strong>Anne McCarthy </strong> 46:01\nWe answered that one. Yeah.\n\n<strong>Nathan Wrigley</strong>  46:02\nI think we did. Okay, moving on directly then to Ian, what is - oh! Okay, what is the philosophy for mobile in the editor? Are there any plans to have a mobile view?\n\n<strong>Anne McCarthy </strong> 46:16\nThat\'s part of the dragging and resizing. And there\'s a lot of work being done around intrinsic design. And you can see on the developer.wordpress.org? What is the blog? I think it\'s /news. Do you hear audio?\n\n<strong>Nathan Wrigley  </strong>46:35\nI hear only your audio. I don\'t hear anything I don\'t wish.\n\n<strong>Anne McCarthy</strong>  46:36\nOkay, sorry. Something just started playing in the background out of nowhere and that just scared me. It\'s like all of a sudden, I was like, woah! Where was I?\n\n<strong>Nathan Wrigley </strong> 46:50\nSo we were talking about mobile views?\n\n<strong>Anne McCarthy </strong> 46:53\nYes, intrinsic design. There is a developer blog that if you\'re not following that, you definitely should, that addresses this around, basically showing that the mobile view points have exploded over time. It\'s now really not sustainable to try and have CSS and all this sort of stuff, mobile queries allowing for each view. So instead, how can we think about intrinsic design? And so that\'s like the best answer I can give. And for now, there is this nice resizing that you can do to kind of see how things scale. 6.1 introduced fluid typography, which was really exciting and part of this larger, intrinsic design set up. And I think we\'ll expect to see more of that over time. Sorry, for the brief mental break.\n\n<strong>Nathan Wrigley  </strong>47:36\nJust a quick reminder, we probably got 5, 6, 7 minutes or something like that before we start to wrap things up. So if you\'ve got any questions, please, please do post them in here. We have one from Paul who asks, is there any more work planned for pattern management in the future? And then WP Engine has released a plugin allowing easier management of patterns recently, I believe that was yesterday, it would be good to know if we should wait for core or assume that nothing else is coming soon.\n\n<strong>Rich Tabor  </strong>48:07\nYeah, I would say that pattern management is an important part of this new WordPress experience and having a way to create and manage local patterns, but also maybe push them to the pattern directory. And then on top of that, having a functionality built in where - it\'s kind of like a component based system where you have patterns where the design is the same across patterns, but content can change. All of that kind of falls into the same category of work. And that is something I believe WordPress will eventually do as well.\n\n<strong>Nathan Wrigley</strong>  48:41\nOkay, we\'ve got no more questions on the screen. So I\'m going to ask a question, if that\'s all right. You were demonstrating the distraction-free mode there where you could move things up, move things down, and resize pictures and images and so on. I was just wondering what the constraints on that are. So in the case of images, I could see that you could resize things. And with the text, I could see that you could, you know, highlight things and start typing wherever you wish. But I just wondered how the decisions had been made to set those parameters and those only. So yeah, around that, what\'s available in distraction-free mode? What limitations are there?\n\n<strong>Rich Tabor  </strong>49:17<strong>\n</strong>I would say, generally, it\'s what\'s available is what happens when you click on a block. The tooling is there available on the canvas before so resizing was available on the image but not the toolbar. So the resizing is still available when you\'re in distraction-free, but maybe not adding the caption piece or you know, those other toolings. It\'s almost like the content locking or content only locking API. It\'s very similar to that in a sense, but a little bit more tightened up.  Where just text and dropping in images - you can\'t necessarily open the Media Library from there unless you dive out of it. But you can drop another image onto that existing image to replace it. Some things like that.\n\n<strong>Nathan Wrigley  </strong>49:59<strong>\n</strong>It looks like a really excellent interface for people who just, well, want to concentrate on their writing. It sounds like Anne\'s all in on it.\n\n<strong>Anne McCarthy</strong>  50:05\nI use it every single day. It\'s amazing.\n\n<strong>Nathan Wrigley </strong> 50:09  \nIt almost felt like a Google doc minus all the bits and pieces at the top. Yeah, really, really nice. Okay, so we have some more questions. Weston is asking, what about optimizing the experience of editing using a mobile device on the web? So I guess that\'s a little bit maybe the question that we had earlier. How can... we how can we do things on a actual mobile device? \n\n<strong>Anne McCarthy </strong> 50:30\nThat\'s a great question. There are mobile apps. So there is the mobile team and using the mobile apps. I personally don\'t use mobile apps and sometimes will edit things from Safari on my iPhone SE 2.\n\nI actually was talking to someone - their username is Nomad Skateboarding. And from what I understand, he only builds client sites from his phone. And so one of the things I said to him, I was like, \"Give us your feedback. That\'s really cool. It\'s really unique. That\'s fantastic. Like, what pain points you\'re running into, what can we improve?\" Because there is obviously like, we are in a mobile first world. My phone is sitting right next to me. I would love to hear particular pain points folks have when trying to edit in that way. You can obviously use the apps. There are some quirks with the site editor, and that I know is partially being looked into and resolved. But yeah, I think there are probably - what we\'re building now should always translate back and there are teams trying to sync back and forth. And there was a recent post from the mobile team talking about what\'s the future of mobile editing. And so I would recommend - it\'s somewhere on Make/Core. I recommend digging that up and getting involved and honestly sharing your feedback. Because I don\'t think that is an experience that we talked about enough personally.\n\nIt\'s a great question. \n\n<strong>Nathan Wrigley  </strong>51:40\nRich, anything or should we move on?\n\n<strong>Rich Tabor  </strong>51:42 \nI think that was great.\n\n<strong>Nathan Wrigley </strong> 51:44 \nOkay, perfect. Um, um, um. Okay, we have an anonymous question. It says as page speed is a big challenge, how are we optimizing the blocks for better LCP score?\n\n<strong>Anne McCarthy</strong>  52:00 \nThere are, some interesting - sorry, Rich, I don\'t know if you wanted to jump in. I was going to start link dropping. \n\n<strong>Rich Tabor  </strong>52:05 \nYeah, you go ahead. Yeah. \n\n<strong>Anne McCarthy  </strong>52:07  \nYeah, there\'s some interesting work from André. Part of it involves actually adding tracking and making sure there\'s really good front end metrics. So there\'s kind of a twofer going on. In one fell swoop, we\'re focusing on better tracking and improving the tracking that we have for performance, particularly the front end. And then at the same time, also work is being done to optimize like style sheets. There\'s been some really neat stuff in previous releases that I bet I can pull up if you\'ll give me one moment.\n\n<strong>Nathan Wrigley  </strong>52:36\nYeah, whilst you try to find that, Anne, I think it\'s probably important to say that, if there are any questions which you wish to have answered which don\'t somehow get answered in the next few moments, then there will be posts created around this piece. So anything that goes missing, any question that is unanswered, there will be endeavours to get them answered. Right? Okay, show us what you got, Anne.\n\n<strong>Anne McCarthy  </strong>53:00  \nYeah. So this was a post I did for 5.9, in conjunction with a whole ton of folks who contributed and actually did this work, I just was kind of gathering it up. But you\'ll see sections here around block style sheets and CSS loading. And honestly, a lot of the work with the styles engine, which is part of the global styles project, can help give a lot of opportunity to actually improve this, I recommend checking out this post to see some of what\'s already been done. And then in the future, one of the discussions that we had recently with some folks across the community from Google, from Automattic, 10up, all over the place, including our lovely performance lead, Felix. We talked about some of this stuff and about how to talk about particularly themes and also just blocks in general. And thinking about some performance improvements and developer education and automated testing and all sorts of stuff. So I won\'t go too far into this. But I think a lot of work can be done. And some of it is being done around measuring more front end metrics and very recently, LCP was added and started to be tracked here, which I think is pretty exciting. \n\n<strong>Nathan Wrigley  </strong>54:05 \nI think following the performance team and Felix Arntz, in particular, would possibly get you quite a long way towards your answers there. Okay, a couple more. Firstly, there\'s a few people helping out in the Slack channel. So, appreciate that. We\'ve got Matías answering questions, and so on. So that\'s really amazing. Thank you. Another anonymous question, any plans to support CSS Grid?\n\n<strong>Rich Tabor  </strong>54:33 \nI think it\'s something worth exploring. Probably not the major priority coming up. But definitely some interesting aspects that we\'ve seen other... other building applications do that we can learn from for sure.\n\n<strong>Nathan Wrigley  </strong>54:47  \nOkay, we\'re very short on time now. I think we\'ve got to round it off at the top of the hour. So we\'ve got about four minutes left. I\'ve got to wrap it up a little bit. So try to get these last two done if we can. This is from Mary. What are the typography options as of 6.2? we have Google fonts and self-hosted. Any plans for solutions like Adobe Type and Monotype?\n\n<strong>Anne McCarthy  </strong>55:11 <strong>\n</strong>There\'s a Fonts API that got booted from 6.2 and is hopefully planned for 6.3. So I would just follow that effort. So right now, 6.2 is not introducing anything new or different there. Things are as they were. There\'s a private API that folks can can use with anything JSON. That\'s as concise as I can be.\n\n<strong>Nathan Wrigley </strong> 55:31\nNo, that\'s perfect. I think we\'re three minutes to go. That\'s probably the best time to wrap up the Q&amp;A. Apologies if you had a question and it didn\'t get answered. As I said, there will be a whole load of things created off the back of this. We will make sure that there\'s a transcript available and - just read something in the comment. Hopefully, any questions that have been asked but unanswered will be answered approaching that. Just very, very quickly, I have to say thank you to Anne and Rich in particular, for taking the time out of their busy schedules and demoing what 6.2 can do. It really looks like a transformational release. But also, thanks to Chloé and Jonathan and Lauren and Mary who are on the call, but, you know, you haven\'t necessarily seen them right now. So, appreciate them. That\'s really great. Following up off this, I\'ve got three points to mention. Following the 6.2 release on Make/Core for development updates and calls, there\'s going to be a post. It\'s make.wordpress.org/core/6-2. Also, if you\'ve been keeping a close eye on the Beta releases - I say beta, I know it\'s hysterical. The beta releases, we\'ve got version beta four has just been released. And anybody who wants to test that out would be most welcome. The URL for that is far too long for me to say out loud, but you can Google it, I\'m sure, and find out how to test for that. And also, if you are keen to follow WordPress, it\'s all over the social networks. And you can follow - basically, if you try to just follow @WordPress, then you\'ll get somewhere. So for example, on Twitter, it\'s WordPress - @WordPress. On LinkedIn, it\'s /company/WordPress. Instagram is @WordPress. And guess what? On Facebook, it\'s - what do you think it would be? It\'s @WordPress. So it\'s available all over there. And I think that\'s it. I think that\'s everything that we\'ve got to say. We\'re about one minute away from closing. So particular thanks to Rich and Anne, but thanks to everybody in the background making all of this happen. Thanks for showing up. If people don\'t show up, the work never gets done and the project never moves forward. So fully appreciate anybody who\'s given up their time to ask questions today and watch this presentation.\n\n<strong>Anne McCarthy </strong> 57:51 \nAnd thank you, Nathan. I want to call you out as being an excellent moderator and creating a safe space for us.\n\n<strong>Nathan Wrigley </strong> 57:57  \nVery, very welcome. I enjoyed doing it. I would gladly do it again. All right. I don\'t know how to end this call. So I\'m just gonna wave. Bye, everyone.\n</pre>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"14573\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 14 Apr 2023 08:05:50 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Mon, 10 Apr 2023 12:00:00 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";s:14:\"20211220193300\";}","no");
INSERT INTO BXzlkOCF_options VALUES("195","_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1681502750","no");
INSERT INTO BXzlkOCF_options VALUES("196","_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1681459550","no");
INSERT INTO BXzlkOCF_options VALUES("197","_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1681502753","no");
INSERT INTO BXzlkOCF_options VALUES("198","_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"BuddyPress: Let’s meet in Paris during the french community contributor day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=329085\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://buddypress.org/2023/04/lets-meet-in-paris-during-the-french-community-contributor-day/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3548:\"<p>The BuddyPress Core Team is very happy to be represented at the Contributor Day the french WordPress community is organizing in Paris on April 20, 2023. Here&#8217;s a link to a <a href=\"https://wpfr-net.translate.goog/programme-de-la-journee-de-contribution-organisee-a-paris-le-20-04-2023/?_x_tr_sl=fr&_x_tr_tl=en&_x_tr_hl=fr&_x_tr_pto=wapp\" target=\"_blank\" rel=\"noreferrer noopener\">translated page of the event schedule</a> (Hours are in Central European Summer time).</p>\n\n\n\n<a href=\"https://buddypress.org/wp-content/uploads/1/2023/04/48766199826_c0187b9999_c.jpg\"><img width=\"800\" height=\"533\" src=\"https://buddypress.org/wp-content/uploads/1/2023/04/48766199826_c0187b9999_c.jpg\" alt=\"\" class=\"wp-image-329088\" /></a>Mathieu Viet (@imath / me!) explaining BP contribution during <a href=\"https://paris.wordcamp.org/2019/contributor-day/\" target=\"_blank\" rel=\"noreferrer noopener\">WC Paris Contributor day in 2019</a>\n\n\n\n<span id=\"more-329085\"></span>\n\n\n\n<p><a class=\"bp-suggestions-mention\" href=\"https://buddypress.org/members/imath/\" rel=\"nofollow\">@imath</a> will be there to lead the BuddyPress contributing squad and we&#8217;ll have a lot of work! As we&#8217;re currently working on a very ambitious 12.0 release which main goal is to migrate from our Legacy URL parser to using the WordPress Rewrite API, there are many areas getting your contributions would really help us &amp; make a huge difference! Below are the most important tasks we need to accomplish:</p>\n\n\n\n<ul>\n<li>Code: the <a href=\"https://buddypress.trac.wordpress.org/ticket/4954\">BP Rewrites merge process</a> is still in progress</li>\n\n\n\n<li>Code: we need to build a <a href=\"https://github.com/buddypress/bp-classic\" target=\"_blank\" rel=\"noreferrer noopener\">BP Classic back compatibility plugin</a> to give end users a plan B if some of their plugins are not ready yet when 12.0 will be released.</li>\n\n\n\n<li>Documentation: we need to <a href=\"https://developer.buddypress.org/plugins/\">explain</a> third party Plugin/Theme developers what they need to do to make their work progressively &#8220;BP Rewrites&#8221; ready.</li>\n\n\n\n<li>Documentation: we need to <a href=\"https://codex.buddypress.org/\">explain</a> end-users how the switch we&#8217;re performing will improve their BuddyPress experience (customizable slugs, plain text link compatibility&#8230;).</li>\n\n\n\n<li>Support: we need to have some most common troubleshoot replies ready in order to face the questions or requests for help we&#8217;ll probably receive into our <a href=\"https://buddypress.org/support/\">support forum</a>.</li>\n</ul>\n\n\n\n<p>If you do not have a chance to attend IRL to this contributor day, no worries: you can virtually join us to get involved into these tasks going into our <a href=\"https://wordpress.slack.com/messages/buddypress\" target=\"_blank\" rel=\"noreferrer noopener\">Slack channel</a> on April 20, 2023 from <a rel=\"noreferrer noopener\" href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20230420T0815\" target=\"_blank\">08:15 UTC</a> to <a rel=\"noreferrer noopener\" href=\"https://www.timeanddate.com/worldclock/fixedtime.html?iso=20230420T1530\" target=\"_blank\">15:30 UTC</a>.</p>\n\n\n\n<p><strong>Let&#8217;s contribute to BuddyPress!</strong></p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f355.png\" alt=\"🍕\" class=\"wp-smiley\" /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f91d.png\" alt=\"🤝\" class=\"wp-smiley\" /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Apr 2023 05:49:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mathieu Viet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"WPTavern: WooCommerce 7.6 Introduces Single Product Details Block and “Add to Cart” Form Block\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143628\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wptavern.com/woocommerce-7-6-introduces-single-product-details-block-and-add-to-cart-form-block\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2657:\"<p><a href=\"https://developer.woocommerce.com/2023/04/13/woocommerce-7-6-released/\">WooCommerce 7.6</a> was released today with two new blocks merged from the WooCommerce Blocks plugin. The Single Product Details block and the &#8220;Add to Cart&#8221; Form block are now available to store owners who want to use the Site Editor to design their own Single Product Templates. </p>\n\n\n\n<p>Along with the button, the &#8220;Add to Cart&#8221; form block will automatically display additional options, depending on if the product has a set available quantity or variations.</p>\n\n\n\n<img />image credit: <a href=\"https://developer.woocommerce.com/2023/04/13/woocommerce-7-6-released/\">WooCommerce 7.6 release post</a>\n\n\n\n<p>In templates where store owners are displaying multiple products, attributes filtering has been improved for the Products block. Inside the editor, there is now a collapsible menu for selecting attributes and filtering the display. It also shows a live preview of the products that will be included in this view.</p>\n\n\n\n<p>For those who are designing pages and templates with patterns, WooCommerce 7.6 makes it much easier to get a consistent design with improved, scalable margins for patterns using the Products block.</p>\n\n\n\n<p>This release also improves the Mini Cart block&#8217;s performance, with content preloaded, and an appearance that more closely matches the site&#8217;s active theme.</p>\n\n\n\n<p>WooCommerce 7.6 includes several important updates for developers, including the following:</p>\n\n\n\n<ul>\n<li>Clearer, renamed event names in block-based Checkout</li>\n\n\n\n<li>Reintroduced cache for orders (after it was reverted due to causing an infinite loop on activation) when custom tables are enabled </li>\n\n\n\n<li>Added an encoding selector to the product importer</li>\n\n\n\n<li>Add/Remove order coupon actions are now logged in notes</li>\n\n\n\n<li>Products widget can now be sorted by menu_order</li>\n</ul>\n\n\n\n<p>For a more detailed look at the 673 commits in 7.6, check out the full <a href=\"https://github.com/woocommerce/woocommerce/blob/release/7.6/plugins/woocommerce/readme.txt\">changelog</a>, which references each pull request included in the release. </p>\n\n\n\n<p>WooCommerce has also released its <a href=\"https://developer.woocommerce.com/2023/04/13/woocommerce-contributor-day-guide/\">Contributor Day Guide</a> today for the upcoming 24-hour virtual event on April 19, 2023. There are instructions for how to get your development environment set up for contributing and how to join the Woo Community Slack. The guide outlines specific topics and tickets that will be addressed, with dedicated Slack channels for each.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Apr 2023 03:16:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Do The Woo Community: Building a Better WooCommerce Hosting Ecosystem with Beau Lebens\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=74755\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://dothewoo.io/woo-express-with-beau-lebens/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:404:\"<p>The new hosting option Woo Express brings a lot to the ecosystem for users, builders and other hosting companies. </p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/woo-express-with-beau-lebens/\">Building a Better WooCommerce Hosting Ecosystem with Beau Lebens</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Apr 2023 08:13:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Post Status: Launching a WordPress Product in Public: Session 9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=148930\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://poststatus.com/launching-a-wordpress-product-in-public-session-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:48283:\"<div class=\"is-layout-flow wp-block-group eplus-wrapper has-theme-palette-2-color has-theme-palette-8-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\"><a href=\"https://twitter.com/coreymaass\">Corey Maass</a> and <a href=\"https://twitter.com/corymiller303\">Cory Miller</a> continue the development of their new WordPress plugin, <a href=\"https://crop.express/\">Crop.Express</a>. In this conversation, they share their experiences and challenges in creating the plugin, including the importance of user feedback and testing. They also talk about their decision to make the plugin open-source, the potential benefits of doing so, and the importance of community involvement in the process. </p></div>\n\n\n<div class=\"wp-block-spacer eplus-wrapper\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">34</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n\n\n\n\n<p><a href=\"https://poststatus.com/planet/feed/#h-transcript\">Transcript</a> ↓</p>\n\n\n\n<p>In this episode, <a href=\"https://twitter.com/corymiller303\">Cory Miller</a> and <a href=\"https://twitter.com/coreymaass\">Corey Maass</a> share their insights and experience about the challenges of finding the right balance between simplicity and complexity and the importance of testing and documentation. They also share their personal stories of how they got started with WordPress and how their experiences have shaped their approach to plugin development. For anyone interested in developing WordPress plugins, especially if you are looking to improve your development process and create more user-friendly plugins, this episode is a must-listen.</p>\n\n\n\n<p><strong>Top Takeaways:</strong></p>\n\n\n\n<ul>\n<li><strong>Building a successful plugin requires a deep understanding of user needs and pain points: </strong>Understanding your users\' needs and pain points to develop a plugin that solves their problems effectively is critical. This requires continuous user testing and feedback to improve functionality and user experience.</li>\n\n\n\n<li><strong>Collaboration and communication are crucial for plugin development: </strong>Plugin development is a team effort that requires effective communication, collaboration, and project management. Clear communication channels, regular meetings, and shared project management tools help ensure everyone is on the same page.</li>\n\n\n\n<li><strong>Monetization strategies should align with user value: </strong>Considering various monetization strategies for plugins, including premium features, subscriptions, and sponsorships, is helpful. Your chosen strategy should align with the user\'s value proposition and offer a fair exchange of value. Being transparent with users about the plugin\'s monetization strategy and how it impacts their experience is important for successful adoption.</li>\n</ul>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the show:</h3>\n\n\n\n<ul>\n<li><a href=\"https://crop.express/\">Crop.Express</a></li>\n\n\n\n<li><a href=\"https://wpengine.com/\">WPEngine</a></li>\n\n\n\n<li><a href=\"https://pagely.com/\">Pagely</a></li>\n\n\n\n<li><a href=\"https://www.studiopress.com/\">StudioPress</a></li>\n</ul>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-you-can-follow-post-status-and-our-guests-on-twitter\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> You can follow Post Status and our guests on Twitter:</h3>\n\n\n\n<ul class=\"eplus-wrapper\">\n<li><a href=\"http://twitter.com/coreymaass\">Corey Maass</a></li>\n\n\n\n<li><a href=\"https://twitter.com/corymiller303\">Cory Miller</a> (CEO, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/lemonadecode\">Olivia Bisset</a> (Intern, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n</ul>\n\n\n\n<p class=\"eplus-wrapper has-background\">The <strong>Post Status Draft</strong> podcast is geared toward WordPress professionals, with interviews, news, and deep analysis. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4dd.png\" alt=\"📝\" class=\"wp-smiley\" /><br /><br /><a href=\"https://poststatus.com/category/post-status-podcasts/\" target=\"_blank\" rel=\"noreferrer noopener\">Browse our archives</a>, and don’t forget to subscribe via <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\" target=\"_blank\" rel=\"noreferrer noopener\">iTunes</a>, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\" target=\"_blank\" rel=\"noreferrer noopener\">Google Podcasts</a>, <a href=\"https://www.youtube.com/c/PostStatus\" target=\"_blank\" rel=\"noreferrer noopener\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\" target=\"_blank\" rel=\"noreferrer noopener\">Stitcher</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Simplecast</a>, or <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h2 class=\"eplus-wrapper\" id=\"h-transcript\">Transcript</h2>\n\n\n\n<h2>Session 9 Corey & Cory Launch a WordPress Product Live</h2>\n\n\n\n<p><strong>Cory Miller:</strong> [00:00:00] So we\'ll also, um, so re read me as the, the big one?&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> Yeah. I think that\'s what we cover today.&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Okay. So we\'ll also, uh, okay. All right. Could you hear me?&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> Uh, first I can, yeah. Oh, okay. The echo you mean? Yeah. Yeah. The same thing. Mute it. Yeah. Open up YouTube and then close YouTube. But I, I keep the comments open if anybody\'s weighing in.<br /></p>\n\n\n\n<p>Yeah,&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> exactly.<br /></p>\n\n\n\n<p>All right, Corey, this is session nine and we talked last week and we made the decision that we\'re gonna be one this with a couple change. And call it good for now and move on to another [00:01:00] project, um, let it sit and simmer a little bit. Um, so any thoughts that you had based on last week or anything else?<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> Yeah, I, I guess I just, I, I\'m glad that we\'re doing this, like I, and, and if for the, for the, the six people watching, You know, but hi, in historically this will be significant. You know, this is where we, uh, figured out how to make our millions. Right. Um, right. But I, I have had a lot of success not in a, in a project sense in the past of letting things.<br /></p>\n\n\n\n<p>Uh, and so I definitely like, cuz we could keep banging away at Crop Express, adding more features. And there\'s still a few things that I wanna add. Like, I definitely wanna put a bow on it. Um, and I definitely think that it\'s something for [00:02:00] us to talk about, promote, you know, we\'ll send copies to, um, blogs.<br /></p>\n\n\n\n<p>Like let\'s still have some of those conversations that, um, you talked about. As much because I want to talk to those people. I think it\'d be fun. Um, but I also think that it takes the pressure off of us like, you know, Having this, having this thing and going, okay, what, what\'s happening with it today?<br /></p>\n\n\n\n<p>What\'s hap when Sometimes you just honestly need some time to go by. Um, and some people to mess with it and some people do mess with it enough to say, oh man, I wish it did this. And then, and then still ha use it for two more days before they finally do send us an email that\'s like, okay, hey, I\'ve been thinking about this for a couple of days.<br /></p>\n\n\n\n<p>Boy, I wish it did this, you know? Just because we\'re thinking a lot about it doesn\'t mean anybody else\'s.&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah. And I think there\'s two things when you\'re saying that came to mind is the get something [00:03:00] out, sit on it a bit, let it just kind of cook or just kind of be Yeah. I think it\'s interesting. And then, um, is, is great for this.<br /></p>\n\n\n\n<p>And then second is.<br /></p>\n\n\n\n<p>I forgot what I was gonna say. Um, but the second is we have the feedback loop, right. Um, within the plugin. So, you know, we, we never know. Um, might be something I think we, we felt like there was something. Better to chase that. We discovered through this, which I look at product as discovery, you know, especially our product, you know, when you got a working product and you\'re just adding things, that\'s way easier.<br /></p>\n\n\n\n<p>Um, working product, meaning people are paying money for it in my mind. Um, we already know it\'s functional and works. Um, but yeah, and I think, you know, just to talk about our decision for a second, we saw. More [00:04:00] opportunity on another direction that we discovered something you\'d been working on in parallel.<br /></p>\n\n\n\n<p>Um, we\'re not ready to talk about that just yet cause we wanna get some things going, but I think that\'s part of the product trail is, you know, discovery, what\'s over the next mountain. And I don\'t know about you, but I go, I gotta put multiple things in the. To see what actually hits. Oh, yeah. Um, I, I feel like you and I built enough of a case for the other thing that, um, is really interesting.<br /></p>\n\n\n\n<p>It seems like there\'s something there. So coming back to the cycle of like, okay, we\'d like this. We think this would be good. Mm-hmm. Other people, you know, would help. Um, anyway, I don\'t wanna get off on that for a second, but I did wanna at least unpack a little bit of our decision. You know, Colin v1 with a couple of these tweaks, um, good.<br /></p>\n\n\n\n<p>And all that, and say, it\'s always a safari. Yes. [00:05:00]&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> Yeah. And I, you know, I, it\'s an ongoing conversation, I think is the other good metaphor. It\'s, it\'s literal for, in our case, but it\'s also a good metaphor that as you talk, you uncover more things. You go, oh, I didn\'t think about this. And it\'s, um, so I guess the analogy too is, Concepts have to simmer.<br /></p>\n\n\n\n<p>Ideas have to simmer, you know, the cadence of you and I chatting once a week, you know, occasionally a little bit more, but, uh, gives us a chance to go, okay, so this happened this week where this new other thing came out this week where this new, um, you know, product caught my eye that isn\'t related, but it sparked an idea, dot, dot, dot.<br /></p>\n\n\n\n<p>Like it\'s, you know, trying to, trying to get it all done, you know, hackathon. Is a neat exercise, but I don\'t think it\'s the, the true arc of, of most products journeys. So, um, but I definitely, [00:06:00] oh, the one thing that I didn\'t tell you about is I did get my first email from crop.express, the website of somebody asking specifically, I have a client website, they need the image to be exactly these pixel proportions.<br /></p>\n\n\n\n<p>So not even an aspect ratio. And uh, I was like, oh, okay. You know, so I think that I, I want to think about again, as we\'re talking about sort of putting a bow on v1 uh, accounting for that situation, and then to me that kind of, again, we\'ve, we\'ve completed a. Product. It solves the problem. It solves the problem everywhere that we think that it matters.<br /></p>\n\n\n\n<p>Um, it solves the problem for all of the scenarios that we currently know about. And this is where, like you said, we\'re wait, waiting for feedback. We\'re waiting for people to say, oh, hey, you know, aspect ratio [00:07:00] isn\'t really what I need, but I need is image or is pixel size. Uh, which technically can be done in the, I had added bin and max pixel stuff.<br /></p>\n\n\n\n<p>Like I, I think, you know, kind of like your feedback last week, like this settings page is the advanced settings, or it feels, you know, um, it feels like a 200 level class or whatever. Um, And so, you know, looking at simplifying that, but then, uh, yeah, letting it, letting it ride. Um, and, and at that point, like I said, I\'m really excited about getting it at actually installing it onto my client\'s websites and going, all right, Guinea pigs dance.<br /></p>\n\n\n\n<p>You now have to use my plugin. But I\'ve, even, this week it came up again where, um, one of my clients was like, you know, trying to, trying to get an image. Onto the site correctly. And I had to walk her through some stuff. It\'s like, don\'t mention the plugin yet. Don\'t mention the [00:08:00] plugin yet, but as soon as I introduce it and walk them through it, you know, so I think it\'ll solve problems for them.<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah, a absolutely. Um, it, this whole conversation, and this relates to crop express now,<br /></p>\n\n\n\n<p>uh, made me think of. But also kudos for like a, you, you saw an opportunity there with your client, like, so that\'s like the validation of, you know, is this, is this a valuable thing? Mm-hmm. You\'ve seen this a bunch of times where I wanted to share for anybody that\'s listened later is I always come back to this, so it seems like, like I\'ve majored in the pains.<br /></p>\n\n\n\n<p>Um, specifically with utility software in the past. The thing that\'s really always compelling to me is gains. And I know you worked at O Opt Montreal at one point and I go, that was my classic example. We did utility things that [00:09:00] I themes and you know, you look at the gain, you look at like an e-commerce site or something, a marketing software or something like that, and it\'s like that\'s, I haven\'t really camped.<br /></p>\n\n\n\n<p>Had a product. I don\'t think that camps out in the gain side. Yeah. Um, but I think we\'ve been doing this work too, is coming back to who is our customer for this. Mm-hmm. Whether it\'s ourselves for sure. And then we\'re developing out the profile for there. Like could this be something that\'s something when we start and talk about the next project publicly, um, so that we can, that\'s something I want to do better is go, okay, let\'s identify.<br /></p>\n\n\n\n<p>The person that might have this problem or frustration or issue. This is a whole concept I\'m trying to get to. What\'s the amount of pain? Somebody goes, I\'ll pay for it. What\'s the amount of gain? Somebody goes, I\'ll pay for it. You know? Yep. That\'s [00:10:00] some of my learning as I\'ve gone, is gone. Okay. Like when we created backup buddy.<br /></p>\n\n\n\n<p>Um, the de the developer goes, Hey, I think we should, WordPress needs a holistic backup solution. And I was like, I just go, yeah, because a hundred percent theoretical market at that time. Um, so it\'s pretty easy. I think WordPress has got enough things out there. It\'s interesting from a competitive standpoint is where\'s that ideal place?<br /></p>\n\n\n\n<p>So, I don\'t know, I wanna throw some of that up to you and see if you had any comments. Cause you always have something really help. Uh, that changes my perspective a little bit, but it\'s like this balance, this is a formula for how products and services, different things get up and then, you know, nailing that customer, they go, oh man, that, that would, you know, when you get that feeling of like, oh, this would help me so much.<br /></p>\n\n\n\n<p>That\'s the magic right there. Yeah.&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> And. [00:11:00] I\'m, I\'m definitely, I\'ve also had some similar thoughts in that it\'s, it is a, I think, a slightly different way of thinking about product. Right. And the looking for pain is a very popular, um, Hundred level, I guess. Apparently I\'m making college analogies today. Um, but like you look at, um, Amy Hoy, Justin Jackson, uh, Rob Walling, like the, the startup thought leaders, um, who put out a lot of great content and have done for decades.<br /></p>\n\n\n\n<p>Arguably, um, the, the thinking for a long time has been okay. You are an aspir. Probably solopreneur. You are a entrepreneur, and I don\'t mean that negatively, but the, like you are an aspiring, uh, you, you have an entrepreneurial spirit without [00:12:00] experience, right? So you, you\'re, you want to start your entrepreneur journey.<br /></p>\n\n\n\n<p>Um, and, uh, a very popular formula to start with because honestly, I think. I know it\'s generally more reliable as a beginner, um, is pain. And so there\'s all these ideas about like, okay, you get on a forum for fishermen where all the fishermen are talking and you kind of listen to their conversations and, and when they keep talking about like, boy at dawn I wish I had, you know, a certain kind of light.<br /></p>\n\n\n\n<p>And that\'s where you go, ah, That\'s a pain. Now I can go try to solve it. Um, which is very different from, oh, I\'m now, I\'m blanking on the name. Um, but there was, um, a product that came out years ago and it just [00:13:00] popped up on my radar again. Oh, Prezi. P r e z I. Mm-hmm. I think, right?&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Mm-hmm. Yeah. I remember Prezi,&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> that was a hundred percent a solution, looking for a.<br /></p>\n\n\n\n<p>It was a really neat, in, in, I mean, we still have the slides paradigm, the, you know, uh, PowerPoint, Google presentation paradigm, rectangle, rectangle, rectangle. And Prezi had this really neat software that they built online, which was very impressive at the time, cuz again, it was probably 10 years ago, but where you had a, it was kind of like a, an interactive mind map.<br /></p>\n\n\n\n<p>And so you had a point that had something. Concept off of it. And you\'d zoom around, you\'d sort of fly around this, this presentation and it was extremely novel. But I think every person built one presentation in it and was like, this is neat, but it\'s very clear that I\'m using this software cuz it does one thing.<br /></p>\n\n\n\n<p>Um, and they did a really good [00:14:00] job, I think, of marketing and finding a use for this and marketing it, but they. Couldn\'t become the presentation standard that they\'d hoped to because they changed. It was too specific, you know? Um, and that\'s always the fear. It\'s definitely more fun sometimes. Um, and I\'ve definitely built a lot of products that were a concept and it was like, oh, I think I have a different way of approaching.<br /></p>\n\n\n\n<p>Uh, you know, project management to-do lists, time tracking the standard paradigms, but like, uh, instead of it being a vertical list, you know, it\'s horizontal or whatever the, whatever, it\'s, um, and I think that it\'s you, it\'s then tough because if you\'re, if you\'re on one end of the spectrum, you can, you can only present gain.<br /></p>\n\n\n\n<p>Like Prezi, where it\'s a, where it\'s, I hate to use the word gimmick, [00:15:00] but where it\'s, again, a, a prob a solution looking for a problem that\'s dangerous, that\'s very, very difficult to change a paradigm. Like they did not change the way all presentations are. Look, they couldn\'t. Um, and then on the other end of the spectrum, you know, what we\'ve, what we\'ve talking about is, um, a hundred percent solving for a pain.<br /></p>\n\n\n\n<p>It\'s. Fishermen need a flashlight at dawn, build the flashlight. You\'re done. And so what we start talking about is somewhere in the middle. Um, and it\'s, and it, again, I think just a different way of, of thinking, uh, it\'s gonna be more challenging for you, marketing it, more challenging for both of us or anybody to talk about it.<br /></p>\n\n\n\n<p>Um, if it isn\'t a problem that people are already trying to solve. And I think what we\'re, you know, I do, I do anticipate landing [00:16:00] somewhere in the middle, like crop Express I think is a good example of, it\'s definitely a pain, but people are solving it by going elsewhere. They\'re going to Photoshop, they\'re going to crop.express, and we\'re kind of bringing it to them.<br /></p>\n\n\n\n<p>Um, and so I think that I, I hope to still kind of do some of that stuff. Um, but then also, You know, maybe introduce concepts that, that WordPress doesn\'t currently have, paradigms that, that WordPress doesn\'t currently, uh, have its arms around. And so I\'m kinda excited for all that. It\'s also, I think it being more on that spectrum, it\'s, it\'s, it\'s more creative.<br /></p>\n\n\n\n<p>It\'s more fun for us.&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah. So yeah, a absolutely. You know, we, it seems like we\'re using that whole thing is build something for yourself. And we\'re using problems we see for ourselves using the new [00:17:00] thing we\'re talking about, using word pr, um, post status and your clients and things. And it makes me think like the game pain conversation on that when we show that we can.<br /></p>\n\n\n\n<p>What I wrote down when, when we, just a minute ago was, you know, in the classic consulting bible, I think it\'s Alan Weiss, he talks about the job of a consultant is to improve the client\'s condition. Mm-hmm. In some way. Mm-hmm. And I\'ve been doing a lot of thoughts about consulting cause I\'ve tried it a couple of times and, uh, have failed miserably at it.<br /></p>\n\n\n\n<p>But, uh, I\'m still trying. And, but from the. From that consulting thing. If you think about that just for a second, you\'re like, how do I help improve the client\'s condition, or in this case, our potential customer\'s condition? And I think we\'ve done a lot of that work in Crop Express is precisely thinking about the outcome they\'re wanting.[00:18:00]&nbsp;<br /></p>\n\n\n\n<p>And, uh, I\'ll save the rest for our, for our next conversation. But, um, so I. Anything you learned, and I know we still need to do the readme, but, um, anything takeaways from what we\'ve done so far? Other takeaways?<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> I, in a, to be honest, I do think that we have, I\'m thinking out loud here, so I, I, I reserve the right to take all of this back. Um, but at least some. The process that we\'re going through, have gone through is the same, uh, falls in the same trap in that I do think that we have, we know there\'s a problem. We, we\'ve had the problem.<br /></p>\n\n\n\n<p>We don\'t like how, um, propping and inserting images into WordPress currently [00:19:00] works. Um, we. Got excited and said, okay, there\'s something here. We both felt, you know, felt it in our gut, but then as we got into it, there\'s definitely been, I don\'t, it\'s not like I expect, you know, a million news, a million installs overnight.<br /></p>\n\n\n\n<p>Um, but there\'s, there\'s something, I don\'t know what we could have done differently, but they\'re, I haven\'t felt. The spark didn\'t ignite, I guess is what I\'m, kinda what I would say. It\'s like there\'s something here. We\'ve built a nice little utility. I almost, it almost feels like we\'ve kind of, uh, you know, we, we saw a sparkle of something on the ground.<br /></p>\n\n\n\n<p>We started digging. There might have been a couple of other glimmers of like, oh, there\'s a, maybe a li a hint of gold. It kept us digging, but I kind of feel like we\'ve reached a point where, You know, we\'ve dug around, we\'ve dug up all the earth around what we thought might have been a vein of gold and said, okay, [00:20:00] yeah, no, I guess there\'s nothing here.<br /></p>\n\n\n\n<p>Um, and not that that isn\'t part of the process. Um, I don\'t know what we could have done differently. I, I only question if there was a way to have arrived there sooner. Um, mm-hmm. And again, none of this is to say that I don\'t think that what we\'ve created has value. Um, and we kept sort of going, okay, well let\'s, you know, we keep having really good high level conversations, which again, has led to other ideas.<br /></p>\n\n\n\n<p>Um, and so that\'s, that\'s not invaluable. Um, but we were sort of like, take a step forward and see, take a step forward and see. And now that we\'re ready to kind of put a bow on version one, it\'s like, yeah, this might be. You know, which is okay. Um, but it\'s very, it\'s, it\'s a, it\'s definitely a little hard to accept.<br /></p>\n\n\n\n<p>Do you know what I mean? Like just [00:21:00] the sunk cost fallacy or whatever it is. Like you Yeah. We\'ve put in time and effort and, and so much thinking that we, we, part of me still really wants it to be something more than what it may. You know, and I know, and this, this conversation may be just as in, um, as premature as, uh, as what I\'m alluding to, right.<br /></p>\n\n\n\n<p>Of like, early on we were very optimistic that we would find something bigger down the road anyway. So I have a thought&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> I, on that thought. I have, I have a thought for when we go to the next conversation. Hmm. Um, how we could maybe approach that even better.&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> But I guess I like what I do like is the meta, um, the meta of you and I recording all of these conversations.<br /></p>\n\n\n\n<p>Right. And I think, like, I remember one, one of the, a a, a mental image, but a [00:22:00] conversation, a memory that, that often pops into my head is when I still worked at we. Um, yes, the one that\'s in the documentary, you can see my bald spot in, in the back of some of the shots, um, where they talk about, you know, the demise of, of WeWork.<br /></p>\n\n\n\n<p>Um, so yeah, I\'m, I\'m WeWork famous. Um, but, uh, at the time I sat at the table with, uh, five other entrepreneurs, everybody pursuing different projects and it was great because it was an an instant mastermind and very frequently we. Just say, Hey, could I, you know, buy you lunch and, and pick your brain about such and such?<br /></p>\n\n\n\n<p>And I remember a buddy of mine, Joel, coming to a real crossroads in, uh, in product and in business. Um, and again, him saying, Hey, could I just, could we take a walk? I\'m like, you know, vexed about this and [00:23:00] we. Uh, in soho and we walked over to the river and just like standing at the railing and looking at, um, what, what would it have been, um, the Hudson River and looking over to New Jersey and him talking.<br /></p>\n\n\n\n<p>And there was this moment of me just feeling very, this is, this is feeling very grown up and very, like, we were having important conversations and, um, You know, and it, it felt great that I hopefully was helping him work through some problems and stuff. But, um, anyway, uh, the value in that experience, that camaraderie and, and then ultimately, like there were other conversations where he helped me just as much as maybe I helped him.<br /></p>\n\n\n\n<p>Um, but I\'m hoping that at a high level, even though you and I like session seven, whatever this is, we, we are where we are. It is where it isn\'t, where we expect it to. We are going to continue, but I\'m, I\'m hoping that people watching this are having some of that same, like, [00:24:00] oh, other people have these, these thoughts or go around in these circles or, you know, ramble to themselves just like I do&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> now.<br /></p>\n\n\n\n<p>I, I think so many times, uh, I\'m not just, I don\'t wake up born with a gift of know. What the pro products are. Um, I\'ve gotta figure it out.&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> Ands am working with you, man. I know. I, I was counting on million dollar idea overnight, the magic.&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Um, you know, and uh, so I\'ve done a lot of thinking about products for the last 15 years, obviously, and gone.<br /></p>\n\n\n\n<p>Okay. You get, so I think we\'re pulling together some components, comparing experiences too, and. Plowing the new head forward. Um, so yeah, I mean, the camaraderie\'s been amazing. I do it just for that. But second is I think we\'re building some experience about what products work, what, what products don\'t. I, I think there\'s a tendency for me is think [00:25:00] people do have magic and just know it, but there\'s, there\'s, there\'s a lot of things that go into that.<br /></p>\n\n\n\n<p>Yeah. And there\'s a lot of. Professionally about this particular topic, but there\'s a reason why comp big companies buy smaller companies because they found the magic and they were pulled in, you know, kind of thing. Um, at least that\'s how I think about it in my humility.&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> Well, and so I, in the last few years have learned to make things around my house.<br /></p>\n\n\n\n<p>I. My carpentry skills are getting better. I\'m not good. But, uh, I have now, you know, built a big roof over my patio. I\'ve built shelves, I\'ve, you know, um, helped my father-in-law fix his roof, stuff like that. Um, and I\'m, I\'ve definitely had the experience where I\'m, I\'m working generally with people who know what they\'re.<br /></p>\n\n\n\n<p>But not always. [00:26:00] Uh, I have, I can always jump on YouTube and, and Google things. Um, but I definitely felt the, so a little, a little insight to me like. Years and years ago, I was an artistic genius. Um, in my own mind, absolutely. Like I was, uh, a musician. I still am. I was starting to build product. I still do, but at the time I was convi, utterly convinced that I\'m very smart and I will, I can, I can figure out magic, um, and, uh, an aspect.<br /></p>\n\n\n\n<p>Turning middle-aged or whatever it is, is like, I\'m just another human. And yes, I might do some amazing things. Um, but most humans in one sense or another, do some amazing things. Um, but everybody also, everybody has to start from somewhere. And a lot of the times it\'s a group of people. And so, uh, going back to like learning how to repair or I, I got to be, [00:27:00] I was, uh, helped a bunch of people literally build a house in a.<br /></p>\n\n\n\n<p>And it was one of the most amazing experiences of my life. And the, the, the, in the crew, it was a dad and some son, his sons all work construction, all build houses, so they know how to knock together, literally knock together a house in a day. And I had no idea how to knock together a house in a day. Um, And so they are amazing at what they do now from experience, and they are smart people.<br /></p>\n\n\n\n<p>Um, and then that gets shared with the rest of us. There\'s this trickle down, and I\'m not saying I could go build a house in a day, but at least I have some sense of how it is done. And so this summer when I build a shed, I might be able to build a shed with a couple of other people in a couple of days.<br /></p>\n\n\n\n<p>You know what I mean? Mm-hmm. Um, and so there\'s, there\'s definitely. You know, we, we always talk about the Steve [00:28:00] Jobs or the whoever, um, you know, the artistic geniuses. The, the people who can snap their fingers and, and creativity comes out, and then the rest of us have to work at it, you know? And, and that\'s okay.<br /></p>\n\n\n\n<p>And it\'s, it\'s a little bit of luck and it\'s a little bit of timing and it\'s a little bit of the people around you, and it\'s a little bit of the industry you\'re in. And then it\'s the practice that you\'ve done. And you and I have both been thinking about product for, you know, 15 years or whatever it is.<br /></p>\n\n\n\n<p>And so I\'m walking around, I\'m in San Francisco this week, so I\'m walking around in San Francisco thinking, The amount of, you know, tech and, and whatnot that\'s here. Um, but what it really comes down to is like, I was driving on the highway last night. Judging harshly, all of the ridiculous billboards, because I\'m like, who is Twilio think they\'re advertising to?<br /></p>\n\n\n\n<p>Or who is, um, who else did we see monday.com? And I\'m not necessarily picking on their billboards. They\'re fine. But it\'s like, [00:29:00] okay, th this is, these, these is, this isn\'t, that\'s most of these products I don\'t think. Attributable to one person\'s genius. These are products that were built by teams and companies that were built up over time.<br /></p>\n\n\n\n<p>And then there\'s a marketing team, and now I\'m questioning some of the marketing decisions, but I\'m like, who are they marketing to? You know? And how does that differ from like the online billboards ads and such that I\'m seeing when I\'m in New Hampshire versus in. You know, I\'m, I\'m essentially in Silicon Valley, you know, so it\'s, uh, humbling, right?<br /></p>\n\n\n\n<p>I mean, they\'re exp spending tens of thousands on billboards that I think are not very good. Um, but at the same time, they\'ve arrived there over time, you know? And did it start with conversations like this? Did it, you know, who was the team involved? Who were the people involved? What were their experience?<br /></p>\n\n\n\n<p>I think that\'s all fascinating. I wish most [00:30:00] companies. There was just a, a thread on Hacker News. Um, was it Hack News or Reddit? Like what are your favorite postmortems? Um, and it\'s, I, I like the people on that thread were wishing that they were more write-ups of, um, You know, there\'s probably a little bit of morbid curiosity, um, but also like, you know, what are the lessons we can learn, but also a, a lot of it\'s just the stories are fascinating.<br /></p>\n\n\n\n<p>There\'s a reason why there\'s 101 podcasts interviewing founders, many of whom haven\'t reached the success that most of us would, would want, themselves included. Um, but the stories are fascinating, you know.&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah, it, it, I\'ve, I read the founders at workbook and it was really cool, but, and a lot of it is serendipity.<br /></p>\n\n\n\n<p>Yeah. And it\'s like, I was gonna use a band analogy cuz of your music background [00:31:00] and just go like, you know, how does. Um, I know some mu musicians and I\'m like, one pretty dang popular in the nineties, eighties and nineties. Mm-hmm. And, uh, spent some time with him. Really great guy, but I was like, I always wanna go.<br /></p>\n\n\n\n<p>How did the, like he\'s played with that, his band for, you know, A long time and they\'ve had success together and it\'s like, how do you, how does that come together? Is always the magic for me. And then how do they make this great music that a lot of the best bands I\'ve heard, you know, they need, like Dave Matthews was the continuum.<br /></p>\n\n\n\n<p>You\'re like, man, great voice. But I\'ve also heard like he wouldn\'t be Dave Matthews and Dave Matthews band without all the incredible musicians around him. He happens to get the names stands,<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> the connections he had and stuff like that.&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah, that was very much, iThemes , by the way, I got way more credit and I can\'t sing so[00:32:00]&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> well. But um, yeah, and I think that, thank you. I think you\'ve sort of. In some ways summarized what, what I, my rambling was trying to get at is the, it\'s everything is the sum of its parts, right? And so it\'s like, there was a point where I thought that I would snap my fingers, um, and not that I didn\'t work really, really hard, um, but I now understand that it\'s so much more as the building blocks, the sum of the building blocks, um, and the culmination of things.<br /></p>\n\n\n\n<p>And like a lot of bands, you know, I love, in fact, I\'m, I\'m rereading Elton John\'s book. Um, great read by the way. I\'m not a fan of Elton John. I, when I read it the first time, I went back and literally tried to listen to some of his music and I couldn\'t get through most of it. It\'s just so not to my taste.<br /></p>\n\n\n\n<p>Um, I\'m wrong. Don\'t, there? There is no question that I am, I am wrong. Literally, [00:33:00] billions of people love his music and I don\'t, so I am wrong here. But the book is really fun. Um, well written self effacing. Self self deprecating. Um, and, and I\'m a music history nerd. Um, but it\'s the, you know how things came.<br /></p>\n\n\n\n<p>Um, you know, and he definitely is magical, musically. Um, but he, he watch the past tense of grind grounded. He, he worked really, really hard for a really long time and with a lot of people, and people came and went and stuff like that, you know, so at some point you and I are. Reach a a point where you\'re gonna fire me and hire somebody better and keep going with the band.<br /></p>\n\n\n\n<p>Um, and I will be the pee best. Um, you know, the long lost drummer, original drummer of the Beatles, um, who will die in obscurity. [00:34:00] And I accept,&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> I don\'t think so, cuz you, you, you forget. I don\'t know how to sing and it\'s not gonna be as fun at all without the drums and guitar solo and everything you\'ve done so.<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> But anyway, why don\'t, why don\'t you share your screen if you have the, the read me. I think, I feel like the brainstorming we did last time worked well. Like you were typing, typing, typing, um, while we were both chatting, if that works. Yep. So we\'re here.<br /></p>\n\n\n\n<p>Nice. Oh, so there\'s an edit option. That\'s cool. Uh, bottom left, there\'s a button that\'s an edit. Can we make our changes right in it? Cool.<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> You know what, we\'ll wanna go back when we do the, the new brand that we talked about, we\'ll wanna come back and put the links here.&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> Oh, for sure. [00:35:00] Okay,<br /></p>\n\n\n\n<p>so I go to, we\'re press. Slash plugins<br /></p>\n\n\n\n<p>and I search for crop<br /></p>\n\n\n\n<p>and I\'m seeing what else comes up. And like there\'s a, yeah, image aspect ratio. Custom fields for, um, a ACF crop and image as keywords. Um, I also heard from, I did a, um, a call with um, Matt Cromwell and, um, I hate to say it, but Leslie Pizza, um, cuz I can never remember her last name and I think she actually, like a lot of people call her Leslie Pizza.<br /></p>\n\n\n\n<p>Um, But, uh, they were helping me [00:36:00] review one of my other plugins and said that we can actually have up to 12 keywords. Uh, just the first, I think, five show up. So, uh, I was actually misinformed that, or I, under, I had the wrong knowledge that, uh, I thought we could only have a few keywords. So, um, I think on that, on that first screen, Plug in maybe.<br /></p>\n\n\n\n<p>Yeah, I saw tags. So, um,<br /></p>\n\n\n\n<p>like I\'m, I\'m wondering if, I mean this is, and this is all always speculation, but is, is it better to have image crop or is it better to just have crop? To me, you don\'t crop, you don\'t crop anything that isn\'t an image. So I, it might ju we might, image, crop might be. Cropping is good though.[00:37:00]&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> So I had crop and cropping. Since we can add more tags, that\'s good knowledge,&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> right?<br /></p>\n\n\n\n<p>In WordPress, uh, featured images are often called thumbnails.<br /></p>\n\n\n\n<p>Um, oh, media library. Now that we have that, it\'s probably, you know, if people are looking for ways that they are manipulating images in the media library, maybe they search for media library.<br /></p>\n\n\n\n<p>Um, I can\'t imagine that people are looking for the term aspect. Um,<br /></p>\n\n\n\n<p>More likely they\'re looking for, oh, image size, right? Like we had the, the guy message me and say, I need, you know, I need [00:38:00] all images, need to ultimately be 700 by 500 or whatever it was, like image size. Um, so anyway, I feel like that flushes it out a lot more. Okay.&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah, that\'s awesome. I mean, that\'s really good base level things.<br /></p>\n\n\n\n<p>We gotta just check the box for. Uh, do I push saver update code? I\'m always the Control s. Control s. Command desk. Command desk, right.&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> Um, I probably save, I I imagine that Save actually does both. I just remember that Save took a long time. Okay.&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Um. Okay. I put cropping here and I put precise. I took out feature damages, but is there anything else you see that we should probably like a list of features maybe[00:39:00]&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> I. So up to 150 characters, um, I\'m still looking at the description first. Um, it seems like, uh, do you have a, something that\'ll tell us how many characters we\'re using there? Go stick it in a fake tweet or something though. So I guess they just give you. A counter,<br /></p>\n\n\n\n<p>I think like, so I do, I [00:40:00] think we could just say crop images in WordPress Z or is that a sentence? It\'s awesome. I think that\'s really good. WordPress easily, but I, I guess my point is I, we\'re not using 150 characters. Let\'s, let\'s add more words. Um, and WordPress easier. Dash featured image media library.<br /></p>\n\n\n\n<p>You know, it\'s a little bit of, um, keyword.<br /></p>\n\n\n\n<p>I mean, we had the block too. Mm-hmm. Prop images and WordPress.[00:41:00]&nbsp;<br /></p>\n\n\n\n<p>Uh,<br /></p>\n\n\n\n<p>say Guttenberg block,<br /></p>\n\n\n\n<p>like, um, image crop or guttenberg block. I just always feel like we need, I, I\'m not convinced that people. Only at like truly think of it, it\'s just the block editor. Do you know what I mean? Yeah.<br /></p>\n\n\n\n<p>[00:42:00] Yeah, that\'s.<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Probably have all these memorized, but I was gonna go back into the plugin. So we have mm-hmm. Go ahead.&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> Um, just the, that we can, um, keyword stuff, the title too. So going back to the plugin tab, crop express,<br /></p>\n\n\n\n<p>crop express, four featured images or, um,<br /></p>\n\n\n\n<p>I\'m just trying to think of what the key, what the keywords might be like. Hmm. [00:43:00] I don\'t think we need WordPress.<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Yeah, I was trying to say something like car is a,<br /></p>\n\n\n\n<p>it keeps it native, I guess. Like you don\'t have to go outside of WordPress. There\'s a better term for that, I\'m sure.&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> Right, but I guess this, this is more like, this is more search rankings. I literally think repeating Crop Express for featured images for media library for Gutenberg block. Um,<br /></p>\n\n\n\n<p>yeah, I think, I think that that\'s, to me, that\'s what, what the purpose would be. It\'s, it doesn\'t hurt, like those are human readable words, but I do think it helps the seo.<br /></p>\n\n\n\n<p>Okay. [00:44:00] And I put block, I don\'t know how long this can be, right? Uh, I mean, short pixels is pretty long. Say what?<br /></p>\n\n\n\n<p>I am, I\'m comparing other ones in the repo and like short, short pixel image optimizer Dash Optimize Image is Convert WebP and a V I f. Like they\'re, they\'re, the title of theirs is 66 characters, so I feel like we\'re, we\'ve got room to play with.[00:45:00]&nbsp;<br /></p>\n\n\n\n<p>Uh, the sentence above, you can take out featured images, so crop express speeds up your content workflow. Uh, giving you uniform images for your blog post. I think you can take out featured because we now have expanded, but I still love this intro. Um, so even the title at the top, make cropping featured images you can take out featured.<br /></p>\n\n\n\n<p>So making<br /></p>\n\n\n\n<p>that what you meant right here. Yeah, and, and again, that I think that could be similar to the short description. So rather than make cropping images, we could just say crop images easier.<br /></p>\n\n\n\n<p>Yep. I think it\'s bad English, [00:46:00] but I think it.<br /></p>\n\n\n\n<p>But I think, yeah, we define the problem, we define the high level solution well, and then talk about features, which is the formula you\'re kind of supposed to follow. Mm-hmm.<br /></p>\n\n\n\n<p>Nice.<br /></p>\n\n\n\n<p>And I would even add another one, uh, below that first one you just said. Say, um, something like, uh, round avatar images or something like that. Like shapes is shapes and down the road we can add [00:47:00] stars and rainbows and unicorns if we want. But you know, I still think that it\'s pretty amazing that you can crop a circle.<br /></p>\n\n\n\n<p>Uh, yeah, there you go.<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Love it<br /></p>\n\n\n\n<p>and the set sizing defaults give. I don\'t know if guardrails communicate cross cultures, but um, to me it\'s like put those Boeing bumpers on your client, right? From like doing crappy stuff. So giving some, you\'re kind of making it easier on your client by giving them some base. You\'re, you\'re actually taking out the [00:48:00] possibility of error on the client you deliver work for by giving them some.<br /></p>\n\n\n\n<p>So keep them for,&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> um, Prevent uploading the wrong,<br /></p>\n\n\n\n<p>wrong image, like it\'s really wrong size and shape image, but that\'s really wordy.<br /></p>\n\n\n\n<p>Huge images that slow down your site. There you go. Nice.<br /></p>\n\n\n\n<p>Yep.<br /></p>\n\n\n\n<p>Um, you could also, uh, another, you another new under the, the second item is, um, media library.[00:49:00]&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Just throw things out just to get us going.&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> Absolutely.<br /></p>\n\n\n\n<p>Yeah, we\'ve got, at this point we\'ve got the three integration points, featured images, media library, and Gutenberg block. Um, and then we\'ve got settings.<br /></p>\n\n\n\n<p>[00:50:00] Settings.&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Got the block you said, I\'m sorry. Feature damage image and then the standalone block? Mm-hmm. Okay.<br /></p>\n\n\n\n<p>I\'m just testing that. I don\'t know if it works. [00:51:00] I almost feel like putting this above here and then, you know, new, like the first one is the block. Yep. That\'s cool. It\'s in post copy images by sizes set. Image<br /></p>\n\n\n\n<p>three, need it. Let\'s see. I almost feel like this needs to be, I don\'t know. I don\'t want to nitpick it too much. Image sizing.<br /></p>\n\n\n\n<p>Okay. Anything I missed?&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> No, I think this is a great next version. Okay.&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Save it. Mm-hmm.[00:52:00]&nbsp;<br /></p>\n\n\n\n<p>Can you do custom ratios? Mm-hmm.<br /></p>\n\n\n\n<p>Where already said that. See, so it\'s really a square circle or&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> you\'re accustom, right? I I feel like, I mean, it\'s circle, circle or anything else. So, um, pick the most pocket aspect ratios or create your own. Crop a circle if you want to kind of thing. Yeah, I mean they\'re, cuz they\'re all,[00:53:00]&nbsp;<br /></p>\n\n\n\n<p>yeah, I think that\'s great. You\'re done. Okay.<br /></p>\n\n\n\n<p>Now do you just need this? Yeah, so if you\'ve hit update code and it updated, uh, cuz I\'m not seeing our new tags in there, so I don\'t think we\'ve updated. Oh. Update code. There we go. There we go. Yeah. So send that to me and I\'ll, I\'ll drop it in. Cool.<br /></p>\n\n\n\n<p>Done. Great. Um, so I actually need to bounce. Okay. Um, But yeah, you send that to me. Uh, we\'ll plug that in. I\'ll upload it later today. And then, um, again, I I, there\'s a little bit of a long tail, there\'s a couple more the settings that we wanted to add and [00:54:00] stuff like that, but, um, you know, let\'s, again, I\'m, I\'m excited to kind of let it, let it simmer for a while.<br /></p>\n\n\n\n<p>Yeah.&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> Okay. Sounds good to me. I\'m gonna put some notes about the next topic. In chat, um, just so that We\'ll, they\'ll be there and I won\'t lose them.&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> Yeah, yeah. I\'m sorry. I\'ve, I\'m, yeah, no problem. I\'m getting lost, but, um, yeah, we could also, let\'s, you know, let\'s schedule a call, uh, tomorrow, Friday, too. Okay.<br /></p>\n\n\n\n<p>Sounds&nbsp;<br /></p>\n\n\n\n<p><strong>Cory Miller:</strong> good, man. Enjoy San Francisco.&nbsp;<br /></p>\n\n\n\n<p><strong>Corey Maass:</strong> Thank you. Thanks man.</p>\n\n\n\n<h2><br /></h2>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Apr 2023 02:13:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Cory Miller\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: Yoast SEO 20.5 Drops Support for PHP 5.6, 7.0, and 7.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143580\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wptavern.com/yoast-seo-20-5-drops-support-for-php-5-6-7-0-and-7-1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2178:\"<p><a href=\"https://yoast.com/yoast-seo-april-11-2023\">Yoast SEO 20.5</a> was released this week with several security fixes and an improved Google SERP preview. The preview shows mobile and desktop snippets with Google&#8217;s current styling so users can see exactly how their snippets will look and tweak how they optimize them for Google Search results.</p>\n\n\n\n<img />\n\n\n\n<p>Another highlight of this release is that Yoast SEO has dropped compatibility with PHP 5.6, 7.0 and 7.1. The plugin now requires PHP 7.2.5 or higher (along with WP 6.0). While this may seem extreme at first glance, approximately 89.9% of WordPress sites are running on PHP 7.2+. WordPress doesn&#8217;t cross-reference these stats with WP version numbers, but it&#8217;s possible sites running on much older versions of WordPress are also on unsupported versions of PHP.</p>\n\n\n\n<img />WordPress <a href=\"https://wordpress.org/about/stats/\">PHP Version Stats</a> &#8211; 4/11/2023\n\n\n\n<p>Getting WordPress sites to update to the latest versions of PHP is a slow-moving process, but historically Yoast SEO has been a force for change in pushing users to upgrade their PHP versions. In version 4.5, released in 2017, <a href=\"https://wptavern.com/yoast-seo-4-5-urges-users-to-upgrade-to-php-7\">Yoast SEO threw the weight of its estimated 6.5 million user base behind the movement to push hosts to upgrade their customers to PHP 7</a>. That version of the plugin introduced a large, non-dismissible notice urging site administrators to upgrade to PHP 7.</p>\n\n\n\n<p>“To move the web forward, we need to take a stand against old, slow, and unsafe software,&#8221; Yoast founder Joost de Valk said at that time. “Because web hosts are not upgrading PHP, we have decided to start pushing this from within plugins.&#8221; He contended that the WordPress ecosystem was losing good developers because the project was moving too slowly and also made the case for security and speed.</p>\n\n\n\n<p>Although the latest version 20.5 will be incompatible with approximately 10% of WordPress sites running unsupported versions of PHP, this move forward is necessary for maintaining a healthy and secure ecosystem. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Apr 2023 00:54:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WPTavern: WordPress Gears Up for 2nd Women and Nonbinary Release Squad\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143582\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/wordpress-gears-up-for-2nd-women-and-nonbinary-release-squad\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3046:\"<p>WordPress Executive Director Josepha Haden Chomphosy is <a href=\"https://make.wordpress.org/core/2023/04/07/preparing-for-the-next-women-nonbinary-release-squad/\">coordinating a second women and nonbinary release squad</a> for the 6.4 release, which is anticipated to land in <a href=\"https://wordpress.org/about/roadmap/\">November 2023</a>. In 2020, <a href=\"https://wptavern.com/wordpress-5-6-simone-includes-new-twenty-twenty-one-theme-and-improved-editor\">WordPress 5.6 &#8220;Simone&#8221;</a> was led by an all-women and non-binary identifying release squad, a first in WordPress&#8217; history, and Haden Chomphosy is proposing the project go for it again.</p>\n\n\n\n<p>&#8220;Having a release squad comprised of folx we don’t typically see in technology also has a goal of increasing the number of underrepresented people who have experience maintaining, managing, and shipping software in an open source project,&#8221; Haden Chomphosy said. &#8220;All contributions to the release and release process are welcome.&#8221;</p>\n\n\n\n<p>WordPress 6.3, which is targeted for a mid-July release, will give prospective 6.4 squad members the opportunity to shadow more experienced contributors and gain new skills by working with mentors and assisting with the release. She is calling for mentors to join in preparing this new round of leaders. The process is a several-months long commitment that gives contributors a head start on understanding their roles in the squad, though it is not required for participation in the 6.4 release.</p>\n\n\n\n<p>Haden Chomphosy emphasized that anyone will be able to contribute to the release but the leaders in the 6.4 squad will be limited to this specific group.</p>\n\n\n\n<p>&#8220;I short-hand the release to &#8216;women and nonbinary&#8217; for easy referencing in our day-to-day collaboration, but the release squad will be open to anyone who identifies as a woman, nonbinary, or gender-expansive,&#8221; she said. &#8220;All contributions are welcome as always, regardless of how you identify or what groups you feel part of.&#8221;</p>\n\n\n\n<p>WordPress has gained valuable new contributors and leaders from this initiative in the past, including 6.2 Core Tech Co-Leads Tonya Mork.</p>\n\n\n\n<p>&#8220;Before joining the 5.6 Release Squad, I had <em>not</em> contributed to the project,&#8221; Mork said. &#8220;I had no idea how the release cycle worked or where to start. Yup, I was a contributing noob. But with mentoring, I was <em>well supported</em> in my onboarding. <em>And you will be too! The experience was and still is incredible!</em>&#8220;</p>\n\n\n\n<p>Based on the response to Haden Chomphosy&#8217;s proposal, there should be no shortage of contributors and volunteers available to help with the women and nonbinary 6.4 release squad. She is requesting anyone who wants to be part of the squad or help as a mentor leading up to the release to leave a comment on the <a href=\"https://make.wordpress.org/core/2023/04/07/preparing-for-the-next-women-nonbinary-release-squad/\">post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Apr 2023 21:02:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Post Status: Women &amp; Nonbinary Release • WP-CLI 2.8.0 • Redesign Update • Build Block Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=148909\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://poststatus.com/women-nonbinary-release-wp-cli-2-8-0-redesign-update-build-block-theme/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16726:\"<h2 id=\"h-this-week-at-wordpress-org-april-3-2023\">This Week at WordPress.org (April 3, 2023)</h2>\n\n\n<div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">Sign up soon to mentor and be a part of the upcoming women and nonbinary release squad. Join the Test team in building a block theme. WP-CLI 2.8.0 is coming soon with PHP 8.2 compatibility. Get the latest updates on the WordPress.org redesign.  </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-kadence-infobox kt-info-box_94d1bd-77\"><div class=\"kt-blocks-info-box-link-wrap kt-blocks-info-box-media-align-left kt-info-halign-left\"><div class=\"kt-blocks-info-box-media-container\"><div class=\"kt-blocks-info-box-media kt-info-media-animate-none\"><div class=\"kadence-info-box-icon-container kt-info-icon-animate-none\"><div class=\"kadence-info-box-icon-inner-container\"><span class=\"kb-svg-icon-wrap kb-svg-icon-fas_paint-brush kt-info-svg-icon\"></span></div></div></div></div><div class=\"kt-infobox-textcontent\"><h2 class=\"kt-blocks-info-box-title\">Women and Nonbinary Release Squad, WP-CLI 2.8.0 Release, Redesign Update</h2><p class=\"kt-blocks-info-box-text\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f9b8-1f3fb-200d-2640-fe0f.png\" alt=\"🦸🏻‍♀️\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2023/04/07/preparing-for-the-next-women-nonbinary-release-squad/\">Preparing for the Next Women & Nonbinary Release Squad</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f477-1f3fe.png\" alt=\"👷🏾\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/test/2023/03/29/fse-program-exploration-build-a-block-theme/\">FSE Program Exploration: Build a block theme</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f7e6.png\" alt=\"🟦\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2023/03/30/proposal-the-interactivity-api-a-better-developer-experience-in-building-interactive-blocks/\">Proposal: The Interactivity API – A better developer experience in building interactive blocks</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f469-1f3fb-200d-1f4bb.png\" alt=\"👩🏻‍💻\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/cli/2023/04/05/wp-cli-v2-8-0-release-date/\">WP-CLI v2.8.0 release date</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f58c.png\" alt=\"🖌\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/meta/2023/04/10/wordpress-org-redesign-update-2/\">WordPress.org Redesign Update</a></p></div></div></div>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_b57166-6e\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<h2 id=\"h-news\"><a href=\"https://wordpress.org/news\">News</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2023/04/episode-53-a-look-at-wordpress-6-2-dolphy/\">WP Briefing: Episode 53: A Look at WordPress 6.2 “Dolphy”</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_8f6276-eb\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<div class=\"is-layout-flex wp-container-5 wp-block-columns\">\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-community\"><a href=\"https://make.wordpress.org/community\">Community</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/community/2023/04/07/its-time-to-plan-your-wp20-anniversary-celebration/\">It’s Time to Plan Your WP20 Anniversary Celebration!!</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2023/04/06/personalised-coupon-codes-for-wordcamps/\">Personalised Coupon Codes for WordCamps</a></li>\n</ul>\n\n\n\n<h2 id=\"h-core\"><a href=\"https://make.wordpress.org/core\">Core</a> </h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/04/10/a-week-in-core-april-10-2023/\">A Week in Core – April 10, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/04/07/preparing-for-the-next-women-nonbinary-release-squad/\">Preparing for the Next Women & Nonbinary Release Squad</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/04/03/preferred-languages-help-test-the-latest-version/\">Preferred Languages: Help test the latest version</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/30/proposal-the-interactivity-api-a-better-developer-experience-in-building-interactive-blocks/\">Proposal: The Interactivity API – A better developer experience in building interactive blocks</a></li>\n</ul>\n\n\n\n<h3 id=\"h-developer-blog\"><a href=\"https://developer.wordpress.org/news/\">Developer Blog</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://developer.wordpress.org/news/2023/04/whats-new-for-developers-april-2023/\">What’s new for developers? (April 2023)</a></li>\n</ul>\n\n\n\n<h3 id=\"h-meetings\">Meetings</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/04/12/editor-chat-summary-wednesday-12th-april-2023/\">Editor chat summary: Wednesday, 12th April 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/04/11/dev-chat-agenda-april-12-2023/\">Dev Chat agenda, April 12, 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-design\"><a href=\"https://make.wordpress.org/design\">Design</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/design/2023/03/30/why-jazz/\">Why Jazz?</a></li>\n</ul>\n\n\n\n<h2 id=\"h-docs\"><a href=\"https://make.wordpress.org/docs\">Docs</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/docs/2023/04/11/summary-for-docs-team-meeting-april-4-2023/\">Summary for Docs Team meeting, April 4, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/04/10/documentation-team-update-april-10-2023/\">Documentation Team Update – April 10, 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-hosting\"><a href=\"https://make.wordpress.org/hosting\">Hosting</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/hosting/2023/04/11/hosting-team-meeting-agenda-2023-04-12/\">Hosting Team meeting agenda 2023-04-12</a></li>\n</ul>\n\n\n\n<h2 id=\"h-marketing\"><a href=\"https://make.wordpress.org/marketing\">Marketing</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/marketing/2023/04/11/notes-global-marketing-team-meeting-4-april-2023/\">Notes: Global Marketing Team meeting, 4 April 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-meta\"><a href=\"https://make.wordpress.org/meta\">Meta</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/meta/2023/04/10/wordpress-org-redesign-update-2/\">WordPress.org Redesign Update</a></li>\n</ul>\n\n\n\n<h2 id=\"h-mobile\"><a href=\"https://make.wordpress.org/mobile\">Mobile</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/mobile/2023/04/11/contribute-to-the-future-of-the-wordpress-app/\">Contribute to the Future of the WordPress App</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/04/07/mobile-team-update-april-6th-2/\">Mobile Team Update – April 6th</a></li>\n</ul>\n\n\n\n<h2 id=\"h-openverse\"><a href=\"https://make.wordpress.org/openverse\">Openverse</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/openverse/2023/04/11/new-repository-for-storing-sensitive-terms/\">New repository for storing sensitive terms</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/openverse/2023/04/11/community-meeting-recap-2023-04-11/\">Community Meeting Recap (2023-04-11)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/openverse/2023/04/10/last-week-openverse-2023-04-03-2023-04-10/\">A week in Openverse: 2023-04-03 – 2023-04-10</a></li>\n</ul>\n\n\n\n<h2 id=\"h-performance\"><a href=\"https://make.wordpress.org/performance/\">Performance</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/04/11/performance-chat-summary-11-april-2023/\">Performance Chat Summary: 11 April 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-plugins\"><a href=\"https://make.wordpress.org/plugins\">Plugins</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/plugins/2023/03/21/use-of-code-generators-must-remain-gpl-compatible/\">Use of Code Generators Must Remain GPL Compatible</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/plugins/2023/03/10/advance-notice-of-retirement/\">Advance Notice of Retirement</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/04/11/plugin-team-status-april-10-2023/\">Plugin Team Status: April 10, 2023</a></li>\n</ul>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-polyglots\"><a href=\"https://make.wordpress.org/polyglots\">Polyglots</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/polyglots/2023/04/12/agenda-weekly-polyglots-chat-april-12-2023-1300-utc/\">Agenda: Weekly Polyglots Chat – April 12, 2023 (13:00 UTC)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/polyglots/2023/04/11/polyglots-outreach-effort-retrospective/\">Polyglots outreach effort retrospective</a></li>\n</ul>\n\n\n\n<h2 id=\"h-project\">Project</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/project/2023/02/06/proposal-creating-a-wordpress-contributor-mentorship-program/\">Proposal: Creating a WordPress Contributor Mentorship Program</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/project/2023/01/27/discussion-ending-the-eternal-september/\">Discussion: Ending the Eternal September</a></li>\n</ul>\n\n\n\n<h2 id=\"h-support\"><a href=\"https://make.wordpress.org/support\">Support</a></h2>\n\n\n\n<ul>\n<li> <a href=\"https://make.wordpress.org/support/2023/03/support-ticket-triage-session-april-5th-2023-at-1600-utc/\">Support ticket triage session – April 5th 2023 at 16:00 UTC&nbsp;</a></li>\n</ul>\n\n\n\n<h2 id=\"h-test\"><a href=\"https://make.wordpress.org/test\">Test</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/test/2023/04/11/test-chat-summary-11-april-2023/\">Test Chat Summary: 11 April 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2023/04/04/hallway-hangout-lets-chat-about-moving-to-the-site-editor/\">Hallway Hangout: Let’s chat about Moving to the Site Editor</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2023/03/29/fse-program-exploration-build-a-block-theme/\">FSE Program Exploration: Build a block theme</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/04/10/test-team-update-10-april-2023/\">Test Team Update: 10 April 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-theme\">Theme</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/themes/2023/04/12/themes-team-meeting-notes-april-11-2023/\">Themes Team Meeting Notes – April 11, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/themes/2023/04/04/theme-handbook-overhaul-proposal/\">Theme Handbook Overhaul Proposal</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/04/11/themes-team-update-april-11-2023/\">Themes team update April 11, 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-training\"><a href=\"https://make.wordpress.org/training\">Training</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/training/2023/04/11/training-team-meeting-recap-for-april-4-2023/\">Training Team Meeting Recap for April 4, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2023/04/05/proposal-creating-learning-pathways-for-learn-wordpress/\">Proposal: Creating Learning Pathways for Learn WordPress</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2023/03/29/introduction-to-wordpress-development-syllabus/\">Introduction to WordPress Development syllabus</a></li>\n</ul>\n\n\n\n<h3 id=\"h-lesson-plans\"><a href=\"https://learn.wordpress.org/lesson-plans\">Lesson Plans</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/lesson-plan/ta-pages-vs-posts/\">பக்கங்கள் Vs. இடுகைகள்</a></li>\n</ul>\n\n\n\n<h3 id=\"h-tutorials\"><a href=\"https://learn.wordpress.org/tutorials\">Tutorials</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorial/adding-a-sticky-header-or-banner/\">Adding a sticky header or banner</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/extending-wordpress-common-security-vulnerabilities/\">Extending WordPress: common security vulnerabilities</a></li>\n</ul>\n\n\n\n<h3 id=\"h-online-workshops\">Online Workshops</h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/?meeting=a-beginners-guide-to-setting-up-a-basic-website-website-design\">A Beginner’s Guide to Setting Up a Basic Website: Website Design</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=a-beginners-guide-to-setting-up-a-basic-website-content-planning\">A Beginner’s Guide to Setting Up a Basic Website: Content Planning</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=becoming-a-better-developer\">Becoming a Better Developer</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=building-a-page-with-only-patterns\">Building a page with only patterns</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=lets-code-creating-a-wordpress-multisite-network\">Let’s code: creating a WordPress multisite network</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=community-sharing-favorite-themes\">Community Sharing: Favorite Themes</a></li>\n</ul>\n\n\n\n<h3 id=\"h-courses\"><a href=\"https://learn.wordpress.org/courses\">Courses</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/course/converting-a-shortcode-to-a-block/\">Converting a Shortcode to a Block</a></li>\n</ul>\n\n\n\n<h2 id=\"h-wp-cli\">WP-CLI</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/cli/2023/04/05/wp-cli-v2-8-0-release-date/\">WP-CLI v2.8.0 release date</a></li>\n</ul>\n\n\n\n<h2 id=\"h-wptv\">WPTV</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.tv/category/year/2022/\">Latest WordPress TV videos</a></li>\n</ul>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 id=\"h-related-news\">Related News:</h2>\n\n\n\n<ul>\n<li><a href=\"https://www.php.net/archive/2023.php#2023-02-14-2\">PHP 8.2.4 Released!</a></li>\n\n\n\n<li><a href=\"https://www.php.net/archive/2023.php#2023-03-16-1\">PHP 8.1.17 Released!</a></li>\n\n\n\n<li><a href=\"https://262.ecma-international.org/13.0/\">TC39</a></li>\n\n\n\n<li><a href=\"https://github.com/composer/composer/releases/tag/2.5.5\">Composer 2.5.5</a></li>\n</ul>\n\n\n\n<p class=\"has-theme-palette-7-background-color has-background\">Thanks for reading our WP dot .org roundup! Each week we are highlighting the news and discussions coming from the good folks making WordPress possible. If you or your company create products or services that use WordPress, you need to be engaged with them and their work. Be sure to share this resource with your product and project managers. <br /><br /><strong>Are you interested in giving back and contributing your time and skills to WordPress.org?</strong> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/support/article/contributing-to-wordpress/\">Start Here ›</a><br /><br /><strong>Get our weekly WordPress community news digest</strong> — Post Status\' <a href=\"https://poststatus.com/news/week-in-review/\">Week in Review</a> — covering the WP/Woo news plus significant writing and podcasts. It\'s also available in <a href=\"https://poststatus.com/newsletter\">our newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f48c.png\" alt=\"💌\" class=\"wp-smiley\" /></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-background\"><a href=\"https://poststatus.com/\"><img src=\"https://cdn.poststatus.com/wp-content/uploads/2021/09/vertical-post-status-logo-250.png\" alt=\"Post Status\" class=\"wp-image-85823 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p class=\"has-text-align-left has-normal-font-size\" id=\"h-get-ready-for-remote-work\">You — and <a href=\"https://poststatus.com/#Agency\">your whole team</a> can <a href=\"https://poststatus.com/#choose-membership\">Join Post Status</a> too!</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job — or your next hire.</strong> Read the <strong>Post Status</strong> <a href=\"https://poststatus.com/newsletter/\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to <a href=\"https://poststatus.com/podcasts/\">podcasts</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/post_status/\">@Post_Status</a> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> and <a href=\"https://www.linkedin.com/company/post-status-llc/\">LinkedIn</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4bc.png\" alt=\"💼\" class=\"wp-smiley\" /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Apr 2023 19:17:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: #71 – Nathan Ingram on How To Manage Contracts With Your WordPress Clients\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=143522\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://wptavern.com/podcast/71-nathan-ingram-on-how-to-manage-contracts-with-your-wordpress-clients\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:50678:\"Transcription<div>\n<p>[00:00:00] Nathan Wrigley: Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley. Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case how to manage your website client contracts.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the show, I&#8217;m very keen to hear from you and hopefully get you or your idea on the podcast as soon as possible. Head over to WPTavern.com forward slash contact forward slash jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Nathan Ingram. Nathan is the host at iThemes Training, where he teaches WordPress and business development topics via live webinar. Based in Birmingham, Alabama, he has been working with clients to build websites since 1995.</p>\n\n\n\n<p>He&#8217;s also the creator of MonsterContracts, which helps WordPress professionals create contracts for their client work.</p>\n\n\n\n<p>If you&#8217;ve worked directly with clients, then you&#8217;ll know that things don&#8217;t always go according to plan. Assets might not be delivered on time. The client does not respond to your emails. The expectations of the client begins to creep away from the original proposal.</p>\n\n\n\n<p>Whilst there&#8217;s unlikely to be a perfect system to ensure that all projects run according to the plan, you can protect yourself from some of the worst aspects. And for this, you may need a contract.</p>\n\n\n\n<p>Nathan is on the podcast today to talk about why he thinks contracts are an essential part of any client facing WordPress work.</p>\n\n\n\n<p>We begin by talking about how the contract is designed as a tool to bring clarity to both parties. You, the website builder, can set out the constraints within which you work and the client can understand what they can, and cannot, expect from you. Nathan thinks that setting these expectations before the project begins leads to fewer problems later on.</p>\n\n\n\n<p>We talk about the fact that contracts don&#8217;t need to contain overly complex legal language, but they do need to be checked by a qualified legal professional before they&#8217;re deployed.</p>\n\n\n\n<p>Nathan also explains how he&#8217;s refined his contract over the years, tweaking the wording and the structure, depending upon the project at hand.</p>\n\n\n\n<p>We then get into what you can realistically do should your client breach the contract. Are you able to turn off their website, or withhold work that you&#8217;ve completed? Nathan&#8217;s not really in favour of sending in the lawyers as soon as something goes wrong. Rather trying to resolve any conflict through better communication.</p>\n\n\n\n<p>It&#8217;s an interesting conversation, which makes contracts seem less adversarial and more about ensuring that your WordPress website projects run as smoothly as possible.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading over to WPTavern.com forward slash podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Nathan Ingram.</p>\n\n\n\n<p>I am joined on the podcast by Nathan Ingram. Hello, Nathan.</p>\n\n\n\n<p>[00:04:07] Nathan Ingram: Hey Nathan, how are you?</p>\n\n\n\n<p>[00:04:08] Nathan Wrigley: That&#8217;s strange. I&#8217;ve not had that before. Two Nathan&#8217;s on the podcast today. Very different levels of experience in the subject that we&#8217;re going to be talking about. Nathan Ingram is here today and he&#8217;s going to be talking to us about the legal aspects of hiring clients.</p>\n\n\n\n<p>You might describe it in one word as contracts, I guess. And there&#8217;s a whole treasure trove of things that we&#8217;re going to unpack there. But before we do that, Nathan, if anybody hasn&#8217;t heard of you before and hasn&#8217;t seen the things that you are doing online, would you just spend a few minutes introducing yourself? You can go back as far as you like but, give us yourself in the WordPress context.</p>\n\n\n\n<p>[00:04:44] Nathan Ingram: Yeah, sure. So I&#8217;ve been working with WordPress exclusively since right around 2010. I run a small agency down in Birmingham, Alabama. I&#8217;ve been working with clients since 1995. So I&#8217;ve been around the webspace for quite a while. I also am the host at iThemes Training. So we do live training webinars three days a week through iThemes. And then I also do some business coaching, and I have a product called MonsterContracts.</p>\n\n\n\n<p>[00:05:08] Nathan Wrigley: Tell us about the iThemes thing for a minute, because I know you do trainings over there. How did that all come about? Was it like a happy coincidence that you ended up doing that? Were you making content, training content, elsewhere that got you into that position?</p>\n\n\n\n<p>[00:05:22] Nathan Ingram: No goodness. So it&#8217;s really an interesting story and we could take a whole , a whole episode on how do people find their way in the WordPress community? So for me, iThemes was actually iThemes training at that time. Early on it was called webdesign.com. They had leased that really awesome domain name.</p>\n\n\n\n<p>And it was where I learned WordPress. At that point I was sort of in a, the Macromedia ecosystem, and I had resisted WordPress for quite a while. Decided this is coming and I&#8217;ve got to go with the flow and move into WordPress, because a lot of my clients were looking for WordPress sites. Or sites they could log in and edit themselves. I found iThemes as a theme company, and the training went hand in hand, and that&#8217;s where I learned WordPress. And gradually over time, I started presenting one or two webinars and then gradually rolled into the presenter role.</p>\n\n\n\n<p>[00:06:08] Nathan Wrigley: That&#8217;s nice. And so you do that regularly, three times a week. You go live and give trainings about a whole range of different subjects, right?</p>\n\n\n\n<p>[00:06:15] Nathan Ingram: Yeah, like just yesterday we did our monthly news roundup on iThemes training. So look at the news in the WordPress world. Particularly from the perspective of people who build and manage websites. That&#8217;s really our audience on iThemes training. What news is important for people who do what I do.</p>\n\n\n\n<p>[00:06:29] Nathan Wrigley: Okay, so that&#8217;s really excellent. Unfortunately, it&#8217;s not the topic that we&#8217;re going to be talking about today. We&#8217;re talking about one of the areas, I think in web design that really can cause the blue touch paper to be lit, and the firework to go off. This is the whole thing of relationships with clients and the boundaries that you set, and whether you should have contracts, and whether you should be getting involved with lawyers and things like that.</p>\n\n\n\n<p>And there are very few parts of the business that I used to run, which would cause me to become upset, irritable, and in some cases quite angry. But relationships with clients could do that. It&#8217;s quite unique, isn&#8217;t it?.</p>\n\n\n\n<p>[00:07:15] Nathan Ingram: Oh, it really is, and I&#8217;ll tell you, it is certainly one of the common challenges that people who do WordPress things run into. You go to WordCamps, back when we used to have those things, so we actually just had our WordCamp Birmingham two weeks ago, and it was wonderful to see people in person. But when you get a group of people who work with clients around, you know, a table eating lunch at an event like a WordCamp, inevitably the conversation turns to bad clients and everybody has a story.</p>\n\n\n\n<p>[00:07:40] Nathan Wrigley: Yeah, it&#8217;s just one of those things. I&#8217;ve got a whole litany of stories. On the whole I think I was able to manage this scenario fairly well, but there was a lot of things probably that I shouldn&#8217;t have done. So I gave way in many cases because I believed that the things that the client was asking for didn&#8217;t really push the boundaries too far, although they certainly stepped over the expectations that I had.</p>\n\n\n\n<p>But your premise really, the reason why you&#8217;ve been getting into this and talking about this is because you want to prepare people and educate people to give them a kind of legal framework. And you describe it in terms of boxing in a client if you like. That&#8217;s probably too harsh a word.</p>\n\n\n\n<p>You go about it in much more conciliatory language than that. But the point is, you are educating people to get themselves into a position where they&#8217;ve got some piece of paperwork, some contract. Something written down somewhere where you can all go back and say, okay, these are the boundaries, these are the constraints. If we step outside of these, one of us is at fault. So tell us a little bit more about your approach there.</p>\n\n\n\n<p>[00:08:47] Nathan Ingram: That&#8217;s a great question. So years ago I put talk together about dealing with problem clients. And the title of the talk was &#8220;dealing with problem clients, building fences around friendly monsters&#8221;. And it&#8217;s a book, actually now I turned that into a book on Amazon. But, it&#8217;s really positioning the client, every client as what I would call a friendly monster.</p>\n\n\n\n<p>Meaning they&#8217;re friendly, but they still have teeth. The idea is we need to build fences around the clients that we work with, because we never know what kind of person we&#8217;re dealing with. And the fences that I talk about are the systems and processes in our business.</p>\n\n\n\n<p>Four in particular. We need to establish clarity. We need to have good commitments between us and our clients. We need to have communication and documentation. And those four fences can show up in a lot of different ways depending on your particular business and how you work. And there may be additional fences you&#8217;d want to build, but those four at least have to be in place in order to have good ongoing client relationships.</p>\n\n\n\n<p>And a lot of those things show up in a contract. But they start as just part of your regular business system, the way you work, the way you deal with clients. Clarity, commitments, communication, documentation. And that&#8217;s where it all has to start. Like you&#8217;ve got to get your house in order before you can really bring in a good document, like a contract to, make your rules clear.</p>\n\n\n\n<p>[00:10:10] Nathan Wrigley: I think the clarity piece coming first is really intriguing. Because that was always the misstep that I felt I&#8217;d made. In that I was very often in a position where I felt that I had explained myself clearly, and assuming the clients were being honest when they were explaining their frustration with the way things were going.</p>\n\n\n\n<p>I clearly hadn&#8217;t done that. I maybe expressed it in a way which I understood, maybe that was too technical. And later down the road it became obvious that there was a complete disconnect between what I was trying to achieve, and what they, in their head, had got designed. And so yeah, the clarity piece, I think is perfect at the beginning, but also quite difficult to achieve. How do you, how do you advise that? What are some of the strategies that you&#8217;ve got in place around that?</p>\n\n\n\n<p>[00:10:57] Nathan Ingram: Yeah, it really is difficult, and one of the first things I think you have to realize is that agreement on the surface does not equal clarity. So, if there&#8217;s no meeting of the minds, like maybe we use technical jargon, or maybe the client doesn&#8217;t tell you everything at the beginning.</p>\n\n\n\n<p>I can&#8217;t tell you how many projects I&#8217;ve gotten into where the client, we&#8217;ll get three quarters of the way through the project, and they&#8217;re like, oh, well where do my clients log in? Well, wait, we haven&#8217;t talked about this at all. And in those sorts of situations you ask yourself, well, whose fault is that?</p>\n\n\n\n<p>And I would say it&#8217;s probably 50 50. And so one of the great skills that we can develop in in way, but specifically in our way of working with people on the web, is learning the skill of asking great questions. If you learn the skill of asking great questions, and continuing to ask until you reach that point of clarity. That skill can really set you apart from other people that are doing client work.</p>\n\n\n\n<p>Asking a question, asking why, and following up with additional questions until you really get down to the root of what the client expects. If you don&#8217;t do that, then oftentimes you can be saying one thing, the client can be saying another, and you&#8217;re both shaking your head up and down, but nobody is really clear on what we&#8217;re saying. Assumptions are made.</p>\n\n\n\n<p>[00:12:08] Nathan Wrigley: In the work that you do, do you typically do all of that client exploration work prior to beginning the build? And then in a sense, that process is closed off, and you go away and you take six weeks, whatever it takes to complete your initial first offering and then go back to the client? Or do you, do you encourage a more agile approach where you iterate with the client? I mean, I know that they&#8217;re completely different ways of doing things. Curious as to know what your process is.</p>\n\n\n\n<p>[00:12:36] Nathan Ingram: So it really depends on the complexity of the build. We try to get some understanding of that at the very beginning, when we&#8217;re trying to create the scope of work. If it&#8217;s a project we&#8217;ve done before, if it&#8217;s a simple, just a basic identity piece, a brochure site, that&#8217;s fairly simple.</p>\n\n\n\n<p>When you get into something that is a lot more complicated, maybe there&#8217;s lots of different content types, or you&#8217;ve got to do some really interesting thing with data. A lot of times what we&#8217;ll end up doing, and I picked this up from my friend Beth Livingston, a change budget. So adding a change budget into the original pricing, that as we go forward and the client gets more ideas where things are uncovered, that we didn&#8217;t realize, there&#8217;s some pre-approved money sitting there, that the client can say, okay, we&#8217;ll allocate some of that change budget to build this thing that we hadn&#8217;t talked about yet.</p>\n\n\n\n<p>[00:13:22] Nathan Wrigley: Yeah, we&#8217;re in such a curious industry as well, in that there&#8217;s not many things that I purchase that morph over time. You know, if I go into a shop and I buy some clothes, I&#8217;m just getting what I&#8217;m getting. I can see it right off the bat, and there it is, and I can hold it in my hands, and it&#8217;s either what I want or it&#8217;s not what I want.</p>\n\n\n\n<p>I&#8217;m not going to purchase that pair of trousers and then turned around a week later and said, actually, you know what? These pockets. I&#8217;ve been wearing these trousers for a couple of weeks now, and the pockets are not deep enough. Can we have an amendment to the pockets please? This curious idea of scope creep that creeps into more or less every project that I was ever involved in.</p>\n\n\n\n<p>Are you getting your clients, after your initial discussions then, are you getting them to a point where you draw up some contract which in effect puts the four fences around the friendly monster that you were describing?</p>\n\n\n\n<p>[00:14:12] Nathan Ingram: In our world we would call that the scope of work, which is part of the proposal. That comes from the original conversation. Or if it&#8217;s a complicated project, maybe there&#8217;s a discovery phase that happens first to really flesh out, what is the scope of work? What are we trying to accomplish in this project.</p>\n\n\n\n<p>And then depending on the complexity of the project, the longer, or the more complex a project is, the greater chance of scope creep. Or honestly, the longer a project takes, because the client delays on content or something else. The longer a project takes also, you tend to have scope creep.</p>\n\n\n\n<p>When you talk about scope creep, people&#8217;s eyes roll. They hate scope creep. But I&#8217;ll tell you what, I love scope creep as long as there&#8217;s corresponding price creep, right? If you want more things, that&#8217;s great. It&#8217;s just we can&#8217;t do more for the same price. In your analogy about, we don&#8217;t use the word trousers.</p>\n\n\n\n<p>[00:15:00] Nathan Wrigley: Oh yeah, you use pants don&#8217;t you? I apologize.</p>\n\n\n\n<p>[00:15:02] Nathan Ingram: Yeah. When you&#8217;re talking about something like that, it&#8217;s a little bit different because, well some people sell websites more as a product rather than a custom service. We&#8217;re more on the custom build side. Everything we do is bespoke. But you know, if you&#8217;re selling websites as a service, that is a good analogy because you&#8217;re in package three and this is what it comes with and this is your pair of pants.</p>\n\n\n\n<p>But for us it would be more like, I&#8217;m hiring a contractor to come in and do a remodel on a kitchen .And this is kind of what we talk about at the beginning, but as we go, maybe we had a problem we didn&#8217;t anticipate. Or maybe my wife sees something on television that she wants to add. And so we want to add to it and we change it along the way. That&#8217;s really a closer analogy, I would think, to a custom website.</p>\n\n\n\n<p>[00:15:44] Nathan Wrigley: It&#8217;s pretty clear that the audience for this podcast is pretty broad and deep. In other words, there are all sorts of people listening to this doing all sorts of work around the WordPress space. Some of them very new to WordPress and website building at all. Some of them just doing it for their own hobbies. Other people just getting into building websites for the first time.</p>\n\n\n\n<p>So let&#8217;s speak to that crowd first. The crowd who really are just embarking on a career. They&#8217;re scoping out whether they wish to build websites for other people and charge for that, and make a business out of that. Let&#8217;s speak to the importance of a contract, because it may be that when you&#8217;re starting out, you&#8217;re just doing this with friends and we know that that can turn south quite quickly.</p>\n\n\n\n<p>So, and also, you know, you may be encouraging businesses in your local area to come on board and they&#8217;re going to be expecting something like a contract. Is this an essential component of the makeup of a web designer? Do you truly need a contract? Or is there any realistic situation where it&#8217;s okay to begin work on a website, charging a fee without some legal protection?</p>\n\n\n\n<p>[00:16:50] Nathan Ingram: Wow, what a great question. For years I worked without a contract. I just had a proposal with a scope of work and a price, and you pay me, I build the thing and there it goes. Then I started running into problems. Expectations that were never really talked about anywhere. For example, oh wait, this would&#8217;ve been like many years ago.</p>\n\n\n\n<p>But at that point it was maybe Internet Explorer 6 was the browser of choice for everyone. And the person would say, wait this is not working on my Internet Explorer 4. Well, we don&#8217;t design for older browsers, we design for newer browsers. And there was great difference in rendering between those two.</p>\n\n\n\n<p>These are the sorts of things that you don&#8217;t think about until you have a problem with a client. What I like to say is you don&#8217;t need a contract for good clients. You need a contract for bad clients. But my goodness, it&#8217;s hard to tell them apart at the beginning. So every client gets a contract. And my contract is mostly plain English, and virtually every paragraph in that contract, aside from the necessary legal constructions, everything in that contract is there because I had a problem one time with a client. That now gets added to the contract for the next time.</p>\n\n\n\n<p>[00:17:59] Nathan Wrigley: I was very much like you in that I began way back, and it was long before IE6 in fact. I remember writing that into my contracts at one point. We are not supporting IE6. It was exactly the problem you described. I had happily breezed through multiple websites. No problem at all, everything was fine. I had a client who simply was able to push harder than anybody I&#8217;d come across before. In other words everything that I delivered, they would either reject or request it to be entirely different.</p>\n\n\n\n<p>So this whole notion to me of scope creep and the client who refused to accept that anything was finished, came along. And it really was at that point that I started to look around and try to protect myself. So, I would imagine that your advice is really, it doesn&#8217;t matter on what level you&#8217;re doing this. You need some kind of legal protection, right?</p>\n\n\n\n<p>[00:18:51] Nathan Ingram: So I would even take a step backwards. You need a consistent process that you use for every client, every project, every time. And that process needs to be documented somewhere in something that you and the client agree to. Call it whatever you want. Call it a contract. Call it, as we do, a master services agreement. You could put it in your proposal, but just have some place where everybody&#8217;s agreeing to the process. That&#8217;s that piece of clarity at the beginning where we are clear on how this is going to proceed.</p>\n\n\n\n<p>Where we get into trouble is where we, we think, well we just sort of do every project differently and there&#8217;s not really a consistent process. And so the client is able at that point to dictate how the project goes. Will have at some point, you know, some level of control over your world, as long as you&#8217;re building that website. Instead of realizing, okay, this is the best way to build. We&#8217;re going to document this process out, and have the client agree to it in a contract.</p>\n\n\n\n<p>[00:19:47] Nathan Wrigley: I guess whenever I&#8217;ve read legal contracts before, whether they&#8217;re for my car insurance or what have you. I&#8217;m always confounded by the language used, within moments of beginning the reading of it. I&#8217;m coming across, not only words which I haven&#8217;t encountered before, but the sentence construction is entirely bizarre.</p>\n\n\n\n<p>In other words, it can be read by a lawyer. Sometimes I&#8217;m confused as to whether or not it&#8217;s written deliberately to be hard read or whether or not it&#8217;s the most expedient way of hammering something down perfectly. I can never parse that. Either way, I&#8217;m left confounded.</p>\n\n\n\n<p>So given that lawyers very often end up with this language, which is impenetrable. And you mentioned that your contracts are in plain English. Is it possible to nail things down, absolutely watertight with plain English? And do you feel yourself equipped to do that? Or is this really the domain of a lawyer? Do we need to get a lawyer to go through your contract and inspect it to make sure that in every scenario it&#8217;s having your back?</p>\n\n\n\n<p>[00:20:59] Nathan Ingram: So, just first of all, I&#8217;ll answer this from my perspective as a person who&#8217;s been working with clients, doing web things for over 25 years. I&#8217;m not an attorney. This is not legal advice or anything like that. But my experience has been sort of a blend of both.</p>\n\n\n\n<p>It&#8217;s important to have good, practical experience working with clients and knowing what the problems are. But you also do need the legal language. Because if the worst thing happens and you end up in court with a client, there&#8217;s a reason that attorneys write things the way they do. You know, this is language that has been proven out and so forth.</p>\n\n\n\n<p>And so if you take a contract that is exclusively plain English, you can get tied up with defining what the meanings of this word and that word and so forth are, and it turns into a mess. So, if you went out today and you did a search for a web design contract on the web, you would find two types of contracts in general.</p>\n\n\n\n<p>You would find some that are just absolutely plain English with no legal constructions whatsoever. And those are okay. They do establish clarity, or give you kind of a template to establish some clarity. But they don&#8217;t have the legal protections. On the other side, it&#8217;s like the total opposite end of the spectrum. Contracts that are a hundred percent legalese, and I don&#8217;t understand what some of these things mean. And this is what you were talking about a bit earlier. And I&#8217;m not sure if that really gives clarity to the client, because nobody really knows what any of this means unless you&#8217;re an attorney.</p>\n\n\n\n<p>And so what I found to be the best approach, and this is what I&#8217;ve done, is I began years ago explaining our process. Explaining what we do, what we don&#8217;t do. Explaining some of the issues like browser compatibility, and what happens if you hire a digital marketing person that comes in and they break your website. Are we responsible for that because we&#8217;re managing your website.</p>\n\n\n\n<p>All of the bad experiences I&#8217;ve had with clients, I started putting those things down in a document and then I gave that to an attorney and said, okay, make this legal. And so they added all the necessary legal constructions, and patched the holes. Over time this has become my agency contract, and that&#8217;s what I ultimately turned into MonsterContracts.</p>\n\n\n\n<p>[00:23:02] Nathan Wrigley: With your contracts, did you find that the nature of the project at hand, in other words, the one that you&#8217;re working on right now. Given that each client website is slightly different and it may have different constraints. It may need, I don&#8217;t know, let&#8217;s imagine, a WooCommerce store or something like that. We really are getting into a completely different variety of website. Or it may be a simple brochure site. Or it may be that there&#8217;s a bespoke plugin, for example, has to be written for that website.</p>\n\n\n\n<p>Do you advise taking those contracts that you&#8217;ve had written, or rather inspected by lawyers, do you take them back and get them to look, more of a scan through each time and append to it, the bits and pieces that are needed? Or have you settled on a contract which you think is broadly good enough to fit any situation?</p>\n\n\n\n<p>[00:23:50] Nathan Ingram: It&#8217;s a great question. So this exact situation is why I recommend a two document approach. So we have a proposal of services that deals with the scope of work and the price for every individual project. And those are going to be different every time. But then we have a master services agreement, or a contract, that has the rules of the road for every project. These don&#8217;t change. And so we present those documents together.</p>\n\n\n\n<p>So the contract that the master services agreement covers the process. All these things that we do and timeframes, and what happens if you don&#8217;t pay and, here&#8217;s how the website management works, and we don&#8217;t guarantee results for SEO.</p>\n\n\n\n<p>All these things that need to be in a contract that don&#8217;t change from project to project, are there in the contract. But then the scope of work of we&#8217;re going to build this plugin, or we&#8217;re going to add a store, we&#8217;re going to do whatever. Those are in the proposal, which is the scope of work and the price for that individual project.</p>\n\n\n\n<p>[00:24:43] Nathan Wrigley: Right, okay, that&#8217;s an intriguing separation. Yeah, so two different documents. One which is more bespoke and one which is more generic and you can reuse over and over again.</p>\n\n\n\n<p>[00:24:53] Nathan Ingram: Exactly.</p>\n\n\n\n<p>[00:24:54] Nathan Wrigley: So, given that we&#8217;ve got a contract. Given that it&#8217;s been written by a lawyer, and there may be aspects in there that are impenetrable to us. I guess there&#8217;s always going to be a need to go back to the lawyers. I can imagine the fees of this starting to tick up quite quickly actually. Because if a client comes back to you and you believe they&#8217;re in breach of the contract in some way, but the contract is difficult to read, it&#8217;s in that legal language. That&#8217;s an important thing to do, isn&#8217;t it? You really do have to understand the ins and outs of your contract.</p>\n\n\n\n<p>So given any scenario of inverted commas, wrongdoing by the client, you are able to say to them with confidence, look, this is what you signed. This is what this clause in the contract meant. In other words, you have to know what it says in plain English in your head. Otherwise you can&#8217;t really enforce it, because you wouldn&#8217;t be sure what you were able to enforce.</p>\n\n\n\n<p>[00:25:47] Nathan Ingram: Right, and this is why if you were to open my agency contract, or if you were to look at MonsterContracts. You would see things like payment terms, and they&#8217;re all in plain English. Again, this is why I said earlier, I want to have my system documented ahead of time.</p>\n\n\n\n<p>Like I want to know, internally, this is how we deal with late payments. This is what happens if the client disappears during a project, all these things. We have our policies internally for this. Those are then put into the contract in very plain wording that can be easily pointed to. There have to be legal constructions, but these are, they&#8217;re really at the end of the document and they don&#8217;t pertain, nearly as much to these practical issues that come up with the client.</p>\n\n\n\n<p>[00:26:28] Nathan Wrigley: Do you ever, so this is a question more directed at you personally, given that you&#8217;ve got all these contracts and you&#8217;ve thought all of this through. Do you ever let things slip, in other words, you&#8217;re having a conflict internally. Part of you saying, I know that this client is now in breach of what the, not only the spirit, but the letter of the contract said. But I&#8217;ve got a bit of a spidey sense that I can let this one go. It feels like it&#8217;s going to be all right. Because there be monsters down there.</p>\n\n\n\n<p>And it&#8217;s so easy. I did that and probably continue to do that quite a bit, because sometimes I feel that if I push the legal button, I really have transformed everything. I&#8217;ve suddenly gone from it being a fairly friendly relationship, albeit fraught at times. To a really adversarial relationship where the lawyers are getting involved and so on. So I&#8217;m just wondering whether or you permit yourself to ignore your contracts in some scenarios.</p>\n\n\n\n<p>[00:27:24] Nathan Ingram: Oh, what a great question. So the answer to that question, it revolves around emotional intelligence, right? you have to make a judgment call on, is this a situation that is worth really enforcing the contract or not. And honestly, many times, let&#8217;s just say, here&#8217;s the situation. The client, we&#8217;ve been waiting for three months for the client to supply assets that are needed to build the website, and that happens all the time, right? Clients delay, delay, delay for content, and photography and everything.</p>\n\n\n\n<p>So, in the contract, it says if we haven&#8217;t heard from you in 30 days, then your project is suspended. And there&#8217;s some things that happen as a result of that. Now, can we choose to change that? Sure, but oftentimes what will solve that problem is a simple email to the client. Hey, we haven&#8217;t heard from you in the last 30 days. At this point your project is about to go into suspended status. And this is what that means.</p>\n\n\n\n<p>We explain in the contract. And just having a clarifying email like that can oftentimes shake up the client and get them refocused on the project. If it doesn&#8217;t, then you have to make a judgment call on, is this a salvageable project or not?</p>\n\n\n\n<p>[00:28:34] Nathan Wrigley: Yeah, I feel like I&#8217;ve encountered many different interpretations of this. On the one hand, there&#8217;s a lot of people out there in the wild who really are proponents of, look, the minute it goes wrong, start lawyering. Just protect yourself. Get the lawyers involved. You cease communication with the client and start to go through the lawyers.</p>\n\n\n\n<p>It&#8217;s this idea of, it&#8217;s not working out. I need you to do what you&#8217;ve agreed right now, otherwise it doesn&#8217;t work. We also hear constantly about firing clients and the joy that that can bring.</p>\n\n\n\n<p>But on the other hand, I feel that, like you said, you have to judge off your own instincts sometimes whether there is a legitimate reason behind there. And that has happened to me. You know, I&#8217;ve had clients that have not delivered things, and then it turns out there&#8217;s not only a plausible reason, but a reason, which if it were me in their shoes, I would desperately want the web designer to understand my crisis.</p>\n\n\n\n<p>Something personal has happened, some event in their life has meant that they literally have been away from the computer for weeks on end. And so it&#8217;s not really their fault. I guess the answer is use your judgment. Invoke the spidey sense, and figure out which is the best way to proceed.</p>\n\n\n\n<p>[00:29:42] Nathan Ingram: For sure. I mean, we&#8217;re dealing with people here, right? And so my default dealing with people is generally grace. I&#8217;m very gracious with people. Understanding about issues that come up. On the other hand, it&#8217;s important to have a document that protects you. If you get to the point where you have to fire the client.</p>\n\n\n\n<p>That&#8217;s a great conversation. And, and you hear a lot, especially on social media and Facebook groups and places like that. Oh, we got to fire the client. This whole discussion, right? But that&#8217;s complicated. If you want to fire the client, can you even do that? Do you have a contract that specifies what happens if you want to terminate the relationship?</p>\n\n\n\n<p>That&#8217;s where having a good document that protects you is critical, because you know at some point, oh, the client didn&#8217;t pay me, so I&#8217;m going to turn their website off. Well, guess what? If you just turn their website off for non payment, and they haven&#8217;t agreed to that stipulation, then you can get sued for that.</p>\n\n\n\n<p>Well you didn&#8217;t give me due process and whatever. And you can find yourself in a lot of trouble if you don&#8217;t have a good document that protects you. So my advice is always have a great contract that is weighted towards you as the service provider, and then you can choose to be gracious when you want.</p>\n\n\n\n<p>[00:30:44] Nathan Wrigley: So let&#8217;s get into that bit. You were mentioning about switching the website off. So it&#8217;s almost like the sanctions piece. What do you have in your arsenal as a web designer, which you can bring to bear should you need to apply a little bit of pressure to make sure that things are moving? So I&#8217;m describing a scenario now where things have clearly gone south.</p>\n\n\n\n<p>We&#8217;re definitely in the territory of miscommunication has been heaped upon miscommunication. We&#8217;re at the point of almost falling out. Communication is breaking down, and so we now need to bring out the big guns, if you like. What have we got? You mentioned turning off the website, that&#8217;s obviously one thing that we could do, given that that was in a contract.</p>\n\n\n\n<p>I&#8217;m thinking we could refuse to do any additional work. There&#8217;s obviously the refusal to communicate unless you go through lawyers at this point. What are the kind of things that you would put in your contracts that you would allow yourself to have as an option?</p>\n\n\n\n<p>[00:31:40] Nathan Ingram: So it would obviously depend on where we are in the process of the project. But if you&#8217;re in the middle of building the site, the client is texting you at 2:00 AM, or whatever. This is clearly not going to work, and we&#8217;ve tried to communicate and tried to request the client to change their behaviour, and they just simply won&#8217;t do it for whatever reason, and you need to pull the plug on the project. Then, you know at that point, at least my contract says, we as an agency get to evaluate the work that&#8217;s been done and say, okay, 78% has been completed and so you owe this much more.</p>\n\n\n\n<p>Or if we&#8217;ve already received full payment, we&#8217;ll refund that much or whatever. You need some process by which you can mitigate or decide who gets what at the end of this. So if you&#8217;re in the middle of the project, and you want to pull the plug, somebody has to figure that out.</p>\n\n\n\n<p>If it&#8217;s a client that&#8217;s maybe in a management phase and they&#8217;re just not paying their bill or they&#8217;re asking for too much or whatever, it&#8217;s always a conversation. What&#8217;s going on here? And is there something we don&#8217;t understand about this? But, at some point you have to have an agreement that if you don&#8217;t pay your bill within certain time, then we do suspend the website from view.</p>\n\n\n\n<p>[00:32:46] Nathan Wrigley: I guess there is also a point where you have to cease communication through anything other than the lawyers. Because at some point any stream of email going left, right, and center has to be mediated by a professional who&#8217;s removed from all of this.</p>\n\n\n\n<p>[00:33:03] Nathan Ingram: Yeah, you really do. And you know, we first tried to do arbitration, just to try to keep things out of court. That&#8217;s just a personal preference. But at some point you have to do that. Now, thankfully I&#8217;ve never even gotten close to anything like that, and I&#8217;ve heard horror stories of where it&#8217;s gotten to that point.</p>\n\n\n\n<p>You know, a lot of this is, as you work with clients and you have good client experiences and bad client experiences. You start to develop, like you said earlier, this spidey sense. This radar of early on, like before you even sign a proposal with a client, getting better at filtering out the bad clients at the beginning.</p>\n\n\n\n<p>Hopefully over time that becomes part of this, where you don&#8217;t have nearly the issues. Early on I had bad clients. They would take advantage of me. they didn&#8217;t want to pay. They wanted to pay a just a little bit, not really what the work was worth.</p>\n\n\n\n<p>They would constantly second guess and question my professional decisions. It was just terrible. I began to realize there are better clients out there and, not let those difficult clients in our world to begin with.</p>\n\n\n\n<p>[00:34:02] Nathan Wrigley: It&#8217;s interesting as this podcast has gone on, we&#8217;ve concentrated on the negative aspect of contracts, in the, you know, we&#8217;re protecting ourselves. This horrible thing could happen, so make sure you&#8217;ve got some protection. Oh, and this horrible thing could happen. But really, it&#8217;s the opposite, isn&#8217;t it? The contract is there to give you peace of mind. It&#8217;s to create a sort of positive scenario.</p>\n\n\n\n<p>And so hopefully you won&#8217;t find yourself in these positions. If the contract is robust enough, everybody signed it, read it, understood it, then those boundaries are in place so that these disasters don&#8217;t occur. So there&#8217;s a bit of silver lining on this cloud.</p>\n\n\n\n<p>[00:34:38] Nathan Ingram: Oh, it absolutely is. There&#8217;s this old story about this mother who&#8217;d warned her children about playing next to the road because they lived next to this busy highway. And oh, don&#8217;t get close to the road because, you know, you could get hit by a car or whatever. And so the kids would not go just a few feet from the house because they were terrified of this road.</p>\n\n\n\n<p>And then they realized, well, our kids aren&#8217;t even playing in our yard. So they put up a fence between the yard and the road. And the kids then could play within the boundaries of the fence and weren&#8217;t afraid of the road anymore. And that&#8217;s just a little example of put up a fence, a contract, and it really frees you to work better with clients.</p>\n\n\n\n<p>And in my experience, it&#8217;s if a client out of the gate, if the client pushes back against some of the things in our contract, it&#8217;s a huge red flag that we probably don&#8217;t want to work with this client, just right away. Because everything that is in our contract is there for a reason.</p>\n\n\n\n<p>I tell the clients that. It&#8217;s a rather long document, but everything is there for a purpose. And if you have questions about it, I&#8217;m happy to answer those, you know, happy to talk through why we do this. But it&#8217;s there for a reason and it really establishes the boundaries of our relationship.</p>\n\n\n\n<p>And the remarkable thing about all of this is, people look at a contract, well, I&#8217;m afraid to get my clients to sign this, it&#8217;s really long or whatever. The good clients have no problem signing contracts like this. They welcome it. It&#8217;s a mark of your professionalism that you&#8217;ve thought through your business well enough to have a well crafted document that governs this whole process of us working together.</p>\n\n\n\n<p>[00:36:03] Nathan Wrigley: You&#8217;ve obviously given this a great deal of thought in the past. You live in the United States and you mentioned Alabama. Obviously America&#8217;s a tapestry of different states with laws and, honestly I don&#8217;t understand that a little bit. But in the UK we have UK law and then there&#8217;s EU law, and then obviously there&#8217;s law in other jurisdictions.</p>\n\n\n\n<p>This, I suppose is something which we might mention right now, towards the end of our recording. You&#8217;ve got to have that in mind as well. It really does matter where you are and where the clients are because I guess you&#8217;ve got to think about the law. Should it go wrong, are you protected correctly given where the client is and where you are?</p>\n\n\n\n<p>[00:36:40] Nathan Ingram: Yeah, for sure. There&#8217;s a lot of local laws that govern things that you wouldn&#8217;t think about. And that&#8217;s why it&#8217;s critical to have a local attorney that understands technology and things like intellectual property and these sorts of things, to take a look at whatever document you have.</p>\n\n\n\n<p>One of the biggest challenges with MonsterContracts was, okay, I&#8217;ve got this document that I have a hundred percent faith in for my work here, and really even state to state. There are very few things that would have to change from state to state, using in the United States.</p>\n\n\n\n<p>But then we started getting some people buying the product internationally. And I began to wonder, wow, how is this going to work? I did have some experience. I had a coaching client, somebody that I was working with in business development who lived there in the UK. I provided her a copy of the contract and she had it vetted through a local attorney there.</p>\n\n\n\n<p>There were just very few changes. So, the way that at least my contract works is most of it, and I would just, pulling a number out of the air, say 80% of the document is just plain language about processes and things like that. And the legal language is at the end. So the attorney in the area, whether it&#8217;s internationally or locally in a different state or whatever, they could just substitute the little bits of standard legal language at the end and make it work wherever you are. And we now have people who&#8217;ve bought MonsterContracts all over the world and they&#8217;re having that experience where the attorney can review it with maybe one or two hours of time. It works great for their location.</p>\n\n\n\n<p>[00:38:05] Nathan Wrigley: So just give us the quick elevator pitch of MonsterContracts. It sounds like that it&#8217;s a service that you can essentially log in, pay your subs, and then you can extract from it contracts, which hopefully you can then use.</p>\n\n\n\n<p>[00:38:19] Nathan Ingram: That&#8217;s basically it. And so again, this is, it&#8217;s based on my contract that over 25 years of working with clients, I&#8217;ve gradually made better until it&#8217;s virtually bulletproof, I think, in my opinion. The MonsterContracts is simply a Word document. You log in, you purchase the document. You take this. You tweak anything that&#8217;s there to match your processes or the, you know, if you don&#8217;t do things in the same order that the contract specifies, change that around. Plain simple wording. And then the recommendation is always take that to your local attorney to allow them to, you know, run through it and make any changes.</p>\n\n\n\n<p>And universally the response has been, one or two hours of time and it&#8217;s done. So, for most people they&#8217;re going to have one of the two types. So if they&#8217;re using a contract, they have the type that&#8217;s just plain English and full of holes, or it&#8217;s just a bunch of legalese that no one understands.</p>\n\n\n\n<p>MonsterContracts it addresses the specific situations that we encounter as web professionals, and it provides the cover that you need to grow your business. It addresses all the things that we deal with in client work.</p>\n\n\n\n<p>[00:39:16] Nathan Wrigley: I think you&#8217;ve got a system whereby you can submit amendments that you&#8217;ve had made. So let&#8217;s say for example, in my case, the UK. I could make amendments and then submit them back to MonsterContracts so that other people can benefit from that as well.</p>\n\n\n\n<p>[00:39:32] Nathan Ingram: Yeah, exactly. So we have the ability to do that. That&#8217;s an area of MonsterContracts that I&#8217;m really working on growing this year. We haven&#8217;t had as many members do that as I had hoped originally. And so that&#8217;s one of our goals this year is to expand those revisions. MonsterContracts is a subscription, just to keep access because we do have the contract vetted by an attorney annually.</p>\n\n\n\n<p>And, there are usually at least a few changes to the contract every year to just keep up to date with things that are happening in client work. The subscription gives you access to those changes as well as any revisions that people upload. And if you upload a revision that&#8217;s accepted we credit you for that year&#8217;s cost.</p>\n\n\n\n<p>[00:40:06] Nathan Wrigley: So a scary subject hopefully somewhat tamed by having contracts. Nathan, thanks for chatting to us today and putting our minds at rest and giving us some advice. If the listeners to this would like to get in touch or figure out where you are or begin a chat with you, what are the best, some of the best places to find you online?</p>\n\n\n\n<p>[00:40:26] Nathan Ingram: Yeah, sure. So, monstercontracts.com is, the place to find the MonsterContracts product. There&#8217;s a great contact form there if you want to reach out to me about any contract related questions. My coaching website is nathaningram.com. That is available out there for coaching work or questions around that subject. And I&#8217;m online three days a week with iThemes training, at training.ithemes.com.</p>\n\n\n\n<p>[00:40:48] Nathan Wrigley: Nathan Ingram, thank you so much for chatting to us on the podcast today. I really appreciate it.</p>\n\n\n\n<p>[00:40:52] Nathan Ingram: Thanks, Nathan. I enjoyed it.</p>\n</div>\n\n\n\n<p>On the podcast today, we have <a href=\"https://nathaningram.com/\">Nathan Ingram</a>.</p>\n\n\n\n<p>Nathan is the host at iThemes Training where he teaches WordPress and business development topics via live webinar. Based in Birmingham, Alabama, he has been working with clients to build websites since 1995.</p>\n\n\n\n<p>He’s also the creator of MonsterContracts, which helps WordPress professionals create contracts for their client work.</p>\n\n\n\n<p>If you’ve worked directly with clients, then you’ll know that things don’t always go according to plan. Assets might not be delivered on time. The client does not respond to your emails. The expectations of the client begins to creep away from the original proposal.</p>\n\n\n\n<p>Whilst there’s unlikely to be a perfect system to ensure that all projects run according to the plan, you can protect yourself from some of the worst aspects, and for this, you may need a contract.</p>\n\n\n\n<p>Nathan is on the podcast today to talk about why he thinks contracts are an essential part of any client facing WordPress work.</p>\n\n\n\n<p>We begin by talking about how the contract is designed as a tool to bring clarity to both parties. You, the website builder, can set out the constraints within which you work, and the client can understand what they can, and cannot, expect from you. Nathan thinks that setting these expectations before the project begins leads to fewer problems later on.</p>\n\n\n\n<p>We talk about the fact that contracts don’t need to contain overly complex legal language, but they do need to be checked by a qualified legal professional before they’re deployed.</p>\n\n\n\n<p>Nathan also explains how he’s refined his contracts over the years, tweaking the wording and the structure, depending upon the project at hand.</p>\n\n\n\n<p>We then get into what you can realistically do should your client breach the contract. Are you able to turn off their website or withhold work that you’ve completed? Nathan’s not really in favour of sending in the lawyers as soon as something goes wrong, rather trying to resolve any conflict through better communication.</p>\n\n\n\n<p>It’s an interesting conversation which makes contracts seem less adversarial and more about ensuring that your WordPress website projects run as smoothly as possible.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links.</h2>\n\n\n\n<p><a href=\"https://training.ithemes.com/\">iThemes Training</a></p>\n\n\n\n<p><a href=\"https://monstercontracts.com/\">MonsterContracts</a></p>\n\n\n\n<p><a href=\"https://birmingham.wordcamp.org/2023/\">WordCamp Birmingham</a></p>\n\n\n\n<p>Nathan&#8217;s &#8220;Dealing with problem clients, building fences around friendly monsters&#8221; <a href=\"https://www.youtube.com/watch?v=jrSH7Mq8ZZs\">webinar</a>.</p>\n\n\n\n<p><a href=\"http://nathaningram.com\">Nathan&#8217;s website</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Apr 2023 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"Do The Woo Community: When WooCommerce Developers Need to Find an Accessibility Partner\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=74744\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://dothewoo.io/woocommerce-accessibility-partnerships/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:421:\"<p>With the need to make sure more sites start with being accessible, learn when you should consider bringing in a partner.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/woocommerce-accessibility-partnerships/\">When WooCommerce Developers Need to Find an Accessibility Partner</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Apr 2023 06:03:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: Limit Login Attempts Plugin Patches Severe Unauthenticated Stored XSS Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143554\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wptavern.com/limit-login-attempts-plugin-patches-severe-unauthenticated-stored-xss-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1622:\"<p>Wordfence has <a href=\"https://www.wordfence.com/blog/2023/04/update-now-severe-vulnerability-impacting-600000-sites-patched-in-limit-login-attempts/\">published</a> a security advisory about <a href=\"https://www.cve.org/CVERecord?id=CVE-2023-1912\">a severe unauthenticated stored Cross-Site Scripting vulnerability</a> in the <a href=\"https://wordpress.org/plugins/limit-login-attempts\">Limit Login Attempts</a> plugin, which is active on more than 600,000 WordPress sites. </p>\n\n\n\n<p>The security issue was discovered by Wordfence security researcher Marco Wotschka in January 2023. It was submitted to the WordPress Plugin Security Team, which acknowledged receipt of the report nearly two months later on March 24, 2023.</p>\n\n\n\n<p>&#8220;This can be leveraged by unauthenticated attackers to facilitate a site takeover by injecting malicious JavaScript into the database of an affected site that may execute when a site administrator accesses the logging page,&#8221; Wotschka said.</p>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/limit-login-attempts/\">Version 1.7.2</a> of the plugin patches the vulnerability. It was released on April 4 with a note in the changelog that simply says &#8220;Security fixes.&#8221; Version 1.7.1 and previous versions remain vulnerable. </p>\n\n\n\n<p>In August 2021, the plugin had more than 900,000 active users, and more than 2 million in 2018, but seems to be dying a slow death and is no longer maintained, as it hasn&#8217;t been updated in years.</p>\n\n\n\n<p>Wordfence has more details in the advisory on how the plugin might be exploited and advises users update immediately.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Apr 2023 03:19:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:122:\"WPTavern: TeamWP Launches Team Experience Index To Measure Employee Engagement and Satisfaction in the WordPress Ecosystem\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143527\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:133:\"https://wptavern.com/teamwp-launches-team-experience-index-to-measure-employee-engagement-and-satisfaction-in-the-wordpress-ecosystem\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1868:\"<p>In February 2023, James Giroux <a href=\"https://teamwp.co/blog/the-benefits-of-investing-in-employee-engagement/\">founded TeamWP</a>, a project that aims to advocate for open, people-first workplaces in the WordPress ecosystem. His first initiative was to launch the <a href=\"https://teamexperienceindex.com/\">Team Experience Index</a>, a benchmark employee engagement survey designed specifically for people working in the world of WordPress.</p>\n\n\n\n<p>“The distributed nature of WordPress companies means they often lack the resources and knowledge to create truly open, people-first workplaces,” Giroux said. “The Team Experience Index fills this gap by providing insights and benchmarks that help companies identify strengths and areas for improvement, fostering a more open, collaborative, and innovative work culture.”</p>\n\n\n\n<p>The comprehensive survey will be aggregated and anonymized. It takes approximately 4-7 minutes to complete and includes questions about employee experience, company culture, leadership, management and teamwork, career progression opportunities, professional development, compensation and recognition, and employees&#8217; individual experiences. </p>\n\n\n\n<p>While responses are recorded anonymously, it&#8217;s important to note that the company name is required, along with the employee&#8217;s role and the number of employees. Respondents should be aware that they are collectively giving away a lot of private information and should only share if they believe the insights will have a positive impact on the wider ecosystem.</p>\n\n\n\n<p>Giroux plans to share the initial results of the Team Experience Index at WordCamp Europe in Athens in June 2023. Anyone working at a WordPress product or service company, agency, or hosting company is invited to <a href=\"https://teamexperienceindex.com/\">complete the survey</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Apr 2023 20:55:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Do The Woo Community: Using WooCommerce Subscriptions at Scale with Devin Price\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=74726\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://dothewoo.io/woocommerce-subscriptions-at-scale/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:436:\"<p>When a site generates 10k orders each hour, and you have 8 million products going out, most of them on subscription, you need to know how to scale.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/woocommerce-subscriptions-at-scale/\">Using WooCommerce Subscriptions at Scale with Devin Price</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Apr 2023 08:10:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"WPTavern: WordPress Developers Are Experimenting With Gutenberg-Native AI Block and Content Assistants\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143492\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"https://wptavern.com/wordpress-developers-are-experimenting-with-gutenberg-native-ai-block-and-content-assistants\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5213:\"<p>As more WordPress <a href=\"https://wordpress.org/plugins/search/chatgpt/\">plugins for AI-generated content and images</a>, chatbots, and assistants, are landing in the official directory, developers are beginning to explore even deeper integration with the block editor. Moving beyond the prototypical content generators that are cobbled together into a plugin, the tools developers are experimenting with today will provide a more deeply integrated experience that works seamlessly with the block editor as a natural extension of its capabilities.</p>\n\n\n\n<p>Last week Human Made CTO Joe Hoyle <a href=\"https://humanmade.com/2023/04/06/wordpress-ai-generative-content-and-blocks/\">published</a> an early preview of generative AI natively integrated into the block editor with a video demonstrating prompts working across various blocks.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">I’ve been working on a WordPress Gutenberg-native AI copilot. The results were pretty astounding to me once I got GPT to “speak Gutenberg” <a href=\"https://t.co/adEfkPRHcb\">pic.twitter.com/adEfkPRHcb</a></p>&mdash; Joe Hoyle (@joe_hoyle) <a href=\"https://twitter.com/joe_hoyle/status/1643952243605925889?ref_src=twsrc%5Etfw\">April 6, 2023</a></blockquote>\n</div>\n\n\n\n<p>&#8220;Taking a native-first approach to integrating generative AI into WordPress, we’ve been experimenting with approaches to a &#8216;WordPress Copilot&#8217; that can &#8216;speak&#8217; Gutenberg / block-editor,&#8221; Hoyle said.</p>\n\n\n\n<p>&#8220;Copy-pasting paragraphs between ChatGPT and WordPress only goes so far, while having the tools directly embedded in the editor for block layout generation, auto-linking, formatting, translation summarization and more open up a world of possibilities and productivity wins for content creators.&#8221;</p>\n\n\n\n<p>Munir Kamal, WordPress developer and founder of Gutenberg Hub, has created a native AI writer with a similar UI to the tool Hoyle previewed, as they both were inspired by the <a href=\"https://www.notion.so/\">Notion app</a>. His preview video demonstrates far more capabilities than the earlier AI content generators for WordPress have implemented.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">I\'ve been working on a native AI writer inspired by Notion, designed to seamlessly integrate into <a href=\"https://twitter.com/hashtag/Gutenberg?src=hash&ref_src=twsrc%5Etfw\">#Gutenberg</a>. Unlike clunky admin approached <a href=\"https://twitter.com/hashtag/AI?src=hash&ref_src=twsrc%5Etfw\">#AI</a> plugins this will be your hidden Ai content assistant. Keep an eye out for it at the <a href=\"https://twitter.com/GutenbergHub?ref_src=twsrc%5Etfw\">@GutenbergHub</a> shop.<a href=\"https://twitter.com/hashtag/WordPress?src=hash&ref_src=twsrc%5Etfw\">#WordPress</a> <a href=\"https://twitter.com/hashtag/chatgpt?src=hash&ref_src=twsrc%5Etfw\">#chatgpt</a> <a href=\"https://t.co/WmCkJCpF0l\">pic.twitter.com/WmCkJCpF0l</a></p>&mdash; Munir Kamal (@m_munirkamal) <a href=\"https://twitter.com/m_munirkamal/status/1644406162966683661?ref_src=twsrc%5Etfw\">April 7, 2023</a></blockquote>\n</div>\n\n\n\n<p>Kamal has tapped into the GPT API to add more options to the AI writer, including the ability to rewrite, improve the generated text, fix grammar, simplify language, make it shorter, make it longer, and translate. He plans to release it as a commercial plugin in his <a href=\"https://shop.gutenberghub.com/\">Gutenberg Hub shop</a> when it&#8217;s ready.</p>\n\n\n\n<img />\n\n\n\n<p>&#8220;With the increasing advancements in AI technology, thanks to OpenAI for taking the leap, I believe it will become an even more integral part of blogging,&#8221; Kamal <a href=\"https://twitter.com/m_munirkamal/status/1644724907694227456\">said</a> when asked about AI and the future of blogging. &#8220;It can assist in generating ideas, improving grammar and structure, and even help with SEO optimization.</p>\n\n\n\n<p>Hoyle is equally optimistic on the future of AI integrated into WordPress tools. It will be exciting to see if his Gutenberg-native AI copilot can be extended to blocks inside the Site Editor, to offer a text prompt-guided design experience without having to click through the tools.</p>\n\n\n\n<p>&#8220;Going through this project has convinced me that LLMs [Large Language Model] have much more potential than I was giving them credit for,&#8221; Hoyle said. &#8220;It feels like there’s still a lot to discover what the models are capable of.</p>\n\n\n\n<p>&#8220;As the availability to GPT-4 (and with it larger token limits) increases, we see a clear path of improvement to what we’ve shown today. The data and information that is stored and available to the Content Management System is ideal for model-training and building a corpus of data specific to the user. Generating, improving and suggesting content of all types that is specific to the data set will be another lead forward in the utility of these tools. We see a future where AI will support and enhance the work we all do, and see the necessity to integrate the technology deeply into the tools and solutions we create.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Apr 2023 02:11:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WordPress.org blog: WP Briefing: Episode 53: A Look at WordPress 6.2 “Dolphy”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=14818\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wordpress.org/news/2023/04/episode-53-a-look-at-wordpress-6-2-dolphy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9229:\"<p>Named after the multi-instrumentalist Eric Allan Dolphy Jr., WordPress 6.2 &#8220;Dolphy&#8221;&#8216;s high notes are riffed on by WordPress&#8217;s Executive Director, Josepha Haden Chomphosy, in this 53rd episode of the WordPress Briefing.</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Credits</h2>\n\n\n\n<p>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a><br />Logo:&nbsp;<a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a><br />Production:&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a><br />Song: Fearless First by Kevin MacLeod </p>\n\n\n\n<h2 class=\"wp-block-heading\">Show Notes</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2023/03/dolphy/\">WordPress 6.2 &#8220;Dolphy&#8221;</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2023/03/introducing-the-wordpress-developer-blog/\">Introducing the WordPress Developer Blog</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/project/?p=251\">WordPress Contributor Mentorship Program</a></li>\n\n\n\n<li><a href=\"https://wp.me/p2U65r-9Nl\">Call for Volunteers: Contributor Working Group</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/design/?p=11037\">Why Jazz</a></li>\n\n\n\n<li>Make Slack channels <a href=\"https://wordpress.slack.com/archives/C04QZCREJ9W\">#kidscamp</a> and <a href=\"https://wordpress.slack.com/archives/C03JNV77Y57\">#sustainability</a> </li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Transcript</h2>\n\n\n\n<span id=\"more-14818\"></span>\n\n\n\n<p>[Josepha Haden Chomphosy 00:00:00] </p>\n\n\n\n<p>Hello everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress Open Source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks.</p>\n\n\n\n<p>I&#8217;m your host, Josepha Haden Chomphosy. Here we go.</p>\n\n\n\n<p>[00:00:28]</p>\n\n\n\n<p>The latest version of WordPress has shipped. WordPress 6.2, which was named after Eric Dolphy, was released on March 29th. And as is the way with software, there&#8217;s already a minor release underway to catch a few errant issues that folks like you have reported to us.</p>\n\n\n\n<p>It&#8217;s a big release that refines a lot of our design tools, but some of the most important changes are actually to the inserter. If you haven&#8217;t had a chance to get in there and play with it yet, here are the three things that I think you should know. </p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:01:08] </p>\n\n\n\n<p>First, the pattern browser. We&#8217;re all aware of the block inserter by now, and a lot of us probably use the quick options, the keyboard shortcuts, or that kind of inline inserter, that little black box that&#8217;s in the middle of your post.</p>\n\n\n\n<p>If you use the main inserter, that&#8217;s a blue square in the top left of the screen. If you use that to add a block, you can still add individual blocks as usual. But there&#8217;s a new way to browse patterns, and in my opinion, it is so much better. It now brings out this drawer that has like thumbnails of patterns that will work with your theme.</p>\n\n\n\n<p>And if you, like me, know what you want your site to look like, but could not in a million years figure out how to build it from scratch out of individual blocks, then this is the area for you. It was like shopping, but you don&#8217;t have to go through a checkout process at the end, and you still have what you want. It&#8217;s great.&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:02:00]&nbsp;</p>\n\n\n\n<p>That&#8217;s also available when you&#8217;re working on templates or template parts, so you can make changes everywhere instead of going page by page. The second thing that I think you should know is about the media browser in that same area where you browse your patterns; you can also now browse for media.</p>\n\n\n\n<p>It lets you look through the images you&#8217;ve already added to your site, but it also lets you search for openly licensed images from Openverse. And if you choose one of those images from Openverse, it inserts the proper attribution for you. You still have to add your own alt text, but that&#8217;s the fun part anyway, right?</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:02:35]&nbsp;</p>\n\n\n\n<p>And number three, a Style Book. So this thing is available in the template editing area, specifically, as is appropriate, given what it actually does. So if you&#8217;re in the template area, toward the top right of the screen is like a half moon day mode, night mode looking icon. If you click on that, you can make changes to things inside your blocks.</p>\n\n\n\n<p>But if you click on the little eyeball icon that&#8217;s just underneath it, it pulls up a style book where you can also see and edit the styles globally. If that didn&#8217;t make sense to you, don&#8217;t worry. I&#8217;ve got you. I&#8217;m about to tell you a bunch of things you can do in here. You can edit the way headings and lists and tables, quotes, and code looks all across the site. You can edit the way images, galleries, files, and videos look using custom CSS.</p>\n\n\n\n<p>Yes. Also, all across the site. And you can edit buttons, separators, and individual blocks. Say it with me &#8212; all across the site. That is not a comprehensive list. There is a ton of stuff. You can see the styles that you have applied across the whole site. You can see them in context, and you can make any changes that you need globally, which means all across the site.</p>\n\n\n\n<p>Yeah. Style Books. What will we think of next? </p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:03:54]&nbsp;</p>\n\n\n\n<p>So those are my three things I think you should know about WordPress right now. As a former WordPress builder who was never really super great with the code, this stuff makes me feel powerful. I just love these changes, and I hope you do too.</p>\n\n\n\n<p> [00:04:07]</p>\n\n\n\n<p>Which brings us now to our small list of big things. First, we just launched the Developer Blog. It&#8217;s over at developer.wordpress.org/news. It has a bunch of content on it that not only is geared specifically toward developers that are using WordPress but especially the folks who are extending WordPress. It gives you kind of an in-depth look at various changes and projects, and implementations and what goes into each one of them.</p>\n\n\n\n<p>So it gives you a bit of like this aspirational overview of stuff that you could do with WordPress and then also gives you an inside look at how you would accomplish it yourself. It&#8217;s very cool. I like it a lot. Head on over there, but we&#8217;ll have a link to the show notes below.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:05:00]&nbsp;</p>\n\n\n\n<p>The second thing is that we have an MVP of our new mentorship program that is underway.</p>\n\n\n\n<p>It should be debuting for essentially testing any day now, a link to the posts detailing that work, just in case you want to join that important initiative. But it is an important thing for me. I think that mentorship is a key element of many of our successful contributors&#8217; onboarding journeys, a part of their story of coming to us.</p>\n\n\n\n<p>And so, creating a mentorship program that is a bit sustainable and looks toward the health of the overall project, I think, is an excellent plan.&nbsp;</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:05:38]&nbsp;</p>\n\n\n\n<p>The third thing on our small list of big things is that Matt put out a nice little post about kind of the history of why jazz has this strong background in the WordPress project. It&#8217;s a brief read. I&#8217;ll put a link to that in the show notes as well. But suffice it to say that he&#8217;s saying that jazz has a little bit of learned processes and rules but that the primary expectation is that you&#8217;re able to make of the jazz what you want. Like you get to make your own thing out of it. You get to be extemporaneous. You get to be very measured, whatever it is, that expresses what you are trying to do and what you are trying to say with it.</p>\n\n\n\n<p>That&#8217;s why he feels like jazz is such an important part of the DNA of the WordPress project. Like I said, it&#8217;s a short read. I&#8217;ll put a link to it in the show notes.</p>\n\n\n\n<p>[Josepha Haden Chomphosy 00:06:30]&nbsp;</p>\n\n\n\n<p>And finally, there are a few working groups that folks can contribute to right now. We don&#8217;t always have working groups. We generally just kind of do stuff inside individual teams. But right now, we&#8217;ve got like the kids camp group, the sustainability group, and of course, that mentorship working group that I mentioned earlier in our list.</p>\n\n\n\n<p>So if you&#8217;re wanting a little change of pace, I&#8217;d drop by their areas in the Making WordPress Slack to see if they have anything that&#8217;s up your alley. </p>\n\n\n\n<p>And that, my friends, is your small list of big things. Thank you for tuning in today for the WordPress Briefing. I&#8217;m your host, Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Apr 2023 12:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Do The Woo Community: Woo DevChat Expands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=74708\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://dothewoo.io/woocommerce-devchat-expands/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:379:\"<p>By expanding our Woo DevChat it gives more of the WooCommerce and WordPress builder community a chance to share what they are building.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/woocommerce-devchat-expands/\">Woo DevChat Expands</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Apr 2023 08:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"Gutenberg Times: Gutenberg Changelog #81 – WordPress 6.2, Gutenberg 15.4 and 15.5, Phase 3 – Collaboration and a new  Interactivity API\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://gutenbergtimes.com/?post_type=podcast&p=23825\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://gutenbergtimes.com/podcast/gutenberg-changelog-81-wordpress-6-2-interactivity-api/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68348:\"<p>Leonardus Nugraha and Birgit Pauli-Haack discuss WordPress&nbsp; 6.2, Gutenberg Releases 15.4 and 15.5, Phase 3 of the Gutenberg Project and a new Proposal on Interactivity API.</p>\n\n\n\n<p><a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-69-gutenberg-releases-wordpress-6-0-1-the-create-block-theme/#shownotes\">Show Notes</a> / <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-81-wordpress-6-2-interactivity-api/#transcript\">Transcript</a></p>\n\n\n\n<ul>\n<li>Music:&nbsp;<a href=\"https://soundcloud.com/xirclebox\">Homer Gaines</a></li>\n\n\n\n<li>Editor:&nbsp;<a href=\"https://www.linkedin.com/in/sandy-reed/\">Sandy Reed</a></li>\n\n\n\n<li>Logo:&nbsp;<a href=\"https://markuraine.com/\">Mark Uraine</a></li>\n\n\n\n<li>Production:&nbsp;<a href=\"https://icodeforapurpose.com\">Birgit Pauli-Haack</a></li>\n</ul>\n\n\n\n<p class=\"has-larger-font-size\"></p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Leonardus</strong> Nugraha</h2>\n\n\n\n<ul>\n<li><a href=\"https://leoandlens.com/\">Leo&#8217;s Photography site  leoandlens.com</a></li>\n\n\n\n<li><a href=\"https://www.instagram.com/leonnugraha/\">On Instagram @leonnugraha</a> </li>\n\n\n\n<li><a href=\"https://profiles.wordpress.org/leonnugraha/\">WordPress Profile @leonnugraha</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">20-Year WordPress Anniversary</h2>\n\n\n\n<ul>\n<li><a href=\"https://wp20.wordpress.net/20-years-of-wordpress-jazz/\">20 Years of WordPress Jazz</a> Playlist </li>\n\n\n\n<li><a href=\"https://wordpress.org/about/history/\">Jazz musicians and WordPress releases</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Community Contribution</h2>\n\n\n\n<p><a href=\"https://blockvisibilitywp.com/block-visibility-3-0-0-a-new-chapter-begins/\">Block Visibility 3.0.0: A New Chapter Begins</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s released</h2>\n\n\n\n<h3 class=\"wp-block-heading\">WordPress 6.2</h3>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2023/03/dolphy/\">WordPress 6.2 “Dolphy”&nbsp;</a></li>\n\n\n\n<li>&nbsp;<a href=\"https://make.wordpress.org/core/2023/03/10/6-2-live-product-demo-qa/\">6.2 Live Product Demo Q&amp;A</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">WordPress 6.2 Field Guide</a></li>\n\n\n\n<li><strong>Leonardus Nugraha</strong>&nbsp;for Hostinger:&nbsp;<a href=\"https://www.hostinger.com/blog/wordpress-6-2\">WordPress 6.2 Is Finally Here: A Detailed Overview</a></li>\n\n\n\n<li><strong>WPTavern</strong>: <a href=\"https://wptavern.com/wordpress-6-2-dolphy-introduces-a-revamped-site-editor-distraction-free-writing-mode-and-updated-block-inserter\">WordPress 6.2 “Dolphy” Introduces a Revamped Site Editor, Distraction-Free Writing Mode, and Updated Block Inserter</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Gutenberg 15.4 &amp; 15.5</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/03/22/whats-new-in-gutenberg-15-4-22-march/\">What’s new in Gutenberg 15.4 (22 March)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/04/05/whats-new-in-gutenberg-15-5-05-april/\">What’s new in Gutenberg 15.5? (05 April)</a></li>\n\n\n\n<li><a href=\"https://wptavern.com/gutenberg-15-5-introduces-experimental-grid-layout-support\">Gutenberg 15.5 Introduces Experimental Grid Layout Support</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">What&#8217;s in active development or discussed</h3>\n\n\n\n<h3 class=\"wp-block-heading\">Phase 3: Collaboration </h3>\n\n\n\n<ul>\n<li>Post by Matias Ventura <a href=\"https://make.wordpress.org/core/2023/03/24/phase-3-collaboration/\">Phase 3: Collaboration</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/design/2022/06/13/thinking-through-the-wordpress-admin-experience/\">Thinking Through the WordPress Admin Experience</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2023/03/episode-52-phase-three-with-hector-prieto/\">WP Briefing: Episode 52: Workflows and Phase Three Visioning with Special Guest Héctor Prieto</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Improve the Site Editor</h3>\n\n\n\n<ul>\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/44461\">Re-Introduce Content Editing in the Site Editor</a></li>\n\n\n\n<li><a href=\"https://github.com/WordPress/gutenberg/issues/49404\">Optimize the content-centric edit experience</a></li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Interactivity API</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/03/30/proposal-the-interactivity-api-a-better-developer-experience-in-building-interactive-blocks/\">Proposal: The Interactivity API – A better developer experience in building interactive blocks</a></li>\n\n\n\n<li><a href=\"https://wpmovies.dev/\">Demo Site</a> </li>\n\n\n\n<li>GitHub: <a href=\"https://github.com/wordpress/wp-movies-demo\">Interactivity API Demo &#8211; WP Movies</a></li>\n\n\n\n<li>4/17/23 &#8211; 8am UTC <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/292575913/\">Developer Hours: Introduction to the Interactivity API</a> </li>\n\n\n\n<li>4/17/23 &#8211; 17:00 UTC <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/292575942/\">Developer Hours: Introduction to the Interactivity AP</a>I </li>\n\n\n\n<li><a href=\"https://wptavern.com/wordpress-contributors-propose-new-interactivity-api-for-frontend-blocks\">WordPress Contributors Propose New Interactivity API for Frontend Blocks</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress Design Team </h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/design/2023/03/27/design-share-mar-13-mar-24/\">Design Share: Mar 13–Mar 24</a></p>\n\n\n\n<p class=\"has-large-font-size\">Stay in Touch</p>\n\n\n\n<div class=\"wp-block-group is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<ul>\n<li>Did you like this episode? <a href=\"https://lovethepodcast.com/gutenbergchangelog\"><strong>Please write us a review </strong></a></li>\n\n\n\n<li>Ping us on Twitter or send DMs with questions. <a href=\"https://twitter.com/gutenbergtimes\">@gutenbergtimes </a>and <a href=\"https://twitter.com/bph\">@bph</a>.</li>\n\n\n\n<li><em>If you have questions or suggestions, or news you want us to include, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a>. </em></li>\n\n\n\n<li><em>Please write us a review on iTunes! <a href=\"https://gutenbergtimes.com/itunes/\">(Click here to learn how)</a></em></li>\n</ul>\n</div></div>\n\n\n\n<p class=\"has-large-font-size\">Transcript</p>\n\n\n\n<p> </p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Hello, and welcome to our 81st episode of the Gutenberg Changelog Podcast. In today&#8217;s episode, we will talk about WordPress 6.2, Gutenberg releases 15.4 and 15.5, Phase 3 of the Gutenberg project, a new proposal on the interactivity API, and so much more. I&#8217;m your host, Birgit Pauli-Haack, curator at the Gutenberg Times and full-time core contributor to the WordPress Open Source Project, and I&#8217;m so thrilled to introduce to you Leonardus Nugraha as my special guest today. Leonardus is a contributor to the WordPress docs team and content specialist at Hostinger, and we personally met at WordCamp Asia and had some great meals together. So welcome to the show, Leonardus. Thank you so much for agreeing to come to the show and talk about Gutenberg with me. How are you?</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah. Ah, thank you. Very good. Thank you for having me in the show. I&#8217;m good. And yeah, it&#8217;s nice to be here with your Gutenberg Changelog podcast. And it&#8217;s good to meet you again here after our in-person meetings. Yeah. It&#8217;s been two months we met in WordCamp Asia, right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; So it&#8217;s nice to have a chat with you again, talk about Gutenberg, talk about WordPress. Yeah. And yeah, thanks for introducing me as well. Yeah, you can call me Leo for short.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Oh, hi, Leo.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; And yeah, content. Yeah, Leo. And as a content specialist, I curate and organize WordPress content in hosting our tutorials and blogs. And with the documentation team, I also work on mainly end user documentation articles. So yeah, my work is all about WordPress articles. Yeah, I&#8217;m loving it. I&#8217;m loving to do things and work about WordPress.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, wonderful, wonderful. Yeah. Tell us a little bit about you. Where you live and what you do for fun. Do you have family?</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah, I live in Indonesia in a city named Bogor, and it&#8217;s known as Rain City.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Oh, no.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah, it rains a lot here, but it&#8217;s nice, it&#8217;s cool, it&#8217;s chill. I think personally, I love the weather. I&#8217;m not sure everyone else. Yeah, when I&#8217;m not working with content or WordPress in general, just for fun, I usually play music. I play guitar, electric guitar mainly, and listening to music on my free time, or just have fun with my dogs. I have two big dogs and I consider them as my family, to be honest.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, yeah, of course, of course. Yeah. That&#8217;s awesome. So many of our listeners are also dog people, and I&#8217;m sure they would like to know what kind of dogs you have, and do you share photos of them somewhere online?</p>\n\n\n\n<p><em>Leonardus Nugraha:</em>&nbsp; Yeah, one of them is a mixed breed. It&#8217;s a quite big dog. It&#8217;s about 20 kilograms. And the other one is a big golden retriever. So I have big dogs with me. I think with a combined weight, they&#8217;re bigger than me, to be honest. I love taking photos. Actually, as you may know, I&#8217;m a photography team in WordCamp, and I do have a online portfolio called <a href=\"https://leoandlens.com/\">LeoandLens.com</a>, and I have some of photos of my docs there as well. And also WordCamp Asia photos, obviously. So, and I do have Instagram as well, and I upload or post docs, photos or just random photos there if you want to see it.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And we&#8217;ll share the links in the show notes to catch up with you online or stalk you online.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Sure.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So speaking of music, as part of the 20-year celebration coming up for WordPress, Julia Golomb published a playlist on Spotify of 20 Years of WordPress Jazz. From Miles Davis to Mikhail &#8220;Misha&#8221; Alperin. And it includes one song for each of the 45 jazz artists selected to represent the releases in the last 20 years. So this is really cool. And sometimes I just listen to it when I&#8217;m curating content, reading, copy-pasting and doing that. So yeah, what kind of music do you play?</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; To be honest, it&#8217;s not jazz, so I hope I don&#8217;t disappoint the WordPress community for that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: No.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Mainly I listen to &#8217;80s, &#8217;90s rock and heavy metal, probably some blues and rock and roll. But as a part of WordPress committee and celebrating 20 years of WordPress, probably I should start listening to jazz.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, we have all our preferences. And some of the jazz like Django Reinhardt or something like that, it&#8217;s really great guitars showing off. So yeah, I&#8217;m not always a fan of jazz. It depends on my mood when I listen to jazz. Yeah. So yeah. So you want, let&#8217;s get further into the show.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Community Contributions</strong></h3>\n\n\n\n<p>We have a great show coming to you, dear listeners. And for the &#8220;Community Contributions&#8221; section we have in his post, Block Visibility 3.0. A new chapter begins. Nick Diego announced that he&#8217;s making all Pro features available for free on his plugin, Block Visibility. And there are a couple of exceptions for which he needs just more time to integrate them into the free versions, but he&#8217;s aiming to pack it all in one version, make it available at no cost. And with a plugin, if you don&#8217;t know it, Block Visibility plugin, you can control, show or hide blocks depending on, for instance, a date or a user role or a location or a referral source, and it extends the core block editor with additional settings on the right. So this is a really good plugin, and it has a few fans.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah, it&#8217;s definitely great plugins, especially if you are collaborating with big team on your WordPress site. Of course, we have user rules and user permissions, but with this plugin, you can extend the functionality and the controls with this plugin towards the blocks. And yeah, this is definitely good news to have this plugin for free for the community at no cost. And I read the blog post, and I really appreciate how Nick mentioned the importance of giving back to the community. It is all WordPress is about, right, to give to the community. And I believe with this decision, there will be more and more aspiring WordPress website owners to benefit from next creation. So yeah, everybody&#8217;s win.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, right. Everybody&#8217;s win. Yes, indeed. And since the plugin came out two years ago, I always had the hope that the core developers would consider bringing it to the core functionality of the Block Editor. Maybe that&#8217;s still in the stars, but the future is bright, so we never know what comes. But by the way, Nick Diego as a news item, joined Automattic as a full-time sponsored contributor, and I&#8217;m thrilled that he became a teammate. He has been a special guest on the show before, and I certainly see him joining again in the future. So watch out.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>What’s Released &#8211; WordPress 6.2</strong></h3>\n\n\n\n<p>Now we come to the last two weeks where a lot of releases happened, or actually four weeks since the last episode, and we&#8217;ll start with the big one, that&#8217;s WordPress 6.2. You heard us talking here on the show before. So WordPress 6.2 had over 600 contributors, and it&#8217;s the first major release in 2023.</p>\n\n\n\n<p>The contributors come from at least 50 countries with 900 enhancements, 10 full Gutenberg releases or features from those releases, and then a slew of performance improvements. You might not be surprised to learn that Dolphy reached the impressive milestone of 2 million downloads in under two hours. So after the release and in the first week, it reached over 18 million downloads. So that&#8217;s pretty impressive. And also shows maybe there are some hosting companies that actually automatically update to new versions or at least other, there is a mechanism there that you can automatically update to the new version. And it seems to be working. So are you doing that at Hostinger, that there are automatic updates to the new version for WordPress sites?</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah, we do have a feature for the users to enable auto updates, both for the minor versions and major versions. Usually we enable it for the minor versions, like 6.2.1 because usually there&#8217;s not many new features or bug fixes. Users can enable for the major updates like 6.2, but usually it&#8217;s better to have that tested on staging site as well, which Hostinger also have, to make sure the site&#8217;s working properly, there&#8217;s no compatibility issues with their plugins or with their content. So yeah, we do have that feature, but it&#8217;s safer for the users to test it first for major updates like this, especially with more than 900 enhancements and new features to the workplace.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: No, totally get it. Yeah, when I was working with the agency and our client sites, we would wait at least two weeks, if not four, to see what&#8217;s happening with a new release and if there&#8217;s a patch release coming out. So yeah, test it please, dear listeners. So if you haven&#8217;t yet, the release candidate actually came out March 8th or 7th, so the last four weeks, it could have been that you could already test some of that quite extensively. So.</p>\n\n\n\n<p>Now Rich Tabor and I discussed the site editor updates in WordPress 6.2 in the last episode, and summarize their significant updates to revamp the site editing interface to get new styling features for various blocks that were typography, styling, dimensions, and also color stylings. And then there&#8217;s a Distraction Free Writing mode and a new integration with Openverse, formerly Creative Commons Search, that enables a quick access to listen to that; 700 million free and openly licensed images and audio. So Leo, you published a blog post taking a detailed view on WordPress 6.2, and you are certainly now an expert on all the features. Have you decided what are your most exciting features for you?</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; It&#8217;s hard to pick one most exciting features, because I think this release is probably, in my opinion, brings more and more enhancement compared to 6.1, 6.2, from the perspective of end users. But obviously, for me, it&#8217;s the revamped Site Editor that is really exciting to have. Finally, we have a new, fresh, clean view of the interface. And users can just switch between templates, have a preview before actually start editing. And it&#8217;s also easy to pick a template. You just click on the canvas and start editing. You don&#8217;t have to actually click the button as well. So that&#8217;s a nice little touch there. And also the Global Styles panel with the zoom in, zoom out effect. Now users can just see the whole template and how the style federations affect the site. And the style works. It&#8217;s interesting to have it, to have all the blocks previewed with the tabs. And it also works with Commerce as well.</p>\n\n\n\n<p>If you have WooCommerce installed, you can have the new tabs for the WooCommerce blocks and the Global Style Book as well. And Openverse integration, very exciting to hear, especially when the Openverse became the part of WordPress project. It&#8217;s already exciting, but still, back then, you still have to download the content to your local computer and then re-upload to WordPress, which is a lengthy process, to be honest. And with the new integration, everything&#8217;s now works seamlessly.</p>\n\n\n\n<p>And I really do appreciate how to developers improve it during, was it on that? I think during the beta phase when they decided to upload the image to Media Library automatically instead of just linking to the content. So that&#8217;s nice. Lastly, for me, the biggest one, everything is big, but this one, Distraction Free mode is personally my favorite. Because I don&#8217;t remember how many times I got distracted or obscured by the block toolbar. When you start a new paragraph below the headings or maybe you have some few blocks near on top of each other, sometimes the block tool can obscure the content. And it&#8217;s annoying when you have a paragraph below a heading and you want to move back to edit the heading, you have to get rid of the toolbar first. So you have to click elsewhere, and it&#8217;s complicated.</p>\n\n\n\n<p>But now with the Distraction Free, no toolbar, I can just focus on my content, writing. And yeah, that&#8217;s the main highlight for me personally. There&#8217;s other things like copy-paste styles, which speeds up the customization process. When you pick a block that you like and you decide, &#8220;Ah, I want to use this style,&#8221; you can just copy to another one. Or you can just post it globally to apply it to all blocks on your side.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. The changing of things, you can get very granular and you can escalate some of the styles to the global styles. And I think it&#8217;s quite intuitive to do that. But the Distraction Free mode is definitely one of the, I&#8217;m so glad that came to core. There was a plugin available called Iceberg by Rich Tabor and Jeffrey Caradang for a long time, and they actually created a Distraction Free mode. And I really loved it when I was doing some journaling, where you don&#8217;t need any pictures or something like that, you&#8217;re just channel your inner self or inner mom or inner dad and just write. And that makes it much better writing experience. And I think quite a few bloggers were put off by the block toolbar that gets in the way every time. And there was this, or there is still this feature that you can patch or stick the toolbar to the top, but you still get all the distractions from other things.</p>\n\n\n\n<p>You move the mouse and something happens, and then it goes. And it&#8217;s just sometimes a little noisy. So the Distraction Free mode is definitely beneficial. I also like to surface some great material around the Site Editor for educators. So with WordCamps and conferences on the horizon, meetups are getting re-energized to meet in place, face-to-face meetings and localities, presentations need to be prepared. And Anne McCarthy has a post on her personal blog that&#8217;s called, &#8220;So you want to talk about Site Editor, Part Four.&#8221; And gives you all the resources that would need to speed up your preparations for any presentations. And of course, we&#8217;ll share that in the show notes.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Gutenberg 15.4</strong></h3>\n\n\n\n<p>So that brings us to the next Gutenberg plugin release. Gutenberg 15.4 was released. Justin Tadlock and Ryan Welcher handled it and it contained 186 PRs with 57 contributors. Six of them were first-timers, so congrats all around.</p>\n\n\n\n<p>And it was a smaller release, because it also had a few bug fixes for the 6.2 that were doing the beta and release backported, as the techies say, to the release version of 6.2.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Enhancements</strong></h3>\n\n\n\n<p>So there are a few enhancements I wanted to talk about. So one is go direct to edit from a &#8220;Manage all template&#8221; list. That&#8217;s something you just mentioned, Leo, that you see the template in the preview and the Template Editor or in the Site Editor, you see the template. And then you click on it, and you&#8217;re right there in the edit mode for the template. And that came with 15.4, you mentioned it. Now you also see in the panel on the left-hand side, the PR says, &#8220;The Site Editor&#8217;s dark side.&#8221; Which, it&#8217;s not philosophical, it&#8217;s the black sidebar on the left-hand side. And now there are descriptions for each of the templates. So you know a little bit more when a theme comes in or you enable a new theme, what the templates are supposed to do. And theme editors are able to add templates as well.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah, I think the description, I didn&#8217;t really notice at first when the full Site Editor came to WordPress, but I think having description for its templates like 404 or &#8220;Single post&#8221; or &#8220;Archive,&#8221; it helps many, many first-time users, WordPressers who are still learning. Having this description will be great for them, definitely.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And when you switch theme or have Template Parts or create new ones, you also get a signal from who created them, and from which theme do they come over. That is a signal for the future, where there is thinking about how to make Template Parts and templates less reliant on particular theme. So when you switch the theme and you created a new template as a site owner, you want the template to come over to the new theme as well and not just go away with the old theme. So there&#8217;s some big thinking to be done, because that can get complex so fast.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah. But that will really relevant with the next phase, which is collaboration, to have Template Parts and templates stick to the WordPress instead of the themes. And you can know which user create the template, or whether it&#8217;s made from the themes. So yeah, hopefully it&#8217;s a great path to the future.</p>\n\n\n\n<p>So yeah, we can move on to the next one. It&#8217;s a navigation sidebar. So we have the new logic, which navigation to be shown on the dark side, as you mentioned. I think the first iteration, it shows the first navigation that is created on the team or templates. And now it shows the latest one that is published, which in my opinion, it&#8217;s really logical. It&#8217;s a good step because most likely users will use the latest one and the latest navigation block that they made.</p>\n\n\n\n<p>But yeah, this is definitely still something, in my opinion, can be improved further, especially with the James Koster&#8217;s idea about having a label or hint to identify which menu actually been shown on the dark side. As for now, if you change the menu on the block tools, the navigation block tools, which on the right side, sometimes it doesn&#8217;t really change the one on the dark side. So you can switch to the older menu on the block tools, but then the dark side stick. And yeah, sometimes it can be confusing for new users. So hopefully, we are moving to the right direction here, in my opinion. But definitely, James Koster&#8217;s idea is definitely something worth to think about and to have labeling or hint, especially for new users again, who are still learning.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And I think there was a reason why the navigation part was actually pulled from 6.2. It&#8217;s now coming back with a Gutenberg plugin, but it was pulled from the 6.2 because it was still not performing to the quality that I want. And it wasn&#8217;t really all that intuitive, because the sidebar, when you actually edit a navigation block on the sidebar, it behaves differently than what was on the left side. So that was good. I think it was a good decision, even late in the cycle. That&#8217;s what the next part is, the height navigation screen, that was in 15.4 and was backported to 6.2.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah, I remember testing it on the beta and the RC. The experience is still not perfect yet, I remember, because why is it different between the block tools and the sidebar? And then I heard the news from AN and that it&#8217;s backported again put from 6.2. So yeah, for me, it&#8217;s perfectly make sense. And hopefully they can deliver it, on the next layer is 6.3. They can get everything perfect with a perfect experience for users. And yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Good. Yeah, the Cover Block now also has constrained flow layout, which means that it can be used in different context, and then applied the block inner wrapper by default. And it means that the layered support will work in the Cover Block the same way as it does for the group block, but without the facts variations. So you cannot change how the Cover Block children behave in the full end wide alignment of the Cover Block context. I don&#8217;t know if that makes sense.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah, I think it makes sense for the Cover Block. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, the FontSizePicker, that&#8217;s just a small note here that the FontSizePicker now allows custom units for theme developers that you can offer to your users. It before was only using pixels, and what was the other one?</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; RVM?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Oh yeah, RVM. Yeah, or EMs. And now you can use all of them that are possible. Like VW and all that. Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah. And on the next one we have new block support. So have a text column, or column support on the typographic settings. So I think on this PR, the example, the great example is the paragraph block. So usually if you have a paragraph block, it&#8217;s just like a block of text. But now with this text column support, you can add columns, the number of columns. So you can split the paragraph into separate columns without actually using a column blocks, which is a great option if you want to customize your content, maybe make it like a newspaper style. You don&#8217;t have to use the column block separately. You can just split your paragraph into columns.</p>\n\n\n\n<p><em>Birgit Pauli-Haack:</em> Yeah. And it adjusts if you add more text to it and adjust the columns to it. And it&#8217;s great that there&#8217;s now typography support available, so you can actually change fonts or make them larger, smaller, or change the line height. What might be needed when you are in smaller columns, you can reduce the line height on your texts. So those controls are now available in the user interface. But one caveat on this, the text columns is only available when the theme actually enables it. It&#8217;s not coming out of the box yet, so you need to adjust the theme a little bit to actually be able to use that.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah, I think it used to, you have to add a little bit of code to make it enabled in the theme that JSON file, right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Correct. Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; For now.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, for now. And I need to figure out maybe next release, there will be a way to enable it as a site builder with not access to code to also make use of it. And the Cover Block now got Text Scholar Block support. I was thinking, &#8220;Okay, that didn&#8217;t happen before.&#8221; But obviously it didn&#8217;t, because it&#8217;s now in the plugin. Yes, those design tools are rolled out to the core blocks one at a time to enable them and then test them, to make sure that they&#8217;re work in every context nicely.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; And the next one, adding compound class to layout wrapper or global style spacing. Maybe you can cover this.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: So the problem was that the Cover Block didn&#8217;t work out of the box. The covers mark up the structure and they needed to change the classes to make them also available to the float. And so the Cover Block was a little bit revamped to specify target wrapper for the class, and for the layout of the object. So it was hard to target things that are inside the inner blocks. So that was a revamp that was necessary. So those who style themes can actually access those easily and style them. There was a specificity problem, I think. So for theme developers, they will make sense of it. So the spacing wasn&#8217;t clear for the block children. It was random inside the Cover Block. So they changed that and fixed it. It was a long way around it, explaining it, but sorry. Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah, so developer focus one. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, seem develop the styles. Yeah, CSS. And sometimes I have a hard time with it.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Bug Fixes</strong></h3>\n\n\n\n<p>So now we come to the bug fixes, those were all the enhances of the 15.4 Gutenberg plugin release. We have, I think only two bug fixes that we want to point out, because sometimes you want to know when a bug is fixed. And the first one is that to ensure that the aspect ratio selected is also applied to the post feature image block, and in the Post Template block. So it shows up when you have a summary page, and you have the featured image with the blocks in a grid, that the aspect ratio is actually applied to the post featured block. That&#8217;s really important. Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; I remember I was having problem with featured image ratio quite a long time ago, but I didn&#8217;t realize that it&#8217;s actually a bug. So yeah, I&#8217;m glad that it&#8217;s fixed now with the 15.4. And I think the aspect ratio option is only available when you actually enable the link option for the featured image, right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, yeah, yeah. That was the problem. And then for the navigation block, there is a major bug fix that when the input, the classic menu using in the menu name, that it&#8217;s also going to be the title for the block menu. So there is a seamless integration there. And people are not getting confused. They did not take my menu that I wanted to, or didn&#8217;t do it when you imported a classic menu. So this is fixed now with the Gutenberg 5.4. What else is in there?&nbsp;</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; I think this pull request in the demonstration, it&#8217;s actually hide the Meta Box at the bottom by default. Previously it shows the Meta Box when you&#8217;re in a certain width, but now it just hidden. So the interface is much more cleaner than ever now.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, Distraction Free. Don&#8217;t get distracted.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: The Meta Boxes, yes. Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; It&#8217;s small, but sometimes people can get distracted by that, even though it&#8217;s this small thing at the bottom.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yes. Yeah. But if you have multiple custom fields or something like that, that can be quite long. So it&#8217;s good to hide it. Yes.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Documentation</strong></h3>\n\n\n\n<p>And then there are quite a few documentation changes, and I want to mention them. So your listeners, you can go and look them up. They added examples on how programmatically remove the panels in the document sidebar. So if you don&#8217;t want featured image or don&#8217;t want the tags or the categories, now developers can look up how to actually remove those for their plugins, or for their theme, or the bespoke agency theme development.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; And then the next one is for the sticky position documentation. So I think this relates to the new sticky position features site. So this also been added to documentation.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And that also fills in with a second one that we…</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Oh, yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Which is, so the theme, JSON Schema now has two places where the sticky option is mentioned, and it didn&#8217;t before, but it&#8217;s now in the controls for the appearance tools. When you set them for true, there&#8217;s also a sticky option there. And then you can also in these further down in the Schema, you can add the sticky positions, and minimum height for the styles section as well. So that is now all documented, and you can look up how it works and how it helps you.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Gutenberg 15.5</strong></h3>\n\n\n\n<p>And I think that&#8217;s the Changelog for Gutenberg 15.4, and we are now right into the Changelog for the latest Gutenberg 15.5 release that was released Wednesday, April 4th. And was again, the team Ryan Welcher and Justin Tadlock. April 5th, sorry. And it has 143 PRs with 52 contributors and some updates there. So the first enhancement is that the post date now block has now a variation to use the modified date rather than the published date. And it&#8217;s really important when you have a new site, and you want to get the updated post higher into the latest news, then you want to use the modified date. So it bubbles up again. &#8220;Okay, look here. There were changes in that and it&#8217;s still important.&#8221;</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah. And this is also great for end user as well, in my opinion, because this is basically the same block with this variation, with the modified date enabled by default. But for new users, it&#8217;s just much easier to find having a separate post date and post modified date. So if they want to show both in the single Post Template, they can just find these blocks without having to fiddle with the settings. So yeah, it&#8217;s a much more seamless and easier work process, workflow. And then similar to the post that we have &#8220;Time to Read&#8221; block, which I believe was released on 15.3. It was right?</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yes.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; And now we have a plethora of settings like typographic support to the &#8220;Time to Read&#8221; block, and also spacing tool. So after this was introduced in 15.3, with 15.5, now you can customize the typography and the spacing tools.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Sorry, go ahead.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; No, I&#8217;m finished.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Enhancements</strong></h3>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, no, I used it. So the &#8220;Time to Read&#8221; was actually already available in the outline of the post when you were in the block editor. You could see &#8220;Time to Read.&#8221; Two minutes, 15 minutes, yeah, 25 minutes. Never going to read that. But then immediately as it was available, people were asking, &#8220;Well, can I use that information also on my front end so I can notify or I can show it with my post grid or something like that? How long the Time to Read for that?&#8221; So because readers like that, they found. And it took a while to get it right, to get a new block in and figure out what&#8217;s the best approach. So it now only shows a number and the minutes, and that was the easiest way to make it available through all the languages, because each locale works differently with minutes, three minutes kind of thing in different languages.</p>\n\n\n\n<p>So now you can put them in a row with your wording. So Time to Read, 15 minutes. The &#8220;Time to Read&#8221; is a paragraph, and then you stack it with a row. Group block, in a group block with the &#8220;Time to Read&#8221; block, and then you can have that in your Post Template block. So what did happen was that when I was testing it, I saw immediately that my default font size was different for the paragraph as it was for the Time to Read, but I didn&#8217;t have any controls to change that for the Time to Read. So I filed an issue and said, &#8220;Okay, I need typography control there, please.&#8221; And then I also thought, &#8220;Okay, I need some spacing as well,&#8221; because it was a little lower than the Time to Read. It was really weird. I figured it out for my personal blog, but then also found that it would probably be best to have both controls available to that.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah. And in case everyone wondering, it is actually possible to have Time to Read information previously, but you have to code it to your theme or install a plugin specific for that function. So yeah, it&#8217;s nice to have it in Gutenberg. And hopefully, in the future it&#8217;ll push to the core as well.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; So the next one, oh yeah, the sticky position. I think this feature didn&#8217;t have chance to see the light of day, because when the feature is added, it&#8217;s now reverted back. But essentially, there was a pull request to enable Template Part blocks to be sticky, which is perfectly logical. Because if you have a header, you want to have a sticky header, that means you have to make the Template Part for the header sticky. So there&#8217;s this pull request that adds that feature, but the way it worked was adding the Template Parts into a group block, which is already have the sticky position support, but that doesn&#8217;t really consistent with how the Template Part works. So we are now referred back to how it was, you cannot make it sticky anymore. But yeah, the idea is there. So hopefully, this will be a good starter to see, to look for a better solution for this one. Because yeah, I think many users will want to have Template Part header to be sticky instead of they have to use a group block on route level.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And it&#8217;s quite unintuitive to figure out, &#8220;Okay, if I want to make it sticky, I need to put it in a group block, but it&#8217;s already a Template Part. Can&#8217;t we have that support just for the Template Part?&#8221; But yeah, that adds definitely to the complexity, because the Template Part sometimes doesn&#8217;t have, the sticky doesn&#8217;t know where to stick it, so to speak. When the Template Part is further down the page, then it&#8217;s hard where to stick it to. And yeah, where is it located? Is the Template Part on the sidebar? Then you have a sticky sidebar, but the sticky sidebar behaves totally differently from a sticky header or a sticky footer. So when you read through the PRs, your head might spin because it really shows the discussion between the designers.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; It&#8217;s just the complexity.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: It&#8217;s totally complex. Yeah, just take it from us. It&#8217;s a complex thing.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; I just skip to Rich Tabor feedback about how it doesn&#8217;t really sit with the consistency of the sticky position as well. Because on this PR, you make it sticky, I think to the Ellipsis menu instead of from the block tools. So it will create a different experience.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And the same complexity we will enter when you make the experiment available on, so there is a new feature in 15.5 that&#8217;s first take on the grid layout group variation. So we have flex layouts, we have flow layouts, and now the designers and developers try to get it working with the grid layout. And if you want to try it, you need to enable it through the experiments menu item on the Gutenberg plugin menu item, and check that part to test it out. But please do test it. Because if you want it to get out of experiments and then into the Gutenberg plugin by default and then further into WordPress, it needs to be really working well. And all the use cases, people cannot think up about all the use cases that you would use it. So yeah, please test it and give feedback on the PRs. Or create new issues on the Gutenberg repo so the developers have a better feel from what is still missing and how it&#8217;s not working. Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah. I just test the feature for a few minutes after the launch, because this is also on the launch post. So it&#8217;s quite interesting. And I love it because it was only after this update, I just realized that if you want to create a block, a grid layout with, let&#8217;s say, three columns and three rows, you have to mix it with row blocks or stack blocks, and you just create the whole complex structure. But now with the grid layout, it can just go straight out from the box with the way you want. You can have four columns, you can have six rows, maybe. And yeah, it&#8217;s nice to have this variation. I already tested, even though just few minutes, but I already see possibilities to use this layout for my website, my portfolio website.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Well, it&#8217;s great when those new features actually trigger some creativity on &#8220;Well, how can I use it? Yeah. Can I push it to the limits?&#8221; And that&#8217;s what it&#8217;s all for. Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; And the great thing is it&#8217;s not something that I have in mind. So previously, okay, row blocks, type blocks, columns blocks, that works, but now you have a grid. &#8220;Oh my God, I can have that all in one now.&#8221;</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: And that was quite a few themes developers or theme builders were actually missing that, because grids came in to the CSS part, I think it was in &#8217;16 or 2017, and it&#8217;s been a while that other web developers were able to use it in different settings. But WordPress didn&#8217;t have. There was a plugin or there is a plugin where Automattic created some grid layouts. But now that this is in core, I think we can push it really further into the internet, so to speak. There&#8217;s another item that now you can actually style the caption element, also via the UI controls for color and topography. That&#8217;s the caption for the image…</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Image block.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Image block, yeah, and Video block and Table block and all that. So now we have that, but it seems to have also the UI for you were able to do this via the theme JSON, but now you can do it without using the code for it.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah. You can access it through the global style panels for typography, there will be a new caption options, and the color as well.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; So yeah, the next one, we have the patterns to the template start modal. So when you add new templates now instead of having a fallback default templates, you can have this options to pick a pattern to start with. So yeah, this is also interesting, because in my opinion, this is a perfect middle ground. I remember when the Site Editor came in 5.9, when you add a new template, you start with blank canvas, which is quite daunting, to be honest. And then it was fixed in the feature of this 6.2, 6.0, I can&#8217;t remember that one. But basically, now you can choose it with the black templates and a default fallback template, which is great. But the problem is if you have different ideas with the default templates, you basically have to modify the existing template. You can remove some blocks, and you have to add more blocks. But now with the increasing number of patterns and increasing number of the pattern adoption by the theme developers, it&#8217;s nice to have just simply options to add patterns for the template and choose whatever suits your needs.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, definitely. Yeah, the blank page is not good for anybody, not for writers and not for style, for theme builders. So what&#8217;s next?</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Bug Fixes</strong></h3>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; It&#8217;s quite a lot showing the featured images placeholders. Again, this is something I didn&#8217;t realize at first. Is it Blockfish? Oh, no, it&#8217;s block library. Yeah. It&#8217;s something that I didn&#8217;t realize previously that sometimes the featured image doesn&#8217;t show on the Query Loop block when there&#8217;s no featured set for the certain post. But I think now when you&#8217;re in the Site Editor and some posts may have a featured image and some don&#8217;t, the post with featured image will show the featured image on the Query Loop. And the post that doesn&#8217;t have any featured image will have this gray placeholder so you know that the featured image will be there.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. Or say, &#8220;Oh,&#8221; and if I want that design, it alerts you to not every post can help you with that design because there is no featured image. So it gets a little bit skewed there, where the headline comes up on the top of the image to the next post. Yeah, so it really helps with what you see is what you get kind of approach. Yeah. Yeah, there was quite a daunting bug there. And then the one other bug fix was that the Selecta&#8217;s API, the hook for the global style variation and Duotone has been fixed, and it&#8217;s now behaving consistently throughout the site. There&#8217;s a whole list of PRs that are with that. Not all of them are actually placed in, but this is definitely a very major fix to revamp the code consistency and code quality for it.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>What’s in Active Development or Discussed</strong></h3>\n\n\n\n<p>All right. And this was Gutenberg 5.5. I&#8217;m glad that they were a little smaller as plug-in releases, because first, we got two and then, but we also have a lot to talk about what&#8217;s in active development and what&#8217;s discussed. And I prefixed that next section for the section is, we will include three and a half topics to talk about. First we talk about a little bit about Matias Ventura&#8217;s post on the next phase of the Gutenberg project, Phase 3. And there&#8217;s also work being done on making content and template editing less confusing, and then a proposal on the interactivity API by core contributors. And the half-topic is the design shares by Joen Asmussion from the WordPress design team showed what they are working on. Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Let&#8217;s start with Phase 3. Personally for me, this is the most excitingness of the year, probably, ever since Matt mentioned it on the State of the Word, that this year we are moving to Phase 3 with real-time collaboration. Personally, I believe if the Phase 3 is what I have in mind, and officially just like what Matias posted on his blog post. This is my personal take, but I really think, I believe that it will be a game changer in the content industry. Because right now, we rely on other tools like Google Docs to collaborate and create the draft for the content and then push it on the WordPress, which, it&#8217;s now better with the Block Editor, but still, you have to move the draft, you still have to clean the code, you still have to move the image with the alt tags. So if the Phase 3 finally mature, this can significantly improve the workflow and the pace of the content industry. So yeah, I really hope the Phase 3 gets underway as soon as possible. And let&#8217;s see how the development then. Definitely can&#8217;t wait for that.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, I&#8217;m totally with you. The other, I think the whole web development and web content creators of the last 25 years is actually waiting for this, that two people at the same time or four people at the same time can access a post and edit it. And not the last person who&#8217;s clicks saves wins. So yes, I think that, and bringing that to a web editor is certainly cutting down on the workflow of a lot of people that had to collaborate on Google Docs to get input from other people, to get approval from other people. So that definitely is that real-time collaboration part that Matias Ventura was talking about in his post. What he also sees is that there are asynchronous collaboration. That if Leo in Indonesia is writing a post, and I&#8217;m in America and that&#8217;s 12 hours apart, I want to comment on it, and it&#8217;s really hard right now to do this because there is no revision comments.</p>\n\n\n\n<p>There is no comments at all unless you have a plugin. There were always a few things already, a plugin there. So PublishPress is one, and then Edit Flow that took care of some of that, but you weren&#8217;t able to customize it to your own liking. And then he also talks about the published flows where you have publishing checklists. So is the image rate in the aspect ratio? Do we have an excerpt? Do we have all the categories and tags, and do we have a different image for the header section and for the footer section? Or when different contacts can have different publish flows. So that is definitely going to be a little bit more complicated to make it extensible. And then also the post revisions interface, it&#8217;s really hard right now to see what really changed when you have a long post from one revisions to the next.</p>\n\n\n\n<p>And this Phase 3 is aiming to make it understand blocks, and then also help you with theme switching as well as applying some other styles. And also have revisions that are scheduled. We have on the documentation team, yeah, Leo, you probably know this better than I do, but if you want to prepare for a release, you need to wait till the release is out, so you can publish it, publish the new version of your documents. But not everybody has time to wait for the release and be there in the middle of a night, and hit the publish button or the save button. You definitely want to schedule that. And yeah, we use a plugin for that, but having that in core would be definitely, we are not the only ones who have that trouble. Yeah, yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah, definitely.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; But with the post revision interface, I think that&#8217;s the main, when talking about collaboration, people might think about real time and asynchronous collaboration. But post revisions are as important as the other ones. Because when you collaborate, especially with bigger themes, you really want to see not only what part has been changed, but who made the change to keep the accountability and content to be as good as possible. And to make sure there&#8217;s no mistake in the process. So yeah, and I think, I&#8217;m not sure, did Matias actually talk about this, but with the collaboration is now on WordPress, there must be some thinking to grant more access to collaborators, maybe from links and maybe how to control the user&#8217;s permissions. So I believe that&#8217;s something to tackle as well on the first three.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah, it&#8217;s definitely will, especially the post revision interface. And although it will need different user roles for different things to do, and I know that bigger publishing houses, they have that really huge requirement that they need to have people access the images but not the text kind of thing or vice versa. And yeah, there&#8217;s definitely a part of the development will be about user roles and user capabilities that come with the publishing flow, for sure. There&#8217;s also the admin design. There was a separate post by Matias back in January, I think, that was thinking about through the WordPress admin experience. And that will now be part of the collaboration phase, where certain pieces of the admin definitely would need a revamp, like how we organize posts. What&#8217;s in the post you need for the collaboration you need, yeah, when was it revisioned?</p>\n\n\n\n<p>Does that need to be in the list view of things? And all that kind of thing. And then also have a library. Expansion, that means spaces where you can manage your patterns, where you can manage your blocks, your styles and your fonts on the site, or at least for the site admin to be able to do that. Right now, there&#8217;s the two, all four of them that I&#8217;ve just mentioned. And the Matias mentioned in his post where are actually missing, and it&#8217;s felt quite a bit throughout the five years that the Block Editor is there, especially the blocks where you can switch on and switch off blocks in the interface. But then if you have third-party blocks, you don&#8217;t know which of the blocks have you used or which post uses which block. So you can switch it over to a different one when you say, &#8220;Okay, I want to remove the plugin.&#8221; But all of a sudden, some of your content disappears as well.</p>\n\n\n\n<p>So there definitely needs to be a little bit more manageable space there. And then the last item is develop a global search and command component where you can say, &#8220;Okay, edit post in a search box,&#8221; and then it opens up the &#8220;Edit post&#8221; admin screen. So you don&#8217;t have to click through all the different levels of things. That&#8217;s the idea behind it. So I&#8217;m not sure if we do it really justice, going through those different sections of the collaboration post by Matias. Give it a read. It&#8217;s definitely is a little bit more expanded at what we are doing here. And see, and especially what Matias Ventura is asking and the whole core contributors are asking. So if there&#8217;s something that you are doing on your website and you want it in one part of the collaboration, because it fits in that scope, but it wasn&#8217;t yet mentioned, comment on the post, describe your flow, and see if that&#8217;s something that could be in core.</p>\n\n\n\n<p>Nothing is, of course, prominent at this stage because I haven&#8217;t started working on it yet. So in the WP Briefing podcast, Episode 52, Josepha Haden Chomphosy and Hector Prieto also talking about the Phase 3, the workflows, the visioning about it. So it&#8217;s another version of it, and you probably can hear more about it. All right. So I mentioned it before, is also work being done, and we&#8217;ll share the links to the PR and discussions in the show notes.</p>\n\n\n\n<p>Users repeatedly mentioned that they sometimes get confused of what they are actually editing in the Site Editor. And then they see a page and make updates to the content, and then they&#8217;re surprised that page template, actually, that they&#8217;re actually changed the page template. And that the content that they changed or that they added is replicated on all the pages because it was a template. So that&#8217;s quite a surprising thing, and it&#8217;s nowhere really alerted that that might happen. So the developers and designers are really working hard to make it a seamless switch from editing your content to editing a template. And there are two, there&#8217;s one PR that actually caters to that, but then there is a bigger effort to optimize also the content-centric editing experience in the site editor. So I&#8217;ll share those in the side notes. Show notes, side notes, show notes. Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; It&#8217;s definitely a nice addition to the Site Editor. I remember when the browse mode first mentioned in past updates, I believe, this is actually what I had in mind. Users can browse their websites, can open pages and blog post to the Site Editors. And when they want to edit the content, they can just switch from editing the templates and just editing the page or post they&#8217;re browsing in. And I think with the new navigation UI in the site bar or the dark side of the Site Editor, it&#8217;s like that already. We can see the menu items in there and just click on it, and you can see the page. And if you click it, you can edit the page on the Site Editor. So yeah, it&#8217;s already in the good direction now. So it&#8217;s only the matter of expanding it to be more integrated between the Site Editors and put editor, and the post and page editor.</p>\n\n\n\n<p>To be honest, when the first Site Editor came out in 5.9, this is also my first issue, figuring out what is the new Site Editor? And I just click it. &#8220;Okay, this is the template, so how do I edit the post or page? Oh, I still have to go to the old post and page editor.&#8221; Because in my mind, it was a page builder or website builder, but it&#8217;s not right. So it took me a while to understand what it is. And now we are working to integrate the Site Editor and the content editor better. So in the future, we might have a better experience with Block Editor and seamless content editing.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And for a newer WordPress user, the difference between the page and the template for the page, that&#8217;s a certain cognitive hurdle there. An abstraction level that not everybody who wants to get their work done wants to deal with. So it&#8217;s definitely something that needs to be handled, but it&#8217;s also sometimes really hard to make that intuitive. And if the context is not known with a switch, so it&#8217;s going to be a training. Sometimes we always think that web editing should be something like using a car, without forgetting that we went to traffic school before we actually learned driving. And we don&#8217;t want have traffic school for the web there. So we need to make a compromise there.</p>\n\n\n\n<p>I also wanted to point the more the developers amongst our listeners to the proposal for an interactivity API that a team of contributors has worked almost a year around it to figure out how can this be standardized. There is, of course, available any of the block builders or block developers or third-party blocks or core blocks. There is some interactivity already available, but it&#8217;s not standardized. And standardization also means that developers don&#8217;t have to relearn everything. Users don&#8217;t have to relearn everything every time they have a new plugin. And also, you can share data. So if one plugin knows about the block of another plugin, then new things and better things can happen. So Mario Santos published a proposal for the Interactivity API.</p>\n\n\n\n<p>And for those of us who need a practical application to think through the abstractions there, it&#8217;s all very theoretically, Mario also put in a video demo of a movie database, where in you can browse the site publicly and developers can look at the code of things. But the video shows two use cases for add an interactivity to that movie directory. And navigating the directory is already by search, and that is one of the interactivity API, because it doesn&#8217;t go back to the server and reloads things. That&#8217;s pretty much what it abstracts is that only parts of the data will be replaced on the site, but it will not go back to reload the whole page that you&#8217;re looking at. And then the other one is click on hearts to favorite some of the movies. And it also has a favorite counter on that. So these kind of interactivity, that&#8217;s a simple example that we can all rely on or relate to.</p>\n\n\n\n<p>And then there is the whole proposal itself. As a developer, you learn about directives, you see some code examples, and the FAQ also answers some of the more in-depth questions you might have. The post has already 40 comments. So grab a cup of coffee, put on some nice, slow music and read through it. It&#8217;s almost a book, but it&#8217;s very, very interesting in terms of what can actually happen when we standardize things. And then there is next week, no. Okay, so I don&#8217;t want to count it because I don&#8217;t know when you are listening to it. So two developers from the team who came up with a proposal will be speakers of the Developer Hours on April 17. I don&#8217;t know if you know about Developer Hours, but they had been revitalized from an experiment last year where you can connect with developers on the core team and have questions answered.</p>\n\n\n\n<p>And this time has a little bit of a different format, when there is an introduction to the interactivity API. And they will hold two events to accommodate as many time zones as possible. One is at 8:00 AM UTC. And the other one, that&#8217;s with Mario Santos. And the other one is at 17:00 UTC. That&#8217;s going to be with Michal Czamplinski. And yeah, so that is actually the next generation of block development getting more interactivity into, it&#8217;s called a hydration process, where things come from the server. Yeah, it&#8217;s a connecting PHP with JavaScript and just update the necessary data on the front end upon user interactions. That&#8217;s pretty much the explanation for it. Yeah, so I don&#8217;t know if you have any comments on that, Leo?</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Nope.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Because I&#8217;m more of an end user in this regard.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. And what you see in the demo is actually quite impressive, because you see the seamless, that there is no time lost between changing different screens. So that&#8217;s really cool.&nbsp;</p>\n\n\n\n<p>So there are two articles in the show notes, one from the Tavern and one the proposal. And then if you as a developer or want to be a developer kind of person, share or join those two developer hours with Michal and Mario. And the last thing, the half about topic for, what&#8217;s in the works is Joen Asmussen&#8217;s Design Share from March 27th on the &#8220;Make WordPress Design,&#8221; make blog. And he shares what&#8217;s happening, with one is that the mercantile store, the swag store gets some social images that are designed. Then the design team also thinks through making the padding and margin controls a little bit more intuitive and see how to provide easily clickable preset sizes and unlink variations, and take a look at it.</p>\n\n\n\n<p>And he connects with the PRs on issues that are on the GitHub repo. They also have a visual idea on how to scale the Block Options menu. That gets really long now to cluster some of them, and then you can access and an arrow with a secondary menu item there. That&#8217;s quite nice. And then he had, the last one is the ideation of the Template Management view where he has a small video to mock up the view toggle patterns to moving between the browsing and the managing context. So that&#8217;s pretty much the topic that we talked before about content-centric Site Editor kind of thing. So they&#8217;re, of course, design, it&#8217;s all visuals. And we are here on a podcast, so it&#8217;s really hard. But we have the link in the show notes for you, so you can browse them at your own leisure. Yeah. All right.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; The block option in particular caught my eye because as you say, the block options get longer and longer over time. So it is quite short. But then we have block locking tools, we have &#8220;Create Template Part&#8221; options. We now have a copy style and paste styles. I mean, if we have a minimized Windows Manager, try to open the options, so you might have to scroll it down just to find the bottom ones. So yeah, it&#8217;s nice to have the new designs to just split it and with the sub-menus. Yeah.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Yeah. You still need the space on the right-hand side when they pop out. So if there are too many options, it&#8217;s not enough room. But yeah, gradual adoption is pretty much the keyword word for that. Yeah. All right. This is the end of the Gutenberg Changelog Episode 81. Thank you so much for listening, people. Leo, thank you so much for being here and talking this through. You did an excellent job. It was wonderful to have the chat with you, and I really enjoyed it, being on the show with you. So you mentioned…</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah. Go ahead. Go ahead.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: You mentioned a few links to your social web. If you can repeat the website where you have your portfolio for the photography, that would be great.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah, the website is <a href=\"https://leoandlens.com/\">Leo and Lens</a>. I will type it down for you later, and maybe you can put it on the show notes.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: There&#8217;s no maybe about it.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Thank you. Yeah. And yeah, lastly, thank you all, listeners, for listening to this episode. Thank you, Birgit, for having me. It&#8217;s such an honor to be in the Gutenberg Changelog podcast with you.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: It was definitely, the pleasure was all mine. And well, I might ask you to maybe come back in the future. Yeah.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Yeah, yeah, just contact me. I&#8217;ll definitely be happy to be in here again and talk about Gutenberg, about WordPress and how it evolves. Yeah, it is a great pleasure for me.</p>\n\n\n\n<p><em>Birgit Pauli-Haack</em>: Thank you. Yeah, and as always, hey listeners, the show notes will be published on GutenbergTimes.com/podcast. This is Episode 81. And if you have questions or suggestions or news you want us to include, send them to <a href=\"mailto:Changelog@Gutenbergtimes.com\">Changelog@Gutenbergtimes.com</a>. That&#8217;s email <a href=\"mailto:Changelog@Gutenbergtimes.com\">Changelog@Gutenbergtimes.com</a>. And thanks again, and I wish you all a good weekend, a good day, a good year, and a good month, so bye. That&#8217;s it for me. Goodbye.</p>\n\n\n\n<p><em>Leonardus Nugraha</em>:&nbsp; Goodbye.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 09 Apr 2023 13:22:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Gutenberg Times: Anniversary, Open Verse, Performance measuring, Interactivity API – Weekend Edition #249\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://gutenbergtimes.com/?p=23782\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://gutenbergtimes.com/anniversary-open-verse-performance-measuring-interactivity-api-weekend-edition-249/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:21724:\"<p>Howdy, </p>\n\n\n\n<p>Greetings from Munich, Germany! It&#8217;s good to be back in my hometown. Let the honeymoon phase of rekindling begin! </p>\n\n\n\n<p>In the WordPress world,  the last two weeks were quite busy. The major release of WordPress 6.2, a preview of Gutenberg&#8217;s Phase Three, a new Gutenberg plugin version, and so much more. </p>\n\n\n\n<p>Enjoy. Wishing you and yours a great weekend and Happy Easter to those who celebrate it. </p>\n\n\n\n<p>Yours, 💕<br /><em>Birgit</em></p>\n\n\n\n<p>PS: Did you know that as part of the 20-year celebrations coming up next month, <strong>Julia Golomb</strong>, published a play list on Spotify of <a href=\"https://wp20.wordpress.net/20-years-of-wordpress-jazz/\"><strong>20 Years of WordPress Jazz</strong></a>? From Miles Davis to Mikhail “Misha” Alperin, this playlist includes one song for each of the 45 jazz artists selected to <a href=\"https://wordpress.org/about/history/\">represent the releases</a>. Have a look at the site <a href=\"https://wp20.wordpress.net\">wp20.WordPress.net</a> of what is in store for the 20-year anniversary coming up next month. </p>\n\n\n\n<a href=\"https://wp20.wordpress.net/\"><img /></a>\n\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p><strong>Table of Contents</strong></p>\n\n\n\n<div class=\"wp-block-sortabrilliant-guidepost\"><ul><li><a href=\"https://gutenbergtimes.com/feed/#0-word-press-release-information\">Developing Gutenberg and WordPress</a></li><li><a href=\"https://gutenbergtimes.com/feed/#0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</a></li><li><a href=\"https://gutenbergtimes.com/feed/#2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</a></li><li><a href=\"https://gutenbergtimes.com/feed/#3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </a></li></ul></div>\n</div></div>\n\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-word-press-release-information\">Developing Gutenberg and WordPress</h2>\n\n\n\n<p>It is finally here!  <a href=\"https://wordpress.org/news/2023/03/dolphy/\"><strong>WordPress 6.2 &#8220;Dolphy&#8221; </strong></a>was released on March 29, 2023. Over 600 contributors made the first major release in 2023 possible. They come from at least 50 countries. With 900+ enhancements, ten full Gutenberg release features, and a slew of performance improvements, you might not be surprised to learn that “Dolphy” reached the impressive milestone of 2 million downloads in under 2 hours after release. After the first week, it reached over 18 million downloads.&nbsp;</p>\n\n\n\n<ul>\n<li>The release post has the details: <a href=\"https://wordpress.org/news/2023/03/dolphy/\"><strong>WordPress 6.2 &#8220;Dolphy&#8221;</strong></a></li>\n\n\n\n<li>The field guide for developers is available since RC 1: <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\"><strong>WordPress 6.2 Field Guide</strong></a></li>\n\n\n\n<li>Watch the recorded Product Demo video from the preview event. <a href=\"https://make.wordpress.org/core/2023/03/10/6-2-live-product-demo-qa/\"><strong>6.2 Live Product Demo Q&amp;A</strong></a></li>\n</ul>\n\n\n\n<a href=\"https://wordpress.org/news/2023/03/dolphy/\"><img /></a>\n\n\n\n<p>Here is a highly subjective list of detailed articles on various sites about the release and the features in WordPress 6.2:</p>\n\n\n\n<ul>\n<li><strong>Carlo Daniele</strong> for Kinsta: <a href=\"https://kinsta.com/blog/wordpress-6-2/\">What’s New In WordPress 6.2: Browse Mode, Style Book, Improved Navigation Menus, New APIs, and Much More</a>.</li>\n\n\n\n<li><strong>Leonardus Nugraha</strong> for Hostinger: <a href=\"https://www.hostinger.com/blog/wordpress-6-2\">WordPress 6.2 Is Finally Here: A Detailed Overview</a></li>\n\n\n\n<li><strong>Dan Knauss</strong>, for iThemes&nbsp;<a href=\"https://ithemes.com/blog/what-to-expect-in-wordpress-6-2\"><strong>What to Expect in WordPress 6.2</strong></a> (<em>BTW iThemes just announced a <a href=\"https://solidwp.com/\">total rebranding to SolidWP</a></em>)</li>\n\n\n\n<li>And last but not least: <strong>Sarah Gooding </strong>for WPTavern: <a href=\"https://wptavern.com/wordpress-6-2-dolphy-introduces-a-revamped-site-editor-distraction-free-writing-mode-and-updated-block-inserter\">WordPress 6.2 “Dolphy” Introduces a Revamped Site Editor, Distraction-Free Writing Mode, and Updated Block Inserter&nbsp;</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-group has-light-background-background-color has-background is-layout-flow wp-block-group-is-layout-flow\"><div class=\"wp-block-group__inner-container\">\n<p><strong>🎙️ </strong> New episode:  <a href=\"https://gutenbergtimes.com/podcast/gutenberg-changelog-81-wordpress-6-2-interactivity-api/\">Gutenberg Changelog #81 – WordPress 6.2, Gutenberg 15.4 and 15.5, Phase 3 – Collaboration and a new  Interactivity API</a> with Birgit Pauli-Haack and special guest Leonardus Nugraha</p>\n</div></div>\n\n\n\n<p><strong><a href=\"https://twitter.com/Leonugr\">Leonardus Nugraha</a> </strong>joined me on Friday for Gutenberg Changelog episode 81, and we also talked about WordPress 6.2. We also covered Gutenberg plugin releases 15.4 and 15.5, Phase 3 and the Interactivity API proposal. If you are a subscriber, the episode will drop into your favorite Podcast app over the weekend. </p>\n\n\n\n<img />\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In the <a href=\"https://gutenbergtimes.com/phase-3-collaboration-layout-and-spacing-controls-block-visibility-3-0-weekend-edition-248/\"><em>Weekend edition #248</em></a>, we shared Matias Ventura&#8217;s announcement on the <a href=\"https://make.wordpress.org/core/2023/03/24/phase-3-collaboration/\">Phase 3: Collaboration</a>  </p>\n\n\n\n<p><strong>Josepha Haden Chomphosy</strong> and <strong>Hector Prieto</strong> discussed a few questions the community had about Phase 3 in the latest episode of the WP Briefing: <a href=\"https://wordpress.org/news/2023/03/episode-52-phase-three-with-hector-prieto/\"><strong>Episode 52: Workflows and Phase Three Visioning with Special Guest Héctor Prieto</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>In his <a href=\"https://make.wordpress.org/design/2023/03/27/design-share-mar-13-mar-24/\"><strong>Design Share: Mar 13–Mar 24</strong></a>, <strong>Joen Asmussen</strong> showcased the latest work by the WordPress Design team. One display is particular interesting as it imagines how the block options menu can scale and house even more options. In another section, Asmussen shows how the team is thinking about the template management. </p>\n\n\n\n<img />\n\n\n\n<p>This week, <strong>Ryan Welcher</strong> and <strong>Justin Tadlock</strong> wrangled the Gutenberg plugins release and published the release post: <strong><a href=\"https://make.wordpress.org/core/2023/04/05/whats-new-in-gutenberg-15-5-05-april/\">What’s new in Gutenberg 15.5? (05 April)</a>. </strong>In it, they highlight </p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/04/05/whats-new-in-gutenberg-15-5-05-april/#patterns-as-template-starters\">Patterns as template starters</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/04/05/whats-new-in-gutenberg-15-5-05-april/#style-captions-via-the-styles-interface\">Style captions via the Styles interface</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/04/05/whats-new-in-gutenberg-15-5-05-april/#experimental-grid-layout-support\">Experimental grid layout support</a></li>\n</ul>\n\n\n\n<p>I am particularly, curious about how the grid layout works. It seems quite complex as the editor needs to deal with several levels and Inner Blocks and how they follow the overall grid layout. It&#8217;s important that theme builders test this and provide feedback, so it can be solidified. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"0-p\">Plugins, Themes, and Tools for #nocode site builders and owners</h2>\n\n\n\n<p><strong>Anne McCarthy</strong>, manager of the FSE-Outreach Project hosted a Hallway Hangout with <a href=\"https://twitter.com/bbertucc\"><strong>Blake Bertuccelli-Booth</strong></a> on <a href=\"https://make.wordpress.org/test/2023/04/04/hallway-hangout-lets-chat-about-moving-to-the-site-editor/\">Moving to the Site Editor</a>. Bertucelli-Booth &#8220;sees a huge advantage in using the Site Editor directly as a design tool rather than using Figma before replicating in WordPress.&#8221; and &#8220;Generally speaking, they try not to build that many custom blocks and instead rely on patterns with an emphasis on employing as much as possible from&nbsp;<a href=\"https://developer.wordpress.org/block-editor/how-to-guides/curating-the-editor-experience/\">the curating the editor experience doc</a>.&#8221; McCarthy wrote. It&#8217;s a great conversation to have and one I will revisit, when starting to migrate the Gutenberg Times to a block theme. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Munir Kamal</strong> launched <a href=\"https://gutenberghub.com/launching-gutenberghub-shop/\">GutenbergHub Shop</a> where he offers an extensive range of Gutenberg Blocks, Templates, and Extensions, designed to facilitate and enhance the website building process. Kamal has big plans for the future. I am excited to see <a href=\"https://shop.gutenberghub.com/\">what&#8217;s in store </a>next</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Anders Noren</strong>, an early adopter of block themes, published a new theme in the WordPress repository called <strong><a href=\"https://wordpress.org/themes/abisko/\">Abisko</a>.</strong> &#8220;Abisko is a stylish blog theme with a heavy emphasis on bold typography and generous amounts of whitespace. It comes with 5 different theme styles to choose from, and over 30 different block patterns that you can use to build unique page layouts quickly.&#8221;<br /><br />Sarah Gooding has the skinny for you: <a href=\"https://wptavern.com/anders-noren-releases-abisko-a-new-free-wordpress-theme-with-30-block-patterns\"><strong>Anders Norén Releases Abisko, a New Free WordPress Theme with 30+ Block Patterns</strong></a></p>\n\n\n\n<img /><em>Features pattern. Theme Abiski by Andres Noren. </em>\n\n\n\n<p>WordPress 6.2 comes with an Openverse integration for media and block inserter. <strong>Wes Theron </strong>has a tutorial for you on how to <a href=\"https://learn.wordpress.org/tutorial/add-media-and-openverse-images-to-your-content-directly-from-the-inserter/\"><strong>Add media and Openverse images to your content directly from the Inserter</strong></a></p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"2-word-press-6-0-1-and-6-1-scheduled\">Theme Development for Full Site Editing and Blocks</h2>\n\n\n\n<p><a href=\"https://twitter.com/jkoussertari\"><strong>James Koussertari</strong></a> at GutenbergMarket, published <a href=\"https://gutenbergmarket.com/news/a-comprehensive-guide-to-building-wordpress-block-themes\"><strong>A Comprehensive Guide to Building WordPress Block Themes</strong></a> with links to official and other sources. Apart from the official sources, Carolina Nymark&#8217;s fullsiteediting.com has the most details resources.  </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p>Previously, <strong>Felix Arntz</strong> shared his experience of&nbsp;<a href=\"https://felix-arntz.me/blog/rebuilding-my-website-using-a-block-theme/\">rebuilding my WordPress website using a block theme</a>. In his latest blog post he shared how he was <a href=\"https://felix-arntz.me/blog/measuring-website-performance-using-webpagetest-with-wordpress-6-2/\"><strong>measuring website performance using WebPageTest</strong></a>, using the latest WordPress version. Arntz shares his plan, how to select relevant test scenarios and what exactly he wanted to measure. It&#8217;s a great case study, that will help you to also benchmark some of the sites you are dealing with. Felix is super detailed in his post, and you might get lost in the weeds. Make sure you check out the tools he mentions to help with the endeavor. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><b>The WPEngine</b> team has released the Pattern Manager plugin in the WordPress plugins directory . The description reads: &#8220;When you design beautiful block patterns for your theme, Pattern Manager by WP Engine will automatically push them into PHP files for you, every time you save.&#8221; </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p><strong>&nbsp;<a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/\" target=\"_blank\" rel=\"noreferrer noopener\">&#8220;Keeping up with Gutenberg &#8211; Index 2022&#8221;</a>&nbsp;</strong><br />A chronological list of the WordPress Make Blog posts from various teams involved in Gutenberg development: Design, Theme Review Team, Core Editor, Core JS, Core CSS, Test, and Meta team from Jan. 2021 on. Updated by yours truly.  <a href=\"https://make.wordpress.org/core/handbook/references/keeping-up-with-gutenberg-index/keeping-up-with-gutenberg-index-2020/\"><em>The index 2020 is here</em></a></p>\n\n\n\n\n<p><strong><a href=\"https://twitter.com/benjaminritner\">Ben Ritner</a></strong> elaborated on the <a href=\"https://www.kadencewp.com/blog/wordpress-6-2-and-the-state-of-fse/\"><strong>state of FSE themes,</strong></a> “…there is a lot about the site editor and FSE themes that are not quite ready…”. Ritner and his team at Kadence theme were early adopters of the Block editor and built a very popular Block Collection plugin. Together with the Kadence Theme, the plugin elevated the user experience to page building capabilities with features the block editor was missing for a long time. There are still things Ritner finds missing. Read  the article and see if his gaps are also relevant to your theme building journey. </p>\n\n\n\n<p></p>\n\n\n\n<p><a href=\"https://twitter.com/nschaeferhoff\">Nick Schäferhoff</a> found <a href=\"https://torquemag.io/2023/03/wordpress-site-editor-features/\"><strong>10 WordPress Site Editor (FSE) Features You Didn’t Know About</strong></a>, even if you know about some of them, you might not know all of them. </p>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"3-building-themes-for-fse-and-word-press\">Building Blocks and Tools for the Block editor. </h2>\n\n\n\n<p>In his post,<strong> <a href=\"https://developer.wordpress.org/news/2023/03/quick-and-easy-local-wordpress-development-with-wp-env/\">Quick and easy local WordPress development with wp-env</a>, Michael Burridge</strong> introduced you to the WordPress development tool that comes with the Gutenberg plugin and allows you to quickly spin up a WordPress site on your computer to start working on proof of concepts, or follow an interesting idea. <em>(Docker required </em></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Jonathan Bossenger</strong>&#8216;s new course is online on Learn.WordPress site.  <a href=\"https://learn.wordpress.org/course/converting-a-shortcode-to-a-block/\"><strong>Converting a Shortcode to a Block</strong></a>. This is a newer style of course, where we&#8217;re using existing tutorial content, updating it with images, code examples and quizzes, and bundling it as a short course.  A short version of the course is available as a tutorial on the WordPress Developer Blog: <a href=\"https://developer.wordpress.org/news/2023/03/converting-your-shortcodes-to-blocks/\"><strong>Converting your shortcodes to blocks</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Michael Burridge</strong> and <strong>Jonathan Bossenger</strong> held live Developer Hours for the Asia/Pacific timezones and uploaded the recording to WordPressTV: <a href=\"https://wordpress.tv/2023/04/03/developer-hours-migrate-a-plugin-to-blocks-emea-asia-pacific/\"><strong>Developer Hours: Migrate a plugin to blocks (EMEA / Asia-Pacific)</strong></a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong>Ryan Welcher</strong>  invited developers to bring block development issues to the live stream on Twitch. Some recordings are available on YouTube:  <a href=\"https://www.youtube.com/watch?v=Aut0EcsKbxM&t=3s\"><strong>Block Development: Bring me your issues!</strong></a> In this edition, Welcher covers about 14 different issues submitted by viewers. </p>\n\n\n\n<p>Among those: </p>\n\n\n\n<ul>\n<li>Adding some checks to only show the link to users with the correct level of access.</li>\n\n\n\n<li>Creating a post-placeholder block and creating the parent/child relationship with the post-picker block.</li>\n\n\n\n<li>Updating the Edit component to match the output of the front end.</li>\n</ul>\n\n\n\n<p><a href=\"https://www.twitch.tv/ryanwelchercodes\">Ryan Welcher streams very Thursday at 10:30 ET / 15:30 UTC on Twitch </a></p>\n\n\n\n<p></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n<p><strong><a href=\"https://twitter.com/santosguillamot\">Mario Santos</a></strong> posted on the Make Core blog the <a href=\"https://make.wordpress.org/core/2023/03/30/proposal-the-interactivity-api-a-better-developer-experience-in-building-interactive-blocks/\"><strong>Proposal: The Interactivity API – A better developer experience in building interactive blocks</strong></a>.  The vision:  &#8220;Imagine plugins providing interactions like “heart this post” or “add to cart” without page reloads. Picture instant search, commenting, and native full-page transitions as best-in-class built-ins without complex scaffolding or external tools. Envision achieving this in any block theme by default without sacrificing&nbsp;PHP&nbsp;server rendering and the&nbsp;plugin&nbsp;ecosystem for a&nbsp;JS&nbsp;runtime. Visualize block developers easily declaring and extending such behaviors in a way that is immediately familiar and compatible with the block ecosystem.&#8221; </p>\n\n\n\n<p>Santos also shared a short demo of  Favorites in a Movies app. You can <a href=\"https://wpmovies.dev/\">browse it yourself on the live site</a>, and if you are interested in the implementation, the <a href=\"https://github.com/wordpress/wp-movies-demo\">demo code is also available on GitHub</a>. This post definitely has a high Geek-factor, but the aim is to make it easier for any developer to create interactive blocks. Stay tuned for more examples and examples code.</p>\n\n\n\n<p>Two developers from the team working on the Interactivity API will be speakers at the <strong>Developer Hours on April 17,</strong> and give an<a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/292575913/\"> </a><strong><a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/292575913/\">Introduction of the </a>Interactivity API</strong>. They will hold two events  to accommodate as many times zones as possible: <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/292575913/\">at 8am UTC</a> with Mario Santos and <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/292575942/\"><strong>at 17:00 UTC</strong></a> with Michal Czamplinski</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p><strong><a href=\"https://gutenbergtimes.com/need-a-zip-from-master/\">Need a plugin .zip from Gutenberg&#8217;s master branch?</a></strong><br />Gutenberg Times provides daily build for testing and review. <br />Have you been using it? Hit reply and let me know.</p>\n\n\n\n<p><img alt=\"GitHub all releases\" src=\"https://img.shields.io/github/downloads/bph/gutenberg/total?style=for-the-badge\" /></p>\n\n\n\n\n<p class=\"has-text-align-right has-small-font-size\"><em>Questions? Suggestions? Ideas? Don&#8217;t hesitate to send <a href=\"mailto:pauli@gutenbergtimes.com\">them via email</a> or send me a message on WordPress Slack or Twitter @bph</em>. </p>\n\n\n\n<p class=\"has-text-align-right has-small-font-size\">For questions to be answered on the <a href=\"http://gutenbergtimes.com/podcast\">Gutenberg Changelog</a>, send them to <a href=\"mailto:changelog@gutenbergtimes.com\">changelog@gutenbergtimes.com</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-wide\" />\n\n\n\n\n<p>Featured Image: Munich, view from the tower of St. Paul by Birgit Pauli-Haack, found on wordpress.org/photos. </p>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\n\n\n\n<p class=\"has-text-align-left\"><strong>Don&#8217;t want to miss the next Weekend Edition? </strong></p>\n\n\n\n<form class=\"wp-block-newsletterglue-form ngl-form ngl-portrait\" action=\"https://gutenbergtimes.com/feed/\" method=\"post\"><div class=\"ngl-form-container\"><div class=\"ngl-form-field\"><label class=\"ngl-form-label\" for=\"ngl_email\"><br />Type in your Email address to subscribe.</label><div class=\"ngl-form-input\"><input type=\"email\" class=\"ngl-form-input-text\" name=\"ngl_email\" id=\"ngl_email\" /></div></div><button type=\"submit\" class=\"ngl-form-button\">Subscribe</button><p class=\"ngl-form-text\">We hate spam, too and won&#8217;t give your email address to anyone except Mailchimp to send out our Weekend Edition</p></div><div class=\"ngl-message-overlay\"><div class=\"ngl-message-svg-wrap\"></div><div class=\"ngl-message-overlay-text\">Thanks for subscribing.</div></div><input type=\"hidden\" name=\"ngl_list_id\" id=\"ngl_list_id\" value=\"26f81bd8ae\" /><input type=\"hidden\" name=\"ngl_double_optin\" id=\"ngl_double_optin\" value=\"yes\" /></form>\n\n\n\n<hr class=\"wp-block-separator has-css-opacity is-style-wide\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 08 Apr 2023 07:09:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Birgit Pauli-Haack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: Gutenberg 15.5 Introduces Experimental Grid Layout Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143396\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/gutenberg-15-5-introduces-experimental-grid-layout-support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3586:\"<p><a href=\"https://make.wordpress.org/core/2023/04/05/whats-new-in-gutenberg-15-5-05-april/\">Gutenberg 15.5</a> was released this week with more new features and refinements to WordPress&#8217; full-site editing capabilities. The project will soon be moving on to Phase 3 with <a href=\"https://wptavern.com/real-time-collaboration-is-coming-to-wordpress\">real-time collaboration</a> on the roadmap, but there are still many improvements on the way for the Site Editor and core blocks.</p>\n\n\n\n<p>This release introduces experimental support for grid layouts in the Group block. Gutenberg contributors are testing a Grid layout type as a new variation for the Group block. They decided on this implementation instead of a new block in order to get more real-world use on the first iteration. </p>\n\n\n\n<img />\n\n\n\n<p>After testing, I found the Grid layout type fits as a natural addition to other Group variations. This first iteration ships with one setting for configuring the minimum column width, but more options can be added in the future. I found it to be far easier to manipulate than the Columns block for basic grids. It may be easier for users to discover and understand if it were implemented as a new block, with the grouping implicit instead of having to add a Group block first and then select a layout.</p>\n\n\n\n\n\n\n\n<p>Grid layouts are a common feature of page builder plugins and this new capability is necessary to make Gutenberg&#8217;s page building capabilities more robust. With more testing, contributors can settle on an implementation and build it out from there. If you want to give it a try, the Grid variation for the Group block can be enabled under <strong>Gutenberg > Experiments</strong>.</p>\n\n\n\n<img />\n\n\n\n<p>Gutenberg 5.5 also introduces the ability for theme authors to identify a custom pattern to be displayed when users load a specific template, such as a 404 page, author page, or single post, instead of relying on a fallback template or starting from a blank slate. This makes it possible to have <a href=\"https://make.wordpress.org/core/2023/04/05/whats-new-in-gutenberg-15-5-05-april/\">custom patterns as template starters</a>, a friendlier jumping off point for users who are editing their sites.</p>\n\n\n\n<p>The update brings the ability for users to <a href=\"https://github.com/WordPress/gutenberg/pull/49141\">style their Captions in the Styles interface</a>. Captions&#8217; color, typography, and size can now be easily edited with changes applied globally.</p>\n\n\n\n<img />image credit: <a href=\"https://make.wordpress.org/core/2023/04/05/whats-new-in-gutenberg-15-5-05-april/\">Gutenberg 5.5 release post</a>\n\n\n\n<p>A few other important updates in this release include the following: </p>\n\n\n\n<ul>\n<li>New <a href=\"https://github.com/WordPress/gutenberg/pull/49111\">Post Modified Date variation</a> for the Post Date block lets users display the post&#8217;s most recent date updated</li>\n\n\n\n<li>Sticky Position: New “Make sticky” action added to the Template Part block</li>\n\n\n\n<li>Buttons: Disabled support for &#8220;edit as HTML&#8221; in block options</li>\n\n\n\n<li> Time to Read block adds spacing and typography support</li>\n\n\n\n<li>Columns block adds support for template locking</li>\n\n\n\n<li>“Image size” replaced with “Resolution” in image size controls</li>\n</ul>\n\n\n\n<p>Check out the changelog in the <a href=\"https://make.wordpress.org/core/2023/04/05/whats-new-in-gutenberg-15-5-05-april/\">release post</a> for a full list of all the bug fixes, enhancements, and performance, documentation, and code quality improvements.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Apr 2023 15:54:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WPTavern: WordPress Mobile Apps Get a New Support Forum\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143415\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://wptavern.com/wordpress-mobile-apps-get-a-new-support-forum\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1939:\"<p>Support for the WordPress mobile apps is <a href=\"https://make.wordpress.org/mobile/2023/03/28/new-mobile-support-forum/\">moving to the WordPress.org forums</a>. Previously, users were routed to WordPress.com, even those who were self-hosted, and Automattic employees handled support tickets related to the mobile apps. </p>\n\n\n\n<p>This move to WordPress.org is part of an effort to disentangle the official WordPress mobile apps from Automattic&#8217;s services. In July 2022, the Mobile Team announced it will be <a href=\"https://wptavern.com/automattic-is-removing-wordpress-com-features-from-the-official-wordpress-mobile-apps\">pulling all the Jetpack and WordPress.com features from the official WordPress mobile apps</a> and moving them into the Jetpack app.</p>\n\n\n\n<p>Although the mobile apps previously had forums on an older bbPress installation, they were rarely used as those in need of helped were piped through the WordPress.com support queue. The new <a href=\"https://wordpress.org/support/forum/mobile/\">mobile support forum</a> is listed on the Support page and is already active with requests regarding <a href=\"https://wordpress.org/support/topic/wordpress-app-crash-samsung-galaxy-tablet/\">app crashes</a>, <a href=\"https://wordpress.org/support/topic/cannot-connect-to-site-with-mobile-wp-app-403-error-xmlrpc-endpoint/\">XML-RPC errors</a>, and <a href=\"https://wordpress.org/support/topic/gallery-block-glitch/\">issues with core blocks</a>.</p>\n\n\n\n<p>Bringing mobile support to a public place has the advantage of allowing users to help each other, search through old threads, and look for answers in the same way they do for problems with themes or plugins. It standardizes the support experience so users know what to expect. The Meta trac <a href=\"https://meta.trac.wordpress.org/ticket/6686\">ticket</a> for the forum creation has been closed now that the initiative is complete and the forum is operational.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Apr 2023 05:10:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WPTavern: Preferred Languages Feature Plugin Needs Testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143376\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wptavern.com/preferred-languages-feature-plugin-needs-testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2925:\"<p>The Preferred Languages project is gaining some momentum with this week&#8217;s <a href=\"https://make.wordpress.org/core/2023/04/03/preferred-languages-help-test-the-latest-version/\">2.0 release</a> of the feature plugin. In 2017, WordPress Core Committer Pascal Birchler <a href=\"https://make.wordpress.org/core/2017/05/20/preferred-languages-the-prototype/\">released a prototype</a> that lets users select multiple preferred languages in their settings so that WordPress will load the first translation available, falling back to the next language in the list. </p>\n\n\n\n<p>&#8220;<a href=\"https://wordpress.org/about/stats/#locales\">More than half of all WordPress sites</a> in the world use a language other than US English,&#8221; Birchler said in a previous update. &#8220;For these sites and users, the options to change the site <em>and</em> user language are great. But when there’s no translation for a given plugin or theme, WordPress falls back to US English. That’s a poor user experience for many non-English speakers.&#8221;</p>\n\n\n\n<p>Version 2.0 introduces some major changes with a full refactoring of the UI to use React. (Previously it was using jQuery and jQuery UI.) Birchler removed the drag and drop sorting functionality to improve accessibility but users should find that almost everything the plugin still looks the same as before.  </p>\n\n\n\n<p>This update also brings compaibility with with <code>WP_Textdomain_Registry</code> and <code>switch_to_user_locale()</code> for users on WordPress 6.1+ and brings unit test coverage to nearly 100%. </p>\n\n\n\n<p>The <a href=\"https://wordpress.org/plugins/preferred-languages/\">Preferred Languages plugin</a> has more than 2,000 active installs but Birchler is calling for people to test the update, as he believes the plugin is close to a core merge proposal.</p>\n\n\n\n<p>&#8220;One big remaining question mark is the concept of <em>translation merging</em>,&#8221; he said. &#8220;By default, if there are only some missing strings in a selected locale, these would be displayed in English. But with translation merging, the missing strings will be taken from the locale next in line instead. While this works great, it could be <a href=\"https://github.com/swissspidy/preferred-languages/issues/536\">a tad slow</a> due to the way translations are loaded in WordPress. Any help addressing this potential performance concern would be greatly appreciated.&#8221;</p>\n\n\n\n<p>Testers can <a href=\"https://github.com/swissspidy/preferred-languages\">contribute to the code on GitHub</a>, leave feedback on the <a href=\"https://wordpress.org/support/plugin/preferred-languages/\">support forum</a>, and open <a href=\"https://github.com/swissspidy/preferred-languages/issues\">new issues</a> to submit bug reports. Getting this project into core will make using WordPress and its plugin and theme ecosystems more accessible for non-English speakers.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Apr 2023 13:58:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Post Status: Launching a WordPress Product in Public: Session 8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=148693\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://poststatus.com/launching-a-wordpress-product-in-public-session-8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:78164:\"<div class=\"is-layout-flow wp-block-group eplus-wrapper has-theme-palette-2-color has-theme-palette-8-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">In this episode, <a href=\"https://twitter.com/corymiller303\">Cory Miller</a> and <a href=\"https://twitter.com/coreymaass\">Corey Maass </a>discuss their experiences and insights on launching <a href=\"https://crop.express/\">Crop.Express</a>. They share valuable advice on building a brand, developing a minimum viable product (MVP), getting feedback from the community, and handling challenges along the way. </p></div>\n\n\n<div class=\"wp-block-spacer eplus-wrapper\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">34</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n\n\n\n\n<p><a href=\"https://poststatus.com/planet/feed/#h-transcript\">Transcript</a> ↓</p>\n\n\n\n<p>As <a href=\"https://twitter.com/coreymaass\">Corey Maass</a> and <a href=\"https://twitter.com/corymiller303\">Cory Miller</a> move further into their experience of launching a WordPress product in public, they delve into the insights they’ve gained and the obstacles they are facing. Listen to their perspectives on building a community around the product, overcoming challenges, handling feedback, and implementing effective marketing strategies.</p>\n\n\n\n<p><strong>Top Takeaways:</strong></p>\n\n\n\n<ul>\n<li><strong>The Impact of Technology on Personal and Professional Lives</strong>: Technology has revolutionized various aspects of our lives, from communication and information access to work and productivity. This brings about the benefits and challenges of living in a digitally connected world, including privacy, cybersecurity, and work-life balance.</li>\n\n\n\n<li><strong>The Role of Mindfulness in the Digital Age:</strong> Mindfulness practices can help individuals navigate the challenges of the digital age, such as reducing stress, improving focus and concentration, and promoting healthy technology habits. Integrating mindfulness into daily routines and setting boundaries with technology is more important than ever.</li>\n\n\n\n<li><strong>The Need for Conscious and Intentional Technology Use:</strong> Being conscious and intentional about how we use technology, including being mindful of the impact of technology on our physical and mental health, relationships, and overall well-being, is critical. Being thoughtful about developing healthy technology habits, such as managing screen time, practicing digital detox, and being mindful of online behavior, can have a significant impact.</li>\n</ul>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the show:</h3>\n\n\n\n<ul>\n<li><a href=\"https://crop.express/\">Crop.Express</a></li>\n\n\n\n<li><a href=\"https://ithemes.com/\">iThemes</a></li>\n\n\n\n<li><a href=\"https://calderaforms.com/\">Caldera Forms</a></li>\n\n\n\n<li><a href=\"https://restrictcontentpro.com/\">Restrict Content Pro</a></li>\n\n\n\n<li><a href=\"https://woocommerce.com/\">WooCommerce</a></li>\n\n\n\n<li><a href=\"https://www.gravityforms.com/\">Gravity Forms</a></li>\n</ul>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-you-can-follow-post-status-and-our-guests-on-twitter\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> You can follow Post Status and our guests on Twitter:</h3>\n\n\n\n<ul class=\"eplus-wrapper\">\n<li><a href=\"http://twitter.com/coreymaass\">Corey Maass</a></li>\n\n\n\n<li><a href=\"https://twitter.com/corymiller303\">Cory Miller</a> (CEO, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/lemonadecode\">Olivia Bisset</a> (Intern, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n</ul>\n\n\n\n<p class=\"eplus-wrapper has-background\">The <strong>Post Status Draft</strong> podcast is geared toward WordPress professionals, with interviews, news, and deep analysis. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4dd.png\" alt=\"📝\" class=\"wp-smiley\" /><br /><br /><a href=\"https://poststatus.com/category/post-status-podcasts/\" target=\"_blank\" rel=\"noreferrer noopener\">Browse our archives</a>, and don’t forget to subscribe via <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\" target=\"_blank\" rel=\"noreferrer noopener\">iTunes</a>, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\" target=\"_blank\" rel=\"noreferrer noopener\">Google Podcasts</a>, <a href=\"https://www.youtube.com/c/PostStatus\" target=\"_blank\" rel=\"noreferrer noopener\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\" target=\"_blank\" rel=\"noreferrer noopener\">Stitcher</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Simplecast</a>, or <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h2 class=\"eplus-wrapper\" id=\"h-transcript\">Transcript</h2>\n\n\n\n<h2>Session 8 Corey & Cory Launch a WordPress Product Live</h2>\n\n\n\n<p>Corey Maass: [00:00:00] Sort of summarize the, summarize what we wanted, all of the features<br />we wanted, where we\'re at, and then what the next steps are. Okay. Because I think, I think the<br />power balance is about to shift the power balance. Yeah. Previously we were waiting for me, I<br />think we\'re, oh, I think I\'m, I think I\'m caught up.<br />And so I think we\'re stepping more into w you know, you being able to do stuff for, um, you<br />know, we can start working on marketing assets and the website and stuff like that because the<br />plugin\'s actually worth talking about .<br />Cory Miller: Okay. Gotcha. Well, do you want to catch me up on where we\'re at with the<br />product?<br />Then we can shift gears to what\'s<br />Corey Maass: next. Yeah, so the good news is, [00:01:00] um, we had started with Featured<br />image and I had jumped over and featured Image was, uh, had a nice walkthrough or a nice<br />flow. Choose your image, choose your shape, do your cropping. There it is. Um, I had added a<br />bypass button, um, and then had started stubbing out settings, um, so that you could build your<br />own, um, presets or calling them your own shapes, basically.<br />Um, size, width, whatever. Um, and then I had jumped over to Media Library cuz that was the<br />other one that I really wanted, or the next one that I really wanted, again, as a non guttenberg<br />user. Um, And so had brought that up to speed. So it, [00:02:00] now, if you go into media<br />library, there\'s now a second button at the top is the choice we\'ve made thus far.<br />Um, so if you go to library Yep. There\'s a critical error. Uh oh.<br />is that, um, uh, we need to start using Insta. Insta, wp,<br />Cory Miller: um, oh,<br />Corey Maass: this is just my, yeah, go to, um, go to Insta WP and do it. Spin up a site<br />they really want. Um, I mean they\'re, this product\'s amazing Anyway, so you just launch one<br />click.<br />Oh, you reach your limit. Do it in incognito. Okay.[00:03:00]<br />Hackers. Um, but they, they\'ve actually offered us a, um, a test account for, um, for using to use<br />c WP for this product, for these kinds of demos. So,<br />or you can do that.<br />Passwords. I\'ve memorized it. I\'ve memorized it. I\'m gonna hack your account.<br />No kidding. .<br />Cory Miller: Oh my God. Come on, .<br />Corey Maass: Seriously, just do, uh, incognito. You don\'t have to do any of this. There you go.<br />Oh, but now you have to share that window.<br />Nothing [00:04:00] is easy. Um, but anyway. Yeah, so Well, you\'re good. Well you\'re setting that<br />up. Um, so media library, uh, doing two things. One is<br />cheeky boogers. Do you want me to just share? I can walk us through it. Yeah. Okay. Um, how<br />are they tracking cookies? Uh, into incognito. That\'s, uh, they\'re being very sneaky. I think.<br />Enter my name. I don\'t want to one click log in. All right. So I\'m gonna share my screen.<br />Cory Miller: Um, okay. I\'m into, oh, okay. Well then go,<br />Corey Maass: Okay, I got the<br />Cory Miller: free account. There you go. You\'re a hackers. Okay, yeah,<br />Corey Maass: go for it. I\'m here. So, [00:05:00] uh, magic login. There you go. And then plugins<br />add new crop, express, crop of the express.<br />And this is something we need to start working on. There you go. Cuz we, we wanna be first, so<br />we\'ll have to start doing some testing on that. Um, so did you notice we had 10 plus click on<br />view details?<br />Uh, we are up to over 10 active installs, 10 plus.<br />Cory Miller: Oh, is that why you were showing me that? I was like, oh man, are you having a<br />bad day? Cuz you showed me that like Active was like, yeah, but they have these gaps and<br />stuff. But what you were trying to say was the plus<br />Corey Maass: we\'re over 10. We finally made it over 10.</p>\n\n\n\n<p>That\'s awesome. So yeah. So if you go to, yeah, so there\'s now, uh, [00:06:00] settings, uh,<br />crop Express. Um, I put in just a little placeholder welcome. And what we\'ve got here is identical<br />settings, but for all three instances of crop express, right? So you can crop, uh, your featured<br />image in posts, you can crop. There\'s a block in Gutenberg and then media library.<br />So, um, all of them are, are identical. So click on media library, cuz then we\'ll jump over to that.<br />Um, so you\'ve got your presets. Um, so all of the default ones you can turn on and off and then<br />you can add your own. And then down below, uh, are the sizes and we just populate with some<br />sensible defaults, basically.<br />But you can say, uh, you know, make my image, um, oh, defaults shouldn\'t say [00:07:00] max,<br />so I need to fix that. Um, but it\'s the, if you upload a square, it\'ll, it\'ll automatically generate an<br />image that\'s 2000 by 2000. Um, but if you up upload a rectangle one way or the other, The<br />wider side will be the maximum and the, and the smaller side will be the minimum.<br />Mm-hmm. , um, it took me a while to figure out what the heck they were talking about with Men\'s<br />Max and default, but it\'s that, so we need some, some happy text there to explain that. Um, and<br />then, yeah, so if you go back up to the top portion, portion in this page and turn off a couple of<br />these, the four threes or something, whatever, um, and then hit save.<br />And then if you go to media library or media in your menu, um, and if you click add new, it<br />automatically throws you back [00:08:00] to the media library, but with the crop Express open so<br />that you\'re always using it. Um, which could be an option that we give. Um, and then, um, but,<br />and if you go to Media Library and say, Add new, there\'s again, there\'s a new button at the top.<br />Cory Miller: Okay. Can we go back for just one second cuz I wanna make sure I understand<br />this so that I could give feedback and help people. So yeah, of course. Okay. I think this is what</p>\n\n\n\n<p>tripped me up and it\'s probably, cuz I\'ve got old, old school, Adobe Photoshop in mind. Mm-<br />hmm. . But we\'re saying for all the image settings, like here is the preset ratios in a sense, but</p>\n\n\n\n<p>it\'s not just ratios, it\'s like circles. It\'s the preset what.<br />Corey Maass: Sure . Um, I\'ve [00:09:00] gone back and forth between, uh, shapes and sizes.<br />So originally we were calling them sizes, but they\'re not really sizes cuz that\'s Yeah. Pixels. So<br />shapes, um, or preset aspect ratios is what they really are.<br />Mm-hmm. , I just, I worry that people don\'t, that\'s progress, right? Like that\'s, that\'s the most<br />correct way to put it. Um, but people don\'t think that way. Mm-hmm. or like, again, using, using<br />one of my clients, uh, using my clients as an example, um, one of them this week, we kept<br />going back and forth unrelated to the plugin.<br />Obviously we kept going back and forth where, uh, she\'s like, there\'s a bug about uploading an<br />image. And I, I had it. Um, set so that they could upload, they should upload 16.9 featured<br />[00:10:00] images and, and she\'s like, yeah, but what if it\'s really tall? And I\'m like, 16 nine is<br />16.9. And in her head, 16.9 and nine 16 are the same thing.<br />And Hmm. And that to me is like one, we, we can do some education, but two, you know, people<br />aren\'t, uh, people don\'t, aren\'t nerds like me and thinking about 16 nine and nine 16 and yada<br />yada. So, um, yeah, I definitely think some video or a video that explains what any of this stuff<br />is. Mm-hmm. like I, maybe, maybe we\'ve been taking that for granted, or now you and I on<br />session eight are, you know, in it, so we totally get it, but users may not, that kind of thing.<br />Okay.<br />Cory Miller: Um, Okay. Can we spend just a little time thinking about that? Um, yeah, of course.<br />[00:11:00] How, how nor, because I saw this and I was like, man, I know you\'ve got these<br />incredibly smart thoughts about all this, but I was like, okay, I\'m trying to get my head around it,<br />but if I think of, maybe I just share what I think and then Yep.<br />You compare that. Help me, because I don\'t know if my knowledge is ancient. Um, okay. So I<br />go, I need a photo for, or I, I know I\'m gonna want a photo featured image, whatever that is.<br />Okay. And then I go, okay, how wide is my now featured image blows this out. But I just, I go,<br />how wide do I need the photo to be?<br />Like, for most of these, I think I\'m just processing my way. And then absolutely. Tell me.<br />Absolutely. Keep going. . So I go, okay. My constant pain in the butt with WordPress for years.<br />Anything like this. Yeah. Is you\'re constrained [00:12:00] by column width mostly. Okay.<br />Featured image. Image. Just like our post stuff. I hate it because it\'s like, I don\'t want post<br />billboards on top of our, our posts.<br />I want them to get to the post anyway, so thank you for letting me digress. . Okay. So I go, I\'m<br />writing a post, I want an image for it. I either think featured type in like a big image that kind of</p>\n\n\n\n<p>sets the tone, but to me, I\'ve, I\'ve always still gone, like it\'s the post width. Mm-hmm. . Um, and I<br />don\'t like the featured image issue there because in themes, for instance, like I\'ll do an image<br />because.<br />I would do want to set a tone, but then it ends up in the featured and then a lot of themes will<br />pull that and it just looks wonky to me. Yeah. Like I haven\'t thought about it, maybe thought<br />about it correctly, but I go, I want an image [00:13:00] and I default to width, like mm-hmm. , how<br />wide is, you know, the newsletter or the blog post or the theme that I have.<br />And then I kind of wanted to crop down to that specification appropriately for me. And<br />sometimes I just go, I just want width. And I\'ll kind of adjust the height if I have a tool that lets me<br />do that. Um, like, I\'m trying to think. When I was cropping in Photoshop, I would set, maybe we<br />could pull up photo.<br />I don\'t have Photoshop, but I would go to their little cropping tool and go, I want it to be, what I<br />would do, Corey, is I would. Previously go it\'s, I don\'t know, four or 500 pixels is typically what<br />I\'ve locked in my memory somehow is like most column widths for posts are four to 500 pixels<br />wide. Mm-hmm.<br />So I\'d go and Photoshop, I\'d go [00:14:00] to the crop tool, I\'d have my image up, I\'d go to the<br />crop tool and I\'d say 400. And I would leave the height, um, uh, open. Mm-hmm. . And because,<br />you know, not every image does that. And then go, okay. Crop and save. Mm-hmm. , um, and<br />then upload to the, to WordPress. But again, I\'m gonna acknowledge, I don\'t even know if that\'s<br />all probably the right workflow, but that\'s how I\'ve done it.<br />Yeah. You know,<br />Corey Maass: I, I think so. I, I think you\'re right. Like one of my takeaways from that is,<br />I think we\'re, we\'re at a high level anyway. We\'re making the same point that people don\'t think<br />about aspect ratios necessarily as aspect ratios. But, you know, and talking about previously<br />we\'ve talked about, uh, [00:15:00] consistency and that kind of thing, um, and, and making<br />images appear correct for your theme.<br />And so using featured image, you know, something\'s popped into my head, which I think is a<br />neat idea. Um, featured image. So using featured image specifically, it\'s like, how wide do you<br />need it? How wide does your theme want your image to be? And then what aspect ratio do you<br />want it to be? Mm-hmm. . So it\'s like you\'re, you go, you go look at, and we could do a little<br />video that\'s like create a post.<br />Laura Ipsum post, add an image, even even publish it privately. And then go look at the image<br />and how it looks and you right click on it. Like we can give some instructions, but it\'s like right<br />click on it, you know, how big is it rendering, [00:16:00] you know, and, and make your screen<br />the biggest. It it could, it can go.<br />So it\'s like you, your theme is a maximum of 1300 pixels wide. And currently your design says<br />your image, your images go full width. So, so 1300 is the number you want. So width 1300. And<br />then we could e and we could do something, do a little UI in here that\'s like, okay, here\'s a<br />placeholder image, 1300 pixels wide.<br />You know, how much height do you want? That\'s your aspect ratio. So click on 16 nine, right?<br />And it\'s like, keep in mind, I mean, this is all education. Like I don\'t, I\'m not really sure how we<br />get there, but, um mm-hmm. , uh, but to say like, keep in mind, you know, on small screens, like<br />if you\'re going 1300 wide, you don\'t want to be, you know, 1300 tall and you really don\'t wanna<br />be nine [00:17:00] 16 cuz then you are, you know, tw 2000 tall or whatever it is.<br />And it\'s like, that takes, here\'s why the re the reason is you don\'t, you don\'t want your reader to<br />have to scroll and scroll and scroll before actually getting to your words unless you do. Um, but<br />yeah, that\'s, I think that\'s something that, that we\'re gonna have to<br />education too is, is a very grand word, but it\'s like people don\'t think about it. This much. Maybe,<br />you know, if they\'re a writer, then they\'ve never thought about it. They just grabbed a photo,<br />made it look cool. Mm-hmm. and uploaded. Mm-hmm. . And never thought other than like, do I<br />want a circle or not A circle.<br />Or there\'s, I want a picture of a guy on a beach building a sandcastle and I don\'t want the, the<br />shark in the background, so I\'m gonna crop it.<br />Cory Miller: So I wonder, are there websites, [00:18:00] and I just happened to think of<br />beginner cause I know they do things really well. Like the final product, what mm-hmm. , see<br />how they do like this technically.</p>\n\n\n\n<p>Is there feature featured image? Mm-hmm. . Um, is there any other sites, I don\'t want to just<br />hone in on this, but any other sites you think do a really good job of using photos in their blog<br />posts that we could look at real quick? Be The reason why I say that is because mm-hmm. .<br />Final product is really kind of what we\'re selling.<br />You know what I mean? Like what they\'re trying to get to is we, we had that extended talk where<br />we said, you know, it\'s somehow flavors up the content and kind of Right. You know. Um, do you<br />have anybody else you\'d think I\'d like that we could just kinda look and get some ideas real<br />quick?<br />Corey Maass: Uh, no, cuz I never go to blogs.<br />Cory Miller: Okay. [00:19:00] Well let\'s use them real quick. So see, like, I don\'t know if they\'ve<br />tagged this as a featured image, you know, in WordPress mm-hmm. , but you go, okay, from an<br />SEO side, headline, gray headline music and WordPress. Two good things they\'re gonna get,<br />then they\'ve got enough text here. I mean, this is a great formula, WP Beginner, you know?<br />Yeah. Because yeah, they own all the WordPress search terms. Um, what about to, so yeah, so<br />intro, and then they give this little nice little thing. So what are they doing here? They\'re<br />restating, restating the, the headline and then providing something that looks kind of nice. Like, I<br />think this adds value to the Post personally.<br />Corey Maass: So go, go to, uh, Freemius . They always have good blog posts.[00:20:00]<br />Go to any of them. Um, and so these, I think this to me is the more standard blog post format.<br />Click on any. Um, I like Zach, right? So big image in this case, they have the headline over the<br />image and then a blog post. And so I bet the, the background of Zach is the featured image.<br />Okay.<br />Entry header. Entry thumbnail,[00:21:00]<br />yeah. With a title overlay.<br />And their image is 1600 by 500. So an aspect ratio of 16 five. 16 five.<br />Cory Miller: So there\'s a lot here that I really like. Um, like this is a nice looking featured<br />images. Mm-hmm. , they\'re taking, you know, they\'re really, I think this is gonna be important for<br />us if you\'ll indulge me for a second. Mm-hmm. . Um, okay. So they\'ve taken profile photos easy.<br />I don\'t know if they\'re creating this, like where are they getting, how are they doing all these, but<br />looks standard, right?<br />Like there\'s the same character,<br />Corey Maass: their little robot is theirs, so they must have an illustrator who\'s creating them.<br />[00:22:00] But I bet some of this is probably just clip art,<br />but somebody\'s taking the time to create these images. Yeah. Canva. P. Yeah. You know, some<br />other editor.<br />Cory Miller: Okay,<br />same here. Like, probably find the source to do that. Cutting. These are like screenshots, which<br />I think kind of might flow into your other project you were talking about, right?<br />Corey Maass: Ooh, here\'s another good example. Um, go to, I\'m gonna send it to in Slack.<br />What\'s your name again? Just kidding. Bob<br />So this is actually really, I just googled for, you know, baking blog or [00:23:00] something, but<br />this is actually really neat. So this tape I, this jumps we\'re jumped right into a category, but look<br />at the aspect ratio of these images. And if you click on any of them, they\'re the. They\'re the<br />same. And if you click through, they\'re actually using the featured image, uh, to the side of the<br />title.<br />So like, here, here, I see it twice, go hit back once and click on the first one. There\'s like swirly<br />brownies, which look very good. Yeah. Click on that. So there\'s, there\'s, you know, big brownie<br />image. Scroll down a little and let\'s see if they use it again. I\'m just curious. Yeah, so it does<br />repeat, but you see, it\'s, it\'s the, the coincidentally, I found a blog that has featured images that<br />are taller than they are wide, little unconventional, but again, an a, a different, a another<br />example of a [00:24:00] different layout.<br />Right. So you found, you went to WP Beginner. They use, it\'s, it\'s horizontal. And it\'s in line. So<br />it\'s gonna be smaller cuz it\'s in that with it\'s confined, confined by that column. Go to Freemius .<br />It\'s, you know, 1600, it\'s full width cuz they\'re using it the way, um, I often think of a blog, they<br />want a big, big, big image that takes up the full header.<br />Um, and then found a cooking blog that does taller rather than wider, which I, I was sort of<br />including to just include, but coincidentally right away found a blog that does in fact do that. Um,</p>\n\n\n\n<p>and so I think what, you know, what we\'re really getting at is, uh, again, it\'s the, you know,<br />you\'ve selected a theme or you already have a theme.<br />How are the images being shown? [00:25:00] And so the, you know, the, let\'s pretend that<br />Hummingbird High. Is, uh, an amateur blogger. And so they are new to WordPress. Um, and so<br />they install a theme and they add start adding recipes, and they\'re just taking, like we\'ve talked<br />about, they\'re just taking photos off their phone.<br />So they don\'t know. I think, you know, to your point, they\'re like, I haven\'t put in any posts yet. I<br />don\'t know how big I need my images. Um, the theme seems to want such and such an aspect<br />ratio where I\'ve read the, let\'s pretend they\'re even like, nerdy enough to read the docs. Do the<br />docs include any mention of here\'s how big you want your images, that kind of thing.<br />And so yeah, there\'s, there\'s a need for. [00:26:00] Again, the, the most thorough process of like<br />AIP, post, add a fake image, even temporarily, see how it renders, and then tho that\'s the<br />information you want. Um, and I don\'t know how to do that. I don\'t know that we can do that for<br />them because as we\'ve shown, you know, if you\'ve got a blog that, if you\'ve got a layout that<br />doesn\'t label your featured image as a featured image, like I have no way of going and writing a<br />little code that like goes and scrapes it.<br />Mm-hmm. and imports that and tries to import that information.<br />Cory Miller: So what if we looked at the, okay, yes, that is, um, all that stuff underneath all this<br />that someone would need to, if they\'re really gonna do this at a high, high level, they need to<br />understand all that stuff. Um, you [00:27:00] know, like really what is your theme?<br />I think for the premise for this free one could be like, if I just look at WP Beginner, um, you want<br />to, the outcome is nice looking, um, scaled appropriate images. There\'s an NCO side to it, but<br />like how do you get somebody, and this is bigger than the plugin right now for sure, but you go, I<br />think a huge win could be like this makes it easier to get nice images that kind of break up.<br />Mm-hmm. your post and show specific things. And if I just go default. Don\'t worry about themes<br />so much cuz those could be specific integrations. Like Cadence has an integration builder.<br />Builder. Right. You know, specific for that. That could be all that paid stuff that we talked about.<br />Yeah. But if I [00:28:00] go, if we keep it the way it is now, which is in, well it\'s either fit featured<br />image, which for sure has the theme stuff that you were talking about, where you go in post,<br />how do you create something like, like this is, these sites we\'ve seen have for are formulas and<br />I\'m trying to think through how we can get through the formula is an easy button to nice looking<br />blog post with some images appropriately sized.<br />Mm-hmm. , um, you know, like I\'ve long admired what WP Beginner does cause they\'ve got this<br />formula that works. Like, yeah. All this, every post. Not trying to, this is not a negative to me.<br />Every post is a very defined formula. Yep. Screenshots are in here, you know? Um, they do<br />have to create an image and then still get it in there.<br />So they, that\'s part of their formula. Just like your, [00:29:00] the baking site with the brownies,<br />you were, you were pulling apart the tech specs for how they do all that. And it seems like, yeah,<br />so anchoring back, back in these presets is like, how do you just get somebody to, Hmm. Sorry,<br />I\'m probably getting a little lost in my own thoughts here, but<br />Corey Maass: as long as you keep talking,<br />you\'re good.<br />Cory Miller: Um. But you go, like when you buy, when you get a product or you buy a product,<br />whatever, you\'re, you\'re really buying whatever the result of it is, you\'re actually not buying the<br />product, you\'re buying this out, this outcome.<br />Corey Maass: And when you buy a piece of software and fire it up, you start hacking away at it,<br />Photoshop you, you\'re create new and then, [00:30:00] and it, and it says, here\'s some, here\'s<br />some document sizes, but you know, here\'s a thousand by a thousand, a white canvas.<br />And off you go. And then you\'re like, well, but I really want, I wanna see my text options. I wanna<br />see. And so then you start playing with what menus to show or hide or you start playing with,<br />and that\'s when you dig in, right? So, um, yeah, I, we, what would be great, and this is, this is<br />sort of what we\'ve started with.<br />again, sensible presets I, or sensible, I mean, I, again, I\'m calling \'em presets, preset aspect<br />ratios. So if somebody doesn\'t go to the setting screen at all, they click featured image. They\'ve<br />got six predefined aspect ratios that, again, are sensible. Um, and they\'ve got, and, and they<br />don\'t know anything about sizes, but we\'ve put in some pretty [00:31:00] industry standard.</p>\n\n\n\n<p>Mm-hmm. , safe for mobile, safe for desktop image size, men and Max. So we might be pretty<br />close to what you\'re talking about. Mm-hmm. and maybe six isn\'t the magic number. Maybe it<br />should only be Square Circle and 16, nine. And the other ones are. Extra. So maybe it\'s too<br />many. We don\'t know that yet, but,<br />Cory Miller: well, you know what, I lost track a little bit of the settings page because this was<br />intended for the agency, like mm-hmm.<br />I mean, you deliver, like, one of our thesis here was you deliver a client project. This really, like<br />the intention for the settings was for those freelancers, web owners, agencies delivering<br />products or delivering websites to clients. And then from that point, like I was trying to reconcile<br />the settings page with just [00:32:00] being a user, but that wasn\'t our intention.<br />Our intention was give those tools to put in the little scoot in the little bumpers on the bowling<br />lane, right? Like that\'s what the agency does pull, you know, Hey, were you, we, whatever<br />theme framework we use, we know it\'s gonna be 69. You know, put the minimal X. Yeah. And<br />then when they do that stuff from the featured image, And, and the user starts using it, it\'s<br />already there.<br />So we\'ve, we\'ve taken this thought of like, this is, to me, this is for an agency to ship better<br />guardrails for images for their client work. Yeah. So my question to you, I mean, as a, you\'ve set<br />this up with the thought, I thought, you know, as a developer, right? So like, I, I\'m not, but I go,<br />your mindset was to do, put these tools, settings in here for that technical person at the agency.<br />Yeah. Or we delivered it. [00:33:00] Make sure this is like, go through real quick and set these,<br />and that\'s, that was our intention for this. Yep. So as long as it speaks to the, like, I don\'t have to<br />note it, know it necessarily as a user, as long as the devs do. And if we check that box, I think<br />it\'s, we ship it and we start talking about like, we, what we try to do is give a.<br />Guard, I\'m rehearsing some of this for a copy. Mm-hmm. , it was like, this is to give guardrails to<br />your clients for their images. Take, take it, take 30 seconds, you know, when before you deliver<br />the client and do these real quick, and then you\'ll put the little bumpers on the bowling alley for<br />\'em.<br />Corey Maass: Yeah. And I, I think I want to, the only, the only caveat or addition I want to add to<br />what you just said is that it\'s not, let\'s not say dev, right, because dev implies code is, it\'s a scary<br />thing to [00:34:00] a lot of people, whereas.<br />Uh, you know, in my mind the, the word like there, there\'s never been a good word for the<br />people who are WordPress pros who don\'t necessarily write code or write a lot of code or write<br />custom plugins, right? So there\'s still experts in my mind at some, at some time. Like 10 years<br />ago the word was, um, that I was introduced was implementer.<br />So it\'s like someone who implements WordPress and WordPress tools but isn\'t a developer,<br />right? But, so to me, this is like somebody who doesn\'t even, doesn\'t write code, but is setting<br />up a site for a client, installs their favorite theme, knows that the theme looks great with 16 nine<br />images. And so they\'re the ones that are gonna go in and tweak these settings.<br />Um, and so, yeah, and, and I think the analogy of, there\'s nothing that says. There\'s really<br />nothing that [00:35:00] says you have to even touch that setting screen if 16, nine or circle<br />meets your needs. Um, and then the, and, but, but I agree, like the language could be a, a heck<br />of a lot friendlier. Um, and we need docs that explain it, right?<br />Um, and so that\'s where like, I think, I think you come in and the kind of thinking that you\'re<br />doing of, you know, the, the, the unknowledgeable, the as yet unknowledgeable user, you know.<br />So on that little welcome screen, on the settings page, it says, welcome, you know, watch a<br />62nd video that explains what the heck is going on here with 10 seconds.<br />That explains, you know, why image size and shape is important in the simplest possible terms.<br />Um, And then the other thing that just occurred to me is actually that, that you kind of alluded<br />[00:36:00] to is, uh, I don\'t remember how you put it, but the, the idea of the sort of pre preset,<br />like, I\'m, I\'m way down, I\'m close to the metal where I\'m, I\'m calling a preset, or when I say<br />preset, I\'m saying preset aspect ratio.<br />But I, but you actually kind of alluded to, um, like a preset featured image or a preset something,<br />something, right? Mm-hmm. . Um, and I realized that like, again, what I\'ve created I think is a<br />great, we\'re still on version 0.0 0.3. Mm-hmm. , so I think it\'s appropriate. Um, but, uh, uh, and<br />so, or what I\'m say, sorry.</p>\n\n\n\n<p>Um, we have the crop. That is identical in three different places. Right? Featured image. And the<br />likelihood is your, what, what The assumption that we\'re going under, which I think is, is pretty<br />safe, is [00:37:00] you always, once you get rolling, you always want your featured image to be<br />the same size and shape. Mm-hmm.<br />So that mm-hmm. , all of your posts look consistent. Mm-hmm. . And the same might go for,<br />might not go for in, in post images, cuz you might want a smaller one shifted, left or shifted right.<br />You might want an infographic that\'s tall and so you don\'t necessarily want to be confined, but<br />here are some, some presets that, you know, look we like, you know, getting a level deeper with<br />design is you often want.<br />Your images to be similar throughout a website, the same way you want fonts to be. Similar<br />throughout a website, you want colors to be similar without throughout a website. So, you know,<br />in a perfect world, not that you shouldn\'t sometimes break the rules, but you often want, if your<br />featured images are all 16, nine, you know, [00:38:00] design a a design guideline might<br />encourage you to have 16, nine images elsewhere.<br />That\'s a little digression, but I think that\'s true. And then taking this even further, if you go to the<br />media library, uh, again, right now for the sake of simplicity, I\'ve got the same settings and the<br />same UI applied to the media library, upload a 16 nine image. But here I actually see, uh, a<br />different, or I\'m envisioning a different UI that says, Upload a featured image, which uses the<br />settings from the featured images.<br />But we could also include things like upload an image for Twitter, upload a, you know, and this is<br />where a preset comes in, right? Upload, you know, a circles a circle, but upload a, and this is, I<br />think what, going back to, uh, the, [00:39:00] the little, um, sticker mule menu that we were<br />talking about where there\'s sort of these predefined touchpoints.<br />And so, yeah, so it\'s like you\'re, you\'re in a post, you\'re writing a post. And we also, I think we<br />are spending a lot of time, we are being very word pressy. Um, and it might be to our detriment,<br />um, we are assuming anybody is actually writing a post. And I even saw a headline I think this<br />morning that was like, should WordPress get rid of the blog?<br />You know, it started as a blog, but should we, should it actually get rid of the blog focus<br />altogether? Because most people are using it as a C M S and building pages more than posts.<br />Mm-hmm. is, is the, was the hypothesis. But anyway, uh, you know, feature image images still<br />applies to pages. Um, when you\'re writing a page, you know, we say in post [00:40:00] image,<br />but an in, in page image, so we\'re not thinking wrong.<br />But, you know, thinking of WordPress as a c m s, you\'re like, you build a page, but then you also<br />need an image for two, an OG image, open graph image for social, you might want to da da da<br />da da. And this is where we were talking about, you know, what, what you really need is an<br />image crop so that no image gets uploaded to WordPress incorrectly.<br />Mm-hmm. , right? And that\'s where, uh, I, I\'m, you know, again, I, we\'ve sort of talked about it<br />and you kind of alluded to it a minute ago as like, within at least media library to have a, you<br />know, what kind of image do you want to upload an image for Twitter? Okay, well that needs to<br />be this size, the shape. I wanna upload a header for Facebook.<br />Or, you know, it\'s like, I mean, these are bad examples cuz you\'d upload those to Twitter or<br />[00:41:00] to Facebook. Um, but it could also be, uh, you know, it doesn\'t even necessarily get<br />up, get saved to your media library, crop in image for Twitter. Download it and now, now post it<br />to Twitter. Crop an image for Facebook.<br />Now post it to Facebook. Do you wanna also save this in your media library?<br />and that\'s where we kind of end up taking over. You know, it\'s like media library bec, you know,<br />becomes, uh, Photoshop within WordPress. Okay. Now that\'s interesting. Um,<br />what kind of image do you want to create today?<br />Cory Miller: You said something that was really interesting to me, um, that stuck out and it\'s like<br />the c m s conversation. Hmm. Is it just the c m s or, you know, [00:42:00] do we, so I was trying<br />to find this blog site to see how they did it, but you go like, but there are people that still use<br />publishing their WordPress is their publishing tool.<br />Um, and I think of that like your client\'s content journey clients mm-hmm. and. They\'re using the<br />blog side. And I go, that was a helpful distinguishing for me is like if you just using the c m s, our<br />image is gonna be static. For instance, most cases, like you\'re not gonna do a lot of image<br />manipulation.</p>\n\n\n\n<p>You may in turn, uh, initially, but we\'re turning over to people that are pushing the publish button.<br />Like you have a newspaper or a magazine client, for instance. They are like, they\'re in the<br />business of publishing. Yeah. Steady content. And that just made me think about the use case<br />again, is I still think the settings [00:43:00] conversation is great because a lot of these people<br />are gonna have agencies build the site because they.<br />To do the publishing really fast. So we\'ve given those tools to the setting, they\'ll look over here.<br />It\'s like I went to moz.com just to see how they use damages. Oh, sure. I went to HubSpot, like<br />the bakery site. Oh, HubSpot. Yeah.<br />Corey Maass: Since they\'re big on SEO and, but I bet. But they do a lot of content.<br />Cory Miller: They\'re publishers, um mm-hmm.<br />which is really interesting. That aligns with where WordPress is, you know? Yeah. Okay. Let me<br />find, try to find,<br />I, I think this is important. This isn\'t wasted because it\'s, um, we\'re drilling down closer to<br />really crystallizing who, yeah. Who, who, yeah. Okay, so [00:44:00] lemme just go back. Okay.<br />So they\'re obviously using, this is probably, Well, hope has their own thing, but like they\'re using<br />some image to draw some interest to the,<br />Corey Maass: so up top you\'ve got four, three. I\'m just, I\'m gonna keep nerding out about this<br />cuz it\'s like, this is what people aren\'t seeing.<br />They\'re, they\'re seeing but not absorbing right? Is Right. On that previous page, you had four,<br />three images and square images, and then you drill, drill down and what would be, you know, a<br />primary image at the top again after the paragraph? Looks like it\'s about four three. But it, but I,<br />I, I liked your WP beginner example.<br />Same with HubSpot, is that they\'re just, they\'re just, they\'re essentially just putting images in line<br />and just like a magazine. So you\'re reading a magazine and they might have a big pretty<br />picture, but they\'re, um, you know, throughout an article they\'ll have [00:45:00] photos.<br />So like,<br />Cory Miller: huh, good<br />Corey Maass: God. Okay. I go to like rolling stone.com.<br />Like go to a publisher. That\'s interesting. Whoops. Yeah,<br />so those look like four, three images and then some square images. Just scroll down a little<br />interesting that this layout is almost identical to, um, Huffington Post , or not Huffington Post, uh,<br />the Atlantic. If you go to the Atlantic , it\'s almost identical. Um, but anyway, there\'s another<br />example. So [00:46:00] like we get into actual news sites, so they\'ve got those look closer to like<br />16, nine.<br />Um, yeah, go back to Rolling Stone. I don\'t need to see Huffington Post homepage. That\'s too<br />depressing. . Um, but click, click into, click into any one of these stories. And here\'s a pretty<br />typical layout. You know, there\'s that featured image again, and then the story below it, and<br />then, but I bet they have images within, I guess this one\'s just a short story, but anyway.<br />Yeah. You think this is four 30? It looks pretty close. I mean, I\'m eyeballing it. Yeah. But,<br />but also, but I guess close enough that if somebody who isn\'t rolling Stone wanted to create<br />their own website, they\'d be like, okay, every time I in. Insert an image into a story, [00:47:00] I<br />will use the four three. Like we, so we, you know what, what, I guess I never finished the<br />description of the, the new version is we have settings and we also now have a block, a<br />Gutenberg block.<br />Yeah.<br />Cory Miller: By the way, you snuck that in on me.<br />Corey Maass: Yeah. So, so we now have, we\'re, we\'re, we\'re pretty close to like feature<br />complete, right? So we have fe you can crop a featured image, you can crop, um, a Gutenberg<br />block and you can crop images going into the media library. Um, and so I think, you know,<br />again, I, uh, I th we\'re focusing a lot on settings, but I think that there\'s a good chance that most<br />people, your average person, will never need to go to those settings.<br />The likelihood is that most will, uh, so I called it cropped image because I think most people are<br />gonna look for image. So it says, select, select an image to crop, and then here\'s our presets.<br />And so I think what most people are gonna do is [00:48:00] they\'re like, they will decide, they will<br />choose four, three, and then, and then every time they do this again, they will choose four three.</p>\n\n\n\n<p>Like, that\'s how most people use these kinds of tools. Like they, they do something once or they<br />learn, click, click, click. They don\'t necessarily think about optimizing their clicking, and so they\'ll<br />just choose four, three every time. If it looks good, the first.<br />Cory Miller: So question about the four three. So we\'ve just said this is probably one of the four,<br />three and 16 by nine, you already know this, but four three was a lot on these sites and that<br />typically, like I\'d look at beginner and all these others, and I go, it\'s four three, like in the, in the<br />vicinity, right?<br />So how did you determine what this with is?<br />Corey Maass: Uh, so that is what\'s set by the, on the settings page. I\'m not saying go there, but<br />there are, [00:49:00] um, some common sense defaults. So it\'s at least a thousand wide and it\'s<br />less than 2000 wide. So if you tried to upload something that was off of your phone, high res,<br />you know, 8,000 wide, it would bring it down to 2000 or something.<br />But you also, if you tried to upload just an emoji, it would make it. Bigger, unless you said<br />bypass.<br />Cory Miller: I see. Okay. So the rationale, so we\'re picking four, three, and then we\'ve got these<br />bigger bumpers. So like this mm-hmm. , if we, so this image is actually whatever the settings</p>\n\n\n\n<p>are a thousand wide. So it\'s technically bigger than it needs to be because of the settings. Mm-<br />hmm. . But that probably has advantages, I\'m guessing, [00:50:00] for.</p>\n\n\n\n<p>Corey Maass: For and for responsive. Like, I\'ve actually built sites before that. So, you know,<br />when you think about responsive and I, I know I\'m devving out here, but, um, no, go for it.<br />You\'ve generally responsive. You\'re thinking mobile phone, you\'re thinking tablet, and you\'re<br />thinking desktop. Right. And uh, I\'ve actually seen sites where, uh, on desktop we had multiple<br />columns of content.<br />So the images were a third of the total width of the site, which, which didn\'t go edge to edge on<br />the screen. So an image was never more than like 800 wide. But then if you looked at it on<br />tablet, it, it went to a one column view images over text and, and not multiple columns of<br />content. And so suddenly it was 10,000 or it was a thousand wide, uh, or, you know, [00:51:00]<br />the size of my iPad here with right.<br />And so it actually went wider on mobile. And so a lot of people will be messing around building<br />their website on their desktop computer or on their laptop, and then eventually they\'ll look at<br />their phone or they\'ll look at their tablet, um, to do, to test it, and the images will actually go<br />wider. Um, and so it\'s not a bad thing to have an image that\'s, again, it\'s if it\'s compressed,<br />which is a whole different conversation.<br />Um, and not, if it\'s not four megs and 8,000 pixels wide, it\'s okay. That. A little too big cuz<br />browsers will size things down. Um, and better that than then it\'s the, then it\'s 800 and gets<br />upsized to be 1200. Cuz that\'s when it looks bad.<br />Cory Miller: Gotcha. Okay. I\'m, I\'m much more understanding this now and it makes [00:52:00]<br />sense, um, because it\'s okay to have like a thousand, whatever the default settings are Yeah.<br />Because you\'ve got these benefits, but it\'s not like an 18 meg file. Exactly. You know? Exactly.<br />But it, it\'s, it\'s in the window of like being quality image and you can set those differently if you<br />want.<br />Like in the setting. Yeah. So that\'s, that\'s great there. Yeah. Um, I gotta tell you, I think right here<br />you\'ve nailed it. , like we\'ve got the Gutenberg block. Mm-hmm. . All right, magician, how\'d you,<br />how\'d you get this done? Have you been working on this ? I think you told me you were gonna<br />work.<br />Corey Maass: No, no, no, no. We, so we, you know, early days when you and I first started<br />talking about this, um, I hired a couple of different developers, one who helped me out with<br />featured image and one who helped me out with block.<br />Um, and they got me [00:53:00] pretty close to the block working, but I couldn\'t, I hadn\'t<br />wrapped my head around. Uh, everything else that I\'ve subsequently wrapped my head around<br />by building it for featured images and building it for media library. So then when I went back and<br />looked at, uh, what he did for the block, I was like, I literally copied the code from Featured<br />Image.<br />And so it took 45 minutes or something because he had already done the, the tricky part. And I,<br />again, have learned a lot more in the interim time. So, uh, so yeah, it was, it was, uh, too big of<br />a lift early on, but coming back to it, it was almost easy. So, yeah. Um, for me, I want to. See if<br />[00:54:00] I can, cuz again, I, I\'m using, um, the classic editor.</p>\n\n\n\n<p>I wanna see if I can overwrite the featured image for that. And then we\'re pretty close to, um, I<br />guess we need the media, like if you click on the add, add image button, you know, in the<br />classic text editor, um, you know, there\'s a couple of, of little things, but they\'re not, they\'re not<br />insignificant, but they are not like modern WordPress.<br />So we\'re, we\'re in pretty good shape. But yeah, I, I definitely would love your input. Like things<br />like, don\'t call them presets, call them preset aspect ratio. Mm-hmm. , um, um, and start thinking<br />about the, you know, the happy text, the explanation text, the, um, do you upload one of your<br />broken images again? Yeah.<br />um, You know, and, and docs and, and welcome text. [00:55:00] And, and if we start talking<br />about, um, a little video for, um, you know, to put on that welcome screen, like that\'s, that\'s<br />where we\'re at. Like starting to actually make this, uh, friendlier and, and more clear. I like your<br />guy.<br />Cory Miller: Okay, now I was just playing with that. Yep.<br />That\'s awesome man. I think this is a game changer. I think this right here could be the v1, like<br />in this, you know, that\'s where we started from a long time ago. We just weren\'t there. We<br />needed some time and space to like be able in opportunity obviously to do this, but like that right<br />there. Hits my original.<br />Holy crap. Can we have this? Can I have this? Mm-hmm. , I want this thing [00:56:00] because<br />Yeah. That\'s super cool. But now some more, I, I heard what you were sayings like more all text.<br />If, if I, if I may though. So is the, em the image is cropped right here. Mm-hmm. . But there\'s<br />white space. So is this the block takes up the whole thing.<br />So we, we would, we can\'t do like Right. Justified or something like that.<br />Corey Maass: What? Right. These are things we need to, to work on. Okay. Add, yeah. These<br />are, and I, and the truth is, is, is I need more real world usage. Mm-hmm. and people telling me<br />what they need for me to know what to add. Okay. I mean, the, I think, you know, the, the easy<br />analogy is if you go at a regular image block,<br />Good luck figuring it out, cuz Gutenberg is confusing [00:57:00] as heck. Not that I\'m cynical.<br />Um, but you\'ve already got, uh, yeah, alignment. Um, what\'s the little triangle next to it?<br />Oh, those filters. Mm-hmm. . So there\'s, you know, like that\'s where, you know, if people are<br />using them, if they want them, we can start adding stuff like that. And this is where, what we\'ve<br />talked about, like we can, you know, we can start messing around with other stuff if, if people<br />want them, um, people need them.<br />You know, we\'re, we\'re still currently at version 0 0 3, so,<br />Cory Miller: okay man, you can get lost in these settings. They\'ve added a lot of the settings it<br />seems. . Mm-hmm. . So would we be able to take, I think somewhere along the way, you<br />mentioned you [00:58:00] looked at a current block and saw some opportunities here, but would<br />these, taking this block with some of these things like the filter, um, would be, we\'d be able to<br />hook into that.<br />I mean essentially like fork? Fork.<br />Corey Maass: Yeah, I think so. I think so. Or ex extend it basically.<br />Yeah. See there\'s your aspect ratios.<br />Cory Miller: This must have got a big update or I\'ve never looked at it.<br />Corey Maass: Yeah.<br />And you know, and part of why it was, I loved your idea of. Doubling down on featured images is<br />none of these are available and, and are not at, at least as far as I know and are not available in<br />media library.[00:59:00]<br />But, so maybe we should do a session where we like, walk through these and, um, yeah. Begin<br />further. Seriously.<br />Wow.<br />Cory Miller: Okay.<br />That\'s, yeah. We de I, I, I for sure need to do this because I had no<br />Corey Maass: idea.<br />People at watching are gonna be like, uh, yeah, it\'s been there for six weeks.<br />Cory Miller: Now that, oh, you have to upload the image first. Okay. Or you have to get the<br />image.<br />Corey Maass: Sorry. Yeah. I think, I think especially, I especially think the alignment [01:00:00]<br />stuff, because that, that to me is version one, right? Like, you need an image, you need the</p>\n\n\n\n<p>image to behave the way you want. Yeah. Shift left, shift right. Whatever. Um, and then getting<br />into this kind of stuff is, is gravy and is a rabbit hole.<br />Oh yeah. Like, you know, we can start again. I, I, I like that we set up a request for feedback.<br />Um, It would be nice if we started getting people using it cuz then they\'d be like, oh, the default<br />block has such and such. Three, two, why don\'t you have three, two, and go, okay, so let\'s go<br />add three, two as a default preset aspect ratio.<br />And you know, or hey, we, you know, why doesn\'t the image shift left sh you know, uh, or why<br />can\'t I set widths? Okay, great. We\'ll go add that. Mm-hmm. . [01:01:00]<br />Cory Miller: Okay. Maybe I need to play with that a little bit more. Um, yeah. Now, but standing<br />now you don\'t wanna like best, uh, that we don\'t have at the moment, but alignment, we\'ve<br />already talked about that.<br />Having that, that\'s, that\'s pretty cool. Cause you can go over here. Right, exactly. You know, all<br />that stuff. This is incredibly compelling to me. Um, because it\'s kind of your way like. You know<br />how themes do this with your color settings. Mm-hmm. , but having some, I don\'t, this is just a,<br />this is a pretty cool way to Dr.<br />Like, this is just this boring image just done with a little filter. Mm-hmm. , or they call these filters,<br />duotone filters. Yep. The filters are really interesting to me because you can make it like, it\'s not<br />gonna be just another stock. Yours. Yeah. You kinda make it yours. Um, but I think now with the<br />Gutenberg plug, man, that\'s the, [01:02:00] that\'s the feature.<br />Um, I could get us to more installs. Um,<br />Corey Maass: I agree. Um, I don\'t, I don\'t know that I\'d, I\'d be curious why that\'s not the right<br />word. How the core team and, you know, 500 volunteers, et cetera, landed on Duotone. Um,<br />mm-hmm. rather than something else, because it\'s, you know, WordPress is at the whim of the<br />people who, who are involved.<br />So it\'s like, did they ask for this? Did they want this? You know, did somebody like me come<br />along and go, oh, this is a neat thing, let\'s add it. And everybody was like, yeah, it\'s cool. We\'ll<br />add it, you know, or people using it. I, which is, and that\'s of course the black box, black box part<br />of WordPress is [01:03:00] we will never have any idea whether people are actually using<br />Duotone filters, um, et cetera.<br />I know that\'s a bit of a cynical approach, but it\'s like, I want to, I wanna make sure that we are<br />focused on. We want our own bumpers because it\'s, you know, this is, this is the slippery slope<br />that I often fall into. It\'s like, I trusted my gut when you were like, I need a circle. And I was like,<br />yeah, we need a circle.<br />But I don\'t, my gut doesn\'t jump when, when we say duotone filters unless, yeah. You know, but<br />unless we have compelling evidence that people are using them.<br />Cory Miller: Yeah. Well I think though the, the single po single block, the, the, the crop to image<br />block could be really that ticker for, uh, um, getting those active installs.<br />Um, and now we [01:04:00] need to switch to, I wanted to make sure we talked to that side<br />because, uh, you surprised me with it. I saw it in there and I was waiting. I was like, no, let him<br />talk about the settings. You\'re like, go. Featured image or whatever, and I was like, I really want<br />to click on GI Berg Block by White<br />Corey Maass: Um, well, and that\'s, I really, yeah. Uh, the block I think will evolve unto itself. It\'ll<br />have those settings, right? Because your, your media library, even your featured image doesn\'t<br />have left or right. A line, like that\'s up to your theme, how it\'s being used. Um, so, so the block<br />will start to evolve with additional settings.<br />Whatev, and we did, again, my gut jumps. Yes, we need alignment for sure. Um, you pointed out<br />yourself, you\'re like, I uploaded a Lego man and he\'s always aligned, left, like, that\'s useless. So<br />immediately we need those, we need alignment. Um, and then I also want to start [01:05:00]<br />evolving the idea of, again, media library presets, meaning, you know, what kind of image do<br />you want to upload?<br />And, and again, and I, I start to get really excited about the idea of images that aren\'t even<br />stored in the library. You\'re going to, like media library implies, or we are taught by WordPress<br />that this is where we store images for WordPress. But why isn\'t it just called media? And why<br />isn\'t a place where you can go and edit an image and download it and it, and it has nothing to<br />do with WordPress.<br />And that\'s exactly the, the sticker mule conversation we had. Mm-hmm. like utility, go to media.<br />Yeah. It\'s a utility to go to media. And it\'s not a media library or it\'s not just a media library. It\'s a</p>\n\n\n\n<p>place where, you know, you can edit an image and then download it. So it\'s like, yo, you just<br />created a post for.[01:06:00]<br />You know, a new post about the brownies, the brownies images image is already in there. Now<br />you need to create an image for Twitter, you need to create an image for Facebook, you need to<br />create a square image for Instagram. So jump into media, grab that image that\'s already in the<br />media library, edited a bunch of times, maybe put a title over it.<br />Download the result. Again, doesn\'t get uploaded to Media Library necessarily. And then now<br />you go over to your socials, or go into Buffer or whatever tool you use for scheduling your, you</p>\n\n\n\n<p>know, multi broadcast to all of your socials and upload the appropriate image for each one. Mm-<br />hmm. . And that also diverges us from Word.</p>\n\n\n\n<p>which I think is important, especially now seeing the default image. Like you said, I didn\'t realize<br />half that stuff was in there. And so we are starting to overlap with them, [01:07:00] which I don\'t<br />want to do. Like, what\'s the point? If it\'s built into core. I mean their, our original thesis was<br />within media library image cropping is awful and I\'ve maintained that.<br />It still is. But if you can crop an image as quick as we can inside of a block, then, then maybe we<br />don\'t need a block. What\'s our differentiator there? But image manipulation elsewhere within<br />WordPress. Like right now, I would absolutely argue that our featured image handler is better<br />than the defaults.<br />And same with media library still. Mm-hmm. . Cause that, that\'s that original crop. That\'s awful.<br />So these are the things that we need to, to balance. Yeah. I,<br />Cory Miller: I mean, I still think the image blocking burg, the, the crop tool is just, I don\'t, I don\'t<br />even know how to use it. Right. [01:08:00] Um,<br />Corey Maass: yeah, yeah. I\'m not, I\'m not necessarily saying we, we rip, you know, I\'m not<br />gonna go rip it out in version 0 0 4.<br />Mm-hmm. , but I don\'t wanna, we don\'t need to recreate that, which WordPress already does.<br />That\'s silly. Yeah. Um, because, and, and I mean, to be like, there, there are plugins out there<br />that do core features better, and we can still do that. But that, that\'s, that, uh, the me, the margin<br />is thin. The, the margin of value that we add is thin if the features are already there, whereas not<br />jumping over, having.<br />Create a post, a story, a page in WordPress, and then jump over to Canva to create your social<br />images. To me, the margin of value add is much larger. Mm-hmm. . So,<br />Cory Miller: yeah. I, I was just trying [01:09:00] to think about, you know, you look at,<br />you look at, like some of the sites we just looked at and you go, there\'s a formula here for how<br />to create a good image. And<br />I would think like, like showing w beginner, for instance, they\'re gonna need Camba or some<br />photo editing, graphic design software. Um, but there\'s this case potentially for the output you<br />want is something like, like I just went to Medium for a second. And was kinda looking at a<br />couple of the articles.<br />Cause I go, you know, high readability, beautiful design, um, very standard. And, you know, I\'m<br />looking at all these posts here and they all have, you know, an image and we know, we know it<br />would be better if you had the image. [01:10:00] Um, my, so I\'m just kind of keeping thinking<br />about what\'s the three value proposition, what\'s the paid value proposition on this?<br />Mm-hmm. and what\'s our space for this? Um, but I do think, like, here, here\'s the, here\'s one<br />part. There\'s all, there\'s this image block within Gate Burke and you go a lot of stuff, a lot of<br />people have thought through those things. A lot of options. Most people won\'t even touch \'em.<br />Mm-hmm. , you know, um, just, most people won\'t touch \'em because it\'s too deep of tools.<br />But what, what are you really wanting? , you want a post that looks nice? Mm-hmm. like<br />attractive and the images help supplement the story. Mm-hmm. . Um, so I\'m just kind of think<br />there with our angle, like we\'re here and just kind of continuing to look at where, what\'s our<br />angle for all this? Until we, until we kind of go, okay.<br />I think this is it. [01:11:00] Like we knew the agency settings case, we got that, we got the block,<br />then we discovered this other thing. And um, I just keep trying to think through like, if we can get<br />enough of a pattern of people that have this, have a problem, we can, it\'ll really help us<br />crystallize the all this stuff.<br />Because you continually say, this is what I love working with awesome developers. We could do<br />that. Oh, by the way, I already did it. Here it is. And um, now we\'ve got enough ingredients I<br />think. We need to nail that use case where, right.</p>\n\n\n\n<p>Corey Maass: Yeah. We\'ve got, we\'ve got screwdrivers, we\'ve got a hammer, we\'ve, we\'ve now<br />got the tool belt.<br />What the hell are we gonna build? Literally<br />Cory Miller: any, yeah, exactly. We need a person. I wrote this down as you were talking. I was<br />like, we need a person, you know, the, the, [01:12:00] the user in client, whatever that is, and<br />whether they want it, you go, I want it to speed it up, what I\'m trying to do. Mm-hmm. Like if we<br />just looked at, because for the publishing conversation, you\'re like, what do you really need?<br />You need to be able to get your content. You\'re gonna do the text. That\'s your thing when you\'re<br />looking for the images. You want something that kind of fits a formula, like the WP beginner<br />formula medium, Moz, I looked at Moz, the bakery site. You\'re like, that\'s a, that\'s a formula, a<br />pattern for how to do content.<br />So, mm-hmm. , some of this comes into the finding, but like I go, like that duotone use case, I\'d<br />go, why not make every image of Duotone? It\'s just something different. You know what I mean?<br />Like it\'s something unique. So I might think through, and where I go back to my past is I like to<br />use templates for those things.<br />Mm-hmm. . [01:13:00] So I\'m trying to keep that in mind for our product or what we\'re doing is<br />the outcome they\'re trying to get is really something that, like you look on medium and you go,<br />some people don\'t. By and large, this just really works. It looks like a clean site. The images are<br />plusing, the value of the content, which I don\'t ever do.<br />Um, We talked about the four threes, like that seems the standard in a lot of these posts. So I\'m<br />really thinking for that user, the publisher user, um, and trying to build that case for the product<br />of what we\'re doing. Um, mm-hmm. , because like I, I think about the filters and I go, um, I told<br />you, we, we talked about my cartoon app,<br />I\'m like, now the problem when I write content is I don\'t have an image in mind. Mm. So finding<br />an image is pain the butt, like, let\'s put down, we have discovered a [01:14:00] problem. It is<br />finding, creating sourcing images that are good is a big problem. We haven\'t, we haven\'t, we\'ve<br />just identified it\'s just a problem.<br />We\'re over here. Um, but like I go, if we had, it\'s like Instagram. I can take, okay. I\'ve got a<br />camera in my pocket, carry with me all the time. My iPhone, it lets me take pictures. What did<br />Instagram did? Make them look a little better. Mm-hmm. , you know, just a little bit better. And<br />that\'s, that\'s something in this where I think that this is what pulls me back to the duo turn thing,<br />is it doesn\'t have to be due to, it\'s just the, a aspect of Sure.<br />You know, how do I look like it\'s not stock<br />Corey Maass: or Well, and that\'s, it\'s not, I mean, that\'s why AI is, is going running rampant, is<br />that people are like, I can now generate original art without paying for it, or paying nominally for<br />[01:15:00] it that nobody else has over and over and over again. Yeah. And that\'s why people<br />are over the moon.<br />You know, obviously there\'s no substitute for hiring a photographer to take pictures of products,<br />people, things like that. But if you need a. Abstract picture to just kind of add that compelling<br />human visual element. You\'re like, generate a picture of I\'m writing a post about coffee, so<br />generate a picture of a guy on a horse drinking a cup of coffee, you know, I don\'t have to spend<br />hours.<br />The, the image will come to me and it\'ll be unique and literally nobody else will have that.<br />Whereas, you know, the sites like stock, whatever, the stock photo, stock image sites historically<br />would charge you more. You could go buy an image, you could pay, you know, a thousand times<br />more for them to take it off the site to guarantee that nobody else ever used it again.<br />[01:16:00] Right. Um, that\'s not a, that\'s not gonna be an issue for much longer, you know?<br />Cory Miller: Um, it\'s not Will it? Okay. So something you said, I wrote down here, I was like,<br />nobody else has it. See. Like we, we are looking at the, I\'m gonna share my screen again. Do<br />you have a second to keep talking about<br />Corey Maass: this? Yeah, let\'s<br />Cory Miller: go 10 more minutes.<br />Um, okay, so Rolling Stone. I don\'t have a, the Desi design ability, I don\'t have the resources to<br />create this, this thing now with ai, is there that opportunity That\'s mm-hmm. . That\'s, that\'s really<br />interesting. But that\'s a sidebar. Yep. But like, you think about this now, for now, when I look at<br />this site, I go, this is thoughtful.</p>\n\n\n\n<p>Like this is unique. It\'s interesting. Like this, Ima I didn\'t even read what this is, but I [01:17:00]<br />was like, it it fits, you know, the, the case and cuz what you\'re trying to, I\'m sorry, I\'m just trying<br />to keep talking about the use case. Here is what you\'re trying to get is. , you know, back to<br />beginner, like, hey, nice sight, nice clean, clear side design.<br />They\'re trying to get you to the content. So they\'re doing a great job with SEO here with the<br />intro, restating what the headline\'s about. Then they use the image, which I think is clever. Like,<br />I don\'t like the featured image going outside of the post because it just fills out a whack for me.<br />But I\'m like, this is interesting.<br />They have given an image that probably, you know, uh, this has SEO in it, you know? Mm-hmm.<br />, I, I, I would guess, look at this. They\'ve restated, they\'ve restated again, the headline.<br />Corey Maass: Yeah. Well, and that\'s that also, that image is [01:18:00] gonna be, um, usable<br />for social. Right. If picture that as a, as a Facebook post it, it says their headline right int it.<br />Cory Miller: Okay, now, now, now you got got me something here. Okay. So may not go<br />anywhere, but the social share side, you\'ve done all of this work to create some kind of content<br />and that social share, like our stuff from post status. I hate it because it\'s not something we don\'t<br />have set up. Right? You know? But what you want is, I\'ve just done this cool post here that<br />hopefully is of interest to you and you\'re using the image in social to pull somebody into it.<br />It\'s kinda like this, almost like this. Well, or who is the<br />Freemius or are they, there [01:19:00] you go. Like if you look at this from a social Sears<br />standpoint, it\'s probably more interesting. Visually, you can kind of say, I see Covid and I see<br />some kinda like weird things around it. Mm-hmm. , right? But I go, it\'s something to do with<br />Covid, like from a social share. That\'s pretty good.<br />Like that\'s what you\'d want represented out on social is it\'s uh, it\'s the product packaging to say,<br />there\'s something in here I want and to go get it. We talked a little bit about that yo side, but<br />man, all of that social sharing stuff is just a mess. Like when I post my, I should do it here when I<br />post my, let me show you something.<br />If you have a second. If I go into to Slack and I\'m gonna, then I\'m gonna try to share this so you<br />can see it. Okay. Maybe this has [01:20:00] been fixed, but this thing right.<br />This, this little snippet that\'s now fixed. I don\'t, oh, it\'s cuz I clicked the social share stuff. But<br />see, like when you do<br />any day now<br />Okay. Anyway, it doesn\'t look good. Like it\'s, it\'s not, there we go. Yeah, sure. Okay. So<br />somehow this, this has attached to the homepage, right? But the idea that you want is, it<br />represents that f. Social share, whatever the image thing, whatever we titled it, feature name or<br />whatever it is, like that, whatever [01:21:00] this, I don\'t know if it\'s graphical or whatever it\'s<br />called.<br />But, um, what you\'re trying to do when you post that to social is show this effect of what, like, w<br />if you beginner on different things, designs, like here\'s something to show you see, show you<br />what this post is about. That\'s an interesting angle, but I, I don\'t know where it goes from here,<br />but like,<br />Corey Maass: so like here\'s, here\'s a tool that I\'ve been playing around with lately is, uh, so<br />Twitter has introduced cards the same way that Facebook a while ago introduced their open<br />graph. So you come here and you plug in post status and you say preview card. Card preview<br />has moved to tweet composer . Okay. Uh, but we can do tweet card preview banner bear.<br />So if I [01:22:00] plug in post status, they built their own preview. There you go. So like, that\'s<br />what it\'s gonna look like on social.<br />And these are the tools, you know, that are becoming more and more prevalent. And it\'s like, so<br />in Yeah, in Yost, using them as an example, and I think the other SEO plugins have this too, is<br />you, you know, you, you set your featured image and it will automatically suck in your featured<br />image as the OG image, but you can also set a different one.<br />And so you can go and, and so like, I actually wanted to do just what you said, um, previous and<br />go to their blog and pick a blog post. . And so like this is, uh, I\'m breaking their site, [01:23:00]<br />so they\'ve got an image in the background. This is text, you know, an H one or whatever. But,<br />um, you know, VVA is so phenomenal with social media and stuff like that, that I bet if I take this<br />U R L and I plug it in here and I hit enter that he\'s created.<br />Yeah. See, so he\'s created a custom image that is that same background image, but has his<br />little photo in it has a title, you know, and this is all one image that is been generated Canva,</p>\n\n\n\n<p>somewhere different from, you know, the, the title up here. Whereas this is all actually H T M L<br />element.<br />Yeah, food for thought and, and actually a conversation to take offline, um, is there are features<br />here that, um, [01:24:00] overlap with other stuff that I\'ve been working on. And so maybe it\'s,<br />maybe we wanna wrap it all in together, or maybe this is a different kind of like the, you know,<br />we keep talking around ai, but we\'re just not, that\'s not the product we\'re building this year, let\'s<br />say.<br />Unless it, it, it\'s the on unless we get to the point where it\'s the only thing we can build. Right.<br />Um, and so it\'s, maybe it\'s something like that or maybe it\'s the direction that we we\'re, we\'re<br />talking about, I dunno. Mm-hmm.<br />Cory Miller: Yeah. Now you got my mind rolling.<br />Corey Maass: Yep. Um, I gotta get. Okay. I do think that we need bringing, bringing you way<br />back down . Um, I mean, and I\'m not picking on you, both of us, like these are our<br />conversations, but [01:25:00] um, I think having you go through the plugin and just saying, look,<br />we need, this needs a little design or this needs some intro text, or what the heck is the word<br />preset mean?<br />Um, would take us pretty far. Cuz right now we do have a very developer friendly product. And<br />so me going in and just changing some labels and things, if that makes it 20% more usable,<br />which I think is true, um, then, then we\'re gonna be better off. The other thing is the Readme<br />needs updating now because we have a block.<br />We have featured images, we have. Media library. We have some basic settings. Okay. So let\'s,<br />you know, I, I, I think we\'re having, in a good way, we\'re having all of the different company<br />meetings in one . We\'re having the executive level discussions, [01:26:00] which are arguably<br />way more fun, but we also need to be having the, you know, low level mm-hmm.<br />dev, you know, dev conversations to make sure that we keep moving, moving what we\'ve got<br />forward, um, in a, in a practical sense. Mm-hmm. .<br />Cory Miller: Yep. Okay. Well I\'ve got down here, review the plugin. I\'ll do a video on that, walk<br />through several things and just note stuff.<br />Corey Maass: Hi puppy. Um, your background changed. How did I take this long to even<br />notice?<br />Cory Miller: Yeah, I know, right? I got the fancy new sleeper.<br />Corey Maass: So it\'s so respectable now. Don\'t go that far<br />Cory Miller: yet. . I do. I think, I think, I\'ll tell you what, I need a big poster right over there. Yeah.<br />Um, yeah. Looking respectable, man. What can you say?<br />Corey Maass: I\'m proud of you, buddy. Thank you, . [01:27:00]<br />Cory Miller: Um, and then I\'ve got the read me file too.<br />Um, to go back to Yeah. And I<br />Corey Maass: think that for me, like we now have Yeah. Read, read Me as you, um, or us like<br />we, we did it together last time. We can do it again. Um, I, I guess what I\'m envisioning right is<br />we\'re, we\'re pretty close to feature, complete, um, Or something that\'s actually usable. Like I\'m,<br />I\'m on the verge of actually installing this on my client\'s websites.<br />I\'ve got it on some of my own cuz I\'m willing to muddle through the things that were confusing<br />or, um, you know, or, or not clear or, um, that\'s redundant, um, or not what I needed. Whereas<br />now I\'m like, okay, my clients have to upload a 16.9 featured image every day and currently they<br />have to go use a separate tool.<br />I\'m ready to install this [01:28:00] plugin cuz it actually does what I need. Um, and so I wanna<br />make sure that we are. Product complete. So Dev builds the features and then we as a team<br />have complete the product. And then frankly, we can sit on it for a long time and keep having<br />more of these conversations or ex, you know, start from there.<br />It\'s like we\'ve built the dock out into the lake and so then we can start dipping our toe in more,<br />but mm-hmm. , we\'re, you know, we\'re out there, we\'re in the world. Um, and, and people, other<br />people can use the dock too. I feel like right now we\'ve got the, uh, the, the janky, uh, we\'re, it\'s<br />a, it\'s a wooden pallet floating on empty beer cans.<br />And so we wouldn\'t allow our loved ones to go use it to get out into the lake. Yes, I\'m running<br />with this metaphor. You know, we\'re close to having actually swimming built a reasonable dock.<br />Um, you know, that\'s safe enough for our, for children to [01:29:00] use that kind of thing.<br />Cory Miller: You\'re swimming with that metaphor.</p>\n\n\n\n<p>Sta. All right. Thanks man. Um, okay. Yeah, I\'ve got my team marching items. Thanks for<br />keeping us grounded. Let me, uh, float in the atmosphere a little bit. I, it really is for specific<br />reasons cause I know when we go Got it. You know, like right there and, and some of that\'s<br />validation, but just a little bit more clarity on how, who is gonna value this and is it the right thing<br />for what they need.<br />Um, but Okay. Thanks dude. Thanks for jumping on today. All right.</p>\n\n\n\n<h2><br /></h2>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 06 Apr 2023 13:22:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Cory Miller\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: ACF 6.1 Adds Support for Registering Custom Post Types and Taxonomies\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143319\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wptavern.com/acf-6-1-adds-support-for-registering-custom-post-types-and-taxonomies\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3772:\"<p>ACF (Advanced Custom Fields) <a href=\"https://www.advancedcustomfields.com/blog/acf-6-1-0-released/\">version 6.1</a> was released this week with support for creating Custom Post Types and Taxonomies. This is a long-awaited feature that users have been asking for since the earliest days of the plugin when it was still developed by its original author, Elliot Condon. </p>\n\n\n\n<p>When Delicious Brains acquired the plugin, the ACF community reiterated this feature request. WP Engine kept it on the roadmap when they <a href=\"https://wptavern.com/wp-engine-acquires-5-plugins-from-delicious-brains\">acquired ACF in June 2022</a> and has finally been able to deliver. Registering post types and taxonomies is now available through a simple interface that works in a similar way to creating field groups and fields.</p>\n\n\n\n<img />\n\n\n\n<p>After registering the CPT, users can then add an existing or new field group for it or create a taxonomy, and move on from there. The advantage is that users don&#8217;t have to break their workflows and use a different plugin for this functionality. For those managing client websites, it is one fewer plugin required. </p>\n\n\n\n<p>&#8220;We know there are a large number of ACF users registering custom post types (CPTs) and creating custom fields for them,&#8221; WP Engine Senior Product Manager Iain Poulson said. &#8220;But they have to register the CPTs either manually with code or using another plugin. The overarching workflow of modeling the data needed for a site build is fragmented between different plugins, UIs, and user experiences. We wanted to fix that!&#8221;</p>\n\n\n\n<p>The ACF development team has also created a <a href=\"https://www.advancedcustomfields.com/resources/post-types-and-taxonomies/#disabling-cpts-taxonomies\">dedicated import tool</a> for users who want to migrate post types and taxonomies from the <a href=\"https://wordpress.org/plugins/custom-post-type-ui/\">Custom Post Type UI</a> (CPTUI) plugin to ACF in order to manage them all from one plugin.  ACF has also built in the ability to <a href=\"https://www.advancedcustomfields.com/resources/acf-settings-enable_post_types/\">disable post types and taxonomies from the plugin admin</a> in case users do not require this feature in the update.</p>\n\n\n\n<p>ACF reports more than 4.5 million users, so it will be interesting to see how having this built in will impact the CPTUI user base, which is active on more than a million websites. Some users simply need custom post types but won&#8217;t require all of ACF&#8217;s capabilities, but there is certainly a large overlap between the two plugins.</p>\n\n\n\n<p>After expanding well beyond the creation of custom fields with this and previous updates, Poulson said they will be referring to the plugin as &#8220;ACF&#8221; more going forward. The plugin&#8217;s admin sidebar menu has been updated from &#8220;Custom Fields&#8221; to ACF.</p>\n\n\n\n<p>Version 6.1 also includes the following highlights and important changes:</p>\n\n\n\n<ul>\n<li>New &#8216;browse fields&#8217; button opens a modal to search and showcase all field types</li>\n\n\n\n<li>Post Object, Page Link and Relationship fields now support filtering by post status</li>\n\n\n\n<li> Full compatibility with PHP versions 8.1 and 8.2</li>\n\n\n\n<li>New option to filter field settings tabs so other plugins can add custom tabs and arrange their fields</li>\n\n\n\n<li>Security fix backported to ACF 5.12.5 for a security issue where ACF might unserialize maliciously manipulated data which instantiates a class</li>\n</ul>\n\n\n\n<p>All of these new features are available in both the free version and ACF Pro. Check out the <a href=\"https://www.advancedcustomfields.com/changelog/\">changelog</a> for the full rundown of everything included in version 6.1.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Apr 2023 21:21:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Post Status: Build a Block Theme • Theme Performance Improvements * Interactivity API • Why Jazz?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=148717\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://poststatus.com/build-a-block-theme-theme-performance-improvements-interactivity-api-why-jazz/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:19144:\"<h2 id=\"h-this-week-at-wordpress-org-april-3-2023\">This Week at WordPress.org (April 3, 2023)</h2>\n\n\n<div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">Matt shares why WordPress releases are named after jazz musicians. The FSE block theme explores functionality gaps and gathers feedback on the Site Editor experience. WordPress 6.2 improves load times and server-side performance for block and classic themes. The Interactivity API proposal standardizes frontend interactivity for Gutenberg blocks. </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-kadence-infobox kt-info-box_94d1bd-77\"><div class=\"kt-blocks-info-box-link-wrap kt-blocks-info-box-media-align-left kt-info-halign-left\"><div class=\"kt-blocks-info-box-media-container\"><div class=\"kt-blocks-info-box-media kt-info-media-animate-none\"><div class=\"kadence-info-box-icon-container kt-info-icon-animate-none\"><div class=\"kadence-info-box-icon-inner-container\"><span class=\"kb-svg-icon-wrap kb-svg-icon-fas_paint-brush kt-info-svg-icon\"></span></div></div></div></div><div class=\"kt-infobox-textcontent\"><h2 class=\"kt-blocks-info-box-title\">Build a Theme, Time to First Byte, Jazz, and Interactivity API</h2><p class=\"kt-blocks-info-box-text\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f9b8-1f3fb-200d-2640-fe0f.png\" alt=\"🦸🏻‍♀️\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2023/04/07/preparing-for-the-next-women-nonbinary-release-squad/\">Preparing for the Next Women & Nonbinary Release Squad</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f477-1f3fe.png\" alt=\"👷🏾\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/test/2023/03/29/fse-program-exploration-build-a-block-theme/\">FSE Program Exploration: Build a block theme</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f680.png\" alt=\"🚀\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2023/04/05/wordpress-6-2-performance-improvements-for-all-themes/\">WordPress 6.2 Performance improvements for all themes</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3b7.png\" alt=\"🎷\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/design/2023/03/30/why-jazz/\">Why Jazz?</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f7e6.png\" alt=\"🟦\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2023/03/30/proposal-the-interactivity-api-a-better-developer-experience-in-building-interactive-blocks/\">Proposal: The Interactivity API – A better developer experience in building interactive blocks</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f469-1f3fb-200d-1f4bb.png\" alt=\"👩🏻‍💻\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/cli/2023/04/05/wp-cli-v2-8-0-release-date/\">WP-CLI v2.8.0 release date</a></p></div></div></div>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_b57166-6e\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<h2 id=\"h-news\"><a href=\"https://wordpress.org/news\">News</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2023/04/the-month-in-wordpress-march-2023/\">The Month in WordPress – March 2023</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_8f6276-eb\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<div class=\"is-layout-flex wp-container-13 wp-block-columns\">\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-accessibility\"><a href=\"https://make.wordpress.org/accessibility\">Accessibility</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/accessibility/2023/04/05/accessibility-team-meeting-agenda-april-7-2023/\">Accessibility Team Meeting Agenda: April 7, 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-central\"><a href=\"https://wordcamp.central.org\">Central</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://central.wordcamp.org/news/2023/03/wordcamp-buffalo-2023/\">WordCamp Buffalo 2023</a></li>\n\n\n\n<li><a href=\"https://central.wordcamp.org/news/2023/03/wordcamp-entebbe-2023-an-amazing-recap/\">WordCamp Entebbe 2023: An Amazing Recap</a></li>\n</ul>\n\n\n\n<h2 id=\"h-community\"><a href=\"https://make.wordpress.org/community\">Community</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/community/2023/04/07/its-time-to-plan-your-wp20-anniversary-celebration/\">It’s Time to Plan Your WP20 Anniversary Celebration!!</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2023/04/06/personalised-coupon-codes-for-wordcamps/\">Personalised Coupon Codes for WordCamps</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2023/04/03/community-team-training-7-community-team-roles-overview-discussion/\">Community Team Training #7: Community Team Roles Overview & Discussion</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/community/2023/04/01/wordcamp-mentors-april-check-in/\">WordCamp Mentors’ April check-in!</a></li>\n</ul>\n\n\n\n<h2 id=\"h-core\"><a href=\"https://make.wordpress.org/core\">Core</a> </h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/04/07/preparing-for-the-next-women-nonbinary-release-squad/\">Preparing for the Next Women & Nonbinary Release Squad</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/04/05/whats-new-in-gutenberg-15-5-05-april/\">What’s new in Gutenberg 15.5? (05 April)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/04/05/wordpress-6-2-performance-improvements-for-all-themes/\">WordPress 6.2 Performance improvements for all themes</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/04/04/a-week-in-core-april-3-2023/\">Two Weeks in Core – April 3, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/04/03/preferred-languages-help-test-the-latest-version/\">Preferred Languages: Help test the latest version</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/30/proposal-the-interactivity-api-a-better-developer-experience-in-building-interactive-blocks/\">Proposal: The Interactivity API – A better developer experience in building interactive blocks</a></li>\n</ul>\n\n\n\n<h3 id=\"h-meetings\">Meetings</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/04/04/editor-chat-agenda-april-5th-2023/\">Editor Chat Agenda: April 5th, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/04/06/dev-chat-summary-april-5-2023/\">Dev Chat Summary, April 5, 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-design\"><a href=\"https://make.wordpress.org/design\">Design</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/design/2023/03/30/why-jazz/\">Why Jazz?</a></li>\n</ul>\n\n\n\n<h2 id=\"h-docs\"><a href=\"https://make.wordpress.org/docs\">Docs</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/docs/2023/03/26/agenda-for-docs-team-bi-weekly-meeting-april-4-2023/\">Agenda for Docs Team bi-weekly meeting April 4, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/04/03/documentation-team-update-april-3-2023/\">Documentation Team Update – April 3, 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-hosting\"><a href=\"https://make.wordpress.org/hosting\">Hosting</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/hosting/2023/04/05/hosting-team-meeting-agenda-2023-04-05/\">Hosting Team meeting agenda 2023-04-05</a></li>\n</ul>\n\n\n\n<h2 id=\"h-marketing\"><a href=\"https://make.wordpress.org/marketing\">Marketing</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/marketing/2023/04/04/notes-global-marketing-team-meeting-28-march-2023/\">Notes: Global Marketing Team meeting, 28 March 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-meta\"><a href=\"https://make.wordpress.org/meta\">Meta</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/meta/2023/04/06/matrix-chat-summary-april-6-2023/\">Matrix chat Summary, April 6, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/meta/2023/04/04/agenda-biweekly-matrix-chat-thu-april-6-2023-10am-utc/\">Agenda: Biweekly Matrix Chat – Thu, April 6, 2023 (10AM UTC)</a></li>\n</ul>\n\n\n\n<h2 id=\"h-mobile\"><a href=\"https://make.wordpress.org/mobile\">Mobile</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/updates/2023/04/07/mobile-team-update-april-6th-2/\">Mobile Team Update – April 6th</a></li>\n</ul>\n\n\n\n<h2 id=\"h-openverse\"><a href=\"https://make.wordpress.org/openverse\">Openverse</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/openverse/2023/04/05/community-meeting-recap-2023-04-04/\">Community Meeting Recap (2023-04-04)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/openverse/2023/04/03/last-week-openverse-2023-03-27-2023-04-03/\">A week in Openverse: 2023-03-27 – 2023-04-03</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/openverse/2023/03/30/community-meeting-recap-28-march-2023/\">Community Meeting Recap (28 March 2023)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/openverse/2023/03/29/openverse-monthly-priorities-meeting-2023-04-05/\">Openverse Monthly Priorities Meeting 2023-04-05</a></li>\n</ul>\n\n\n\n<h2 id=\"h-performance\"><a href=\"https://make.wordpress.org/performance/\">Performance</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/04/05/performance-chat-summary-04-april-2023/\">Performance Chat Summary: 4 April 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-plugins\"><a href=\"https://make.wordpress.org/plugins\">Plugins</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/plugins/2023/03/21/use-of-code-generators-must-remain-gpl-compatible/\">Use of Code Generators Must Remain GPL Compatible</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/plugins/2023/03/10/advance-notice-of-retirement/\">Advance Notice of Retirement</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/04/04/plugin-review-team-3-april-2023/\">Plugin Review Team – 3 April 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-polyglots\"><a href=\"https://make.wordpress.org/polyglots\">Polyglots</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/polyglots/2023/04/05/agenda-weekly-polyglots-chat-april-05-2023-0700-utc/\">Agenda: Weekly Polyglots Chat – April 05, 2023 (07:00 UTC)</a></li>\n</ul>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-project\">Project</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/project/2023/02/06/proposal-creating-a-wordpress-contributor-mentorship-program/\">Proposal: Creating a WordPress Contributor Mentorship Program</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/project/2023/01/27/discussion-ending-the-eternal-september/\">Discussion: Ending the Eternal September</a></li>\n</ul>\n\n\n\n<h2 id=\"h-support\"><a href=\"https://make.wordpress.org/support\">Support</a></h2>\n\n\n\n<ul>\n<li> <a href=\"https://make.wordpress.org/support/2023/03/support-ticket-triage-session-april-5th-2023-at-1600-utc/\">Support ticket triage session – April 5th 2023 at 16:00 UTC&nbsp;</a></li>\n</ul>\n\n\n\n<h2 id=\"h-test\"><a href=\"https://make.wordpress.org/test\">Test</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/test/2023/04/04/hallway-hangout-lets-chat-about-moving-to-the-site-editor/\">Hallway Hangout: Let’s chat about Moving to the Site Editor</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2023/03/29/fse-program-exploration-build-a-block-theme/\">FSE Program Exploration: Build a block theme</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/04/03/test-team-update-3-april-2023/\">Test Team Update: 3 April 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-theme\">Theme</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/themes/2023/04/04/theme-handbook-overhaul-proposal/\">Theme Handbook Overhaul Proposal</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/04/04/themes-team-update-april-04-2023/\">Themes team update April 04, 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-training\"><a href=\"https://make.wordpress.org/training\">Training</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/training/2023/04/07/next-steps-for-the-faculty-program/\">Next Steps for the Faculty Program</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/learn-wordpress-april-2023-newsletter/\">Learn WordPress April 2023 Newsletter</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2023/04/05/proposal-creating-learning-pathways-for-learn-wordpress/\">Proposal: Creating Learning Pathways for Learn WordPress</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2023/03/29/introduction-to-wordpress-development-syllabus/\">Introduction to WordPress Development syllabus</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2023/04/03/meeting-agenda-for-april-04-2023/\">Meeting agenda for April 04, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/04/01/whats-new-on-learn-wordpress-in-march-2023/\">What’s new on Learn WordPress in March 2023</a></li>\n</ul>\n\n\n\n<h3 id=\"h-lesson-plans\"><a href=\"https://learn.wordpress.org/lesson-plans\">Lesson Plans</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/lesson-plan/ar-dashboard-overview/\">نبذة عن لوحة البيانات </a></li>\n</ul>\n\n\n\n<h3 id=\"h-tutorials\"><a href=\"https://learn.wordpress.org/tutorials\">Tutorials</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorial/using-block-patterns/\">Using Block Patterns</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/add-media-and-openverse-images-to-your-content-directly-from-the-inserter/\">Add media and Openverse images to your content directly from the Inserter</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/wordpress-rest-api-custom-routes-endpoints/\">WordPress REST API – custom routes & endpoints</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/intro-to-the-site-editor-and-template-editor/\">Intro to the Site Editor and Template Editor</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/how-to-use-the-wordpress-stylebook-with-your-block-theme/\">How to use the WordPress Stylebook with your block theme</a></li>\n</ul>\n\n\n\n<h3 id=\"h-online-workshops\">Online Workshops</h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/?meeting=how-to-validate-content-feedback-for-the-wordpress-training-team\">How to validate content feedback for the WordPress Training Team</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=33114\">WordPress 6.2 のアップデート内容を見てみよう！</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=wordpress-6-2-%E3%81%AE%E3%82%A2%E3%83%83%E3%83%97%E3%83%87%E3%83%BC%E3%83%88%E5%86%85%E5%AE%B9%E3%82%92%E8%A6%8B%E3%81%A6%E3%81%BF%E3%82%88%E3%81%86%EF%BC%81\">WordPress 6.2 のアップデート内容を見てみよう！</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=updating-a-blogs-design-informal-live-stream-part-4\">Updating a blog’s design (Informal live stream) – Part 4</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=the-wordpress-request-lifecycle-2\">WP dev livestream: WordPress request lifecycle</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=the-wordpress-request-lifecycle\">The WordPress request lifecycle</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=a-guide-to-open-source-and-wordpress-timezone-2\">A Guide to Open Source and WordPress (Timezone 2)</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=a-guide-to-open-source-and-wordpress\">A Guide to Open Source and WordPress</a></li>\n</ul>\n\n\n\n<h3 id=\"h-courses\"><a href=\"https://learn.wordpress.org/courses\">Courses</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/course/converting-a-shortcode-to-a-block/\">Converting a Shortcode to a Block</a></li>\n</ul>\n\n\n\n<h2 id=\"h-wp-cli\">WP-CLI</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/cli/2023/04/05/wp-cli-v2-8-0-release-date/\">WP-CLI v2.8.0 release date</a></li>\n</ul>\n\n\n\n<h2 id=\"h-wptv\">WPTV</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.tv/category/year/2022/\">Latest WordPress TV videos</a></li>\n</ul>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 id=\"h-related-news\">Related News:</h2>\n\n\n\n<ul>\n<li><a href=\"https://www.php.net/archive/2023.php#2023-02-14-2\">PHP 8.2.4 Released!</a></li>\n\n\n\n<li><a href=\"https://www.php.net/archive/2023.php#2023-03-16-1\">PHP 8.1.17 Released!</a></li>\n\n\n\n<li><a href=\"https://262.ecma-international.org/13.0/\">TC39</a></li>\n\n\n\n<li><a href=\"https://github.com/composer/composer/releases/tag/2.5.5\">Composer 2.5.5</a></li>\n</ul>\n\n\n\n<p class=\"has-theme-palette-7-background-color has-background\">Thanks for reading our WP dot .org roundup! Each week we are highlighting the news and discussions coming from the good folks making WordPress possible. If you or your company create products or services that use WordPress, you need to be engaged with them and their work. Be sure to share this resource with your product and project managers. <br /><br /><strong>Are you interested in giving back and contributing your time and skills to WordPress.org?</strong> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/support/article/contributing-to-wordpress/\">Start Here ›</a><br /><br /><strong>Get our weekly WordPress community news digest</strong> — Post Status\' <a href=\"https://poststatus.com/news/week-in-review/\">Week in Review</a> — covering the WP/Woo news plus significant writing and podcasts. It\'s also available in <a href=\"https://poststatus.com/newsletter\">our newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f48c.png\" alt=\"💌\" class=\"wp-smiley\" /></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-background\"><a href=\"https://poststatus.com/\"><img src=\"https://cdn.poststatus.com/wp-content/uploads/2021/09/vertical-post-status-logo-250.png\" alt=\"Post Status\" class=\"wp-image-85823 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p class=\"has-text-align-left has-normal-font-size\" id=\"h-get-ready-for-remote-work\">You — and <a href=\"https://poststatus.com/#Agency\">your whole team</a> can <a href=\"https://poststatus.com/#choose-membership\">Join Post Status</a> too!</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job — or your next hire.</strong> Read the <strong>Post Status</strong> <a href=\"https://poststatus.com/newsletter/\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to <a href=\"https://poststatus.com/podcasts/\">podcasts</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/post_status/\">@Post_Status</a> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> and <a href=\"https://www.linkedin.com/company/post-status-llc/\">LinkedIn</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4bc.png\" alt=\"💼\" class=\"wp-smiley\" /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Apr 2023 19:30:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: #70 – Steve Persch and Brian Perry on How Hosting Is Changing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=143278\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://wptavern.com/podcast/70-steve-persch-and-brian-perry-on-how-hosting-is-changing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:53090:\"Transcription<div>\n<p>[00:00:00] Nathan Wrigley: Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, the past and future of website hosting.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the show, I&#8217;m keen to hear from you and hopefully get you all your idea on the podcast as soon as possible. Head over to WPTavern.com forward slash contact forward slash jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Steve Persch and Brian Perry. They&#8217;re both employed at Pantheon, an enterprise website operations platform. And they&#8217;re here to talk about the evolution of website hosting.</p>\n\n\n\n<p>Back when the internet started, hosting was a fairly straightforward enterprise. You created HTML files and uploaded them to a server. That was it. An HTML file was a page.</p>\n\n\n\n<p>Server-side technology such as PHP came along, and the picture became a little more complex. Web pages needed to be constructed on the fly. Databases were thrown into the mix, and the complexity increased. Add in the different languages that you could write your code in, and the server configurations. The CMS that you choose also plays into this mix. Now we&#8217;ve got CDNs, headless, React, Gatsby, Node.js and much more. Is it even possible for the non-technical to have any understanding of where their website is?</p>\n\n\n\n<p>Steve and Brian talk about how they got into the hosting space, and what&#8217;s changed over the years. We address what Pantheon is doing with WordPress and Drupal.</p>\n\n\n\n<p>We discuss how headless can be difficult for content teams, given that there&#8217;s a disconnect with hitting the publish button and that content going live on the site.</p>\n\n\n\n<p>What&#8217;s certain is that there&#8217;s no end in sight in terms of the rate of innovation in the website hosting space. What&#8217;s popular today might not be several years from now. And so it&#8217;s a timely discussion of what Steve and Brian see as the best bets for the future.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading over to WPTavern.com forward slash podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so, without further delay I bring you Steve Persch and Brian Perry.</p>\n\n\n\n<p>I am joined on the podcast today by Steve Persch and Brian Perry. Hello.</p>\n\n\n\n<p>[00:03:37] Steve Persch: Hello, Steve Persh here. Happy to be here.</p>\n\n\n\n<p>[00:03:39] Brian Perry: Yeah, Brian Perry also really excited to chat.</p>\n\n\n\n<p>[00:03:42] Nathan Wrigley: Well, thank you for joining me on the podcast today. We&#8217;re going to talk about something, and I seem to have said this sentence much more often recently, about something that that really is a mystery to me. You are going to school me in all sorts of ways about something that I&#8217;m really not that familiar with, and that is all about how files get served up. Where are our website files being kept? Where are the computers? Where&#8217;s the infrastructure, and how much more complicated it has become over the last 10 or 15 years.</p>\n\n\n\n<p>Before we begin that, I think we&#8217;ll take you in order. I&#8217;ll go Steve first, if that&#8217;s all right? I&#8217;m wondering if both of you can give us a little bit of orientation about who you are, who you work for. Your history with technology and possibly WordPress in particular. So yeah, we&#8217;ll launch that with Steve.</p>\n\n\n\n<p>[00:04:28] Steve Persch: Sure, so Steve Persch here in Minneapolis, Minnesota. I&#8217;m the director of technical marketing at Pantheon. We&#8217;re a website operations platform for Drupal, WordPress and now front end frameworks, which is, much of what, thinking about that question of what computer makes the website.</p>\n\n\n\n<p>I&#8217;ve been in the web space for a while now. I first started making websites, first semi-professionally, and then professionally in the early days of WordPress. I built some of my first professional websites in WordPress 2, back in 2006. Then for some of the sites that I wanted to make, that took me into the Drupal world. And now in Pantheon, we play in both of those worlds, in the lamp stack, and as Pantheon is aiming itself at running extraordinary websites, as we like to say, the best possible websites. We see that that requires us to step more fully into the JavaScript centric front end framework ecosystem.</p>\n\n\n\n<p>[00:05:23] Nathan Wrigley: Well thank you Steve. That was great. We&#8217;ll hand it over to Brian to do a similar job.</p>\n\n\n\n<p>[00:05:28] Brian Perry: I&#8217;m Brian Perry. I&#8217;m a staff software engineer at Pantheon. What I&#8217;m focusing on at Pantheon is leading a project we&#8217;re calling Decoupled Kit, which is a set of open source utilities and projects that aim to make this decoupled architecture or running headless WordPress and Drupal sites easier.</p>\n\n\n\n<p>What brought me to that is, prior to Pantheon, a lot of my background was in the agency space. Specifically focusing on front end and front end develop. More and more I found myself interested in what was going on in the JavaScript ecosystem, and working on projects where using a CMS like WordPress or Drupal to feed data into the front end. But also found that there were a lot of solutions that were being invented over and over to solve those problems. So being able to focus on trying to make that easier for folks has been really exciting.</p>\n\n\n\n<p>[00:06:24] Nathan Wrigley: Thank you very much indeed. So you&#8217;re both coming from Pantheon and you mentioned there that you have a very keen focus on, well you mentioned two CMSs, which is curious actually. Obviously this is a WordPress podcast, but we&#8217;re not here to destroy the opposition if you like. But Drupal and WordPress, I think I&#8217;m right in saying that you don&#8217;t find too many hosting companies that lay claim to both of those. Is that a relic of the past of Pantheon, how it all began back in the day?</p>\n\n\n\n<p>[00:06:51] Steve Persch: It&#8217;s an intentional choice. We think that supporting both of those systems gives us more flexibility. It ends up fitting us better to our core audience. Pantheon started with digital agencies. Our four founders came from running web development agencies, that&#8217;s the background.</p>\n\n\n\n<p>And for a lot of the agencies and in the ecosystems we came from, we knew that it was normal for those sorts of agencies to have a preference between Drupal, WordPress or, you know, Ruby and Rails or any other of system. But often, the given client you&#8217;re working for might have both, for any number of historical reasons.</p>\n\n\n\n<p>So yes, the initiation of that was, uh, somewhat happenstance. Our customers figuring out like, this platform was first built for Drupal, I bet we could make it run WordPress. And then Pantheon as a company realizing like, yes, we should support WordPress. That&#8217;s something that I think was a bit inevitable.</p>\n\n\n\n<p>It&#8217;s good for us technologically and business wise to support more than one. And at the same time it&#8217;s good for us to not open it up as wide as, well, anything PHP. Some of our competitors take the other extreme of, hey, if you can make it run then you&#8217;re good. We think of ourselves as, we prefer the term, a website operations platform.</p>\n\n\n\n<p>And hosting is a feature of that. But don&#8217;t want to have a relationship with our customers that&#8217;s as simple as like, well, yeah, if you can make it run, that&#8217;s good. We&#8217;re only here to provide the server. We see ourselves as facilitating more growth of value of the websites, not just the question of can this run at all?</p>\n\n\n\n<p>[00:08:21] Brian Perry: Yeah, I think that, that same sort of concept also extends to the front end and JavaScript frameworks in that, there&#8217;s definitely a lot of excitement around Next.js. But we are looking to build a platform where other future frameworks can run on it. But also, yeah, we&#8217;re not necessarily trying to be like, run whatever crazy JavaScript project you want. We want to have some guardrails there.</p>\n\n\n\n<p>[00:08:44] Nathan Wrigley: I remember back in the day prior to stumbling across WordPress, which I did quite a long time ago now, I used to use Drupal exclusively actually, and I have a, have a memory of Pantheon cropping up, and at the time, really hadn&#8217;t heard of a hosting company that was binding itself to a CMS in that way.</p>\n\n\n\n<p>It was curious to me that Pantheon had laid claim to, okay, if you&#8217;re using a CMS, we&#8217;re somebody that you should look at. Prior to that, it was always, we&#8217;re just a hosting company. You know, we&#8217;ll host anything.</p>\n\n\n\n<p>[00:09:16] Steve Persch: I often go back to the first blog post that was done by, one of our co-founders, our four co-founders, when Pantheon started. I think the title of the blog post was Putting the Humans at the Top of the Stack. And it laid out, or at the time, but a decade plus ago, two common ways of running websites.</p>\n\n\n\n<p>One was just that hosting mode of a host providing some baseline technological capabilities, but the team buying the hosting is responsible for assembling the parts and making it all work. And yes, that&#8217;s an appropriate choice for some teams, but it&#8217;s not a great recipe for success for what we see as the broad plurality of professional web teams.</p>\n\n\n\n<p>The other extreme at the time, and it&#8217;s still present there, is the Squarespace, Wix, very templatized, cookie cutter way of building a site. Which again, is totally appropriate for certain people who need websites. But Pantheon, a decade ago and still now, wants to find a middle path that empowers the majority, or a plurality of professional web teams to make the best possible websites.</p>\n\n\n\n<p>And we see that, fulfilling that mission does require us to build CMS specific capabilities, and now front end framework specific capabilities, while not putting ourselves as narrow as only WordPress, or only Next.js.</p>\n\n\n\n<p>[00:10:35] Nathan Wrigley: Okay. That&#8217;s really interesting. Thank you for that. The subject at hand is really about how hosting has changed over the last decade, two decades, what have you. And it might be of interest to the listeners to the podcast if they pause for a moment and go and watch one of the videos. It was created by Steve, I believe, created the video.</p>\n\n\n\n<p>It&#8217;s called Decoupled Architectures, What Computer Assembles the website, and it&#8217;s a great watch. It&#8217;s. 10 minutes long, and it&#8217;ll give you a real insight into the things that we&#8217;re going to talk about. What Steve brings to bear is lots of papers and drawing, which we can&#8217;t do on this podcast, but they really do help solidify the problem. He&#8217;s got lots of nice diagrams of how things are working.</p>\n\n\n\n<p>But just to rewind the clock, let&#8217;s go back 20 years or so ago. It seems like an age almost at the birth of the internet almost. But if you had a website, whatever CMS it was. You would have to host it somewhere, and you would probably select a host and upload the files.</p>\n\n\n\n<p>They were probably at that point, just static HTML. I imagine CSS probably hadn&#8217;t even emerged at that point. And you just uploaded them. And you had a great idea of where that computer was. You had a slice, a share of that computer. It was yours. You could point to where it was on the map and so on and so forth.</p>\n\n\n\n<p>And that&#8217;s not how it&#8217;s done now. Or at least that&#8217;s not how everybody&#8217;s doing it. So I want us to run through a history of how that&#8217;s changed over time. Going right back from the beginnings when the internet began and you could build your own websites. Right up to how it&#8217;s done now. We can really be ponderous about this, we&#8217;ve got a whole episode ahead of us. So, whoever wants to begin that journey, you can flip flop and change, do tag team if you like, but that&#8217;s what I want to do. The history of how hosting has changed.</p>\n\n\n\n<p>[00:12:19] Steve Persch: Brian, if you don&#8217;t mind, I&#8217;ll start from flat HTML files, and enter us into the era of PHP. And then you can talk about CMSs. So one of my first experiences getting paid to maintain a website, a thing, I wasn&#8217;t even pondering as a career path. I was a theater major, and then I found myself working in the marketing department of a theater company. And they had a flat HTML website that did the job, was good enough for the early two thousands. A few hundred pages of flat HTML files, mostly it&#8217;s like if you want to buy tickets, call this phone number. Here&#8217;s the production that we&#8217;re producing, here&#8217;s the calendar.</p>\n\n\n\n<p>And one of the most annoying tasks, once I became the person getting paid to update the website was, add this menu link in the sidebar. And that sidebar appears on like a dozen pages. Okay, so I open up a dozen flat HTML files and then I notice, oh, this sub sidebar menu for the education department of the theater company. This menu isn&#8217;t even consistent on these 12 HTML files, because over however many years, copy paste errors happened. And that&#8217;s annoying, and creates a bad, confusing experience.</p>\n\n\n\n<p>But, I know enough to realize that I could put in some PHP tags, and save myself some time. That&#8217;s how I first started transitioning that question of, what computer assembles the website? How does this website really come together? The first answer of, it&#8217;s all flat HTML that I&#8217;ve got to hand code on my own machine to, what if I put a little bit more, just a little bit more intelligence in the server and told it to like PHP include education sub sidebar dot PHP.</p>\n\n\n\n<p>Then I don&#8217;t have to worry about copy pasting menu updates across 12 HTML files. That started to transition the question of what computer assembles the website, but the content management systems that were cropping up at the same time, WordPress, Drupal, others, provided a much more robust answer. But I can let Brian talk about that.</p>\n\n\n\n<p>[00:14:25] Nathan Wrigley: I&#8217;ll just interject at that point because the pain that you&#8217;ve just described was my pain. I remember exactly that. I mean, it wasn&#8217;t the 200 page website, but I remember the exact same thing. And then stumbling across the, oh, you can include something with PHP can you? That will take that whole burden, maybe the header or the footer or wherever it may be on the website.</p>\n\n\n\n<p>And I do remember finding that really quite startling, and thinking good grief. I&#8217;ve just saved myself literally hours of time, and it was fabulous. It was really, really an excellent moment. So, okay, so.</p>\n\n\n\n<p>[00:15:00] Brian Perry: It&#8217;s also a, it&#8217;s a gateway to the danger of creating your own CMS, I don&#8217;t know if anybody on this has done that?</p>\n\n\n\n<p>[00:15:07] Nathan Wrigley: Yes, that&#8217;s exactly what I did. We&#8217;ve laid the pathway then to, we&#8217;ve got PHP in there somehow now, and so now we&#8217;re moving towards CMSs. So I guess we&#8217;ll hand it to Brian to tell us what came next.</p>\n\n\n\n<p>[00:15:19] Brian Perry: Yeah, and Steve, feel free to jump in as the overall tour guide with any color commentary. But yeah so, many of us have rolled our own CMSs. But then projects like WordPress and Drupal come along and provide a consistent user experience to being able to manage your data. Have an associated front end.</p>\n\n\n\n<p>It&#8217;s the great situation where there&#8217;s a community of folks making that project better, rather than the CMS we built on our own. That is a situation where you have your CMS, that handles that data. But it is essentially a single lamp stack. And your CMS is responsible for assembling your website. So you can edit things in the admin. But at the end of the day, WordPress, for example, is what puts everything together, using its templates and providing the end page that the user interacts with.</p>\n\n\n\n<p>[00:16:15] Steve Persch: Another way I think about this progression is through the lens of the three really broad groups of people who make a website like this possible. Especially in those early PHP days, to make something like this work there&#8217;s someone probably with an IT sort of job title who&#8217;s setting up the server. There&#8217;s someone with like a web developer type of job title who&#8217;s making the Drupal or WordPress part work, and they may be working with designers as well. And then there are people managing the content.</p>\n\n\n\n<p>So in addition to what computer assembles the website, a more specific framing is where is the work of these three broad groups of people coming together? It&#8217;s coming together over and over and over and over again, to make a functioning website. And in the lamp stack era, it&#8217;s that PHP server, you know, be it shared hosting or a server in the closet. That is where the work of those three groups has to fit together.</p>\n\n\n\n<p>And for the decade or so that the lamp stack was dominant, there became pretty solidified best practices on how those three groups need to work together in order to do their jobs most effectively.</p>\n\n\n\n<p>[00:17:26] Nathan Wrigley: I feel that&#8217;s a really nice segregation of the different things that were going on. But also it makes the two bits that you are not involved with suddenly quite mysterious. If you&#8217;re the content editor, suddenly the IT bit, the hosting if you like, you&#8217;re no longer involved in that in any way. And, so that over time becomes a little bit more murky and what have you.</p>\n\n\n\n<p>But the advent of the CMS suddenly opened up a whole range of possibilities for people who really don&#8217;t have any technical, they don&#8217;t desire to be technical. They want to be consumed with the content. They want to log into something, type away, upload images, what have you, and press publish, and for it to be done.</p>\n\n\n\n<p>So I think that&#8217;s a really useful definition. Prior to that, you had to be fairly technical, at least technically enough to create the HTML and what have you, to then upload it to the server. And now we&#8217;ve got a kind of career path coming out of it, haven&#8217;t we? We&#8217;ve got the IT people, we&#8217;ve got the editor people, and various other different pieces of the puzzle.</p>\n\n\n\n<p>It feels like maybe that is where quite a few people will still be with WordPress. That is to say they&#8217;ve got a WordPress website, they&#8217;re paying a monthly fee to a hosting company. That hosting company is literally holding the files of the CMS, in our case, WordPress. Holding them on a particular box somewhere. The DNS is pointed correctly. It all works. That set up is still doable, but I guess the journey doesn&#8217;t end there. I suppose we&#8217;ve got quite a long way to go in this journey.</p>\n\n\n\n<p>[00:18:59] Steve Persch: Yeah, the journey does not end there. Actually it might, because it comes back around. There are other steps along the way. So, I see the next big event in this history as the release of the iPhone. Which for a while I wondered like, am I drawn to that as the key moment? Because that&#8217;s when I was coming into professional web development, around 2007. In the decade plus remove, I can see, no, that really was a big deal when we had to figure out how to make websites squish, and fit on different size devices. Phones, tablets, Android devices of every single size and resolution.</p>\n\n\n\n<p>That was a huge change. And it came about at the same time these native application ecosystems sprung up, and really, really raised the bar for how good of an experience you could have on these devices. So not only is this just a new form factor to make work at all. The quality bar jumps up very, very high. In retrospect, I can see like, oh, that set off a bit of a panic in the web development community. And different people reacted in different ways and, you look at the 2010s and think, oh yeah, people ran in a bunch of different directions trying to handle or deal with the existential question of, how does the web stay relevant when literally billions of dollars are pushing technology towards native applications.</p>\n\n\n\n<p>[00:20:33] Nathan Wrigley: I feel there&#8217;s some other pieces I might add into that as well, and that is, the invention of the iPhone, which then spawned so many other similar devices, some slightly larger, some competing operating systems. But the thing there was suddenly the internet went from something which was probably peripheral in your life.</p>\n\n\n\n<p>You would interact with it, maybe with email or something at work. You&#8217;d have to turn on a computer and sit in a chair. And the internet would be on that screen and then you&#8217;d walk away from it and you&#8217;ve forgotten about the internet. Suddenly you&#8217;re at a point where the internet is with you 24 7, should you wish. It&#8217;s there all the time. So it marks a moment where not only is it technically possible to do it, but it increases the importance in everybody&#8217;s lives. So, almost everything now, what are we now about 15 years later or something?</p>\n\n\n\n<p>Almost everything can have a web presence. You know, you were talking about buying tickets earlier. Well, what&#8217;s the best way to do that now? It&#8217;s the internet. How do you consume your radio? It&#8217;s the internet. Where does your entertainment come from? It&#8217;s the internet. There&#8217;s almost nothing, which the internet hasn&#8217;t touched, and I feel that that was the inflection point when it went in your back pocket and suddenly every company on earth had a window into everybody&#8217;s lives.</p>\n\n\n\n<p>[00:21:50] Brian Perry: It&#8217;s a blessing and a curse.</p>\n\n\n\n<p>[00:21:52] Nathan Wrigley: But also a convergence of the technology, you know. So cellular data was suddenly getting rolled out. Prior to that it was just mobile phones was as, as much as you could do. You could do voice chat and so on. But then mobile data came along and it all coincided at the same time. So I, yeah, Steve, I think that&#8217;s a really insight thing. The iPhone being this moment.</p>\n\n\n\n<p>[00:22:09] Steve Persch: So the iPhone, when it comes out, it suddenly becomes the most powerful computer in the whole stack. If you&#8217;re thinking about what can we make a website or a native application? What can I do with this device? A lot of people consciously or unconsciously realized if we push more responsibility to this last computer in the chain. From the developer&#8217;s computers. There are still servers involved.</p>\n\n\n\n<p>There are increasing number of computers in the cloud that are involved in getting the website to that iPhone. But the iPhone in many respects, the most powerful computer in the whole stack, and that leads to an architecture of, oh, let&#8217;s make that end device, be it a laptop, a high powered iPhone or a low powered budget Android phone. Let&#8217;s put all the responsibility there. Brian, I bet you could talk in greater detail about the upsides and the downsides of the single page application architecture that came about when a lot of the web development ecosystems said, oh, let&#8217;s put all the responsibility in the client, in the end device.</p>\n\n\n\n<p>[00:23:16] Brian Perry: Yeah, there&#8217;s definitely like a huge trade off to that in that the end result that we&#8217;re doing there, especially thinking about modern JavaScript frameworks, were essentially pushing more responsibility, more code, more JavaScript to that end device. So there&#8217;s more places where things could potentially go wrong.</p>\n\n\n\n<p>There&#8217;s more cases where rather than having just a HTML document that is passed from a device to device, it actually has responsible, responsibility for rendering the page and executing all of that code. And it&#8217;s even a situation where things as simple as being able to click the back button in your browser to go to the previous HTML document, that&#8217;s things that need to be handled within that client device.</p>\n\n\n\n<p>So it really does increase the complexity there. And then also related to what we&#8217;ve been talking about and thinking about, the three audiences that we talked about before. One thing that jumped out to me is that as we&#8217;re finding all of these, you know, the internet everywhere, and all of these, different devices that can be used for these different purposes. I think some of also what brings us to the headless architectures that we&#8217;re going to get to down the line, is in some ways, I think driven by the content editor. In that they still want to have one place where they can go and manage content that is going to show up in all of these different places.</p>\n\n\n\n<p>Whether it&#8217;s a client side page, a traditional website, things managed by PHP, and I think that also does start to lead us in the direction of how can we manage this content in one place and make that data available to all kinds of different consumers.</p>\n\n\n\n<p>[00:25:01] Nathan Wrigley: So we have the, we have the iPhone, and prior to that we have just regular servers. I guess we&#8217;ve now got to take a bit of a leap and stray into an area where maybe many of us really don&#8217;t know what we&#8217;re talking about, and I&#8217;ve very much include myself in this. What are the evolution of things that have happened subsequently since the iPhone?</p>\n\n\n\n<p>And what was the purpose of all of that? Were there things which were tried and failed? And I suppose we are slowly getting towards the present day, but if there&#8217;s been some interesting evolutions during that time which need to be mentioned to give context, please do.</p>\n\n\n\n<p>[00:25:35] Steve Persch: Absolutely, I think one dynamic that played out in the 2010s was the splintering of all these different disciplines. I said in that lamp stack era, there are these three broad groups, of IT and content editors and developers. And I was even lumping in designers with the developers there.</p>\n\n\n\n<p>There might be some designers who take offense to that, but you know, it&#8217;s a blurry line. I lump them together because at a very, a very zoom out level that that&#8217;s the group that&#8217;s responsible for controlling how the website looks. And the handoffs that happened between designer and developer have changed over the years.</p>\n\n\n\n<p>But in the 2010s, there&#8217;s just an incredible splintering of the amount of detailed knowledge necessary to make websites look good across all these different devices was so large it was just unreasonable to think that you can hire one human being to know how to even implement a good design across all of these devices.</p>\n\n\n\n<p>Who also knows how to, like, configure Advanced Custom Fields and WordPress. That&#8217;s not a terribly reasonable expectation, to think you can find one person who is excellent at both of those things. Some of those people do exist in the world, but for many team leaders putting together teams, they&#8217;re realizing, we&#8217;re going to be better off if we say like, Steve, you&#8217;re going to be the backend expert, and Brian, you&#8217;re going to be the front end expert. And, even though Brian has a whole lot of that backend expertise, for many teams, they just decided to make a hard divide in the people.</p>\n\n\n\n<p>And then subsequently, or the order was sometimes flipped, a hard divide in the technology. So for, you know, a lot of websites built in this era, there is a very hard divide between the content management system is over here, be it WordPress or Drupal or a natively headless system like Contentful or Sanity. That&#8217;s going to be managed by one group, and then this group of front end specialists will handle the front end presentation.</p>\n\n\n\n<p>That&#8217;s a hard cut to make. A question I&#8217;ve been asking for the last decade or so is, if we&#8217;re going to cut off WordPress&#8217;s head or Drupal&#8217;s head, where is the neck? That is an answer that is constantly moving. The next era, after single page applications, is static site generation. As people saw the, you know, that downside of single page applications, then it&#8217;s, oh, well what if we, what if we get some of the benefits of that old way of doing it where it was just flat files? Can we have flat files again, Brian.</p>\n\n\n\n<p>[00:28:06] Nathan Wrigley: Full circle.</p>\n\n\n\n<p>[00:28:07] Brian Perry: Exactly. That introduces a whole new set of challenges and trade offs. You know, it certainly does, things being completely static does provide a build asset that is immutable, and it&#8217;s easy to roll back. It&#8217;s something that can be cached on a CDN. But also it really changes, kind of going back to again, the editing experience. It really drastically changes that experience where someone who was used to editing a page in WordPress and clicking publish and then being able to see the page.</p>\n\n\n\n<p>Now you have a workflow where you make a change in your CMS or whatever the source of the data is, and then a build has to run to be able to have the end website updated. And how do you preview what that looks like before the build runs? Do you need a separate environment? That trade off definitely brings a lot of additional complexity potentially to the content editing experience now.</p>\n\n\n\n<p>[00:29:07] Nathan Wrigley: Yeah, I think it&#8217;s potentially very frustrating as well because although the technological benefits and probably things like SEO and all of those things. There probably are great benefits there. If you&#8217;re the content editor, there&#8217;s probably only annoyance that when you click publish nothing happens.</p>\n\n\n\n<p>We&#8217;ve got to wait for some, like you say, some build process to carry on. You&#8217;re adding in a great deal of incredible technological innovation, which speed things up and pushes things to different parts of the world, and I&#8217;m sure it&#8217;s something we can get into. But also from the content editing point of view, we&#8217;ve had this evolution toward being able to edit everything right away, and click publish and seeing it, to then suddenly yanking that carpet out from underneath them, which is yeah, kind of frustrating I guess.</p>\n\n\n\n<p>[00:29:55] Steve Persch: I called this the cliff of complexity. If you search on YouTube for that phrase, you can probably find a presentation that I did at Gatsby Conf. So Gatsby, as a front end framework, really became popular as that static site generator pattern was on the ascendance, because there are so many technological benefits to be had, but when you add in a handful of possibly extra requirements. Requirements like, well, the content editors really like to be able to press publish and see it immediately. That shoots you up this cliff where making that work in an architecture that is fundamentally static, is really cutting against the grain.</p>\n\n\n\n<p>Like it can be made to work, but is massively complex. And we think for a lot of teams like that complexity is just now worth it. The fundamental mode that WordPress has done for 20 years of like, you press publish and then you see it immediately. That is something that should not be compromised on for most teams.</p>\n\n\n\n<p>[00:30:56] Nathan Wrigley: We&#8217;re used to a trajectory where technology just gets better in every respect. So, not only does it get quicker, but the, you know, the UI is easier to use and there&#8217;s a complete expectation that if I could publish it yesterday, and click publish and it was published right away and I could examine and look for errors that I&#8217;d made.</p>\n\n\n\n<p>Well, we&#8217;re a year on from that. Why have you taken that capability away from me? We&#8217;re going backwards? Well, we&#8217;re kind of going sideways. We&#8217;re not going back because we&#8217;re just changing things. I think that would be a bitter pill to swallow. Hard to understand if you&#8217;re not technical.</p>\n\n\n\n<p>[00:31:30] Steve Persch: Yeah, absolutely. And I think that&#8217;s, that backwards moving or that sideways moving does happen in other places. That&#8217;s not something I think that&#8217;s unique to web development. I remember the first time I got a car that relied heavily on a touchscreen. I was like, no, I want a knob to turn up the volume on the radio. This is so much worse. But somebody thought, no touchscreens, that&#8217;s the future. No. A lot of cars are now backswinging. There&#8217;s some parts that we do need physical buttons and dials for. That is better.</p>\n\n\n\n<p>[00:32:01] Brian Perry: I was going to say, it&#8217;s funny that you bring up the car example because, my car actually has both, which is somewhat infuriating. There is a touchscreen that could do everything. And then on the console, all the knobs and buttons, they can do the exact same things. I feel like the JavaScript frameworks in trying to address the shift aggressively in the direction of static sites has had a period of time where it was the equivalent of my car that had both.</p>\n\n\n\n<p>So things started shifting back over to server side rendering. But a lot of the frameworks had, and still have, concepts of both at one time. So there are ways that you can say, I want to either build things statically by default, and after some period of time they&#8217;re invalidated and re rendered on the server. Or say that it&#8217;s this subset of pages that are pre-rendered statically. Maybe it&#8217;s my homepage, and my 100 most popular pages.</p>\n\n\n\n<p>And then other things are handled server side. That also does increase the complexity now. You have to know what things are static, what things are not. It&#8217;s kind of two different approaches. But yeah, it does feel a lot like my car that has essentially two completely redundant ways to interface with it.</p>\n\n\n\n<p>[00:33:19] Nathan Wrigley: I&#8217;m waiting for somebody to invent the car which has levers in it. So that you&#8217;ve got screens, dials, and levers. Then we&#8217;ll, we&#8217;ll truly have the car from across the entire century. So is that where we&#8217;re at now then? If we chart our history we spoke about HTML files, and then PHP coming along and then flattening things. Is that this history lesson ends, or is there more to say?</p>\n\n\n\n<p>[00:33:42] Steve Persch: The way I think about it, a phrase I often like to repeat to myself that came from a customer of ours, is that Pantheon needs to aim for state of the art, not bleeding edge. We see the state of the art for many web teams right now is one where you use a totally stable content management system like WordPress or Dupal for the content management systems.</p>\n\n\n\n<p>And because so many front end developers simply expect to be working in JavaScript centric tools for teams in that, in that pool. Yes, you should have the front end then controlled through JavaScript centric tools. But do so with server side rendering because the content editors expect to press publish and then immediately see the change. And that works well with server side rendering.</p>\n\n\n\n<p>So that&#8217;s, that&#8217;s a mode that we support in our front end sites product, the front end sites product does also support that static mode. Which is beneficial for a subset of teams out there. Like Pantheon&#8217;s own documentation site has been a totally static site for nearly a decade. I think as long as we&#8217;ve had a standalone docs site, it&#8217;s been static. And that works for that team where everything is all just in a Git repo. An edit to code can happen at the same time as an edit to the content markdown files. That works for that mode.</p>\n\n\n\n<p>But we see that, you know, the state of the art for some web teams, as that mix of a contact management system, and a server side rendered Node.js framework. I should also say, because we&#8217;re on a WordPress centric podcast here, if you are totally comfortable with WordPress, as is, you don&#8217;t need to jump on a new React framework or a new JavaScript framework, just because there are a lot of people on Twitter saying it&#8217;s great. If you can do your job without taking on the extra complexity, stick with what works.</p>\n\n\n\n<p>[00:35:28] Nathan Wrigley: Yeah, it&#8217;s a really good point. You mentioned there, now, I can&#8217;t remember the exact phrasing that you used, but you made a differentiation between bleeding edge and something else. Is that an approach that you take? Do you keep a watchful eye on what is happening at the extremes of technology.</p>\n\n\n\n<p>[00:35:44] Steve Persch: Oh absolutely, yes.</p>\n\n\n\n<p>[00:35:46] Nathan Wrigley: PhD thesis which are describing what the future might look like. But holding back just a little bit until it&#8217;s embedded and we figured out what all of this stuff is. That&#8217;s the approach?</p>\n\n\n\n<p>[00:35:56] Steve Persch: Absolutely. So it is not a coincidence that Pantheon as a company started a decade after Drupal came into being. It was starting as a Drupal centric company, and then adding WordPress a few years later. That&#8217;s not a coincidence. There needed to be a decade or so of figuring out, how do we make websites like this before Pantheon or any company like Pantheon could do what we did. Which is put guardrails around what our founders considered to be a best practice mode of developing and maintaining and improving a lamp stack site.</p>\n\n\n\n<p>Trying to impose those guardrails the same year that a system like WordPress or Drupal comes out, that wouldn&#8217;t make sense. Similarly, we didn&#8217;t really enter this front end framework ecosystem until about a decade in. I think almost exactly a decade after React, was released publicly is when we entered this space fully.</p>\n\n\n\n<p>We&#8217;ve been keeping an eye on it for a very long time. I&#8217;ve been at Pantheon for seven years and that was one of my very first questions, my first week, like, when are we going to get into the Node.js space? And the answer then was not yet. And then for a while, it was soon. And then the answer was like, okay, now.</p>\n\n\n\n<p>And now we can see, okay, the edge and one of the reasons I like to use that term bleeding edge is because that&#8217;s also the term for where the bleeding edge is now. The edge, as a synonym for the content delivery network. So companies like Cloudflare or Fastly that cache your website all over the world, have been adding more and more advanced capabilities beyond the simple caching that makes the website faster. That is very clearly where the bleeding edge or the cutting edge is now. We have a CDN baked in. We have ways of exploring that. However, put it all on the edge is not an acceptable answer yet for the broad plurality of professional web teams.</p>\n\n\n\n<p>[00:37:50] Nathan Wrigley: Why is that? What&#8217;s the thing which makes that untenable?</p>\n\n\n\n<p>[00:37:53] Steve Persch: The very short answer is because your database is still in one place. Even though the cloud abstracts so much like. There is a MySQL database or an abstraction thereof that lives physically in one place. Because we run on Google Cloud, that place for most sites on Pantheon is in Council Bluffs, Iowa.</p>\n\n\n\n<p>For a WordPress site that you know, may be making in some cases hundreds of MySQL queries to generate an HTML page, hopefully fewer than, than a few hundred, but in many cases, hundreds of queries. It&#8217;s best if the PHP process that&#8217;s making those queries is right next to, physically right next to that database.</p>\n\n\n\n<p>There are new companies popping up spreading your database all over the world at the edge. Okay, that sounds cool, but before, before we take some of the biggest websites in the world and say, oh yeah, your database will be everywhere. We need to see how that plays out with those who, who want to jump on the edge earlier. Because for the sites we serve and cater to they need to be planning in very long terms.</p>\n\n\n\n<p>We&#8217;re highly adopted in the edu space, and I, I&#8217;ve put together timelines on yardsticks to represent like the multi hundred year history of these universities that we&#8217;re working with. And asking like, on a multi a hundred year scale or a scale of decades, it doesn&#8217;t matter that much if you switch to the new thing, whatever the new thing is, this semester or next semester, or this year or next year? Let&#8217;s wait till we know that that next thing is solid before we jump on it.</p>\n\n\n\n<p>[00:39:23] Brian Perry: As the JavaScript guy, I got to say I want it now. But, aside from that, one thing that&#8217;s interesting from the front end perspective as well, thinking about running things on the edge. One of the challenges there is that right now, all of the different solutions for edge functions tend to use different variations of JavaScript runtime. So there&#8217;s really no consistency there. And I think that&#8217;s another thing that&#8217;s going to have to change before that gets real wide adoption, when there can be one consistent JavaScript runtime that is typically used for that solution.</p>\n\n\n\n<p>[00:39:54] Nathan Wrigley: You mentioned Steve, but Brian maybe can answer this as well, I don&#8217;t know. You mentioned that there are people who are endeavoring to break up the database and put it in all sorts of different parts of the world and what have you. So that&#8217;s one innovation which people are trying to achieve. I&#8217;m just curious about what the next 10 years will look like. What kind of fun, interesting projects have you guys been keeping your eye on, which the listeners may be interested in? Just to give some insight into what hosting a WordPress website might look like Well, in 2025, 2026, whatever it may be.</p>\n\n\n\n<p>[00:40:29] Brian Perry: My kind of, it&#8217;s partially my hope, but also where I&#8217;d like to think that things are going. With all of the constant changes in the JavaScript framework landscape, I think that more and more of the things that people like about that sort of developer experience is going to find its way just more generally into the platform and into browser standards.</p>\n\n\n\n<p>Again, like looking back in the rear view, jQuery is a good example of that, in that jQuery brought so many wonderful niceties for how you can interact with the DOM. And then over time, most of the things that jQuery can do are just in JavaScript now. So they&#8217;re part of the platform.</p>\n\n\n\n<p>So my hope is that the things that people like about React and Vue and et cetera, start to find their way into the general platform. Web components are one potential technology that might help there. A component based approach that can be used regardless of the framework.</p>\n\n\n\n<p>My hope is that in the next 10 years, a lot of the things that people turn to React or Vue or different frameworks for, are just a part of the platform, rather than having to find your cool JavaScript framework that was released three months ago,</p>\n\n\n\n<p>[00:41:47] Nathan Wrigley: Yeah. Nice. Thank you, Brian. Steve, anything to add to that?</p>\n\n\n\n<p>[00:41:51] Steve Persch: I&#8217;ll give a quick tech answer, then a longer, uh, philosophical sort of answer. So the quick tech answer is web assembly. I&#8217;ll be quick because I can&#8217;t speak to many of the details of web assembly, maybe Brian can? I see it as a layer that can abstract away many of the differences between the different computer languages that we&#8217;re all writing in. PHP, JavaScript, TypeScript, Rust. If web assembly is a common target that can be used to leverage software. You write in these different modes. Run it in the same place, be it at the edge, or I saw a demo recently that I think involved web assembly getting WordPress to fully run in your browser, like the WordPress running in web assembly in your browser. Okay, that, that looks cool.</p>\n\n\n\n<p>The thing I&#8217;m, I&#8217;m probably most excited about right now for where the overall web zeitgeist is going is, is that the web development ecosystem seems to be coming back to what WordPress has been saying for a long time, of decisions, not options as that philosophical pillar for the WordPress community.</p>\n\n\n\n<p>I find it very reassuring that these front end framework projects that for a decade or so, provided so many options and put so many decisions on the plate of individual web teams and said like, you figure out whether or not you want Redux or this other thing to pair with your React project, and good luck sorting out the hundreds or thousands of NPM dependencies that get installed.</p>\n\n\n\n<p>The frameworks that seem to be, that just are ascendant, right now, are the ones that are consolidating a lot of those options. Turning them into decisions that are made at the framework level, be it Next.js or Astro or Remix. The leaders of those projects seem to understand that there&#8217;s a desire in the community for, for those framework maintainers as experts to make a good quality decision that works for the broad majority of users of those frameworks. Be it Next or Astro or anything else. The users of Next.js are comfortable with an increasing number of decisions being first made in a centralized framework. WordPress has been doing that again for 20 years. Again, it&#8217;s fashionable.</p>\n\n\n\n<p>[00:44:11] Nathan Wrigley: Yeah, history I think in many respects is fairly cyclical. What goes around does seem to come around. Yeah, good observation. I&#8217;m curious at this point, we&#8217;ve reached the 50 minute mark, and I want to wrap it up. I know you&#8217;ve got things to do with your day. But is there anything that you had wished that we had talked about that we failed to?</p>\n\n\n\n<p>[00:44:31] Steve Persch: Brian, do you want to touch on Decoupled Kit?</p>\n\n\n\n<p>[00:44:34] Brian Perry: Yeah, I&#8217;d love to talk about that a little bit. The Decoupled Kit project is essentially what we&#8217;re thinking of as a kit, is essentially a backend starter project and a front end starter kit that are intended to work together as close to out of the box with as little configuration as possible. To try to simplify the process of setting up the headless or decoupled architecture sites.</p>\n\n\n\n<p>And also provide some common examples of types of integrations and common problems that need to be solved there. And the thing that I think is most interesting about some of what we&#8217;re doing there. Again, thinking about this being an open source project sponsored by Pantheon, is we&#8217;re trying to solve some of these problems in cases where it makes sense in a framework agnostic way.</p>\n\n\n\n<p>So, obviously starter projects for both Drupal and WordPress. And then within that we have a starter kit, we have multiple starter kits that are based on React. So we have a starter kit for Gatsby and WordPress, and a starter kit for Next.js and WordPress. So we&#8217;re trying to find cases where there are things that we can abstract out, which are just essentially like general utilities for sourcing data from WordPress. And not things that are really strictly tied to any one framework.</p>\n\n\n\n<p>So that if there is, you know, another framework in the future that we need to support, or gains popularity, it&#8217;s easy to make adjustments there and adapt to that. And I think in the headless CMS community, both in the Drupal world and the WordPress world. I think there&#8217;s a lot of opportunity for tools that are a little bit more framework agnostic, that can still serve popular projects like Next.js. But hopefully are things that the community can use as the JavaScript world evolves.</p>\n\n\n\n<p>I&#8217;ll just also throw out there that, would love to, as we continue to build things, any feedback on the project. The main repo is decoupled dash kit dash js, under the Pantheon Systems GitHub. Would love to hear what people run into, any features that they&#8217;d love to see us support in the future. Any feedback is welcome.</p>\n\n\n\n<p>[00:46:45] Nathan Wrigley: I will make sure to link to all of the bits and pieces that we&#8217;ve talked about in the show notes. So if you are listening to this and you want to follow up on what the guys have been mentioning, then head over to wptavern.com, search for the episode, and all of the links will be in the show notes. Just before I let you go and get on with your busy days. If somebody wants to reach out to you personally and connect, what are the best ways, what are the methods that you are willing to share publicly? Let&#8217;s go with Brian first.</p>\n\n\n\n<p>[00:47:16] Brian Perry: Sure. Yeah, I&#8217;m in a number of CMS and Pantheon community Slacks, usually as Brian Perry. That, that&#8217;s one decent way to get at me. And then also I am still on Twitter. That is my main connection to the web development social media world, currently. Bri Comedy, b r i comedy on Twitter.</p>\n\n\n\n<p>[00:47:38] Nathan Wrigley: Brian, thank you very much. And Steve.</p>\n\n\n\n<p>[00:47:40] Steve Persch: I am spending less time on Twitter these days, although I&#8217;m still there as at stevector. And LinkedIn is the social network that I&#8217;m opening most often these days, and I&#8217;m easy to find just by searching for Steve Persch.</p>\n\n\n\n<p>[00:47:55] Nathan Wrigley: Thank you very much. Brian Perry and Steve Persch really appreciate you coming onto the podcast today. Thank you very much indeed.</p>\n\n\n\n<p>[00:48:02] Steve Persch: Thank you, Nathan.</p>\n\n\n\n<p>[00:48:03] Brian Perry: Thank you.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://pantheon.io/team/steve-persch\">Steve Persch</a> and <a href=\"https://pantheon.io/team/brian-perry\">Brian Perry</a>. They’re both employed at <a href=\"https://pantheon.io/\">Pantheon</a>, an enterprise website operations platform, and they’re here to talk about the evolution of website hosting.</p>\n\n\n\n<p>Back when the internet started, hosting was a fairly straightforward enterprise. You created HTML files and uploaded them to a server. That was it. An HTML file was a page.</p>\n\n\n\n<p>Server-side technologies such as PHP came along and the picture became a little more complex. Web pages needed to be constructed on-the-fly. Databases were thrown into the mix and the complexity increased.</p>\n\n\n\n<p>Add in the different languages that you could write your code in, and the server configurations. The CMS that you choose also plays into this mix.</p>\n\n\n\n<p>Now we’ve got CDNs, headless, React, Gatsby, Node.js and much more. Is it even possible for the non-technical to have any understanding of where their website is?</p>\n\n\n\n<p>Steve and Brian talk about how they got into the hosting space and what’s changed over the years. We address what Pantheon is doing with WordPress and Drupal.</p>\n\n\n\n<p>We discuss how headless can be difficult for content teams, given that there’s a disconnect with hitting the publish button, and that content going live on the site.</p>\n\n\n\n<p>What’s certain is that there’s no end in sight in terms of the rate of innovation in the website hosting space. What’s popular today might not be several years from now, and so it’s a timely discussion of what Steve and Brain see as the best bets for the future.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links.</h2>\n\n\n\n<p><a href=\"https://pantheon.io/blog/decoupled-kit\">Brian&#8217;s blog post about Decoupled Kit</a></p>\n\n\n\n<p><a href=\"https://www.youtube.com/watch?v=dF39cXW3IqY\">Steve&#8217;s video &#8220;Decoupled Architectures: What Computer Assembles the website&#8221;</a></p>\n\n\n\n<p><a href=\"https://www.contentful.com/\">Contentful</a></p>\n\n\n\n<p><a href=\"https://www.sanity.io/\">Sanity</a></p>\n\n\n\n<p><a href=\"https://gatsbyconf.com/\">GatsbyConf</a></p>\n\n\n\n<p><a href=\"https://docs.pantheon.io/overview/support\">Pantheon&#8217;s documentation site</a></p>\n\n\n\n<p><a href=\"https://www.cloudflare.com/\">Cloudflare</a></p>\n\n\n\n<p><a href=\"https://www.fastly.com/\">Fastly</a></p>\n\n\n\n<p><a href=\"https://webassembly.org/\">WebAssembly</a></p>\n\n\n\n<p><a href=\"https://nextjs.org/\">Next.js</a></p>\n\n\n\n<p><a href=\"https://astro.build/\">Astro</a></p>\n\n\n\n<p><a href=\"https://www.gatsbyjs.com/\">Gatsby</a></p>\n\n\n\n<p><a href=\"https://twitter.com/bricomedy\">Brian&#8217;s Twitter</a></p>\n\n\n\n<p><a href=\"https://twitter.com/stevector/\">Steve&#8217;s Twitter</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Apr 2023 14:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:192:\"HeroPress: Empowering Women within the WordPress Community: Embracing Contributions and Overcoming Fear – Empowerment von Frauen in der WordPress-Community: Mitmachen und Ängste überwinden\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=5438\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:256:\"https://heropress.com/essays/empowering-women-within-the-wordpress-community-embracing-contributions-and-overcoming-fear/#utm_source=rss&utm_medium=rss&utm_campaign=empowering-women-within-the-wordpress-community-embracing-contributions-and-overcoming-fear\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15453:\"<img width=\"1024\" height=\"512\" src=\"https://heropress.com/wp-content/uploads/2023/04/040323-min.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: Women, your talents, ideas, and passion are needed, and together we can continue to shape the future of WordPress.\" /><p><a href=\"https://heropress.com/feed/#deutsch\">Dieses Essay ist auch auf Deutsch verfügbar.</a></p>\n\n\n\n\nHere is Birgit reading her own story aloud.\n\n\n\n\n\n\n<p>The world of technology and open-source projects can often feel intimidating, especially for women, who may experience feelings of inadequacy or fear of rejection. In my own journey within the WordPress community, I have faced challenges and insecurities while navigating an environment where my work and accomplishments sometimes go unrecognized. However, I have also discovered the incredible impact that women&#8217;s contributions can have on the community and the importance of overcoming fear to make a meaningful difference. Today, I will share my experience and mission to empower women to contribute to the WordPress project, regardless of the obstacles they might face.</p>\n\n\n\n<h3 id=\"h-my-experience-in-the-wordpress-community\">My Experience in the WordPress Community:</h3>\n\n\n\n<p>Even though I’ve used WordPress from its first release, I began my journey in the WordPress community back in 2010 by visiting my first WordCamp in Berlin, Germany. This WordCamp was my leap into deep waters, I couldn’t imagine. There I made valuable contacts which led me joining one of the biggest WordPress agencies in Germany. After joining the Inpsyde Agency, whose founder also initiated the German-speaking WordPress community and ran the community forums, I was soon made responsible for overseeing the translations and compiling the software packages for the WordPress releases in German.&nbsp;</p>\n\n\n\n<p>Since then, I have contributed in various ways, from organizing meetups and writing support documentation to translating the software and providing training materials. Like many others, I was not always vocal about my contributions, and due to the lack of visible logs, I could not easily measure the impact of my work. This lack of recognition sometimes left me feeling discouraged and questioning my value within the community.</p>\n\n\n\n<p>Nonetheless, I persisted – with some mental health related sabbaticals – in contributing to the project, driven by my passion for WordPress and a desire to help others. Over time, I began to recognize the importance of the work I was doing, regardless of whether it was acknowledged by others. I saw firsthand how my efforts, along with those of countless other women in the community, helped to shape the WordPress ecosystem, making it more inclusive, accessible, and user-friendly.</p>\n\n\n\n<h3 id=\"h-the-importance-of-embracing-contributions-and-overcoming-fear\">The Importance of Embracing Contributions and Overcoming Fear:</h3>\n\n\n\n<p>Despite the challenges we may face, it is crucial for women to embrace their contributions and overcome their fears in the WordPress community. By stepping up and sharing our skills, talents, and insights, we can help shape the future of the project and make a lasting impact. There are several reasons why this is essential:</p>\n\n\n\n<ol>\n<li>Diversity in perspectives: Women bring unique perspectives and experiences to the table, which can lead to innovative solutions and a more well-rounded community. By contributing, we help ensure that the WordPress project remains diverse and inclusive.</li>\n\n\n\n<li>Empowerment and personal growth: Taking on challenges and pushing ourselves beyond our comfort zones can be an incredibly empowering experience. Contributing to the WordPress community not only allows us to grow professionally, but also boosts our self-confidence and sense of accomplishment.</li>\n\n\n\n<li>Inspiring others: When we step up and contribute despite our fears, we become role models for other women who may be hesitant to get involved. By sharing our stories and experiences, we can inspire and encourage others to join the community and make their own impact.</li>\n\n\n\n<li>Building a supportive network: By actively participating in the WordPress community, we can form connections and relationships with like-minded individuals who can offer support, mentorship, and encouragement. This network can be invaluable in overcoming challenges and fostering a sense of belonging within the community.</li>\n</ol>\n\n\n\n<h3 id=\"h-my-mission-to-empower-women-in-the-wordpress-community\">My Mission to Empower Women in the WordPress Community</h3>\n\n\n\n<p>As someone who has experienced the challenges and rewards of contributing to the WordPress project, I am dedicated to empowering other women to do the same. My mission is to create a supportive environment where women feel encouraged to share their talents, ideas, and expertise, regardless of any fears or obstacles they may face.</p>\n\n\n\n<p>To achieve this goal, I am committed to:</p>\n\n\n\n<ul>\n<li>Raising awareness about the importance of women&#8217;s contributions in the WordPress community</li>\n\n\n\n<li>Actively recognizing and celebrating the achievements of women who have made a significant impact within the project</li>\n\n\n\n<li>Encouraging mentorship programs that support and guide women in their journey as contributors</li>\n\n\n\n<li>Sharing my own experiences and lessons learned to inspire and empower others</li>\n\n\n\n<li>Fostering a sense of camaraderie and support among women in the community, promoting collaboration and understanding</li>\n</ul>\n\n\n\n<p>Fear can be a powerful deterrent that prevents us from realizing our full potential and making meaningful contributions to the projects and communities we care about. However, it is crucial for women to recognize the value of their skills and insights and to overcome their fears in order to make a lasting impact within the WordPress community.</p>\n\n\n\n<p>By embracing our contributions, seeking support, and empowering one another, we can help create a more inclusive, diverse, and vibrant WordPress ecosystem that benefits everyone. So, to all the women who have thought about contributing to the WordPress project but have held back due to fear or uncertainty, I encourage you to take that first step. Your talents, ideas, and passion are needed, and together we can continue to shape the future of WordPress.</p>\n\n\n\n<p>Disclaimer: While the content of this essay primarily addresses women, I wholeheartedly acknowledge and embrace the diversity of gender and sexual orientation, including those who identify as female, non-binary, or belong to underrepresented groups.</p>\n\n\n\n<div class=\"kb-row-layout-wrap kb-row-layout-id_ade563-ae alignnone kt-row-has-bg wp-block-kadence-rowlayout\"><div class=\"kt-row-column-wrap kt-has-1-columns kt-row-layout-equal kt-tab-layout-inherit kt-mobile-layout-row kt-row-valign-top\">\n\n<div class=\"wp-block-kadence-column kadence-column_d879cf-9a\"><div class=\"kt-inside-inner-col\">\n<h2 id=\"work-environment\" class=\"kt-adv-heading_1e8c32-97 wp-block-kadence-advancedheading\">Birgit&#8217;s Work Environment</h2>\n\n\n\n<p>We asked Birgit for a view into her development life and this is what she sent! </p>\n\n\n	<div class=\"hotspots-image-container\">\n		<img width=\"2560\" height=\"1920\" src=\"https://heropress.com/wp-content/uploads/2023/03/birgit-olzems-desk-scaled-1.jpeg\" alt=\"Birgit Olzem\" class=\"hotspots-image skip-lazy\" />\n	</div>\n\n\n\n\n<p class=\"kt-adv-heading_b61d45-c4 wp-block-kadence-advancedheading has-theme-palette-9-background-color has-background\">HeroPress would like to thank <a href=\"https://wpdrawattention.com/\">Draw Attention</a> for their donation of the plugin to make this interactive image!</p>\n</div></div>\n\n</div></div>\n\n\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h1 id=\"deutsch\" class=\"kt-adv-heading_ca583d-16 wp-block-kadence-advancedheading\">Empowerment von Frauen in der WordPress-Community: Mitmachen und Ängste überwinden</h1>\n\n\n\n<p>Die Welt der Technologie und der Open-Source-Projekte kann oft einschüchternd wirken, insbesondere für Frauen, die sich unzulänglich fühlen oder Angst vor Ablehnung haben. Auf meinem eigenen Weg in der WordPress-Community war ich mit Herausforderungen und Unsicherheiten konfrontiert, in denen meine Arbeit und meine Leistungen manchmal nicht anerkannt wurden. Aber ich habe auch entdeckt, welch unglaublichen Einfluss die Beiträge von Frauen auf die Community haben können und wie wichtig es ist, Ängste zu überwinden, um etwas zu bewegen. Heute werde ich meine Erfahrungen und meine Mission teilen, Frauen zu befähigen, einen Beitrag zum WordPress-Projekt zu leisten, unabhängig von den Hindernissen, auf die sie stoßen könnten.</p>\n\n\n\n<h3>Meine Erfahrungen mit der WordPress-Community:</h3>\n\n\n\n<p>Obwohl ich WordPress seit seiner ersten Veröffentlichung benutze, begann meine Reise in die WordPress-Community im Jahr 2010 mit der Teilnahme an meinem ersten WordCamp in Berlin, Deutschland. Dieses WordCamp war mein Sprung in tiefere Gewässer, als ich es mir je hätte träumen lassen. Dort habe ich wertvolle Kontakte geknüpft, die mich zu einer der größten WordPress-Agenturen in Deutschland geführt haben. Bei der Agentur Inpsyde, deren Gründer auch die deutschsprachige WordPress-Community initiierte und die Community-Foren leitete, war ich bald für die Betreuung der Übersetzungen und die Erstellung der Softwarepakete für die deutschsprachigen WordPress-Versionen zuständig.&nbsp;</p>\n\n\n\n<p>Seitdem habe ich mich auf verschiedene Weise eingebracht, von der Organisation von Meetups und dem Schreiben von Support-Dokumentation bis hin zur Übersetzung von Software und der Bereitstellung von Schulungsmaterialien. Wie viele andere habe ich meine Beiträge nicht immer laut ausgesprochen, und da es oft keine sichtbaren Aufzeichnungen gab, war es für mich nicht leicht, die Auswirkungen meiner Arbeit zu messen. Dieser Mangel an Anerkennung führte manchmal dazu, dass ich mich entmutigt fühlte und meinen Wert innerhalb der Community infrage stellte.</p>\n\n\n\n<p>Nichtsdestotrotz arbeitete ich &#8211; mit einigen gesundheitsbedingten Unterbrechungen &#8211; weiter an dem Projekt, angetrieben von meiner Leidenschaft für WordPress und dem Wunsch, anderen zu helfen. Mit der Zeit wurde mir klar, wie wichtig die Arbeit war, die ich leistete, unabhängig davon, ob sie von anderen anerkannt wurde. Ich konnte aus erster Hand sehen, wie meine Bemühungen und die unzähliger anderer Frauen in der Community dazu beitrugen, das WordPress-Ökosystem inklusiver, zugänglicher und benutzerfreundlicher zu machen.</p>\n\n\n\n<h3>Die Bedeutung von Beteiligung und die Überwindung von Ängsten:</h3>\n\n\n\n<p>Trotz der Herausforderungen, mit denen wir konfrontiert sind, ist es für Frauen von entscheidender Bedeutung, ihren Beitrag zu leisten und ihre Ängste in der WordPress-Community zu überwinden. Indem wir unsere Fähigkeiten, Talente und Einsichten mit anderen teilen, können wir die Zukunft des Projekts mitgestalten und einen nachhaltigen Einfluss ausüben. Dies ist aus mehreren Gründen wichtig:</p>\n\n\n\n<ol>\n<li>Vielfalt der Perspektiven: Frauen bringen einzigartige Perspektiven und Erfahrungen ein, die zu innovativen Lösungen und einer vielfältigeren Gemeinschaft führen können. Durch unseren Beitrag tragen wir dazu bei, dass das WordPress-Projekt vielfältig und inklusiv bleibt.</li>\n\n\n\n<li>Empowerment und persönliches Wachstum: Sich Herausforderungen zu stellen und die eigene Komfortzone zu verlassen, kann eine unglaublich befähigende Erfahrung sein. Die Beteiligung an der WordPress-Community lässt uns nicht nur beruflich wachsen, sondern stärkt auch unser Selbstvertrauen und das Gefühl, etwas erreicht zu haben.</li>\n\n\n\n<li>Andere inspirieren: Wenn wir trotz unserer Ängste einen Beitrag leisten, werden wir zu Vorbildern für andere Frauen, die vielleicht noch zögern, sich zu engagieren. Indem wir unsere Geschichten und Erfahrungen teilen, können wir andere inspirieren und ermutigen, sich der Gemeinschaft anzuschließen und selbst etwas zu bewegen.</li>\n\n\n\n<li>Aufbau eines unterstützenden Netzwerks: Durch die aktive Teilnahme an der WordPress-Community können wir Verbindungen und Beziehungen zu Gleichgesinnten aufbauen, die uns unterstützen, beraten und ermutigen können. Dieses Netzwerk kann von unschätzbarem Wert sein, wenn es darum geht, Herausforderungen zu meistern und das Zusammengehörigkeitsgefühl innerhalb der Community zu stärken.</li>\n</ol>\n\n\n\n<h3>Meine Mission: Frauen in der WordPress-Community stärken</h3>\n\n\n\n<p>Als jemand, der die Herausforderungen und Vorteile der Teilnahme am WordPress-Projekt selbst erfahren hat, möchte ich andere Frauen ermutigen, dasselbe zu tun. Meine Mission ist es, ein unterstützendes Umfeld zu schaffen, in dem Frauen sich ermutigt fühlen, ihre Talente, Ideen und ihr Fachwissen mit anderen zu teilen, unabhängig von Ängsten oder Hindernissen, denen sie begegnen könnten.</p>\n\n\n\n<p>Um dieses Ziel zu erreichen, verpflichte ich mich, die folgenden Maßnahmen zu ergreifen:</p>\n\n\n\n<ul>\n<li>Sensibilisierung für die Bedeutung der Beiträge von Frauen in der WordPress-Community</li>\n\n\n\n<li>Aktive Anerkennung und Würdigung der Leistungen von Frauen, die einen wichtigen Beitrag zum Projekt geleistet haben.</li>\n\n\n\n<li>Förderung von Mentoring-Programmen, die Frauen auf ihrem Weg als Mitwirkende unterstützen und begleiten</li>\n\n\n\n<li>Eigene Erfahrungen und Erkenntnisse weitergeben, um andere zu inspirieren und zu stärken</li>\n\n\n\n<li>Förderung von Teamgeist und Unterstützung unter den Frauen in der Gemeinschaft, Förderung von Zusammenarbeit und Verständnis.</li>\n</ul>\n\n\n\n<p>Angst kann ein mächtiges Hindernis sein, das uns davon abhält, unser volles Potenzial auszuschöpfen und einen sinnvollen Beitrag zu den Projekten und Gemeinschaften zu leisten, die uns am Herzen liegen. Es ist jedoch von entscheidender Bedeutung, dass Frauen den Wert ihrer Fähigkeiten und Einsichten erkennen und ihre Ängste überwinden, um eine nachhaltige Wirkung in der WordPress-Gemeinschaft zu erzielen.</p>\n\n\n\n<p>Indem wir unsere Inputs annehmen, Unterstützung suchen und uns gegenseitig stärken, können wir dazu beitragen, ein inklusiveres, vielfältigeres und lebendigeres WordPress-Ökosystem zu schaffen, von dem alle profitieren. Daher möchte ich alle Frauen, die darüber nachgedacht haben, einen Beitrag zum WordPress-Projekt zu leisten, sich aber aus Angst oder Unsicherheit zurückgehalten haben, ermutigen, den ersten Schritt zu tun. Ihre Talente, Ideen und Leidenschaft werden gebraucht und gemeinsam können wir die Zukunft von WordPress gestalten.</p>\n\n\n\n<p>Disclaimer: Obwohl sich der Inhalt dieses Essays in erster Linie an Frauen richtet, erkenne ich die Vielfalt des Geschlechts und der sexuellen Orientierung von ganzem Herzen an und begrüße sie, einschließlich derer, die sich als weiblich oder nicht-binär identifizieren oder anderen unterrepräsentierten Gruppen angehören.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/empowering-women-within-the-wordpress-community-embracing-contributions-and-overcoming-fear/\">Empowering Women within the WordPress Community: Embracing Contributions and Overcoming Fear &#8211; Empowerment von Frauen in der WordPress-Community: Mitmachen und Ängste überwinden</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Apr 2023 12:34:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Birgit Olzem\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"WPTavern: iThemes Rebrands to SolidWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143283\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/ithemes-rebrands-to-solidwp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2861:\"<img />\n\n\n\n<p>iThemes, one of the oldest brands in WordPress that originally <a href=\"https://ithemes.com/blog/the-ithemes-story/\">launched around theme products</a> nearly 15 years ago, is <a href=\"https://solidwp.com/blog/press-release-ithemes-is-becoming-solidwp/\">rebranding to SolidWP</a>. Over the years, the company&#8217;s products became increasingly centered on plugins, yet the old brand had so much name recognition that its leadership was not quick to change it.</p>\n\n\n\n<p>&#8220;iThemes is known today for security, backups, and site maintenance – none of which are well-represented in the name &#8216;iThemes,\'&#8221; StellarWP Senior Director of Ops and Marketing Matt Cromwell said. &#8220;Additionally, the brand evokes the early 2000’s Apple era of technology, and we want to look toward the future.&#8221;</p>\n\n\n\n<p>This week the company kicked off a &#8220;rebrand in public&#8221; approach to updating its identity to be more aligned with promoting iThemes&#8217; key offerings &#8211; its security, backup, syncing, and educational products. They will all be rebranded to the following: </p>\n\n\n\n<ul>\n<li>Solid Security</li>\n\n\n\n<li>Solid Backups</li>\n\n\n\n<li>Solid Central</li>\n\n\n\n<li>Solid Academy</li>\n</ul>\n\n\n\n<p>&#8220;This shift in branding signifies our renewed focus on providing a solid foundation for every WordPress website,&#8221; Cromwell said. &#8220;Our whole team, as well as our products, will pivot to focus on security, backups, site maintenance, and training as we enhance and improve our solutions for all of our users.&#8221;</p>\n\n\n\n<p>The rebranding is a massive undertaking, as the company&#8217;s products have millions of users and years worth of articles, webinars, eBooks, and tutorials. SolidWP will present reworked pricing and retire some legacy products in the process.</p>\n\n\n\n<p>&#8220;Currently on ithemes.com you’ll find a lot of products that are either part of a bundle, or sold on other websites in a variety of ways,&#8221; Cromwell said in the FAQ section of the announcement. &#8220;Some products will continue to thrive on their own, and others will be retired. We plan on reviewing publicly the complete inventory of our current products and bundles and working with the community to shape what the future plan is for each.&#8221;</p>\n\n\n\n<p>The company is not planning to increase prices on its products at this time but Cromwell said they reserve the right to adjust pricing as needed. iThemes will also be consulting its community regarding products that are slated to be retired.</p>\n\n\n\n<p>&#8220;We will continue to support any and all who land in our support queue with our best efforts and service,&#8221; Cromwell said. &#8220;The official end-of-life for the products being sunset will be discussed with the community and decided on before the full launch of our new brand.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Apr 2023 22:33:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"WPTavern: Twitter Suspends WordPress.com’s Access to Twitter API, Breaking Jetpack Social Sharing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143281\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://wptavern.com/twitter-suspends-wordpress-coms-access-to-twitter-api-breaking-jetpack-social-sharing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3042:\"<p>Twitter <a href=\"https://jetpack.com/blog/an-update-on-jetpack-social-and-twitter/\">suspended WordPress.com&#8217;s access to the Twitter API</a> without notice yesterday. Representatives at WordPress.com do not know why their access is currently blocked but are working to regain it.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">Our access to the Twitter API is currently blocked. As a result, Jetpack Social is temporarily unable to automatically share your posts directly from <a href=\"https://t.co/eRvNKWaolr\">https://t.co/eRvNKWaolr</a> to Twitter.  We have reached out to Twitter for more information on how to get unblocked.</p>&mdash; WordPress.com (@wordpressdotcom) <a href=\"https://twitter.com/wordpressdotcom/status/1643240046621802497?ref_src=twsrc%5Etfw\">April 4, 2023</a></blockquote>\n</div>\n\n\n\n<p>The API enables features like Jetpack Social&#8217;s Twitter connection. Users who rely on this Jetpack module to auto-tweet their published posts will see errors in the dashboard until this issue is resolved. </p>\n\n\n\n<img />\n\n\n\n<p>WordPress.com <a href=\"https://wordpress.com/blog/2023/04/04/why-twitter-isnt-working-with-your-blog-right-now/\">advised</a> that reconnecting will not work at this time, nor will trying to establish a new connection. Connections to other social networks are still operational.</p>\n\n\n\n<p>On large publishing sites some authors may not be aware that the auto-tweet functionality is broken. For the time being, the solution is to manually tweet published posts. </p>\n\n\n\n<p>Jetpack users <a href=\"https://wordpress.org/support/topic/twitter-connections-from-wordpress-com-are-currently-experiencing-failures/\">reported</a> the issue in the plugin&#8217;s support forums 10 hours ago, as some of them are Jetpack Social paid subscribers. In October 2022, Jetpack <a href=\"https://wptavern.com/jetpack-social-plugin-adds-paid-plan-free-users-now-limited-to-30-shares-per-month\">announced</a> a paid plan for its Social plugin and limited the free version to 30 social shares per month, a controversial monetization decision that left many users in search of alternatives.</p>\n\n\n\n<p>Several users asked if refunds will be coming their way if the fix for the issue is not forthcoming, as auto-sharing to Facebook and Twitter is one of the main reasons customers subscribe to the service.</p>\n\n\n\n<p>&#8220;We are aware of issue and are looking into it with Twitter, but at this stage we don’t know when it will be fixed,&#8221; a Jetpack support representative responded to customers. &#8220;We’re working with Twitter to find the best solution possible.&#8221;</p>\n\n\n\n<p>Twitter <a href=\"https://twitter.com/TwitterDev/status/1641222789901484034\">launched</a> its new API access tiers on March 29, 2023. Access to the Enterprise tier requires an application process. Over the next 30 days Twitter is deprecating its previous access tiers and is encouraging developers to migrate to the new tiers as soon as possible to avoid disruption.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Apr 2023 19:51:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Do The Woo Community: Woo DevChat on WordPress Blocks with Nyasha Greene and Kathy Darling\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=74694\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://dothewoo.io/developer-chat-wordpress-blocks/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:429:\"<p>Nyasha Greene and Kathy Darling have a conversation on what they are building lately, and the experiences they have had with blocks.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/developer-chat-wordpress-blocks/\">Woo DevChat on WordPress Blocks with Nyasha Greene and Kathy Darling</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Apr 2023 09:35:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: Anders Norén Releases Abisko, a New Free WordPress Theme with 30+ Block Patterns\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143241\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://wptavern.com/anders-noren-releases-abisko-a-new-free-wordpress-theme-with-30-block-patterns\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3292:\"<p>Designer and developer Anders Norén has released a new free block theme called <a href=\"https://wordpress.org/themes/abisko/\">Abisko</a>, created to fully support the new design features available in the latest <a href=\"https://wptavern.com/wordpress-6-2-dolphy-introduces-a-revamped-site-editor-distraction-free-writing-mode-and-updated-block-inserter\">WordPress 6.2</a> release. The theme was named for one of Norén&#8217;s favorite stomping grounds, <a href=\"https://en.wikipedia.org/wiki/Abisko_National_Park\">Abisko national park</a>, where he hikes every summer.</p>\n\n\n\n<img />\n\n\n\n<p>Abisko places a strong emphasis on both images and typography, featuring the geometric &#8220;Plus Jakarta Sans&#8221; font for both headings and paragraph text. Plus Jakarta Sans was designed by Gumpita Rahayu from Tokotype in 2020. It seems to be gaining popularity and was mostly recently featured in the <a href=\"https://wptavern.com/lemmony-a-free-wordpress-block-theme-with-30-patterns\">free Lemmony theme</a> we reviewed last month. Plus Jakarta Sans is available as a free variable font and also on Google Fonts.</p>\n\n\n\n<p>At a font weight of 800, Abisko&#8217;s H1 and H2 headings make a major statement in the design across the various templates and patterns. Norén contrasts this with liberal use of whitespace so it doesn&#8217;t end up feeling overbearing.</p>\n\n\n\n<img />\n\n\n\n<p>Abisko includes five different style variations, with unique color palettes that will change the entire look and feel of the site. These are found under Appearance &gt; Editor and can be accessed through the Styles panel and applied globally when editing any template.</p>\n\n\n\n\n\n\n\n<p>Abisko packages more than 30 patterns for users to mix and match in creating pages. These include a grid with logo types, various artfully designed gallery layouts, contact section, various calls-to-action, hero patterns with images and background colors, testimonials grid, FAQ section, features list, a pricing table, large numbered lists, a wide separator with vertical margins, and more. </p>\n\n\n\n<p>The theme also has five full-page layouts available as patterns: About Us, Contact Us, FAQ, Front Page, and a Linktree style page.</p>\n\n\n\n<img />\n\n\n\n<p>The evolution of WordPress themes, becoming fully editable and packaged with style variations and dozens of patterns, means there is no single screenshot that can fully represent what a theme might look like. Check out the <a href=\"https://andersnoren.se/themes/abisko/\">live demo</a> to see what is possible and the page that previews all the <a href=\"https://andersnoren.se/themes/abisko/patterns/\">block patterns</a>.</p>\n\n\n\n<p>&#8220;Same as most block themes, Abisko is really lightweight and fast,&#8221; Norén said in a <a href=\"https://andersnoren.se/introducing-abisko/\">post</a> introducing his theme. &#8220;It has a small CSS file, includes no JavaScript at all, and uses locally hosted variable fonts to keep external requests and page size at a minimum.&#8221;</p>\n\n\n\n<p><a href=\"https://wordpress.org/themes/abisko/\">Abisko</a> is available for free on WordPress.org. Although Norén said he designed it with travel blogs in mind, it&#8217;s flexible for many different use cases, including agencies, portfolios, businesses, and personal websites.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Apr 2023 03:06:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WordPress.org blog: The Month in WordPress – March 2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=14780\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2023/04/the-month-in-wordpress-march-2023/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13171:\"<p>March saw the arrival of the first major release of 2023, WordPress 6.2 “Dolphy.” Planning for the project&#8217;s 20th anniversary continues with new celebratory updates and commemorative swag. Read on for the latest happenings in the WordPress space.</p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Meet WordPress 6.2 “Dolphy”</h2>\n\n\n\n<p><strong><a href=\"https://wordpress.org/news/2023/03/dolphy/\">WordPress 6.2</a> “Dolphy” was released on March 29, 2023</strong>. Named after the acclaimed jazz multi-instrumentalist and composer<strong> </strong>Eric Allan Dolphy Jr., the latest version of WordPress further enhances the site editing experience with significant updates.</p>\n\n\n\n<p>Highlights include a reimagined Site Editor interface, a more intuitive way to manage menus, and a distraction-free writing mode. A new Block Inserter design adds integration with <a href=\"https://openverse.org/\">Openverse</a>, allowing you to easily browse and insert free, openly-licensed images and audio files into your content.</p>\n\n\n\n<img width=\"1024\" height=\"581\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/04/WordPress-6.2-highlight-grid.png?resize=1024%2C581&ssl=1\" alt=\"Feature highlights in WordPress 6.2: Reimagined Site Editor, more ways to manage menus, a more powerful inserter, faster access to media—yours and Openverse\'s, the new Style Book, distraction-free writing, and more.\" class=\"wp-image-14782\" />\n\n\n\n<p>Whether you&#8217;re a content creator, designer, or developer, WordPress 6.2 has something for you. <a href=\"https://wordpress.org/news/2023/03/dolphy/\"><strong>Check out the full announcement post</strong></a> for an overview of what&#8217;s new and the <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">Field Guide</a> for detailed developer notes.</p>\n\n\n\n<p>WordPress 6.2 is one of the last major releases planned for Phase 2 of the <a href=\"https://wordpress.org/about/roadmap/\">project’s development roadmap</a> and was made possible thanks to more than 600 contributors.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://make.wordpress.org/test/2023/02/07/help-test-wordpress-6-2/\"></a><a href=\"https://wordpress.org/download/\">Download WordPress 6.2 “Dolphy.”</a></p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">WP20 swag is here</h2>\n\n\n\n<p>Show your WordPress excitement with <strong>limited edition 20th anniversary merchandise</strong>—now available at the official <a href=\"https://mercantile.wordpress.org/product-category/wp20/\"><strong>WordPress Mercantile store</strong></a>. If you prefer to create your own swag, you can use these <a href=\"https://wp20.wordpress.net/download-the-wp20-commemorative-logos/\">WP20 downloadable assets</a>.</p>\n\n\n\n<img width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/04/digital-banner-1.png?resize=1024%2C576&ssl=1\" alt=\"Blue background with confetti and WordPress 20th anniversary commemorative logo.\" class=\"wp-image-14785\" />\n\n\n\n<p>The 20th anniversary website <a href=\"https://wp20.wordpress.net/wp20-celebrations/\">lists celebrations</a> as organizers announce and schedule them. Check back regularly to see if there’s an event in your area to join or <a href=\"https://wordpress.org/news/2023/03/lets-party-organize-your-wp20-celebration/\">help organize one</a> to celebrate this milestone with your local community.</p>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://wp20.wordpress.net/wapuu-coloring-giveaway-style-your-own-party-wapuu/\">Enter the Wapuu Coloring Giveaway</a> by April 17, 2023, for a chance to win some commemorative WP20 swag!</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">New in the Gutenberg plugin</h2>\n\n\n\n<p>Two new versions of the Gutenberg plugin have shipped in the last month:</p>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/03/13/whats-new-in-gutenberg-15-3-13-march/\"><strong>Gutenberg 15.3</strong></a><strong> </strong>was released on March 13, 2023. This version polishes the Site Editor experience, includes a new “Time to Read” block for displaying estimated read time to posts, and enhances the Duotone design tool.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/22/whats-new-in-gutenberg-15-4-22-march/\"><strong>Gutenberg 15.4</strong></a> is available for download as of March 22, 2023, and focuses primarily on bug fixes and testing improvements. Other additions include color and layout support for the Cover block, improved descriptions to help you understand the purpose of each template in the Site Editor, and the ability to turn paragraph blocks into columns.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p><a href=\"https://make.wordpress.org/core/2023/02/01/core-editor-improvement-strengthening-style-options/\"></a>Follow the “<a href=\"https://make.wordpress.org/core/tag/gutenberg-new/\">What’s new in Gutenberg</a>” posts to stay on top of the latest enhancements.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Team updates: Phase 3 planning, WordPress Developer Blog launch, and more</h2>\n\n\n\n<ul>\n<li>Gutenberg Lead Architect Matías Ventura <a href=\"https://make.wordpress.org/core/2023/03/24/phase-3-collaboration/\">outlined the focus areas</a> for Phase 3 of the WordPress development roadmap, known as <strong>Collaboration</strong> or <strong>Collaborative Editing</strong>.</li>\n\n\n\n<li>Last month, the <a href=\"https://wordpress.org/news/2023/03/introducing-the-wordpress-developer-blog/\">WordPress Developer Blog</a> officially launched (removing the &#8220;beta&#8221; label). <a href=\"https://developer.wordpress.org/news/#subscribe\">Subscribe</a> to keep up with the latest features, tutorials, and learning resources in the WordPress development space.</li>\n\n\n\n<li>The Documentation Team seeks volunteers to help with <a href=\"https://make.wordpress.org/docs/2023/03/15/call-for-volunteers-to-help-with-6-2-end-user-documentation/\">WordPress 6.2 end user documentation</a>.</li>\n\n\n\n<li>Are you looking to broaden your knowledge and improve your WordPress skills? See <a href=\"https://make.wordpress.org/updates/2023/04/01/whats-new-on-learn-wordpress-in-march-2023/\">what’s new on Learn WordPress in March 2023</a>, including the latest course on <a href=\"https://learn.wordpress.org/course/converting-a-shortcode-to-a-block/\">Converting a Shortcode to a Block</a>.</li>\n\n\n\n<li>A new <a href=\"https://make.wordpress.org/themes/2023/03/03/hallway-hangout-community-themes-initiative/\">Community Themes initiative</a> aims to bring together a group of contributors to collaborate and build block themes.</li>\n\n\n\n<li>The Training Team is looking for assistance in creating content to complete <a href=\"https://make.wordpress.org/training/2023/03/29/introduction-to-wordpress-development-syllabus/\">this WordPress Development syllabus</a>.</li>\n\n\n\n<li>The newly formed Contributor Working Group <a href=\"https://make.wordpress.org/community/2023/03/23/recap-of-contributor-working-group-inaugural-mentorship-chat-on-march-20-2023/\">hosted an inaugural chat</a> to kick off work on the <a href=\"https://make.wordpress.org/project/2023/02/06/proposal-creating-a-wordpress-contributor-mentorship-program/\">WordPress Mentorship Program</a>.</li>\n\n\n\n<li>The Polyglots Team is <a href=\"https://make.wordpress.org/polyglots/2023/03/29/adding-chatgpt-and-deepl-in-the-translation-memory/\">testing AI systems</a> to help with translation work.</li>\n\n\n\n<li>The WordPress.org redesign project has a new dedicated Making WordPress Slack channel to coordinate work: <a href=\"https://wordpress.slack.com/archives/C04U953K77A\">#website-redesign</a>.</li>\n\n\n\n<li>The March 2023 editions of the <a href=\"https://make.wordpress.org/polyglots/2023/03/15/polyglots-monthly-newsletter-march-2023/\">Polyglots monthly newsletter</a> and the <a href=\"https://make.wordpress.org/community/2023/03/21/meetup-organizer-newsletter-march-2023/\">Meetup Organizer newsletter</a> are available for reading.</li>\n\n\n\n<li>The Mobile Team announced a <a href=\"https://make.wordpress.org/mobile/2023/03/28/new-mobile-support-forum/\">new support forum</a> for the WordPress mobile app.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Tune in to <a href=\"https://wordpress.org/news/2023/03/episode-52-phase-three-with-hector-prieto/\">Episode 52 of WP Briefing</a> to learn more about the visioning behind Phase 3, Collaboration.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Feedback &amp; testing requests</h2>\n\n\n\n<ul>\n<li>A new Full Site Editing (FSE) Program exploration looks into the Site Editor as a design tool in light of the recent WordPress 6.2 release. Participants are asked to create a block theme without coding using the current editor tools. <a href=\"https://make.wordpress.org/test/2023/03/29/fse-program-exploration-build-a-block-theme/\">Share your experience</a> by April 26, 2023.</li>\n\n\n\n<li>A group of Core contributors is working on a new <a href=\"https://make.wordpress.org/core/2023/03/30/proposal-the-interactivity-api-a-better-developer-experience-in-building-interactive-blocks/\">Interactivity API proposal</a> to provide a better developer experience for building interactive blocks.</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/03/25/mobile-team-update-march-25th/\">Version 22.0</a> of the WordPress mobile app for iOS and Android is ready for testing.</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Members of the Core Team are looking for user experience (UX) feedback on the <a href=\"https://make.wordpress.org/core/2023/03/28/call-for-testing-plugin-dependencies-ux/\">Plugin Dependencies feature plugin</a>.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress events updates</h2>\n\n\n\n<ul>\n<li>WordCamp Asia 2024 is <a href=\"https://asia.wordcamp.org/2024/\">calling for organizers</a>. Apply by April 15, 2023.</li>\n\n\n\n<li>Registration for the <a href=\"https://europe.wordcamp.org/2023/contributor-day-registration-is-now-open/\">WordCamp Europe 2023 Contributor Day</a> is now open.</li>\n\n\n\n<li>Want to create diverse and inclusive WordPress events? Mark your calendars for the upcoming <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/diversity-speaker-training-workshop/#upcoming-wpdiversity-workshops\">#WPDiversity workshops</a>.</li>\n\n\n\n<li>Four WordCamps are taking place this month:\n<ul>\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1ee-1f1f9.png\" alt=\"🇮🇹\" class=\"wp-smiley\" /> <a href=\"https://torino.wordcamp.org/2023/\">WordCamp Torino</a>, Italy, on April 14-15, 2023</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e6-1f1f9.png\" alt=\"🇦🇹\" class=\"wp-smiley\" /> <a href=\"https://vienna.wordcamp.org/2023/\">Wordcamp Vienna</a>, Austria, on April 15-16, 2023</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1eb-1f1f7.png\" alt=\"🇫🇷\" class=\"wp-smiley\" /> <a href=\"https://paris.wordcamp.org/2023/\">WordCamp Paris</a>, France, on April 21, 2023</li>\n\n\n\n<li><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f1e7-1f1ec.png\" alt=\"🇧🇬\" class=\"wp-smiley\" /> <a href=\"https://sofia.wordcamp.org/2023/\">WordCamp Sofia</a>, Bulgaria, on April 22-23, 2023</li>\n</ul>\n</li>\n</ul>\n\n\n\n<blockquote class=\"wp-block-quote has-extra-large-font-size\">\n<p>Join WordPress Executive Director Josepha Haden Chomphosy as she discusses <a href=\"https://wordpress.org/news/2023/03/episode-51-is-routine-a-rut/\">the benefits of routine and what role it plays in the WordPress project</a>.</p>\n</blockquote>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator has-text-color has-light-grey-color has-alpha-channel-opacity has-light-grey-background-color has-background\" />\n\n\n\n<p><strong><em><strong><em><strong><em>Have a story we should include in the next issue of The Month in WordPress? <strong><em>Fill out </em></strong><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><strong><em>this quick form</em></strong></a><strong><em> to let us know.</em></strong></em></strong></em></strong></em></strong></p>\n\n\n\n<p><em><em>The following folks contributed to this Month in WordPress: <a href=\"https://profiles.wordpress.org/bsanevans/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>bsanevans</a>, <a href=\"https://profiles.wordpress.org/cbringmann/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>cbringmann</a>, <a href=\"https://profiles.wordpress.org/eidolonnight/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>eidolonnight</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rmartinezduque</a>, <a href=\"https://profiles.wordpress.org/sereedmedia/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sereedmedia</a>.</em></em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Apr 2023 10:30:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"rmartinezduque\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Do The Woo Community: BobWP is Speaking at WordCamp Lisboa\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=74701\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://dothewoo.io/bobwp-wordcamp-lisboa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:318:\"<p>BobWP will be speaking about community at WordCamp Lisboa 2023.</p>\n<p>&gt;&gt; The post <a rel=\"nofollow\" href=\"https://dothewoo.io/bobwp-wordcamp-lisboa/\">BobWP is Speaking at WordCamp Lisboa</a> appeared first on <a rel=\"nofollow\" href=\"https://dothewoo.io\">Do the Woo - a WooCommerce Builder Community</a>	.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Apr 2023 10:22:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: WooCommerce to Host Virtual Contributor Day April 19, 2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143218\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/woocommerce-to-host-virtual-contributor-day-april-19-2023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2157:\"<p>WooCommerce has announced a 24-hour virtual contributor day that will happen on April 19, 2023. Contributors will be working on the <a href=\"https://github.com/woocommerce/woocommerce\">WooCommerce Core</a> and <a href=\"https://github.com/woocommerce/woocommerce-blocks\">WooCommerce Blocks</a> repositories. To give better coverage over time zones, organizers will have two kickoff times (0 UTC and 12 UTC).</p>\n\n\n\n<p>WooCommerce hasn&#8217;t had a WooConf in-person conference since 2017, opting instead for virtual events like WooSesh where people can attend and watch presentations for free. The open source project has focused more on virtual communication channels to help contributors stay connected, such as the new <a href=\"https://wptavern.com/woocommerce-to-launch-wc-blocks-extensibility-monthly-chat\">monthly chat focused on WooCommerce block extensibility</a>. This virtual contribution day will be the first of its kind for WooCommerce. </p>\n\n\n\n<p>&#8220;We are asking for a minimum of 4 hours of your time to dedicate to a curated list of issues,&#8221; WooCommerce developer advocate Stephanie Pi said. &#8220;These issues have been selected based on the effort needed to solve them –we’re only including issues that we believe can be solved within the day.</p>\n\n\n\n<p>&#8220;Any issues picked up and worked on during contributor day will be merged before the next release.<strong> </strong>We are committed to making sure this happens because we want to honor the time our community is dedicating to this event.&#8221;</p>\n\n\n\n<p>The virtual event will be a more intense, focused time than what one might experience at a WordCamp contributor day, with key WooCommerce decision makers present to help keep things moving.</p>\n\n\n\n<p>Organizers will be creating new channels in the <a href=\"https://woocommercecommunity.slack.com/\">WooCommerce Community Slack</a>, that will be dedicated to the different issues they plan to work on during the 24-hour event. This includes a channel for helping contributors get set up with a development environment. Those interested to attend can watch for updates in the #announcements channel.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 01 Apr 2023 01:02:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WordPress Contributors Propose New Interactivity API for Frontend Blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143152\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/wordpress-contributors-propose-new-interactivity-api-for-frontend-blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6558:\"<p>Over the past year a group of WordPress contributors have been <a href=\"https://make.wordpress.org/core/2022/04/27/exploration-to-enable-better-developer-and-visitor-experiences-with-blocks/\">working</a> on making it easier for developers to build interactive blocks. These are the kinds of experiences that allow visitors to submit a form and get feedback without reloading the page, load paginated content without refreshing, and improve e-commerce stores with more dynamic responses based on visitor interaction. </p>\n\n\n\n<p>A new <a href=\"https://make.wordpress.org/core/2023/03/30/proposal-the-interactivity-api-a-better-developer-experience-in-building-interactive-blocks/\">proposal for an Interactivity API</a> aims to provide a standard way for developers to add interactivity to the frontend, making it faster to build these experiences without reinventing the wheel every time. </p>\n\n\n\n<p>Automattic-sponsored core contributor Mario Santos cast the vision for what the new API will deliver: </p>\n\n\n\n<blockquote class=\"wp-block-quote\">\n<p>What if effortlessly creating performant, fluid, and idiomatic frontend interactivity on block-based WordPress sites was possible? Imagine plugins providing interactions like “heart this post” or “add to cart” without page reloads. Picture instant search, commenting, and native full-page transitions as best-in-class built-ins without complex scaffolding or external tools. Envision achieving this in any block theme by default without sacrificing PHP server rendering and the plugin ecosystem for a JS runtime. Visualize block developers easily declaring and extending such behaviors in a way that is immediately familiar and compatible with the block ecosystem.</p>\n</blockquote>\n\n\n\n<p>Santos published a demo video accompanied by a <a href=\"https://wpmovies.dev/\">live interactive demo</a> where visitors can favorite movies and have the favorite count instantly updated in the block in the header. Pagination and search update the content without refreshing the page. The code for the demo is <a href=\"https://github.com/WordPress/wp-movies-demo\">available on GitHub</a>.</p>\n\n\n\n\n\n\n\n<p>The Interactivity API is being created for use on the frontend of block-based websites but contributors may also explore the possibility of reusing some of its directives inside the editor. They are taking a similar approach to <a href=\"https://alpinejs.dev/\">Alpine.js</a> with &#8220;directives&#8221; that extend HTML with special attributes, except designed specifically for WordPress and backwards compatible with its APIs. </p>\n\n\n\n<p>&#8220;The API is designed for the world of blocks and takes WordPress history of being closely attached to web standards to heart,&#8221; Santos said.</p>\n\n\n\n<p>&#8220;As directives are added to the HTML, they work great with dynamic blocks and PHP.&#8221;</p>\n\n\n\n<p>Having a standard in place means that WordPress developers don&#8217;t have to roll their own solutions for things like tooling, inter-block communication, and frontend performance. They would be primarily responsible for the block logic, making creating interactive blocks easier and more approachable for less experienced developers.</p>\n\n\n\n<p>Contributors on the project have selected <a href=\"https://preactjs.com/\">Preact</a> to build the directives system due to its HTML-friendliness, small size, performance, extensibility, and compatibility with React.</p>\n\n\n\n<p>The Interactivity API is currently in the stage of gathering feedback to incorporate in development as well as expanding technical documentation. </p>\n\n\n\n<p>&#8220;Although it is now distributed as a plugin, it aims to be added as an experimental feature to Gutenberg,&#8221; Santos said. &#8220;The goal is to include it in Core once enough feedback has been gathered, and it’s clear that it’s the right direction.&#8221;</p>\n\n\n\n<p>Initial reactions to the proposed API have been mostly positive, as developers have previously had to build their own solutions for interactivity in the absence of a standard.</p>\n\n\n\n<p>&#8220;The Interactivity API is one of the most interesting proposals for WordPress frontend UX &amp; DX that I&#8217;ve seen in awhile,&#8221; WordPress Core contributor Weston Ruter <a href=\"https://twitter.com/westonruter/status/1641521738805809152\">said</a>.</p>\n\n\n\n<p>&#8220;As someone who has been experimenting a lot with using AlpineJS, HTMX, Unpoly, StimulusJS, etc. for interactivity on the frontend, having a blessed solution in WP core would be most welcome,&#8221; another developer (@r1ckd33zy) <a href=\"https://twitter.com/r1ckd33zy/status/1641573350701948928\">commented</a>.</p>\n\n\n\n<p>WordPress developer and WPGraphQL contributor David Levine seemed less enthused about the approach outlined in the proposal. &#8220;Great idea but shortsighted execution,&#8221; Levine said. &#8220;We need an actual block data layer, not to further pollute our markup for our scripts to parse. This just exacerbates the same problems that got us into this mess.&#8221;</p>\n\n\n\n<p>A few others in the comments of the post have been critical of the approach and  others have questions about long term challenges of maintaining this approach.</p>\n\n\n\n<p>&#8220;This is a pretty out-there which is quite a different approach to anything I’ve seen before,&#8221; WordPress core contributor Joe Hoyle said. &#8220;That does give me caution, as it’s very wp specific / centric. I think with the block editor there’s opportunity to align more with industry innovation around front-end tooling. I think it’s really great work and very creative; but again I’m not yet sure it’s the right direction. It could be that there’s no long term solution to bring an &#8216;nextjs&#8217;-ification to WordPress, but I’m not sure I’m looking at it.&#8221;</p>\n\n\n\n<p>The proposal includes examples of how to create interactive blocks using the API and developers have opened a lively discussion on the approach. Contributors on the Interactivity API are planning to host two sessions on April 17, 2023 (<a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/292575913/\">one at 08:00UTC</a> and <a href=\"https://www.meetup.com/learn-wordpress-online-workshops/events/292575942/\">another at 17:00UTC</a>) that will include a live product demo followed by a Q&amp;A. Check out the proposal for more details and the <a href=\"https://github.com/WordPress/block-interactivity-experiments\">Interactivity API GitHub repo</a> to see some experiments the team has been working on so far.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 Mar 2023 14:48:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Post Status: Launching a WordPress Product in Public: Session 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=148593\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://poststatus.com/launching-a-wordpress-product-in-public-session-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:60603:\"<div class=\"is-layout-flow wp-block-group eplus-wrapper has-theme-palette-2-color has-theme-palette-8-background-color has-text-color has-background\"><div class=\"wp-block-group__inner-container\"><div class=\"wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\">In this episode, <a href=\"https://twitter.com/coreymaass\">Corey Maass</a>, a freelance web developer, joins <a href=\"https://twitter.com/corymiller303\">Cory Miller</a> to discuss the intricacies of creating an impactful, user-appreciated product that makes a positive impact on customers and stands apart in a saturated industry. </p></div>\n\n\n<div class=\"wp-block-spacer eplus-wrapper\"></div>\n\n\n\n<p class=\"yoast-reading-time__wrapper\"><span class=\"yoast-reading-time__icon\"></span><span class=\"yoast-reading-time__spacer\"></span><span class=\"yoast-reading-time__descriptive-text\">Estimated reading time:  </span><span class=\"yoast-reading-time__reading-time\">34</span><span class=\"yoast-reading-time__time-unit\"> minutes</span></p>\n</div></div>\n\n\n\n\n\n\n\n<p><a href=\"https://poststatus.com/planet/feed/#h-transcript\">Transcript</a> ↓</p>\n\n\n\n<p>Learn from <a href=\"https://twitter.com/coreymaass\">Corey Maass</a>, the go-to on WordPress product design topics, and <a href=\"https://twitter.com/corymiller303\">Cory Miller</a>, a master on the business of WordPress. They discuss finding the balance in the small and big pictures of product development, highlighting the process of trial and error.</p>\n\n\n\n<p><strong>Top Takeaways:</strong></p>\n\n\n\n<ul>\n<li><strong>Courage Under Fire.</strong> After what feels like a miserable failure, it’s vital to keep trudging forward. Great product design takes time to build and grow in the space you are putting it into. Keeping your passion alive and remaining consistent in your efforts will eventually lead you to success.&nbsp;</li>\n\n\n\n<li><strong>The Impact of Thoughtful Design.</strong> Developing a product is, of course, based on meeting some kind of user need, but it’s important to consider if you are going to make that user’s life easier with your product. When the end user is your top priority, your product will shine, and you’ll be proud of your direct impact on someone’s everyday life. </li>\n\n\n\n<li><strong>Finding the Spark in Your Product.</strong> Focusing on the overall product journey is key for great product development, but zooming in on the minor details is equally important. Brainstorming and finding the spark is not easy, but setting your product apart from the rest is crucial. </li>\n\n\n\n<li><strong>Using Your Audience to Improve Development</strong>. Put your ideas and questions out there for your audience to speak to. If you are wondering how people will perceive a certain product aspect or want more information on their exact pain points, it’s good to ask directly. Getting information straight from your customers or peers can help you make well-informed decisions in product development.</li>\n</ul>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-mentioned-in-the-show\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f517.png\" alt=\"🔗\" class=\"wp-smiley\" /> Mentioned in the show:</h3>\n\n\n\n<ul>\n<li><a href=\"https://crop.express/\">Crop.Express</a></li>\n\n\n\n<li><a href=\"https://www.google.com/aclk?sa=l&ai=DChcSEwiIyKyw6PL9AhVlyZQJHT6EAcYYABAKGgJ5bQ&ei=bawcZJe0G8epqtsPivSAqA8&sig=AOD64_0_PN97hzZ3jYMLTv3M0suhf9h2Ag&q&sqi=2&adurl&ved=2ahUKEwjXnqSw6PL9AhXHlGoFHQo6APUQ0Qx6BAgKEAE\">StickerMule</a></li>\n</ul>\n\n\n\n<h3 class=\"eplus-wrapper\" id=\"h-you-can-follow-post-status-and-our-guests-on-twitter\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> You can follow Post Status and our guests on Twitter:</h3>\n\n\n\n<ul class=\"eplus-wrapper\">\n<li><a href=\"http://twitter.com/coreymaass\">Corey Maass</a></li>\n\n\n\n<li><a href=\"https://twitter.com/corymiller303\">Cory Miller</a> (CEO, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n\n\n\n<li><a href=\"https://twitter.com/lemonadecode\">Olivia Bisset</a> (Intern, <a href=\"https://twitter.com/post_status\">Post Status</a>)</li>\n</ul>\n\n\n\n<p class=\"eplus-wrapper has-background\">The <strong>Post Status Draft</strong> podcast is geared toward WordPress professionals, with interviews, news, and deep analysis. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4dd.png\" alt=\"📝\" class=\"wp-smiley\" /><br /><br /><a href=\"https://poststatus.com/category/post-status-podcasts/\" target=\"_blank\" rel=\"noreferrer noopener\">Browse our archives</a>, and don’t forget to subscribe via <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\" target=\"_blank\" rel=\"noreferrer noopener\">iTunes</a>, <a href=\"https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5zaW1wbGVjYXN0LmNvbS8ySkU5c2M4UA\" target=\"_blank\" rel=\"noreferrer noopener\">Google Podcasts</a>, <a href=\"https://www.youtube.com/c/PostStatus\" target=\"_blank\" rel=\"noreferrer noopener\">YouTube</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\" target=\"_blank\" rel=\"noreferrer noopener\">Stitcher</a>, <a href=\"https://wordpress-post-status-draft-podcast.simplecast.com/\" target=\"_blank\" rel=\"noreferrer noopener\">Simplecast</a>, or <a href=\"https://feeds.simplecast.com/2JE9sc8P\">RSS</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /></p>\n\n\n\n<h2 class=\"eplus-wrapper\" id=\"h-transcript\">Transcript</h2>\n\n\n\n<h2>Session 7 Corey & Cory Launch a WordPress Product Live</h2>\n\n\n\n<p>Corey Maass: [00:00:00] So now I\'m following along. I\'ve gotten in the habit of. I opened the<br />YouTube, which is, well, it\'s live, which is really disorienting cuz of course I\'m talking, uh, 10<br />seconds ago or 10 seconds in the future. And then grab the chat and then close it as fast as I<br />can,<br />because it seems that people do ask us questions, but mostly on YouTube, not on, uh, the<br />webinar, the Zoom webinar.<br />Cory Miller: Um, sorry, I was just trying to get all that going. Um, yeah, speaking of what we\'re<br />talking about today in the marketing channel with post status, there\'s some good conversations<br />about product. Hmm. I was like, you know, there\'s enough of this going around that we, um,<br />should we have more conversations about product and marketing.<br />And [00:01:00] channels.<br />Corey Maass: Um, I have to go find, I\'ve got, um, I\'m in product owner and I\'m in a couple of<br />others, but I\'m not in marketing. Oh, okay. You\'re already in here. Yeah. Product leaders I\'m in.<br />Cory Miller: Yeah. Um, I really want that product leaders channel to. This type of, you know,<br />conversation, whatever it has to do with product, you know?<br />Right.<br />Corey Maass: So, yeah, and it\'s, I mean, it\'s a popular topic. Like I, I was on Twitter five<br />minutes ago and somebody was asking like, who is marketing WordPress plugins? Well these<br />days? And of course was scrolling the answers to see who to follow or what examples to look at,<br />or, you know, there\'s, I mean, a few known quantities.<br />Um, and articles and, and references and stuff, but well, you know, [00:02:00] year to year and,<br />and new products that will cause blips and, and whatnot. Yeah. Um, you know, because it\'s<br />definitely still not a. You know, not a known thing. I mean, marketing anything is not, is never<br />necessarily reliable. But, uh, marketing a WordPress plugin.<br />There are people who are very successful with WordPress plugins, but I don\'t know that the<br />marketing is, it\'s not a solved problem. You know,<br />Cory Miller: I think we said this a lot, but I really love product. Um, but it feels like. Almost like<br />gambling, you know? Um, like this one, I continue to see there\'s something here and we say<br />this, we don\'t know what it is and we\'re trying to kinda keep stepping into it.<br />But gosh, I\'ve tried a bunch of products between I themes and today, you know, bunch of<br />different things. And they weren\'t like [00:03:00] pure software products of course. Um, but.<br />Every time I talk about product, I realize how much I have to learn .<br />Corey Maass: Um, so there\'s, um, they\'re the people who I, I\'m not gonna even try to mention<br />names, but it\'s like, there are, there are people who are famous for breaking the land speed<br />record, you know, or the like, uh, What was his name?<br />Hopkins was in the, a movie called The Indian, and it was his, about his motorcycle or you know,<br />there\'s nascar, like there\'s the people who win over year, over year. And, and then there\'s,<br />there\'s gotta be the people who were fascinating, you know, they, they worked a, a regular job<br />and they spent every night and weekend working on, you know, Build, trying to build the fastest<br />[00:04:00] race car or the fastest motorcycle and, and have absolutely died in obscurity, , you<br />know, like, they just never, they d take a, take a motorcycle out to the flats, crash it, start over<br />again, you know, and, and have done it.<br />Or did it, you know, for 30 years or whatever, and, and we\'re never gonna hear about any of<br />those people, you know, or they consistently came in third and we\'re never gonna hear about<br />any of those people. Yeah. And it\'s like, I\'m a while ago, I had to th there was a time in my life<br />where I was absolutely convinced that I was going to be a rockstar dj, where I was going to be<br />the gazillion.<br />Uh, entrepreneur or, and I still would love to be all those things. Well, I don\'t know if I have the<br />energy anymore, but Me too. Um, you know, um, but it, they were, they were tied into my<br />identity and they were like constant. You know, a need and would keep me up at night. And now<br />I\'m like, I [00:05:00] have, I think part of middle age is accepting your mediocrity.</p>\n\n\n\n<p>Um, and, and just going, you know, okay, if, if I\'m, if I\'m successful, if I\'m having some fun and<br />I\'m successful enough that I\'m not, Uh, starving, you know, then, then that\'s then and, and then<br />it\'s fun to keep trying, you know, and, and on my deathbed, it, it\'s still probably gonna hurt that I<br />didn\'t, you know, uh, headline, uh, you know, some huge music festival or something, but, uh,<br />but at least I tried, I suppose<br />Cory Miller: I, I love that. Thank you for sharing that. Um, you know, because I, I totally. , um, in<br />so many ways. I feel like I had my time. Mm-hmm. , you know, I got my opportunity and I made,<br />I made the most of it. I\'m, I\'m proud of it, you know, uh, and that, that was a [00:06:00] very<br />magical period for me. You know? But when you\'re talking, have you seen the Netflix?<br />It made me think of the Netflix special full swing. It\'s about golf. So, I know you golf. I don\'t, I put<br />putt golf, you know, but, um, even though we have a son named Callaway, everybody thinks we<br />named it after a golf club. And I\'m like, no, sorry, , um, him out after a golf club. But, okay, so this<br />last episode, there\'s a guy, and you may name, you may know his name, and I\'m like, I, if, if<br />there were jerseys in golf, I\'m not a.<br />I would go buy his jersey today. He\'s like the 70th best. Mm-hmm. golfer in the world. His name<br />is Joel Drum. I can\'t remember. I\'ll f I\'ll find his name. So the first episode, have you seen this?<br />Mm-hmm. . Okay. You, I think you\'d be interested. I\'m like you said. Full swing. Full swing. It\'s a<br />documentary about the [00:07:00] PGA.<br />I\'m morbidly curious about sports because I think it has so many parallels. Anyway, so the first<br />two were like, the brand names Justin Thomas, uh, Jordan Sp, and now I know those names<br />well, but I was familiar with their names. Sure. And like they\'re at the top pinnacle of the sport.<br />Then the third episode is, is is Joel, and he\'s basically like, I\'m okay being seven.<br />like he\'s got immense talent. Um, his caddy, everybody\'s like, no, he\'s a top 30 golfer. And he\'s<br />just kinda like, you know, he\'s, he could be like, he won, he\'s won, but like, he could be even<br />better. But he\'s just like, k he feels like almost resigned contend of being like 70th. And I. Maybe<br />I\'m okay being like 500th best or five thousandths best at being an entrepreneur, being a<br />product person, right?<br />Um, [00:08:00] I am morbidly attracted to entrepreneurship and product. Like I think you and I<br />resonate with this. Like every time I hear you talk, man, I would go. Rather from another mother,<br />like he, you know,<br />Corey Maass: I could have said those words or have had or have said those words. Yeah,<br />exactly.<br />Cory Miller: But I think there\'s something resonating here, Corey.<br />It\'s the esteem that I, I\'m gonna talk by myself. The esteem I might talk about, like iconic,<br />everybody says it, Steve, let me invoke his name. Steve Jobs right now, first time around, I<br />think. Right time, right place, and of course genius, you know, but right time, right place, right.<br />Critical thing got kicked out of Apple, comes back and doing it again, and we always talk about<br />him.<br />Right. You know, maybe, maybe Elon Musk in my mind before he started doing, just, I don\'t<br />know. Um, he, I think he went too far. He overreach. But anyway, but I go, God, [00:09:00] I\'d<br />love to have that kind of genius for product for. and, but selling down in Maine, like you were<br />saying about middle, middle age and Meoc, just going, Hey, I think I got some talent , you know,<br />but mainly I just work my ass off.<br />Mm-hmm.<br />Corey Maass: I\'m one of those, try things and try things.<br />Cory Miller: I feel like one of those sports players, like if we use that metaphor analogy,<br />whatever it is, and I. Never gonna be number one. Mm-hmm. never gonna be top 50. But for my<br />brand of those, I\'m really content with who I am. You know? Right. Even though I\'m just like,<br />God, it feels like with product it\'s miserable Failure.<br />Miserable failure. Miserable failure. Miserable failure. When 2008, man, I felt like I\'m gonna mix<br />all these sports things, get up to the plate, ball\'s coming, [00:10:00] and I hit it. And I get into the<br />field<br />Corey Maass: and you scored a touchdown<br />Cory Miller: and . Yes. And a hole in one and you know, let me find another sport so I can do it.<br />But you don\'t end up in the gutter.<br />I think the reality is, yeah, , I need bumpers for my bowling entrepreneur, bowling, and there you<br />go. Product person. I need some bumpers. I feel like sometimes, and I\'m glad I. I couldn\'t laugh</p>\n\n\n\n<p>about this a couple years ago at all. Hmm. I\'d be like, what? I have magic. I\'m supposed to be<br />magic. I\'m supposed to come.<br />Right. You know, and then you\'re like, maybe not . It\'s the humbling effect of that. Yep. And I<br />think when you come down to it, you go, I think the reason why I\'m so interested in product is<br />like it\'s a gift. It should be like this cool gift that you\'re trying to help someone. Make somebody\'s<br />life better and in the process be [00:11:00] able to do it vocationally and get paid for it.<br />Yeah. And man, I love that about work, you know, and products specifically is like tie to this little<br />bow, here\'s your present and I\'m trying to get better about this is I\'m trying to offer a gift that you<br />pay for. Of course. You know, like those win-win things. But I digress.<br />Corey Maass: Yeah, it\'s, I love solving a problem.<br />I love the, like, this is gonna sound weird, but I love the angles of it. Like the, uh, moving through<br />a problem, uh, like screens and inner, like, I, I want to feel clever for having built it, like build a<br />better mouse trap. But I also want, that\'s a bad analogy cuz a mouse, mouse uses a mouse<br />trap. But it\'s like, I, I wanna build, you know, the, the better.<br />Thing that other people then get pleasure out of using to, again, to [00:12:00] solve a problem.<br />Um, and so then I feel smart. And they feel smart. And, and it\'s like, to me it\'s, it\'s one of the<br />epitome of the human condition is, is solving problems, is manipulating the space around us.<br />And, um, and so yeah, product just absolutely.<br />Resonated with me early on. Which is funny because I think I, and a lot of, a lot of developers<br />and a lot of product people also are passionate about music in one way or another, which is the<br />opposite. It\'s so abstract. It can mean anything to anybody. It\'s totally subjective, uh, as opposed<br />to like, In the world we live in, like there\'s a little bit of subjectivity.<br />Like there\'s, you know, there\'s a reason why there\'s a million to-do list apps because everybody<br />solves it slightly differently or wants it to feel slightly different. But it\'s still, uh, you know, there\'s<br />still ones that objectively don\'t [00:13:00] work. , uh, uh, But anyway. Yeah, it\'s, it\'s, it\'s fun. It\'s<br />interesting.<br />It\'s, I\'m glad that it\'s now a hobby rather than, uh, something that I, that I\'m relying on. Cuz I<br />remember building, I think I\'ve talked about this before, like, I remember building things because<br />I was like, I\'m not gonna make rent if this doesn\'t succeed. And of course it didn\'t come close to<br />succeeding. I don\'t even think I was able to finish it cuz it was like, I can\'t make a logical<br />decision.<br />From a position of desperation, like some people can mm-hmm. , but I just, I can\'t, I have to like<br />sit in it and splash around. Which is also why, because I think maybe it was another Twitter<br />conversation I was having, but, um, I, I often. Will. Oh, so yeah, somebody, somebody asked<br />like, do you, do you do any planning or do you jump right in?<br />I\'m like, I a hundred percent jump right in, just like you, you keep saying like, there\'s something<br />here. I often jump right in when I just, my gut [00:14:00] tells me that there\'s something here<br />and, uh, Because I\'m finding, and this is, I was noticing this again over the weekend. Um, the<br />setting screen that I wanna show you is like, I had to start building the setting screen in order for<br />me to go, oh, no, this setting isn\'t right, or, we don\'t need this, or This is better organized a<br />different way.<br />But I had to like, and I suppose I could put pen to paper and come to the sum of the same<br />conclusions, but for me, pen to paper is usually writing. You know, some, some aspect of code<br />to, so that I\'m clicking on a button or I\'m, I\'m starting to fill in a screen or I\'m even at this point, I<br />can just look at a screen and be like, no, this isn\'t what we need, or this isn\'t intuitive, or, um, no.<br />With that said, what I\'ve designed is quite ugly. Um, I was futzing around. Information<br />architecture, and I don\'t know why I was bothering, it was Sunday. I was having fun. Um, but<br />anyway, yeah, it\'s, uh, there\'s, [00:15:00] there\'s definitely a difference of, of, for me anyway, like<br />getting in and actually clicking on things.<br />Cory Miller: It\'s uh, when you say, when you said hobby, it reset me back to me going, is this,<br />should this really be a hobby for me? You know? Hmm. Um, cuz. I gotta tell you, I\'ve, I<br />presented my business group about a week or two ago, and I was like, yeah, I don\'t know. I<br />don\'t know if I keep going. You know, back to middle age mediocrity, whatever it is, it\'s like, I,<br />you know, we\'re trying to do some things with post status and it\'s been one frustration after the<br />other hitting walls.</p>\n\n\n\n<p>I think that\'s starting to loosen up, maybe with my own growth, you know? Okay. But like, just<br />trying to make progress on stuff where I had a team previously and now we\'re trying, you know,<br />put stuff together. But that\'s the bigger business. But down product too is like, you know, I think<br />there was a hope in me that you launch it and everybody\'s like, hell yes.[00:16:00]<br />You know? Yeah. There\'s more to it, you know? I just wanted people to instantly love it.<br />Corey Maass: Well, and starting from scratch is freaking hard. I mean, you were, you were on<br />a, a winning team. You were, you know, you were on a, a bus with a group of people. You\'d built<br />the bus. You got the bus moving, and then you were hurling down the highway successfully.<br />And it\'s real easy to forget that, like, oh, right. When we were building the bus, nobody cared.<br />And when the bus, the wheels first started moving, nobody cared. Now they do. And so yeah, if<br />you are, you know, leveraging something, if you\'re building a trailer onto a bus that\'s already<br />moving, that\'s different than getting off the bus, chilling for a couple of years and then starting to<br />build another bus, you know?<br />Weird, weird analogy, but ,<br />Cory Miller: no, no, no. I like the bus thing cuz that\'s how it was. I was like, I. I don\'t, I get credit,<br />but I try not to ever take it and [00:17:00] be sure to point it in other ways. Like it was very much<br />a band back to music. I like, this is like, we\'re a band that makes great music together. You<br />know, somehow it\'s working, you know?<br />Yeah. And I can\'t really take credit for a lot of that. I was, don\'t get me wrong, I contributed, I<br />impacted it, but it was a magic of. Yeah, things flying together with it. And I think I\'ve been trying<br />to ree that magic, you know, particularly with product. Um, but the word that comes up for me,<br />and I\'m curious what your thoughts about this are, like de detachment, detachment from my<br />brilliant ideas, Corey, like, man, I\'m very attached to my brilliant ideas, you know, and like here I<br />go.<br />How to detach from that pride aspect and then go just kinda lean into like passion and interest,<br />which is what your pace and how you [00:18:00] approach This has been really healthy for me<br />because you\'re kinda like, I\'m having fun doing it today. I\'m having it and then tomorrow having<br />fun doing it and it. It\'s, it\'s taking some box for you.<br />And I\'m like, I need to be just okay with like, it\'s taking a box for me. Now when I am working<br />with a developer partner, , I\'m like, I wanna talk to you about filters. I wanna talk to you about all<br />these things. Cuz like I had, like all the stuff that we could do with images. I\'ve been planning<br />around with stuff and wanting, been wanting to go like, you know, Instagram revolutionized<br />photos, for instance.<br />I think it, it took the iPhone or the smartphone, whatever it is, and made most anybody a pretty<br />decent photographer, right? Like, you know, Photoshop, you could do the Gazi blur and you can<br />kind of filter and like make things a little like correct stuff with Instagram. I did that and I\'m like, I,<br />I love that.<br />I love taking photos. I\'ve been taken. [00:19:00] So this is a weird sidebar onto the product by.<br />But I\'ve been, um, you know, there\'s those cartoon apps that\'ll take a photo and make a cartoon<br />of it. Yep. I\'m a freaking geek about cartoon illustration, all that stuff. So what I\'ve been doing,<br />this is gonna lead back to product, by the way, an actual question on our product future.<br />And you can say, Hey, can we pause that? Can we hold that later? But, so I\'ve been taking, I<br />love taking pictures of sunsets, you know, and I. So I\'ve been taking my sunset pictures and<br />putting \'em into my cartoon app. . Mm-hmm. nice. Yeah. And making these really things. But the<br />premise here was, you know, back to our philosophical conversations about images and the<br />web and on a website, and I go, you know, with ai, there\'s a, that mix in there too, but I go, that\'s<br />interesting to me.<br />Like for, for, for our product perspective is like, there\'s cool things going on. I think we could be<br />creative and innovate downstream a bit in this [00:20:00] market. While I\'m kinda like really<br />impatient, but trying to be patient about getting to the stage of like, I want somebody to pay for<br />it. I want somebody to give some validation to go, okay, should we put a little bit more time and<br />effort and money into this?<br />You know? Right. But anyway, the filtered conversation was where I\'ve been going as we\'ve<br />been talking, going man, You would know, but like are there libraries and stuff that we can do<br />filters or something different to make things just a little nicer in the pro side? Yeah, that I just<br />freaking love, like I\'m such a geek Corey about that.</p>\n\n\n\n<p>But I take my picture and then I share it over to whatever the tune app is and I really like, I don\'t<br />know, it\'s kind of fun. There\'s gotta be . I can\'t help, this is my idealism. There\'s gotta be<br />something. On this other side when we start being able to get to the pro side. Okay.<br />Corey Maass: Looking for the other, the other app, there\'s one that, um, I got really into a<br />[00:21:00] couple years ago.<br />That\'s, um, it\'ll, it\'ll take any photo and basically make it a painting Yes. In a bunch of different<br />styles. Yes. Because there was a, a woman at the la in the, uh, woman who posted on<br />Facebook this like really cute watercolor painting of a farmhouse. And then I noticed at the<br />bottom that there was a watermark of the app that she\'d used.<br />And I was like, oh crap. She just took a picture of a farmhouse and ran it through this little, you<br />know, 99 cent app and then had. Like a watercolor that I would\'ve put on the wall, you know?<br />Um,<br />Cory Miller: see that, that, that\'s like the heart of publishing for me is expression, and I\'m very<br />much an amateur photographer that flunk photography twice, by the way, in college. But I go,<br />Corey Maass: you forgot to do that. No, the, the cover, the lens cover off . Yes, yes.<br />Cory Miller: I know what depth to field is, but I\'m like, The manual. Mm-hmm. cameras I had to<br />use suck. But all that to say [00:22:00] like this is interesting and that\'s a hobby of mine and so I<br />would say it\'s a hobby of mine. It\'s taking these photos.<br />I even had my son do it while I was driving. I was like, could you take a picture of that sentence?<br />Yeah,<br />Corey Maass: yeah, I do. It\'s one more thing. We have the same of, you need to look at my<br />Instagram. It\'s literally just sky pictures. That\'s<br />Cory Miller: so, okay. This is called Tune. But yeah, let\'s see<br />Corey Maass: here. Oh, it does it live? It Does it live?<br />Oh, that\'s cool. I assumed it was like, it had to be a photo, but it, it actually applies the filter while<br />you\'re moving the photo.<br />Cory Miller: Yeah. So I was like, that\'s wild. And then they\'ve got impressionism, they\'ve got all<br />these filters and I go, right, you know, there\'s something about Instagram having, yeah, I, I don\'t<br />know, 10, 15 filters.<br />I always use like the first six. Sure. You know, but it\'s like there\'s something about that taking<br />something, making it, just dressing it up a little bit and being able to put it out there. Like I\'ve<br />been playing with the tune stuff on the colors cuz it really pulls [00:23:00] out some of the sunset<br />photos and stuff and I go, I hope there\'s something there on this pro.<br />I want it. You know what I mean? Like I want something that just<br />Corey Maass: I conceptually, I think. You\'re onto something. I mean, again, go, what\'s our<br />mantra? You know, making creative tasks simpler, easier, fun. And so we\'re starting with what<br />we\'re hoping is the widest base. Everybody needs to crop an image and get it into WordPress.<br />Um, and then. So I, my Instagram, again, I\'m fascinated, I\'m captivated by mostly cloud shapes<br />and especially sunlight coming through the clouds. But I didn\'t want to, I, I was never. Really<br />impressed with filters. Like they\'re neat for doing different things, but I didn\'t, they didn\'t do what<br />I wanted. And so what I [00:24:00] actually do is, um, because I noticed that the, whatever it is,<br />the polarization from my sunglasses, Make things more distinct.<br />So I usually take my sunglasses off and then take a picture through the lens, and that\'s my real<br />world filter, so to speak. Right. But it\'s like, it\'s, it\'s my style. Nobody knows I\'m doing it, but<br />that\'s stylistically. Right. And so I imagine that, uh, a lot of people like. They, they have their feed<br />and so they have their favorite one or two filters and they think of it in part as their branding.<br />Um, and maybe it\'s the same with blogs where it\'s like, oh, if I\'m, I\'m blogging week over week,<br />whatever photo, I\'m gonna give it the same treatment. Um, you know, even if that means, it\'s not<br />necessarily some manipulation of the photo, but I put. My own watermark, or I put the title of the<br />blog post in a certain font with a certain background.<br />You know, [00:25:00] there\'s a treatment so that you know when it\'s shared. It\'s the same with<br />the OG images, which is why I\'m so fascinated by those. Um, and that\'s the other plugin that I<br />keep messing around with as generating social images. But it\'s the idea of being, again, that<br />same sort of the concept of set it and forget it, but so, Um, so the, another, another word that we<br />should somehow incorporate into one or another of our sort of overarching rules here is<br />consistency, which we\'ve talked about.</p>\n\n\n\n<p>It\'s like, but, but taking that, like all of your images should be 16, nine, but taking it much further<br />so that it\'s all of your images should be watermarked the same way, or they should have some.<br />You know, coherent look and feel so that I land on any page on your blog and, and I know where<br />I am or if I see an image on, in, you know, I\'m scrolling Twitter and I\'m like, oh, there\'s another<br />one of Corey\'s photos.<br />Because it\'s, it\'s [00:26:00] a, it\'s a sunset, but it\'s got the, the comic book treatment, you know,<br />so whatever, whatever it is, like, um, I, I think you are, you\'re, what I take away from what you\'re<br />describing is, An example of still kind of what we, our long-term goal, like whatever the handling<br />of images, but allowing people to handle images consistently.<br />And if it\'s, if it\'s unrecognizable, if it\'s just a task, if it, if we just make uploading images easier<br />than great, like, and we\'re, and everybody has that problem, but if down the road, like, yeah, we<br />hear from people that they all want watermarks or they all want. Uh, you know, an image filter<br />and we can figure out how to do that.<br />It\'s, it still, to me, falls in the same, the same ballpark. Yep.<br />Cory Miller: Now we need a business case, like, you know, take some of this [00:27:00]<br />abstract, creative thought and go, okay, how can we, back to what you kind of grounding us in<br />as like consistent, I heard the word consistent, consistent. unique to the brand Yeah. That<br />they\'re trying to portray.<br />That\'s really interesting thought cuz I, I love templates. I mean, obviously mm-hmm. , that\'s the<br />it that\'s High Themes came from Template. Template Monster. You know, I was a, I had used<br />Template Monster 2004 or five for a website, um, that wasn\'t in WordPress. I don\'t even know<br />what it was in. Um, and I.<br />Offering somebody some flavors to have a head start to, to create something creative. Like for,<br />for, for me, I can\'t draw, you know, I doodle, but some kind of headstart to help somebody do the<br />things. Yep. Consistent you need to your brand, um, you, your [00:28:00] own kinda style that<br />you could develop. Um, kinda like paint by numbers, so.<br />Okay. Thanks for letting me die. Tribe on. Wonder and fascination about all this. Um, you<br />wanted to talk about settings?<br />Corey Maass: Yeah. So I just shared, uh, something with you. Um, you see my screen? Yeah, I<br />can. So starting a settings page. Um, so we\'ve got, I don\'t know if it\'s working in this version yet,<br />so featured images, um, Oh yeah, I, I have a fix for this.<br />So you see the three, four is not actually three four. Um, so that I\'ve, that\'ll, that\'ll be fixed in the<br />next version. A little thing that\'s been bugging me. Um, but the, you know, we\'ve, we\'ve got the<br />actual cropper in a couple of places. Media ad new, no, it\'s not in here. [00:29:00] Again, this is<br />just a non, a little local demo thing.<br />Um, but I started adding what we\'d talked about previously. Uh, uh, the next thing we need, or<br />one of the next things we need is a settings page where we can define the, essentially the<br />defaults like we\'re talking about. Um, So starting with one of the use cases or the, the place, the<br />implement, one of the implementations we\'ve done, um, being featured images.<br />The idea being that right you, when you first install a plugin, we\'ll walk you through these<br />essentially where, you know, okay, for featured images, what is, you know, you always want<br />your photo to be, or the resulting photo to be at least, you know, 500 wide, uh, you know, but not<br />more than 2000 wide. And then same with.<br />You know, something like this, right? So that you don\'t, [00:30:00] you don\'t end up with images<br />that are too small, but you don\'t also don\'t end up with images that are too large. Um, and then,<br />uh, presets,<br />Cory Miller: oh, you can remove. That\'s cool.<br />Corey Maass: So, yeah, because it\'s like, uh, the, the example of the featured image, right? It\'s<br />like we have given you these six square circle, 16, 9 43.<br />but it\'s like, you don\'t, you don\'t want to give you, you, you know, if, if your featured image<br />should always be a circle, then, then why do you have to select circle every time? Right. And so<br />in settings, yeah, you can go in and remove, um, you know, everything but the circle. Um, and<br />then save it. And then that\'s the idea being that, you know, you hit save here and then the next<br />time you come into here where you\'re setting your featured image circle would be the only thing<br />available.<br />Um, and obviously if there\'s, if there\'s only one, then it\'ll be pre-selected and so then [00:31:00]<br />it saves you a step. Um, and then, and then there\'s also the option of, um, so this isn\'t quite</p>\n\n\n\n<p>functioning, but, um, Choose a preset. So it\'s, if you, if you know, I\'ve now deleted all of the, the<br />default preset 16 nine, you can re-add it here, or there\'s this, you know, I, this just, this is my<br />preset, but it\'s like you can, you can name it the query, uh, Miller preset with an aspect ratio of,<br />you know, whatever, whatever.<br />Um, I think this works. Yeah. There\'s the Corey Miller preset. Um, awesome. So, so this is, this<br />is what I started with, um, again, with the idea that what you set is what\'s gonna get translated<br />to here. So the presets are choose your shape, you then have those to choose from. Um, and<br />then when you cropped an [00:32:00] image, the output would match whatever your Minn Max<br />is.<br />Um, I haven\'t quite, I\'m not sure what. Parallel is yet, is it, is it always you? It should be the<br />minimum, but should it go up to the max? You know, we\'ll figure that out. But, um, is, is this kind<br />of what you had in mind? Does this resonate with you? Anything missing?<br />Cory Miller: Um, now that the preset thing is really awesome, like being able to set that here, I<br />think that\'s very forward thinking.<br />Work. You know, I continue to think through work, through flow, come in here, configure it<br />yourself, save it, make it easier on the client, and it becomes a pretty easy thing to, for the<br />problem of getting right sized images per the theme design. So I think that\'s cool. Would you<br />scroll up a little bit? So this puts it, [00:33:00] this men stuff puts it where, Any image that goes<br />through it and scrub by it will not be bigger.<br />So that then whatever we\'ve listed here.<br />Corey Maass: Okay. Yeah, the, you know, it\'s like if you thinking about pr, you know, protecting<br />people from themselves. So if they upload a 10 pixel by 10 pixel emoji and they, but they want to<br />use that as a high res, uh, featured image, then it. Upscale it and look terrible, but that\'s better<br />than them, than a 10 by 10 pixel image getting stuck in there.<br />And then same with like, what we keep talking about is uploading from your photo where, or<br />uploading from your phone where a photo is six megs. No, bring it down, you know, and, and,<br />and 4,000 pixels. It\'s like, no, bring it down to the web. Really doesn\'t need more than 2000<br />pixels. [00:34:00]<br />Cory Miller: So, okay, so the experience is come in here, set it here, put some guardrails.<br />Um, bumpers. Bumpers. Keep talking about bowling, bowling. Bowling bumpers. Okay. Then<br />when they go to do it from like, this is the basic settings. Start, you know, start hearing, get a<br />little bumpers, but then the workflow, if they\'re going into the image and all that kind of stuff. Is<br />there a plan for. Letting them customize that in the featured image and the other, you know,<br />tools in the post.<br />That\'s a good question because here\'s what I\'m thinking. Like web designer developer would<br />go, there\'s your guardrails. Cool. You know? Yeah. And then they get into the live, and I think<br />maybe they, like we were doing the ratios to be simple. Click boom, there you go. But if<br />someone goes. You know, I don\'t know.<br />I want [00:35:00] the cropped image, like I think we were talking about, there\'s a featured image<br />section, then there\'s another section which is in lieu of the block. Yeah. It\'s like upload an image<br />and, and my question would be like, I think we should consider in that, that screen over there,<br />letting them do the custom dimensions there potentially.<br />Corey Maass: Mm. Yeah, so I, I think if I understand you, like we\'ve got a, we\'ve got a bypass,<br />which lets them upload. Straight from their hard drive. And then I also think, if I\'m hearing you<br />correctly, we need a bypass, essentially, these settings. So it\'s like you can still use the cropper,<br />but you can essentially make bad choices if you want to.<br />Uh, and I, and I think maybe that, like there\'s a, I also envision a toggle in here that enables<br />that. And so there\'d be like, here are the [00:36:00] guardrails, you know, a and maybe this<br />screen, so at least, at least for my use case, right? I am, I am an ad I, I have the WordPress<br />admin role. I have the WordPress role of administrator, and then all of my clients have a<br />contributor role, or I\'ve made up another, um, another role called site admin.<br />And so they still think that they\'re admins, but I\'ve actually disabled a bunch of things so that<br />again, they can\'t, they can\'t go in and update a plugin that they shouldn\'t or delete a plugin or<br />change themes. Have had clients go in and just be like, what does this do? And totally break a<br />site. . And so I think in, in, in here, there\'s a, there\'d be a, like an advanced toggle that says, lock<br />this shit down.</p>\n\n\n\n<p>Yeah. Or these are the recommended. Let them make bad choices if they want to. And so like<br />for my clients, for [00:37:00] featured images, hard, hard, hard rule, it\'s 16 nine. Full stop, no<br />exceptions. And so I would switch that toggle to be like, do not let them make any other choices.<br />But you know, the o our other implementation, so this screen would essentially be repeated for<br />media library.<br />I haven\'t reported it over yet, but in media library I might allow more presets. I also might toggle<br />it the other way and say, you know, let them. Upload something because frankly, like we also<br />use the media library for, um, you know, hosting an image to send to the press. And so we then<br />we want a high res image and we\'re just basically using our WordPress install as file storage.<br />And so they would, they would hit a little button that says, just let me upload, you know, leave<br />me alone and let me upload the, the image or let me crop it, but leave it at 7,000 pixels or, or<br />whatever. So, yeah. [00:38:00] That\'s another necessary.<br />Cory Miller: I think this is the work, this is the workflow for an organization or the developer<br />here in this screen.<br />Yeah. What I\'m thinking is I go, okay, because we, the crux of the problem we started with<br />months ago was it\'s a pain in the butt to like crop an image to make it reasonable for the web<br />and look good. And I, if I\'m just Corey Blogger, Corey website thing, I go, okay, I\'m writing a<br />post. I go, okay, I need an image.<br />I want an image for it in here and want it. Obviously I you won\'t believe how many times I\'ve like<br />gotten. A screenshot tool or something to go How many pixels wide is my Yeah. Post column<br />with, you know, and I, we\'ve talked a lot about this, but I go, maybe I [00:39:00] want it really tall<br />in the, in the place or something like that doesn\'t fit a preset mm-hmm.<br />you know, like, here\'s the quick presets we\'ve done. Just go here and you can kind of keep it<br />standard that checks that consistent box, but, Utility of the crop to make it whatever it needs to<br />be for that page design. Yeah, that\'s the workflow I\'m thinking about because I think this is<br />where we need to be for the, I\'m handing this project over to you and I\'m trying to keep you right<br />in the bumpers and I think that big time checks the agency box and some point I wanna share<br />that with our agency owner channel and just get some feedback and.<br />Understand the problems they actually face, but the other side is to make this ubiquitous and<br />easy to use. How do we make it really practical and easy for what they\'re trying to do? And I\'m<br />just talking that out, going, I wonder, you know, they find the image, [00:40:00] they upload it,<br />but they want it, you know, you know how it goes.<br />Sometimes the image doesn\'t fit right. A, a ratio.<br />Corey Maass: So, yeah. Well, and yeah, and I think, you know, we. What we don\'t want to do is<br />limit people\'s creativity and so, you know, and what\'s WordPress? Uh, The mantra, but I think it,<br />I think it\'s actually backwards. They say decisions, not options or something like that.<br />But anyway, in, in our case, we actually want at least, at least sensible options. Um, you know,<br />or, or we don\'t, we can\'t speak for everybody, at least not yet . Um, and, and so yeah, letting<br />people. Bypass the, all these things. Um, I think if nothing else, you know, I mean more of the<br />spirit of WordPress and, and more, you know, the freedom to, to do what you want.<br />I mean, they can always disable the plugin. I\'ve even done that with, there\'s a plugin by short<br />[00:41:00] pixel that. It\'s called something like resize after Upload. And so it, I installed that early<br />on so that client\'s uploading it just lets you, uh, ju similar to some of this, right? It lets you set a<br />sensible limit, so it\'s like resize anything over 2,500 pixels, down to 2,500 pixels.<br />And that\'s all it does, but it\'s it per it, it has saved us so much disk space. They will make a<br />mistake and upload something that\'s, you know, two megs and 7,000 pixels or whatever. So,<br />um, but I\'ve had to. Like, there were times when we wanted, uh, like we had a blog post that<br />was a web comic, and so we needed it 7,000 tall.<br />So I went in disabled, the plugin, and this is the process I had to do right as I went in. Had to go<br />in, disable the plugin, upload the full, full version, and then go back in and reenable the plugin.<br />So yeah, if there was a like click here to bypass just this one time, [00:42:00] uh, you know, then<br />it would\'ve saved me.<br />Six clicks and a, and a bunch of load time. Um, so yeah, to, to make sure that we ac we<br />accommodate that or offer the option to accommodate that , uh, options to offer options always<br />gets a little meta, but I do think that that\'s crucial as much because like we keep talking about,<br />we don\'t, we just don\'t know yet.</p>\n\n\n\n<p>We don\'t know who\'s really gonna use this. We don\'t really know. And that\'s, that\'s why like, I<br />like the thinking. We did at the beginning of this phone call about using, talking about filters. But<br />to me, filters is an example or of, of that, which we don\'t know yet, but are the kind of features<br />that we can offer.<br />Not fi filters specifically, but some sort of photo manipulation, assuming that that\'s what people<br />want. But I also, I think I\'ve, I mean, I\'m having fun looking at discovering. How robust<br />JavaScript is [00:43:00] now and, and what it can do, including photo manipulation. But to me,<br />cropping a circle was a no-brainer for this, you know, for v1.<br />But adding photo filters is, is down the road at some point because it\'s, it could be a lot of noise<br />within the product and if nobody wants it, then we don\'t wanna add that much noise.<br />Cory Miller: I feel like too, a lot of this just kind of pulling up for the overall product journey we\'re<br />on. Mm-hmm. is trying to find that spark.<br />Yeah. Like we\'re talking through things that we think are good ideas, thought like really<br />thoughtfully trying to embody the experience and I feel like we\'re trying to find a little spark of<br />something when we, when we talk about feedback and like, Someone goes, yeah, that what you<br />just said there, but like a lot of the process of product like this is trying to get just lucky and, and<br />find that little spark of, [00:44:00] hey, here it, here it goes.<br />You know? So it\'s good for me to kind of reset and go, yeah, doesn\'t feel good to see fewer than<br />10, you know? But like we\'re trying to get it out there enough and we\'re doing this obviously, so<br />we find a spark somewhere in there and they go, Hey, that\'s what I. To, I don\'t know, let\'s, let me<br />throw in another sport.<br />Fishing,<br />We\'re trying to fish and go like, yeah, we think this is good. So I\'m trying not to make too many,<br />um, minute feedback things about the thing. I go. We, we, we decided a couple weeks ago, we<br />kept talking about like the custom dimensions. So you\'ve done the settings page and now this<br />seems to be the other side.<br />And just kind of getting it out there and going, like, does this, does this work? Part of it, I think<br />for me is I\'m not actively blogging as much at all, and I haven\'t for a long time, but I need to get<br />back in the [00:45:00] process and start documenting, you know, when I\'m Yeah. Trying to<br />express a. Feeling, emotion, whatever those things are.<br />Um, and then going through the press of like, what, you know, for me, I\'m trying to commit to<br />this, this going, okay, let me find an image for this. That kind of hits at what I\'m trying to get at,<br />you know? Yep. Um, back to Instagram, that\'s what I loved about Instagram and those little<br />apps, you remember those apps that take like a second a day and it\'d kind of be a journal and.<br />It started with an image and then it became, you know, people tried to blow up the content<br />underneath. Um, I needed to play around that with, in my head a little bit and practice it of like,<br />what if I started with an image and wrote and just put, get back doing my click and publish<br />again, and then note all my pain points with finding [00:46:00] images that are appropriate.<br />Corey Maass: And I\'m going to, um, to me we\'re, I like your fishing analogy. We\'re fishing with<br />a, with a all lure. We\'re still building. You know, we, we\'ve got the hook and we\'ve got the eyes,<br />but we need the little wiggly bit that the fish will actually be attracted to or whatever. Um, but I\'m<br />not, I guess I\'m, to me, I\'m not yet casting with the intent of actually catching fish like I\'m casting<br />to just kind of make sure that it, it all still holds together when it hits the water.<br />Um, I think with a, with some basic settings, uh, with a block at that point. Like I wanna start<br />promoting it a lot more, putting it on, you know, actually put it in some places. Um, I think at that,<br />that\'s when, you know, we actually are version complete and we can start sending it to some<br />blogs. Um, You know, you, you do a, a Google search for word [00:47:00] plug, you know,<br />WordPress plugin, photo cropping or photo manipulation, and then go find all those listicles and<br />add some comments and, and basically just do kind of the, the, the bare minimum, uh, s e o and<br />spreading of the word.<br />I think the other thing is, um, I don\'t remember who it was, um, Kathy. Or somebody. Yeah,<br />Kathy, um, typed in crop, uh, in the plug-in directory and. Um, and it was like, I think just crop,<br />we\'re not even on the first page. If you do crop.express, we come right up, but crop space<br />express doesn\'t come up. So we, you know, we need to start tweaking some of, you know,<br />looking at, cuz at that point, like the, the README that\'s in there now is, is almost, is already<br />almost not.</p>\n\n\n\n<p>Accurate in that we\'ve added more features. And so revisiting that, revisiting the wording,<br />starting to play with the [00:48:00] wording, but it\'s like at that point we are at least a fully<br />functional product. And so then, then I feel much better about talking about it. I also look forward<br />to like, I will make my clients use this whether they like it or not, and I will toggle it so that they<br />are locked down.<br />Um, and then I will hear their complaints, you know, good, or, or I guess you don\'t have good<br />complaints, but I will hear their feedback, good or bad. Um, but it\'s, um, you know, to me a very<br />real world use case. So, um, we\'re. I guess I\'m trying to get us there, right? Like basic settings,<br />basic implementation. Um, and then I, I, and then frankly, like at that point, at we, we, we.<br />It\'s fun to keep talking every week, but I almost feel like at least what I\'ve done in the past is at<br />that point we, like, we let a couple of months go by and maybe we\'re working on, we\'re still<br />working on it [00:49:00] or we\'re working on a companion or we\'re, you know, something else is<br />cooking. But, um, The, you know, one of the best things that happened to me was, you know,<br />my social link pages plug in.<br />I built it and then, uh, had to stop working on it cuz of a job I was doing. And the year went by<br />and I stopped doing that job and I came back and was like, oh, it has a thousand active installs.<br />And it was like letting it grow organically. Mm. You know, letting time happen naturally. Like I<br />probably could have made that ramp happen a little bit faster, but not a lot, you know, at least at<br />the level I\'m at.<br />Like we, like we talked about, if you\'re starting from zero, you\'ve only got so many favors you<br />can call in. You\'ve only got so many eyes on you. You\'ve only got, um, you know, I think we\'ve,<br />we\'ve both got a little bit of an, I, you\'ve got a much bigger audience than I do. We both are<br />involved with communities, but you know, we are not, [00:50:00] Uh, who\'s a successful<br />blogger?<br />Tim Ferris or, you know, Paul Jarvis or, um, Joel s Spolsky, or, you know, whoever, like big, big<br />names that have attention on them. And so we\'ve, we\'ve, there will be, there will come a day<br />when we\'ve, we\'ve basically tapped every lead that we can think of, and then it\'s like, okay, so<br />let\'s let a week go by and let some, you know, let the internet do its job and, and spreading the<br />word.<br />Cory Miller: That\'s good grounding.<br />Corey Maass: It\'s hard. It\'s hard,<br />Cory Miller: like even if I want to, I, I\'m always so impatient and want to accelerate and get to<br />the things, but I, that\'s really good grounding.<br />Corey Maass: It\'s like, well, if we, if we had a gajillion dollars, if, if we had investment, I\'m not,<br />obviously, I\'m not advocating that, but it\'s like, If we were in that kind of situation or we were able<br />to, you know, sit down in an office day after day and say like, this is our job.<br />[00:51:00] Very different trajectory. Yeah, but I don\'t, but we\'re not in that position.<br />Cory Miller: Yeah, it\'s true.<br />Okay. Well anyway, so go ahead.<br />Corey Maass: Oh, I was just gonna say like, we\'ve got five minutes and I actually need to wrap<br />up on time today, so, okay. Um, just wanted to check in with you, see, see if there\'s anything<br />else to talk about or what else you wanted to talk about. Put you on the spot here. I<br />Cory Miller: think that\'s it. I want to keep kind of pushing in and trying to find, um, I think my<br />part in this is sniffing the problem that we go there.<br />It, you know, there it is. That could potentially illuminate it to bring in money for sales, whatever it<br />might be. But, um, and going like, I think we got a pretty cool thing here. It seems to me for the<br />future, it\'s like [00:52:00] image creation in that cate, something in this category is the potential<br />for the pro. And I\'m keen to just go, like, personally finding the angles in there that would go right<br />here.<br />This could be a little, this could be a V1 into the paid, you know, finding that, that little mix. But<br />thanks for keeping us on track with this. I, I think where we\'re going with this setting is great. It\'s<br />all there. It\'s functional or it will be, and, uh, try to get a little bit more stepped in the, into the.<br />Finding our people<br />Corey Maass: Yeah. For this. Yeah. And I\'m, I\'m, you know, I don\'t think I need to say it, but I\'ll<br />say it anyway. Don\'t get me wrong. Like, I\'m also anxious and excited. Unfortunately, this week,<br />once again, life happens. And so I\'ve, on Monday, a tight deadline Okay. With a day job. Um, but<br />I\'m, but I\'m, there\'s something is going to shift [00:53:00] and I, I almost want to, uh, I wanna</p>\n\n\n\n<p>make sure we don\'t keep having the same conversation week over week, , uh, both for the<br />people listening in, but of course for ourselves.<br />Cuz that that\'s also when we\'re like, okay, yeah, last week we said we were gonna do this, it\'s<br />still not done. So I guess another week goes by, you know, and then, and then we get frustrated.<br />So, um, trying to chip away at it and. But I think, cuz I think something will shift once we<br />honestly look at our, what, at our initial offering crop express the plugin and say, okay, that\'s in<br />the repo as as a complete fishing lure, , or whatever.<br />Um, you know, and, and, and people are using it. And we are using it cuz it actually like does<br />solve the problems that we\'re talking about.<br />Cory Miller: Yeah. Yeah. I wrote down here too, when you said block earlier, uh, I\'ll follow back</p>\n\n\n\n<p>up with Robbie [00:54:00] Umhmm. That\'s right. We had the whole thing come back. Yeah. Mm-<br />hmm. . But it seems like I knew Block had some complexity, uh, you know, that we talked about,</p>\n\n\n\n<p>but I know you\'re heavily embedded into the Beaver Builder community and used it prolifically.<br />And we got that contact with Robbie, so I\'ll follow back up with him. Kathy was the other one.<br />And then I still need to ping the Elementor team. Um, cuz that could be a, you know, it feels like<br />we need that. Somebody going Yeah. But mm-hmm. this or, you know, reactions like, what, what<br />we need. So, um, let me do that with the Robbie, Kathy, aunt Cadence and then, um, ping, ping<br />the team over at on Mentor.<br />Corey Maass: Yeah, and honestly like think about, so I, I think one of the things that you could<br />be doing. Is, or, or what you are doing, but [00:55:00] do more of, is this kind of, essentially, it\'s<br />not really a custom inter customer interview, but kind of, sort of, yeah, yeah. Um, so like, you<br />know, put it on your Twitter or look for a way to, to elevate that question in post status or, and I,<br />I\'m not sure what the question is, but I, I kind of want to put that, put that on your plate.<br />Let me keep focusing on the development of, of the first version of the plugin. Um, but if you can<br />be having starting, or, I mean, and, and usually, you know, tweet into the void and maybe<br />nobody comes back, but it\'s the, like, you know, how, how do you, how do you find images or<br />like, that\'s not the problem we\'re solving yet, so I don\'t wanna really ask that question yet.<br />But, you know, how, what problem, how painful do you, yeah. You know, is it, do you, do you,<br />you know, either define the problem, you know, do you have, do you wish that there was a<br />better crop in WordPress? Or what apps [00:56:00] do you use to manipulate a photo before<br />you upload it to your blog post? Or, um, you know, I think there\'s, I think there\'s, you asked a<br />couple of questions to help figure out the right question to ask and then start asking that in more<br />places.<br />Um, okay. Cuz that, that\'ll. I think it\'s, you know, you pinging the specific people is huge. Um,<br />especially tapping into if, if they are a, a essentially a gateway into, uh, a community or a, a<br />team that is facing a problem over and over again. But I would, I\'d love to hear some, like,<br />answers in the wild too of like throw it on Twitter and see if, if people.<br />Have a response, you know? Um, yeah, because like you said, there\'s, I, I do feel like we are<br />looking for a spark. Like I have this other, um, app, you know, a p i service that I built a while<br />ago that I want to talk to you some other time [00:57:00] about offline. Um, But it\'s like I, and, uh,<br />well, I\'ve mentioned a couple times.<br />I, I built it 99% of the way and then stopped and have not opened it up because I\'m like, I\'m just<br />missing that spark. Like the, and, and then just today somebody, it, it pertains to screenshots.<br />And so somebody today was like, oh, is there a WordPress plugin that takes this kind of<br />screenshot? And I was like, oh my God, I never even thought of that.<br />And I don\'t, I don\'t, still don\'t know if it\'s the spark, but I\'m, you know, I\'m pulling at that thread. I<br />messaged the guy and then we\'re. We\'re chatting via email, like I might bang together a quick<br />use case for \'em to like see if that\'s part of the spark. You know what I mean? So<br />Cory Miller: I, I would love to talk about that.<br />Cause you\'ve mentioned it in our other discussions. I\'d love to talk about that more because, I<br />mean, I think there\'s one thing that I\'m really interested in. It\'s like images and they mentioned<br />Yeah, exactly. No, being able to do that and like, I love the, I think it was a screen. Tool<br />potentially you were talking about?<br />Um, yeah. [00:58:00] Or in that realm. And Yeah. And it makes me put, like, higher on my list is<br />the OMG IMG site as our base for Yeah. Being able to explore this. Here\'s your free plug into<br />crop, you know, like that sticker mill thing. Like here\'s your total mm-hmm. ,<br />Corey Maass: which by, by the way, Sticker Mule, they have, um, specials once in a while.</p>\n\n\n\n<p>So I ordered us, um, 10 crop express stickers for a dollar. So we have our first swag, so as it, it<br />has shipped. So I need your, I need your address. Yep. And, uh, uh, I\'ll send you five. And then<br />we each have five crop express plugin or, um, plugin stickers for, for the fun of it. .<br />Cory Miller: I, I want an OMG IMG Hoodie<br />Corey Maass: oh yes. . Yes.<br />And that, that logo, we\'re gonna need to spend a little more time on roughly. So, yeah,<br />[00:59:00] I want, I want rainbows and unicorns or something. I don\'t know yet. Ice cream<br />cones, but hey brother, I could keep<br />Cory Miller: talking, but I know you need to jet.<br />Corey Maass: Yeah, I gotta bounce.<br />Cory Miller: All right. Uh, I\'m pumped. Thanks, man.<br />Corey Maass: Yeah, we\'ll talk soon.</p>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Mar 2023 13:34:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Cory Miller\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"WPTavern: WordPress 6.2 “Dolphy” Introduces a Revamped Site Editor, Distraction-Free Writing Mode, and Updated Block Inserter \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wptavern.com/?p=143114\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"https://wptavern.com/wordpress-6-2-dolphy-introduces-a-revamped-site-editor-distraction-free-writing-mode-and-updated-block-inserter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4550:\"<img />image credit: <a href=\"https://www.youtube.com/watch?v=vAn_gyNcvN4\">Charles Mingus Sextet &#8211; Feat. Eric Dolphy &#8211; Take The A Train</a>\n\n\n\n<p><a href=\"https://wordpress.org/news/2023/03/dolphy/\">WordPress 6.2</a> &#8220;Dolphy&#8221; was released today, named in honor of American jazz alto saxophonist, bass clarinetist, and flautist <a href=\"https://en.wikipedia.org/wiki/Eric_Dolphy\">Eric Allan Dolphy Jr</a>.&nbsp;This is the first of three planned major releases in 2023. It includes more than 900 enhancements and bug fixes, with a strong focus on improving the site editing experience.</p>\n\n\n\n<p>One of the major highlights of the 6.2 release is the completely revamped Site Editor interface. The browse mode style of navigation lets users quickly slide between editing and previews of templates and template parts, with a new unified design that makes it feel like it&#8217;s all part of the same application. </p>\n\n\n\n<p>Color-coded labels have been added in 6.2, which give users more visual cues in finding their template parts and reusable blocks inside the List View, the Block toolbar, and on the Canvas.</p>\n\n\n\n<p>With these and other updates, the Site Editor is now out of beta. Inside the admin, the About page includes beautifully designed screenshots of each feature with the vibrant blue color that has become part of WordPress&#8217; identity in the new design that is slowly being rolled out across WordPress.org.</p>\n\n\n\n<img />WordPress 6.2 About page\n\n\n\n<p>For those switching from a Classic theme to a Block theme, widgets that are imported will now automatically become Template Parts to make it an easier transition.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Improved Navigation Block Experience for Managing Menus</h3>\n\n\n\n<p>Managing Navigation menus just got easier with a new sidebar inside the Site Editor that allows users to quickly add, remove, and reorder menu items.</p>\n\n\n\n<img />WordPress 6.2 About page\n\n\n\n<h3 class=\"wp-block-heading\">Updated Block Inserter with Media Tab and Openverse Integration</h3>\n\n\n\n<p>The Block Inserter is sporting a new design that better integrates media, making it faster to insert images, video, and audio, with a new tab alongside blocks and patterns. Users can select the new tab and select a media type to see the ten most recent items. </p>\n\n\n\n<img />\n\n\n\n<p>WordPress 6.2 also adds integration with <a href=\"https://openverse.org/\">Openverse</a> to this new media tab. Users now have access to the Openverse library of more than 700 million free-to-use openly licensed and public domain works, directly inside the editor. Clicking on an Openverse image will instantly insert it as an Image block with the proper attribution and license automatically added to the caption, a much faster experience than downloading and uploading to the Media Library.</p>\n\n\n\n<img />\n\n\n\n<h3 class=\"wp-block-heading\">New Distraction-Free Writing Mode</h3>\n\n\n\n<p>WordPress 6.2 introduces a distraction-free writing mode that offers a more focused writing experience, hiding unnecessary interface elements from the editor. This video from the 6.2 testing guide shows how it can be enabled and disabled.</p>\n\n\n\nvideo credit: <a href=\"https://make.wordpress.org/test/2023/02/07/help-test-wordpress-6-2/\">WordPress 6.2 Testing Guide</a>\n\n\n\n<p>Other notable features and updates in 6.2 include the following:</p>\n\n\n\n<ul>\n<li>&nbsp;A new collection of header and footer patterns for block themes</li>\n\n\n\n<li>Scaled block settings with split controls to better organize Styles and Settings options</li>\n\n\n\n<li>A new Style Book that displays every block in the site’s library at a glance where they can be previewed and edited globally</li>\n\n\n\n<li>Copy and Paste styles between blocks</li>\n\n\n\n<li>Improved pattern insertion with patterns organized into more categories, like headers and footers</li>\n\n\n\n<li>Custom CSS support sitewide and for specific blocks</li>\n\n\n\n<li>Sticky positioning to keep top-level group blocks fixed to the top of a page as visitors scroll</li>\n\n\n\n<li>Improved privacy for default themes with locally hosted Google Fonts</li>\n</ul>\n\n\n\n<p>WordPress 6.2 was made possible by more than 600 contributors across 50 countries, with 178 of those contributing for the first time. Update today to get access to all these new features and bug fixes. For the most comprehensive coverage of all the under-the-hood changes for developers and extenders, check out the <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">WordPress 6.2 Field Guide</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Mar 2023 20:35:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"Post Status: WordPress 6.2 “Dolphy” • Gutenberg Phase 3 • Test Plugin Dependencies\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/?p=148557\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://poststatus.com/wordpress-6-2-dolphy-gutenberg-phase-3-test-plugin-dependencies/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:21251:\"<h2 id=\"h-this-week-at-wordpress-org-march-27-2023\">This Week at WordPress.org (March 27, 2023)</h2>\n\n\n<div class=\"has-background has-theme-palette-8-background-color wp-block-post-excerpt\"><p class=\"wp-block-post-excerpt__excerpt\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f973.png\" alt=\"🥳\" class=\"wp-smiley\" /> WordPress 6.2 is now available! If you haven\'t started testing yet, now is the time. <br /><br />Gutenberg is a 4 phase approach to nearly all areas of WordPress. Phase 1 was Posts and Pages. Phase 2 included Themes. Matias Ventura shares what we could see in Phase 3.  <br /><br />Andy Fragen has posted a call for testing on the Plugin Dependencies plugin. </p></div>\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-kadence-infobox kt-info-box_94d1bd-77\"><div class=\"kt-blocks-info-box-link-wrap kt-blocks-info-box-media-align-left kt-info-halign-left\"><div class=\"kt-blocks-info-box-media-container\"><div class=\"kt-blocks-info-box-media kt-info-media-animate-none\"><div class=\"kadence-info-box-icon-container kt-info-icon-animate-none\"><div class=\"kadence-info-box-icon-inner-container\"><span class=\"kb-svg-icon-wrap kb-svg-icon-fas_rocket kt-info-svg-icon\"></span></div></div></div></div><div class=\"kt-infobox-textcontent\"><h2 class=\"kt-blocks-info-box-title\">WP 6.2, Plugin Dependencies, Phase 3</h2><p class=\"kt-blocks-info-box-text\"><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f680.png\" alt=\"🚀\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/news/2023/03/dolphy/\">WordPress 6.2 “Dolphy”</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f5a5.png\" alt=\"🖥\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2023/03/28/call-for-testing-plugin-dependencies-ux/\">Call for Testing: Plugin Dependencies UX</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f7e6.png\" alt=\"🟦\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/core/2023/03/30/proposal-the-interactivity-api-a-better-developer-experience-in-building-interactive-blocks/\">Proposal: The Interactivity API – A better developer experience in building interactive blocks</a><br /><br />3&#x20e3; <a href=\"https://make.wordpress.org/core/2023/03/24/phase-3-collaboration/\">Phase 3: Collaboration</a><br /><br /><img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f3b7.png\" alt=\"🎷\" class=\"wp-smiley\" /> <a href=\"https://make.wordpress.org/design/2023/03/30/why-jazz/\">Why Jazz?</a></p></div></div></div>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_b57166-6e\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<h2 id=\"h-news\"><a href=\"https://wordpress.org/news\">News</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.org/news/2023/03/episode-52-phase-three-with-hector-prieto/\">WP Briefing: Episode 52: Workflows and Phase Three Visioning with Special Guest Héctor Prieto</a></li>\n\n\n\n<li><a href=\"https://wp20.wordpress.net/wp20-swag-is-here/\">WP20 Swag is Here! Order Your Official Merchandise Today</a></li>\n</ul>\n\n\n\n<div class=\"wp-block-kadence-spacer aligncenter kt-block-spacer-_8f6276-eb\"><div class=\"kt-block-spacer kt-block-spacer-halign-center\"><hr class=\"kt-divider\" /></div></div>\n\n\n\n<div class=\"is-layout-flex wp-container-21 wp-block-columns\">\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-community\"><a href=\"https://make.wordpress.org/community\">Community</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/community/2023/03/30/community-team-goals-for-2023-2nd-chat-session/\">Community Team Goals for 2023 : 2nd Chat session</a></li>\n</ul>\n\n\n\n<h2 id=\"h-core\"><a href=\"https://make.wordpress.org/core\">Core</a> </h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/03/30/proposal-the-interactivity-api-a-better-developer-experience-in-building-interactive-blocks/\">Proposal: The Interactivity API – A better developer experience in building interactive blocks</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/28/call-for-testing-plugin-dependencies-ux/\">Call for Testing: Plugin Dependencies UX</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/28/introducing-a-new-block-editor-handbook-scrub/\">Introducing a new block editor handbook scrub</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/23/wordpress-6-2-release-day-process/\">WordPress 6.2 Release Day Process</a></li>\n</ul>\n\n\n\n<h3 id=\"h-wordpress-6-2\">WordPress 6.2</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/03/28/wordpress-6-2-release-date-updated-march-29-2023/\">WordPress 6.2 release date updated: March 29, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/23/wordpress-6-2-release-day-process/\">WordPress 6.2 Release Day Process</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/23/wordpress-6-2-release-candidate-4/\">WordPress 6.2 Release Candidate 4</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/14/fyi-navigation-section-of-new-site-editor-experienced-removed-for-6-2-rc-2/\">FYI: Navigation section of new Site Editor experienced removed for 6.2 RC 2</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/news/2023/03/wordpress-6-2-release-candidate-1/\">WordPress 6.2 Release Candidate 1</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/polyglots/2023/03/14/wordpress-6-2-translation-status-march-14-2023/\">WordPress 6.2 Translation Status (March 14, 2023)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/polyglots/2023/03/04/wordpress-6-2-ready-to-be-translated/\">WordPress 6.2 ready to be translated</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">WordPress 6.2 Field Guide</a>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/03/08/requests-library-upgraded-to-2-0-5-in-wordpress-6-2/\">Requests library upgraded to 2.0.5 in WordPress 6.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/07/patterns-api-expanded-to-include-template_types-property/\">Patterns API expanded to include template_types property</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/07/introduction-of-block-inspector-tabs/\">Introduction of Block Inspector Tabs</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/07/shadows-in-global-styles-with-wordpress-6-2/\">Shadows in Global Styles with WordPress 6.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/07/introducing-the-html-api-in-wordpress-6-2/\">Introducing the HTML API in WordPress 6.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/07/miscellaneous-editor-changes-in-wordpress-6-2/\">Miscellaneous Editor changes in WordPress 6.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/07/introducing-move_dir-in-wordpress-6-2/\">Introducing move_dir() in WordPress 6.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/07/sticky-position-block-support/\">Sticky position block support</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/07/upgrading-to-react-18-and-common-pitfalls-of-concurrent-mode/\">Upgrading to React 18 and common pitfalls of concurrent mode</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/06/add-new-prop-to-serversiderender-component/\">Add new prop to ServerSideRender component</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/06/google-fonts-are-included-locally-in-bundled-themes/\">Google Fonts are included locally in bundled themes</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/06/custom-css-for-global-styles-and-per-block/\">Custom CSS for global styles and per block</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/06/minimum-height-dimensions-block-support/\">Minimum height dimensions block support</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/03/editor-components-updates-in-wordpress-6-2/\">Editor Components updates in WordPress 6.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/03/i18n-improvements-in-6-2/\">I18N Improvements in 6.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/02/28/custom-settings-wordpress-6-2/\">Customize settings for any block in WordPress 6.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/02/19/style-book-preview-of-blocks-in-global-styles/\">Style Book preview of blocks in global styles</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2022/12/09/update-to-content-only-editing-filter-namespace/\">Update to content only editing filter namespace</a></li>\n</ul>\n</li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/02/wordpress-6-2-accessibility-improvements/\">WordPress 6.2 Accessibility Improvements</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/02/28/wordpress-6-2-beta-4-postponed/\">WordPress 6.2 Beta 4 Postponed</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/02/21/wordpress-6-2-beta-3/\">WordPress 6.2 Beta 3</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/02/21/6-2-live-product-demo/\">6.2 Live Product Demo</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/02/04/phase-2-finale/\">Phase 2, Finale</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/02/03/hallway-hangout-performance-improvements-for-wordpress-6-2/\">Hallway Hangout: Performance Improvements for WordPress 6.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/02/06/roadmap-to-6-2/\">Roadmap to 6.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/01/18/bug-scrub-schedule-for-6-2/\">Bug Scrub Schedule for 6.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/01/11/early-bug-scrub-schedule-for-wp-6-2/\">Early bug scrub schedule for WP&nbsp;6.2</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/01/17/wordpress-6-2-planning-roundup/\">WordPress 6.2 Planning Roundup</a></li>\n</ul>\n\n\n\n<h3 id=\"h-meetings\">Meetings</h3>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/03/30/core-editor-chat-summary-29th-march-2023/\">Core Editor chat summary: 29th March 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/28/march-29-dev-chat-is-canceled-in-favor-of-wordpress-6-2-final-release-party/\">March 29 Dev Chat is canceled in favor of WordPress 6.2 final release party</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/27/editor-chat-summary-march-22nd-2023/\">Editor chat summary: March 22nd, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2023/03/27/editor-chat-agenda-march-29th-2023/\">Editor Chat Agenda: March 29th 2023</a></li>\n</ul>\n\n\n\n<h3 id=\"h-developer-blog\">Developer Blog</h3>\n\n\n\n<ul>\n<li><a href=\"https://developer.wordpress.org/news/2023/03/quick-and-easy-local-wordpress-development-with-wp-env/\">Quick and easy local WordPress development with wp-env</a></li>\n</ul>\n\n\n\n<h2 id=\"h-design\"><a href=\"https://make.wordpress.org/design\">Design</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/design/2023/03/30/why-jazz/\">Why Jazz?</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/design/2023/03/13/design-share-feb-13-mar-10/\">Design Share: Feb 13–Mar 10</a></li>\n</ul>\n\n\n\n<h2 id=\"h-docs\"><a href=\"https://make.wordpress.org/docs\">Docs</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/docs/2023/03/26/agenda-for-docs-team-bi-weekly-meeting-april-4-2023/\">Agenda for Docs Team bi-weekly meeting April 4, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/docs/2023/03/26/summary-for-docs-team-meeting-march-21-2023/\">Summary for Docs Team meeting, March 21, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/docs/2023/03/15/call-for-volunteers-to-help-with-6-2-end-user-documentation/\">Call for volunteers to help with 6.2 end user documentation</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/03/27/documentation-team-update-march-27-2023/\">Documentation Team Update – March 27, 2023</a></li>\n</ul>\n</div>\n\n\n\n<div class=\"is-layout-flow wp-block-column\">\n<h2 id=\"h-hosting\"><a href=\"https://make.wordpress.org/hosting\">Hosting</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/hosting/2023/03/21/hosting-team-meeting-agenda-2023-03-22/\">Hosting Team meeting agenda 2023-03-22</a></li>\n</ul>\n\n\n\n<h2 id=\"h-marketing\"><a href=\"https://make.wordpress.org/marketing\">Marketing</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/marketing/2023/03/28/notes-global-marketing-team-meeting-21-march-2023/\">Notes: Global Marketing Team meeting, 21 March 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-meta\"><a href=\"https://make.wordpress.org/meta\">Meta</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/meta/2023/03/27/matrix-chat-summary-march-23-2023/\">Matrix chat Summary, March 23 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-mobile\"><a href=\"https://make.wordpress.org/mobile\">Mobile</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/mobile/2023/03/28/new-mobile-support-forum/\">New Mobile Support Forum</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/03/25/mobile-team-update-march-25th/\">Mobile Team Update – March 25th</a></li>\n</ul>\n\n\n\n<h2 id=\"h-openverse\"><a href=\"https://make.wordpress.org/openverse\">Openverse</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/openverse/2023/03/27/last-week-openverse-2023-03-20-2023-03-27/\">A week in Openverse: 2023-03-20 – 2023-03-27</a></li>\n</ul>\n\n\n\n<h2 id=\"h-performance\"><a href=\"https://make.wordpress.org/performance/\">Performance</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2023/03/28/performance-chat-summary-28-march-2023/\">Performance Chat Summary: 28 March 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/03/27/core-performance-team-update-march-27-2023/\">Core Performance Team Update: March 27, 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-plugins\"><a href=\"https://make.wordpress.org/plugins\">Plugins</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/plugins/2023/03/10/advance-notice-of-retirement/\">Advance Notice of Retirement</a></li>\n</ul>\n\n\n\n<h2 id=\"h-polyglots\"><a href=\"https://make.wordpress.org/polyglots\">Polyglots</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/polyglots/2023/03/29/agenda-weekly-polyglots-chat-march-29-2023-1300-utc/\">Agenda: Weekly Polyglots Chat – March 29, 2023 (13:00 UTC)</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/polyglots/2023/03/21/new-translation-project-wp20-wordpress-net/\">New translation project: wp20.wordpress.net</a></li>\n</ul>\n\n\n\n<h2 id=\"h-plugins-1\"><a href=\"https://make.wordpress.org/plugins\">Plugins</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/plugins/2023/03/21/use-of-code-generators-must-remain-gpl-compatible/\">Use of Code Generators Must Remain GPL Compatible</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/plugins/2023/03/10/advance-notice-of-retirement/\">Advance Notice of Retirement</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/03/28/plugin-review-team-27-mar-2023/\">Plugin Review Team: 27 Mar 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-project\">Project</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/project/2023/02/06/proposal-creating-a-wordpress-contributor-mentorship-program/\">Proposal: Creating a WordPress Contributor Mentorship Program</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/project/2023/01/27/discussion-ending-the-eternal-september/\">Discussion: Ending the Eternal September</a></li>\n</ul>\n\n\n\n<h2 id=\"h-support\"><a href=\"https://make.wordpress.org/support\">Support</a></h2>\n\n\n\n<ul>\n<li> </li>\n</ul>\n\n\n\n<h2 id=\"h-test\"><a href=\"https://make.wordpress.org/test\">Test</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/test/2023/03/28/test-chat-summary-28-march-2023/\">Test Chat Summary: 28 March 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2023/03/14/hallway-hangout-lets-chat-about-all-things-layout/\">Hallway Hangout: Let’s chat about All Things Layout</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/test/2023/02/07/help-test-wordpress-6-2/\">Help Test WordPress 6.2</a></li>\n</ul>\n\n\n\n<h2 id=\"h-theme\">Theme</h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/themes/2023/03/27/themes-team-meeting-agenda-for-march-28-2023/\">Themes team meeting agenda for March 28, 2023</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/themes/2023/03/03/hallway-hangout-community-themes-initiative/\">Hallway Hangout: Community Themes Initiative</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/updates/2023/03/28/themes-team-update-march-28-2023/\">Themes team update March 28, 2023</a></li>\n</ul>\n\n\n\n<h2 id=\"h-training\"><a href=\"https://make.wordpress.org/training\">Training</a></h2>\n\n\n\n<ul>\n<li><a href=\"https://make.wordpress.org/training/2023/03/29/introduction-to-wordpress-development-syllabus/\">Introduction to WordPress Development syllabus</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/training/2023/03/27/meeting-agenda-for-march-28-2023/\">Meeting agenda for March 28, 2023</a></li>\n</ul>\n\n\n\n<h3 id=\"h-tutorials\"><a href=\"https://learn.wordpress.org/tutorials\">Tutorials</a></h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/tutorial/32894-2/\">How to use featured images</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/tutorial/wordpress-rest-api-modifying-responses/\">WordPress REST API – Modifying responses</a></li>\n</ul>\n\n\n\n<h3 id=\"h-online-workshops\">Online Workshops</h3>\n\n\n\n<ul>\n<li><a href=\"https://learn.wordpress.org/?meeting=live-stream-reviewing-developer-focused-features-in-gutenberg-15-4\">Live stream: Reviewing developer-focused features in Gutenberg 15.4</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=%CE%B3%CE%BD%CF%89%CF%81%CE%B9%CE%BC%CE%AF%CE%B1-%CE%BC%CE%B5-%CF%84%CE%B7%CE%BD-%CE%BF%CE%BC%CE%AC%CE%B4%CE%B1-learn\">Γνωριμία με την ομάδα Learn</a></li>\n\n\n\n<li><a href=\"https://learn.wordpress.org/?meeting=how-do-you-learn-wordpress\">How do you Learn WordPress?</a></li>\n</ul>\n\n\n\n<h2 id=\"h-wptv\">WPTV</h2>\n\n\n\n<ul>\n<li><a href=\"https://wordpress.tv/category/year/2022/\">Latest WordPress TV videos</a></li>\n</ul>\n</div>\n</div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 id=\"h-related-news\">Related News:</h2>\n\n\n\n<ul>\n<li><a href=\"https://www.php.net/archive/2023.php#2023-02-14-2\">PHP 8.2.4 Released!</a></li>\n\n\n\n<li><a href=\"https://www.php.net/archive/2023.php#2023-03-16-1\">PHP 8.1.17 Released!</a></li>\n\n\n\n<li><a href=\"https://262.ecma-international.org/13.0/\">TC39</a></li>\n\n\n\n<li><a href=\"https://github.com/composer/composer/releases/tag/2.5.5\">Composer 2.5.5</a></li>\n</ul>\n\n\n\n<p class=\"has-theme-palette-7-background-color has-background\">Thanks for reading our WP dot .org roundup! Each week we are highlighting the news and discussions coming from the good folks making WordPress possible. If you or your company create products or services that use WordPress, you need to be engaged with them and their work. Be sure to share this resource with your product and project managers. <br /><br /><strong>Are you interested in giving back and contributing your time and skills to WordPress.org?</strong> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f64f.png\" alt=\"🙏\" class=\"wp-smiley\" /> <a href=\"https://wordpress.org/support/article/contributing-to-wordpress/\">Start Here ›</a><br /><br /><strong>Get our weekly WordPress community news digest</strong> — Post Status\' <a href=\"https://poststatus.com/news/week-in-review/\">Week in Review</a> — covering the WP/Woo news plus significant writing and podcasts. It\'s also available in <a href=\"https://poststatus.com/newsletter\">our newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f48c.png\" alt=\"💌\" class=\"wp-smiley\" /></p>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile has-background\"><a href=\"https://poststatus.com/\"><img src=\"https://cdn.poststatus.com/wp-content/uploads/2021/09/vertical-post-status-logo-250.png\" alt=\"Post Status\" class=\"wp-image-85823 size-full\" /></a><div class=\"wp-block-media-text__content\">\n<p class=\"has-text-align-left has-normal-font-size\" id=\"h-get-ready-for-remote-work\">You — and <a href=\"https://poststatus.com/#Agency\">your whole team</a> can <a href=\"https://poststatus.com/#choose-membership\">Join Post Status</a> too!</p>\n\n\n\n<p class=\"has-text-align-left has-small-font-size\"><strong>Build your network. Learn with others. Find your next job — or your next hire.</strong> Read the <strong>Post Status</strong> <a href=\"https://poststatus.com/newsletter/\">newsletter</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2709.png\" alt=\"✉\" class=\"wp-smiley\" /> Listen to <a href=\"https://poststatus.com/podcasts/\">podcasts</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f399.png\" alt=\"🎙\" class=\"wp-smiley\" /> Follow <a href=\"https://twitter.com/post_status/\">@Post_Status</a> <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f426.png\" alt=\"🐦\" class=\"wp-smiley\" /> and <a href=\"https://www.linkedin.com/company/post-status-llc/\">LinkedIn</a>. <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f4bc.png\" alt=\"💼\" class=\"wp-smiley\" /></p>\n</div></div>\n\n\n\n<div class=\"wp-block-spacer\"></div>\n<p>This article was published at Post Status — the community for WordPress professionals.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Mar 2023 18:59:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Courtney Robertson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WordPress.org blog: WordPress 6.2 “Dolphy”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=14659\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpress.org/news/2023/03/dolphy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:56896:\"<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/inline-image-x2-1.png?resize=1024%2C683&ssl=1\" alt=\"WordPress 6.2 \" />\n\n\n\n<p>Say hello to WordPress 6.2 “Dolphy,&#8221; named for the woodwind jazz wiz, the multi-instrumentalist—<a href=\"https://en.wikipedia.org/wiki/Eric_Dolphy\">Eric Allan Dolphy Jr</a>. Dolphy is acclaimed for having brought the bass clarinet to prominence in the jazz scene, creating a place for the flute and extending the lexicon of the alto saxophone. In a career that spanned continents, his artistry was at the forefront of pushing improvisational boundaries, ensemble work, and partnerships with well-respected artists like Charles Mingus and John Coltrane.</p>\n\n\n\n<p>This latest version of WordPress reimagines your site editing experience, introduces more ways to style your site, and offers a new distraction-free way to write. Discover improvements that give you more control and freedom to express your creative vision. There’s something for everyone, whether you’re a content creator, developer, site builder, or designer. Let the <a href=\"https://open.spotify.com/artist/6rxxu32JCGDpKKMPHxnSJp?si=UEYO5JU5TXyEeINuuhN6aQ\">music of Eric Dolphy</a> delight you as you take in all that 6.2 has to offer.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/wordpress-6.2.zip\">Download WordPress 6.2 today</a></div>\n</div>\n\n\n\n<p>WordPress 6.2 is the first major release of 2023, covering over 900 enhancements and fixes. It’s also a transition point in the WordPress project’s <a href=\"https://wordpress.org/about/roadmap/\">development roadmap</a>, shifting focus from customization to <a href=\"https://make.wordpress.org/core/2023/03/24/phase-3-collaboration/\">early exploration of workflows and collaboration</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What’s inside</h2>\n\n\n\n<h4 class=\"wp-block-heading\">Meet&nbsp;the reimagined Site Editor</h4>\n\n\n\n<img src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Site-Editor.png?resize=536%2C536&ssl=1\" alt=\"Image inlay of the reimagined Site Editor. WordPress 6.2 Dolphy\" class=\"wp-image-14661\" width=\"536\" height=\"536\" />\n\n\n\n<p>Ready for you to dive in and explore: 6.2 is your invitation to discover what the next generation of WordPress—and block themes—can do.&nbsp;</p>\n\n\n\n<p>Now out of beta, the Site Editor has an updated interface, giving you a new way to interact with your entire site. Explore full previews of your templates and template parts, then jump in and get to editing your site from wherever you choose.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Manage menus in more ways with the Navigation block</h4>\n\n\n\n<img src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Navigation.png?resize=532%2C532&ssl=1\" alt=\"Image inlay of menu management from the Navigation block\" class=\"wp-image-14662\" width=\"532\" height=\"532\" />\n\n\n\n<p>Add, remove, and reorder menu items faster—with a new sidebar experience that makes editing your site’s navigation easier.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Discover a smoother experience for the Block Inserter</h4>\n\n\n\n<img src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Patterns-Inserter.png?resize=536%2C536&ssl=1\" alt=\"Image inlay of the Block Inserter\" class=\"wp-image-14663\" width=\"536\" height=\"536\" />\n\n\n\n<p>A refreshed design gives you easier access to the content you need. Use the Media tab to quickly drag and drop content from your existing Media Library. Find patterns faster with a split view that lets you navigate categories and see previews all at once.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Find the controls you want when you need them</h4>\n\n\n\n<img src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Settings-and-Styles-Tabs.png?resize=540%2C540&ssl=1\" alt=\"Tab between settings and styles in the block settings sidebar\" class=\"wp-image-14664\" width=\"540\" height=\"540\" />\n\n\n\n<p>Your block settings sidebar is better organized with tabs for Settings and Styles. So the tools you need are easy to identify and access.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Build faster with headers and footers for block themes</h4>\n\n\n\n<img src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Block-themes.png?resize=534%2C534&ssl=1\" alt=\"\" class=\"wp-image-14671\" width=\"534\" height=\"534\" />\n\n\n\n<p>Discover a new collection of header and footer patterns. Use them with any block theme as a quick, high-quality starting point for your site’s templates.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Explore Openverse media right from the Editor</h4>\n\n\n\n<img src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Openverse.png?resize=544%2C544&ssl=1\" alt=\"\" class=\"wp-image-14670\" width=\"544\" height=\"544\" />\n\n\n\n<p>Openverse’s library catalogs over 700 million+ free, openly licensed stock images and audio—and now it’s directly integrated into the WordPress experience through the Inserter.&nbsp;</p>\n\n\n\n<h4 class=\"wp-block-heading\">Focus on writing with Distraction Free mode</h4>\n\n\n\n<img src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Distraction-Free.png?resize=542%2C542&ssl=1\" alt=\"\" class=\"wp-image-14665\" width=\"542\" height=\"542\" />\n\n\n\n<p>For those times you want to be alone with your ideas. You can now hide all your panels and controls, leaving you free to bring your content to life.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Meet the new Style Book</h4>\n\n\n\n<img width=\"560\" height=\"560\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Style-Book.png?resize=560%2C560&ssl=1\" alt=\"\" class=\"wp-image-14667\" />\n\n\n\n<p>Get a complete overview of how every block in your site’s library looks. All in one place, all at a glance, directly in the Site Editor.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Copy and paste styles</h4>\n\n\n\n<img width=\"560\" height=\"560\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Copy-_-Paste.png?resize=560%2C560&ssl=1\" alt=\"\" class=\"wp-image-14666\" />\n\n\n\n<p>Perfect the design on one type of block, then copy and paste those styles to other blocks to get just the look you want.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Custom CSS</h4>\n\n\n\n<img width=\"560\" height=\"560\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/03/Custom-CSS.png?resize=560%2C560&ssl=1\" alt=\"\" class=\"wp-image-14669\" />\n\n\n\n<p>Power up your site any way you wish with design tools and custom CSS for another level of control over your site’s look and feel for maximum creativity and artistry in your designs.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Other highlights in 6.2</h3>\n\n\n\n<ul>\n<li><strong>Sticky positioning</strong>: Choose to keep top-level group blocks fixed to the top of a page as visitors scroll.</li>\n\n\n\n<li><strong>Importing widgets</strong>: Options to import your favorite widgets from Classic themes to Block themes.</li>\n\n\n\n<li><strong>Local fonts in themes</strong>: Default WordPress themes offer better privacy with Google Fonts now included.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Performance highlights</h3>\n\n\n\n<p>“Dolphy” includes several impressive performance improvements. You’ll note overall faster load times for block themes of 14 to 18%, and for classic themes, speed increases of 2 to 5%. Server-side performance is also significantly boosted, with an increase of 17 to 23% for block themes and 3 to 5% for classic themes, 3 to 5%. The performance team is dedicated to these kinds of improvements. You can learn more about their work by following the Making WordPress blog using the <a href=\"https://make.wordpress.org/core/tag/performance/\">#performance hashtag</a>.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"></blockquote>\n\n\n\n<h2 class=\"wp-block-heading\">Learn more about WordPress 6.2</h2>\n\n\n\n<p>Explore <a href=\"https://learn.wordpress.org/workshops/\">Learn WordPress</a> for quick how-to videos, courses, and other resources for the latest features in WordPress. Or join a free <a href=\"https://learn.wordpress.org/social-learning/\">live interactive online workshop</a>.</p>\n\n\n\n<p>Check out the <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">WordPress 6.2 Field Guide</a> for detailed developer notes to help you build with WordPress and get the most out of the latest release. Read the <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-2/\">6.2 release notes</a> for additional technical details about this release, including installation information, updates, fixes, file changes, and more.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The 6.2 release squad</h2>\n\n\n\n<p>6.2 is made possible by the many folks who have enthusiastically helped keep the release on track and moving forward:</p>\n\n\n\n<ul>\n<li>Release Lead: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Release Coordinators: <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a></li>\n\n\n\n<li>Core Tech Co-Leads: <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Editor Tech Co-Leads: <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a></li>\n\n\n\n<li>Core Triage Co-Leads: <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Editor Triage Co-Leads: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a></li>\n\n\n\n<li>Design Lead: <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Documentation Co-Leads: <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseet</a>, <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a>, <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a></li>\n\n\n\n<li>Marketing &amp; Communications Co-Leads: <a href=\"https://profiles.wordpress.org/jpantani/\">Jonathan Pantani</a>, <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Test Co-Leads: <a href=\"https://profiles.wordpress.org/robinwpdeveloper/\">Robin</a>, <a href=\"https://profiles.wordpress.org/adeltahri/\">Adel Tahri</a></li>\n\n\n\n<li>Performance Lead: <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you, contributors</h2>\n\n\n\n<p>WordPress 6.2 couldn’t be here without the countless effort and passion of more than 600 contributors in at least 50 countries. A special thank you to the 178 new contributors who joined a release for the first time. Their collaboration helped deliver hundreds of enhancements and fixes, ensuring a stable release for all—a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull\"><a href=\"https://profiles.wordpress.org/10upsimon/\">10upsimon</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">254volkan</a> · <a href=\"https://profiles.wordpress.org/mercime/\">@mercime</a> · <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a> · <a href=\"https://profiles.wordpress.org/aeg0125/\">Aaron Graham</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abidhasan112/\">Abid Hasan</a> · <a href=\"https://profiles.wordpress.org/abitofmind/\">abitofmind</a> · <a href=\"https://profiles.wordpress.org/abtop/\">ABTOP</a> · <a href=\"https://profiles.wordpress.org/ace100/\">ace100</a> · <a href=\"https://profiles.wordpress.org/bosconiandynamics/\">Adam Bosco</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/admwgn/\">Adam Wiltgen</a> · <a href=\"https://profiles.wordpress.org/adeltahri/\">Adel Tahri</a> · <a href=\"https://profiles.wordpress.org/adhun/\">Adhun Anand</a> · <a href=\"https://profiles.wordpress.org/adityaarora010196/\">adityaarora010196</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/afshanadiya/\">Afshana Diya</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/ajmaurya/\">Ajay Maurya</a> · <a href=\"https://profiles.wordpress.org/ajayver/\">ajayver</a> · <a href=\"https://profiles.wordpress.org/seakashdiu/\">Akash Mia</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanjacobmathew/\">Alan Jacob Mathew</a> · <a href=\"https://profiles.wordpress.org/albarin/\">albarin</a> · <a href=\"https://profiles.wordpress.org/alberuni-azad/\">Alberuni Azad.</a> · <a href=\"https://profiles.wordpress.org/alecgeatches/\">alecgeatches</a> · <a href=\"https://profiles.wordpress.org/aleksganev/\">Aleks Ganev</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alvastar/\">alvastar</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amin7/\">amin</a> · <a href=\"https://profiles.wordpress.org/amirrezatm/\">amirrezatm</a> · <a href=\"https://profiles.wordpress.org/amitbarai013/\">Amit Barai Alit</a> · <a href=\"https://profiles.wordpress.org/paulamit/\">Amit Paul</a> · <a href=\"https://profiles.wordpress.org/anantajitjg/\">Anantajit JG</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andreaboe/\">andreaboe</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/apmatthe/\">Andrew Matthews</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey \"Rarst\" Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antonyagrios/\">Antony Agrios</a> · <a href=\"https://profiles.wordpress.org/aparnajl/\">Aparna Adhun</a> · <a href=\"https://profiles.wordpress.org/arrasel403/\">AR Rasel</a> · <a href=\"https://profiles.wordpress.org/arafatjamil01/\">Arafat Jamil</a> · <a href=\"https://profiles.wordpress.org/aravindajith/\">Aravind Ajith</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arnolp/\">arnolp</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/artz91/\">ArtZ91</a> · <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a> · <a href=\"https://profiles.wordpress.org/mrasharirfan/\">Ashar Irfan</a> · <a href=\"https://profiles.wordpress.org/ashrafulsarkar/\">Ashraful Sarkar Naiem</a> · <a href=\"https://profiles.wordpress.org/nmutua/\">Autumn</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/azurseisme/\">azurseisme</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bart/\">Bart</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/benish74/\">benish74</a> · <a href=\"https://profiles.wordpress.org/benjgrolleau/\">Benjamin Grolleau</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernie Reiter</a> · <a href=\"https://profiles.wordpress.org/mxbclang/\">Bethany Chobanian Lang</a> · <a href=\"https://profiles.wordpress.org/bgin/\">bgin</a> · <a href=\"https://profiles.wordpress.org/albatross10/\">Bhavik Kalpesh</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bjorn2404/\">Bjorn Holine</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/bonjour52/\">bonjour52</a> · <a href=\"https://profiles.wordpress.org/bookwyrm/\">bookwyrm</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradyvercher/\">Brady Vercher</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/bgoewert/\">Brennan Goewert</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">Bronson Quick</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke Kaminski</a> · <a href=\"https://profiles.wordpress.org/brookedot/\">Brooke.</a> · <a href=\"https://profiles.wordpress.org/buutqn/\">buutqn</a> · <a href=\"https://profiles.wordpress.org/cameronjonesweb/\">Cameron Jones</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos Garcia Prim</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/critterverse/\">Channing Ritter</a> · <a href=\"https://profiles.wordpress.org/mcaskill/\">Chauncey McAskill</a> · <a href=\"https://profiles.wordpress.org/chintan1896/\">Chintan hingrajiya</a> · <a href=\"https://profiles.wordpress.org/chiragrathod103/\">Chirag Rathod</a> · <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloe Bringmann</a> · <a href=\"https://profiles.wordpress.org/chocofc1/\">chocofc1</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisbaltazar/\">chrisbaltazar</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/ckanderson22/\">ckanderson22</a> · <a href=\"https://profiles.wordpress.org/claytoncollie/\">Clayton Collie</a> · <a href=\"https://profiles.wordpress.org/cnspecialcolor/\">cnspecialcolor</a> · <a href=\"https://profiles.wordpress.org/codesdnc/\">codesdnc</a> · <a href=\"https://profiles.wordpress.org/codingchicken/\">Coding Chicken</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/conner_bw/\">conner_bw</a> · <a href=\"https://profiles.wordpress.org/copons/\">Copons</a> · <a href=\"https://profiles.wordpress.org/corentingautier/\">corentingautier</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">Cory Birdsong</a> · <a href=\"https://profiles.wordpress.org/craigfrancis/\">Craig Francis</a> · <a href=\"https://profiles.wordpress.org/craiglpeters/\">craiglpeters</a> · <a href=\"https://profiles.wordpress.org/geisthanen/\">Creative Andrew</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/dperonne/\">D.PERONNE</a> · <a href=\"https://profiles.wordpress.org/daisyo/\">Daisy Olsen</a> · <a href=\"https://profiles.wordpress.org/dalirajab/\">dali-rajab</a> · <a href=\"https://profiles.wordpress.org/dalleyne/\">Damien Alleyne</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/wirecat/\">Daniel Johnson</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/datagutten/\">datagutten</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dgwyer/\">David Gwyer</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/davefx/\">David Mar&#237;n Carre&#241;o</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/davidvongries/\">David Vongries</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dennisatyoast/\">Dennis Claassen</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">derekblank</a> · <a href=\"https://profiles.wordpress.org/devanshijoshi/\">Devanshi Joshi</a> · <a href=\"https://profiles.wordpress.org/dhusakovic/\">dhusakovic</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/doctorlai/\">doctorlai</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donncha/\">Donncha</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/d-signed/\">DSIGNED</a> · <a href=\"https://profiles.wordpress.org/dustinrue/\">dustinrue</a> · <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/emanuelx/\">emanuelx</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/enej/\">Enej Bajgorić</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/edanzer/\">Erick Danzer</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik Betshammar</a> · <a href=\"https://profiles.wordpress.org/esratpopy/\">Esrat Sultana Popy</a> · <a href=\"https://profiles.wordpress.org/manuilov/\">Eugene M</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian K&#228;gy</a> · <a href=\"https://profiles.wordpress.org/fosuahmed/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fasuto/\">fasuto</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/felipelavinz/\">Felipe Lav&#237;n</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseeth</a> · <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a> · <a href=\"https://profiles.wordpress.org/fpodhorsky/\">fpodhorsky</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/bueltge/\">Frank Bueltge</a> · <a href=\"https://profiles.wordpress.org/franz00/\">franzaurus</a> · <a href=\"https://profiles.wordpress.org/fuadragib/\">Fuad Ragib</a> · <a href=\"https://profiles.wordpress.org/galbaras/\">Gal Baras</a> · <a href=\"https://profiles.wordpress.org/gamecreature/\">gamecreature</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/revgeorge/\">George Hotelling</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/gisgeo/\">gisgeo</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Zi&#243;łkowski</a> · <a href=\"https://profiles.wordpress.org/grl570810/\">grl570810</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/hvar/\">H-var</a> · <a href=\"https://profiles.wordpress.org/hakre/\">hakre</a> · <a href=\"https://profiles.wordpress.org/hanshenrik/\">hanshenrik</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/haritpanchal/\">Harit Panchal</a> · <a href=\"https://profiles.wordpress.org/hasanmisbah/\">Hasan Misbah</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/ehtmlu/\">Helmut Wandl</a> · <a href=\"https://profiles.wordpress.org/luehrsen/\">Hendrik Luehrsen</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/hiren1094/\">hiren sanja</a> · <a href=\"https://profiles.wordpress.org/patelhitesh/\">Hitesh Patel</a> · <a href=\"https://profiles.wordpress.org/hughiemolloy/\">hughie.molloy</a> · <a href=\"https://profiles.wordpress.org/hugodevos/\">hugodevos</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">hztyfoon</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/polevaultweb/\">Iain Poulson</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/iazel/\">Iazel</a> · <a href=\"https://profiles.wordpress.org/ignatggeorgiev/\">Ignat Georgiev</a> · <a href=\"https://profiles.wordpress.org/imanish003/\">imanish003</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">ingeniumed</a> · <a href=\"https://profiles.wordpress.org/innovext/\">Innovext</a> · <a href=\"https://profiles.wordpress.org/inwerpsel/\">inwerpsel</a> · <a href=\"https://profiles.wordpress.org/iqbalrony/\">iqbalrony</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/ivanjeronimo/\">ivanjeronimo</a> · <a href=\"https://profiles.wordpress.org/jhoffmann/\">j.hoffmann</a> · <a href=\"https://profiles.wordpress.org/jackreichert/\">Jack Reichert</a> · <a href=\"https://profiles.wordpress.org/jaedm97/\">Jaed Mosharraf</a> · <a href=\"https://profiles.wordpress.org/jakariaistauk/\">Jakaria Istauk</a> · <a href=\"https://profiles.wordpress.org/outrankjames/\">James</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james-roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a> · <a href=\"https://profiles.wordpress.org/janusdev/\">janusdev</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/carazo/\">Javier Carazo</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jchambo/\">jchambo</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jeanphilippegreen/\">Jean-Philippe Green</a> · <a href=\"https://profiles.wordpress.org/jeawhanlee/\">jeawhanlee</a> · <a href=\"https://profiles.wordpress.org/jeffmatson/\">Jeff Matson</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jmdodd/\">Jennifer M. Dodd</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/lobeless14/\">Jeremy Lind</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jhned/\">jhned</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">jigar bhanushali</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelmadigan/\">joelmadigan</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnwatkins0/\">John Watkins</a> · <a href=\"https://profiles.wordpress.org/jokerrs/\">Jokerrs</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/jpantani/\">Jonathan Pantani</a> · <a href=\"https://profiles.wordpress.org/jongycastillo/\">Jong</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/dunhakdis/\">Joseph G.</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jsh4/\">jsh4</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/welenofsky/\">Justin Welenofsky</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">justlevine</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kacper3355/\">kacper3355</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/kaneva/\">kaneva</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn P.</a> · <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/konyoldeath/\">konyoldeath</a> · <a href=\"https://profiles.wordpress.org/kowsar89/\">Kowsar Hossain</a> · <a href=\"https://profiles.wordpress.org/krunal265/\">Krunal Bhimajiyani</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/lanacodes/\">Lana Codes</a> · <a href=\"https://profiles.wordpress.org/larsmqller/\">larsmqller</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">Lena Stergatou</a> · <a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leo Milo</a> · <a href=\"https://profiles.wordpress.org/lifeboat/\">lifeboat</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/webaxones/\">Lo&#239;c Antignac</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/dreadlox/\">Lox</a> · <a href=\"https://profiles.wordpress.org/lozula/\">lozula</a> · <a href=\"https://profiles.wordpress.org/lucius0101/\">lucius0101</a> · <a href=\"https://profiles.wordpress.org/lucymtc/\">Lucy Tomas</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/pyrobd/\">Lukman Nakib</a> · <a href=\"https://profiles.wordpress.org/pagelab/\">M&#225;rcio Duarte</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mahbubshovan/\">Mahbub Shovan</a> · <a href=\"https://profiles.wordpress.org/mahekkalola/\">Mahek Kalola</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manojkpatil/\">Manoj Patil</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marekdedic/\">Marek Dědič</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/marissamakes/\">Marissa Matthews</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoserb/\">Marko Ivanovic</a> · <a href=\"https://profiles.wordpress.org/marksabbath/\">marksabbath</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/mkox/\">Markus Kosmal</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/matclayton/\">matclayton</a> · <a href=\"https://profiles.wordpress.org/wetah/\">Mateus Machado Luna</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu Paapst</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/mattkeys/\">Matt Keys</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matthiasreinholz/\">Matthias Reinholz</a> · <a href=\"https://profiles.wordpress.org/h4l9k/\">Mauricio</a> · <a href=\"https://profiles.wordpress.org/wppunk/\">Max</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maximej/\">Maxime J.</a> · <a href=\"https://profiles.wordpress.org/jamilbd07/\">MD Jamil Uddin</a> · <a href=\"https://profiles.wordpress.org/kawserz/\">Md Kawser Ahmed Khan Jami</a> · <a href=\"https://profiles.wordpress.org/rakibwordpress/\">Md Rakib Hossain</a> · <a href=\"https://profiles.wordpress.org/abirhasandipu/\">Md. Abir Hasan Dipu</a> · <a href=\"https://profiles.wordpress.org/reduanmasud/\">Md. Reduan Masud</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/mensmaximus/\">mensmaximus</a> · <a href=\"https://profiles.wordpress.org/meyegui/\">meyerdev.ch</a> · <a href=\"https://profiles.wordpress.org/mgol/\">mgol</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/michael-kelly/\">Michael Kelly</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michelmany/\">Michel Many</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mmtr86/\">Miguel Torres</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikestraw/\">Mike Straw</a> · <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/mitchellaustin/\">mitchellaustin</a> · <a href=\"https://profiles.wordpress.org/presents111/\">miya</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtias/\">mtias</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/amustaque97/\">Mustaque Ahmed</a> · <a href=\"https://profiles.wordpress.org/mw108/\">mw108</a> · <a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a> · <a href=\"https://profiles.wordpress.org/namithjawahar/\">Namith Jawahar</a> · <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a> · <a href=\"https://profiles.wordpress.org/nazmulhasan103/\">Nazmul Hasan</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neychok/\">Neycho Kalaydzhiev</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nicholaswilson/\">nicholaswilson</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/nick_thegeek/\">Nick the Geek</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/itsnikhilpatel/\">NikhilPatel</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/dasnitesh780/\">Nitesh Das</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/rnitinb/\">Nitin Rathod</a> · <a href=\"https://profiles.wordpress.org/nitman43/\">nitman43</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nuvopoint/\">nuvoPoint</a> · <a href=\"https://profiles.wordpress.org/oakesjosh/\">oakesjosh</a> · <a href=\"https://profiles.wordpress.org/obayedmamur/\">Obayed Mamur</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/oh_hello/\">oh_hello</a> · <a href=\"https://profiles.wordpress.org/hideokamoto/\">Okamoto Hidetaka</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/olliejones/\">OllieJones</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoney/\">PabloHoney</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbking/\">pbking</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendon&#231;a</a> · <a href=\"https://profiles.wordpress.org/pputzer/\">pepe</a> · <a href=\"https://profiles.wordpress.org/petaryoast/\">Petar Ratković</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walb&#248; Johnsg&#229;rd</a> · <a href=\"https://profiles.wordpress.org/phil-webster/\">Phil Webster</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/iapial/\">Pial</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/knowingart_com/\">PJ Brunet</a> · <a href=\"https://profiles.wordpress.org/pkolenbr/\">pkolenbr</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pravinparmar2404/\">Pravin Parmar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/ptahdunbar/\">Ptah Dunbar</a> · <a href=\"https://profiles.wordpress.org/raduiason/\">raduiason</a> · <a href=\"https://profiles.wordpress.org/initsogar/\">Rafael Agostini</a> · <a href=\"https://profiles.wordpress.org/rafinkhan/\">Rafin</a> · <a href=\"https://profiles.wordpress.org/rajanpanchal2028/\">Rajan Panchal</a> · <a href=\"https://profiles.wordpress.org/rajeshraval786/\">Rajesh Raval</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/razthee007/\">Razthee Md. Yakini</a> · <a href=\"https://profiles.wordpress.org/renatoagds/\">Renato Augusto Gama dos Santos</a> · <a href=\"https://profiles.wordpress.org/rezakhan995/\">Reza Khan</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/riccardodicurti/\">Riccardo Di Curti</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rinkychowdhury9/\">Rinky Chowdhury</a> · <a href=\"https://profiles.wordpress.org/ritteshpatel/\">Ritesh Patel</a> · <a href=\"https://profiles.wordpress.org/rjasdfiii/\">rjasdfiii</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/robinwpdeveloper/\">Robin</a> · <a href=\"https://profiles.wordpress.org/robin-labadie/\">Robin Labadie</a> · <a href=\"https://profiles.wordpress.org/rodage/\">rodage</a> · <a href=\"https://profiles.wordpress.org/rodricus/\">rodricus</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/digical/\">Ross Gile</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/re_enter_rupok/\">Rupok</a> · <a href=\"https://profiles.wordpress.org/rryyaanndd/\">Ryan</a> · <a href=\"https://profiles.wordpress.org/ryankienstra/\">Ryan Kienstra</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">S&#233; Reed</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">S&#233;rgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">S&#246;ren Wrede</a> · <a href=\"https://profiles.wordpress.org/andy786/\">Sahil B.</a> · <a href=\"https://profiles.wordpress.org/stalukder03/\">Sajib Talukder</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/samful/\">Sam Fullalove</a> · <a href=\"https://profiles.wordpress.org/sam1el/\">sam1el</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/samruddhikhandale/\">samruddhikhandale</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sanjucta/\">sanjucta</a> · <a href=\"https://profiles.wordpress.org/sanketchodavadiya/\">Sanket Chodavadiya</a> · <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a> · <a href=\"https://profiles.wordpress.org/sapayth/\">sapayth</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/saumil1611/\">Saumil Nerpagar</a> · <a href=\"https://profiles.wordpress.org/ira2910/\">Sazia Faizunnessa Ira</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/countrymusicchicago/\">Scott Winterroth</a> · <a href=\"https://profiles.wordpress.org/hiyascout/\">Scout James</a> · <a href=\"https://profiles.wordpress.org/seanchayes/\">Sean Hayes</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/seriouslysenpai/\">seriouslysenpai</a> · <a href=\"https://profiles.wordpress.org/wandering-aramean/\">Seth Miller</a> · <a href=\"https://profiles.wordpress.org/shahidul95/\">Shahidul Islam</a> · <a href=\"https://profiles.wordpress.org/shamayel007/\">Shamayel</a> · <a href=\"https://profiles.wordpress.org/shamimmiashuhagh/\">Shamim Mia</a> · <a href=\"https://profiles.wordpress.org/smeunus/\">Sharif Mohammad Eunus</a> · <a href=\"https://profiles.wordpress.org/shraboni/\">Shraboni</a> · <a href=\"https://profiles.wordpress.org/shubham1gupta/\">shubham1gupta</a> · <a href=\"https://profiles.wordpress.org/silicium23/\">Silicium</a> · <a href=\"https://profiles.wordpress.org/simongomes02/\">Simon Gomes</a> · <a href=\"https://profiles.wordpress.org/slieschke/\">Simon Lieschke</a> · <a href=\"https://profiles.wordpress.org/siobhan/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/calvinalkan/\">snicco.io</a> · <a href=\"https://profiles.wordpress.org/sruthi90/\">sruthi90</a> · <a href=\"https://profiles.wordpress.org/steelwagstaff/\">SteelWagstaff</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stentibbing/\">stentibbing</a> · <a href=\"https://profiles.wordpress.org/pypwalters/\">Stephanie Walters</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephym/\">Stephy Miehle</a> · <a href=\"https://profiles.wordpress.org/stephymiehle/\">stephymiehle</a> · <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sun/\">sun</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva (a11n)</a> · <a href=\"https://profiles.wordpress.org/codemonksuvro/\">Suvro</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/afrin29/\">Syeda Sanjida Afrin</a> · <a href=\"https://profiles.wordpress.org/syhc/\">syhc</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/syntaxart/\">syntaxart</a> · <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a> · <a href=\"https://profiles.wordpress.org/tahmidulkarim/\">Tahmid ul Karim</a> · <a href=\"https://profiles.wordpress.org/tahminar27/\">Tahmina Rahman</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/tanazmasaba/\">Tanaz Masaba</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanner-m/\">Tanner Moushey</a> · <a href=\"https://profiles.wordpress.org/rahmantasnia/\">Tasnia Rahman Raima</a> · <a href=\"https://profiles.wordpress.org/teebee/\">teebee</a> · <a href=\"https://profiles.wordpress.org/tekapo/\">tekapo</a> · <a href=\"https://profiles.wordpress.org/thedaysse/\">thedaysse</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/theode/\">theode</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a> · <a href=\"https://profiles.wordpress.org/thomask/\">thomask</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timoth&#233;e Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/dziudek/\">Tomasz Dziuda</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemer&#246;</a> · <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul I Chowdhury</a> · <a href=\"https://profiles.wordpress.org/travisaxton/\">travisaxton</a> · <a href=\"https://profiles.wordpress.org/triumvirate/\">triumvirate</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Sz&#233;pe</a> · <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a> · <a href=\"https://profiles.wordpress.org/elifvish/\">Vishal Kumar</a> · <a href=\"https://profiles.wordpress.org/vladytimy/\">Vlad T</a> · <a href=\"https://profiles.wordpress.org/vtad/\">vtad</a> · <a href=\"https://profiles.wordpress.org/vykesmac/\">vykesmac</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design &#124; Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/webrocker/\">Webrocker</a> · <a href=\"https://profiles.wordpress.org/websitegenii/\">websitegenii</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/winterpsv/\">winterpsv</a> · <a href=\"https://profiles.wordpress.org/wojsmol/\">wojsmol</a> · <a href=\"https://profiles.wordpress.org/wojtekn/\">Wojtek Naruniec</a> · <a href=\"https://profiles.wordpress.org/wojtekszkutnik/\">Wojtek Szkutnik</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/zebaafiashama/\">Zeba Afia Shama</a> · <a href=\"https://profiles.wordpress.org/zenaulislam/\">Zenaul Islam</a> · <a href=\"https://profiles.wordpress.org/zevilz/\">zevilz</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<p>By release day, <a href=\"https://translate.wordpress.org/stats/\">70 locales had translated 90 percent</a> or more of WordPress 6.2 in their language. Community translators are hard at work ensuring more translations are on their way. Thank you to everyone who helps to make WordPress 6.2 available in 200 languages.</p>\n\n\n\n<h2 class=\"wp-block-heading\">A release haiku for 6.2&nbsp;</h2>\n\n\n\n<p>Six point two, so new<br />Shiny and ready for you<br />Congrats on hard work!</p>\n\n\n\n<p class=\"has-text-align-left has-tiny-font-size\"><em>* Portrait of Eric Allen Dolphy Jr. discovered via <a href=\"https://openverse.org/image/36720968-690c-4287-a2dd-619573cc23a6\">Openverse</a>. Colorization by D. Pountain; Original by F. Wolff</em>.<br />&#8220;<a rel=\"noreferrer noopener\" href=\"https://www.flickr.com/photos/98119031@N00/39509743850\" target=\"_blank\">eric dolphy</a>&#8221; by&nbsp;<a rel=\"noreferrer noopener\" href=\"https://www.flickr.com/photos/98119031@N00\" target=\"_blank\">dick_pountain</a>&nbsp;is licensed under&nbsp;<a rel=\"noreferrer noopener\" href=\"https://creativecommons.org/licenses/by-nc-sa/2.0/?ref=openverse\" target=\"_blank\">CC BY-NC-SA 2.0</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Mar 2023 18:57:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: #69 – Joost De Valk on What’s Happening After Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=143046\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wptavern.com/podcast/69-joost-de-valk-on-whats-happening-after-yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39389:\"Transcription<div>\n<p>[00:00:00] Nathan Wrigley: Welcome to the Jukebox podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, what the founder of Yoast is working on now.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast, player of choice, or by going to WPTavern.com forward slash feed forward slash podcast. And you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m very keen to hear from you and hopefully get you or your idea featured on the show. Head to WPTavern.com forward slash contact forward slash jukebox, and use the form there.</p>\n\n\n\n<p>So on the podcast today, we have Joost de Valk.</p>\n\n\n\n<p>If you&#8217;ve been in the WordPress space for any length of time, it&#8217;s likely that you&#8217;ve come across the Yoast SEO plugin. This was the brain child of the guests today, Joost. Same pronunciation, different spelling.</p>\n\n\n\n<p>We talk about how Joost found WordPress and quickly started working on his SEO plugin. How it rapidly grew and became his career.</p>\n\n\n\n<p>We discussed the WordPress landscape during this time, and whether it&#8217;s more difficult now to have the type of success that his plugin received, given that there are more players vying for our attention.</p>\n\n\n\n<p>The conversation then moves into why the plugin was recently sold to Newfold Digital. What were the guardrails that were put in place to ensure that the plugin continued and the employees felt safe?</p>\n\n\n\n<p>We then get into a conversation about Joost&#8217;s new role. He&#8217;s been tasked with reaching out to WordPress community members in order to see what projects or initiatives need more thought and support.</p>\n\n\n\n<p>This leads us into the topic of the current WordPress UI, and how Joost is hoping for a refresh at some point soon. For years, his plugin team wanted to create their own UI to take advantage of new technologies, but Joost always pushed back, preferring instead to adopt the style of the WordPress UI. Now that&#8217;s changed, and the open sourcing of the UI kit they&#8217;ve made is intended as a starting point for a discussion about the need for a more consistent admin experience for all WordPress users.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading over to WPTavern.com forward slash podcast. Where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Joost de Valk.</p>\n\n\n\n<p>I am joined on the podcast today by Joost de Valk. Hello Joost.</p>\n\n\n\n<p>[00:03:32] Joost de Valk: Hey, thank you for having me.</p>\n\n\n\n<p>[00:03:34] Nathan Wrigley: You are very, very welcome. It&#8217;s an absolute pleasure to have somebody of your stature in the WordPress community. You&#8217;ve been with WordPress for a really long time. Certainly whilst I&#8217;ve been using WordPress, I joined the party a little bit later than a lot of people. But your company and your name was already a really big deal.</p>\n\n\n\n<p>If anybody hasn&#8217;t heard of you, I&#8217;d appreciate it if just for a few minutes, you could just give us a little bit of your background story. Where you are, what companies you&#8217;ve worked for, how on earth did you get into WordPress and so on.</p>\n\n\n\n<p>[00:04:05] Joost de Valk: Okay, so that&#8217;s a lot to cover, but let me try. So, I am Joost. I&#8217;m Dutch. I live in the Netherlands with my lovely wife Marieke, who I think you&#8217;ve also had on your show, and our four kids.</p>\n\n\n\n<p>I started Yoast coming from a background of working in several different IT companies. I started university, basically failed at university because I wasn&#8217;t a very good student. Then started working in IT, in a web hosting company. And later on moved into an SEO company where I learned SEO consulting.</p>\n\n\n\n<p>When I started doing that, I had already been coding a bit. I&#8217;ve actually always been coding since I was 12. I built my first website when I was 12, which was in 1994, so you can do the math. I&#8217;d been working on that and I, I learned SEO at this company. Started blogging, and then also started building plugins for the blog platform that I chose, which happened to be WordPress. Building plugins to basically fix my own SEO needs. This was in 2005, 2006. So that&#8217;s relatively early days.</p>\n\n\n\n<p>I started contributing to WordPress Core at basically the same time. I&#8217;d been doing other open source software development. I was a part of the WebKit project, which is the core of Safari, and Chrome. Actually committer in that project before I joined the WordPress world.</p>\n\n\n\n<p>And I had two sites. I had one where I blogged about SEO, and one where I blogged about CSS. And my specialty at that time was CSS 3, which was at that point being created, and I was creating CSS 3 previews. So I was doing SEO for that, building my own plugins, just for myself. And I started releasing them and more people started using them. I started speaking at SEO conferences, and people started asking about these plugins.</p>\n\n\n\n<p>And one thing led to another. And some point in 2010 I decided to start working on my own. At that point thinking I would never hire anybody, but I would just be an SEO consultant, which is why I called the company after myself. Which in hindsight was a stupid idea, because whilst it is a very beautiful brand name, it is super annoying to hear your own name the whole day, because you can&#8217;t really not hear that.</p>\n\n\n\n<p>So, did that in 2010. Basically started SEO consulting. I was consulting for pretty large brands at that time, Facebook, eBay, the Guardian, companies like that. And, well I was still doing that plugin. Decided to bundle the several small plugins that I&#8217;d built into one larger WordPress SEO plugin, which later on became the Yoast SEO plugin.</p>\n\n\n\n<p>And then, at some point during 2011, I hit a million users with what was called WordPress SEO at the time. And Marieke said to me, you can&#8217;t keep doing this. You either have to start making money from this, or stop doing it, because this is nonsense. And she was, as always, right.</p>\n\n\n\n<p>And then started working on that. And she joined quite quickly. Had a couple of other colleagues who I&#8217;d hired to do part of the other work that I was doing at that point already. And we started building, and that went quite well for a very long time. So we sold in 2021, and at that point we had almost 150 employees, and a very well running business. So we&#8217;d been growing between 30 and 50% year over year for almost a decade. And yeah, it&#8217;s been a very interesting journey. And throughout that time I&#8217;ve been doing WordPress, because I love WordPress as a system, and I love the open source community.</p>\n\n\n\n<p>[00:08:05] Nathan Wrigley: I have a quick comment in here and I love how you described it, your successes. We did quite well. To get a million users in the space of, well, it sounds like under a year.</p>\n\n\n\n<p>[00:08:17] Joost de Valk: Well, no, it was, it was slightly more because it was, I had small plugins that people were already using, and then I bundled them into one. So I was basically combining all these user bases. But yeah, no, it, it did go very quickly. So a fairly limited amount of companies I&#8217;ve seen that do it quickly, although I have to say if you look at Elementor, similar and better actually.</p>\n\n\n\n<p>[00:08:39] Nathan Wrigley: When you look back at that time, do you consider that you entered WordPress at what might be described as halcyon days or something? Was there just something about it at that time, which was ripe for the picking? Because the growth from zero to a million, I mean very, very few plugins managed to jump that hurdle. And the fact that you did it, let&#8217;s say, relatively quickly, really quickly in fact, is pretty amazing. But I just wondered if the, if it was more wild west back then? If it was more possible because there was less competition, there was less rivals in the space. Do you have any insight into why it was so successful?</p>\n\n\n\n<p>[00:09:19] Joost de Valk: So part of it is that the people that were building WordPress sites at that time were, almost all of them developers, or at least website maintainers with a fairly good technical grasp. And they switched plugins fairly easily and often. I think that was a bit easier than it is now. Although that group is still there, but it&#8217;s just a smaller portion of the entire user base of WordPress now.</p>\n\n\n\n<p>So yeah, it was a bit different. It was a bit more pioneering I think, in a way. The thing is, we build these ginormous websites on WordPress now, right? So these enormously important websites as well to people. And you&#8217;re not going to play around with plugins on sites like that. So it&#8217;s on personal blogs that you can do that. And just a lot more people did have a personal blog at that time. It was probably the best days for the actual blogoshpere in comparison to what later happened with Twitter, et cetera.</p>\n\n\n\n<p>[00:10:19] Nathan Wrigley: We probably could spend the entire podcast talking about Yoast over the years, but we&#8217;re not going to do that, because we&#8217;ve decided to take a different route. But I, do want to ask, in terms of your journey since the day that you committed to having Yoast a plugin, right through to maybe today, maybe a year or two ago.</p>\n\n\n\n<p>Were you always in love with WordPress, the community and so on? I get the feeling that there might have been a few wrinkles along the way where the whole ecosystem was something that you wanted a little bit of a break from. I could be getting that wrong. If so, ignore the question.</p>\n\n\n\n<p>[00:10:53] Joost de Valk: I don&#8217;t think I&#8217;ve ever really wanted a break from WordPress itself. I think the community is a wonderful thing, but at the same time it&#8217;s very brittle. People come and go, and that&#8217;s fine, right? But we, I feel, have failed in the last few years especially to, well to show our excitement for it to each other.</p>\n\n\n\n<p>I think part of that is Covid, because there weren&#8217;t as many WordCamps and other things while we did that. Part of that is also, we&#8217;re all growing up and all these companies are becoming bigger and, well the demands on those companies are getting bigger. But it&#8217;s also like we&#8217;re getting more professional, but with that maybe also a bit more dull</p>\n\n\n\n<p>[00:11:37] Nathan Wrigley: So you&#8217;re still committed to WordPress. Is that the case? Are you going to be with WordPress do you imagine 3 or 4, 5, 10 years from now? You&#8217;ll still be coming on podcasts like this and talking about WordPress, albeit in a different role?</p>\n\n\n\n<p>[00:11:51] Joost de Valk: I absolutely hope so, yeah. If I wasn&#8217;t thinking that, I wouldn&#8217;t have taken on this new role that I took on at Newfold.</p>\n\n\n\n<p>[00:11:58] Nathan Wrigley: Yeah, let&#8217;s talk about that. But before we get onto that, I would imagine there&#8217;s a subset of users who know that Yoast as a plugin exists, but they may not know about the ownership and the structure and how it&#8217;s all run and what have you. Just run us through that little piece. A little while ago it was announced that you had sold to Newfold Digital. What was the reasoning behind that? So that could be maybe there were personal reasons behind that. Maybe it was just something that you wanted to get away from and give yourself a bit of head space, try something new. What was going on in the run up to that, and how did it all go?</p>\n\n\n\n<p>[00:12:32] Joost de Valk: So, well running a company&#8217;s hard. And as a company becomes bigger, it becomes harder. And during Covid, Marieke and I decided it&#8217;s time. It&#8217;s time to, to sell it and to look at, like, hey, what else do we want to do? And we were talking about that to our other partners. I think we all felt the same at that point.</p>\n\n\n\n<p>And so we went into a process. We actually engaged a banker who helped us sell the company. And we ended up with Newfold Digital, which is not really a household name, but it&#8217;s the parent company to companies like Bluehost, Hostgator, domain.com, and multiple dozens of other brands.</p>\n\n\n\n<p>They put in a good offer, but they also had a very good story about why they wanted to buy Yoast, and what they would do with it. And that really was very interesting to us. And then, they ended up after acquiring us, quite quickly after that, they also acquired Yith. A WooCommerce plugin shop, also from Europe. It&#8217;s been good. It&#8217;s a very nice group of people.</p>\n\n\n\n<p>[00:13:41] Nathan Wrigley: With the transition there, when you went out and as you said, you got some third party in, who obviously had your best interest, but also presumably could be somewhat dispassionate as well. Did you have any sort of guardrails? Because you described that you&#8217;d grown from, well, you solo up to 150 employees, and just before we hit record, you were mentioning that in some cases, some of your employees have been there for as much as a decade. You know, there&#8217;s a real long heritage of people working there. So presumably a lot of these people, you&#8217;re very close to them. Friends you might say.</p>\n\n\n\n<p>[00:14:15] Joost de Valk: Absolutely, yes.</p>\n\n\n\n<p>[00:14:17] Nathan Wrigley: I presume part of that process was protecting them, knowing that when you stepped away and released the reins, that whoever took over the reins was going to behave in a way that you would have behaved. Did you get into that? Did you struggle with that? Was there any, any pieces that you needed to in place?</p>\n\n\n\n<p>[00:14:36] Joost de Valk: It&#8217;s definitely a part of why you&#8217;re thinking very long and hard about who you&#8217;re selling your company to. To some extent, we don&#8217;t need to do all the defense because there&#8217;s Dutch law that will actually prevent them from just firing people. If I lived in an at will firing world, I would probably think about this even more specifically.</p>\n\n\n\n<p>But, honestly it was never a question, they wanted the people. And they wanted everyone to come board and to stay on. And actually in the first year after we sold to Newfold, nobody left. Or in the first six months, I should probably say, I don&#8217;t know whether it&#8217;s entirely true for the first year. Nobody left for a long time.</p>\n\n\n\n<p>No, I think actually treating your employees well is super important. To be fair, that&#8217;s always been one of the things that Marieke has run at our company. So for a long time I was the CEO, then she took over from me. So she was the CEO for the last three years before we sold. Well, she did a tremendous job at making well, creating that culture and making it even better.</p>\n\n\n\n<p>We do indeed have quite a few people that work here for, well, five years or longer. And a couple of them, two people now who are at a decade and one is closing in, yeah.</p>\n\n\n\n<p>[00:15:51] Nathan Wrigley: You mentioned, I can&#8217;t remember whether it was in the conversation we&#8217;ve just had or whether I read it in some show notes. But Newfeld Digital, the company that you ultimately sold for. This for now at least, this is the direction of travel for you. What&#8217;s the role that you&#8217;ve taken on there and what are the sort of key points that you are trying to achieve? You also mentioned that it&#8217;s not a household name. I suspect there&#8217;s some will to change that might be part of your role.</p>\n\n\n\n<p>[00:16:15] Joost de Valk: Not necessarily, I mean, Newford is a corporate brand mostly aimed at other things than, it&#8217;s not like we need everyone to know Newford. But I do think it&#8217;s, well the combination of Bluehost and Yith and Yoast, and quite a few other things under our umbrella make us quite a big player in the WordPress world. We are, I think, the biggest or the second biggest WordPress host out there. Maybe GoDaddy&#8217;s bigger, I honestly don&#8217;t know.</p>\n\n\n\n<p>So my role specifically for the foreseeable future, is to look at hey, what&#8217;s happening in the WordPress world? How can Newfold help WordPress, and what can we do in the WordPress world that would benefit both Newfold and the WordPress world?</p>\n\n\n\n<p>And how can we use our knowledge of WordPress internally a bit better as well. It&#8217;s funny how this works at large hosts and these are, Newfold is not unique in that I&#8217;ve found. I&#8217;ve been talking to other people in the hosting space a lot in the last few months. A lot of these hosting companies, only in the last few years have started realizing that they&#8217;re actually WordPress companies.</p>\n\n\n\n<p>There&#8217;s a bit of a catch up to do there. Well, it&#8217;s one of the things that I want to focus on is like, how can we see that these large hosts who make a lot of money on WordPress and who together create quite a big economy, that they contribute back to WordPress as well? And what can we do about that?</p>\n\n\n\n<p>[00:17:40] Nathan Wrigley: So if I&#8217;m right, your role is head of WordPress strategy for Newfold Digital? That is a part of it. It&#8217;s just trying to figure out where WordPress fits in the overall structure, the products that you&#8217;ve got, the direction that you&#8217;re going to take, the events that you&#8217;re going to show up to, and all of that?</p>\n\n\n\n<p>[00:17:57] Joost de Valk: Yeah, absolutely. And it is honestly, it&#8217;s sort of a perfect role because I have no one reporting to me, and yet I get to talk about these things, which I love.</p>\n\n\n\n<p>[00:18:08] Nathan Wrigley: What have been some of the things that you have been mulling over that at Newfold you think you might like to get your hands dirty on?</p>\n\n\n\n<p>[00:18:15] Joost de Valk: Well, I think it actually ties into one of the other things you wanted to talk about, which is the WordPress Admin UI. So we did a new settings UI for Yoast, and as I was looking at it and we were building that. I was talking to my colleagues at Newfold responsible for the Bluehost interface and for Yith, and we were like, hey, can&#8217;t we just use this across the company?</p>\n\n\n\n<p>So it&#8217;s stuff like that where we, we help each other with our knowledge of WordPress. And we also let people who are good at one specific thing inside WordPress do that. But it&#8217;s also like, okay, we have a couple of different teams of WordPress Core contributors within Newfold. How can we effectively use those?</p>\n\n\n\n<p>So yeah, there&#8217;s a lot of different angles to it. There&#8217;s how do we make more money from WordPress? What direction does WordPress need to go, and how can we help that? How do we make WordPress better usable for our customers so that we actually maintain our customers better? There&#8217;s a lot of different things to do.</p>\n\n\n\n<p>[00:19:17] Nathan Wrigley: You&#8217;ve been really keen publishing statistics over the years about WordPress adoption and WordPress usage and all of those kind of things. So it really does seem like the perfect role for you. You&#8217;re very interested in the bigger picture of WordPress and how widely it&#8217;s adopted and whether the numbers are going up or going down and publishing data about all that. Yeah, it&#8217;s fascinating.</p>\n\n\n\n<p>[00:19:35] Joost de Valk: It is. WordPress is just a perfect project for a large number of the websites out there. And honestly, I think that we, that we don&#8217;t always do ourselves a good service as WordPress on marketing what we can do. And we&#8217;ve also, I think, underinvested a little in some parts of WordPress, in terms of performance and in terms of onboarding, that we should probably invest a bit more in.</p>\n\n\n\n<p>[00:20:02] Nathan Wrigley: Yeah, that&#8217;s an interesting point. Just as a segue, the whole performance thing, not the onboarding piece, but the performance bit in particular. I feel that&#8217;s, that&#8217;s really been kickstarted over the last 12 months. There seems to be a lot of work going into performance and a lot of chatter about it.</p>\n\n\n\n<p>Whether everything should be bundled into one performance plugin or whether it should be split out and become different canonical plugins, if you like. So I think you&#8217;re right. I think it&#8217;s quite interesting that some of the things that you&#8217;ve just mentioned do seem to be getting some attention, and performance is just one that springs to mind.</p>\n\n\n\n<p>[00:20:36] Joost de Valk: Things like performance on an individual site level, they&#8217;re important, but if you are the host that is hosting literally millions of WordPress sites. It is just literally also cost to your bottom line.</p>\n\n\n\n<p>[00:20:49] Nathan Wrigley: Yeah, I hadn&#8217;t really thought about it from that perspective. But if you can shave, I don&#8217;t know, 5% of CPU cycles out of the whole hosting platform, that&#8217;s quite a large amount of money that you&#8217;ve saved.</p>\n\n\n\n<p>[00:20:59] Joost de Valk: Yeah, and we did a lot more than that in recent releases. So it&#8217;s been in the double digits. And that&#8217;s absolutely a good thing for, well, not just for our bottom line, but for nature and for electricity usage. I mean, there&#8217;s tons of reasons to want to do better at that. And I think there&#8217;s still a lot more that we could do.</p>\n\n\n\n<p>[00:21:21] Nathan Wrigley: I think it does seem genuinely to be a perfect role given, well, given that I don&#8217;t know you particularly well, but from all of the things that I&#8217;ve read over the years, it seems like this is kind of like a match made in heaven.</p>\n\n\n\n<p>[00:21:32] Joost de Valk: Yeah, and it is actually a very nice team. So it&#8217;s, it is very nice to be able to work with these people, and look at like, hey, what can we do here? And yeah, I hope to be able to make an impact.</p>\n\n\n\n<p>[00:21:42] Nathan Wrigley: Let&#8217;s talk about the UI, because over the years, if you&#8217;ve been using WordPress for all these years, you must have logged into WordPress, oh, I daren&#8217;t even count. But it&#8217;s probably multiple tens of thousands of times. And each time you&#8217;ve logged in, you&#8217;ve stared at the same UI. And certainly over the last decade, that UI has been exactly the same.</p>\n\n\n\n<p>It basically has looked the same since I started WordPress, with tiny, teeny modifications to things like the color blue. There&#8217;s a slight variation in the color blue that&#8217;s being used now than previously. But broadly speaking, it&#8217;s exactly the same.</p>\n\n\n\n<p>You guys, and we&#8217;re going to use Yoast as an example, but it really, it could be any company. You guys took it into your own hands to say, enough. We think that the UI, if we stick with WordPress standard UI, it doesn&#8217;t really fit what we&#8217;re doing. Technology&#8217;s moved on. We&#8217;ve got more things available to us. Certainly the way things look in WordPress is beginning to be a little bit tired.</p>\n\n\n\n<p>Tell me about that journey. And are you hoping that your free UI kit, that you&#8217;ve open sourced is going to be taken on? Maybe it&#8217;s a cue for the team over at .org to have a look at this and adopt this across WordPress, dare I say?</p>\n\n\n\n<p>[00:22:53] Joost de Valk: I honestly doubt that&#8217;ll happen. Yeah, no, I doubt that. Not because they are against using something that we&#8217;ve built, but because what we build is quite opinionated and uses stuff that they might not be willing to use, like Tailwind.</p>\n\n\n\n<p>It definitely needs a change. It&#8217;s been a tired look for, well, almost a decade as well now. We&#8217;ve had experiments. We&#8217;ve not really moved on that. Gutenberg itself has changed in what it looks like a couple of times over its development, and now we&#8217;re basically stuck with three different types of designs, even within the WordPress admin.</p>\n\n\n\n<p>[00:23:29] Nathan Wrigley: Yeah, tell us what you mean by that because I&#8217;m not sure everybody will pick up the nuance of that.</p>\n\n\n\n<p>[00:23:33] Joost de Valk: Well, if you look at the site health page, it uses different styling from say, add a post. And then go into a post and you edit it in Gutenberg, then that looks entirely different as well. And, I just think that&#8217;s weird. I think it&#8217;s weird that we have different types of buttons. I think it&#8217;s weird that we basically teach a user two or three different UIs. And if you use the customizer with it, then even more. So you&#8217;re basically teaching people new user experiences all the time, and that makes it hard to use.</p>\n\n\n\n<p>And then because there is no real design system for WordPress anymore, that you can use to build your plugin&#8217;s admin pages, everyone starts building their own and all of them start looking differently. And that means that if you have five plugins, you have five different admin pages. And I just don&#8217;t think that that&#8217;s a good experience.</p>\n\n\n\n<p>[00:24:35] Nathan Wrigley: Yeah, I guess if you are a user of WordPress, a frequent user of WordPress, and you&#8217;ve got let&#8217;s say, the one site that you are maintaining all five sites or whatever it may be. Because you&#8217;re in there all the time, that dissonance doesn&#8217;t really happen for you as much, does it? You know, you&#8217;re just familiar with it.</p>\n\n\n\n<p>Okay. If I go in here, I&#8217;m going to expect that the menu&#8217;s going to change. The whole color palette and everything. The buttons will look different, but okay, that&#8217;s how it is. But if WordPress continues to grow, and it wants to get into the late forties and early 50%, which is, I guess, a target which is within reach. That isn&#8217;t really going to fly anymore, is it?</p>\n\n\n\n<p>Because if you go to any SaaS app, let&#8217;s say for example, I don&#8217;t know, let&#8217;s say you go over to Google and you want to interact with Google Docs, it would be really weird if the UI for Docs was different from spreadsheets. And, I don&#8217;t know, let&#8217;s say that you are using Notion or Evernote or something like that. If when you went into some portion of it, it was just different.</p>\n\n\n\n<p>You just fully expect everything to look and feel the same. And in our own experience of WordPress, we just forgive that, don&#8217;t we? We just, oh, okay, that plugin author has done this. But if you are looking to compete against the rising stars, Wix, Squarespace, Shopify, all these other things, that really starts to matter.</p>\n\n\n\n<p>It&#8217;s a bit like death by a thousand teeny, tiny little paper cuts. Those things stick in the head of the end user. That just seems a bit unprofessional. Not sure about this WordPress thing. Do you think I&#8217;ve hit the target there?</p>\n\n\n\n<p>[00:26:08] Joost de Valk: Yeah, no, absolutely. I think that is our problem. I think it actually ties into the other thing I mentioned, the onboarding. It&#8217;s actually pretty hard to start using WordPress. So you are thrown into a dashboard and then the first thing you&#8217;re greeted with is WordPress meetups. And as much as I love WordPress meetups, if you are just on that page for the first time, why are those in my screen?</p>\n\n\n\n<p>And, well there&#8217;s a hundred things like that where I think that we, we could and probably should do better. And the first thing would be, in my opinion, a design system that we all agree on. And I think that is actually an achievable goal. I spoke a bit, before and after I published my post, to a couple of people from the design team, Joan and Mathias, and they also seemed to want something like that.</p>\n\n\n\n<p>We seem to disagree a bit on how far, in how far that actually already exists. Because there is a somewhat of a component system within Gutenberg. I just think that as long as I search for WordPress design system and don&#8217;t get a post or page from WordPress.org, that actually explains the design system in simple to use terms for every plugin developer out there, it doesn&#8217;t exist.</p>\n\n\n\n<p>That means that we have to build it. We have to market it. We have to think about how it&#8217;s going to be used and then write good docs for that. That&#8217;s quite a bit of work, but it&#8217;s not unconceivable that we do that. There&#8217;s a lot of people in the WordPress world who want to make that happen. We&#8217;re just not prioritizing it at the moment. And I think we&#8217;re doing ourselves a disservice by not doing that.</p>\n\n\n\n<p>[00:27:45] Nathan Wrigley: I am going to link in the show notes to an article that you put out recently where you express a lot of these thoughts. And in it you make the point that it was a really difficult decision over at Yoast. Sorry to keep going back to Yoast.</p>\n\n\n\n<p>[00:27:59] Joost de Valk: No, it&#8217;s not a problem. It was a very difficult decision. We&#8217;ve been literally been talking about this for five, six years, and my UX team at Yoast had been wanting to do a redesign for a long time, and I basically stopped them all the time because I was like, I want to stay in line with the WordPress admin.</p>\n\n\n\n<p>And over time we started moving away from it more and more because we needed stuff that simply wasn&#8217;t there. And then at some point you have to admit like, okay, I&#8217;m wrong. This is not going to happen and we need to build our own. It was sort of like a bittersweet decision. And