

CREATE TABLE `BXzlkOCF_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `BXzlkOCF_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO BXzlkOCF_comments VALUES("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2023-09-25 10:01:25","2023-09-25 10:01:25","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://en.gravatar.com/\">Gravatar</a>.","0","1","","comment","0","0");



CREATE TABLE `BXzlkOCF_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `BXzlkOCF_jet_post_types` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO BXzlkOCF_jet_post_types VALUES("1","case-study","publish","a:1:{s:4:\"name\";s:10:\"Case Study\";}","a:22:{s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"query_var\";b:1;s:7:\"rewrite\";b:1;s:12:\"map_meta_cap\";b:1;s:11:\"has_archive\";b:1;s:12:\"hierarchical\";b:0;s:19:\"exclude_from_search\";b:0;s:10:\"with_front\";b:0;s:14:\"show_edit_link\";b:1;s:16:\"hide_field_names\";b:1;s:12:\"rewrite_slug\";s:10:\"case-study\";s:15:\"capability_type\";s:4:\"post\";s:13:\"menu_position\";N;s:9:\"menu_icon\";s:25:\"dashicons-format-standard\";s:8:\"supports\";a:6:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:15:\"page-attributes\";i:3;s:9:\"thumbnail\";i:4;s:13:\"custom-fields\";i:5;s:7:\"excerpt\";}s:13:\"admin_columns\";a:0:{}s:13:\"admin_filters\";a:0:{}}","a:4:{i:0;a:8:{s:5:\"title\";s:12:\"Product Type\";s:4:\"name\";s:23:\"case-study-product-type\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:9:\"33.33333%\";s:7:\"options\";a:4:{i:0;a:3:{s:3:\"key\";s:3:\"AMC\";s:5:\"value\";s:3:\"AMC\";s:2:\"id\";i:7476;}i:1;a:3:{s:3:\"key\";s:3:\"CLN\";s:5:\"value\";s:3:\"CLN\";s:2:\"id\";i:8310;}i:2;a:3:{s:3:\"key\";s:7:\"Tracker\";s:5:\"value\";s:7:\"Tracker\";s:2:\"id\";i:4291;}i:3;a:3:{s:3:\"key\";s:5:\"Token\";s:5:\"value\";s:5:\"Token\";s:2:\"id\";i:6935;}}s:4:\"type\";s:8:\"checkbox\";s:8:\"isNested\";b:0;s:2:\"id\";i:3432;}i:1;a:8:{s:5:\"title\";s:11:\"Market Type\";s:4:\"name\";s:22:\"case-study-market-type\";s:11:\"object_type\";s:5:\"field\";s:7:\"options\";a:3:{i:0;a:3:{s:3:\"key\";s:13:\"Public Market\";s:5:\"value\";s:13:\"Public Market\";s:2:\"id\";i:7166;}i:1;a:3:{s:3:\"key\";s:14:\"Private Market\";s:5:\"value\";s:14:\"Private Market\";s:2:\"id\";i:2256;}i:2;a:3:{s:3:\"key\";s:14:\"Digital Market\";s:5:\"value\";s:14:\"Digital Market\";s:2:\"id\";i:5327;}}s:4:\"type\";s:8:\"checkbox\";s:5:\"width\";s:9:\"33.33333%\";s:8:\"isNested\";b:0;s:2:\"id\";i:6097;}i:2;a:8:{s:5:\"title\";s:14:\"How that works\";s:4:\"name\";s:25:\"case-study-how-that-works\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:3:\"50%\";s:7:\"options\";a:0:{}s:4:\"type\";s:7:\"wysiwyg\";s:8:\"isNested\";b:0;s:2:\"id\";i:6928;}i:3;a:8:{s:5:\"title\";s:15:\"Client Industry\";s:4:\"name\";s:26:\"case-study-client-industry\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:3:\"50%\";s:7:\"options\";a:0:{}s:4:\"type\";s:7:\"wysiwyg\";s:8:\"isNested\";b:0;s:2:\"id\";i:9765;}}");



CREATE TABLE `BXzlkOCF_jet_taxonomies` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `object_type` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO BXzlkOCF_jet_taxonomies VALUES("1","case-study-categories","a:1:{i:0;s:10:\"case-study\";}","publish","a:1:{s:4:\"name\";s:10:\"Categories\";}","a:13:{s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"query_var\";b:0;s:7:\"rewrite\";b:1;s:12:\"hierarchical\";b:1;s:10:\"with_front\";b:0;s:14:\"show_edit_link\";b:0;s:12:\"rewrite_slug\";s:21:\"case-study-categories\";s:15:\"capability_type\";s:0:\"\";}","a:0:{}");



CREATE TABLE `BXzlkOCF_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;




CREATE TABLE `BXzlkOCF_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=292 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO BXzlkOCF_options VALUES("1","siteurl","https://oo-uae.com","yes");
INSERT INTO BXzlkOCF_options VALUES("2","home","https://oo-uae.com","yes");
INSERT INTO BXzlkOCF_options VALUES("3","blogname","Orpheus Oriens","yes");
INSERT INTO BXzlkOCF_options VALUES("4","blogdescription","","yes");
INSERT INTO BXzlkOCF_options VALUES("5","users_can_register","0","yes");
INSERT INTO BXzlkOCF_options VALUES("6","admin_email","admin@oo-uae.com","yes");
INSERT INTO BXzlkOCF_options VALUES("7","start_of_week","1","yes");
INSERT INTO BXzlkOCF_options VALUES("8","use_balanceTags","0","yes");
INSERT INTO BXzlkOCF_options VALUES("9","use_smilies","1","yes");
INSERT INTO BXzlkOCF_options VALUES("10","require_name_email","1","yes");
INSERT INTO BXzlkOCF_options VALUES("11","comments_notify","1","yes");
INSERT INTO BXzlkOCF_options VALUES("12","posts_per_rss","10","yes");
INSERT INTO BXzlkOCF_options VALUES("13","rss_use_excerpt","0","yes");
INSERT INTO BXzlkOCF_options VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO BXzlkOCF_options VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO BXzlkOCF_options VALUES("16","mailserver_pass","password","yes");
INSERT INTO BXzlkOCF_options VALUES("17","mailserver_port","110","yes");
INSERT INTO BXzlkOCF_options VALUES("18","default_category","1","yes");
INSERT INTO BXzlkOCF_options VALUES("19","default_comment_status","open","yes");
INSERT INTO BXzlkOCF_options VALUES("20","default_ping_status","open","yes");
INSERT INTO BXzlkOCF_options VALUES("21","default_pingback_flag","1","yes");
INSERT INTO BXzlkOCF_options VALUES("22","posts_per_page","10","yes");
INSERT INTO BXzlkOCF_options VALUES("23","date_format","F j, Y","yes");
INSERT INTO BXzlkOCF_options VALUES("24","time_format","g:i a","yes");
INSERT INTO BXzlkOCF_options VALUES("25","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO BXzlkOCF_options VALUES("26","comment_moderation","0","yes");
INSERT INTO BXzlkOCF_options VALUES("27","moderation_notify","1","yes");
INSERT INTO BXzlkOCF_options VALUES("28","permalink_structure","","yes");
INSERT INTO BXzlkOCF_options VALUES("29","rewrite_rules","","yes");
INSERT INTO BXzlkOCF_options VALUES("30","hack_file","0","yes");
INSERT INTO BXzlkOCF_options VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO BXzlkOCF_options VALUES("32","moderation_keys","","no");
INSERT INTO BXzlkOCF_options VALUES("33","active_plugins","a:19:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:23:\"elementor/elementor.php\";i:3;s:35:\"google-site-kit/google-site-kit.php\";i:4;s:29:\"jet-elements/jet-elements.php\";i:5;s:25:\"jet-engine/jet-engine.php\";i:6;s:31:\"jupiterx-core/jupiterx-core.php\";i:7;s:17:\"leadin/leadin.php\";i:8;s:63:\"limit-login-attempts-reloaded/limit-login-attempts-reloaded.php\";i:9;s:27:\"maintenance/maintenance.php\";i:10;s:27:\"sellkit-pro/sellkit-pro.php\";i:11;s:19:\"sellkit/sellkit.php\";i:12;s:27:\"updraftplus/updraftplus.php\";i:13;s:24:\"wordpress-seo/wp-seo.php\";i:14;s:23:\"wp-smushit/wp-smush.php\";i:15;s:27:\"wp-super-cache/wp-cache.php\";i:16;s:24:\"wp-whatsapp/whatsapp.php\";i:17;s:47:\"wpvivid-backuprestore/wpvivid-backuprestore.php\";i:18;s:37:\"wpvivid-imgoptim/wpvivid-imgoptim.php\";}","yes");
INSERT INTO BXzlkOCF_options VALUES("34","category_base","","yes");
INSERT INTO BXzlkOCF_options VALUES("35","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO BXzlkOCF_options VALUES("36","comment_max_links","2","yes");
INSERT INTO BXzlkOCF_options VALUES("37","gmt_offset","0","yes");
INSERT INTO BXzlkOCF_options VALUES("38","default_email_category","1","yes");
INSERT INTO BXzlkOCF_options VALUES("39","recently_edited","","no");
INSERT INTO BXzlkOCF_options VALUES("40","template","jupiterx","yes");
INSERT INTO BXzlkOCF_options VALUES("41","stylesheet","jupiterx","yes");
INSERT INTO BXzlkOCF_options VALUES("42","comment_registration","0","yes");
INSERT INTO BXzlkOCF_options VALUES("43","html_type","text/html","yes");
INSERT INTO BXzlkOCF_options VALUES("44","use_trackback","0","yes");
INSERT INTO BXzlkOCF_options VALUES("45","default_role","subscriber","yes");
INSERT INTO BXzlkOCF_options VALUES("46","db_version","55853","yes");
INSERT INTO BXzlkOCF_options VALUES("47","uploads_use_yearmonth_folders","1","yes");
INSERT INTO BXzlkOCF_options VALUES("48","upload_path","","yes");
INSERT INTO BXzlkOCF_options VALUES("49","blog_public","1","yes");
INSERT INTO BXzlkOCF_options VALUES("50","default_link_category","2","yes");
INSERT INTO BXzlkOCF_options VALUES("51","show_on_front","posts","yes");
INSERT INTO BXzlkOCF_options VALUES("52","tag_base","","yes");
INSERT INTO BXzlkOCF_options VALUES("53","show_avatars","1","yes");
INSERT INTO BXzlkOCF_options VALUES("54","avatar_rating","G","yes");
INSERT INTO BXzlkOCF_options VALUES("55","upload_url_path","","yes");
INSERT INTO BXzlkOCF_options VALUES("56","thumbnail_size_w","150","yes");
INSERT INTO BXzlkOCF_options VALUES("57","thumbnail_size_h","150","yes");
INSERT INTO BXzlkOCF_options VALUES("58","thumbnail_crop","1","yes");
INSERT INTO BXzlkOCF_options VALUES("59","medium_size_w","300","yes");
INSERT INTO BXzlkOCF_options VALUES("60","medium_size_h","300","yes");
INSERT INTO BXzlkOCF_options VALUES("61","avatar_default","mystery","yes");
INSERT INTO BXzlkOCF_options VALUES("62","large_size_w","1024","yes");
INSERT INTO BXzlkOCF_options VALUES("63","large_size_h","1024","yes");
INSERT INTO BXzlkOCF_options VALUES("64","image_default_link_type","none","yes");
INSERT INTO BXzlkOCF_options VALUES("65","image_default_size","","yes");
INSERT INTO BXzlkOCF_options VALUES("66","image_default_align","","yes");
INSERT INTO BXzlkOCF_options VALUES("67","close_comments_for_old_posts","0","yes");
INSERT INTO BXzlkOCF_options VALUES("68","close_comments_days_old","14","yes");
INSERT INTO BXzlkOCF_options VALUES("69","thread_comments","1","yes");
INSERT INTO BXzlkOCF_options VALUES("70","thread_comments_depth","5","yes");
INSERT INTO BXzlkOCF_options VALUES("71","page_comments","0","yes");
INSERT INTO BXzlkOCF_options VALUES("72","comments_per_page","50","yes");
INSERT INTO BXzlkOCF_options VALUES("73","default_comments_page","newest","yes");
INSERT INTO BXzlkOCF_options VALUES("74","comment_order","asc","yes");
INSERT INTO BXzlkOCF_options VALUES("75","sticky_posts","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("76","widget_categories","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("77","widget_text","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("78","widget_rss","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("79","uninstall_plugins","a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:27:\"wp-super-cache/wp-cache.php\";s:22:\"wpsupercache_uninstall\";}","no");
INSERT INTO BXzlkOCF_options VALUES("80","timezone_string","","yes");
INSERT INTO BXzlkOCF_options VALUES("81","page_for_posts","0","yes");
INSERT INTO BXzlkOCF_options VALUES("82","page_on_front","0","yes");
INSERT INTO BXzlkOCF_options VALUES("83","default_post_format","0","yes");
INSERT INTO BXzlkOCF_options VALUES("84","link_manager_enabled","0","yes");
INSERT INTO BXzlkOCF_options VALUES("85","finished_splitting_shared_terms","1","yes");
INSERT INTO BXzlkOCF_options VALUES("86","site_icon","0","yes");
INSERT INTO BXzlkOCF_options VALUES("87","medium_large_size_w","768","yes");
INSERT INTO BXzlkOCF_options VALUES("88","medium_large_size_h","0","yes");
INSERT INTO BXzlkOCF_options VALUES("89","wp_page_for_privacy_policy","3","yes");
INSERT INTO BXzlkOCF_options VALUES("90","show_comments_cookies_opt_in","1","yes");
INSERT INTO BXzlkOCF_options VALUES("91","admin_email_lifespan","1711188085","yes");
INSERT INTO BXzlkOCF_options VALUES("92","disallowed_keys","","no");
INSERT INTO BXzlkOCF_options VALUES("93","comment_previously_approved","1","yes");
INSERT INTO BXzlkOCF_options VALUES("94","auto_plugin_theme_update_emails","a:0:{}","no");
INSERT INTO BXzlkOCF_options VALUES("95","auto_update_core_dev","enabled","yes");
INSERT INTO BXzlkOCF_options VALUES("96","auto_update_core_minor","enabled","yes");
INSERT INTO BXzlkOCF_options VALUES("97","auto_update_core_major","enabled","yes");
INSERT INTO BXzlkOCF_options VALUES("98","wp_force_deactivated_plugins","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("99","initial_db_version","55853","yes");
INSERT INTO BXzlkOCF_options VALUES("100","BXzlkOCF_user_roles","a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}","yes");
INSERT INTO BXzlkOCF_options VALUES("101","fresh_site","1","yes");
INSERT INTO BXzlkOCF_options VALUES("102","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("103","sidebars_widgets","a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}","yes");
INSERT INTO BXzlkOCF_options VALUES("104","cron","a:13:{i:1695636087;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1695636089;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1695636095;a:1:{s:32:\"wp_sellkit-database-updater_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:41:\"wp_sellkit-database-updater_cron_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1695636098;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1695636112;a:1:{s:25:\"smush_check_for_conflicts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1695636149;a:1:{s:28:\"wp_update_comment_type_batch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1695636385;a:1:{s:30:\"wpseo_start_cleanup_indexables\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1695639685;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1695639705;a:1:{s:27:\"wpseo_indexable_index_batch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:15:\"fifteen_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1695679285;a:6:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:33:\"updraftplus_clean_temporary_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:41:\"googlesitekit_cron_update_remote_features\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1695686400;a:1:{s:22:\"wdev_logger_clear_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1695722485;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO BXzlkOCF_options VALUES("105","wpsupercache_gc_time","1695636085","yes");
INSERT INTO BXzlkOCF_options VALUES("106","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("107","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("108","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("109","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("110","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("111","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("112","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("113","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("114","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("115","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("116","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("117","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("118","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("119","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("120","_transient_wp_core_block_css_files","a:496:{i:0;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/archives/editor-rtl.css\";i:1;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/archives/editor-rtl.min.css\";i:2;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/archives/editor.css\";i:3;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/archives/editor.min.css\";i:4;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/archives/style-rtl.css\";i:5;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/archives/style-rtl.min.css\";i:6;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/archives/style.css\";i:7;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/archives/style.min.css\";i:8;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/audio/editor-rtl.css\";i:9;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/audio/editor-rtl.min.css\";i:10;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/audio/editor.css\";i:11;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/audio/editor.min.css\";i:12;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/audio/style-rtl.css\";i:13;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/audio/style-rtl.min.css\";i:14;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/audio/style.css\";i:15;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/audio/style.min.css\";i:16;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/audio/theme-rtl.css\";i:17;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/audio/theme-rtl.min.css\";i:18;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/audio/theme.css\";i:19;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/audio/theme.min.css\";i:20;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/avatar/editor-rtl.css\";i:21;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/avatar/editor-rtl.min.css\";i:22;s:63:\"/home/oouaeco1/public_html/wp-includes/blocks/avatar/editor.css\";i:23;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/avatar/editor.min.css\";i:24;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/avatar/style-rtl.css\";i:25;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/avatar/style-rtl.min.css\";i:26;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/avatar/style.css\";i:27;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/avatar/style.min.css\";i:28;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/block/editor-rtl.css\";i:29;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/block/editor-rtl.min.css\";i:30;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/block/editor.css\";i:31;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/block/editor.min.css\";i:32;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/button/editor-rtl.css\";i:33;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/button/editor-rtl.min.css\";i:34;s:63:\"/home/oouaeco1/public_html/wp-includes/blocks/button/editor.css\";i:35;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/button/editor.min.css\";i:36;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/button/style-rtl.css\";i:37;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/button/style-rtl.min.css\";i:38;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/button/style.css\";i:39;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/button/style.min.css\";i:40;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/buttons/editor-rtl.css\";i:41;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/buttons/editor-rtl.min.css\";i:42;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/buttons/editor.css\";i:43;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/buttons/editor.min.css\";i:44;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/buttons/style-rtl.css\";i:45;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/buttons/style-rtl.min.css\";i:46;s:63:\"/home/oouaeco1/public_html/wp-includes/blocks/buttons/style.css\";i:47;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/buttons/style.min.css\";i:48;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/calendar/style-rtl.css\";i:49;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/calendar/style-rtl.min.css\";i:50;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/calendar/style.css\";i:51;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/calendar/style.min.css\";i:52;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/categories/editor-rtl.css\";i:53;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/categories/editor-rtl.min.css\";i:54;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/categories/editor.css\";i:55;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/categories/editor.min.css\";i:56;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/categories/style-rtl.css\";i:57;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/categories/style-rtl.min.css\";i:58;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/categories/style.css\";i:59;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/categories/style.min.css\";i:60;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/code/editor-rtl.css\";i:61;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/code/editor-rtl.min.css\";i:62;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/code/editor.css\";i:63;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/code/editor.min.css\";i:64;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/code/style-rtl.css\";i:65;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/code/style-rtl.min.css\";i:66;s:60:\"/home/oouaeco1/public_html/wp-includes/blocks/code/style.css\";i:67;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/code/style.min.css\";i:68;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/code/theme-rtl.css\";i:69;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/code/theme-rtl.min.css\";i:70;s:60:\"/home/oouaeco1/public_html/wp-includes/blocks/code/theme.css\";i:71;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/code/theme.min.css\";i:72;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/columns/editor-rtl.css\";i:73;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/columns/editor-rtl.min.css\";i:74;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/columns/editor.css\";i:75;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/columns/editor.min.css\";i:76;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/columns/style-rtl.css\";i:77;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/columns/style-rtl.min.css\";i:78;s:63:\"/home/oouaeco1/public_html/wp-includes/blocks/columns/style.css\";i:79;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/columns/style.min.css\";i:80;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/comment-content/style-rtl.css\";i:81;s:79:\"/home/oouaeco1/public_html/wp-includes/blocks/comment-content/style-rtl.min.css\";i:82;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/comment-content/style.css\";i:83;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/comment-content/style.min.css\";i:84;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/comment-template/style-rtl.css\";i:85;s:80:\"/home/oouaeco1/public_html/wp-includes/blocks/comment-template/style-rtl.min.css\";i:86;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/comment-template/style.css\";i:87;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/comment-template/style.min.css\";i:88;s:88:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-pagination-numbers/editor-rtl.css\";i:89;s:92:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-pagination-numbers/editor-rtl.min.css\";i:90;s:84:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-pagination-numbers/editor.css\";i:91;s:88:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-pagination-numbers/editor.min.css\";i:92;s:80:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-pagination/editor-rtl.css\";i:93;s:84:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-pagination/editor-rtl.min.css\";i:94;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-pagination/editor.css\";i:95;s:80:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-pagination/editor.min.css\";i:96;s:79:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-pagination/style-rtl.css\";i:97;s:83:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-pagination/style-rtl.min.css\";i:98;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-pagination/style.css\";i:99;s:79:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-pagination/style.min.css\";i:100;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-title/editor-rtl.css\";i:101;s:79:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-title/editor-rtl.min.css\";i:102;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-title/editor.css\";i:103;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/comments-title/editor.min.css\";i:104;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/comments/editor-rtl.css\";i:105;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/comments/editor-rtl.min.css\";i:106;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/comments/editor.css\";i:107;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/comments/editor.min.css\";i:108;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/comments/style-rtl.css\";i:109;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/comments/style-rtl.min.css\";i:110;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/comments/style.css\";i:111;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/comments/style.min.css\";i:112;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/cover/editor-rtl.css\";i:113;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/cover/editor-rtl.min.css\";i:114;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/cover/editor.css\";i:115;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/cover/editor.min.css\";i:116;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/cover/style-rtl.css\";i:117;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/cover/style-rtl.min.css\";i:118;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/cover/style.css\";i:119;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/cover/style.min.css\";i:120;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/details/editor-rtl.css\";i:121;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/details/editor-rtl.min.css\";i:122;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/details/editor.css\";i:123;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/details/editor.min.css\";i:124;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/details/style-rtl.css\";i:125;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/details/style-rtl.min.css\";i:126;s:63:\"/home/oouaeco1/public_html/wp-includes/blocks/details/style.css\";i:127;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/details/style.min.css\";i:128;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/embed/editor-rtl.css\";i:129;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/embed/editor-rtl.min.css\";i:130;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/embed/editor.css\";i:131;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/embed/editor.min.css\";i:132;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/embed/style-rtl.css\";i:133;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/embed/style-rtl.min.css\";i:134;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/embed/style.css\";i:135;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/embed/style.min.css\";i:136;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/embed/theme-rtl.css\";i:137;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/embed/theme-rtl.min.css\";i:138;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/embed/theme.css\";i:139;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/embed/theme.min.css\";i:140;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/file/editor-rtl.css\";i:141;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/file/editor-rtl.min.css\";i:142;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/file/editor.css\";i:143;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/file/editor.min.css\";i:144;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/file/style-rtl.css\";i:145;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/file/style-rtl.min.css\";i:146;s:60:\"/home/oouaeco1/public_html/wp-includes/blocks/file/style.css\";i:147;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/file/style.min.css\";i:148;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/footnotes/style-rtl.css\";i:149;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/footnotes/style-rtl.min.css\";i:150;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/footnotes/style.css\";i:151;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/footnotes/style.min.css\";i:152;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/freeform/editor-rtl.css\";i:153;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/freeform/editor-rtl.min.css\";i:154;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/freeform/editor.css\";i:155;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/freeform/editor.min.css\";i:156;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/gallery/editor-rtl.css\";i:157;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/gallery/editor-rtl.min.css\";i:158;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/gallery/editor.css\";i:159;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/gallery/editor.min.css\";i:160;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/gallery/style-rtl.css\";i:161;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/gallery/style-rtl.min.css\";i:162;s:63:\"/home/oouaeco1/public_html/wp-includes/blocks/gallery/style.css\";i:163;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/gallery/style.min.css\";i:164;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/gallery/theme-rtl.css\";i:165;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/gallery/theme-rtl.min.css\";i:166;s:63:\"/home/oouaeco1/public_html/wp-includes/blocks/gallery/theme.css\";i:167;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/gallery/theme.min.css\";i:168;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/group/editor-rtl.css\";i:169;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/group/editor-rtl.min.css\";i:170;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/group/editor.css\";i:171;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/group/editor.min.css\";i:172;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/group/style-rtl.css\";i:173;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/group/style-rtl.min.css\";i:174;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/group/style.css\";i:175;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/group/style.min.css\";i:176;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/group/theme-rtl.css\";i:177;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/group/theme-rtl.min.css\";i:178;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/group/theme.css\";i:179;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/group/theme.min.css\";i:180;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/heading/style-rtl.css\";i:181;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/heading/style-rtl.min.css\";i:182;s:63:\"/home/oouaeco1/public_html/wp-includes/blocks/heading/style.css\";i:183;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/heading/style.min.css\";i:184;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/html/editor-rtl.css\";i:185;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/html/editor-rtl.min.css\";i:186;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/html/editor.css\";i:187;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/html/editor.min.css\";i:188;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/image/editor-rtl.css\";i:189;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/image/editor-rtl.min.css\";i:190;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/image/editor.css\";i:191;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/image/editor.min.css\";i:192;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/image/style-rtl.css\";i:193;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/image/style-rtl.min.css\";i:194;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/image/style.css\";i:195;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/image/style.min.css\";i:196;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/image/theme-rtl.css\";i:197;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/image/theme-rtl.min.css\";i:198;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/image/theme.css\";i:199;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/image/theme.min.css\";i:200;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/latest-comments/style-rtl.css\";i:201;s:79:\"/home/oouaeco1/public_html/wp-includes/blocks/latest-comments/style-rtl.min.css\";i:202;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/latest-comments/style.css\";i:203;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/latest-comments/style.min.css\";i:204;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/latest-posts/editor-rtl.css\";i:205;s:77:\"/home/oouaeco1/public_html/wp-includes/blocks/latest-posts/editor-rtl.min.css\";i:206;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/latest-posts/editor.css\";i:207;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/latest-posts/editor.min.css\";i:208;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/latest-posts/style-rtl.css\";i:209;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/latest-posts/style-rtl.min.css\";i:210;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/latest-posts/style.css\";i:211;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/latest-posts/style.min.css\";i:212;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/list/style-rtl.css\";i:213;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/list/style-rtl.min.css\";i:214;s:60:\"/home/oouaeco1/public_html/wp-includes/blocks/list/style.css\";i:215;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/list/style.min.css\";i:216;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/media-text/editor-rtl.css\";i:217;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/media-text/editor-rtl.min.css\";i:218;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/media-text/editor.css\";i:219;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/media-text/editor.min.css\";i:220;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/media-text/style-rtl.css\";i:221;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/media-text/style-rtl.min.css\";i:222;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/media-text/style.css\";i:223;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/media-text/style.min.css\";i:224;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/more/editor-rtl.css\";i:225;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/more/editor-rtl.min.css\";i:226;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/more/editor.css\";i:227;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/more/editor.min.css\";i:228;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation-link/editor-rtl.css\";i:229;s:80:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation-link/editor-rtl.min.css\";i:230;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation-link/editor.css\";i:231;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation-link/editor.min.css\";i:232;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation-link/style-rtl.css\";i:233;s:79:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation-link/style-rtl.min.css\";i:234;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation-link/style.css\";i:235;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation-link/style.min.css\";i:236;s:79:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation-submenu/editor-rtl.css\";i:237;s:83:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation-submenu/editor-rtl.min.css\";i:238;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation-submenu/editor.css\";i:239;s:79:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation-submenu/editor.min.css\";i:240;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation/editor-rtl.css\";i:241;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation/editor-rtl.min.css\";i:242;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation/editor.css\";i:243;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation/editor.min.css\";i:244;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation/style-rtl.css\";i:245;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation/style-rtl.min.css\";i:246;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation/style.css\";i:247;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/navigation/style.min.css\";i:248;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/nextpage/editor-rtl.css\";i:249;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/nextpage/editor-rtl.min.css\";i:250;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/nextpage/editor.css\";i:251;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/nextpage/editor.min.css\";i:252;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/page-list/editor-rtl.css\";i:253;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/page-list/editor-rtl.min.css\";i:254;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/page-list/editor.css\";i:255;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/page-list/editor.min.css\";i:256;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/page-list/style-rtl.css\";i:257;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/page-list/style-rtl.min.css\";i:258;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/page-list/style.css\";i:259;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/page-list/style.min.css\";i:260;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/paragraph/editor-rtl.css\";i:261;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/paragraph/editor-rtl.min.css\";i:262;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/paragraph/editor.css\";i:263;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/paragraph/editor.min.css\";i:264;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/paragraph/style-rtl.css\";i:265;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/paragraph/style-rtl.min.css\";i:266;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/paragraph/style.css\";i:267;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/paragraph/style.min.css\";i:268;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/post-author/style-rtl.css\";i:269;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/post-author/style-rtl.min.css\";i:270;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/post-author/style.css\";i:271;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/post-author/style.min.css\";i:272;s:79:\"/home/oouaeco1/public_html/wp-includes/blocks/post-comments-form/editor-rtl.css\";i:273;s:83:\"/home/oouaeco1/public_html/wp-includes/blocks/post-comments-form/editor-rtl.min.css\";i:274;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/post-comments-form/editor.css\";i:275;s:79:\"/home/oouaeco1/public_html/wp-includes/blocks/post-comments-form/editor.min.css\";i:276;s:78:\"/home/oouaeco1/public_html/wp-includes/blocks/post-comments-form/style-rtl.css\";i:277;s:82:\"/home/oouaeco1/public_html/wp-includes/blocks/post-comments-form/style-rtl.min.css\";i:278;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/post-comments-form/style.css\";i:279;s:78:\"/home/oouaeco1/public_html/wp-includes/blocks/post-comments-form/style.min.css\";i:280;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/post-date/style-rtl.css\";i:281;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/post-date/style-rtl.min.css\";i:282;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/post-date/style.css\";i:283;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/post-date/style.min.css\";i:284;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/post-excerpt/editor-rtl.css\";i:285;s:77:\"/home/oouaeco1/public_html/wp-includes/blocks/post-excerpt/editor-rtl.min.css\";i:286;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/post-excerpt/editor.css\";i:287;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/post-excerpt/editor.min.css\";i:288;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/post-excerpt/style-rtl.css\";i:289;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/post-excerpt/style-rtl.min.css\";i:290;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/post-excerpt/style.css\";i:291;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/post-excerpt/style.min.css\";i:292;s:80:\"/home/oouaeco1/public_html/wp-includes/blocks/post-featured-image/editor-rtl.css\";i:293;s:84:\"/home/oouaeco1/public_html/wp-includes/blocks/post-featured-image/editor-rtl.min.css\";i:294;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/post-featured-image/editor.css\";i:295;s:80:\"/home/oouaeco1/public_html/wp-includes/blocks/post-featured-image/editor.min.css\";i:296;s:79:\"/home/oouaeco1/public_html/wp-includes/blocks/post-featured-image/style-rtl.css\";i:297;s:83:\"/home/oouaeco1/public_html/wp-includes/blocks/post-featured-image/style-rtl.min.css\";i:298;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/post-featured-image/style.css\";i:299;s:79:\"/home/oouaeco1/public_html/wp-includes/blocks/post-featured-image/style.min.css\";i:300;s:80:\"/home/oouaeco1/public_html/wp-includes/blocks/post-navigation-link/style-rtl.css\";i:301;s:84:\"/home/oouaeco1/public_html/wp-includes/blocks/post-navigation-link/style-rtl.min.css\";i:302;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/post-navigation-link/style.css\";i:303;s:80:\"/home/oouaeco1/public_html/wp-includes/blocks/post-navigation-link/style.min.css\";i:304;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/post-template/editor-rtl.css\";i:305;s:78:\"/home/oouaeco1/public_html/wp-includes/blocks/post-template/editor-rtl.min.css\";i:306;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/post-template/editor.css\";i:307;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/post-template/editor.min.css\";i:308;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/post-template/style-rtl.css\";i:309;s:77:\"/home/oouaeco1/public_html/wp-includes/blocks/post-template/style-rtl.min.css\";i:310;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/post-template/style.css\";i:311;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/post-template/style.min.css\";i:312;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/post-terms/style-rtl.css\";i:313;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/post-terms/style-rtl.min.css\";i:314;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/post-terms/style.css\";i:315;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/post-terms/style.min.css\";i:316;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/post-title/style-rtl.css\";i:317;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/post-title/style-rtl.min.css\";i:318;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/post-title/style.css\";i:319;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/post-title/style.min.css\";i:320;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/preformatted/style-rtl.css\";i:321;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/preformatted/style-rtl.min.css\";i:322;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/preformatted/style.css\";i:323;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/preformatted/style.min.css\";i:324;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/pullquote/editor-rtl.css\";i:325;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/pullquote/editor-rtl.min.css\";i:326;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/pullquote/editor.css\";i:327;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/pullquote/editor.min.css\";i:328;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/pullquote/style-rtl.css\";i:329;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/pullquote/style-rtl.min.css\";i:330;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/pullquote/style.css\";i:331;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/pullquote/style.min.css\";i:332;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/pullquote/theme-rtl.css\";i:333;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/pullquote/theme-rtl.min.css\";i:334;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/pullquote/theme.css\";i:335;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/pullquote/theme.min.css\";i:336;s:85:\"/home/oouaeco1/public_html/wp-includes/blocks/query-pagination-numbers/editor-rtl.css\";i:337;s:89:\"/home/oouaeco1/public_html/wp-includes/blocks/query-pagination-numbers/editor-rtl.min.css\";i:338;s:81:\"/home/oouaeco1/public_html/wp-includes/blocks/query-pagination-numbers/editor.css\";i:339;s:85:\"/home/oouaeco1/public_html/wp-includes/blocks/query-pagination-numbers/editor.min.css\";i:340;s:77:\"/home/oouaeco1/public_html/wp-includes/blocks/query-pagination/editor-rtl.css\";i:341;s:81:\"/home/oouaeco1/public_html/wp-includes/blocks/query-pagination/editor-rtl.min.css\";i:342;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/query-pagination/editor.css\";i:343;s:77:\"/home/oouaeco1/public_html/wp-includes/blocks/query-pagination/editor.min.css\";i:344;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/query-pagination/style-rtl.css\";i:345;s:80:\"/home/oouaeco1/public_html/wp-includes/blocks/query-pagination/style-rtl.min.css\";i:346;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/query-pagination/style.css\";i:347;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/query-pagination/style.min.css\";i:348;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/query-title/style-rtl.css\";i:349;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/query-title/style-rtl.min.css\";i:350;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/query-title/style.css\";i:351;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/query-title/style.min.css\";i:352;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/query/editor-rtl.css\";i:353;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/query/editor-rtl.min.css\";i:354;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/query/editor.css\";i:355;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/query/editor.min.css\";i:356;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/quote/style-rtl.css\";i:357;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/quote/style-rtl.min.css\";i:358;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/quote/style.css\";i:359;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/quote/style.min.css\";i:360;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/quote/theme-rtl.css\";i:361;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/quote/theme-rtl.min.css\";i:362;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/quote/theme.css\";i:363;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/quote/theme.min.css\";i:364;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/read-more/style-rtl.css\";i:365;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/read-more/style-rtl.min.css\";i:366;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/read-more/style.css\";i:367;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/read-more/style.min.css\";i:368;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/rss/editor-rtl.css\";i:369;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/rss/editor-rtl.min.css\";i:370;s:60:\"/home/oouaeco1/public_html/wp-includes/blocks/rss/editor.css\";i:371;s:64:\"/home/oouaeco1/public_html/wp-includes/blocks/rss/editor.min.css\";i:372;s:63:\"/home/oouaeco1/public_html/wp-includes/blocks/rss/style-rtl.css\";i:373;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/rss/style-rtl.min.css\";i:374;s:59:\"/home/oouaeco1/public_html/wp-includes/blocks/rss/style.css\";i:375;s:63:\"/home/oouaeco1/public_html/wp-includes/blocks/rss/style.min.css\";i:376;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/search/editor-rtl.css\";i:377;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/search/editor-rtl.min.css\";i:378;s:63:\"/home/oouaeco1/public_html/wp-includes/blocks/search/editor.css\";i:379;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/search/editor.min.css\";i:380;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/search/style-rtl.css\";i:381;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/search/style-rtl.min.css\";i:382;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/search/style.css\";i:383;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/search/style.min.css\";i:384;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/search/theme-rtl.css\";i:385;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/search/theme-rtl.min.css\";i:386;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/search/theme.css\";i:387;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/search/theme.min.css\";i:388;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/separator/editor-rtl.css\";i:389;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/separator/editor-rtl.min.css\";i:390;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/separator/editor.css\";i:391;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/separator/editor.min.css\";i:392;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/separator/style-rtl.css\";i:393;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/separator/style-rtl.min.css\";i:394;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/separator/style.css\";i:395;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/separator/style.min.css\";i:396;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/separator/theme-rtl.css\";i:397;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/separator/theme-rtl.min.css\";i:398;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/separator/theme.css\";i:399;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/separator/theme.min.css\";i:400;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/shortcode/editor-rtl.css\";i:401;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/shortcode/editor-rtl.min.css\";i:402;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/shortcode/editor.css\";i:403;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/shortcode/editor.min.css\";i:404;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/site-logo/editor-rtl.css\";i:405;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/site-logo/editor-rtl.min.css\";i:406;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/site-logo/editor.css\";i:407;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/site-logo/editor.min.css\";i:408;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/site-logo/style-rtl.css\";i:409;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/site-logo/style-rtl.min.css\";i:410;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/site-logo/style.css\";i:411;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/site-logo/style.min.css\";i:412;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/site-tagline/editor-rtl.css\";i:413;s:77:\"/home/oouaeco1/public_html/wp-includes/blocks/site-tagline/editor-rtl.min.css\";i:414;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/site-tagline/editor.css\";i:415;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/site-tagline/editor.min.css\";i:416;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/site-title/editor-rtl.css\";i:417;s:75:\"/home/oouaeco1/public_html/wp-includes/blocks/site-title/editor-rtl.min.css\";i:418;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/site-title/editor.css\";i:419;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/site-title/editor.min.css\";i:420;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/site-title/style-rtl.css\";i:421;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/site-title/style-rtl.min.css\";i:422;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/site-title/style.css\";i:423;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/site-title/style.min.css\";i:424;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/social-link/editor-rtl.css\";i:425;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/social-link/editor-rtl.min.css\";i:426;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/social-link/editor.css\";i:427;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/social-link/editor.min.css\";i:428;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/social-links/editor-rtl.css\";i:429;s:77:\"/home/oouaeco1/public_html/wp-includes/blocks/social-links/editor-rtl.min.css\";i:430;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/social-links/editor.css\";i:431;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/social-links/editor.min.css\";i:432;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/social-links/style-rtl.css\";i:433;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/social-links/style-rtl.min.css\";i:434;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/social-links/style.css\";i:435;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/social-links/style.min.css\";i:436;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/spacer/editor-rtl.css\";i:437;s:71:\"/home/oouaeco1/public_html/wp-includes/blocks/spacer/editor-rtl.min.css\";i:438;s:63:\"/home/oouaeco1/public_html/wp-includes/blocks/spacer/editor.css\";i:439;s:67:\"/home/oouaeco1/public_html/wp-includes/blocks/spacer/editor.min.css\";i:440;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/spacer/style-rtl.css\";i:441;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/spacer/style-rtl.min.css\";i:442;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/spacer/style.css\";i:443;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/spacer/style.min.css\";i:444;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/table/editor-rtl.css\";i:445;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/table/editor-rtl.min.css\";i:446;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/table/editor.css\";i:447;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/table/editor.min.css\";i:448;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/table/style-rtl.css\";i:449;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/table/style-rtl.min.css\";i:450;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/table/style.css\";i:451;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/table/style.min.css\";i:452;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/table/theme-rtl.css\";i:453;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/table/theme-rtl.min.css\";i:454;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/table/theme.css\";i:455;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/table/theme.min.css\";i:456;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/tag-cloud/style-rtl.css\";i:457;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/tag-cloud/style-rtl.min.css\";i:458;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/tag-cloud/style.css\";i:459;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/tag-cloud/style.min.css\";i:460;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/template-part/editor-rtl.css\";i:461;s:78:\"/home/oouaeco1/public_html/wp-includes/blocks/template-part/editor-rtl.min.css\";i:462;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/template-part/editor.css\";i:463;s:74:\"/home/oouaeco1/public_html/wp-includes/blocks/template-part/editor.min.css\";i:464;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/template-part/theme-rtl.css\";i:465;s:77:\"/home/oouaeco1/public_html/wp-includes/blocks/template-part/theme-rtl.min.css\";i:466;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/template-part/theme.css\";i:467;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/template-part/theme.min.css\";i:468;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/term-description/style-rtl.css\";i:469;s:80:\"/home/oouaeco1/public_html/wp-includes/blocks/term-description/style-rtl.min.css\";i:470;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/term-description/style.css\";i:471;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/term-description/style.min.css\";i:472;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/text-columns/editor-rtl.css\";i:473;s:77:\"/home/oouaeco1/public_html/wp-includes/blocks/text-columns/editor-rtl.min.css\";i:474;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/text-columns/editor.css\";i:475;s:73:\"/home/oouaeco1/public_html/wp-includes/blocks/text-columns/editor.min.css\";i:476;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/text-columns/style-rtl.css\";i:477;s:76:\"/home/oouaeco1/public_html/wp-includes/blocks/text-columns/style-rtl.min.css\";i:478;s:68:\"/home/oouaeco1/public_html/wp-includes/blocks/text-columns/style.css\";i:479;s:72:\"/home/oouaeco1/public_html/wp-includes/blocks/text-columns/style.min.css\";i:480;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/verse/style-rtl.css\";i:481;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/verse/style-rtl.min.css\";i:482;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/verse/style.css\";i:483;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/verse/style.min.css\";i:484;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/video/editor-rtl.css\";i:485;s:70:\"/home/oouaeco1/public_html/wp-includes/blocks/video/editor-rtl.min.css\";i:486;s:62:\"/home/oouaeco1/public_html/wp-includes/blocks/video/editor.css\";i:487;s:66:\"/home/oouaeco1/public_html/wp-includes/blocks/video/editor.min.css\";i:488;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/video/style-rtl.css\";i:489;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/video/style-rtl.min.css\";i:490;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/video/style.css\";i:491;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/video/style.min.css\";i:492;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/video/theme-rtl.css\";i:493;s:69:\"/home/oouaeco1/public_html/wp-includes/blocks/video/theme-rtl.min.css\";i:494;s:61:\"/home/oouaeco1/public_html/wp-includes/blocks/video/theme.css\";i:495;s:65:\"/home/oouaeco1/public_html/wp-includes/blocks/video/theme.min.css\";}","yes");
INSERT INTO BXzlkOCF_options VALUES("122","theme_mods_twentytwentythree","a:2:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:0:{}}","yes");
INSERT INTO BXzlkOCF_options VALUES("123","current_theme","JupiterX","yes");
INSERT INTO BXzlkOCF_options VALUES("124","theme_mods_jupiterx","a:2:{i:0;b:0;s:18:\"custom_css_post_id\";i:-1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("125","theme_switched","","yes");
INSERT INTO BXzlkOCF_options VALUES("126","jupiterx","a:7:{s:28:\"envato_purchase_code_5177775\";s:36:\"0262ad62-1b14-4605-af4b-c7e0a1cb4a88\";s:7:\"api_key\";s:64:\"b7c7af51ec4e0a7943543699b680081eeba666477841cb3e14be131899186cc9\";s:16:\"api_access_token\";s:32:\"473d9cff82bbc73550f13b12bd17fab9\";s:13:\"theme_version\";s:5:\"3.5.6\";s:21:\"theme_current_version\";s:5:\"3.5.6\";s:28:\"first_installation_after_250\";b:1;s:11:\"svg_support\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("127","recovery_keys","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("128","yoast_migrations_free","a:1:{s:7:\"version\";s:4:\"21.2\";}","yes");
INSERT INTO BXzlkOCF_options VALUES("129","wpvivid_email_setting","a:3:{s:7:\"send_to\";a:0:{}s:6:\"always\";b:1;s:12:\"email_enable\";b:0;}","no");
INSERT INTO BXzlkOCF_options VALUES("130","wpvivid_compress_setting","a:7:{s:13:\"compress_type\";s:3:\"zip\";s:13:\"max_file_size\";i:200;s:11:\"no_compress\";b:1;s:13:\"use_temp_file\";i:1;s:13:\"use_temp_size\";i:16;s:17:\"exclude_file_size\";i:0;s:24:\"subpackage_plugin_upload\";b:0;}","no");
INSERT INTO BXzlkOCF_options VALUES("131","wpvivid_local_setting","a:2:{s:4:\"path\";s:14:\"wpvividbackups\";s:10:\"save_local\";i:1;}","no");
INSERT INTO BXzlkOCF_options VALUES("132","wpvivid_upload_setting","a:1:{s:15:\"remote_selected\";a:0:{}}","no");
INSERT INTO BXzlkOCF_options VALUES("133","wpvivid_common_setting","a:10:{s:18:\"max_execution_time\";i:300;s:17:\"log_save_location\";s:26:\"wpvividbackups/wpvivid_log\";s:16:\"max_backup_count\";i:3;s:14:\"show_admin_bar\";b:1;s:14:\"domain_include\";b:1;s:15:\"estimate_backup\";b:1;s:16:\"max_resume_count\";i:6;s:12:\"memory_limit\";s:4:\"256M\";s:20:\"restore_memory_limit\";s:4:\"512M\";s:12:\"migrate_size\";s:4:\"2048\";}","no");
INSERT INTO BXzlkOCF_options VALUES("134","wpvivid_init","init","no");
INSERT INTO BXzlkOCF_options VALUES("135","wpvivid_backup_list","a:0:{}","no");
INSERT INTO BXzlkOCF_options VALUES("136","wpvivid_remote_init","init","no");
INSERT INTO BXzlkOCF_options VALUES("137","wp-smush-settings","a:25:{s:4:\"auto\";b:1;s:5:\"lossy\";i:0;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:0;s:8:\"original\";b:0;s:6:\"backup\";b:0;s:8:\"no_scale\";b:0;s:10:\"png_to_jpg\";b:0;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:5:\"gform\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:0;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;s:8:\"webp_mod\";b:0;s:16:\"background_email\";b:0;}","yes");
INSERT INTO BXzlkOCF_options VALUES("138","njt_wa_review","1695722485","yes");
INSERT INTO BXzlkOCF_options VALUES("139","njt_wa_first_time_active","1","yes");
INSERT INTO BXzlkOCF_options VALUES("140","njt_popup_filebird_cross","1695722485","yes");
INSERT INTO BXzlkOCF_options VALUES("141","njt_notification_filebird_cross","1695722485","yes");
INSERT INTO BXzlkOCF_options VALUES("142","njt_wa_version","3.4.6","yes");
INSERT INTO BXzlkOCF_options VALUES("143","wpseo","a:106:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";i:2;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:21:\"post_type_made_public\";s:29:\"indexables_indexing_completed\";b:0;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"21.2\";s:16:\"previous_version\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:0;s:22:\"show_onboarding_notice\";b:0;s:18:\"first_activated_on\";i:1694426485;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:0:\"\";s:8:\"home_url\";s:18:\"https://oo-uae.com\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:0:{}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:28:\"wordproof_integration_active\";b:0;s:29:\"wordproof_integration_changed\";b:0;s:18:\"first_time_install\";b:0;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1652258756;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:11:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:14:\"e-landing-page\";i:3;s:12:\"sellkit_step\";i:4;s:9:\"portfolio\";i:5;s:14:\"jupiterx-codes\";i:6;s:14:\"jupiterx-fonts\";i:7;s:14:\"jupiterx-icons\";i:8;s:18:\"jet-engine-booking\";i:9;s:10:\"jet-engine\";i:10;s:10:\"case-study\";}s:28:\"last_known_public_taxonomies\";a:6:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";i:3;s:21:\"case-study-categories\";i:4;s:18:\"portfolio_category\";i:5;s:13:\"portfolio_tag\";}s:23:\"last_known_no_unindexed\";a:2:{s:27:\"wpseo_total_unindexed_terms\";i:1695636105;s:31:\"wpseo_unindexed_term_link_count\";i:1695636105;}s:14:\"new_post_types\";a:2:{i:8;s:18:\"jet-engine-booking\";i:9;s:10:\"jet-engine\";}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("144","wpseo_titles","a:248:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:20:\"title-e-landing-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-e-landing-page\";s:0:\"\";s:22:\"noindex-e-landing-page\";b:0;s:33:\"display-metabox-pt-e-landing-page\";b:1;s:33:\"post_types-e-landing-page-maintax\";i:0;s:31:\"schema-page-type-e-landing-page\";s:7:\"WebPage\";s:34:\"schema-article-type-e-landing-page\";s:4:\"None\";s:27:\"social-title-e-landing-page\";s:9:\"%%title%%\";s:33:\"social-description-e-landing-page\";s:0:\"\";s:31:\"social-image-url-e-landing-page\";s:0:\"\";s:30:\"social-image-id-e-landing-page\";i:0;s:23:\"title-elementor_library\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-elementor_library\";s:0:\"\";s:25:\"noindex-elementor_library\";b:0;s:36:\"display-metabox-pt-elementor_library\";b:1;s:36:\"post_types-elementor_library-maintax\";i:0;s:34:\"schema-page-type-elementor_library\";s:7:\"WebPage\";s:37:\"schema-article-type-elementor_library\";s:4:\"None\";s:30:\"social-title-elementor_library\";s:9:\"%%title%%\";s:36:\"social-description-elementor_library\";s:0:\"\";s:34:\"social-image-url-elementor_library\";s:0:\"\";s:33:\"social-image-id-elementor_library\";i:0;s:18:\"title-sellkit_step\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-sellkit_step\";s:0:\"\";s:20:\"noindex-sellkit_step\";b:0;s:31:\"display-metabox-pt-sellkit_step\";b:1;s:31:\"post_types-sellkit_step-maintax\";i:0;s:29:\"schema-page-type-sellkit_step\";s:7:\"WebPage\";s:32:\"schema-article-type-sellkit_step\";s:4:\"None\";s:25:\"social-title-sellkit_step\";s:9:\"%%title%%\";s:31:\"social-description-sellkit_step\";s:0:\"\";s:29:\"social-image-url-sellkit_step\";s:0:\"\";s:28:\"social-image-id-sellkit_step\";i:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:31:\"title-tax-case-study-categories\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:34:\"metadesc-tax-case-study-categories\";s:0:\"\";s:41:\"display-metabox-tax-case-study-categories\";b:1;s:33:\"noindex-tax-case-study-categories\";b:0;s:38:\"social-title-tax-case-study-categories\";s:23:\"%%term_title%% Archives\";s:44:\"social-description-tax-case-study-categories\";s:0:\"\";s:42:\"social-image-url-tax-case-study-categories\";s:0:\"\";s:41:\"social-image-id-tax-case-study-categories\";i:0;s:39:\"taxonomy-case-study-categories-ptparent\";i:0;s:15:\"title-portfolio\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-portfolio\";s:0:\"\";s:17:\"noindex-portfolio\";b:0;s:28:\"display-metabox-pt-portfolio\";b:1;s:28:\"post_types-portfolio-maintax\";i:0;s:26:\"schema-page-type-portfolio\";s:7:\"WebPage\";s:29:\"schema-article-type-portfolio\";s:4:\"None\";s:22:\"social-title-portfolio\";s:9:\"%%title%%\";s:28:\"social-description-portfolio\";s:0:\"\";s:26:\"social-image-url-portfolio\";s:0:\"\";s:25:\"social-image-id-portfolio\";i:0;s:25:\"title-ptarchive-portfolio\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-ptarchive-portfolio\";s:0:\"\";s:27:\"bctitle-ptarchive-portfolio\";s:0:\"\";s:27:\"noindex-ptarchive-portfolio\";b:0;s:32:\"social-title-ptarchive-portfolio\";s:21:\"%%pt_plural%% Archive\";s:38:\"social-description-ptarchive-portfolio\";s:0:\"\";s:36:\"social-image-url-ptarchive-portfolio\";s:0:\"\";s:35:\"social-image-id-ptarchive-portfolio\";i:0;s:20:\"title-jupiterx-codes\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-jupiterx-codes\";s:0:\"\";s:22:\"noindex-jupiterx-codes\";b:0;s:33:\"display-metabox-pt-jupiterx-codes\";b:1;s:33:\"post_types-jupiterx-codes-maintax\";i:0;s:31:\"schema-page-type-jupiterx-codes\";s:7:\"WebPage\";s:34:\"schema-article-type-jupiterx-codes\";s:4:\"None\";s:27:\"social-title-jupiterx-codes\";s:9:\"%%title%%\";s:33:\"social-description-jupiterx-codes\";s:0:\"\";s:31:\"social-image-url-jupiterx-codes\";s:0:\"\";s:30:\"social-image-id-jupiterx-codes\";i:0;s:20:\"title-jupiterx-fonts\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-jupiterx-fonts\";s:0:\"\";s:22:\"noindex-jupiterx-fonts\";b:0;s:33:\"display-metabox-pt-jupiterx-fonts\";b:1;s:33:\"post_types-jupiterx-fonts-maintax\";i:0;s:31:\"schema-page-type-jupiterx-fonts\";s:7:\"WebPage\";s:34:\"schema-article-type-jupiterx-fonts\";s:4:\"None\";s:27:\"social-title-jupiterx-fonts\";s:9:\"%%title%%\";s:33:\"social-description-jupiterx-fonts\";s:0:\"\";s:31:\"social-image-url-jupiterx-fonts\";s:0:\"\";s:30:\"social-image-id-jupiterx-fonts\";i:0;s:20:\"title-jupiterx-icons\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-jupiterx-icons\";s:0:\"\";s:22:\"noindex-jupiterx-icons\";b:0;s:33:\"display-metabox-pt-jupiterx-icons\";b:1;s:33:\"post_types-jupiterx-icons-maintax\";i:0;s:31:\"schema-page-type-jupiterx-icons\";s:7:\"WebPage\";s:34:\"schema-article-type-jupiterx-icons\";s:4:\"None\";s:27:\"social-title-jupiterx-icons\";s:9:\"%%title%%\";s:33:\"social-description-jupiterx-icons\";s:0:\"\";s:31:\"social-image-url-jupiterx-icons\";s:0:\"\";s:30:\"social-image-id-jupiterx-icons\";i:0;s:16:\"title-case-study\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-case-study\";s:0:\"\";s:18:\"noindex-case-study\";b:0;s:29:\"display-metabox-pt-case-study\";b:1;s:29:\"post_types-case-study-maintax\";i:0;s:27:\"schema-page-type-case-study\";s:7:\"WebPage\";s:30:\"schema-article-type-case-study\";s:4:\"None\";s:23:\"social-title-case-study\";s:9:\"%%title%%\";s:29:\"social-description-case-study\";s:0:\"\";s:27:\"social-image-url-case-study\";s:0:\"\";s:26:\"social-image-id-case-study\";i:0;s:26:\"title-ptarchive-case-study\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:29:\"metadesc-ptarchive-case-study\";s:0:\"\";s:28:\"bctitle-ptarchive-case-study\";s:0:\"\";s:28:\"noindex-ptarchive-case-study\";b:0;s:33:\"social-title-ptarchive-case-study\";s:21:\"%%pt_plural%% Archive\";s:39:\"social-description-ptarchive-case-study\";s:0:\"\";s:37:\"social-image-url-ptarchive-case-study\";s:0:\"\";s:36:\"social-image-id-ptarchive-case-study\";i:0;s:28:\"title-tax-portfolio_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-portfolio_category\";s:0:\"\";s:38:\"display-metabox-tax-portfolio_category\";b:1;s:30:\"noindex-tax-portfolio_category\";b:0;s:35:\"social-title-tax-portfolio_category\";s:23:\"%%term_title%% Archives\";s:41:\"social-description-tax-portfolio_category\";s:0:\"\";s:39:\"social-image-url-tax-portfolio_category\";s:0:\"\";s:38:\"social-image-id-tax-portfolio_category\";i:0;s:36:\"taxonomy-portfolio_category-ptparent\";i:0;s:23:\"title-tax-portfolio_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-tax-portfolio_tag\";s:0:\"\";s:33:\"display-metabox-tax-portfolio_tag\";b:1;s:25:\"noindex-tax-portfolio_tag\";b:0;s:30:\"social-title-tax-portfolio_tag\";s:23:\"%%term_title%% Archives\";s:36:\"social-description-tax-portfolio_tag\";s:0:\"\";s:34:\"social-image-url-tax-portfolio_tag\";s:0:\"\";s:33:\"social-image-id-tax-portfolio_tag\";i:0;s:31:\"taxonomy-portfolio_tag-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}","yes");
INSERT INTO BXzlkOCF_options VALUES("145","wpseo_social","a:20:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}s:12:\"mastodon_url\";s:0:\"\";}","yes");
INSERT INTO BXzlkOCF_options VALUES("146","limit_login_activation_timestamp","1695636085","yes");
INSERT INTO BXzlkOCF_options VALUES("147","limit_login_notice_enable_notify_timestamp","1692871285","yes");
INSERT INTO BXzlkOCF_options VALUES("148","jet_elements_download_button_encrypt_key_start","7368690147","yes");
INSERT INTO BXzlkOCF_options VALUES("149","jet_elements_download_button_encrypt_key_end","29391025473","yes");
INSERT INTO BXzlkOCF_options VALUES("150","jet_elements_download_button_encrypt_id_multiplier","595","yes");
INSERT INTO BXzlkOCF_options VALUES("151","elementor_version","3.16.4","yes");
INSERT INTO BXzlkOCF_options VALUES("152","elementor_install_history","a:1:{s:6:\"3.16.4\";i:1695636085;}","yes");
INSERT INTO BXzlkOCF_options VALUES("153","_elementor_editor_upgrade_notice_dismissed","1727172137","yes");
INSERT INTO BXzlkOCF_options VALUES("154","widget_jupiterx_social","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("155","widget_jupiterx_posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("156","wp_smush_global_stats","a:3:{s:22:\"image_attachment_count\";i:1;s:25:\"rescan_required_timestamp\";i:1695636090;s:22:\"optimized_images_count\";i:6;}","no");
INSERT INTO BXzlkOCF_options VALUES("157","wp-smush-optimize-list","","no");
INSERT INTO BXzlkOCF_options VALUES("158","wp-smush-reoptimize-list","","no");
INSERT INTO BXzlkOCF_options VALUES("159","wp-smush-error-items-list","","no");
INSERT INTO BXzlkOCF_options VALUES("160","wp-smush-ignored-items-list","","no");
INSERT INTO BXzlkOCF_options VALUES("161","wp-smush-animated-items-list","","no");
INSERT INTO BXzlkOCF_options VALUES("162","jet-license-data","a:1:{s:12:\"license-list\";a:0:{}}","yes");
INSERT INTO BXzlkOCF_options VALUES("163","_site_transient_timeout_jet_dashboard_license_expire_check","1695679286","no");
INSERT INTO BXzlkOCF_options VALUES("164","_site_transient_jet_dashboard_license_expire_check","true","no");
INSERT INTO BXzlkOCF_options VALUES("165","sellkit","a:3:{s:43:\"contact_segmentation_users_updating_started\";b:0;s:39:\"contact_segmentation_users_are_imported\";b:1;s:18:\"current_db_version\";s:5:\"1.2.7\";}","yes");
INSERT INTO BXzlkOCF_options VALUES("169","_transient_timeout_jupiterx_sellkit_pro_link","1695657688","no");
INSERT INTO BXzlkOCF_options VALUES("170","_transient_jupiterx_sellkit_pro_link","https://d1rfs5xwxtkv4m.cloudfront.net/updates/1.7.0/70e02766-e07c-404f-b148-070b6dd644ef/sellkit-pro-v1.7.0.zip?Expires=1696240888&Signature=rGfQPFd40fe6z~Oz1ay61~Epy6CoOpxoWU5yvdJtLnHH-mn1IN497TqtV2Vn5KE4UMcBm9pX8fUHI2zkEPC9XKqKcYw4Q5krhJV-ZHF7DyVBVLKJ9w78VvvqIzwyF83k3dGLmmAOG2nH7KNY7P0TYKgWspE-hGyhAV-kL2BZmfuIMBhYftNJhrVmTr-5WO5jWHg5Stl9zulEAXpgiMOPOC6oYd2I6VuKwnTo80maB~-P6ckv~hLfGZZEpzGF1YVpcEwtxwDWliDirGQrVKXKuWoY-QmBnPde8ahuhmZvMAClwqY7PblMuyYtJGpEuEzfKa5yFdV~zyK8RmNzWORb7w__&Key-Pair-Id=K2A7AZRN7F76V9","no");
INSERT INTO BXzlkOCF_options VALUES("173","jupiterx_tgmpa_plugins","a:25:{i:0;a:14:{s:2:\"id\";i:37690;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"Jupiter X Core\";s:4:\"slug\";s:13:\"jupiterx-core\";s:8:\"basename\";s:31:\"jupiterx-core/jupiterx-core.php\";s:7:\"img_url\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jupiterx-core-icon.png\";s:4:\"desc\";s:107:\"Enables the customizer settings in Jupiter X. Also, some other theme functionalities depend on this plugin.\";s:6:\"source\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/09/jupiterx-core-v3.5.6.zip\";s:7:\"version\";s:5:\"3.5.6\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:63:\"https://themes.artbees.net/docs/jupiter-x-core-plugin-overview/\";s:11:\"is_callable\";s:13:\"JupiterX_Core\";}i:1;a:12:{s:2:\"id\";i:37695;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:22:\"Advanced Custom Fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:8:\"basename\";s:30:\"advanced-custom-fields/acf.php\";s:7:\"img_url\";s:90:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-acf-icon.png\";s:4:\"desc\";s:134:\"Adds the page options to Jupiter X so you can override the global settings on each page. Add and edit extra fields to your post types.\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:11:\"is_callable\";s:3:\"ACF\";}i:2;a:12:{s:2:\"id\";i:37698;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Elementor\";s:4:\"slug\";s:9:\"elementor\";s:8:\"basename\";s:23:\"elementor/elementor.php\";s:7:\"img_url\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-elementor-icon.png\";s:4:\"desc\";s:162:\"The default page builder with Jupiter X. It allows you to edit the pages in a real WYSIWYG editor. Currently known as the most advanced page builder in the world.\";s:8:\"required\";s:4:\"true\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:74:\"https://help.artbees.net/getting-started/plugins/elementor-plugin-overview\";s:11:\"is_callable\";s:16:\"Elementor\\Plugin\";}i:3;a:15:{s:2:\"id\";i:37586;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:5:\"Raven\";s:4:\"slug\";s:5:\"raven\";s:8:\"basename\";s:15:\"raven/raven.php\";s:7:\"img_url\";s:92:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-raven-icon.png\";s:4:\"desc\";s:189:\"20+ new elements exclusively developed by Artbees for Elementor. Also, Header, Footer and custom post type templates in the Free version of Elementor will be available by using this plugin.\";s:6:\"source\";s:94:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2020/09/raven-v1.11.0.zip\";s:7:\"version\";s:6:\"1.11.0\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:70:\"https://help.artbees.net/getting-started/plugins/raven-plugin-overview\";s:11:\"is_callable\";s:12:\"Raven\\Plugin\";s:8:\"releases\";O:8:\"stdClass\":2:{s:6:\"item-0\";O:8:\"stdClass\":2:{s:14:\"_version_label\";s:1:\"I\";s:15:\"_version_number\";s:5:\"1.3.0\";}s:6:\"item-1\";O:8:\"stdClass\":2:{s:14:\"_version_label\";s:2:\"II\";s:15:\"_version_number\";s:5:\"1.3.1\";}}}i:4;a:18:{s:2:\"id\";i:37701;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:12:\"Jet Elements\";s:8:\"headline\";s:26:\"Get More Elementor Widgets\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/edflWQvInNc\";s:15:\"large_thumbnail\";s:83:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-elements-2.jpg\";s:4:\"slug\";s:12:\"jet-elements\";s:8:\"basename\";s:29:\"jet-elements/jet-elements.php\";s:7:\"img_url\";s:99:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-elements-icon.png\";s:4:\"desc\";s:62:\"Adds different Elements and widgets to Elementor page builder.\";s:6:\"source\";s:103:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-elements-v2.6.12.1.zip\";s:7:\"version\";s:8:\"2.6.12.1\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:60:\"https://themes.artbees.net/docs/jetelements-plugin-overview/\";s:11:\"is_callable\";s:12:\"Jet_Elements\";s:10:\"label_type\";s:8:\"Optional\";}i:5;a:18:{s:2:\"id\";i:37706;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Blog\";s:8:\"headline\";s:18:\"Create Better Blog\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/80LaNrv9fZ8\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Blog-2.jpg\";s:4:\"slug\";s:8:\"jet-blog\";s:8:\"basename\";s:21:\"jet-blog/jet-blog.php\";s:7:\"img_url\";s:95:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-blog-icon.png\";s:4:\"desc\";s:90:\"Adds advanced widgets to Elementor and let you build a powerful blog and magazine website.\";s:6:\"source\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-blog-v2.3.4.zip\";s:7:\"version\";s:5:\"2.3.4\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:56:\"https://themes.artbees.net/docs/jetblog-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Blog\";s:10:\"label_type\";s:8:\"Optional\";}i:6;a:18:{s:2:\"id\";i:37711;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Menu\";s:8:\"headline\";s:21:\"Create Advanced Menus\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/Pndy-eEgGsY\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Menu-2.jpg\";s:4:\"slug\";s:8:\"jet-menu\";s:8:\"basename\";s:21:\"jet-menu/jet-menu.php\";s:7:\"img_url\";s:95:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-menu-icon.png\";s:4:\"desc\";s:52:\"Advanced mega menu addon for Elementor page builder.\";s:6:\"source\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-menu-v2.4.0.zip\";s:7:\"version\";s:5:\"2.4.0\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:56:\"https://themes.artbees.net/docs/jetmenu-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Menu\";s:10:\"label_type\";s:8:\"Optional\";}i:7;a:18:{s:2:\"id\";i:37716;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Jet Popup\";s:8:\"headline\";s:25:\"Create Pop-ups and Modals\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/pgINfIT8hKk\";s:15:\"large_thumbnail\";s:78:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Popup.jpg\";s:4:\"slug\";s:9:\"jet-popup\";s:8:\"basename\";s:23:\"jet-popup/jet-popup.php\";s:7:\"img_url\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-popup-icon.png\";s:4:\"desc\";s:55:\"The advanced plugin for creating popups with Elementor.\";s:6:\"source\";s:97:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-popup-v2.0.1.zip\";s:7:\"version\";s:5:\"2.0.1\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:57:\"https://themes.artbees.net/docs/jetpopup-plugin-overview/\";s:11:\"is_callable\";s:9:\"Jet_Popup\";s:10:\"label_type\";s:8:\"Optional\";}i:8;a:18:{s:2:\"id\";i:37721;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"Jet Tabs\";s:8:\"headline\";s:41:\"Create Tabs with Extended Functionalities\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/WgOJEQrMEFg\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Tabs-2.jpg\";s:4:\"slug\";s:8:\"jet-tabs\";s:8:\"basename\";s:21:\"jet-tabs/jet-tabs.php\";s:7:\"img_url\";s:95:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-tabs-icon.png\";s:4:\"desc\";s:56:\"Advanced Tabs and Accordions for Elementor Page Builder.\";s:6:\"source\";s:97:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-tabs-v2.1.23.zip\";s:7:\"version\";s:6:\"2.1.23\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:56:\"https://themes.artbees.net/docs/jettabs-plugin-overview/\";s:11:\"is_callable\";s:8:\"Jet_Tabs\";s:10:\"label_type\";s:8:\"Optional\";}i:9;a:18:{s:2:\"id\";i:37726;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"Jet WooBuilder\";s:8:\"headline\";s:23:\"Customize Product Pages\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/vvMrjACSnzo\";s:15:\"large_thumbnail\";s:85:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-woobuilder-2.jpg\";s:4:\"slug\";s:15:\"jet-woo-builder\";s:8:\"basename\";s:35:\"jet-woo-builder/jet-woo-builder.php\";s:7:\"img_url\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-woobuilder-icon.png\";s:4:\"desc\";s:131:\"Custom shop templates for WooCommerce. Adds some widgets to Elementor that can be used inside and outside of WooCommerce templates.\";s:6:\"source\";s:105:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-woo-builder-v2.1.6.1.zip\";s:7:\"version\";s:7:\"2.1.6.1\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:62:\"https://themes.artbees.net/docs/jetwoobuilder-plugin-overview/\";s:11:\"is_callable\";s:15:\"Jet_Woo_Builder\";s:10:\"label_type\";s:8:\"Optional\";}i:10;a:18:{s:2:\"id\";i:37731;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:10:\"Jet Tricks\";s:8:\"headline\";s:21:\"Create Visual Effects\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/mfGuDEsixFs\";s:15:\"large_thumbnail\";s:81:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Tricks-2.jpg\";s:4:\"slug\";s:10:\"jet-tricks\";s:8:\"basename\";s:25:\"jet-tricks/jet-tricks.php\";s:7:\"img_url\";s:97:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-tricks-icon.png\";s:4:\"desc\";s:124:\"Use different eye-catching stylish animation effects and let your content become truly alive with outstanding visual tricks.\";s:6:\"source\";s:98:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-tricks-v1.4.4.zip\";s:7:\"version\";s:5:\"1.4.4\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:58:\"https://themes.artbees.net/docs/jettricks-plugin-overview/\";s:11:\"is_callable\";s:10:\"Jet_Tricks\";s:10:\"label_type\";s:8:\"Optional\";}i:11;a:18:{s:2:\"id\";i:37736;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:10:\"Jet Engine\";s:8:\"headline\";s:31:\"Create Dynamic Fields and Pages\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/aP_jHmX9hd4\";s:15:\"large_thumbnail\";s:81:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-Engine-2.jpg\";s:4:\"slug\";s:10:\"jet-engine\";s:8:\"basename\";s:25:\"jet-engine/jet-engine.php\";s:7:\"img_url\";s:97:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-engine-icon.png\";s:4:\"desc\";s:146:\"Create and manage custom post types, listings and booking forms for them. Completely compatible with Jupiter X Custom Post Type templates feature.\";s:6:\"source\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-engine-v3.2.3.2.zip\";s:7:\"version\";s:7:\"3.2.3.2\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:58:\"https://themes.artbees.net/docs/jetengine-plugin-overview/\";s:11:\"is_callable\";s:10:\"Jet_Engine\";s:10:\"label_type\";s:8:\"Optional\";}i:12;a:18:{s:2:\"id\";i:37741;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:16:\"Jet SmartFilters\";s:8:\"headline\";s:32:\"Create Filters For Any Post Type\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/uJ2efTTaxD8\";s:15:\"large_thumbnail\";s:87:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Jet-SmartFilters-2.jpg\";s:4:\"slug\";s:17:\"jet-smart-filters\";s:8:\"basename\";s:39:\"jet-smart-filters/jet-smart-filters.php\";s:7:\"img_url\";s:103:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jet-smartfilters-icon.png\";s:4:\"desc\";s:107:\"Adds easy-to-use AJAX filters and widgets to Elementor so you can easily manage your listings and products.\";s:6:\"source\";s:105:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-smart-filters-v3.2.0.zip\";s:7:\"version\";s:5:\"3.2.0\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:64:\"https://themes.artbees.net/docs/jetsmartfilters-plugin-overview/\";s:11:\"is_callable\";s:17:\"Jet_Smart_Filters\";s:10:\"label_type\";s:8:\"Optional\";}i:13;a:16:{s:2:\"id\";i:37746;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:40:\"WPBakery Page Builder (Modified Version)\";s:8:\"headline\";s:61:\"Use Another Page Builder to Migrate from Jupiter to Jupiter X\";s:15:\"large_thumbnail\";s:77:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/wpbakery.jpg\";s:4:\"slug\";s:17:\"js_composer_theme\";s:8:\"basename\";s:33:\"js_composer_theme/js_composer.php\";s:7:\"img_url\";s:99:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-js_composer_theme.svg\";s:4:\"desc\";s:140:\"Another page builder with Jupiter X. It can work along side Elementor. Best for the websites that want to migrate from Jupiter to Jupiter X.\";s:6:\"source\";s:111:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/09/jupiterx_js_composer_theme.7.0.zip\";s:7:\"version\";s:3:\"7.0\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:11:\"is_callable\";s:10:\"Vc_Manager\";s:10:\"label_type\";s:8:\"Optional\";}i:14;a:16:{s:2:\"id\";i:37751;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:13:\"Jupiter Donut\";s:8:\"headline\";s:48:\"Add Jupiter Shortcodes For WPBakery Page Builder\";s:15:\"large_thumbnail\";s:75:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/donut2.jpg\";s:4:\"slug\";s:13:\"jupiter-donut\";s:8:\"basename\";s:31:\"jupiter-donut/jupiter-donut.php\";s:7:\"img_url\";s:95:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-jupiter-donut.png\";s:4:\"desc\";s:205:\"80+ shortcodes for WPBakery Page Builder. These shortcodes were available in Jupiter and are necessary if you are migrating your theme from Jupiter to Jupiter X and still want to use WPBakery Page Builder.\";s:6:\"source\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jupiter-donut-v1.4.4.zip\";s:7:\"version\";s:5:\"1.4.4\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:11:\"is_callable\";s:13:\"Jupiter_Donut\";s:10:\"label_type\";s:8:\"Optional\";}i:15;a:17:{s:2:\"id\";i:37755;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:8:\"headline\";s:19:\"Create Field Groups\";s:15:\"large_thumbnail\";s:76:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/acf-pro.jpg\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:8:\"basename\";s:34:\"advanced-custom-fields-pro/acf.php\";s:7:\"img_url\";s:90:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-acf-icon.png\";s:4:\"desc\";s:134:\"Adds the page options to Jupiter X so you can override the global settings on each page. Add and edit extra fields to your post types.\";s:6:\"source\";s:114:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/advanced-custom-fields-pro-v6.2.0.zip\";s:7:\"version\";s:5:\"6.2.0\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:91:\"https://help.artbees.net/getting-started/plugins/advanced-custom-fields-pro-plugin-overview\";s:11:\"is_callable\";s:7:\"acf_pro\";s:10:\"label_type\";s:8:\"Optional\";}i:16;a:15:{s:2:\"id\";i:37759;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:23:\"Menu Icons by ThemeIsle\";s:8:\"headline\";s:17:\"Add Icons to Menu\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Menu-Icons.jpg\";s:4:\"slug\";s:10:\"menu-icons\";s:8:\"basename\";s:25:\"menu-icons/menu-icons.php\";s:7:\"img_url\";s:92:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-menu-icons.png\";s:4:\"desc\";s:30:\"Adds icons to your menu items.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:59:\"https://themes.artbees.net/docs/menu-icons-plugin-overview/\";s:11:\"is_callable\";s:10:\"Menu_Icons\";s:10:\"label_type\";s:8:\"Optional\";}i:17;a:18:{s:2:\"id\";i:37762;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:17:\"Slider Revolution\";s:8:\"headline\";s:14:\"Create Sliders\";s:5:\"video\";s:43:\"https://www.youtube.com/watch?v=mn5hC07aGvE\";s:15:\"large_thumbnail\";s:80:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/sliderrev-2.jpg\";s:4:\"slug\";s:9:\"revslider\";s:8:\"basename\";s:23:\"revslider/revslider.php\";s:7:\"img_url\";s:91:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/slider-revolution-icon.png\";s:4:\"desc\";s:55:\"One of the most advanced premium sliders for WordPress.\";s:6:\"source\";s:98:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/09/revslider.v6.6.16.zip\";s:7:\"version\";s:6:\"6.6.16\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:66:\"https://themes.artbees.net/docs/slider-revolution-plugin-overview/\";s:11:\"is_callable\";s:14:\"RevSliderFront\";s:10:\"label_type\";s:8:\"Optional\";}i:18;a:17:{s:2:\"id\";i:37767;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:13:\"Master Slider\";s:8:\"headline\";s:14:\"Create Sliders\";s:15:\"large_thumbnail\";s:82:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/Master-Slider.jpg\";s:4:\"slug\";s:12:\"masterslider\";s:8:\"basename\";s:29:\"masterslider/masterslider.php\";s:7:\"img_url\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-master-slider-icon.jpg\";s:4:\"desc\";s:55:\"One of the most advanced premium sliders for WordPress.\";s:6:\"source\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/masterslider-v3.6.5.zip\";s:7:\"version\";s:5:\"3.6.5\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:62:\"https://themes.artbees.net/docs/master-slider-plugin-overview/\";s:11:\"is_callable\";s:13:\"Master_Slider\";s:10:\"label_type\";s:8:\"Optional\";}i:19;a:17:{s:2:\"id\";i:37769;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:14:\"LayerSlider WP\";s:8:\"headline\";s:14:\"Create Sliders\";s:15:\"large_thumbnail\";s:85:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/LayerSlider-WP-2.jpg\";s:4:\"slug\";s:11:\"LayerSlider\";s:8:\"basename\";s:27:\"LayerSlider/layerslider.php\";s:7:\"img_url\";s:99:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-layer-slider-icon.png\";s:4:\"desc\";s:108:\"Popular advanced Slider plugin. Build and publish your sliders on your website. License is \"In-Stock Usage\".\";s:6:\"source\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/layersliderwp-v7.8.0.zip\";s:7:\"version\";s:5:\"7.8.0\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";s:9:\"more_link\";s:61:\"https://themes.artbees.net/docs/layer-slider-plugin-overview/\";s:11:\"is_callable\";s:9:\"LS_Config\";s:10:\"label_type\";s:8:\"Optional\";}i:20;a:15:{s:2:\"id\";i:37772;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:11:\"WooCommerce\";s:8:\"headline\";s:23:\"Build eCommerce Website\";s:15:\"large_thumbnail\";s:80:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/WooCommerce.jpg\";s:4:\"slug\";s:11:\"woocommerce\";s:8:\"basename\";s:27:\"woocommerce/woocommerce.php\";s:7:\"img_url\";s:98:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-woocommerce-icon.png\";s:4:\"desc\";s:131:\"Create and manage your e-commerce website with this plugin. After activating, the Shop section in the Customizer will be available.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:60:\"https://themes.artbees.net/docs/woocommerce-plugin-overview/\";s:11:\"is_callable\";s:11:\"WooCommerce\";s:10:\"label_type\";s:8:\"Optional\";}i:21;a:15:{s:2:\"id\";i:37774;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:24:\"Customizer Export/Import\";s:8:\"headline\";s:42:\"Add Export and Import Option to Customizer\";s:15:\"large_thumbnail\";s:93:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/customizer-import-export.jpg\";s:4:\"slug\";s:24:\"customizer-export-import\";s:8:\"basename\";s:53:\"customizer-export-import/customizer-export-import.php\";s:7:\"img_url\";s:111:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-customizer-export-import-icon.png\";s:4:\"desc\";s:112:\"Adds the Export and import option to the Customizer. Useful for theme migrations and moving to the child themes.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:73:\"https://themes.artbees.net/docs/customizer-export-import-plugin-overview/\";s:11:\"is_callable\";s:8:\"CEI_Core\";s:10:\"label_type\";s:8:\"Optional\";}i:22;a:15:{s:2:\"id\";i:37776;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:16:\"Customizer Reset\";s:8:\"headline\";s:26:\"Reset Theme Customizations\";s:15:\"large_thumbnail\";s:85:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/customizer-reset.jpg\";s:4:\"slug\";s:26:\"customizer-reset-by-wpzoom\";s:8:\"basename\";s:47:\"customizer-reset-by-wpzoom/customizer-reset.php\";s:7:\"img_url\";s:103:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2019/11/plugin-thumb-customizer-reset-icon.png\";s:4:\"desc\";s:107:\"Reset theme customizations made via WordPress Customizer. Useful for troubleshooting the customizer issues.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:65:\"https://themes.artbees.net/docs/customizer-reset-plugin-overview/\";s:11:\"is_callable\";s:21:\"ZOOM_Customizer_Reset\";s:10:\"label_type\";s:8:\"Optional\";}i:23;a:16:{s:2:\"id\";i:45885;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:8:\"WunderWP\";s:8:\"headline\";s:65:\"Build Pages Quickly With Presets and Reusable Styles or Templates\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/nW4vduTqD64\";s:15:\"large_thumbnail\";s:79:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2020/02/wunderwp-2.jpg\";s:4:\"slug\";s:8:\"wunderwp\";s:8:\"basename\";s:21:\"wunderwp/wunderwp.php\";s:7:\"img_url\";s:89:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2020/02/wunderwp_plugin_icon.png\";s:4:\"desc\";s:151:\"Save and reuse your Elementor styles or templates in the WunderWP Cloud or use readymade styles to quickly beautify your Elementor pages. All for free!\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:21:\"https://wunderwp.com/\";s:11:\"is_callable\";s:8:\"WunderWP\";s:10:\"label_type\";s:8:\"Optional\";}i:24;a:16:{s:2:\"id\";i:74379;s:10:\"theme_name\";s:8:\"jupiterx\";s:4:\"name\";s:9:\"Growmatik\";s:8:\"headline\";s:44:\"All-in-one Personalized Marketing Automation\";s:5:\"video\";s:50:\"https://www.youtube-nocookie.com/embed/vdk09PMWit4\";s:15:\"large_thumbnail\";s:78:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2020/08/growmatik.jpg\";s:4:\"slug\";s:40:\"marketing-automation-and-personalization\";s:8:\"basename\";s:54:\"marketing-automation-and-personalization/growmatik.php\";s:7:\"img_url\";s:83:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/2020/08/growmatik-logo.png\";s:4:\"desc\";s:150:\"Growmatik automates your marketing and personalizes your customer experience across their journey by highly-personalized web pages, emails and popups.\";s:8:\"required\";s:5:\"false\";s:11:\"recommended\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";s:9:\"more_link\";s:93:\"https://app.growmatik.ai/start/?utm_source=JupiterXSuggestedPlugin&utm_campaign=JupiterXAdmin\";s:11:\"is_callable\";s:9:\"Growmatik\";s:10:\"label_type\";s:8:\"Optional\";}}","no");
INSERT INTO BXzlkOCF_options VALUES("176","updraftplus_version","1.23.10","yes");
INSERT INTO BXzlkOCF_options VALUES("177","wpmudev_recommended_plugins_registered","a:1:{s:23:\"wp-smushit/wp-smush.php\";a:1:{s:13:\"registered_at\";i:1695636088;}}","no");
INSERT INTO BXzlkOCF_options VALUES("178","wpcf7","a:1:{s:7:\"version\";s:3:\"5.8\";}","yes");
INSERT INTO BXzlkOCF_options VALUES("179","leadin_activation_time","1695636088","yes");
INSERT INTO BXzlkOCF_options VALUES("184","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.3.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.3.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.3.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.3.1-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.3.1\";s:7:\"version\";s:5:\"6.3.1\";s:11:\"php_version\";s:5:\"7.0.0\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"6.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1695636090;s:15:\"version_checked\";s:5:\"6.3.1\";s:12:\"translations\";a:0:{}}","no");
INSERT INTO BXzlkOCF_options VALUES("185","maintenance_meta","a:4:{s:13:\"first_version\";s:4:\"4.06\";s:13:\"first_install\";i:1695636089;s:11:\"old_version\";b:0;s:20:\"hide_welcome_pointer\";b:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("186","mtnc_db_version","2","yes");
INSERT INTO BXzlkOCF_options VALUES("187","maintenance_options","a:26:{s:5:\"state\";b:1;s:10:\"page_title\";s:30:\"Site is undergoing maintenance\";s:7:\"heading\";s:22:\"Maintenance mode is on\";s:11:\"description\";s:57:\"Site will be available soon. Thank you for your patience!\";s:11:\"footer_text\";s:26:\"&copy; Orpheus Oriens 2023\";s:14:\"show_some_love\";s:0:\"\";s:10:\"logo_width\";i:220;s:11:\"logo_height\";s:0:\"\";s:4:\"logo\";s:0:\"\";s:11:\"retina_logo\";s:0:\"\";s:7:\"body_bg\";s:3:\"135\";s:17:\"bg_image_portrait\";s:0:\"\";s:13:\"preloader_img\";s:0:\"\";s:13:\"body_bg_color\";s:7:\"#111111\";s:17:\"controls_bg_color\";s:7:\"#111111\";s:10:\"font_color\";s:7:\"#ffffff\";s:16:\"body_font_family\";s:9:\"Open Sans\";s:16:\"body_font_subset\";s:5:\"Latin\";s:7:\"is_blur\";b:0;s:14:\"blur_intensity\";i:5;s:11:\"503_enabled\";b:0;s:15:\"gg_analytics_id\";s:0:\"\";s:8:\"is_login\";b:1;s:10:\"custom_css\";s:0:\"\";s:13:\"exclude_pages\";s:0:\"\";s:16:\"default_settings\";b:1;}","yes");
INSERT INTO BXzlkOCF_options VALUES("188","elementor_onboarded","1","yes");
INSERT INTO BXzlkOCF_options VALUES("189","elementor_tracker_notice","1","yes");
INSERT INTO BXzlkOCF_options VALUES("190","wp-smush-install-type","existing","no");
INSERT INTO BXzlkOCF_options VALUES("191","wp-smush-version","3.14.2","no");
INSERT INTO BXzlkOCF_options VALUES("192","nta_wa_restored","1","yes");
INSERT INTO BXzlkOCF_options VALUES("193","jet_engine_modules","a:3:{i:0;s:13:\"booking-forms\";i:1;s:18:\"listing-injections\";i:2;s:8:\"calendar\";}","yes");
INSERT INTO BXzlkOCF_options VALUES("195","googlesitekit_db_version","1.3.0","yes");
INSERT INTO BXzlkOCF_options VALUES("196","wp_smush_image_sizes_state","a:2:{s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:3:{s:5:\"width\";s:3:\"150\";s:6:\"height\";s:3:\"150\";s:4:\"crop\";b:1;}s:6:\"medium\";a:3:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";b:0;}s:5:\"large\";a:3:{s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:4:\"1024\";s:4:\"crop\";b:0;}s:9:\"1536x1536\";a:3:{s:5:\"width\";i:1536;s:6:\"height\";i:1536;s:4:\"crop\";b:0;}s:9:\"2048x2048\";a:3:{s:5:\"width\";i:2048;s:6:\"height\";i:2048;s:4:\"crop\";b:0;}s:18:\"Image Size 500x500\";a:3:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"crop\";b:1;}s:12:\"medium_large\";a:2:{s:5:\"width\";i:768;s:6:\"height\";i:0;}}s:4:\"hash\";i:54375313845;}","yes");
INSERT INTO BXzlkOCF_options VALUES("197","_transient_timeout_wp_smush_skip_image_sizes_recheck","1695639690","no");
INSERT INTO BXzlkOCF_options VALUES("198","_transient_wp_smush_skip_image_sizes_recheck","1","no");
INSERT INTO BXzlkOCF_options VALUES("202","wp-smush-optimization-global-stats","a:8:{s:4:\"time\";d:0.18;s:5:\"bytes\";i:19700;s:7:\"percent\";d:7.71;s:11:\"size_before\";i:255506;s:10:\"size_after\";i:235806;s:5:\"count\";i:1;s:14:\"attachment_ids\";s:3:\"135\";s:11:\"lossy_count\";i:0;}","no");
INSERT INTO BXzlkOCF_options VALUES("203","wpvivid_image_opt_task","a:8:{s:6:\"images\";a:1:{i:135;a:2:{s:2:\"id\";i:135;s:8:\"finished\";i:0;}}s:7:\"options\";a:0:{}s:6:\"status\";s:5:\"error\";s:16:\"last_update_time\";i:1695636090;s:5:\"retry\";i:0;s:3:\"log\";s:21:\"wpvivid-65115a7aaba35\";s:5:\"error\";s:10:\"Need login\";s:8:\"last_log\";s:41:\"Optimizing image failed. Error:Need login\";}","yes");
INSERT INTO BXzlkOCF_options VALUES("206","_transient_timeout_wpseo_total_unindexed_terms_limited","1695636990","no");
INSERT INTO BXzlkOCF_options VALUES("207","_transient_wpseo_total_unindexed_terms_limited","0","no");
INSERT INTO BXzlkOCF_options VALUES("208","_transient_timeout_wpseo_total_unindexed_post_type_archives","1695722490","no");
INSERT INTO BXzlkOCF_options VALUES("209","_transient_wpseo_total_unindexed_post_type_archives","0","no");
INSERT INTO BXzlkOCF_options VALUES("210","_transient_timeout_wpseo_total_unindexed_general_items","1695722490","no");
INSERT INTO BXzlkOCF_options VALUES("211","_transient_wpseo_total_unindexed_general_items","0","no");
INSERT INTO BXzlkOCF_options VALUES("212","_transient_timeout_wpseo_unindexed_post_link_count","1695722491","no");
INSERT INTO BXzlkOCF_options VALUES("213","_transient_wpseo_unindexed_post_link_count","1","no");
INSERT INTO BXzlkOCF_options VALUES("214","wp_smush_pre_3_12_6_site","0","no");
INSERT INTO BXzlkOCF_options VALUES("223","https_detection_errors","a:2:{s:23:\"ssl_verification_failed\";a:1:{i:0;s:24:\"SSL verification failed.\";}s:19:\"bad_response_source\";a:1:{i:0;s:55:\"It looks like the response did not come from this site.\";}}","yes");
INSERT INTO BXzlkOCF_options VALUES("232","jupiterx_custom_icon_sets_config","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("233","_transient_timeout_b61abe42a44c9623d93e71fe8667fc98","1696240894","no");
INSERT INTO BXzlkOCF_options VALUES("234","_transient_b61abe42a44c9623d93e71fe8667fc98","a:10:{s:80:\"/wp-content/plugins/jet-elements/assets/js/lib/google-maps/apple-maps-esque.json\";s:16:\"Apple Maps-esque\";s:76:\"/wp-content/plugins/jet-elements/assets/js/lib/google-maps/blue-essence.json\";s:12:\"Blue Essence\";s:74:\"/wp-content/plugins/jet-elements/assets/js/lib/google-maps/blue-water.json\";s:10:\"Blue Water\";s:75:\"/wp-content/plugins/jet-elements/assets/js/lib/google-maps/light-dream.json\";s:11:\"Light Dream\";s:73:\"/wp-content/plugins/jet-elements/assets/js/lib/google-maps/pale-dawn.json\";s:9:\"Pale Dawn\";s:69:\"/wp-content/plugins/jet-elements/assets/js/lib/google-maps/paper.json\";s:5:\"Paper\";s:78:\"/wp-content/plugins/jet-elements/assets/js/lib/google-maps/shades-of-grey.json\";s:14:\"Shades of Grey\";s:80:\"/wp-content/plugins/jet-elements/assets/js/lib/google-maps/subtle-grayscale.json\";s:16:\"Subtle Grayscale\";s:75:\"/wp-content/plugins/jet-elements/assets/js/lib/google-maps/ultra-light.json\";s:11:\"Ultra Light\";s:66:\"/wp-content/plugins/jet-elements/assets/js/lib/google-maps/wy.json\";s:2:\"WY\";}","no");
INSERT INTO BXzlkOCF_options VALUES("235","_site_transient_timeout_theme_roots","1695637894","no");
INSERT INTO BXzlkOCF_options VALUES("236","_site_transient_theme_roots","a:4:{s:8:\"jupiterx\";s:7:\"/themes\";s:15:\"twentytwentyone\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";s:15:\"twentytwentytwo\";s:7:\"/themes\";}","no");
INSERT INTO BXzlkOCF_options VALUES("237","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1695636096;s:7:\"checked\";a:4:{s:8:\"jupiterx\";s:5:\"3.5.6\";s:15:\"twentytwentyone\";s:3:\"1.8\";s:17:\"twentytwentythree\";s:3:\"1.2\";s:15:\"twentytwentytwo\";s:3:\"1.4\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:3:{s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"1.8\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.1.8.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.2\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.2.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.4.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}","no");
INSERT INTO BXzlkOCF_options VALUES("238","_elementor_global_css","a:6:{s:4:\"time\";i:1695636095;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:0:{}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;b:0;}","yes");
INSERT INTO BXzlkOCF_options VALUES("239","_transient_googlesitekit_verification_meta_tags","a:0:{}","yes");
INSERT INTO BXzlkOCF_options VALUES("243","wp_sellkit-database-updater_batch_4e5faf69d334643b36d21da2288acf","a:4:{i:0;a:2:{s:17:\"callback_function\";s:21:\"check_database_tables\";s:10:\"db_version\";s:5:\"1.0.0\";}i:1;a:2:{s:17:\"callback_function\";s:37:\"add_ip_column_to_contact_segmentation\";s:10:\"db_version\";s:5:\"1.2.1\";}i:2;a:2:{s:17:\"callback_function\";s:51:\"add_url_query_string_column_to_contact_segmentation\";s:10:\"db_version\";s:5:\"1.2.3\";}i:3;a:2:{s:17:\"callback_function\";s:24:\"add_funnel_contact_table\";s:10:\"db_version\";s:5:\"1.2.7\";}}","no");
INSERT INTO BXzlkOCF_options VALUES("249","_transient_doing_cron","1695636098.6707220077514648437500","yes");
INSERT INTO BXzlkOCF_options VALUES("250","acf_version","6.2.1","yes");
INSERT INTO BXzlkOCF_options VALUES("251","_transient_timeout_wpseo_total_unindexed_posts_limited","1695636998","no");
INSERT INTO BXzlkOCF_options VALUES("252","_transient_wpseo_total_unindexed_posts_limited","1","no");
INSERT INTO BXzlkOCF_options VALUES("253","_site_transient_timeout_browser_84fb6a68ab92a6d30981c69a1117885c","1696240900","no");
INSERT INTO BXzlkOCF_options VALUES("254","_site_transient_browser_84fb6a68ab92a6d30981c69a1117885c","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"117.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no");
INSERT INTO BXzlkOCF_options VALUES("255","_site_transient_timeout_php_check_38979a08dcd71638878b7b4419751271","1696240902","no");
INSERT INTO BXzlkOCF_options VALUES("256","_site_transient_php_check_38979a08dcd71638878b7b4419751271","a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:3:\"7.0\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","no");
INSERT INTO BXzlkOCF_options VALUES("260","_transient_timeout_wpseo_total_unindexed_posts","1695722505","no");
INSERT INTO BXzlkOCF_options VALUES("261","_transient_wpseo_total_unindexed_posts","1","no");
INSERT INTO BXzlkOCF_options VALUES("262","_transient_timeout_wpseo_total_unindexed_terms","1695722505","no");
INSERT INTO BXzlkOCF_options VALUES("263","_transient_wpseo_total_unindexed_terms","0","no");
INSERT INTO BXzlkOCF_options VALUES("264","_transient_timeout_wpseo_unindexed_term_link_count","1695722505","no");
INSERT INTO BXzlkOCF_options VALUES("265","_transient_wpseo_unindexed_term_link_count","0","no");
INSERT INTO BXzlkOCF_options VALUES("268","_transient_leadin_onboarding","true","yes");
INSERT INTO BXzlkOCF_options VALUES("269","_transient_timeout_jupiterx_templates_filters","1695722506","no");
INSERT INTO BXzlkOCF_options VALUES("270","_transient_jupiterx_templates_filters","a:6:{s:8:\"category\";a:16:{s:13:\"blog-magazine\";s:15:\"Blog / Magazine\";s:9:\"corporate\";s:9:\"Corporate\";s:18:\"creative-portfolio\";s:20:\"Creative / Portfolio\";s:9:\"education\";s:9:\"Education\";s:13:\"entertainment\";s:13:\"Entertainment\";s:6:\"events\";s:6:\"Events\";s:4:\"food\";s:4:\"Food\";s:13:\"health-beauty\";s:19:\"Health &amp; Beauty\";s:17:\"listing-directory\";s:19:\"Listing / Directory\";s:4:\"misc\";s:4:\"Misc\";s:10:\"non-profit\";s:10:\"Non Profit\";s:12:\"products-app\";s:14:\"Products / App\";s:7:\"service\";s:7:\"Service\";s:4:\"shop\";s:4:\"Shop\";s:6:\"sports\";s:6:\"Sports\";s:6:\"travel\";s:6:\"Travel\";}s:5:\"style\";a:4:{s:7:\"elegant\";s:7:\"Elegant\";s:4:\"flat\";s:4:\"Flat\";s:7:\"minimal\";s:7:\"Minimal\";s:8:\"parallax\";s:8:\"Parallax\";}s:12:\"content_type\";a:2:{s:10:\"multi_page\";s:10:\"Multi-Page\";s:8:\"one_page\";s:8:\"One Page\";}s:10:\"components\";a:6:{s:4:\"blog\";s:4:\"Blog\";s:12:\"booking_form\";s:13:\"Booking Forms\";s:5:\"popup\";s:5:\"Popup\";s:9:\"portfolio\";s:9:\"Portfolio\";s:4:\"shop\";s:4:\"Shop\";s:9:\"slideshow\";s:9:\"Slideshow\";}s:9:\"menu_type\";a:4:{s:6:\"burger\";s:6:\"Burger\";s:11:\"full_screen\";s:11:\"Full Screen\";s:9:\"mega_menu\";s:9:\"Mega Menu\";s:6:\"normal\";s:6:\"Normal\";}s:11:\"header_type\";a:4:{s:9:\"multi_row\";s:9:\"Multi Row\";s:7:\"regular\";s:7:\"Regular\";s:11:\"transparent\";s:11:\"Transparent\";s:8:\"vertical\";s:8:\"Vertical\";}}","no");
INSERT INTO BXzlkOCF_options VALUES("271","wpvivid_check_htaccess_rule_free","1","yes");
INSERT INTO BXzlkOCF_options VALUES("272","_elementor_installed_time","1695636107","yes");
INSERT INTO BXzlkOCF_options VALUES("273","elementor_remote_info_library","a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:27:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:9:\"portfolio\";i:15;s:7:\"pricing\";i:16;s:15:\"product archive\";i:17;s:5:\"Quote\";i:18;s:15:\"Service Details\";i:19;s:8:\"services\";i:20;s:11:\"single page\";i:21;s:11:\"single post\";i:22;s:14:\"single product\";i:23;s:5:\"stats\";i:24;s:9:\"subscribe\";i:25;s:4:\"team\";i:26;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:18:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:18:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:18:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:18:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:18:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:18:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:18:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:18:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:18:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:18:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:18:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:18:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:18:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:18:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:18:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:18:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:18:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:18:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:18:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:18:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:18:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:18:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:18:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:18:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:18:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:18:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:18:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:18:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:18:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:18:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:18:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:18:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:18:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:18:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:18:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:18:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:18:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:18:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:18:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:18:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:18:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:18:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:18:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:18:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:18:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:18:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:18:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:18:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:18:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:18:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:18:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:18:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:18:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:18:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:18:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:18:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:18:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:18:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:18:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:18:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:18:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:18:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:18:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:18:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:18:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:18:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:18:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:18:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:18:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:18:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:18:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:18:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:18:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:18:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:18:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:18:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:18:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:18:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:18:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:18:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:18:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:18:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:18:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:18:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:18:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:18:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:18:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:18:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:18:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:18:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:18:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:18:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:18:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:18:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:18:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:18:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:18:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:18:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:18:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:18:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:18:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:18:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:18:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:18:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:18:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:18:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:18:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:18:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:18:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:18:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:18:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:18:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:18:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:18:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:18:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:18:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:18:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:18:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:18:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:119;a:18:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:18:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:18:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:18:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:18:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:18:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:18:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:18:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:18:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:18:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:18:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:18:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:18:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:18:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:18:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:18:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:18:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:18:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:18:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:18:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:18:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:18:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:18:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:18:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:143;a:18:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:18:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:145;a:18:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:18:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:18:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:18:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:18:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:18:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:18:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:18:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:18:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:18:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:18:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:18:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:18:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:18:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:159;a:18:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:18:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:18:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:18:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:163;a:18:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:18:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:18:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:18:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:18:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:18:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:18:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:170;a:18:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:171;a:18:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:172;a:18:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:18:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:174;a:18:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:18:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:18:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:18:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:18:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:18:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:18:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:18:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:182;a:18:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:18:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:184;a:18:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:185;a:18:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:186;a:18:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:18:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:188;a:18:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:18:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:18:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:18:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:192;a:18:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:18:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:18:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:18:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:18:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:18:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:18:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:18:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:18:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:18:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:18:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:18:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:18:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:18:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:18:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:18:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:18:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:18:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:18:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:18:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:18:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:18:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:18:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:18:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:18:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:18:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:18:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:219;a:18:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:220;a:18:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:18:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:18:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Business\",\"Faq\",\"Footer\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:223;a:18:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:18:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:18:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Conference\",\"Contact\",\"Form\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:226;a:18:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:18:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:18:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:18:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:230;a:18:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:231;a:18:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:18:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:18:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:18:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:18:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:18:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:18:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"Creative Portfolio\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:238;a:18:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:18:{s:4:\"tmpl\";i:1414;s:2:\"id\";i:24079;s:5:\"title\";s:32:\"Fashion Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg\";s:12:\"tmpl_created\";i:1650988089;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Aesthetic\",\"Business\",\"Coming Soon\",\"Ecommerce\",\"Girly\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:18:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:241;a:18:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:18:{s:4:\"tmpl\";i:1430;s:2:\"id\";i:24434;s:5:\"title\";s:25:\"Wireframe &#8211; About 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg\";s:12:\"tmpl_created\";i:1653988697;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:243;a:18:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:18:{s:4:\"tmpl\";i:1436;s:2:\"id\";i:24515;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg\";s:12:\"tmpl_created\";i:1653988946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:66:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:245;a:18:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:18:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:18:{s:4:\"tmpl\";i:1429;s:2:\"id\";i:24421;s:5:\"title\";s:25:\"Wireframe &#8211; About 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg\";s:12:\"tmpl_created\";i:1653988579;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:248;a:18:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:18:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:18:{s:4:\"tmpl\";i:1417;s:2:\"id\";i:24116;s:5:\"title\";s:32:\"Tech Company &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg\";s:12:\"tmpl_created\";i:1650989265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"Business\",\"Coding\",\"Coming Soon\",\"Computer\",\"Developer\",\"IT\",\"Services\",\"Technology\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:18:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:252;a:18:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:18:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"Moving\",\"Storge\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:254;a:18:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:255;a:18:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:256;a:18:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:18:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:258;a:18:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:18:{s:4:\"tmpl\";i:1249;s:2:\"id\";i:22137;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647177194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:260;a:18:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"Medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:261;a:18:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"Contact\",\"from\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:262;a:18:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:263;a:18:{s:4:\"tmpl\";i:1432;s:2:\"id\";i:24461;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg\";s:12:\"tmpl_created\";i:1653988784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:264;a:18:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:265;a:18:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:18:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:18:{s:4:\"tmpl\";i:1440;s:2:\"id\";i:24563;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 4\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg\";s:12:\"tmpl_created\";i:1653989095;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:84:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:268;a:18:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:269;a:18:{s:4:\"tmpl\";i:1439;s:2:\"id\";i:24553;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 3\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg\";s:12:\"tmpl_created\";i:1653989057;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Professional\",\"Testimonial\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:18:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:271;a:18:{s:4:\"tmpl\";i:1435;s:2:\"id\";i:24504;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg\";s:12:\"tmpl_created\";i:1653988910;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:80:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:272;a:18:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:18:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:274;a:18:{s:4:\"tmpl\";i:1437;s:2:\"id\";i:24528;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg\";s:12:\"tmpl_created\";i:1653988981;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:18:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:18:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:277;a:18:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:60:\"[\"Contact\",\"Food\",\"Form\",\"Google Maps\",\"Info\",\"Testimonial\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:278;a:18:{s:4:\"tmpl\";i:1140;s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:279;a:18:{s:4:\"tmpl\";i:1244;s:2:\"id\";i:21393;s:5:\"title\";s:34:\"Interior Designer &#8211; Projects\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg\";s:12:\"tmpl_created\";i:1638823945;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/interior-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:93:\"[\"Creative\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Interior Design\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:18:{s:4:\"tmpl\";i:1148;s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:281;a:18:{s:4:\"tmpl\";i:670;s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:18:{s:4:\"tmpl\";i:1251;s:2:\"id\";i:22143;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1647177389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:283;a:18:{s:4:\"tmpl\";i:1155;s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:284;a:18:{s:4:\"tmpl\";i:1241;s:2:\"id\";i:21451;s:5:\"title\";s:26:\"Exhibition &#8211; Gallery\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg\";s:12:\"tmpl_created\";i:1638821855;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/exhibition-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"Art\",\"Creative\",\"Creative Portfolio\",\"Exhibition\",\"Gallery\",\"Portfolio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:285;a:18:{s:4:\"tmpl\";i:502;s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:286;a:18:{s:4:\"tmpl\";i:1159;s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:287;a:18:{s:4:\"tmpl\";i:1240;s:2:\"id\";i:21430;s:5:\"title\";s:30:\"Travel Blogger &#8211; Gallery\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg\";s:12:\"tmpl_created\";i:1638821592;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/travel-blogger-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Gallery\",\"Photography\",\"Slider\",\"Travel\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:288;a:18:{s:4:\"tmpl\";i:1149;s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:289;a:18:{s:4:\"tmpl\";i:1416;s:2:\"id\";i:24104;s:5:\"title\";s:33:\"Ceramics Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Ceramics-Shop.jpg\";s:12:\"tmpl_created\";i:1650988949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/ceramics-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:290;a:18:{s:4:\"tmpl\";i:557;s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:47;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:291;a:18:{s:4:\"tmpl\";i:1412;s:2:\"id\";i:24033;s:5:\"title\";s:37:\"Dance Studio &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Dance-Studio.jpg\";s:12:\"tmpl_created\";i:1649881344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/dance-studio-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:113:\"[\"Academy\",\"Business\",\"Dance Studio\",\"Form\",\"Pilates\",\"School\",\"Sport\",\"Teacher\",\"Training\",\"Under Construction\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:292;a:18:{s:4:\"tmpl\";i:1190;s:2:\"id\";i:18568;s:5:\"title\";s:32:\"Flower Delivery &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png\";s:12:\"tmpl_created\";i:1617546716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/flower-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Delivery\",\"Flower\",\"Landing Pages\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:874;s:11:\"trend_index\";i:763;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:293;a:18:{s:4:\"tmpl\";i:1145;s:2:\"id\";i:16917;s:5:\"title\";s:22:\"Webinar &#8211; Events\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610466822;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:36:\"[\"Events\",\"Landing Pages\",\"Webinar\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:821;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:294;a:18:{s:4:\"tmpl\";i:1413;s:2:\"id\";i:24049;s:5:\"title\";s:33:\"ECO Shop &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-ECO-Shop.jpg\";s:12:\"tmpl_created\";i:1649882053;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/eco-shop-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:110:\"[\"Aesthetic\",\"Business\",\"Creative\",\"Decor\",\"Health\",\"Help\",\"Lifestyle\",\"Products\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:295;a:18:{s:4:\"tmpl\";i:497;s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:43;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:296;a:18:{s:4:\"tmpl\";i:1154;s:2:\"id\";i:17079;s:5:\"title\";s:42:\"Calls Volunteer &#8211; Social Involvement\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png\";s:12:\"tmpl_created\";i:1610631774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:68:\"[\"Care\",\"Covid-19\",\"Help\",\"Involvement\",\"Landing Pages\",\"Volunteer\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:854;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:297;a:18:{s:4:\"tmpl\";i:1419;s:2:\"id\";i:24136;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Food-Blog.jpg\";s:12:\"tmpl_created\";i:1650990034;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:62:\"[\"Blog\",\"Business\",\"Coming Soon\",\"Cooking\",\"Education\",\"Food\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:298;a:18:{s:4:\"tmpl\";i:1142;s:2:\"id\";i:16836;s:5:\"title\";s:33:\"Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610464490;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:74:\"[\"Agency\",\"Business\",\"Landing Pages\",\"Marketing\",\"Marketing Landing Page\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:816;s:11:\"trend_index\";i:787;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:299;a:18:{s:4:\"tmpl\";i:1411;s:2:\"id\";i:24020;s:5:\"title\";s:35:\"Mobile App &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Mobile-App.jpg\";s:12:\"tmpl_created\";i:1649880955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/mobile-app-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"App\",\"Business\",\"Coding\",\"Computer\",\"Launch\",\"Mobile\",\"Under Construction\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:300;a:18:{s:4:\"tmpl\";i:498;s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:50;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:301;a:18:{s:4:\"tmpl\";i:1139;s:2:\"id\";i:16785;s:5:\"title\";s:42:\"Gym Promotion &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg\";s:12:\"tmpl_created\";i:1610455496;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:42:\"[\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:820;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:302;a:18:{s:4:\"tmpl\";i:1420;s:2:\"id\";i:24152;s:5:\"title\";s:32:\"Perfume Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Perfume-Shop.jpg\";s:12:\"tmpl_created\";i:1650990353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/perfume-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Business\",\"Coming Soon\",\"Cosmetics\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:303;a:18:{s:4:\"tmpl\";i:1185;s:2:\"id\";i:18492;s:5:\"title\";s:34:\"Bicycle Pre-Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png\";s:12:\"tmpl_created\";i:1617535552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Bicycle\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:871;s:11:\"trend_index\";i:826;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:304;a:18:{s:4:\"tmpl\";i:1418;s:2:\"id\";i:24126;s:5:\"title\";s:28:\"Skincare &#8211; Coming Soon\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Skincare.jpg\";s:12:\"tmpl_created\";i:1650989585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/skincare-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:128:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Coming Soon\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Services\",\"Skincare\",\"Treatment\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:305;a:18:{s:4:\"tmpl\";i:1181;s:2:\"id\";i:18349;s:5:\"title\";s:39:\"Virtual try-on glasses &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png\";s:12:\"tmpl_created\";i:1614772569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:64:\"[\"Fashion\",\"Glasses\",\"Landing Pages\",\"Online Service\",\"Virtual\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:848;s:11:\"trend_index\";i:803;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:306;a:18:{s:4:\"tmpl\";i:500;s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:77;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:307;a:18:{s:4:\"tmpl\";i:513;s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:57;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:308;a:18:{s:4:\"tmpl\";i:1410;s:2:\"id\";i:24004;s:5:\"title\";s:33:\"Skincare &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Skincare.jpg\";s:12:\"tmpl_created\";i:1649880534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/skincare-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:144:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Makeup\",\"Services\",\"Skincare\",\"Treatment\",\"Under Construction\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:309;a:18:{s:4:\"tmpl\";i:1172;s:2:\"id\";i:17458;s:5:\"title\";s:31:\"Moving Company &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png\";s:12:\"tmpl_created\";i:1612727025;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/moving-company-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"Landing Pages\",\"Movers\",\"Moving\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:826;s:11:\"trend_index\";i:767;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:310;a:18:{s:4:\"tmpl\";i:1415;s:2:\"id\";i:24092;s:5:\"title\";s:29:\"Vase Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Vase-Shop.jpg\";s:12:\"tmpl_created\";i:1650988613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/vase-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:311;a:18:{s:4:\"tmpl\";i:1186;s:2:\"id\";i:18517;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png\";s:12:\"tmpl_created\";i:1617539897;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:45:\"[\"Blog\",\"Coming Soon\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:844;s:11:\"trend_index\";i:672;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:312;a:18:{s:4:\"tmpl\";i:1167;s:2:\"id\";i:17379;s:5:\"title\";s:33:\"IT Service &#8211; Online Service\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png\";s:12:\"tmpl_created\";i:1612713022;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/it-service-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:41:\"[\"IT\",\"Landing Pages\",\"Remote\",\"Support\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:806;s:11:\"trend_index\";i:634;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:313;a:18:{s:4:\"tmpl\";i:1248;s:2:\"id\";i:22134;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647176713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:314;a:18:{s:4:\"tmpl\";i:512;s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:29;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:315;a:18:{s:4:\"tmpl\";i:1189;s:2:\"id\";i:18560;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1617542761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:843;s:11:\"trend_index\";i:561;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:316;a:18:{s:4:\"tmpl\";i:1225;s:2:\"id\";i:21041;s:5:\"title\";s:41:\"Business Consulting Company &#8211; About\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg\";s:12:\"tmpl_created\";i:1638797560;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/business-consulting-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Coach\",\"Collaboration\",\"Consulting\",\"Life Coach\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:317;a:18:{s:4:\"tmpl\";i:1187;s:2:\"id\";i:18528;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1617541784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:872;s:11:\"trend_index\";i:819;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:318;a:18:{s:4:\"tmpl\";i:1243;s:2:\"id\";i:21135;s:5:\"title\";s:28:\"Construction &#8211; Service\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg\";s:12:\"tmpl_created\";i:1638823202;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Architecture\",\"Construction\",\"Faq\",\"Services\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:319;a:18:{s:4:\"tmpl\";i:501;s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:8;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:320;a:18:{s:4:\"tmpl\";i:1174;s:2:\"id\";i:17504;s:5:\"title\";s:29:\"Hair Stylist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png\";s:12:\"tmpl_created\";i:1612883014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/hair-stylist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:59:\"[\"Business\",\"Hair\",\"hairdresser\",\"Landing Pages\",\"Stylist\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:840;s:11:\"trend_index\";i:806;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:321;a:18:{s:4:\"tmpl\";i:1223;s:2:\"id\";i:20981;s:5:\"title\";s:37:\"Creative Digital Agency &#8211; About\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg\";s:12:\"tmpl_created\";i:1638789303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/creative-digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"About\",\"Advisor\",\"Creative\",\"Creative Portfolio\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:322;a:18:{s:4:\"tmpl\";i:1184;s:2:\"id\";i:18449;s:5:\"title\";s:45:\"Aesthetic Clinic &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png\";s:12:\"tmpl_created\";i:1616682181;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:57:\"[\"Aesthetic\",\"Beauty\",\"Fitness\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:859;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:323;a:18:{s:4:\"tmpl\";i:1221;s:2:\"id\";i:20926;s:5:\"title\";s:33:\"Doctors Online Consultation -Home\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg\";s:12:\"tmpl_created\";i:1638787371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/doctors-online-consultation-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"App\",\"Health\",\"Medical\",\"Online\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:324;a:18:{s:4:\"tmpl\";i:505;s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:142;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:325;a:18:{s:4:\"tmpl\";i:1165;s:2:\"id\";i:17353;s:5:\"title\";s:44:\"Online Cooking Course &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png\";s:12:\"tmpl_created\";i:1612705144;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Cooking\",\"Course Online\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:845;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:326;a:18:{s:4:\"tmpl\";i:1188;s:2:\"id\";i:18550;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1617542506;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:832;s:11:\"trend_index\";i:600;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:327;a:18:{s:4:\"tmpl\";i:1250;s:2:\"id\";i:22140;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1647177317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:328;a:18:{s:4:\"tmpl\";i:510;s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:46;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:329;a:18:{s:4:\"tmpl\";i:1191;s:2:\"id\";i:18539;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1617610273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:876;s:11:\"trend_index\";i:652;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:330;a:18:{s:4:\"tmpl\";i:1175;s:2:\"id\";i:18270;s:5:\"title\";s:24:\"Open week &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png\";s:12:\"tmpl_created\";i:1614767186;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/open-week-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:59:\"[\"Education\",\"Event\",\"Events\",\"Landing Pages\",\"University\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:831;s:11:\"trend_index\";i:673;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:331;a:18:{s:4:\"tmpl\";i:1177;s:2:\"id\";i:18300;s:5:\"title\";s:30:\"Makeup Artist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png\";s:12:\"tmpl_created\";i:1614768608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/makeup-artist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Beauty\",\"Business\",\"Course Online\",\"Landing Pages\",\"Makeup\",\"Online Service\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:861;s:11:\"trend_index\";i:783;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:332;a:18:{s:4:\"tmpl\";i:511;s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:161;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:333;a:18:{s:4:\"tmpl\";i:1179;s:2:\"id\";i:18329;s:5:\"title\";s:63:\"Online Real Estate Investment Conference &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-5.png\";s:12:\"tmpl_created\";i:1614770404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/lp/online-real-estate-investment-conference-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:76:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Online Event\",\"Real estate\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:866;s:11:\"trend_index\";i:779;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:334;a:18:{s:4:\"tmpl\";i:506;s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";i:1520443520;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:210;s:11:\"trend_index\";i:116;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:335;a:18:{s:4:\"tmpl\";i:1183;s:2:\"id\";i:18391;s:5:\"title\";s:45:\"Children&#8217;s Optometrist &#8211; Business\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Childrens-Optometrist.png\";s:12:\"tmpl_created\";i:1614773564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/childrens-optometrist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:85:\"[\"Business\",\"Children\",\"Eye\",\"Glasses\",\"Health\",\"Kids\",\"Landing Pages\",\"Optometrist\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:877;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:336;a:18:{s:4:\"tmpl\";i:1182;s:2:\"id\";i:18366;s:5:\"title\";s:30:\"Car Insurance &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Car-Insurance.png\";s:12:\"tmpl_created\";i:1614773263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/car-insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"car\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:869;s:11:\"trend_index\";i:797;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:337;a:18:{s:4:\"tmpl\";i:1201;s:2:\"id\";i:19144;s:5:\"title\";s:25:\"Birthday Party Invitation\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/06/250x280.png\";s:12:\"tmpl_created\";i:1623848691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/birthday-party-invitation/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Birthday\",\"Event\",\"Landing Pages\",\"Party\",\"RSVD\",\"Save the Date\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:338;a:18:{s:4:\"tmpl\";i:1124;s:2:\"id\";i:16473;s:5:\"title\";s:26:\"Beauty Salon &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/about-1.jpg\";s:12:\"tmpl_created\";i:1608622373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/beauty-salon-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:615;s:11:\"trend_index\";i:184;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:339;a:18:{s:4:\"tmpl\";i:1176;s:2:\"id\";i:18291;s:5:\"title\";s:47:\"Grill Restaurant Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Food-Delivery-LP.png\";s:12:\"tmpl_created\";i:1614767830;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/lp/grill-restaurant-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Delivery\",\"Delivery Service\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:819;s:11:\"trend_index\";i:685;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:340;a:18:{s:4:\"tmpl\";i:504;s:2:\"id\";i:5455;s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";i:1520443516;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:134;s:11:\"trend_index\";i:70;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:341;a:18:{s:4:\"tmpl\";i:1125;s:2:\"id\";i:16488;s:5:\"title\";s:28:\"Beauty Salon &#8211; Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/contact.jpg\";s:12:\"tmpl_created\";i:1608622374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:101;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:342;a:18:{s:4:\"tmpl\";i:1180;s:2:\"id\";i:18340;s:5:\"title\";s:30:\"Restaurant &#8211; Coming Soon\";s:9:\"thumbnail\";s:98:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Restuarant-Coming-Soon-LP.png\";s:12:\"tmpl_created\";i:1614772183;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/restaurant-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:51:\"[\"Coming Soon\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:810;s:11:\"trend_index\";i:809;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:343;a:18:{s:4:\"tmpl\";i:499;s:2:\"id\";i:5413;s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";i:1520443507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:83;s:11:\"trend_index\";i:52;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:344;a:18:{s:4:\"tmpl\";i:1126;s:2:\"id\";i:16496;s:5:\"title\";s:28:\"Beauty Salon &#8211; Gallery\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/12/gallery-1.jpg\";s:12:\"tmpl_created\";i:1608622379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:491;s:11:\"trend_index\";i:90;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:345;a:18:{s:4:\"tmpl\";i:1173;s:2:\"id\";i:17480;s:5:\"title\";s:42:\"At-home Massage Therapist &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/02/At-Home-Massage-Therapist.jpg\";s:12:\"tmpl_created\";i:1612879264;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/at-home-massage-therapist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:60:\"[\"Business\",\"Health\",\"Landing Pages\",\"Services\",\"Therapist\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:856;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:346;a:18:{s:4:\"tmpl\";i:1127;s:2:\"id\";i:16457;s:5:\"title\";s:25:\"Beauty Salon &#8211; Home\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/home-1.jpg\";s:12:\"tmpl_created\";i:1608622383;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/beauty-salon-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:408;s:11:\"trend_index\";i:56;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:347;a:18:{s:4:\"tmpl\";i:1178;s:2:\"id\";i:18317;s:5:\"title\";s:26:\"Insurance &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Life-Insirance.png\";s:12:\"tmpl_created\";i:1614769488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:61:\"[\"Business\",\"Family\",\"Financial\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:870;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:348;a:18:{s:4:\"tmpl\";i:1128;s:2:\"id\";i:16518;s:5:\"title\";s:29:\"Beauty Salon &#8211; Services\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/12/services-1.jpg\";s:12:\"tmpl_created\";i:1608622386;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/beauty-salon-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:664;s:11:\"trend_index\";i:261;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:349;a:18:{s:4:\"tmpl\";i:1168;s:2:\"id\";i:17401;s:5:\"title\";s:40:\"Conference Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280.png\";s:12:\"tmpl_created\";i:1612724753;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/conference-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:59:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:799;s:11:\"trend_index\";i:540;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:350;a:18:{s:4:\"tmpl\";i:503;s:2:\"id\";i:5447;s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";i:1520443514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:48;s:11:\"trend_index\";i:12;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:351;a:18:{s:4:\"tmpl\";i:1073;s:2:\"id\";i:15486;s:5:\"title\";s:25:\"Travel Blog &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/About.jpg\";s:12:\"tmpl_created\";i:1606215720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/travel-blog-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:608;s:11:\"trend_index\";i:343;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:352;a:18:{s:4:\"tmpl\";i:1166;s:2:\"id\";i:17368;s:5:\"title\";s:38:\"Real Estate Agency &#8211; Real-Estate\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Real-Estate.png\";s:12:\"tmpl_created\";i:1612711814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/real-estate-agency-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:73:\"[\"Landing Pages\",\"listing\",\"Real estate\",\"Realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:858;s:11:\"trend_index\";i:777;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:353;a:18:{s:4:\"tmpl\";i:1074;s:2:\"id\";i:15478;s:5:\"title\";s:27:\"Travel Blog &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1606215735;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-blog-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:687;s:11:\"trend_index\";i:564;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:354;a:18:{s:4:\"tmpl\";i:1170;s:2:\"id\";i:17423;s:5:\"title\";s:57:\"Volunteer Calls Thank You Page &#8211; Social Involvement\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/02/Volunteer-Calls-TYP.jpg\";s:12:\"tmpl_created\";i:1612726058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/volunteer-calls-thank-you-page-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:62:\"[\"Care\",\"Involvement\",\"Landing Pages\",\"Thank You\",\"Volunteer\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:857;s:11:\"trend_index\";i:818;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:355;a:18:{s:4:\"tmpl\";i:507;s:2:\"id\";i:5480;s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";i:1520443522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-4-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:428;s:11:\"trend_index\";i:303;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:356;a:18:{s:4:\"tmpl\";i:1075;s:2:\"id\";i:15467;s:5:\"title\";s:24:\"Travel Blog &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/11/Home.jpg\";s:12:\"tmpl_created\";i:1606215756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/travel-blog-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:567;s:11:\"trend_index\";i:224;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:357;a:18:{s:4:\"tmpl\";i:1169;s:2:\"id\";i:17409;s:5:\"title\";s:37:\"Webinar Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Webinar-TYP.png\";s:12:\"tmpl_created\";i:1612725644;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/webinar-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:56:\"[\"Event\",\"Events\",\"Landing Pages\",\"Thank You\",\"Webinar\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:868;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:358;a:18:{s:4:\"tmpl\";i:1056;s:2:\"id\";i:15317;s:5:\"title\";s:25:\"Dance Studio &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg\";s:12:\"tmpl_created\";i:1603181291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/dance-studio-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:596;s:11:\"trend_index\";i:301;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:359;a:18:{s:4:\"tmpl\";i:545;s:2:\"id\";i:6027;s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";i:1520443639;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-5-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:40;s:11:\"trend_index\";i:40;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:360;a:18:{s:4:\"tmpl\";i:1160;s:2:\"id\";i:17258;s:5:\"title\";s:32:\"Beauty Product &#8211; eCommerce\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Beauty-Product.png\";s:12:\"tmpl_created\";i:1610903153;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/beauty-product-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:38:\"[\"Beauty\",\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:797;s:11:\"trend_index\";i:703;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:361;a:18:{s:4:\"tmpl\";i:1057;s:2:\"id\";i:15334;s:5:\"title\";s:26:\"Dance Studio &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg\";s:12:\"tmpl_created\";i:1603181364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/dance-studio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:626;s:11:\"trend_index\";i:373;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:362;a:18:{s:4:\"tmpl\";i:546;s:2:\"id\";i:6036;s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";i:1520443641;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-6-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:90;s:11:\"trend_index\";i:123;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:363;a:18:{s:4:\"tmpl\";i:1171;s:2:\"id\";i:17435;s:5:\"title\";s:39:\"Gym &#8211; App Service &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-4.png\";s:12:\"tmpl_created\";i:1612726462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/gym-app-service-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:58:\"[\"App\",\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:767;s:11:\"trend_index\";i:577;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:364;a:18:{s:4:\"tmpl\";i:1058;s:2:\"id\";i:15349;s:5:\"title\";s:28:\"Dance Studio &#8211; Classes\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg\";s:12:\"tmpl_created\";i:1603181425;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:629;s:11:\"trend_index\";i:458;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:365;a:18:{s:4:\"tmpl\";i:1156;s:2:\"id\";i:17111;s:5:\"title\";s:33:\"Sunglasses Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/01/Sunglasses-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610632408;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/sunglasses-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Ecommerce\",\"Fashion\",\"Landing Pages\",\"Sale\",\"Sunglasses\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:812;s:11:\"trend_index\";i:732;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:366;a:18:{s:4:\"tmpl\";i:1055;s:2:\"id\";i:15366;s:5:\"title\";s:29:\"Dance Studio &#8211; Schedule\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg\";s:12:\"tmpl_created\";i:1603181056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/dance-studio-schedule/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:698;s:11:\"trend_index\";i:602;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:367;a:18:{s:4:\"tmpl\";i:1157;s:2:\"id\";i:17223;s:5:\"title\";s:25:\"Fashion &#8211; eCommerce\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/01/Commerce-Fashion.png\";s:12:\"tmpl_created\";i:1610902553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/fashion-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:808;s:11:\"trend_index\";i:745;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:368;a:18:{s:4:\"tmpl\";i:1059;s:2:\"id\";i:15373;s:5:\"title\";s:28:\"Dance Studio &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Pricing.jpg\";s:12:\"tmpl_created\";i:1603181678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:731;s:11:\"trend_index\";i:661;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:369;a:18:{s:4:\"tmpl\";i:1151;s:2:\"id\";i:17017;s:5:\"title\";s:28:\"Shoes Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Shoes-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610535361;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/shoes-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:55:\"[\"Discount\",\"Ecommerce\",\"Landing Pages\",\"Sale\",\"Shoes\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:803;s:11:\"trend_index\";i:642;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:370;a:18:{s:4:\"tmpl\";i:508;s:2:\"id\";i:5488;s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";i:1520443524;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:307;s:11:\"trend_index\";i:169;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:371;a:18:{s:4:\"tmpl\";i:1060;s:2:\"id\";i:15384;s:5:\"title\";s:28:\"Dance Studio &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/10/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1603181738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:741;s:11:\"trend_index\";i:721;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:372;a:18:{s:4:\"tmpl\";i:556;s:2:\"id\";i:6122;s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";i:1520443661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:38;s:11:\"trend_index\";i:26;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:373;a:18:{s:4:\"tmpl\";i:1163;s:2:\"id\";i:17301;s:5:\"title\";s:53:\"Personal Chef &#8211; Thank You Page &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/TYP-Personal-Chef.jpg\";s:12:\"tmpl_created\";i:1610903622;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/personal-chef-thank-you-page-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:43:\"[\"Chef\",\"Food\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:823;s:11:\"trend_index\";i:754;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:374;a:18:{s:4:\"tmpl\";i:1042;s:2:\"id\";i:15158;s:5:\"title\";s:26:\"Psychologist &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/About.jpg\";s:12:\"tmpl_created\";i:1600157561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/psychologist-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:618;s:11:\"trend_index\";i:426;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:375;a:18:{s:4:\"tmpl\";i:1164;s:2:\"id\";i:17313;s:5:\"title\";s:60:\"Development Course  &#8211; Thank You Page &#8211; Education\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Dev-Course-TYP-.png\";s:12:\"tmpl_created\";i:1610903776;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/development-course-thank-you-page-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Education\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:834;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:376;a:18:{s:4:\"tmpl\";i:1045;s:2:\"id\";i:15197;s:5:\"title\";s:28:\"Psychologist &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1600160499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/psychologist-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:666;s:11:\"trend_index\";i:558;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:377;a:18:{s:4:\"tmpl\";i:509;s:2:\"id\";i:5496;s:5:\"title\";s:7:\"About 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png\";s:12:\"tmpl_created\";i:1520443526;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:523;s:11:\"trend_index\";i:453;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:378;a:18:{s:4:\"tmpl\";i:1041;s:2:\"id\";i:15142;s:5:\"title\";s:25:\"Psychologist &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Home.jpg\";s:12:\"tmpl_created\";i:1600156308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/psychologist-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:464;s:11:\"trend_index\";i:297;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:379;a:18:{s:4:\"tmpl\";i:1044;s:2:\"id\";i:15188;s:5:\"title\";s:28:\"Psychologist &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/09/Pricing.jpg\";s:12:\"tmpl_created\";i:1600159731;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/psychologist-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:732;s:11:\"trend_index\";i:537;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:380;a:18:{s:4:\"tmpl\";i:684;s:2:\"id\";i:8961;s:5:\"title\";s:9:\"archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg\";s:12:\"tmpl_created\";i:1528639909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:79;s:11:\"trend_index\";i:15;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:381;a:18:{s:4:\"tmpl\";i:1043;s:2:\"id\";i:15167;s:5:\"title\";s:29:\"Psychologist &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/09/Services.jpg\";s:12:\"tmpl_created\";i:1600158206;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/psychologist-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:606;s:11:\"trend_index\";i:379;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:382;a:18:{s:4:\"tmpl\";i:1036;s:2:\"id\";i:14932;s:5:\"title\";s:30:\"Flooring Company &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/About.png\";s:12:\"tmpl_created\";i:1597740110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/flooring-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:488;s:11:\"trend_index\";i:319;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:383;a:18:{s:4:\"tmpl\";i:685;s:2:\"id\";i:8969;s:5:\"title\";s:9:\"archive 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg\";s:12:\"tmpl_created\";i:1528700014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:250;s:11:\"trend_index\";i:124;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:384;a:18:{s:4:\"tmpl\";i:1037;s:2:\"id\";i:14998;s:5:\"title\";s:32:\"Flooring Company &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/08/Contact-Us.png\";s:12:\"tmpl_created\";i:1597740222;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/flooring-company-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:553;s:11:\"trend_index\";i:380;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:385;a:18:{s:4:\"tmpl\";i:1038;s:2:\"id\";i:14965;s:5:\"title\";s:32:\"Flooring Company &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/Gallery.png\";s:12:\"tmpl_created\";i:1597740353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/flooring-company-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:371;s:11:\"trend_index\";i:291;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:386;a:18:{s:4:\"tmpl\";i:686;s:2:\"id\";i:8973;s:5:\"title\";s:9:\"archive 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg\";s:12:\"tmpl_created\";i:1528700205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:176;s:11:\"trend_index\";i:54;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:387;a:18:{s:4:\"tmpl\";i:1282;s:2:\"id\";i:22417;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1647354987;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:388;a:18:{s:4:\"tmpl\";i:1040;s:2:\"id\";i:14947;s:5:\"title\";s:33:\"Flooring company &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/08/Services.png\";s:12:\"tmpl_created\";i:1597740551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/flooring-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:538;s:11:\"trend_index\";i:392;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:389;a:18:{s:4:\"tmpl\";i:1039;s:2:\"id\";i:14901;s:5:\"title\";s:29:\"Flooring Company &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Home.png\";s:12:\"tmpl_created\";i:1597740474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/flooring-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:387;s:11:\"trend_index\";i:185;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:390;a:18:{s:4:\"tmpl\";i:687;s:2:\"id\";i:8977;s:5:\"title\";s:9:\"archive 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg\";s:12:\"tmpl_created\";i:1528700326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:354;s:11:\"trend_index\";i:396;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:391;a:18:{s:4:\"tmpl\";i:1252;s:2:\"id\";i:22146;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1647177514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:392;a:18:{s:4:\"tmpl\";i:688;s:2:\"id\";i:8981;s:5:\"title\";s:9:\"archive 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg\";s:12:\"tmpl_created\";i:1528700484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:333;s:11:\"trend_index\";i:195;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:393;a:18:{s:4:\"tmpl\";i:1021;s:2:\"id\";i:14737;s:5:\"title\";s:32:\"Luxury Real Estate &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/About.png\";s:12:\"tmpl_created\";i:1595313527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/luxury-real-estate-about-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:150;s:11:\"trend_index\";i:447;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:394;a:18:{s:4:\"tmpl\";i:689;s:2:\"id\";i:8985;s:5:\"title\";s:9:\"archive 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg\";s:12:\"tmpl_created\";i:1528700612;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:204;s:11:\"trend_index\";i:95;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:395;a:18:{s:4:\"tmpl\";i:1020;s:2:\"id\";i:14756;s:5:\"title\";s:34:\"Luxury Real Estate &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Contact-Us.png\";s:12:\"tmpl_created\";i:1595313519;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/luxury-real-estate-contact-us-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:610;s:11:\"trend_index\";i:569;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:396;a:18:{s:4:\"tmpl\";i:1019;s:2:\"id\";i:14716;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Home.png\";s:12:\"tmpl_created\";i:1595313512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/luxury-real-estate-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:394;s:11:\"trend_index\";i:165;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:397;a:18:{s:4:\"tmpl\";i:690;s:2:\"id\";i:8989;s:5:\"title\";s:9:\"archive 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg\";s:12:\"tmpl_created\";i:1528701063;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:208;s:11:\"trend_index\";i:111;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:398;a:18:{s:4:\"tmpl\";i:1018;s:2:\"id\";i:14763;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; News\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/07/news-Archive.png\";s:12:\"tmpl_created\";i:1595313273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/luxury-real-estate-news-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:404;s:11:\"trend_index\";i:167;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:399;a:18:{s:4:\"tmpl\";i:1283;s:2:\"id\";i:22423;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1647355154;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:400;a:18:{s:4:\"tmpl\";i:691;s:2:\"id\";i:8996;s:5:\"title\";s:9:\"archive 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg\";s:12:\"tmpl_created\";i:1528701290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:227;s:11:\"trend_index\";i:153;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:401;a:18:{s:4:\"tmpl\";i:1010;s:2:\"id\";i:13960;s:5:\"title\";s:32:\"Japanese restaurant &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/06/Home-Page.jpg\";s:12:\"tmpl_created\";i:1592289775;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/japanese-restaurant-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:537;s:11:\"trend_index\";i:287;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:402;a:18:{s:4:\"tmpl\";i:1284;s:2:\"id\";i:22428;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1647355339;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:403;a:18:{s:4:\"tmpl\";i:692;s:2:\"id\";i:9001;s:5:\"title\";s:9:\"archive 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg\";s:12:\"tmpl_created\";i:1528701433;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:265;s:11:\"trend_index\";i:208;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:404;a:18:{s:4:\"tmpl\";i:1007;s:2:\"id\";i:13993;s:5:\"title\";s:45:\"Japanese restaurant &#8211; Chef&#8217;s Menu\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/06/Chef_s-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/japanese-restaurant-chefs-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:651;s:11:\"trend_index\";i:675;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:405;a:18:{s:4:\"tmpl\";i:1006;s:2:\"id\";i:14012;s:5:\"title\";s:36:\"Japanese restaurant &#8211; Bar Menu\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/06/Bar-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/japanese-restaurant-bar-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:735;s:11:\"trend_index\";i:829;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:406;a:18:{s:4:\"tmpl\";i:1005;s:2:\"id\";i:13917;s:5:\"title\";s:33:\"Japanese restaurant &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/06/About-Page.jpg\";s:12:\"tmpl_created\";i:1592289629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/japanese-restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:640;s:11:\"trend_index\";i:389;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:407;a:18:{s:4:\"tmpl\";i:997;s:2:\"id\";i:13528;s:5:\"title\";s:22:\"Barbershop &#8211; 404\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/05/404-Page.jpg\";s:12:\"tmpl_created\";i:1589893152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/barbershop-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:768;s:11:\"trend_index\";i:681;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:408;a:18:{s:4:\"tmpl\";i:1009;s:2:\"id\";i:13937;s:5:\"title\";s:35:\"Japanese restaurant &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1592289748;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/japanese-restaurant-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:648;s:11:\"trend_index\";i:551;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:409;a:18:{s:4:\"tmpl\";i:1008;s:2:\"id\";i:14030;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Events\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/06/Events-Page.jpg\";s:12:\"tmpl_created\";i:1592289713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/japanese-restaurant-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:723;s:11:\"trend_index\";i:711;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:410;a:18:{s:4:\"tmpl\";i:998;s:2:\"id\";i:13518;s:5:\"title\";s:26:\"Barbershop &#8211; Archive\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Blog-Page.jpg\";s:12:\"tmpl_created\";i:1589893157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/barbershop-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:737;s:11:\"trend_index\";i:523;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:411;a:18:{s:4:\"tmpl\";i:1016;s:2:\"id\";i:13984;s:5:\"title\";s:40:\"Japanese restaurant &#8211; Reservations\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/reservations.jpg\";s:12:\"tmpl_created\";i:1592294757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/japanese-restaurant-reservations/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:715;s:11:\"trend_index\";i:727;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:412;a:18:{s:4:\"tmpl\";i:999;s:2:\"id\";i:13479;s:5:\"title\";s:23:\"Barbershop &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Home-Page.jpg\";s:12:\"tmpl_created\";i:1589893275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/barbershop-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:106;s:16:\"popularity_index\";i:683;s:11:\"trend_index\";i:832;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:413;a:18:{s:4:\"tmpl\";i:996;s:2:\"id\";i:13604;s:5:\"title\";s:25:\"Barbershop &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1589893147;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/barbershop-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Footer\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:555;s:11:\"trend_index\";i:267;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:414;a:18:{s:4:\"tmpl\";i:1000;s:2:\"id\";i:13503;s:5:\"title\";s:24:\"Barbershop &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/05/About-Page.jpg\";s:12:\"tmpl_created\";i:1589893289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/barbershop-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:744;s:11:\"trend_index\";i:739;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:415;a:18:{s:4:\"tmpl\";i:995;s:2:\"id\";i:13612;s:5:\"title\";s:25:\"Barbershop &#8211; Header\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/06/barber-shop-header.jpg\";s:12:\"tmpl_created\";i:1589893142;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/barbershop-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Header\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:343;s:11:\"trend_index\";i:137;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:416;a:18:{s:4:\"tmpl\";i:1001;s:2:\"id\";i:13548;s:5:\"title\";s:27:\"Barbershop &#8211; Services\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/05/Services-Page.jpg\";s:12:\"tmpl_created\";i:1589893298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/barbershop-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:761;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:417;a:18:{s:4:\"tmpl\";i:1002;s:2:\"id\";i:13560;s:5:\"title\";s:26:\"Barbershop &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1589893307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/barbershop-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:109;s:16:\"popularity_index\";i:756;s:11:\"trend_index\";i:822;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:418;a:18:{s:4:\"tmpl\";i:1003;s:2:\"id\";i:13587;s:5:\"title\";s:26:\"Barbershop &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/05/Contact-Us-Page.jpg\";s:12:\"tmpl_created\";i:1589893315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/barbershop-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:110;s:16:\"popularity_index\";i:753;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:419;a:18:{s:4:\"tmpl\";i:982;s:2:\"id\";i:13307;s:5:\"title\";s:26:\"Online Course &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.jpg\";s:12:\"tmpl_created\";i:1587474541;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/online-course-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:230;s:11:\"trend_index\";i:125;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:420;a:18:{s:4:\"tmpl\";i:994;s:2:\"id\";i:13621;s:5:\"title\";s:30:\"Barbershop &#8211; Single Post\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/05/Single-Page.jpg\";s:12:\"tmpl_created\";i:1589893137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/barbershop-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:736;s:11:\"trend_index\";i:580;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:421;a:18:{s:4:\"tmpl\";i:1131;s:2:\"id\";i:16527;s:5:\"title\";s:24:\"Beauty Salon &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/12/404.jpg\";s:12:\"tmpl_created\";i:1608622517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/beauty-salon-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:29:\"[\"404\",\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:742;s:11:\"trend_index\";i:563;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:422;a:18:{s:4:\"tmpl\";i:983;s:2:\"id\";i:13328;s:5:\"title\";s:27:\"Online Course &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.jpg\";s:12:\"tmpl_created\";i:1587474558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/online-course-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:508;s:11:\"trend_index\";i:429;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:423;a:18:{s:4:\"tmpl\";i:984;s:2:\"id\";i:13338;s:5:\"title\";s:33:\"Online Course &#8211; Course Page\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Course-Page.png\";s:12:\"tmpl_created\";i:1587474574;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/online-course-course-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:113;s:16:\"popularity_index\";i:337;s:11:\"trend_index\";i:310;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:424;a:18:{s:4:\"tmpl\";i:985;s:2:\"id\";i:13352;s:5:\"title\";s:29:\"Online Course &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1587474591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/online-course-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:114;s:16:\"popularity_index\";i:565;s:11:\"trend_index\";i:533;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:425;a:18:{s:4:\"tmpl\";i:1130;s:2:\"id\";i:16535;s:5:\"title\";s:27:\"Beauty Salon &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Footer.jpg\";s:12:\"tmpl_created\";i:1608622498;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/beauty-salon-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:32:\"[\"Beauty Salon\",\"Footer\",\"Hair\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:524;s:11:\"trend_index\";i:126;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:426;a:18:{s:4:\"tmpl\";i:971;s:2:\"id\";i:13187;s:5:\"title\";s:33:\"Interior Design &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.png\";s:12:\"tmpl_created\";i:1586148661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/interior-design-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:331;s:11:\"trend_index\";i:264;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:427;a:18:{s:4:\"tmpl\";i:1453;s:2:\"id\";i:16346;s:5:\"title\";s:33:\"Your New Home &#8211; Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp3-l.png\";s:12:\"tmpl_created\";i:1660205402;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/your-new-home-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:31:\"[\"Landing Pages\",\"Real estate\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:428;a:18:{s:4:\"tmpl\";i:972;s:2:\"id\";i:13199;s:5:\"title\";s:29:\"Interior Design &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.png\";s:12:\"tmpl_created\";i:1586148666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/interior-design-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:316;s:11:\"trend_index\";i:334;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:429;a:18:{s:4:\"tmpl\";i:1129;s:2:\"id\";i:16545;s:5:\"title\";s:27:\"Beauty Salon &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Header.jpg\";s:12:\"tmpl_created\";i:1608622495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/beauty-salon-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:32:\"[\"Beauty Salon\",\"Hair\",\"Header\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:356;s:11:\"trend_index\";i:49;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:430;a:18:{s:4:\"tmpl\";i:973;s:2:\"id\";i:13214;s:5:\"title\";s:32:\"Interior Design &#8211; Projects\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/portfolio_s.jpg\";s:12:\"tmpl_created\";i:1586148672;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/interior-design-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:367;s:11:\"trend_index\";i:323;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:431;a:18:{s:4:\"tmpl\";i:641;s:2:\"id\";i:7686;s:5:\"title\";s:12:\"Blog Posts 1\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png\";s:12:\"tmpl_created\";i:1521558047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/blog-posts-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:26:\"[\"Archive\",\"Blog\",\"posts\"]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:131;s:11:\"trend_index\";i:152;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:432;a:18:{s:4:\"tmpl\";i:974;s:2:\"id\";i:13229;s:5:\"title\";s:31:\"Interior Design &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.png\";s:12:\"tmpl_created\";i:1586148677;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/interior-design-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:395;s:11:\"trend_index\";i:337;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:433;a:18:{s:4:\"tmpl\";i:959;s:2:\"id\";i:12948;s:5:\"title\";s:29:\"Photography &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Home_s.png\";s:12:\"tmpl_created\";i:1582093442;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photography-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:119;s:16:\"popularity_index\";i:241;s:11:\"trend_index\";i:201;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:434;a:18:{s:4:\"tmpl\";i:960;s:2:\"id\";i:12798;s:5:\"title\";s:25:\"Photography &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/About_s.png\";s:12:\"tmpl_created\";i:1582093446;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/photography-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:499;s:11:\"trend_index\";i:374;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:435;a:18:{s:4:\"tmpl\";i:484;s:2:\"id\";i:5283;s:5:\"title\";s:9:\"Clients 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png\";s:12:\"tmpl_created\";i:1520443478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-1-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:294;s:11:\"trend_index\";i:202;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:436;a:18:{s:4:\"tmpl\";i:961;s:2:\"id\";i:12868;s:5:\"title\";s:27:\"Photography &#8211; Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Contact_s.png\";s:12:\"tmpl_created\";i:1582093450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:121;s:16:\"popularity_index\";i:531;s:11:\"trend_index\";i:350;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:437;a:18:{s:4:\"tmpl\";i:962;s:2:\"id\";i:13056;s:5:\"title\";s:28:\"Photography &#8211; Wildlife\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/02/Wildlife_s.png\";s:12:\"tmpl_created\";i:1582093454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photography-wildlife/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:579;s:11:\"trend_index\";i:656;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:438;a:18:{s:4:\"tmpl\";i:487;s:2:\"id\";i:5306;s:5:\"title\";s:10:\"Clients 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png\";s:12:\"tmpl_created\";i:1520443484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:657;s:11:\"trend_index\";i:581;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:439;a:18:{s:4:\"tmpl\";i:963;s:2:\"id\";i:12922;s:5:\"title\";s:37:\"Photography &#8211; Glowing Jellyfish\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Jellyfish_S.png\";s:12:\"tmpl_created\";i:1582093457;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/photography-glowing-jellyfish/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:123;s:16:\"popularity_index\";i:628;s:11:\"trend_index\";i:532;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:440;a:18:{s:4:\"tmpl\";i:964;s:2:\"id\";i:12875;s:5:\"title\";s:36:\"Photography &#8211; Fluttering Birds\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Birds_s.png\";s:12:\"tmpl_created\";i:1582093461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/photography-fluttering-birds/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:124;s:16:\"popularity_index\";i:693;s:11:\"trend_index\";i:766;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:441;a:18:{s:4:\"tmpl\";i:965;s:2:\"id\";i:12962;s:5:\"title\";s:26:\"Photography &#8211; Nature\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Nature_s.png\";s:12:\"tmpl_created\";i:1582093465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/photography-nature/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:592;s:11:\"trend_index\";i:778;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:442;a:18:{s:4:\"tmpl\";i:491;s:2:\"id\";i:5341;s:5:\"title\";s:10:\"Clients 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png\";s:12:\"tmpl_created\";i:1520443491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:603;s:11:\"trend_index\";i:633;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:443;a:18:{s:4:\"tmpl\";i:966;s:2:\"id\";i:12833;s:5:\"title\";s:38:\"Photography &#8211; Blossoming Flowers\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Flowers_s.png\";s:12:\"tmpl_created\";i:1582093469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/photography-blossoming-flowers/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:597;s:11:\"trend_index\";i:750;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:444;a:18:{s:4:\"tmpl\";i:488;s:2:\"id\";i:5315;s:5:\"title\";s:10:\"Clients 12\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png\";s:12:\"tmpl_created\";i:1520443486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:485;s:11:\"trend_index\";i:263;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:445;a:18:{s:4:\"tmpl\";i:967;s:2:\"id\";i:12898;s:5:\"title\";s:36:\"Photography &#8211; Forest Mushrooms\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Mushrooms_s.png\";s:12:\"tmpl_created\";i:1582093473;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/photography-forest-mushrooms/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:127;s:16:\"popularity_index\";i:667;s:11:\"trend_index\";i:649;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:446;a:18:{s:4:\"tmpl\";i:968;s:2:\"id\";i:12994;s:5:\"title\";s:24:\"Photography &#8211; Pets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Pets_s.png\";s:12:\"tmpl_created\";i:1582093477;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/photography-pets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:128;s:16:\"popularity_index\";i:612;s:11:\"trend_index\";i:508;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:447;a:18:{s:4:\"tmpl\";i:969;s:2:\"id\";i:12805;s:5:\"title\";s:37:\"Photography &#8211; B&amp;W Portraits\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Black_s.png\";s:12:\"tmpl_created\";i:1582093481;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/photography-bw-portraits/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:695;s:11:\"trend_index\";i:735;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:448;a:18:{s:4:\"tmpl\";i:490;s:2:\"id\";i:5333;s:5:\"title\";s:10:\"Clients 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png\";s:12:\"tmpl_created\";i:1520443489;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:234;s:11:\"trend_index\";i:128;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:449;a:18:{s:4:\"tmpl\";i:970;s:2:\"id\";i:13031;s:5:\"title\";s:33:\"Photography &#8211; Vivid Parrots\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Parrots_s.png\";s:12:\"tmpl_created\";i:1582093484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/photography-vivid-parrots/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:660;s:11:\"trend_index\";i:643;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:450;a:18:{s:4:\"tmpl\";i:496;s:2:\"id\";i:5389;s:5:\"title\";s:10:\"Clients 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png\";s:12:\"tmpl_created\";i:1520443501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:407;s:11:\"trend_index\";i:307;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:451;a:18:{s:4:\"tmpl\";i:940;s:2:\"id\";i:12621;s:5:\"title\";s:26:\"Magazine &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/01/Home_s.png\";s:12:\"tmpl_created\";i:1579060604;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/magazine-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:131;s:16:\"popularity_index\";i:167;s:11:\"trend_index\";i:121;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:452;a:18:{s:4:\"tmpl\";i:936;s:2:\"id\";i:12352;s:5:\"title\";s:24:\"Travel &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/12/Home_s.png\";s:12:\"tmpl_created\";i:1575960464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/travel-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:291;s:11:\"trend_index\";i:194;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:453;a:18:{s:4:\"tmpl\";i:486;s:2:\"id\";i:5298;s:5:\"title\";s:10:\"Clients 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png\";s:12:\"tmpl_created\";i:1520443482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:465;s:11:\"trend_index\";i:520;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:454;a:18:{s:4:\"tmpl\";i:932;s:2:\"id\";i:12400;s:5:\"title\";s:20:\"Travel &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/12/About.png\";s:12:\"tmpl_created\";i:1575960441;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/travel-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:133;s:16:\"popularity_index\";i:444;s:11:\"trend_index\";i:445;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:455;a:18:{s:4:\"tmpl\";i:938;s:2:\"id\";i:12479;s:5:\"title\";s:20:\"Travel &#8211; Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Tours_s.png\";s:12:\"tmpl_created\";i:1575960474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/travel-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:539;s:11:\"trend_index\";i:726;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:456;a:18:{s:4:\"tmpl\";i:495;s:2:\"id\";i:5381;s:5:\"title\";s:10:\"Clients 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png\";s:12:\"tmpl_created\";i:1520443499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:198;s:11:\"trend_index\";i:168;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:457;a:18:{s:4:\"tmpl\";i:937;s:2:\"id\";i:12466;s:5:\"title\";s:27:\"Travel &#8211; Testimonials\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/Testimonials.png\";s:12:\"tmpl_created\";i:1575960469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-testimonials/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:135;s:16:\"popularity_index\";i:527;s:11:\"trend_index\";i:481;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:458;a:18:{s:4:\"tmpl\";i:935;s:2:\"id\";i:12443;s:5:\"title\";s:22:\"Travel &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Gallery.png\";s:12:\"tmpl_created\";i:1575960459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/travel-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:136;s:16:\"popularity_index\";i:467;s:11:\"trend_index\";i:501;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:459;a:18:{s:4:\"tmpl\";i:934;s:2:\"id\";i:12431;s:5:\"title\";s:18:\"Travel &#8211; FAQ\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/FAQ.png\";s:12:\"tmpl_created\";i:1575960453;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-faq/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:501;s:11:\"trend_index\";i:387;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:460;a:18:{s:4:\"tmpl\";i:493;s:2:\"id\";i:5357;s:5:\"title\";s:9:\"Clients 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png\";s:12:\"tmpl_created\";i:1520443495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:341;s:11:\"trend_index\";i:232;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:461;a:18:{s:4:\"tmpl\";i:933;s:2:\"id\";i:12421;s:5:\"title\";s:27:\"Travel &#8211; Contact Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/12/Contsct-Us.png\";s:12:\"tmpl_created\";i:1575960445;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-contact-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:138;s:16:\"popularity_index\";i:571;s:11:\"trend_index\";i:536;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:462;a:18:{s:4:\"tmpl\";i:892;s:2:\"id\";i:11763;s:5:\"title\";s:27:\"Portfolio &#8211; Home Page\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Homepage_small.png\";s:12:\"tmpl_created\";i:1569428959;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/portfolio-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:280;s:11:\"trend_index\";i:241;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:463;a:18:{s:4:\"tmpl\";i:485;s:2:\"id\";i:5290;s:5:\"title\";s:9:\"Clients 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png\";s:12:\"tmpl_created\";i:1520443480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:545;s:11:\"trend_index\";i:502;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:464;a:18:{s:4:\"tmpl\";i:891;s:2:\"id\";i:11781;s:5:\"title\";s:23:\"Portfolio &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/About_small.png\";s:12:\"tmpl_created\";i:1569428955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/portfolio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:140;s:16:\"popularity_index\";i:349;s:11:\"trend_index\";i:290;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:465;a:18:{s:4:\"tmpl\";i:482;s:2:\"id\";i:5266;s:5:\"title\";s:9:\"Clients 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png\";s:12:\"tmpl_created\";i:1520443474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:140;s:16:\"popularity_index\";i:95;s:11:\"trend_index\";i:134;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:466;a:18:{s:4:\"tmpl\";i:890;s:2:\"id\";i:11793;s:5:\"title\";s:26:\"Portfolio &#8211; Projects\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Projects_small.png\";s:12:\"tmpl_created\";i:1569428951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/portfolio-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:141;s:16:\"popularity_index\";i:448;s:11:\"trend_index\";i:467;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:467;a:18:{s:4:\"tmpl\";i:889;s:2:\"id\";i:11800;s:5:\"title\";s:25:\"Portfolio &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/09/Contact_small.png\";s:12:\"tmpl_created\";i:1569428946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/portfolio-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:494;s:11:\"trend_index\";i:449;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:468;a:18:{s:4:\"tmpl\";i:866;s:2:\"id\";i:11163;s:5:\"title\";s:32:\"Digital Agency &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/07/Home_small.png\";s:12:\"tmpl_created\";i:1564641877;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/digital-agency-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:143;s:16:\"popularity_index\";i:57;s:11:\"trend_index\";i:32;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:469;a:18:{s:4:\"tmpl\";i:483;s:2:\"id\";i:5275;s:5:\"title\";s:9:\"Clients 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png\";s:12:\"tmpl_created\";i:1520443476;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:143;s:16:\"popularity_index\";i:334;s:11:\"trend_index\";i:321;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:470;a:18:{s:4:\"tmpl\";i:492;s:2:\"id\";i:5349;s:5:\"title\";s:9:\"Clients 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png\";s:12:\"tmpl_created\";i:1520443493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:144;s:16:\"popularity_index\";i:233;s:11:\"trend_index\";i:92;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:471;a:18:{s:4:\"tmpl\";i:916;s:2:\"id\";i:12143;s:5:\"title\";s:22:\"Law Firm &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/about.png\";s:12:\"tmpl_created\";i:1572847069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/law-firm-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:146;s:16:\"popularity_index\";i:350;s:11:\"trend_index\";i:344;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:472;a:18:{s:4:\"tmpl\";i:489;s:2:\"id\";i:5324;s:5:\"title\";s:9:\"Clients 8\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png\";s:12:\"tmpl_created\";i:1520443488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:146;s:16:\"popularity_index\";i:526;s:11:\"trend_index\";i:381;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:473;a:18:{s:4:\"tmpl\";i:920;s:2:\"id\";i:12091;s:5:\"title\";s:21:\"Law Firm &#8211; Team\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/team.png\";s:12:\"tmpl_created\";i:1572847113;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/law-firm-team/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:147;s:16:\"popularity_index\";i:318;s:11:\"trend_index\";i:314;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:474;a:18:{s:4:\"tmpl\";i:869;s:2:\"id\";i:11129;s:5:\"title\";s:28:\"Digital Agency &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/About_small.png\";s:12:\"tmpl_created\";i:1564641889;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:148;s:16:\"popularity_index\";i:182;s:11:\"trend_index\";i:166;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:475;a:18:{s:4:\"tmpl\";i:880;s:2:\"id\";i:11572;s:5:\"title\";s:19:\"Gym &#8211; Trainer\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Trainer_Small.png\";s:12:\"tmpl_created\";i:1567392934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:149;s:16:\"popularity_index\";i:521;s:11:\"trend_index\";i:590;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:476;a:18:{s:4:\"tmpl\";i:494;s:2:\"id\";i:5368;s:5:\"title\";s:9:\"Clients 9\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png\";s:12:\"tmpl_created\";i:1520443497;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:149;s:16:\"popularity_index\";i:253;s:11:\"trend_index\";i:273;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:477;a:18:{s:4:\"tmpl\";i:917;s:2:\"id\";i:12133;s:5:\"title\";s:24:\"Law Firm &#8211; Careers\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/11/careers.png\";s:12:\"tmpl_created\";i:1572847078;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/law-firm-careers/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:151;s:16:\"popularity_index\";i:583;s:11:\"trend_index\";i:640;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:478;a:18:{s:4:\"tmpl\";i:425;s:2:\"id\";i:4436;s:5:\"title\";s:11:\"Contact  16\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png\";s:12:\"tmpl_created\";i:1520443293;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:151;s:16:\"popularity_index\";i:161;s:11:\"trend_index\";i:68;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:479;a:18:{s:4:\"tmpl\";i:915;s:2:\"id\";i:12155;s:5:\"title\";s:26:\"Law Firm &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/home.png\";s:12:\"tmpl_created\";i:1572847054;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/law-firm-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:152;s:16:\"popularity_index\";i:193;s:11:\"trend_index\";i:110;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:480;a:18:{s:4:\"tmpl\";i:423;s:2:\"id\";i:4420;s:5:\"title\";s:9:\"Contact 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png\";s:12:\"tmpl_created\";i:1520443289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/contact-1-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:152;s:16:\"popularity_index\";i:196;s:11:\"trend_index\";i:127;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:481;a:18:{s:4:\"tmpl\";i:921;s:2:\"id\";i:12080;s:5:\"title\";s:24:\"Law Firm &#8211; Partner\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/11/partner-1.png\";s:12:\"tmpl_created\";i:1572847120;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/law-firm-partner/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:153;s:16:\"popularity_index\";i:556;s:11:\"trend_index\";i:471;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:482;a:18:{s:4:\"tmpl\";i:534;s:2:\"id\";i:5836;s:5:\"title\";s:10:\"Contact 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:154;s:16:\"popularity_index\";i:114;s:11:\"trend_index\";i:76;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:483;a:18:{s:4:\"tmpl\";i:865;s:2:\"id\";i:11074;s:5:\"title\";s:31:\"Digital Agency &#8211; Services\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/07/Services_small.png\";s:12:\"tmpl_created\";i:1564641872;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/digital-agency-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:154;s:16:\"popularity_index\";i:163;s:11:\"trend_index\";i:170;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:484;a:18:{s:4:\"tmpl\";i:879;s:2:\"id\";i:11506;s:5:\"title\";s:19:\"Gym &#8211; Classes\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Classes_Small.png\";s:12:\"tmpl_created\";i:1567392930;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:155;s:16:\"popularity_index\";i:514;s:11:\"trend_index\";i:554;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:485;a:18:{s:4:\"tmpl\";i:535;s:2:\"id\";i:5844;s:5:\"title\";s:10:\"Contact 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png\";s:12:\"tmpl_created\";i:1520443599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:156;s:16:\"popularity_index\";i:289;s:11:\"trend_index\";i:313;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:486;a:18:{s:4:\"tmpl\";i:922;s:2:\"id\";i:12044;s:5:\"title\";s:24:\"Law Firm &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/contsct_us.png\";s:12:\"tmpl_created\";i:1572847130;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/law-firm-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:157;s:16:\"popularity_index\";i:437;s:11:\"trend_index\";i:304;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:487;a:18:{s:4:\"tmpl\";i:430;s:2:\"id\";i:4476;s:5:\"title\";s:10:\"Contact 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png\";s:12:\"tmpl_created\";i:1520443303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:157;s:16:\"popularity_index\";i:229;s:11:\"trend_index\";i:187;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:488;a:18:{s:4:\"tmpl\";i:918;s:2:\"id\";i:12124;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/11/services.png\";s:12:\"tmpl_created\";i:1572847096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/law-firm-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:158;s:16:\"popularity_index\";i:433;s:11:\"trend_index\";i:296;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:489;a:18:{s:4:\"tmpl\";i:864;s:2:\"id\";i:11056;s:5:\"title\";s:35:\"Digital Agency &#8211; Social Media\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/07/Social-Media_small.png\";s:12:\"tmpl_created\";i:1564641867;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/digital-agency-social-media/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:159;s:16:\"popularity_index\";i:297;s:11:\"trend_index\";i:361;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:490;a:18:{s:4:\"tmpl\";i:476;s:2:\"id\";i:5214;s:5:\"title\";s:10:\"Contact 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png\";s:12:\"tmpl_created\";i:1520443462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/contact-16-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:159;s:16:\"popularity_index\";i:194;s:11:\"trend_index\";i:106;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:491;a:18:{s:4:\"tmpl\";i:878;s:2:\"id\";i:11536;s:5:\"title\";s:19:\"Gym &#8211; Fitness\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Fitness_Small.png\";s:12:\"tmpl_created\";i:1567392927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:160;s:16:\"popularity_index\";i:621;s:11:\"trend_index\";i:674;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:492;a:18:{s:4:\"tmpl\";i:882;s:2:\"id\";i:11545;s:5:\"title\";s:21:\"Gym &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Home_Small.png\";s:12:\"tmpl_created\";i:1567392943;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/gym-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:161;s:16:\"popularity_index\";i:310;s:11:\"trend_index\";i:229;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:493;a:18:{s:4:\"tmpl\";i:919;s:2:\"id\";i:12116;s:5:\"title\";s:24:\"Law Firm &#8211; Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/family_law.png\";s:12:\"tmpl_created\";i:1572847105;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/law-firm-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:162;s:16:\"popularity_index\";i:489;s:11:\"trend_index\";i:339;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:494;a:18:{s:4:\"tmpl\";i:478;s:2:\"id\";i:5230;s:5:\"title\";s:10:\"Contact 17\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png\";s:12:\"tmpl_created\";i:1520443466;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:162;s:16:\"popularity_index\";i:339;s:11:\"trend_index\";i:335;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:495;a:18:{s:4:\"tmpl\";i:868;s:2:\"id\";i:11094;s:5:\"title\";s:30:\"Digital Agency &#8211; Clients\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/07/Clients_small.png\";s:12:\"tmpl_created\";i:1564641885;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/digital-agency-clients/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:163;s:16:\"popularity_index\";i:424;s:11:\"trend_index\";i:424;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:496;a:18:{s:4:\"tmpl\";i:481;s:2:\"id\";i:5257;s:5:\"title\";s:10:\"Contact 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5.png\";s:12:\"tmpl_created\";i:1520443472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/contact-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:163;s:16:\"popularity_index\";i:438;s:11:\"trend_index\";i:490;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:497;a:18:{s:4:\"tmpl\";i:881;s:2:\"id\";i:11478;s:5:\"title\";s:17:\"Gym &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/About_Small.png\";s:12:\"tmpl_created\";i:1567392939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/gym-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:164;s:16:\"popularity_index\";i:481;s:11:\"trend_index\";i:579;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:498;a:18:{s:4:\"tmpl\";i:532;s:2:\"id\";i:5820;s:5:\"title\";s:9:\"Contact 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:166;s:16:\"popularity_index\";i:183;s:11:\"trend_index\";i:357;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:499;a:18:{s:4:\"tmpl\";i:877;s:2:\"id\";i:11563;s:5:\"title\";s:19:\"Gym &#8211; Pricing\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Pricing_Small.png\";s:12:\"tmpl_created\";i:1567392923;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:166;s:16:\"popularity_index\";i:577;s:11:\"trend_index\";i:736;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:500;a:18:{s:4:\"tmpl\";i:422;s:2:\"id\";i:4411;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_1.png\";s:12:\"tmpl_created\";i:1520443287;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/contact-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:167;s:16:\"popularity_index\";i:113;s:11:\"trend_index\";i:217;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:501;a:18:{s:4:\"tmpl\";i:867;s:2:\"id\";i:11034;s:5:\"title\";s:30:\"Digital Agency &#8211; Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/07/Contsct-Us_small.png\";s:12:\"tmpl_created\";i:1564641881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/contact-digital-agency/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:168;s:16:\"popularity_index\";i:191;s:11:\"trend_index\";i:156;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:502;a:18:{s:4:\"tmpl\";i:533;s:2:\"id\";i:5828;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:170;s:16:\"popularity_index\";i:312;s:11:\"trend_index\";i:495;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:503;a:18:{s:4:\"tmpl\";i:876;s:2:\"id\";i:11528;s:5:\"title\";s:19:\"Gym &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Contact_Small.png\";s:12:\"tmpl_created\";i:1567392917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/gym-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:171;s:16:\"popularity_index\";i:505;s:11:\"trend_index\";i:624;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:504;a:18:{s:4:\"tmpl\";i:424;s:2:\"id\";i:4428;s:5:\"title\";s:9:\"Contact 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_2.png\";s:12:\"tmpl_created\";i:1520443291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:171;s:16:\"popularity_index\";i:118;s:11:\"trend_index\";i:131;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:505;a:18:{s:4:\"tmpl\";i:426;s:2:\"id\";i:4444;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443295;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:174;s:16:\"popularity_index\";i:84;s:11:\"trend_index\";i:93;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:506;a:18:{s:4:\"tmpl\";i:432;s:2:\"id\";i:4492;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_3.png\";s:12:\"tmpl_created\";i:1520443307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/contact-5-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:176;s:16:\"popularity_index\";i:37;s:11:\"trend_index\";i:31;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:507;a:18:{s:4:\"tmpl\";i:427;s:2:\"id\";i:4452;s:5:\"title\";s:9:\"Contact 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:178;s:16:\"popularity_index\";i:139;s:11:\"trend_index\";i:150;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:508;a:18:{s:4:\"tmpl\";i:429;s:2:\"id\";i:4468;s:5:\"title\";s:9:\"Contact 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_3.png\";s:12:\"tmpl_created\";i:1520443301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:179;s:16:\"popularity_index\";i:127;s:11:\"trend_index\";i:72;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:509;a:18:{s:4:\"tmpl\";i:431;s:2:\"id\";i:4484;s:5:\"title\";s:9:\"Contact 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_3.png\";s:12:\"tmpl_created\";i:1520443305;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"Contact\",\"Form\"]\";s:10:\"menu_order\";i:182;s:16:\"popularity_index\";i:328;s:11:\"trend_index\";i:260;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:510;a:18:{s:4:\"tmpl\";i:428;s:2:\"id\";i:4460;s:5:\"title\";s:9:\"Contact 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/contact-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:184;s:16:\"popularity_index\";i:99;s:11:\"trend_index\";i:80;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:511;a:18:{s:4:\"tmpl\";i:613;s:2:\"id\";i:5558;s:5:\"title\";s:5:\"CTA 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_2.png\";s:12:\"tmpl_created\";i:1520520684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:185;s:16:\"popularity_index\";i:129;s:11:\"trend_index\";i:69;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:512;a:18:{s:4:\"tmpl\";i:634;s:2:\"id\";i:5939;s:5:\"title\";s:6:\"CTA 10\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_13-1.png\";s:12:\"tmpl_created\";i:1520520760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:187;s:16:\"popularity_index\";i:190;s:11:\"trend_index\";i:118;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:513;a:18:{s:4:\"tmpl\";i:633;s:2:\"id\";i:5930;s:5:\"title\";s:6:\"CTA 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_15.png\";s:12:\"tmpl_created\";i:1520520758;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:190;s:16:\"popularity_index\";i:76;s:11:\"trend_index\";i:84;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:514;a:18:{s:4:\"tmpl\";i:632;s:2:\"id\";i:5921;s:5:\"title\";s:6:\"CTA 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_14.png\";s:12:\"tmpl_created\";i:1520520757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:192;s:16:\"popularity_index\";i:278;s:11:\"trend_index\";i:234;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:515;a:18:{s:4:\"tmpl\";i:618;s:2:\"id\";i:5607;s:5:\"title\";s:6:\"CTA 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_5.png\";s:12:\"tmpl_created\";i:1520520695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:194;s:16:\"popularity_index\";i:42;s:11:\"trend_index\";i:11;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:516;a:18:{s:4:\"tmpl\";i:574;s:2:\"id\";i:6017;s:5:\"title\";s:6:\"CTA 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_14.png\";s:12:\"tmpl_created\";i:1520520331;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:196;s:16:\"popularity_index\";i:152;s:11:\"trend_index\";i:122;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:517;a:18:{s:4:\"tmpl\";i:628;s:2:\"id\";i:5885;s:5:\"title\";s:6:\"CTA 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_11.png\";s:12:\"tmpl_created\";i:1520520751;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:197;s:16:\"popularity_index\";i:274;s:11:\"trend_index\";i:256;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:518;a:18:{s:4:\"tmpl\";i:627;s:2:\"id\";i:5877;s:5:\"title\";s:6:\"CTA 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_10.png\";s:12:\"tmpl_created\";i:1520520749;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:200;s:16:\"popularity_index\";i:564;s:11:\"trend_index\";i:677;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:519;a:18:{s:4:\"tmpl\";i:625;s:2:\"id\";i:5860;s:5:\"title\";s:6:\"CTA 17\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_9.png\";s:12:\"tmpl_created\";i:1520520746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:201;s:16:\"popularity_index\";i:120;s:11:\"trend_index\";i:63;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:520;a:18:{s:4:\"tmpl\";i:626;s:2:\"id\";i:5869;s:5:\"title\";s:6:\"CTA 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_10.png\";s:12:\"tmpl_created\";i:1520520747;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:204;s:16:\"popularity_index\";i:345;s:11:\"trend_index\";i:486;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:521;a:18:{s:4:\"tmpl\";i:611;s:2:\"id\";i:5542;s:5:\"title\";s:6:\"CTA 19\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_1.png\";s:12:\"tmpl_created\";i:1520520681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:205;s:16:\"popularity_index\";i:169;s:11:\"trend_index\";i:270;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:522;a:18:{s:4:\"tmpl\";i:614;s:2:\"id\";i:5567;s:5:\"title\";s:5:\"CTA 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_2.png\";s:12:\"tmpl_created\";i:1520520685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:207;s:16:\"popularity_index\";i:143;s:11:\"trend_index\";i:225;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:523;a:18:{s:4:\"tmpl\";i:629;s:2:\"id\";i:5893;s:5:\"title\";s:6:\"CTA 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_12.png\";s:12:\"tmpl_created\";i:1520520752;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:210;s:16:\"popularity_index\";i:259;s:11:\"trend_index\";i:457;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:524;a:18:{s:4:\"tmpl\";i:619;s:2:\"id\";i:5634;s:5:\"title\";s:6:\"CTA 24\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_6.png\";s:12:\"tmpl_created\";i:1520520699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-24/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:212;s:16:\"popularity_index\";i:188;s:11:\"trend_index\";i:255;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:525;a:18:{s:4:\"tmpl\";i:620;s:2:\"id\";i:5642;s:5:\"title\";s:6:\"CTA 25\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_6.png\";s:12:\"tmpl_created\";i:1520520701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-25/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:214;s:16:\"popularity_index\";i:226;s:11:\"trend_index\";i:262;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:526;a:18:{s:4:\"tmpl\";i:615;s:2:\"id\";i:5583;s:5:\"title\";s:6:\"CTA 26\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_3.png\";s:12:\"tmpl_created\";i:1520520689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-26/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:216;s:16:\"popularity_index\";i:117;s:11:\"trend_index\";i:117;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:527;a:18:{s:4:\"tmpl\";i:630;s:2:\"id\";i:5904;s:5:\"title\";s:6:\"CTA 27\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_13.png\";s:12:\"tmpl_created\";i:1520520754;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-27/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:217;s:16:\"popularity_index\";i:528;s:11:\"trend_index\";i:517;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:528;a:18:{s:4:\"tmpl\";i:631;s:2:\"id\";i:5912;s:5:\"title\";s:6:\"CTA 28\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_11.png\";s:12:\"tmpl_created\";i:1520520755;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-28/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:219;s:16:\"popularity_index\";i:665;s:11:\"trend_index\";i:702;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:529;a:18:{s:4:\"tmpl\";i:473;s:2:\"id\";i:5189;s:5:\"title\";s:6:\"CTA 29\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_1.png\";s:12:\"tmpl_created\";i:1520443456;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-29/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:221;s:16:\"popularity_index\";i:472;s:11:\"trend_index\";i:631;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:530;a:18:{s:4:\"tmpl\";i:623;s:2:\"id\";i:5667;s:5:\"title\";s:5:\"CTA 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_8.png\";s:12:\"tmpl_created\";i:1520520705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:222;s:16:\"popularity_index\";i:171;s:11:\"trend_index\";i:250;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:531;a:18:{s:4:\"tmpl\";i:474;s:2:\"id\";i:5198;s:5:\"title\";s:6:\"CTA 30\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_1.png\";s:12:\"tmpl_created\";i:1520443458;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-30/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:225;s:16:\"popularity_index\";i:572;s:11:\"trend_index\";i:511;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:532;a:18:{s:4:\"tmpl\";i:475;s:2:\"id\";i:5206;s:5:\"title\";s:6:\"CTA 31\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_2.png\";s:12:\"tmpl_created\";i:1520443459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-31/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:226;s:16:\"popularity_index\";i:593;s:11:\"trend_index\";i:611;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:533;a:18:{s:4:\"tmpl\";i:480;s:2:\"id\";i:5249;s:5:\"title\";s:6:\"CTA 32\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_4.png\";s:12:\"tmpl_created\";i:1520443470;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-32/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:228;s:16:\"popularity_index\";i:512;s:11:\"trend_index\";i:409;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:534;a:18:{s:4:\"tmpl\";i:612;s:2:\"id\";i:5550;s:5:\"title\";s:6:\"CTA 33\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_1.png\";s:12:\"tmpl_created\";i:1520520682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-33/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:231;s:16:\"popularity_index\";i:260;s:11:\"trend_index\";i:562;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:535;a:18:{s:4:\"tmpl\";i:536;s:2:\"id\";i:5852;s:5:\"title\";s:6:\"CTA 34\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2018/03/form_1.png\";s:12:\"tmpl_created\";i:1520443600;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/cta-34/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"Form\"]\";s:10:\"menu_order\";i:232;s:16:\"popularity_index\";i:563;s:11:\"trend_index\";i:828;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:536;a:18:{s:4:\"tmpl\";i:624;s:2:\"id\";i:5675;s:5:\"title\";s:5:\"CTA 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_8.png\";s:12:\"tmpl_created\";i:1520520707;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:235;s:16:\"popularity_index\";i:391;s:11:\"trend_index\";i:484;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:537;a:18:{s:4:\"tmpl\";i:616;s:2:\"id\";i:5591;s:5:\"title\";s:5:\"CTA 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_4.png\";s:12:\"tmpl_created\";i:1520520691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:237;s:16:\"popularity_index\";i:133;s:11:\"trend_index\";i:130;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:538;a:18:{s:4:\"tmpl\";i:617;s:2:\"id\";i:5599;s:5:\"title\";s:5:\"CTA 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_4.png\";s:12:\"tmpl_created\";i:1520520693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:239;s:16:\"popularity_index\";i:252;s:11:\"trend_index\";i:362;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:539;a:18:{s:4:\"tmpl\";i:514;s:2:\"id\";i:5575;s:5:\"title\";s:5:\"CTA 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_3.png\";s:12:\"tmpl_created\";i:1520443543;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:240;s:16:\"popularity_index\";i:13;s:11:\"trend_index\";i:586;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:540;a:18:{s:4:\"tmpl\";i:622;s:2:\"id\";i:5658;s:5:\"title\";s:5:\"CTA 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_7.png\";s:12:\"tmpl_created\";i:1520520704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:243;s:16:\"popularity_index\";i:187;s:11:\"trend_index\";i:235;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:541;a:18:{s:4:\"tmpl\";i:621;s:2:\"id\";i:5650;s:5:\"title\";s:5:\"CTA 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_7.png\";s:12:\"tmpl_created\";i:1520520702;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/cta-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:244;s:16:\"popularity_index\";i:94;s:11:\"trend_index\";i:148;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:542;a:18:{s:4:\"tmpl\";i:1061;s:2:\"id\";i:15407;s:5:\"title\";s:24:\"Dance Studio &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/10/404.jpg\";s:12:\"tmpl_created\";i:1603181958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/dance-studio-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:22:\"[\"404\",\"Dance Studio\"]\";s:10:\"menu_order\";i:246;s:16:\"popularity_index\";i:783;s:11:\"trend_index\";i:710;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:543;a:18:{s:4:\"tmpl\";i:1062;s:2:\"id\";i:15400;s:5:\"title\";s:27:\"Dance Studio &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Footer.jpg\";s:12:\"tmpl_created\";i:1603181989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/dance-studio-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:25:\"[\"Dance Studio\",\"Footer\"]\";s:10:\"menu_order\";i:247;s:16:\"popularity_index\";i:586;s:11:\"trend_index\";i:243;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:544;a:18:{s:4:\"tmpl\";i:1063;s:2:\"id\";i:15391;s:5:\"title\";s:27:\"Dance Studio &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Header.jpg\";s:12:\"tmpl_created\";i:1603182011;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/dance-studio-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:25:\"[\"Dance Studio\",\"Header\"]\";s:10:\"menu_order\";i:248;s:16:\"popularity_index\";i:352;s:11:\"trend_index\";i:67;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:545;a:18:{s:4:\"tmpl\";i:874;s:2:\"id\";i:11192;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/07/Footer_small.jpg\";s:12:\"tmpl_created\";i:1564642399;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/digital-agency-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"Footer\",\"Marketing\"]\";s:10:\"menu_order\";i:250;s:16:\"popularity_index\";i:172;s:11:\"trend_index\";i:105;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:546;a:18:{s:4:\"tmpl\";i:873;s:2:\"id\";i:11198;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-digital-marketing-agency.png\";s:12:\"tmpl_created\";i:1564642395;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/digital-agency-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"Header\",\"Marketing\"]\";s:10:\"menu_order\";i:251;s:16:\"popularity_index\";i:34;s:11:\"trend_index\";i:10;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:547;a:18:{s:4:\"tmpl\";i:872;s:2:\"id\";i:11204;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/07/404_small.jpg\";s:12:\"tmpl_created\";i:1564642389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/digital-agency-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:36:\"[\"404\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:253;s:16:\"popularity_index\";i:301;s:11:\"trend_index\";i:239;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:548;a:18:{s:4:\"tmpl\";i:871;s:2:\"id\";i:11220;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/08/Archive_small1.png\";s:12:\"tmpl_created\";i:1564642385;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/digital-agency-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:255;s:16:\"popularity_index\";i:116;s:11:\"trend_index\";i:73;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:549;a:18:{s:4:\"tmpl\";i:870;s:2:\"id\";i:11231;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/Post_small1.png\";s:12:\"tmpl_created\";i:1564642380;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/digital-agency/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:257;s:16:\"popularity_index\";i:145;s:11:\"trend_index\";i:71;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:550;a:18:{s:4:\"tmpl\";i:520;s:2:\"id\";i:5711;s:5:\"title\";s:5:\"FAQ 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_2.png\";s:12:\"tmpl_created\";i:1520443571;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:260;s:16:\"popularity_index\";i:200;s:11:\"trend_index\";i:231;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:551;a:18:{s:4:\"tmpl\";i:523;s:2:\"id\";i:5737;s:5:\"title\";s:6:\"FAQ 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_4.png\";s:12:\"tmpl_created\";i:1520443576;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/faq-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:261;s:16:\"popularity_index\";i:155;s:11:\"trend_index\";i:112;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:552;a:18:{s:4:\"tmpl\";i:524;s:2:\"id\";i:5746;s:5:\"title\";s:6:\"FAQ 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_4.png\";s:12:\"tmpl_created\";i:1520443578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/faq-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:264;s:16:\"popularity_index\";i:212;s:11:\"trend_index\";i:305;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:553;a:18:{s:4:\"tmpl\";i:519;s:2:\"id\";i:5703;s:5:\"title\";s:6:\"FAQ 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_2.png\";s:12:\"tmpl_created\";i:1520443569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/faq-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:265;s:16:\"popularity_index\";i:29;s:11:\"trend_index\";i:38;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:554;a:18:{s:4:\"tmpl\";i:521;s:2:\"id\";i:5719;s:5:\"title\";s:5:\"FAQ 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_3.png\";s:12:\"tmpl_created\";i:1520443573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:267;s:16:\"popularity_index\";i:125;s:11:\"trend_index\";i:251;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:555;a:18:{s:4:\"tmpl\";i:522;s:2:\"id\";i:5729;s:5:\"title\";s:5:\"FAQ 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_3.png\";s:12:\"tmpl_created\";i:1520443575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:269;s:16:\"popularity_index\";i:319;s:11:\"trend_index\";i:327;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:556;a:18:{s:4:\"tmpl\";i:525;s:2:\"id\";i:5755;s:5:\"title\";s:5:\"FAQ 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_5.png\";s:12:\"tmpl_created\";i:1520443580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:271;s:16:\"popularity_index\";i:112;s:11:\"trend_index\";i:180;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:557;a:18:{s:4:\"tmpl\";i:526;s:2:\"id\";i:5764;s:5:\"title\";s:5:\"FAQ 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_5.png\";s:12:\"tmpl_created\";i:1520443582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:273;s:16:\"popularity_index\";i:338;s:11:\"trend_index\";i:474;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:558;a:18:{s:4:\"tmpl\";i:517;s:2:\"id\";i:5684;s:5:\"title\";s:5:\"FAQ 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_1.png\";s:12:\"tmpl_created\";i:1520443565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:274;s:16:\"popularity_index\";i:74;s:11:\"trend_index\";i:193;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:559;a:18:{s:4:\"tmpl\";i:518;s:2:\"id\";i:5693;s:5:\"title\";s:5:\"FAQ 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_1.png\";s:12:\"tmpl_created\";i:1520443567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/faq-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"Faq\"]\";s:10:\"menu_order\";i:276;s:16:\"popularity_index\";i:224;s:11:\"trend_index\";i:515;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:560;a:18:{s:4:\"tmpl\";i:548;s:2:\"id\";i:6053;s:5:\"title\";s:10:\"Features 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_5.png\";s:12:\"tmpl_created\";i:1520443645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:277;s:16:\"popularity_index\";i:179;s:11:\"trend_index\";i:463;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:561;a:18:{s:4:\"tmpl\";i:542;s:2:\"id\";i:5991;s:5:\"title\";s:11:\"Features 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_4.png\";s:12:\"tmpl_created\";i:1520443632;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/features-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:279;s:16:\"popularity_index\";i:135;s:11:\"trend_index\";i:265;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:562;a:18:{s:4:\"tmpl\";i:547;s:2:\"id\";i:6044;s:5:\"title\";s:11:\"Features 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_5.png\";s:12:\"tmpl_created\";i:1520443643;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/features-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:280;s:16:\"popularity_index\";i:70;s:11:\"trend_index\";i:163;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:563;a:18:{s:4:\"tmpl\";i:566;s:2:\"id\";i:6212;s:5:\"title\";s:11:\"Features 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_7.png\";s:12:\"tmpl_created\";i:1520443684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/features-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:281;s:16:\"popularity_index\";i:81;s:11:\"trend_index\";i:98;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:564;a:18:{s:4:\"tmpl\";i:567;s:2:\"id\";i:6220;s:5:\"title\";s:10:\"Features 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_8.png\";s:12:\"tmpl_created\";i:1520443685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:282;s:16:\"popularity_index\";i:88;s:11:\"trend_index\";i:189;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:565;a:18:{s:4:\"tmpl\";i:541;s:2:\"id\";i:5983;s:5:\"title\";s:10:\"Features 3\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_3.png\";s:12:\"tmpl_created\";i:1520443630;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:283;s:16:\"popularity_index\";i:231;s:11:\"trend_index\";i:351;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:566;a:18:{s:4:\"tmpl\";i:540;s:2:\"id\";i:5974;s:5:\"title\";s:10:\"Features 4\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_3.png\";s:12:\"tmpl_created\";i:1520443629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:286;s:16:\"popularity_index\";i:69;s:11:\"trend_index\";i:181;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:567;a:18:{s:4:\"tmpl\";i:516;s:2:\"id\";i:5624;s:5:\"title\";s:10:\"Features 5\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_1.png\";s:12:\"tmpl_created\";i:1520443553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:287;s:16:\"popularity_index\";i:93;s:11:\"trend_index\";i:352;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:568;a:18:{s:4:\"tmpl\";i:515;s:2:\"id\";i:5615;s:5:\"title\";s:10:\"Features 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_5.png\";s:12:\"tmpl_created\";i:1520443551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:290;s:16:\"popularity_index\";i:41;s:11:\"trend_index\";i:119;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:569;a:18:{s:4:\"tmpl\";i:539;s:2:\"id\";i:5963;s:5:\"title\";s:10:\"Features 7\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_2.png\";s:12:\"tmpl_created\";i:1520443626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:291;s:16:\"popularity_index\";i:67;s:11:\"trend_index\";i:133;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:570;a:18:{s:4:\"tmpl\";i:565;s:2:\"id\";i:6204;s:5:\"title\";s:10:\"Features 8\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_6.png\";s:12:\"tmpl_created\";i:1520443681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:292;s:16:\"popularity_index\";i:217;s:11:\"trend_index\";i:223;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:571;a:18:{s:4:\"tmpl\";i:564;s:2:\"id\";i:6196;s:5:\"title\";s:10:\"Features 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_6.png\";s:12:\"tmpl_created\";i:1520443680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/features-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"Features\"]\";s:10:\"menu_order\";i:294;s:16:\"popularity_index\";i:106;s:11:\"trend_index\";i:113;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:572;a:18:{s:4:\"tmpl\";i:1033;s:2:\"id\";i:15033;s:5:\"title\";s:28:\"Flooring Company &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/08/404.png\";s:12:\"tmpl_created\";i:1597739459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/blocks/flooring-company-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:45:\"[\"404\",\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:296;s:16:\"popularity_index\";i:655;s:11:\"trend_index\";i:671;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:573;a:18:{s:4:\"tmpl\";i:1032;s:2:\"id\";i:15042;s:5:\"title\";s:32:\"Flooring Company &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Blog.png\";s:12:\"tmpl_created\";i:1597739084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/blocks/flooring-company-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:297;s:16:\"popularity_index\";i:320;s:11:\"trend_index\";i:275;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:574;a:18:{s:4:\"tmpl\";i:1031;s:2:\"id\";i:15017;s:5:\"title\";s:31:\"Flooring Company &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Footer.png\";s:12:\"tmpl_created\";i:1597738933;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/blocks/flooring-company-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"Footer\"]\";s:10:\"menu_order\";i:299;s:16:\"popularity_index\";i:323;s:11:\"trend_index\";i:192;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:575;a:18:{s:4:\"tmpl\";i:1030;s:2:\"id\";i:15007;s:5:\"title\";s:31:\"Flooring Company &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Header.png\";s:12:\"tmpl_created\";i:1597738896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/blocks/flooring-company-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"Header\"]\";s:10:\"menu_order\";i:302;s:16:\"popularity_index\";i:459;s:11:\"trend_index\";i:333;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:576;a:18:{s:4:\"tmpl\";i:1029;s:2:\"id\";i:15052;s:5:\"title\";s:36:\"Flooring Company &#8211; Single post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Single.png\";s:12:\"tmpl_created\";i:1597738858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/blocks/flooring-company-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:303;s:16:\"popularity_index\";i:392;s:11:\"trend_index\";i:226;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:577;a:18:{s:4:\"tmpl\";i:651;s:2:\"id\";i:7837;s:5:\"title\";s:9:\"footer 01\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.14.jpg\";s:12:\"tmpl_created\";i:1524582852;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:305;s:16:\"popularity_index\";i:495;s:11:\"trend_index\";i:539;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:578;a:18:{s:4:\"tmpl\";i:647;s:2:\"id\";i:7937;s:5:\"title\";s:10:\"footer 010\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.5.jpg\";s:12:\"tmpl_created\";i:1524582665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-010/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:308;s:16:\"popularity_index\";i:185;s:11:\"trend_index\";i:115;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:579;a:18:{s:4:\"tmpl\";i:646;s:2:\"id\";i:7950;s:5:\"title\";s:10:\"footer 011\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.4.jpg\";s:12:\"tmpl_created\";i:1524582631;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-011/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:310;s:16:\"popularity_index\";i:244;s:11:\"trend_index\";i:203;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:580;a:18:{s:4:\"tmpl\";i:645;s:2:\"id\";i:7959;s:5:\"title\";s:10:\"footer 012\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.3.jpg\";s:12:\"tmpl_created\";i:1524582605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-012/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:311;s:16:\"popularity_index\";i:177;s:11:\"trend_index\";i:140;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:581;a:18:{s:4:\"tmpl\";i:644;s:2:\"id\";i:7982;s:5:\"title\";s:10:\"footer 013\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.2.jpg\";s:12:\"tmpl_created\";i:1524582468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-013/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:314;s:16:\"popularity_index\";i:209;s:11:\"trend_index\";i:212;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:582;a:18:{s:4:\"tmpl\";i:643;s:2:\"id\";i:7997;s:5:\"title\";s:10:\"footer 014\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.1.jpg\";s:12:\"tmpl_created\";i:1524582343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/footer-014/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:316;s:16:\"popularity_index\";i:64;s:11:\"trend_index\";i:41;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:583;a:18:{s:4:\"tmpl\";i:693;s:2:\"id\";i:9119;s:5:\"title\";s:10:\"footer 015\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/Footer_GetStarted_350.png\";s:12:\"tmpl_created\";i:1532428138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/demo/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:317;s:16:\"popularity_index\";i:240;s:11:\"trend_index\";i:154;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:584;a:18:{s:4:\"tmpl\";i:652;s:2:\"id\";i:7852;s:5:\"title\";s:9:\"footer 02\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.13.jpg\";s:12:\"tmpl_created\";i:1524582875;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:320;s:16:\"popularity_index\";i:199;s:11:\"trend_index\";i:96;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:585;a:18:{s:4:\"tmpl\";i:653;s:2:\"id\";i:7862;s:5:\"title\";s:9:\"footer 03\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.12.jpg\";s:12:\"tmpl_created\";i:1524582903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:321;s:16:\"popularity_index\";i:137;s:11:\"trend_index\";i:91;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:586;a:18:{s:4:\"tmpl\";i:654;s:2:\"id\";i:7871;s:5:\"title\";s:9:\"footer 04\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.11.jpg\";s:12:\"tmpl_created\";i:1524582927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:323;s:16:\"popularity_index\";i:97;s:11:\"trend_index\";i:55;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:587;a:18:{s:4:\"tmpl\";i:655;s:2:\"id\";i:7884;s:5:\"title\";s:9:\"footer 05\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.10.jpg\";s:12:\"tmpl_created\";i:1524582944;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:325;s:16:\"popularity_index\";i:92;s:11:\"trend_index\";i:109;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:588;a:18:{s:4:\"tmpl\";i:656;s:2:\"id\";i:7892;s:5:\"title\";s:9:\"footer 06\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.9.jpg\";s:12:\"tmpl_created\";i:1524583015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:326;s:16:\"popularity_index\";i:132;s:11:\"trend_index\";i:146;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:589;a:18:{s:4:\"tmpl\";i:650;s:2:\"id\";i:7904;s:5:\"title\";s:9:\"footer 07\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.8.jpg\";s:12:\"tmpl_created\";i:1524582814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:328;s:16:\"popularity_index\";i:203;s:11:\"trend_index\";i:186;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:590;a:18:{s:4:\"tmpl\";i:649;s:2:\"id\";i:7917;s:5:\"title\";s:9:\"footer 08\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.7.jpg\";s:12:\"tmpl_created\";i:1524582788;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:329;s:16:\"popularity_index\";i:89;s:11:\"trend_index\";i:144;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:591;a:18:{s:4:\"tmpl\";i:648;s:2:\"id\";i:7927;s:5:\"title\";s:9:\"footer 09\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.6.jpg\";s:12:\"tmpl_created\";i:1524582691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/footer-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:331;s:16:\"popularity_index\";i:178;s:11:\"trend_index\";i:100;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:592;a:18:{s:4:\"tmpl\";i:642;s:2:\"id\";i:4676;s:5:\"title\";s:8:\"Footer 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_7.png\";s:12:\"tmpl_created\";i:1522014215;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/footer_7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:338;s:16:\"popularity_index\";i:237;s:11:\"trend_index\";i:346;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:593;a:18:{s:4:\"tmpl\";i:637;s:2:\"id\";i:7627;s:5:\"title\";s:8:\"Footer 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_1.png\";s:12:\"tmpl_created\";i:1521547332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/footer-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:340;s:16:\"popularity_index\";i:100;s:11:\"trend_index\";i:83;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:594;a:18:{s:4:\"tmpl\";i:638;s:2:\"id\";i:7638;s:5:\"title\";s:8:\"Footer 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_2.png\";s:12:\"tmpl_created\";i:1521547502;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/footer-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:342;s:16:\"popularity_index\";i:124;s:11:\"trend_index\";i:147;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:595;a:18:{s:4:\"tmpl\";i:888;s:2:\"id\";i:11424;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/08/404_Small.png\";s:12:\"tmpl_created\";i:1567393309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/gym-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:13:\"[\"404\",\"Gym\"]\";s:10:\"menu_order\";i:344;s:16:\"popularity_index\";i:679;s:11:\"trend_index\";i:769;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:596;a:18:{s:4:\"tmpl\";i:887;s:2:\"id\";i:11435;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Archiv_Small.png\";s:12:\"tmpl_created\";i:1567393296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/gym-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:346;s:16:\"popularity_index\";i:441;s:11:\"trend_index\";i:507;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:597;a:18:{s:4:\"tmpl\";i:886;s:2:\"id\";i:11445;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Post_Small.png\";s:12:\"tmpl_created\";i:1567393229;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/gym-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:349;s:16:\"popularity_index\";i:452;s:11:\"trend_index\";i:479;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:598;a:18:{s:4:\"tmpl\";i:885;s:2:\"id\";i:11453;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Footer_Small.png\";s:12:\"tmpl_created\";i:1567393224;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/gym-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:16:\"[\"Footer\",\"Gym\"]\";s:10:\"menu_order\";i:351;s:16:\"popularity_index\";i:270;s:11:\"trend_index\";i:331;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:599;a:18:{s:4:\"tmpl\";i:884;s:2:\"id\";i:11461;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-gym-and-fitness.png\";s:12:\"tmpl_created\";i:1567393219;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:16:\"[\"Gym\",\"Header\"]\";s:10:\"menu_order\";i:352;s:16:\"popularity_index\";i:201;s:11:\"trend_index\";i:135;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:600;a:18:{s:4:\"tmpl\";i:635;s:2:\"id\";i:7596;s:5:\"title\";s:8:\"Header 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.12.jpg\";s:12:\"tmpl_created\";i:1521546999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"Header\"]\";s:10:\"menu_order\";i:354;s:16:\"popularity_index\";i:33;s:11:\"trend_index\";i:17;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:601;a:18:{s:4:\"tmpl\";i:663;s:2:\"id\";i:7801;s:5:\"title\";s:9:\"header 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.9.jpg\";s:12:\"tmpl_created\";i:1524583659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/header-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:356;s:16:\"popularity_index\";i:51;s:11:\"trend_index\";i:14;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:602;a:18:{s:4:\"tmpl\";i:658;s:2:\"id\";i:7812;s:5:\"title\";s:9:\"header 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.10.jpg\";s:12:\"tmpl_created\";i:1524583298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/header-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:358;s:16:\"popularity_index\";i:96;s:11:\"trend_index\";i:103;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:603;a:18:{s:4:\"tmpl\";i:657;s:2:\"id\";i:7825;s:5:\"title\";s:9:\"header 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.11.jpg\";s:12:\"tmpl_created\";i:1524583273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/header-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:360;s:16:\"popularity_index\";i:63;s:11:\"trend_index\";i:75;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:604;a:18:{s:4:\"tmpl\";i:694;s:2:\"id\";i:9127;s:5:\"title\";s:9:\"header 13\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2018/07/Header_get_started_1200V3.png\";s:12:\"tmpl_created\";i:1532428699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/header-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:362;s:16:\"popularity_index\";i:61;s:11:\"trend_index\";i:58;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:605;a:18:{s:4:\"tmpl\";i:636;s:2:\"id\";i:7615;s:5:\"title\";s:8:\"Header 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.1.jpg\";s:12:\"tmpl_created\";i:1521547237;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"Header\"]\";s:10:\"menu_order\";i:365;s:16:\"popularity_index\";i:30;s:11:\"trend_index\";i:33;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:606;a:18:{s:4:\"tmpl\";i:665;s:2:\"id\";i:7713;s:5:\"title\";s:8:\"header 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.2.jpg\";s:12:\"tmpl_created\";i:1524584780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:367;s:16:\"popularity_index\";i:43;s:11:\"trend_index\";i:28;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:607;a:18:{s:4:\"tmpl\";i:659;s:2:\"id\";i:7724;s:5:\"title\";s:8:\"header 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.3.jpg\";s:12:\"tmpl_created\";i:1524583367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:369;s:16:\"popularity_index\";i:24;s:11:\"trend_index\";i:13;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:608;a:18:{s:4:\"tmpl\";i:660;s:2:\"id\";i:7734;s:5:\"title\";s:8:\"header 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.4.jpg\";s:12:\"tmpl_created\";i:1524583436;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:371;s:16:\"popularity_index\";i:36;s:11:\"trend_index\";i:18;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:609;a:18:{s:4:\"tmpl\";i:666;s:2:\"id\";i:7744;s:5:\"title\";s:8:\"Header 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.5.jpg\";s:12:\"tmpl_created\";i:1524584784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:372;s:16:\"popularity_index\";i:65;s:11:\"trend_index\";i:94;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:610;a:18:{s:4:\"tmpl\";i:664;s:2:\"id\";i:7754;s:5:\"title\";s:8:\"header 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.6.jpg\";s:12:\"tmpl_created\";i:1524583712;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:375;s:16:\"popularity_index\";i:111;s:11:\"trend_index\";i:143;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:611;a:18:{s:4:\"tmpl\";i:661;s:2:\"id\";i:7771;s:5:\"title\";s:8:\"header 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.7.jpg\";s:12:\"tmpl_created\";i:1524583540;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:376;s:16:\"popularity_index\";i:91;s:11:\"trend_index\";i:60;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:612;a:18:{s:4:\"tmpl\";i:662;s:2:\"id\";i:7787;s:5:\"title\";s:8:\"header 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.8.jpg\";s:12:\"tmpl_created\";i:1524583598;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/header-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:379;s:16:\"popularity_index\";i:102;s:11:\"trend_index\";i:78;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:613;a:18:{s:4:\"tmpl\";i:572;s:2:\"id\";i:6266;s:5:\"title\";s:6:\"Hero 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_4.png\";s:12:\"tmpl_created\";i:1520443695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:380;s:16:\"popularity_index\";i:52;s:11:\"trend_index\";i:35;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:614;a:18:{s:4:\"tmpl\";i:528;s:2:\"id\";i:5783;s:5:\"title\";s:7:\"Hero 10\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_2.png\";s:12:\"tmpl_created\";i:1520443586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/hero-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:383;s:16:\"popularity_index\";i:365;s:11:\"trend_index\";i:567;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:615;a:18:{s:4:\"tmpl\";i:527;s:2:\"id\";i:5773;s:5:\"title\";s:7:\"Hero 11\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_1.png\";s:12:\"tmpl_created\";i:1520443584;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/hero-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:384;s:16:\"popularity_index\";i:39;s:11:\"trend_index\";i:179;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:616;a:18:{s:4:\"tmpl\";i:479;s:2:\"id\";i:5238;s:5:\"title\";s:7:\"Hero 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4.png\";s:12:\"tmpl_created\";i:1520443468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/hero-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:386;s:16:\"popularity_index\";i:611;s:11:\"trend_index\";i:555;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:617;a:18:{s:4:\"tmpl\";i:573;s:2:\"id\";i:6274;s:5:\"title\";s:6:\"Hero 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_5.png\";s:12:\"tmpl_created\";i:1520443698;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:389;s:16:\"popularity_index\";i:87;s:11:\"trend_index\";i:88;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:618;a:18:{s:4:\"tmpl\";i:569;s:2:\"id\";i:6239;s:5:\"title\";s:6:\"Hero 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_1.png\";s:12:\"tmpl_created\";i:1520443689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:391;s:16:\"popularity_index\";i:23;s:11:\"trend_index\";i:34;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:619;a:18:{s:4:\"tmpl\";i:571;s:2:\"id\";i:6258;s:5:\"title\";s:6:\"Hero 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_3.png\";s:12:\"tmpl_created\";i:1520443693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:393;s:16:\"popularity_index\";i:479;s:11:\"trend_index\";i:470;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:620;a:18:{s:4:\"tmpl\";i:570;s:2:\"id\";i:6249;s:5:\"title\";s:6:\"Hero 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_2.png\";s:12:\"tmpl_created\";i:1520443691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:395;s:16:\"popularity_index\";i:56;s:11:\"trend_index\";i:85;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:621;a:18:{s:4:\"tmpl\";i:568;s:2:\"id\";i:6230;s:5:\"title\";s:6:\"Hero 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_white_1.png\";s:12:\"tmpl_created\";i:1520443687;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:396;s:16:\"popularity_index\";i:406;s:11:\"trend_index\";i:542;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:622;a:18:{s:4:\"tmpl\";i:530;s:2:\"id\";i:5801;s:5:\"title\";s:6:\"Hero 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_4.png\";s:12:\"tmpl_created\";i:1520443589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:398;s:16:\"popularity_index\";i:15;s:11:\"trend_index\";i:37;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:623;a:18:{s:4:\"tmpl\";i:531;s:2:\"id\";i:5811;s:5:\"title\";s:6:\"Hero 8\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_5.png\";s:12:\"tmpl_created\";i:1520443591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:400;s:16:\"popularity_index\";i:105;s:11:\"trend_index\";i:86;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:624;a:18:{s:4:\"tmpl\";i:529;s:2:\"id\";i:5792;s:5:\"title\";s:6:\"Hero 9\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_3.png\";s:12:\"tmpl_created\";i:1520443588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/hero-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:403;s:16:\"popularity_index\";i:225;s:11:\"trend_index\";i:244;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:625;a:18:{s:4:\"tmpl\";i:978;s:2:\"id\";i:13251;s:5:\"title\";s:27:\"Interior Design &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.png\";s:12:\"tmpl_created\";i:1586148737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/interior-design-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:405;s:16:\"popularity_index\";i:730;s:11:\"trend_index\";i:795;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:626;a:18:{s:4:\"tmpl\";i:979;s:2:\"id\";i:13244;s:5:\"title\";s:30:\"Interior Design &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.png\";s:12:\"tmpl_created\";i:1586148742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/interior-design-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Business\",\"Footer\",\"Interior Design\"]\";s:10:\"menu_order\";i:406;s:16:\"popularity_index\";i:322;s:11:\"trend_index\";i:178;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:627;a:18:{s:4:\"tmpl\";i:980;s:2:\"id\";i:13236;s:5:\"title\";s:30:\"Interior Design &#8211; Header\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-interior-design.png\";s:12:\"tmpl_created\";i:1586148746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/interior-design-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Business\",\"Header\",\"Interior Design\"]\";s:10:\"menu_order\";i:408;s:16:\"popularity_index\";i:146;s:11:\"trend_index\";i:64;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:628;a:18:{s:4:\"tmpl\";i:977;s:2:\"id\";i:13259;s:5:\"title\";s:36:\"Interior Design &#8211; News Archive\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Archiv-Blog.png\";s:12:\"tmpl_created\";i:1586148733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/blocks/interior-design-news-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:410;s:16:\"popularity_index\";i:436;s:11:\"trend_index\";i:132;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:629;a:18:{s:4:\"tmpl\";i:976;s:2:\"id\";i:13267;s:5:\"title\";s:35:\"Interior Design &#8211; Single News\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Post.png\";s:12:\"tmpl_created\";i:1586148728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/blocks/interior-design-single-news/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:413;s:16:\"popularity_index\";i:402;s:11:\"trend_index\";i:108;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:630;a:18:{s:4:\"tmpl\";i:975;s:2:\"id\";i:13274;s:5:\"title\";s:38:\"Interior Design &#8211; Single Project\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/04/Single-Project-.png\";s:12:\"tmpl_created\";i:1586148723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/blocks/interior-design-single-project/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:414;s:16:\"popularity_index\";i:601;s:11:\"trend_index\";i:324;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:631;a:18:{s:4:\"tmpl\";i:1011;s:2:\"id\";i:14058;s:5:\"title\";s:36:\"Japanese restaurant &#8211; 404 page\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/06/404-Page.jpg\";s:12:\"tmpl_created\";i:1592290211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/blocks/japanese-restaurant-404-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:38:\"[\"404\",\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:416;s:16:\"popularity_index\";i:724;s:11:\"trend_index\";i:647;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:632;a:18:{s:4:\"tmpl\";i:1012;s:2:\"id\";i:14050;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1592290247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/blocks/japanese-restaurant-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:41:\"[\"Food\",\"Footer\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:419;s:16:\"popularity_index\";i:317;s:11:\"trend_index\";i:238;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:633;a:18:{s:4:\"tmpl\";i:1013;s:2:\"id\";i:14042;s:5:\"title\";s:34:\"Japanese Restaurant &#8211; Header\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2020/06/japanese-restaurant-header.jpg\";s:12:\"tmpl_created\";i:1592290277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/blocks/japanese-restaurant-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:41:\"[\"Food\",\"Header\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:421;s:16:\"popularity_index\";i:411;s:11:\"trend_index\";i:274;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:634;a:18:{s:4:\"tmpl\";i:914;s:2:\"id\";i:12164;s:5:\"title\";s:20:\"Law Firm &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/11/404.png\";s:12:\"tmpl_created\";i:1572846979;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/law-firm-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:422;s:16:\"popularity_index\";i:704;s:11:\"trend_index\";i:716;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:635;a:18:{s:4:\"tmpl\";i:913;s:2:\"id\";i:12170;s:5:\"title\";s:23:\"Law Firm &#8211; Archiv\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/archiv.png\";s:12:\"tmpl_created\";i:1572846967;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/law-firm-archiv/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:424;s:16:\"popularity_index\";i:431;s:11:\"trend_index\";i:294;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:636;a:18:{s:4:\"tmpl\";i:912;s:2:\"id\";i:12179;s:5:\"title\";s:23:\"Law Firm &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/footer.png\";s:12:\"tmpl_created\";i:1572846958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/law-firm-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"Footer\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:425;s:16:\"popularity_index\";i:388;s:11:\"trend_index\";i:240;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:637;a:18:{s:4:\"tmpl\";i:911;s:2:\"id\";i:12194;s:5:\"title\";s:23:\"Law Firm &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-law-firm.png\";s:12:\"tmpl_created\";i:1572846935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/law-firm-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"Header\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:427;s:16:\"popularity_index\";i:80;s:11:\"trend_index\";i:39;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:638;a:18:{s:4:\"tmpl\";i:910;s:2:\"id\";i:12203;s:5:\"title\";s:30:\"Law Firm &#8211; Search Archiv\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/11/search_result.png\";s:12:\"tmpl_created\";i:1572846925;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/law-firm-search-archiv/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:430;s:16:\"popularity_index\";i:493;s:11:\"trend_index\";i:433;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:639;a:18:{s:4:\"tmpl\";i:909;s:2:\"id\";i:12212;s:5:\"title\";s:28:\"Law Firm &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/single.png\";s:12:\"tmpl_created\";i:1572846914;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/blocks/law-firm-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:432;s:16:\"popularity_index\";i:326;s:11:\"trend_index\";i:214;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:640;a:18:{s:4:\"tmpl\";i:1022;s:2:\"id\";i:14772;s:5:\"title\";s:35:\"Luxury Real Estate &#8211; 404 page\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/07/404.png\";s:12:\"tmpl_created\";i:1595315728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/blocks/luxury-real-estate-404-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:433;s:16:\"popularity_index\";i:759;s:11:\"trend_index\";i:720;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:641;a:18:{s:4:\"tmpl\";i:1023;s:2:\"id\";i:14779;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Footer.png\";s:12:\"tmpl_created\";i:1595315743;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/blocks/luxury-real-estate-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Footer\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:434;s:16:\"popularity_index\";i:536;s:11:\"trend_index\";i:505;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:642;a:18:{s:4:\"tmpl\";i:1024;s:2:\"id\";i:14790;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Header.png\";s:12:\"tmpl_created\";i:1595315760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/blocks/luxury-real-estate-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Header\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:436;s:16:\"popularity_index\";i:101;s:11:\"trend_index\";i:157;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:643;a:18:{s:4:\"tmpl\";i:1026;s:2:\"id\";i:14809;s:5:\"title\";s:45:\"Luxury Real Estate &#8211; Properties Archive\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Properties.png\";s:12:\"tmpl_created\";i:1595315826;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/blocks/luxury-real-estate-properties-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:438;s:16:\"popularity_index\";i:414;s:11:\"trend_index\";i:420;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:644;a:18:{s:4:\"tmpl\";i:1027;s:2:\"id\";i:14816;s:5:\"title\";s:47:\"Luxury Real Estate &#8211; Property single post\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/07/Single-Property-.png\";s:12:\"tmpl_created\";i:1595315847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/blocks/luxury-real-estate-property-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:441;s:16:\"popularity_index\";i:541;s:11:\"trend_index\";i:665;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:645;a:18:{s:4:\"tmpl\";i:1025;s:2:\"id\";i:14799;s:5:\"title\";s:38:\"Luxury Real Estate &#8211; single post\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Post.png\";s:12:\"tmpl_created\";i:1595315792;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/blocks/luxury-real-estate-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:442;s:16:\"popularity_index\";i:369;s:11:\"trend_index\";i:441;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:646;a:18:{s:4:\"tmpl\";i:950;s:2:\"id\";i:12635;s:5:\"title\";s:20:\"Magazine &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/01/404_s.png\";s:12:\"tmpl_created\";i:1579060746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/magazine-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:25:\"[\"404\",\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:445;s:16:\"popularity_index\";i:645;s:11:\"trend_index\";i:734;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:647;a:18:{s:4:\"tmpl\";i:949;s:2:\"id\";i:12643;s:5:\"title\";s:24:\"Magazine &#8211; Archiv1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv1_s.png\";s:12:\"tmpl_created\";i:1579060737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/magazine-archiv1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:447;s:16:\"popularity_index\";i:346;s:11:\"trend_index\";i:272;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:648;a:18:{s:4:\"tmpl\";i:946;s:2:\"id\";i:12669;s:5:\"title\";s:23:\"Magazine &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Footer_s.png\";s:12:\"tmpl_created\";i:1579060715;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/magazine-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:28:\"[\"Blog\",\"Footer\",\"Magazine\"]\";s:10:\"menu_order\";i:448;s:16:\"popularity_index\";i:442;s:11:\"trend_index\";i:349;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:649;a:18:{s:4:\"tmpl\";i:945;s:2:\"id\";i:12678;s:5:\"title\";s:23:\"Magazine &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-magazine.png\";s:12:\"tmpl_created\";i:1579060701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/magazine-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:28:\"[\"Blog\",\"Header\",\"Magazine\"]\";s:10:\"menu_order\";i:450;s:16:\"popularity_index\";i:295;s:11:\"trend_index\";i:197;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:650;a:18:{s:4:\"tmpl\";i:947;s:2:\"id\";i:12661;s:5:\"title\";s:23:\"Magazine &#8211; Search\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Search_s.png\";s:12:\"tmpl_created\";i:1579060722;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/magazine-search/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:452;s:16:\"popularity_index\";i:396;s:11:\"trend_index\";i:509;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:651;a:18:{s:4:\"tmpl\";i:944;s:2:\"id\";i:12688;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 1\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post2_s.png\";s:12:\"tmpl_created\";i:1579060692;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/magazine-single-post-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:453;s:16:\"popularity_index\";i:342;s:11:\"trend_index\";i:175;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:652;a:18:{s:4:\"tmpl\";i:943;s:2:\"id\";i:12699;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 2\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post3_s.png\";s:12:\"tmpl_created\";i:1579060680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/magazine-single-post-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:454;s:16:\"popularity_index\";i:348;s:11:\"trend_index\";i:129;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:653;a:18:{s:4:\"tmpl\";i:942;s:2:\"id\";i:12707;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post1_s.png\";s:12:\"tmpl_created\";i:1579060669;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/magazine-single-post-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:457;s:16:\"popularity_index\";i:476;s:11:\"trend_index\";i:246;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:654;a:18:{s:4:\"tmpl\";i:941;s:2:\"id\";i:12716;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post4_s.png\";s:12:\"tmpl_created\";i:1579060659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/blocks/magazine-single-post-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:459;s:16:\"popularity_index\";i:513;s:11:\"trend_index\";i:489;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:655;a:18:{s:4:\"tmpl\";i:948;s:2:\"id\";i:12652;s:5:\"title\";s:17:\"Magazine- Archiv2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv2_s.png\";s:12:\"tmpl_created\";i:1579060730;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/magazine-archiv2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:461;s:16:\"popularity_index\";i:525;s:11:\"trend_index\";i:585;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:656;a:18:{s:4:\"tmpl\";i:990;s:2:\"id\";i:13361;s:5:\"title\";s:25:\"Online Course &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.jpg\";s:12:\"tmpl_created\";i:1587474710;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/online-course-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:35:\"[\"404\",\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:462;s:16:\"popularity_index\";i:682;s:11:\"trend_index\";i:498;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:657;a:18:{s:4:\"tmpl\";i:987;s:2:\"id\";i:13387;s:5:\"title\";s:32:\"Online Course &#8211; End Lesson\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-End-.jpg\";s:12:\"tmpl_created\";i:1587474682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/blocks/online-course-end-lesson/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:464;s:16:\"popularity_index\";i:653;s:11:\"trend_index\";i:408;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:658;a:18:{s:4:\"tmpl\";i:989;s:2:\"id\";i:13369;s:5:\"title\";s:28:\"Online Course &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.jpg\";s:12:\"tmpl_created\";i:1587474701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/blocks/online-course-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"Footer\"]\";s:10:\"menu_order\";i:466;s:16:\"popularity_index\";i:389;s:11:\"trend_index\";i:308;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:659;a:18:{s:4:\"tmpl\";i:988;s:2:\"id\";i:13378;s:5:\"title\";s:28:\"Online Course &#8211; Header\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-education-online-courses.jpg\";s:12:\"tmpl_created\";i:1587474693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/blocks/online-course-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"Header\"]\";s:10:\"menu_order\";i:469;s:16:\"popularity_index\";i:492;s:11:\"trend_index\";i:519;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:660;a:18:{s:4:\"tmpl\";i:986;s:2:\"id\";i:13395;s:5:\"title\";s:34:\"Online Course &#8211; Start Lesson\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-Start.jpg\";s:12:\"tmpl_created\";i:1587474673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/blocks/online-course-start-lesson/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:471;s:16:\"popularity_index\";i:672;s:11:\"trend_index\";i:578;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:661;a:18:{s:4:\"tmpl\";i:953;s:2:\"id\";i:13089;s:5:\"title\";s:23:\"Photography &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/02/404_s.png\";s:12:\"tmpl_created\";i:1582091623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/photography-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:33:\"[\"404\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:473;s:16:\"popularity_index\";i:702;s:11:\"trend_index\";i:706;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:662;a:18:{s:4:\"tmpl\";i:954;s:2:\"id\";i:13096;s:5:\"title\";s:32:\"Photography &#8211; Archiv Media\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Archiv_s.png\";s:12:\"tmpl_created\";i:1582091742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/blocks/photography-archiv-media/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:475;s:16:\"popularity_index\";i:631;s:11:\"trend_index\";i:405;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:663;a:18:{s:4:\"tmpl\";i:955;s:2:\"id\";i:13103;s:5:\"title\";s:26:\"Photography &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Footer_s.png\";s:12:\"tmpl_created\";i:1582091903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/photography-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:36:\"[\"Footer\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:477;s:16:\"popularity_index\";i:422;s:11:\"trend_index\";i:230;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:664;a:18:{s:4:\"tmpl\";i:957;s:2:\"id\";i:13112;s:5:\"title\";s:26:\"Photography &#8211; Header\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-photography-portfolio.png\";s:12:\"tmpl_created\";i:1582092483;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/photography-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:36:\"[\"Header\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:478;s:16:\"popularity_index\";i:325;s:11:\"trend_index\";i:205;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:665;a:18:{s:4:\"tmpl\";i:956;s:2:\"id\";i:13120;s:5:\"title\";s:31:\"Photography &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Post_s.png\";s:12:\"tmpl_created\";i:1582092351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/blocks/photography-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:480;s:16:\"popularity_index\";i:671;s:11:\"trend_index\";i:645;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:666;a:18:{s:4:\"tmpl\";i:901;s:2:\"id\";i:11807;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/09/404_small.png\";s:12:\"tmpl_created\";i:1569430070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:483;s:16:\"popularity_index\";i:480;s:11:\"trend_index\";i:497;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:667;a:18:{s:4:\"tmpl\";i:900;s:2:\"id\";i:11832;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Footer_small.png\";s:12:\"tmpl_created\";i:1569430019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"Creative Portfolio\",\"Footer\",\"Portfolio\"]\";s:10:\"menu_order\";i:484;s:16:\"popularity_index\";i:246;s:11:\"trend_index\";i:102;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:668;a:18:{s:4:\"tmpl\";i:898;s:2:\"id\";i:11847;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Archiv_small.png\";s:12:\"tmpl_created\";i:1569430010;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:487;s:16:\"popularity_index\";i:336;s:11:\"trend_index\";i:455;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:669;a:18:{s:4:\"tmpl\";i:897;s:2:\"id\";i:11854;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/09/Post_small.png\";s:12:\"tmpl_created\";i:1569429983;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:489;s:16:\"popularity_index\";i:482;s:11:\"trend_index\";i:609;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:670;a:18:{s:4:\"tmpl\";i:904;s:2:\"id\";i:11890;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-design-portfolio.png\";s:12:\"tmpl_created\";i:1571907344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"Creative Portfolio\",\"Header\",\"Portfolio\"]\";s:10:\"menu_order\";i:491;s:16:\"popularity_index\";i:306;s:11:\"trend_index\";i:364;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:671;a:18:{s:4:\"tmpl\";i:896;s:2:\"id\";i:11861;s:5:\"title\";s:27:\"Portfolio &#8211; Project 1\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project1_small.png\";s:12:\"tmpl_created\";i:1569429975;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/portfolio-project-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:493;s:16:\"popularity_index\";i:643;s:11:\"trend_index\";i:764;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:672;a:18:{s:4:\"tmpl\";i:895;s:2:\"id\";i:11870;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569429964;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/portfolio-project-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:495;s:16:\"popularity_index\";i:662;s:11:\"trend_index\";i:816;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:673;a:18:{s:4:\"tmpl\";i:903;s:2:\"id\";i:11897;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569494236;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/portfolio-project-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:496;s:16:\"popularity_index\";i:733;s:11:\"trend_index\";i:744;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:674;a:18:{s:4:\"tmpl\";i:894;s:2:\"id\";i:11877;s:5:\"title\";s:27:\"Portfolio &#8211; Project 3\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project3_small.png\";s:12:\"tmpl_created\";i:1569429954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/portfolio-project-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:498;s:16:\"popularity_index\";i:692;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:675;a:18:{s:4:\"tmpl\";i:597;s:2:\"id\";i:5019;s:5:\"title\";s:11:\"Portfolio 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_1.png\";s:12:\"tmpl_created\";i:1520520580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:500;s:16:\"popularity_index\";i:170;s:11:\"trend_index\";i:236;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:676;a:18:{s:4:\"tmpl\";i:609;s:2:\"id\";i:5141;s:5:\"title\";s:12:\"Portfolio 10\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_10.png\";s:12:\"tmpl_created\";i:1520520601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:503;s:16:\"popularity_index\";i:416;s:11:\"trend_index\";i:478;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:677;a:18:{s:4:\"tmpl\";i:598;s:2:\"id\";i:5027;s:5:\"title\";s:12:\"Portfolio 11\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_2.png\";s:12:\"tmpl_created\";i:1520520581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:504;s:16:\"popularity_index\";i:304;s:11:\"trend_index\";i:421;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:678;a:18:{s:4:\"tmpl\";i:599;s:2:\"id\";i:5037;s:5:\"title\";s:12:\"Portfolio 12\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_3.png\";s:12:\"tmpl_created\";i:1520520583;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:507;s:16:\"popularity_index\";i:279;s:11:\"trend_index\";i:399;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:679;a:18:{s:4:\"tmpl\";i:600;s:2:\"id\";i:5057;s:5:\"title\";s:12:\"Portfolio 13\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_4.png\";s:12:\"tmpl_created\";i:1520520586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:509;s:16:\"popularity_index\";i:239;s:11:\"trend_index\";i:288;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:680;a:18:{s:4:\"tmpl\";i:601;s:2:\"id\";i:5071;s:5:\"title\";s:12:\"Portfolio 14\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_5.png\";s:12:\"tmpl_created\";i:1520520588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:511;s:16:\"popularity_index\";i:276;s:11:\"trend_index\";i:329;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:681;a:18:{s:4:\"tmpl\";i:603;s:2:\"id\";i:5090;s:5:\"title\";s:12:\"Portfolio 15\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_6.png\";s:12:\"tmpl_created\";i:1520520591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:513;s:16:\"popularity_index\";i:186;s:11:\"trend_index\";i:283;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:682;a:18:{s:4:\"tmpl\";i:604;s:2:\"id\";i:5098;s:5:\"title\";s:12:\"Portfolio 16\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_7.png\";s:12:\"tmpl_created\";i:1520520593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:515;s:16:\"popularity_index\";i:156;s:11:\"trend_index\";i:211;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:683;a:18:{s:4:\"tmpl\";i:606;s:2:\"id\";i:5115;s:5:\"title\";s:12:\"Portfolio 17\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_8.png\";s:12:\"tmpl_created\";i:1520520596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:517;s:16:\"popularity_index\";i:19;s:11:\"trend_index\";i:22;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:684;a:18:{s:4:\"tmpl\";i:608;s:2:\"id\";i:5133;s:5:\"title\";s:12:\"Portfolio 18\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_9.png\";s:12:\"tmpl_created\";i:1520520599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:519;s:16:\"popularity_index\";i:180;s:11:\"trend_index\";i:280;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:685;a:18:{s:4:\"tmpl\";i:610;s:2:\"id\";i:5149;s:5:\"title\";s:11:\"Portfolio 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_10.png\";s:12:\"tmpl_created\";i:1520520602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:521;s:16:\"popularity_index\";i:413;s:11:\"trend_index\";i:635;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:686;a:18:{s:4:\"tmpl\";i:468;s:2:\"id\";i:5045;s:5:\"title\";s:11:\"Portfolio 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_2.png\";s:12:\"tmpl_created\";i:1520443423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:523;s:16:\"popularity_index\";i:636;s:11:\"trend_index\";i:608;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:687;a:18:{s:4:\"tmpl\";i:602;s:2:\"id\";i:5082;s:5:\"title\";s:11:\"Portfolio 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_4.png\";s:12:\"tmpl_created\";i:1520520589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:524;s:16:\"popularity_index\";i:558;s:11:\"trend_index\";i:654;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:688;a:18:{s:4:\"tmpl\";i:605;s:2:\"id\";i:5107;s:5:\"title\";s:11:\"Portfolio 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_7.png\";s:12:\"tmpl_created\";i:1520520594;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:527;s:16:\"popularity_index\";i:380;s:11:\"trend_index\";i:347;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:689;a:18:{s:4:\"tmpl\";i:607;s:2:\"id\";i:5125;s:5:\"title\";s:11:\"Portfolio 6\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_8.png\";s:12:\"tmpl_created\";i:1520520597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:529;s:16:\"popularity_index\";i:236;s:11:\"trend_index\";i:386;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:690;a:18:{s:4:\"tmpl\";i:596;s:2:\"id\";i:5007;s:5:\"title\";s:11:\"Portfolio 7\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_1.png\";s:12:\"tmpl_created\";i:1520520578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/portfolio-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"Portfolio\"]\";s:10:\"menu_order\";i:530;s:16:\"popularity_index\";i:44;s:11:\"trend_index\";i:183;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:691;a:18:{s:4:\"tmpl\";i:434;s:2:\"id\";i:4509;s:5:\"title\";s:9:\"Pricing 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_1.png\";s:12:\"tmpl_created\";i:1520443310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:532;s:16:\"popularity_index\";i:703;s:11:\"trend_index\";i:641;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:692;a:18:{s:4:\"tmpl\";i:439;s:2:\"id\";i:4553;s:5:\"title\";s:10:\"Pricing 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_4.png\";s:12:\"tmpl_created\";i:1520443319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/pricing-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:534;s:16:\"popularity_index\";i:511;s:11:\"trend_index\";i:506;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:693;a:18:{s:4:\"tmpl\";i:441;s:2:\"id\";i:4572;s:5:\"title\";s:10:\"Pricing 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_5.png\";s:12:\"tmpl_created\";i:1520443324;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/pricing-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:537;s:16:\"popularity_index\";i:308;s:11:\"trend_index\";i:248;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:694;a:18:{s:4:\"tmpl\";i:442;s:2:\"id\";i:4580;s:5:\"title\";s:10:\"Pricing 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_6.png\";s:12:\"tmpl_created\";i:1520443326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/pricing-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:539;s:16:\"popularity_index\";i:576;s:11:\"trend_index\";i:526;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:695;a:18:{s:4:\"tmpl\";i:444;s:2:\"id\";i:4597;s:5:\"title\";s:10:\"Pricing 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_7.png\";s:12:\"tmpl_created\";i:1520443330;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/pricing-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:540;s:16:\"popularity_index\";i:613;s:11:\"trend_index\";i:450;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:696;a:18:{s:4:\"tmpl\";i:446;s:2:\"id\";i:4613;s:5:\"title\";s:10:\"Pricing 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_8.png\";s:12:\"tmpl_created\";i:1520443334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/pricing-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:543;s:16:\"popularity_index\";i:581;s:11:\"trend_index\";i:568;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:697;a:18:{s:4:\"tmpl\";i:436;s:2:\"id\";i:4529;s:5:\"title\";s:9:\"Pricing 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_2.png\";s:12:\"tmpl_created\";i:1520443314;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:545;s:16:\"popularity_index\";i:609;s:11:\"trend_index\";i:613;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:698;a:18:{s:4:\"tmpl\";i:438;s:2:\"id\";i:4545;s:5:\"title\";s:9:\"Pricing 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_3.png\";s:12:\"tmpl_created\";i:1520443317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:547;s:16:\"popularity_index\";i:707;s:11:\"trend_index\";i:825;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:699;a:18:{s:4:\"tmpl\";i:440;s:2:\"id\";i:4562;s:5:\"title\";s:9:\"Pricing 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_4.png\";s:12:\"tmpl_created\";i:1520443322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:549;s:16:\"popularity_index\";i:697;s:11:\"trend_index\";i:821;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:700;a:18:{s:4:\"tmpl\";i:443;s:2:\"id\";i:4589;s:5:\"title\";s:9:\"Pricing 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_6.png\";s:12:\"tmpl_created\";i:1520443327;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:551;s:16:\"popularity_index\";i:716;s:11:\"trend_index\";i:639;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:701;a:18:{s:4:\"tmpl\";i:445;s:2:\"id\";i:4605;s:5:\"title\";s:9:\"Pricing 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_7.png\";s:12:\"tmpl_created\";i:1520443332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:553;s:16:\"popularity_index\";i:738;s:11:\"trend_index\";i:773;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:702;a:18:{s:4:\"tmpl\";i:433;s:2:\"id\";i:4500;s:5:\"title\";s:9:\"Pricing 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_1.png\";s:12:\"tmpl_created\";i:1520443308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:554;s:16:\"popularity_index\";i:500;s:11:\"trend_index\";i:451;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:703;a:18:{s:4:\"tmpl\";i:435;s:2:\"id\";i:4521;s:5:\"title\";s:9:\"Pricing 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_2.png\";s:12:\"tmpl_created\";i:1520443312;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:557;s:16:\"popularity_index\";i:311;s:11:\"trend_index\";i:372;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:704;a:18:{s:4:\"tmpl\";i:437;s:2:\"id\";i:4537;s:5:\"title\";s:9:\"Pricing 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_3.png\";s:12:\"tmpl_created\";i:1520443315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/pricing-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"Pricing\"]\";s:10:\"menu_order\";i:559;s:16:\"popularity_index\";i:589;s:11:\"trend_index\";i:841;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:705;a:18:{s:4:\"tmpl\";i:701;s:2:\"id\";i:9239;s:5:\"title\";s:17:\"product archive 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-1.png\";s:12:\"tmpl_created\";i:1532953482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/product-archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:561;s:16:\"popularity_index\";i:60;s:11:\"trend_index\";i:25;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:706;a:18:{s:4:\"tmpl\";i:702;s:2:\"id\";i:9247;s:5:\"title\";s:17:\"product archive 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-2.png\";s:12:\"tmpl_created\";i:1532953793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/product-archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:562;s:16:\"popularity_index\";i:71;s:11:\"trend_index\";i:30;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:707;a:18:{s:4:\"tmpl\";i:703;s:2:\"id\";i:9254;s:5:\"title\";s:17:\"product archive 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-3.png\";s:12:\"tmpl_created\";i:1532954032;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/product-archive-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:563;s:16:\"popularity_index\";i:73;s:11:\"trend_index\";i:44;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:708;a:18:{s:4:\"tmpl\";i:1046;s:2:\"id\";i:15204;s:5:\"title\";s:24:\"Psychologist &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/09/404.jpg\";s:12:\"tmpl_created\";i:1600161419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/psychologist-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:564;s:16:\"popularity_index\";i:574;s:11:\"trend_index\";i:493;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:709;a:18:{s:4:\"tmpl\";i:1047;s:2:\"id\";i:15212;s:5:\"title\";s:28:\"Psychologist &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Blog.jpg\";s:12:\"tmpl_created\";i:1600162340;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/blocks/psychologist-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:565;s:16:\"popularity_index\";i:379;s:11:\"trend_index\";i:358;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:710;a:18:{s:4:\"tmpl\";i:1048;s:2:\"id\";i:15219;s:5:\"title\";s:27:\"Psychologist &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Footer.jpg\";s:12:\"tmpl_created\";i:1600163069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/psychologist-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"Footer\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:566;s:16:\"popularity_index\";i:599;s:11:\"trend_index\";i:500;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:711;a:18:{s:4:\"tmpl\";i:1049;s:2:\"id\";i:15230;s:5:\"title\";s:27:\"Psychologist &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Header.png\";s:12:\"tmpl_created\";i:1600163444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/psychologist-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"Header\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:567;s:16:\"popularity_index\";i:429;s:11:\"trend_index\";i:423;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:712;a:18:{s:4:\"tmpl\";i:1050;s:2:\"id\";i:15240;s:5:\"title\";s:34:\"Psychologist &#8211; single post 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Post.png\";s:12:\"tmpl_created\";i:1600164087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/blocks/psychologist-single-post-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:568;s:16:\"popularity_index\";i:562;s:11:\"trend_index\";i:570;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:713;a:18:{s:4:\"tmpl\";i:1051;s:2:\"id\";i:15251;s:5:\"title\";s:34:\"Psychologist &#8211; single post 2\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Service-Page.png\";s:12:\"tmpl_created\";i:1600165179;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/blocks/psychologist-single-post-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:569;s:16:\"popularity_index\";i:507;s:11:\"trend_index\";i:368;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:714;a:18:{s:4:\"tmpl\";i:412;s:2:\"id\";i:4313;s:5:\"title\";s:11:\"Services 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_8.png\";s:12:\"tmpl_created\";i:1520443268;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:570;s:16:\"popularity_index\";i:115;s:11:\"trend_index\";i:53;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:715;a:18:{s:4:\"tmpl\";i:413;s:2:\"id\";i:4324;s:5:\"title\";s:11:\"Services 14\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_9.png\";s:12:\"tmpl_created\";i:1520443270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:571;s:16:\"popularity_index\";i:277;s:11:\"trend_index\";i:138;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:716;a:18:{s:4:\"tmpl\";i:418;s:2:\"id\";i:4368;s:5:\"title\";s:11:\"Services 16\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_13.png\";s:12:\"tmpl_created\";i:1520443279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:572;s:16:\"popularity_index\";i:62;s:11:\"trend_index\";i:59;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:717;a:18:{s:4:\"tmpl\";i:420;s:2:\"id\";i:4391;s:5:\"title\";s:11:\"Services 17\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_14.png\";s:12:\"tmpl_created\";i:1520443283;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:573;s:16:\"popularity_index\";i:153;s:11:\"trend_index\";i:120;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:718;a:18:{s:4:\"tmpl\";i:403;s:2:\"id\";i:4235;s:5:\"title\";s:11:\"Services 18\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_2.png\";s:12:\"tmpl_created\";i:1520443251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:574;s:16:\"popularity_index\";i:273;s:11:\"trend_index\";i:172;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:719;a:18:{s:4:\"tmpl\";i:417;s:2:\"id\";i:4357;s:5:\"title\";s:11:\"Services 20\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_12.png\";s:12:\"tmpl_created\";i:1520443277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:575;s:16:\"popularity_index\";i:45;s:11:\"trend_index\";i:45;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:720;a:18:{s:4:\"tmpl\";i:415;s:2:\"id\";i:4341;s:5:\"title\";s:11:\"Services 21\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_11.png\";s:12:\"tmpl_created\";i:1520443274;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:576;s:16:\"popularity_index\";i:142;s:11:\"trend_index\";i:114;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:721;a:18:{s:4:\"tmpl\";i:414;s:2:\"id\";i:4332;s:5:\"title\";s:11:\"Services 22\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_10.png\";s:12:\"tmpl_created\";i:1520443272;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-22/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:577;s:16:\"popularity_index\";i:138;s:11:\"trend_index\";i:149;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:722;a:18:{s:4:\"tmpl\";i:401;s:2:\"id\";i:4212;s:5:\"title\";s:11:\"Services 23\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_1.png\";s:12:\"tmpl_created\";i:1520443248;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-23/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:578;s:16:\"popularity_index\";i:136;s:11:\"trend_index\";i:302;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:723;a:18:{s:4:\"tmpl\";i:408;s:2:\"id\";i:4276;s:5:\"title\";s:11:\"Services 24\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_4.png\";s:12:\"tmpl_created\";i:1520443261;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-24/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:579;s:16:\"popularity_index\";i:353;s:11:\"trend_index\";i:514;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:724;a:18:{s:4:\"tmpl\";i:406;s:2:\"id\";i:4260;s:5:\"title\";s:11:\"Services 25\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_3.png\";s:12:\"tmpl_created\";i:1520443257;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-25/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:580;s:16:\"popularity_index\";i:184;s:11:\"trend_index\";i:209;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:725;a:18:{s:4:\"tmpl\";i:404;s:2:\"id\";i:4244;s:5:\"title\";s:11:\"Services 26\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_2.png\";s:12:\"tmpl_created\";i:1520443253;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-26/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:581;s:16:\"popularity_index\";i:544;s:11:\"trend_index\";i:596;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:726;a:18:{s:4:\"tmpl\";i:421;s:2:\"id\";i:4400;s:5:\"title\";s:11:\"Services 27\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_13.png\";s:12:\"tmpl_created\";i:1520443285;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-27/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:582;s:16:\"popularity_index\";i:286;s:11:\"trend_index\";i:438;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:727;a:18:{s:4:\"tmpl\";i:419;s:2:\"id\";i:4376;s:5:\"title\";s:11:\"Services 28\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_12.png\";s:12:\"tmpl_created\";i:1520443281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-28/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:583;s:16:\"popularity_index\";i:151;s:11:\"trend_index\";i:249;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:728;a:18:{s:4:\"tmpl\";i:416;s:2:\"id\";i:4349;s:5:\"title\";s:11:\"Services 29\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_11.png\";s:12:\"tmpl_created\";i:1520443275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-29/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:584;s:16:\"popularity_index\";i:330;s:11:\"trend_index\";i:483;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:729;a:18:{s:4:\"tmpl\";i:402;s:2:\"id\";i:4227;s:5:\"title\";s:11:\"Services 30\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_1.png\";s:12:\"tmpl_created\";i:1520443250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-30/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:585;s:16:\"popularity_index\";i:351;s:11:\"trend_index\";i:553;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:730;a:18:{s:4:\"tmpl\";i:560;s:2:\"id\";i:6162;s:5:\"title\";s:11:\"Services 31\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_1.png\";s:12:\"tmpl_created\";i:1520443668;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/services-31/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:586;s:16:\"popularity_index\";i:372;s:11:\"trend_index\";i:550;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:731;a:18:{s:4:\"tmpl\";i:411;s:2:\"id\";i:4302;s:5:\"title\";s:10:\"Services 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_7.png\";s:12:\"tmpl_created\";i:1520443266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:587;s:16:\"popularity_index\";i:58;s:11:\"trend_index\";i:97;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:732;a:18:{s:4:\"tmpl\";i:410;s:2:\"id\";i:4293;s:5:\"title\";s:10:\"Services 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_6.png\";s:12:\"tmpl_created\";i:1520443265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/services-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:588;s:16:\"popularity_index\";i:288;s:11:\"trend_index\";i:269;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:733;a:18:{s:4:\"tmpl\";i:409;s:2:\"id\";i:4284;s:5:\"title\";s:10:\"Services 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_5.png\";s:12:\"tmpl_created\";i:1520443263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/services-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:589;s:16:\"popularity_index\";i:27;s:11:\"trend_index\";i:21;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:734;a:18:{s:4:\"tmpl\";i:407;s:2:\"id\";i:4268;s:5:\"title\";s:10:\"Services 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_4.png\";s:12:\"tmpl_created\";i:1520443259;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/services-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:590;s:16:\"popularity_index\";i:173;s:11:\"trend_index\";i:213;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:735;a:18:{s:4:\"tmpl\";i:405;s:2:\"id\";i:4252;s:5:\"title\";s:10:\"Services 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_3.png\";s:12:\"tmpl_created\";i:1520443255;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/services-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:591;s:16:\"popularity_index\";i:46;s:11:\"trend_index\";i:99;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:736;a:18:{s:4:\"tmpl\";i:677;s:2:\"id\";i:8676;s:5:\"title\";s:13:\"single page 1\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.6.jpg\";s:12:\"tmpl_created\";i:1527682423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:592;s:16:\"popularity_index\";i:285;s:11:\"trend_index\";i:145;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:737;a:18:{s:4:\"tmpl\";i:678;s:2:\"id\";i:8678;s:5:\"title\";s:13:\"single page 2\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.2.jpg\";s:12:\"tmpl_created\";i:1527682780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:593;s:16:\"popularity_index\";i:140;s:11:\"trend_index\";i:82;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:738;a:18:{s:4:\"tmpl\";i:679;s:2:\"id\";i:8679;s:5:\"title\";s:13:\"single page 3\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.3.jpg\";s:12:\"tmpl_created\";i:1527682847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:594;s:16:\"popularity_index\";i:122;s:11:\"trend_index\";i:23;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:739;a:18:{s:4:\"tmpl\";i:680;s:2:\"id\";i:8680;s:5:\"title\";s:13:\"single page 4\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.1.jpg\";s:12:\"tmpl_created\";i:1527682896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:595;s:16:\"popularity_index\";i:373;s:11:\"trend_index\";i:190;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:740;a:18:{s:4:\"tmpl\";i:681;s:2:\"id\";i:8681;s:5:\"title\";s:13:\"single page 5\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.5.jpg\";s:12:\"tmpl_created\";i:1527682969;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:596;s:16:\"popularity_index\";i:287;s:11:\"trend_index\";i:218;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:741;a:18:{s:4:\"tmpl\";i:682;s:2:\"id\";i:8682;s:5:\"title\";s:13:\"single page 6\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.4.jpg\";s:12:\"tmpl_created\";i:1527683026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:597;s:16:\"popularity_index\";i:412;s:11:\"trend_index\";i:227;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:742;a:18:{s:4:\"tmpl\";i:683;s:2:\"id\";i:8703;s:5:\"title\";s:13:\"single page 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.7.jpg\";s:12:\"tmpl_created\";i:1527683072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-page-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:598;s:16:\"popularity_index\";i:401;s:11:\"trend_index\";i:316;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:743;a:18:{s:4:\"tmpl\";i:640;s:2:\"id\";i:7650;s:5:\"title\";s:13:\"Single Post 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_1_v2.jpg\";s:12:\"tmpl_created\";i:1521557736;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:599;s:16:\"popularity_index\";i:119;s:11:\"trend_index\";i:266;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:744;a:18:{s:4:\"tmpl\";i:639;s:2:\"id\";i:7663;s:5:\"title\";s:13:\"Single Post 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_2_v2.jpg\";s:12:\"tmpl_created\";i:1521547761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:600;s:16:\"popularity_index\";i:50;s:11:\"trend_index\";i:139;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:745;a:18:{s:4:\"tmpl\";i:705;s:2:\"id\";i:9296;s:5:\"title\";s:13:\"Single Post 3\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3002.jpg\";s:12:\"tmpl_created\";i:1537440673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:601;s:16:\"popularity_index\";i:213;s:11:\"trend_index\";i:204;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:746;a:18:{s:4:\"tmpl\";i:704;s:2:\"id\";i:9301;s:5:\"title\";s:13:\"Single Post 4\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3003.jpg\";s:12:\"tmpl_created\";i:1537440661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:602;s:16:\"popularity_index\";i:248;s:11:\"trend_index\";i:336;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:747;a:18:{s:4:\"tmpl\";i:706;s:2:\"id\";i:9313;s:5:\"title\";s:13:\"Single Post 5\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3001.jpg\";s:12:\"tmpl_created\";i:1537440798;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:603;s:16:\"popularity_index\";i:197;s:11:\"trend_index\";i:177;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:748;a:18:{s:4:\"tmpl\";i:707;s:2:\"id\";i:9343;s:5:\"title\";s:13:\"Single Post 6\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3004.jpg\";s:12:\"tmpl_created\";i:1537443531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:604;s:16:\"popularity_index\";i:228;s:11:\"trend_index\";i:279;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:749;a:18:{s:4:\"tmpl\";i:708;s:2:\"id\";i:9349;s:5:\"title\";s:13:\"Single Post 7\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3005.jpg\";s:12:\"tmpl_created\";i:1537443903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/single-post-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:605;s:16:\"popularity_index\";i:158;s:11:\"trend_index\";i:253;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:750;a:18:{s:4:\"tmpl\";i:697;s:2:\"id\";i:9174;s:5:\"title\";s:17:\"single product 01\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product01_350.png\";s:12:\"tmpl_created\";i:1532950125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/single-product-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:606;s:16:\"popularity_index\";i:31;s:11:\"trend_index\";i:6;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:751;a:18:{s:4:\"tmpl\";i:698;s:2:\"id\";i:9178;s:5:\"title\";s:17:\"single product 02\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product02_350new.png\";s:12:\"tmpl_created\";i:1532951997;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/single-product-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:607;s:16:\"popularity_index\";i:66;s:11:\"trend_index\";i:42;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:752;a:18:{s:4:\"tmpl\";i:699;s:2:\"id\";i:9180;s:5:\"title\";s:17:\"single product 03\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product03_350.png\";s:12:\"tmpl_created\";i:1532952302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/single-product-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:608;s:16:\"popularity_index\";i:108;s:11:\"trend_index\";i:66;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:753;a:18:{s:4:\"tmpl\";i:700;s:2:\"id\";i:9182;s:5:\"title\";s:17:\"single product 04\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product040_350.png\";s:12:\"tmpl_created\";i:1532952606;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/single-product-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:609;s:16:\"popularity_index\";i:123;s:11:\"trend_index\";i:81;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:754;a:18:{s:4:\"tmpl\";i:555;s:2:\"id\";i:6114;s:5:\"title\";s:7:\"Stats 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_6.png\";s:12:\"tmpl_created\";i:1520443659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:610;s:16:\"popularity_index\";i:434;s:11:\"trend_index\";i:692;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:755;a:18:{s:4:\"tmpl\";i:562;s:2:\"id\";i:6178;s:5:\"title\";s:8:\"Stats 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_2.png\";s:12:\"tmpl_created\";i:1520443676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/stats-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:611;s:16:\"popularity_index\";i:435;s:11:\"trend_index\";i:755;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:756;a:18:{s:4:\"tmpl\";i:561;s:2:\"id\";i:6170;s:5:\"title\";s:8:\"Stats 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_2.png\";s:12:\"tmpl_created\";i:1520443670;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/stats-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:612;s:16:\"popularity_index\";i:366;s:11:\"trend_index\";i:552;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:757;a:18:{s:4:\"tmpl\";i:563;s:2:\"id\";i:6186;s:5:\"title\";s:8:\"Stats 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_3.png\";s:12:\"tmpl_created\";i:1520443678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/stats-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:613;s:16:\"popularity_index\";i:569;s:11:\"trend_index\";i:811;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:758;a:18:{s:4:\"tmpl\";i:550;s:2:\"id\";i:6071;s:5:\"title\";s:8:\"Stats 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_3.png\";s:12:\"tmpl_created\";i:1520443649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/stats-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:614;s:16:\"popularity_index\";i:168;s:11:\"trend_index\";i:328;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:759;a:18:{s:4:\"tmpl\";i:554;s:2:\"id\";i:6106;s:5:\"title\";s:7:\"Stats 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_6.png\";s:12:\"tmpl_created\";i:1520443657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:615;s:16:\"popularity_index\";i:361;s:11:\"trend_index\";i:784;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:760;a:18:{s:4:\"tmpl\";i:551;s:2:\"id\";i:6079;s:5:\"title\";s:7:\"Stats 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_4.png\";s:12:\"tmpl_created\";i:1520443651;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:616;s:16:\"popularity_index\";i:284;s:11:\"trend_index\";i:385;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:761;a:18:{s:4:\"tmpl\";i:552;s:2:\"id\";i:6089;s:5:\"title\";s:7:\"Stats 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_5.png\";s:12:\"tmpl_created\";i:1520443653;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:617;s:16:\"popularity_index\";i:205;s:11:\"trend_index\";i:452;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:762;a:18:{s:4:\"tmpl\";i:549;s:2:\"id\";i:6063;s:5:\"title\";s:7:\"Stats 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_2.png\";s:12:\"tmpl_created\";i:1520443647;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:618;s:16:\"popularity_index\";i:181;s:11:\"trend_index\";i:419;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:763;a:18:{s:4:\"tmpl\";i:553;s:2:\"id\";i:6097;s:5:\"title\";s:7:\"Stats 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_2.png\";s:12:\"tmpl_created\";i:1520443655;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:619;s:16:\"popularity_index\";i:264;s:11:\"trend_index\";i:492;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:764;a:18:{s:4:\"tmpl\";i:538;s:2:\"id\";i:5956;s:5:\"title\";s:7:\"Stats 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_1.png\";s:12:\"tmpl_created\";i:1520443623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:620;s:16:\"popularity_index\";i:532;s:11:\"trend_index\";i:541;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:765;a:18:{s:4:\"tmpl\";i:537;s:2:\"id\";i:5947;s:5:\"title\";s:7:\"Stats 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_1.png\";s:12:\"tmpl_created\";i:1520443621;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:621;s:16:\"popularity_index\";i:368;s:11:\"trend_index\";i:531;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:766;a:18:{s:4:\"tmpl\";i:559;s:2:\"id\";i:6152;s:5:\"title\";s:7:\"Stats 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_1.png\";s:12:\"tmpl_created\";i:1520443666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/stats-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:622;s:16:\"popularity_index\";i:272;s:11:\"trend_index\";i:557;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:767;a:18:{s:4:\"tmpl\";i:469;s:2:\"id\";i:5157;s:5:\"title\";s:11:\"Subscribe 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_1.png\";s:12:\"tmpl_created\";i:1520443448;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/subscribe-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"Form\",\"Subscribe\"]\";s:10:\"menu_order\";i:623;s:16:\"popularity_index\";i:340;s:11:\"trend_index\";i:293;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:768;a:18:{s:4:\"tmpl\";i:472;s:2:\"id\";i:5181;s:5:\"title\";s:11:\"Subscribe 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_2.png\";s:12:\"tmpl_created\";i:1520443454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/subscribe-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"Form\",\"Subscribe\"]\";s:10:\"menu_order\";i:624;s:16:\"popularity_index\";i:451;s:11:\"trend_index\";i:340;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:769;a:18:{s:4:\"tmpl\";i:470;s:2:\"id\";i:5165;s:5:\"title\";s:11:\"Subscribe 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_1.png\";s:12:\"tmpl_created\";i:1520443450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/subscribe-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"Form\",\"Subscribe\"]\";s:10:\"menu_order\";i:625;s:16:\"popularity_index\";i:520;s:11:\"trend_index\";i:620;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:770;a:18:{s:4:\"tmpl\";i:477;s:2:\"id\";i:5222;s:5:\"title\";s:11:\"Subscribe 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_3.png\";s:12:\"tmpl_created\";i:1520443464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/subscribe-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"Form\",\"Subscribe\"]\";s:10:\"menu_order\";i:626;s:16:\"popularity_index\";i:397;s:11:\"trend_index\";i:427;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:771;a:18:{s:4:\"tmpl\";i:471;s:2:\"id\";i:5173;s:5:\"title\";s:11:\"Subscribe 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_2.png\";s:12:\"tmpl_created\";i:1520443452;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/subscribe-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"Form\",\"Subscribe\"]\";s:10:\"menu_order\";i:627;s:16:\"popularity_index\";i:261;s:11:\"trend_index\";i:237;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:772;a:18:{s:4:\"tmpl\";i:465;s:2:\"id\";i:4801;s:5:\"title\";s:7:\"Team 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_8.png\";s:12:\"tmpl_created\";i:1520443369;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:628;s:16:\"popularity_index\";i:332;s:11:\"trend_index\";i:188;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:773;a:18:{s:4:\"tmpl\";i:462;s:2:\"id\";i:4770;s:5:\"title\";s:7:\"Team 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_6.png\";s:12:\"tmpl_created\";i:1520443364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/team-12-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:629;s:16:\"popularity_index\";i:432;s:11:\"trend_index\";i:488;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:774;a:18:{s:4:\"tmpl\";i:458;s:2:\"id\";i:4727;s:5:\"title\";s:7:\"Team 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_2.png\";s:12:\"tmpl_created\";i:1520443356;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:630;s:16:\"popularity_index\";i:375;s:11:\"trend_index\";i:345;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:775;a:18:{s:4:\"tmpl\";i:543;s:2:\"id\";i:5999;s:5:\"title\";s:7:\"Team 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_10.png\";s:12:\"tmpl_created\";i:1520443634;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:631;s:16:\"popularity_index\";i:110;s:11:\"trend_index\";i:318;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:776;a:18:{s:4:\"tmpl\";i:455;s:2:\"id\";i:4698;s:5:\"title\";s:7:\"Team 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_1.png\";s:12:\"tmpl_created\";i:1520443350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:632;s:16:\"popularity_index\";i:449;s:11:\"trend_index\";i:410;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:777;a:18:{s:4:\"tmpl\";i:463;s:2:\"id\";i:4781;s:5:\"title\";s:7:\"Team 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_7.png\";s:12:\"tmpl_created\";i:1520443365;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:633;s:16:\"popularity_index\";i:267;s:11:\"trend_index\";i:330;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:778;a:18:{s:4:\"tmpl\";i:558;s:2:\"id\";i:6144;s:5:\"title\";s:7:\"Team 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_11.png\";s:12:\"tmpl_created\";i:1520443664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:634;s:16:\"popularity_index\";i:166;s:11:\"trend_index\";i:365;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:779;a:18:{s:4:\"tmpl\";i:464;s:2:\"id\";i:4793;s:5:\"title\";s:7:\"Team 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_8.png\";s:12:\"tmpl_created\";i:1520443367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:635;s:16:\"popularity_index\";i:207;s:11:\"trend_index\";i:173;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:780;a:18:{s:4:\"tmpl\";i:466;s:2:\"id\";i:4809;s:5:\"title\";s:7:\"Team 19\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_9.png\";s:12:\"tmpl_created\";i:1520443371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:636;s:16:\"popularity_index\";i:300;s:11:\"trend_index\";i:465;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:781;a:18:{s:4:\"tmpl\";i:459;s:2:\"id\";i:4736;s:5:\"title\";s:7:\"Team 20\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_4.png\";s:12:\"tmpl_created\";i:1520443358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:637;s:16:\"popularity_index\";i:144;s:11:\"trend_index\";i:159;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:782;a:18:{s:4:\"tmpl\";i:467;s:2:\"id\";i:4818;s:5:\"title\";s:7:\"Team 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_9.png\";s:12:\"tmpl_created\";i:1520443373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:638;s:16:\"popularity_index\";i:515;s:11:\"trend_index\";i:606;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:783;a:18:{s:4:\"tmpl\";i:461;s:2:\"id\";i:4759;s:5:\"title\";s:7:\"Team 22\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_5.png\";s:12:\"tmpl_created\";i:1520443362;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-22/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:639;s:16:\"popularity_index\";i:299;s:11:\"trend_index\";i:376;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:784;a:18:{s:4:\"tmpl\";i:460;s:2:\"id\";i:4746;s:5:\"title\";s:7:\"Team 23\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_4.png\";s:12:\"tmpl_created\";i:1520443360;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/team-23/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:640;s:16:\"popularity_index\";i:282;s:11:\"trend_index\";i:378;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:785;a:18:{s:4:\"tmpl\";i:457;s:2:\"id\";i:4718;s:5:\"title\";s:6:\"Team 4\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_3.png\";s:12:\"tmpl_created\";i:1520443354;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/team-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:641;s:16:\"popularity_index\";i:192;s:11:\"trend_index\";i:359;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:786;a:18:{s:4:\"tmpl\";i:456;s:2:\"id\";i:4706;s:5:\"title\";s:6:\"Team 5\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_2.png\";s:12:\"tmpl_created\";i:1520443352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/team-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:642;s:16:\"popularity_index\";i:149;s:11:\"trend_index\";i:299;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:787;a:18:{s:4:\"tmpl\";i:544;s:2:\"id\";i:6008;s:5:\"title\";s:6:\"Team 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_10.png\";s:12:\"tmpl_created\";i:1520443636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/team-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:643;s:16:\"popularity_index\";i:75;s:11:\"trend_index\";i:277;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:788;a:18:{s:4:\"tmpl\";i:454;s:2:\"id\";i:4690;s:5:\"title\";s:6:\"Team 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_1.png\";s:12:\"tmpl_created\";i:1520443348;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/team-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:644;s:16:\"popularity_index\";i:243;s:11:\"trend_index\";i:402;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:789;a:18:{s:4:\"tmpl\";i:586;s:2:\"id\";i:4921;s:5:\"title\";s:14:\"Testimonial 10\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_5.png\";s:12:\"tmpl_created\";i:1520520562;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:645;s:16:\"popularity_index\";i:219;s:11:\"trend_index\";i:198;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:790;a:18:{s:4:\"tmpl\";i:582;s:2:\"id\";i:4889;s:5:\"title\";s:14:\"Testimonial 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-2.jpg\";s:12:\"tmpl_created\";i:1520520556;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:646;s:16:\"popularity_index\";i:557;s:11:\"trend_index\";i:522;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:791;a:18:{s:4:\"tmpl\";i:580;s:2:\"id\";i:4871;s:5:\"title\";s:14:\"Testimonial 12\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_3.png\";s:12:\"tmpl_created\";i:1520520552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:647;s:16:\"popularity_index\";i:262;s:11:\"trend_index\";i:391;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:792;a:18:{s:4:\"tmpl\";i:578;s:2:\"id\";i:4854;s:5:\"title\";s:14:\"Testimonial 13\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_2.png\";s:12:\"tmpl_created\";i:1520520549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:648;s:16:\"popularity_index\";i:637;s:11:\"trend_index\";i:741;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:793;a:18:{s:4:\"tmpl\";i:595;s:2:\"id\";i:4995;s:5:\"title\";s:14:\"Testimonial 14\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_12.png\";s:12:\"tmpl_created\";i:1520520577;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:649;s:16:\"popularity_index\";i:400;s:11:\"trend_index\";i:411;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:794;a:18:{s:4:\"tmpl\";i:593;s:2:\"id\";i:4979;s:5:\"title\";s:14:\"Testimonial 15\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_10.png\";s:12:\"tmpl_created\";i:1520520573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:650;s:16:\"popularity_index\";i:568;s:11:\"trend_index\";i:544;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:795;a:18:{s:4:\"tmpl\";i:576;s:2:\"id\";i:4835;s:5:\"title\";s:14:\"Testimonial 16\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_1.png\";s:12:\"tmpl_created\";i:1520520546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:651;s:16:\"popularity_index\";i:399;s:11:\"trend_index\";i:401;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:796;a:18:{s:4:\"tmpl\";i:594;s:2:\"id\";i:4987;s:5:\"title\";s:14:\"Testimonial 17\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_12-1.png\";s:12:\"tmpl_created\";i:1520520575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:652;s:16:\"popularity_index\";i:159;s:11:\"trend_index\";i:199;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:797;a:18:{s:4:\"tmpl\";i:577;s:2:\"id\";i:4843;s:5:\"title\";s:14:\"Testimonial 18\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_2.png\";s:12:\"tmpl_created\";i:1520520548;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:653;s:16:\"popularity_index\";i:457;s:11:\"trend_index\";i:780;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:798;a:18:{s:4:\"tmpl\";i:579;s:2:\"id\";i:4863;s:5:\"title\";s:14:\"Testimonial 19\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_3.png\";s:12:\"tmpl_created\";i:1520520551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:654;s:16:\"popularity_index\";i:245;s:11:\"trend_index\";i:599;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:799;a:18:{s:4:\"tmpl\";i:581;s:2:\"id\";i:4880;s:5:\"title\";s:14:\"Testimonial 20\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-1.jpg\";s:12:\"tmpl_created\";i:1520520554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:655;s:16:\"popularity_index\";i:446;s:11:\"trend_index\";i:653;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:800;a:18:{s:4:\"tmpl\";i:583;s:2:\"id\";i:4897;s:5:\"title\";s:14:\"Testimonial 21\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_5.png\";s:12:\"tmpl_created\";i:1520520557;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:656;s:16:\"popularity_index\";i:78;s:11:\"trend_index\";i:289;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:801;a:18:{s:4:\"tmpl\";i:584;s:2:\"id\";i:4905;s:5:\"title\";s:14:\"Testimonial 22\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_6.png\";s:12:\"tmpl_created\";i:1520520559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-22/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:657;s:16:\"popularity_index\";i:121;s:11:\"trend_index\";i:221;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:802;a:18:{s:4:\"tmpl\";i:585;s:2:\"id\";i:4913;s:5:\"title\";s:14:\"Testimonial 23\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_7.png\";s:12:\"tmpl_created\";i:1520520561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-23/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:658;s:16:\"popularity_index\";i:247;s:11:\"trend_index\";i:566;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:803;a:18:{s:4:\"tmpl\";i:575;s:2:\"id\";i:4826;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_1.png\";s:12:\"tmpl_created\";i:1520520544;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/testimonial-24-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:659;s:16:\"popularity_index\";i:256;s:11:\"trend_index\";i:395;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:804;a:18:{s:4:\"tmpl\";i:587;s:2:\"id\";i:4929;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_8.png\";s:12:\"tmpl_created\";i:1520520564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-24/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:660;s:16:\"popularity_index\";i:49;s:11:\"trend_index\";i:206;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:805;a:18:{s:4:\"tmpl\";i:591;s:2:\"id\";i:4963;s:5:\"title\";s:14:\"Testimonial 25\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_10.png\";s:12:\"tmpl_created\";i:1520520570;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/testimonial-25-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:661;s:16:\"popularity_index\";i:417;s:11:\"trend_index\";i:546;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:806;a:18:{s:4:\"tmpl\";i:592;s:2:\"id\";i:4971;s:5:\"title\";s:14:\"Testimonial 26\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_11.png\";s:12:\"tmpl_created\";i:1520520572;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-26/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:662;s:16:\"popularity_index\";i:649;s:11:\"trend_index\";i:718;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:807;a:18:{s:4:\"tmpl\";i:589;s:2:\"id\";i:4947;s:5:\"title\";s:14:\"Testimonial 27\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_9.png\";s:12:\"tmpl_created\";i:1520520567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-27/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:663;s:16:\"popularity_index\";i:221;s:11:\"trend_index\";i:496;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:808;a:18:{s:4:\"tmpl\";i:590;s:2:\"id\";i:4955;s:5:\"title\";s:14:\"Testimonial 29\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_9.png\";s:12:\"tmpl_created\";i:1520520569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/testimonial-29/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:664;s:16:\"popularity_index\";i:378;s:11:\"trend_index\";i:695;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:809;a:18:{s:4:\"tmpl\";i:588;s:2:\"id\";i:4939;s:5:\"title\";s:13:\"Testimonial 9\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_8.png\";s:12:\"tmpl_created\";i:1520520565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/testimonial-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:665;s:16:\"popularity_index\";i:103;s:11:\"trend_index\";i:341;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:810;a:18:{s:4:\"tmpl\";i:928;s:2:\"id\";i:12509;s:5:\"title\";s:18:\"Travel &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/404.png\";s:12:\"tmpl_created\";i:1575960378;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/travel-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:666;s:16:\"popularity_index\";i:747;s:11:\"trend_index\";i:712;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:811;a:18:{s:4:\"tmpl\";i:929;s:2:\"id\";i:12516;s:5:\"title\";s:27:\"Travel &#8211; Archive Blog\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Archiv_s.png\";s:12:\"tmpl_created\";i:1575960387;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/travel-archive-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:667;s:16:\"popularity_index\";i:496;s:11:\"trend_index\";i:487;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:812;a:18:{s:4:\"tmpl\";i:927;s:2:\"id\";i:12500;s:5:\"title\";s:21:\"Travel &#8211; Header\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-travel-and-tours.png\";s:12:\"tmpl_created\";i:1575960371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/travel-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"Header\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:668;s:16:\"popularity_index\";i:443;s:11:\"trend_index\";i:434;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:813;a:18:{s:4:\"tmpl\";i:930;s:2:\"id\";i:12524;s:5:\"title\";s:26:\"Travel &#8211; Single Post\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Post_s.png\";s:12:\"tmpl_created\";i:1575960397;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/travel-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:669;s:16:\"popularity_index\";i:591;s:11:\"trend_index\";i:663;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:814;a:18:{s:4:\"tmpl\";i:931;s:2:\"id\";i:12531;s:5:\"title\";s:31:\"Travel &#8211; Single Post Tour\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Tour_s.png\";s:12:\"tmpl_created\";i:1575960404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/blocks/travel-single-post-tour/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:670;s:16:\"popularity_index\";i:630;s:11:\"trend_index\";i:548;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:815;a:18:{s:4:\"tmpl\";i:926;s:2:\"id\";i:12492;s:5:\"title\";s:14:\"Travel -Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Footer_s.png\";s:12:\"tmpl_created\";i:1575960358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/travel-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"Footer\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:671;s:16:\"popularity_index\";i:453;s:11:\"trend_index\";i:322;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:816;a:18:{s:4:\"tmpl\";i:1068;s:2:\"id\";i:15498;s:5:\"title\";s:23:\"Travel Blog &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/11/404.jpg\";s:12:\"tmpl_created\";i:1606215636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/travel-blog-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:23:\"[\"404\",\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:672;s:16:\"popularity_index\";i:749;s:11:\"trend_index\";i:759;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:817;a:18:{s:4:\"tmpl\";i:1069;s:2:\"id\";i:15508;s:5:\"title\";s:29:\"Travel Blog &#8211; Archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/11/Archive-1-350.jpg\";s:12:\"tmpl_created\";i:1606215649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/travel-blog-archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:673;s:16:\"popularity_index\";i:659;s:11:\"trend_index\";i:468;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:818;a:18:{s:4:\"tmpl\";i:1070;s:2:\"id\";i:15518;s:5:\"title\";s:29:\"Travel Blog &#8211; Archive 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/11/Archive-2-350-Copy.jpg\";s:12:\"tmpl_created\";i:1606215663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/travel-blog-archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:674;s:16:\"popularity_index\";i:688;s:11:\"trend_index\";i:431;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:819;a:18:{s:4:\"tmpl\";i:1071;s:2:\"id\";i:15528;s:5:\"title\";s:26:\"Travel Blog &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/11/Footer.jpg\";s:12:\"tmpl_created\";i:1606215673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/travel-blog-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:26:\"[\"Blog\",\"Footer\",\"Travel\"]\";s:10:\"menu_order\";i:675;s:16:\"popularity_index\";i:656;s:11:\"trend_index\";i:377;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:820;a:18:{s:4:\"tmpl\";i:1067;s:2:\"id\";i:15536;s:5:\"title\";s:26:\"Travel Blog &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/11/Header.jpg\";s:12:\"tmpl_created\";i:1606215625;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/travel-blog-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:26:\"[\"Blog\",\"Header\",\"Travel\"]\";s:10:\"menu_order\";i:676;s:16:\"popularity_index\";i:584;s:11:\"trend_index\";i:228;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:821;a:18:{s:4:\"tmpl\";i:1072;s:2:\"id\";i:15545;s:5:\"title\";s:33:\"Travel Blog &#8211; Single Post 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/11/Single-1-350.jpg\";s:12:\"tmpl_created\";i:1606215684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/blocks/travel-blog-single-post-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:677;s:16:\"popularity_index\";i:669;s:11:\"trend_index\";i:482;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:822;a:18:{s:4:\"tmpl\";i:1066;s:2:\"id\";i:15556;s:5:\"title\";s:33:\"Travel Blog &#8211; Single Post 2\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/11/Single-2-350.jpg\";s:12:\"tmpl_created\";i:1606215613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/blocks/travel-blog-single-post-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:678;s:16:\"popularity_index\";i:652;s:11:\"trend_index\";i:454;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}","no");
INSERT INTO BXzlkOCF_options VALUES("274","elementor_remote_info_feed_data","a:3:{i:0;a:5:{s:5:\"title\";s:73:\"Elementor 3.16 - Faster Performance, Flexible Design, and more Accessible\";s:7:\"excerpt\";s:210:\"Elementor 3.16 activates Flexbox Containers by default for new websites, improves site loading speed with performance enhancements, increases accessibility for visitors who use assistive technologies, and more.\";s:7:\"created\";i:1695134049;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:152:\"https://elementor.com/blog/316-faster-performance-flexible-design-accessibility/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:82:\"Elementor 3.15 is Here - Check out The Taxonomy Filter, Nested Accordion, and More\";s:7:\"excerpt\";s:241:\"This release includes the first phase of the much-awaited Taxonomy Filter, the new and improved Accordion widget with nested items, enhanced styling capabilities for Carousel widgets, fun new Elementor AI Image tools, and the new Apps Page. \";s:7:\"created\";i:1691513693;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:157:\"https://elementor.com/blog/introducing-315-taxonomy-filter-nested-accordion-and-more/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:97:\"Introducing Elementor 3.14 - Gain More Design Flexibility with Nested Carousels and Loop Grid Ads\";s:7:\"excerpt\";s:239:\"This version includes a new Carousel widget, extends the Loop Grid with the ability to place static content within the Loop, a Global Styles Preview, and a multitude of highly requested styling capabilities, and new Elementor AI features. \";s:7:\"created\";i:1688394655;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:154:\"https://elementor.com/blog/introducing-314-nested-carousel-loop-grid-ads-and-more/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}","no");
INSERT INTO BXzlkOCF_options VALUES("275","_transient_timeout_elementor_remote_info_api_data_3.16.4","1695679309","no");
INSERT INTO BXzlkOCF_options VALUES("276","_transient_elementor_remote_info_api_data_3.16.4","a:4:{s:9:\"timestamp\";s:10:\"1695632513\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:75:{i:0;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:3;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:6;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:8;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:9;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:10;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:11;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:12;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:14;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:25;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:26;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:27;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:33;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:34;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:35;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:36;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:37;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:38;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:39;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:40;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:41;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:43;a:4:{s:4:\"name\";s:11:\"search-form\";s:5:\"title\";s:11:\"Search Form\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:51;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:52;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:53;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:54;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:55;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:57;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"6.3.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}","no");
INSERT INTO BXzlkOCF_options VALUES("277","wpmudev_notices","a:3:{s:7:\"plugins\";a:1:{s:5:\"smush\";i:1695636109;}s:5:\"queue\";a:1:{s:5:\"smush\";a:3:{s:5:\"email\";i:1695636098;s:4:\"rate\";i:1696240898;s:8:\"giveaway\";i:1695808898;}}s:4:\"done\";a:0:{}}","no");
INSERT INTO BXzlkOCF_options VALUES("278","_transient_timeout_jupiterx_core_cp_updates_last_checked","1695722514","no");
INSERT INTO BXzlkOCF_options VALUES("279","_transient_jupiterx_core_cp_updates_last_checked","1695636114","no");
INSERT INTO BXzlkOCF_options VALUES("280","_transient_timeout_jupiterx_tgmpa_plugins_check","1695722515","no");
INSERT INTO BXzlkOCF_options VALUES("281","_transient_jupiterx_tgmpa_plugins_check","a:0:{}","no");
INSERT INTO BXzlkOCF_options VALUES("284","can_compress_scripts","1","yes");
INSERT INTO BXzlkOCF_options VALUES("285","_site_transient_timeout_jet_dashboard_remote_jet_plugin_list","1695722520","no");
INSERT INTO BXzlkOCF_options VALUES("286","_site_transient_jet_dashboard_remote_jet_plugin_list","a:18:{i:0;a:9:{s:4:\"name\";s:11:\"JetElements\";s:4:\"slug\";s:29:\"jet-elements/jet-elements.php\";s:7:\"version\";s:8:\"2.6.12.2\";s:5:\"thumb\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo/jetelements.svg\";s:9:\"thumb_alt\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetelements.svg\";s:4:\"docs\";s:68:\"https://crocoblock.com/knowledge-base/article-category/jet-elements/\";s:4:\"demo\";s:43:\"https://crocoblock.com/plugins/jetelements/\";s:4:\"desc\";s:24:\"Must-have design widgets\";s:8:\"versions\";a:34:{i:0;s:8:\"2.6.12.2\";i:1;s:8:\"2.6.12.1\";i:2;s:6:\"2.6.12\";i:3;s:6:\"2.6.11\";i:4;s:6:\"2.6.10\";i:5;s:5:\"2.6.9\";i:6;s:5:\"2.6.8\";i:7;s:5:\"2.6.7\";i:8;s:5:\"2.6.6\";i:9;s:5:\"2.6.5\";i:10;s:5:\"2.6.4\";i:11;s:5:\"2.6.3\";i:12;s:5:\"2.6.2\";i:13;s:5:\"2.6.1\";i:14;s:5:\"2.6.0\";i:15;s:5:\"2.5.9\";i:16;s:5:\"2.5.8\";i:17;s:5:\"2.5.7\";i:18;s:5:\"2.5.6\";i:19;s:5:\"2.5.5\";i:20;s:5:\"2.5.4\";i:21;s:5:\"2.5.3\";i:22;s:5:\"2.5.2\";i:23;s:5:\"2.5.1\";i:24;s:5:\"2.5.0\";i:25;s:5:\"2.4.1\";i:26;s:5:\"2.4.0\";i:27;s:5:\"2.3.3\";i:28;s:5:\"2.3.2\";i:29;s:5:\"2.3.1\";i:30;s:5:\"2.3.0\";i:31;s:6:\"2.2.17\";i:32;s:6:\"2.2.16\";i:33;s:6:\"2.2.15\";}}i:1;a:9:{s:4:\"name\";s:7:\"JetTabs\";s:4:\"slug\";s:21:\"jet-tabs/jet-tabs.php\";s:7:\"version\";s:6:\"2.1.25\";s:5:\"thumb\";s:71:\"https://account.crocoblock.com/free-download/images/jetlogo/jettabs.svg\";s:9:\"thumb_alt\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jettabs.svg\";s:4:\"docs\";s:64:\"https://crocoblock.com/knowledge-base/article-category/jet-tabs/\";s:4:\"demo\";s:39:\"https://crocoblock.com/plugins/jettabs/\";s:4:\"desc\";s:31:\"A smart way to organize content\";s:8:\"versions\";a:22:{i:0;s:6:\"2.1.25\";i:1;s:6:\"2.1.24\";i:2;s:6:\"2.1.23\";i:3;s:6:\"2.1.22\";i:4;s:6:\"2.1.21\";i:5;s:6:\"2.1.20\";i:6;s:6:\"2.1.19\";i:7;s:6:\"2.1.18\";i:8;s:6:\"2.1.17\";i:9;s:6:\"2.1.16\";i:10;s:6:\"2.1.15\";i:11;s:6:\"2.1.14\";i:12;s:6:\"2.1.13\";i:13;s:6:\"2.1.12\";i:14;s:6:\"2.1.11\";i:15;s:6:\"2.1.10\";i:16;s:5:\"2.1.9\";i:17;s:5:\"2.1.8\";i:18;s:5:\"2.1.7\";i:19;s:5:\"2.1.6\";i:20;s:5:\"2.1.5\";i:21;s:5:\"2.1.4\";}}i:2;a:9:{s:4:\"name\";s:10:\"JetReviews\";s:4:\"slug\";s:27:\"jet-reviews/jet-reviews.php\";s:7:\"version\";s:5:\"2.3.2\";s:5:\"thumb\";s:74:\"https://account.crocoblock.com/free-download/images/jetlogo/jetreviews.svg\";s:9:\"thumb_alt\";s:78:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetreviews.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jetreviews/\";s:4:\"demo\";s:42:\"https://crocoblock.com/plugins/jetreviews/\";s:4:\"desc\";s:32:\"Add reviews, comments, and rates\";s:8:\"versions\";a:18:{i:0;s:5:\"2.3.2\";i:1;s:5:\"2.3.1\";i:2;s:5:\"2.3.0\";i:3;s:5:\"2.2.7\";i:4;s:5:\"2.2.6\";i:5;s:5:\"2.2.4\";i:6;s:5:\"2.2.3\";i:7;s:5:\"2.2.2\";i:8;s:5:\"2.2.1\";i:9;s:5:\"2.2.0\";i:10;s:5:\"2.1.1\";i:11;s:5:\"2.1.0\";i:12;s:5:\"2.0.2\";i:13;s:5:\"2.0.1\";i:14;s:5:\"2.0.0\";i:15;s:5:\"1.3.0\";i:16;s:5:\"1.2.2\";i:17;s:5:\"1.2.1\";}}i:3;a:9:{s:4:\"name\";s:7:\"JetMenu\";s:4:\"slug\";s:21:\"jet-menu/jet-menu.php\";s:7:\"version\";s:5:\"2.4.1\";s:5:\"thumb\";s:71:\"https://account.crocoblock.com/free-download/images/jetlogo/jetmenu.svg\";s:9:\"thumb_alt\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetmenu.svg\";s:4:\"docs\";s:64:\"https://crocoblock.com/knowledge-base/article-category/jet-menu/\";s:4:\"demo\";s:39:\"https://crocoblock.com/plugins/jetmenu/\";s:4:\"desc\";s:24:\"Build a custom mega menu\";s:8:\"versions\";a:24:{i:0;s:5:\"2.4.1\";i:1;s:5:\"2.4.0\";i:2;s:5:\"2.3.0\";i:3;s:5:\"2.2.4\";i:4;s:5:\"2.2.3\";i:5;s:5:\"2.2.2\";i:6;s:5:\"2.2.1\";i:7;s:5:\"2.2.0\";i:8;s:5:\"2.1.7\";i:9;s:5:\"2.1.6\";i:10;s:5:\"2.1.5\";i:11;s:5:\"2.1.4\";i:12;s:5:\"2.1.3\";i:13;s:5:\"2.1.2\";i:14;s:5:\"2.1.1\";i:15;s:5:\"2.1.0\";i:16;s:5:\"2.0.9\";i:17;s:5:\"2.0.8\";i:18;s:5:\"2.0.7\";i:19;s:5:\"2.0.6\";i:20;s:5:\"2.0.5\";i:21;s:5:\"2.0.4\";i:22;s:5:\"2.0.3\";i:23;s:6:\"1.5.15\";}}i:4;a:9:{s:4:\"name\";s:7:\"JetBlog\";s:4:\"slug\";s:21:\"jet-blog/jet-blog.php\";s:7:\"version\";s:5:\"2.3.5\";s:5:\"thumb\";s:71:\"https://account.crocoblock.com/free-download/images/jetlogo/jetblog.svg\";s:9:\"thumb_alt\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetblog.svg\";s:4:\"docs\";s:64:\"https://crocoblock.com/knowledge-base/article-category/jet-blog/\";s:4:\"demo\";s:39:\"https://crocoblock.com/plugins/jetblog/\";s:4:\"desc\";s:26:\"Create engaging blog pages\";s:8:\"versions\";a:17:{i:0;s:5:\"2.3.5\";i:1;s:5:\"2.3.4\";i:2;s:5:\"2.3.3\";i:3;s:5:\"2.3.2\";i:4;s:5:\"2.3.1\";i:5;s:5:\"2.3.0\";i:6;s:6:\"2.2.17\";i:7;s:6:\"2.2.16\";i:8;s:6:\"2.2.15\";i:9;s:6:\"2.2.14\";i:10;s:6:\"2.2.13\";i:11;s:6:\"2.2.12\";i:12;s:6:\"2.2.11\";i:13;s:6:\"2.2.10\";i:14;s:5:\"2.2.9\";i:15;s:5:\"2.2.8\";i:16;s:5:\"2.2.7\";}}i:5;a:9:{s:4:\"name\";s:9:\"JetBlocks\";s:4:\"slug\";s:25:\"jet-blocks/jet-blocks.php\";s:7:\"version\";s:5:\"1.3.8\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jetblocks.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetblocks.svg\";s:4:\"docs\";s:65:\"https://crocoblock.com/knowledge-base/article-category/jetblocks/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jetblocks/\";s:4:\"desc\";s:30:\"Enrich header & footer content\";s:8:\"versions\";a:19:{i:0;s:5:\"1.3.8\";i:1;s:5:\"1.3.7\";i:2;s:5:\"1.3.6\";i:3;s:5:\"1.3.5\";i:4;s:5:\"1.3.4\";i:5;s:5:\"1.3.3\";i:6;s:5:\"1.3.2\";i:7;s:5:\"1.3.1\";i:8;s:5:\"1.3.0\";i:9;s:6:\"1.2.10\";i:10;s:5:\"1.2.9\";i:11;s:5:\"1.2.8\";i:12;s:5:\"1.2.7\";i:13;s:5:\"1.2.6\";i:14;s:5:\"1.2.5\";i:15;s:5:\"1.2.4\";i:16;s:5:\"1.2.3\";i:17;s:5:\"1.2.2\";i:18;s:5:\"1.2.1\";}}i:6;a:9:{s:4:\"name\";s:9:\"JetTricks\";s:4:\"slug\";s:25:\"jet-tricks/jet-tricks.php\";s:7:\"version\";s:5:\"1.4.6\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jettricks.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jettricks.svg\";s:4:\"docs\";s:65:\"https://crocoblock.com/knowledge-base/article-category/jettricks/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jettricks/\";s:4:\"desc\";s:30:\"Add interactive visual effects\";s:8:\"versions\";a:22:{i:0;s:5:\"1.4.6\";i:1;s:5:\"1.4.5\";i:2;s:5:\"1.4.4\";i:3;s:5:\"1.4.3\";i:4;s:5:\"1.4.2\";i:5;s:5:\"1.4.1\";i:6;s:5:\"1.4.0\";i:7;s:5:\"1.3.9\";i:8;s:5:\"1.3.8\";i:9;s:5:\"1.3.7\";i:10;s:5:\"1.3.5\";i:11;s:5:\"1.3.4\";i:12;s:5:\"1.3.3\";i:13;s:5:\"1.3.2\";i:14;s:5:\"1.3.1\";i:15;s:5:\"1.3.0\";i:16;s:6:\"1.2.12\";i:17;s:6:\"1.2.11\";i:18;s:6:\"1.2.10\";i:19;s:5:\"1.2.9\";i:20;s:5:\"1.2.8\";i:21;s:5:\"1.2.7\";}}i:7;a:9:{s:4:\"name\";s:15:\"JetSmartFilters\";s:4:\"slug\";s:39:\"jet-smart-filters/jet-smart-filters.php\";s:7:\"version\";s:5:\"3.2.1\";s:5:\"thumb\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo/jetsmartfilters.svg\";s:9:\"thumb_alt\";s:83:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetsmartfilters.svg\";s:4:\"docs\";s:71:\"https://crocoblock.com/knowledge-base/article-category/jetsmartfilters/\";s:4:\"demo\";s:47:\"https://crocoblock.com/plugins/jetsmartfilters/\";s:4:\"desc\";s:34:\"Advanced filters for any post type\";s:8:\"versions\";a:42:{i:0;s:5:\"3.2.1\";i:1;s:5:\"3.2.0\";i:2;s:5:\"3.1.2\";i:3;s:5:\"3.1.1\";i:4;s:5:\"3.1.0\";i:5;s:5:\"3.0.4\";i:6;s:5:\"3.0.3\";i:7;s:5:\"3.0.2\";i:8;s:5:\"3.0.1\";i:9;s:5:\"3.0.0\";i:10;s:6:\"2.3.14\";i:11;s:6:\"2.3.13\";i:12;s:6:\"2.3.12\";i:13;s:6:\"2.3.11\";i:14;s:6:\"2.3.10\";i:15;s:5:\"2.3.9\";i:16;s:5:\"2.3.8\";i:17;s:5:\"2.3.7\";i:18;s:5:\"2.3.6\";i:19;s:5:\"2.3.5\";i:20;s:5:\"2.3.4\";i:21;s:5:\"2.3.3\";i:22;s:5:\"2.3.2\";i:23;s:5:\"2.3.1\";i:24;s:5:\"2.3.0\";i:25;s:5:\"2.2.3\";i:26;s:5:\"2.2.2\";i:27;s:5:\"2.2.1\";i:28;s:5:\"2.2.0\";i:29;s:5:\"2.1.1\";i:30;s:5:\"2.1.0\";i:31;s:5:\"2.0.6\";i:32;s:5:\"2.0.5\";i:33;s:5:\"2.0.4\";i:34;s:5:\"2.0.3\";i:35;s:5:\"2.0.2\";i:36;s:5:\"2.0.1\";i:37;s:5:\"2.0.0\";i:38;s:5:\"1.8.4\";i:39;s:5:\"1.8.3\";i:40;s:5:\"1.8.2\";i:41;s:5:\"1.8.1\";}}i:8;a:9:{s:4:\"name\";s:8:\"JetPopup\";s:4:\"slug\";s:23:\"jet-popup/jet-popup.php\";s:7:\"version\";s:5:\"2.0.2\";s:5:\"thumb\";s:72:\"https://account.crocoblock.com/free-download/images/jetlogo/jetpopup.svg\";s:9:\"thumb_alt\";s:76:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetpopup.svg\";s:4:\"docs\";s:65:\"https://crocoblock.com/knowledge-base/article-category/jet-popup/\";s:4:\"demo\";s:40:\"https://crocoblock.com/plugins/jetpopup/\";s:4:\"desc\";s:30:\"Create popups that boost sales\";s:8:\"versions\";a:21:{i:0;s:5:\"2.0.2\";i:1;s:5:\"2.0.1\";i:2;s:5:\"2.0.0\";i:3;s:5:\"1.6.5\";i:4;s:5:\"1.6.4\";i:5;s:5:\"1.6.3\";i:6;s:5:\"1.6.2\";i:7;s:5:\"1.6.1\";i:8;s:5:\"1.6.0\";i:9;s:5:\"1.5.6\";i:10;s:5:\"1.5.5\";i:11;s:5:\"1.5.4\";i:12;s:5:\"1.5.3\";i:13;s:5:\"1.5.2\";i:14;s:5:\"1.5.1\";i:15;s:5:\"1.5.0\";i:16;s:5:\"1.4.2\";i:17;s:5:\"1.4.1\";i:18;s:5:\"1.4.0\";i:19;s:5:\"1.3.1\";i:20;s:5:\"1.3.0\";}}i:9;a:9:{s:4:\"name\";s:9:\"JetSearch\";s:4:\"slug\";s:25:\"jet-search/jet-search.php\";s:7:\"version\";s:5:\"3.1.2\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jetsearch.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetsearch.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jet-search/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jetsearch/\";s:4:\"desc\";s:27:\"Try the fastest AJAX search\";s:8:\"versions\";a:21:{i:0;s:5:\"3.1.2\";i:1;s:5:\"3.1.1\";i:2;s:5:\"3.1.0\";i:3;s:5:\"3.0.3\";i:4;s:5:\"3.0.2\";i:5;s:5:\"3.0.1\";i:6;s:5:\"3.0.0\";i:7;s:6:\"2.1.17\";i:8;s:6:\"2.1.16\";i:9;s:6:\"2.1.15\";i:10;s:6:\"2.1.14\";i:11;s:6:\"2.1.13\";i:12;s:6:\"2.1.12\";i:13;s:6:\"2.1.11\";i:14;s:6:\"2.1.10\";i:15;s:5:\"2.1.9\";i:16;s:5:\"2.1.8\";i:17;s:5:\"2.1.7\";i:18;s:5:\"2.1.6\";i:19;s:5:\"2.1.5\";i:20;s:5:\"2.1.4\";}}i:10;a:9:{s:4:\"name\";s:13:\"JetWooBuilder\";s:4:\"slug\";s:35:\"jet-woo-builder/jet-woo-builder.php\";s:7:\"version\";s:7:\"2.1.7.1\";s:5:\"thumb\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo/jetwoobuilder.svg\";s:9:\"thumb_alt\";s:81:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetwoobuilder.svg\";s:4:\"docs\";s:69:\"https://crocoblock.com/knowledge-base/article-category/jetwoobuilder/\";s:4:\"demo\";s:45:\"https://crocoblock.com/plugins/jetwoobuilder/\";s:4:\"desc\";s:30:\"Create custom e-commerce pages\";s:8:\"versions\";a:56:{i:0;s:7:\"2.1.7.1\";i:1;s:5:\"2.1.7\";i:2;s:7:\"2.1.6.1\";i:3;s:5:\"2.1.6\";i:4;s:5:\"2.1.5\";i:5;s:5:\"2.1.4\";i:6;s:5:\"2.1.3\";i:7;s:7:\"2.1.2.1\";i:8;s:5:\"2.1.2\";i:9;s:5:\"2.1.1\";i:10;s:5:\"2.1.0\";i:11;s:5:\"2.0.5\";i:12;s:5:\"2.0.4\";i:13;s:5:\"2.0.3\";i:14;s:5:\"2.0.2\";i:15;s:5:\"2.0.1\";i:16;s:5:\"2.0.0\";i:17;s:6:\"1.12.4\";i:18;s:6:\"1.12.3\";i:19;s:6:\"1.12.2\";i:20;s:6:\"1.12.1\";i:21;s:6:\"1.12.0\";i:22;s:6:\"1.11.4\";i:23;s:6:\"1.11.3\";i:24;s:6:\"1.11.2\";i:25;s:6:\"1.11.1\";i:26;s:6:\"1.11.0\";i:27;s:6:\"1.10.5\";i:28;s:6:\"1.10.4\";i:29;s:6:\"1.10.3\";i:30;s:6:\"1.10.2\";i:31;s:6:\"1.10.1\";i:32;s:6:\"1.10.0\";i:33;s:5:\"1.9.2\";i:34;s:5:\"1.9.1\";i:35;s:5:\"1.9.0\";i:36;s:5:\"1.8.2\";i:37;s:5:\"1.8.1\";i:38;s:5:\"1.8.0\";i:39;s:6:\"1.7.12\";i:40;s:6:\"1.7.11\";i:41;s:6:\"1.7.10\";i:42;s:5:\"1.7.9\";i:43;s:5:\"1.7.8\";i:44;s:5:\"1.7.7\";i:45;s:5:\"1.7.6\";i:46;s:5:\"1.7.5\";i:47;s:5:\"1.7.4\";i:48;s:5:\"1.7.3\";i:49;s:5:\"1.7.2\";i:50;s:5:\"1.7.1\";i:51;s:5:\"1.7.0\";i:52;s:5:\"1.6.6\";i:53;s:5:\"1.6.5\";i:54;s:5:\"1.6.4\";i:55;s:5:\"1.6.3\";}}i:11;a:9:{s:4:\"name\";s:17:\"JetProductGallery\";s:4:\"slug\";s:51:\"jet-woo-product-gallery/jet-woo-product-gallery.php\";s:7:\"version\";s:8:\"2.1.13.1\";s:5:\"thumb\";s:81:\"https://account.crocoblock.com/free-download/images/jetlogo/jetproductgallery.svg\";s:9:\"thumb_alt\";s:85:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetproductgallery.svg\";s:4:\"docs\";s:73:\"https://crocoblock.com/knowledge-base/article-category/jetproductgallery/\";s:4:\"demo\";s:49:\"https://crocoblock.com/plugins/jetproductgallery/\";s:4:\"desc\";s:38:\"Product gallery sliders and carousels \";s:8:\"versions\";a:34:{i:0;s:8:\"2.1.13.1\";i:1;s:6:\"2.1.13\";i:2;s:6:\"2.1.12\";i:3;s:6:\"2.1.11\";i:4;s:6:\"2.1.10\";i:5;s:5:\"2.1.9\";i:6;s:5:\"2.1.8\";i:7;s:5:\"2.1.7\";i:8;s:5:\"2.1.6\";i:9;s:5:\"2.1.5\";i:10;s:5:\"2.1.4\";i:11;s:5:\"2.1.3\";i:12;s:5:\"2.1.2\";i:13;s:5:\"2.1.1\";i:14;s:5:\"2.1.0\";i:15;s:5:\"2.0.5\";i:16;s:5:\"2.0.4\";i:17;s:5:\"2.0.3\";i:18;s:5:\"2.0.2\";i:19;s:5:\"2.0.1\";i:20;s:5:\"2.0.0\";i:21;s:5:\"1.3.1\";i:22;s:5:\"1.3.0\";i:23;s:5:\"1.2.3\";i:24;s:5:\"1.2.2\";i:25;s:5:\"1.2.1\";i:26;s:5:\"1.2.0\";i:27;s:5:\"1.1.9\";i:28;s:5:\"1.1.8\";i:29;s:5:\"1.1.7\";i:30;s:5:\"1.1.6\";i:31;s:5:\"1.1.5\";i:32;s:5:\"1.1.4\";i:33;s:5:\"1.1.3\";}}i:12;a:9:{s:4:\"name\";s:19:\"JetCompare&Wishlist\";s:4:\"slug\";s:31:\"jet-compare-wishlist/jet-cw.php\";s:7:\"version\";s:7:\"1.5.5.1\";s:5:\"thumb\";s:85:\"https://account.crocoblock.com/free-download/images/jetlogo/jetwoocomparewishlist.svg\";s:9:\"thumb_alt\";s:86:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetcomparewishlist.svg\";s:4:\"docs\";s:74:\"https://crocoblock.com/knowledge-base/article-category/jetcomparewishlist/\";s:4:\"demo\";s:50:\"https://crocoblock.com/plugins/jetcomparewishlist/\";s:4:\"desc\";s:34:\"Compare and wishlist functionality\";s:8:\"versions\";a:29:{i:0;s:7:\"1.5.5.1\";i:1;s:5:\"1.5.5\";i:2;s:5:\"1.5.4\";i:3;s:5:\"1.5.3\";i:4;s:5:\"1.5.2\";i:5;s:5:\"1.5.1\";i:6;s:5:\"1.5.0\";i:7;s:5:\"1.4.7\";i:8;s:5:\"1.4.6\";i:9;s:5:\"1.4.5\";i:10;s:5:\"1.4.4\";i:11;s:5:\"1.4.3\";i:12;s:5:\"1.4.2\";i:13;s:5:\"1.4.1\";i:14;s:5:\"1.4.0\";i:15;s:5:\"1.3.5\";i:16;s:5:\"1.3.4\";i:17;s:5:\"1.3.3\";i:18;s:5:\"1.3.2\";i:19;s:5:\"1.3.1\";i:20;s:5:\"1.3.0\";i:21;s:5:\"1.2.4\";i:22;s:5:\"1.2.3\";i:23;s:5:\"1.2.2\";i:24;s:5:\"1.2.1\";i:25;s:5:\"1.2.0\";i:26;s:5:\"1.1.2\";i:27;s:5:\"1.1.1\";i:28;s:5:\"1.1.0\";}}i:13;a:9:{s:4:\"name\";s:9:\"JetEngine\";s:4:\"slug\";s:25:\"jet-engine/jet-engine.php\";s:7:\"version\";s:7:\"3.2.5.1\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jetengine.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetengine.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jet-engine/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jetengine/\";s:4:\"desc\";s:36:\"Top-notch plugin for dynamic content\";s:8:\"versions\";a:93:{i:0;s:7:\"3.2.5.1\";i:1;s:5:\"3.2.5\";i:2;s:5:\"3.2.4\";i:3;s:7:\"3.2.3.2\";i:4;s:7:\"3.2.3.1\";i:5;s:5:\"3.2.3\";i:6;s:5:\"3.2.2\";i:7;s:5:\"3.2.1\";i:8;s:5:\"3.2.0\";i:9;s:7:\"3.1.6.1\";i:10;s:5:\"3.1.6\";i:11;s:5:\"3.1.5\";i:12;s:5:\"3.1.4\";i:13;s:7:\"3.1.3.1\";i:14;s:5:\"3.1.3\";i:15;s:5:\"3.1.2\";i:16;s:5:\"3.1.1\";i:17;s:5:\"3.1.0\";i:18;s:7:\"3.0.9.1\";i:19;s:5:\"3.0.9\";i:20;s:5:\"3.0.8\";i:21;s:5:\"3.0.7\";i:22;s:7:\"3.0.6.1\";i:23;s:5:\"3.0.6\";i:24;s:5:\"3.0.5\";i:25;s:5:\"3.0.4\";i:26;s:7:\"3.0.3.1\";i:27;s:5:\"3.0.3\";i:28;s:5:\"3.0.2\";i:29;s:5:\"3.0.1\";i:30;s:5:\"3.0.0\";i:31;s:7:\"2.11.11\";i:32;s:7:\"2.11.10\";i:33;s:6:\"2.11.9\";i:34;s:6:\"2.11.8\";i:35;s:6:\"2.11.7\";i:36;s:6:\"2.11.6\";i:37;s:6:\"2.11.5\";i:38;s:6:\"2.11.4\";i:39;s:6:\"2.11.3\";i:40;s:6:\"2.11.2\";i:41;s:6:\"2.11.1\";i:42;s:6:\"2.11.0\";i:43;s:6:\"2.10.3\";i:44;s:6:\"2.10.2\";i:45;s:6:\"2.10.1\";i:46;s:6:\"2.10.0\";i:47;s:5:\"2.9.4\";i:48;s:5:\"2.9.3\";i:49;s:5:\"2.9.2\";i:50;s:5:\"2.9.1\";i:51;s:5:\"2.9.0\";i:52;s:6:\"2.8.10\";i:53;s:5:\"2.8.9\";i:54;s:5:\"2.8.8\";i:55;s:5:\"2.8.7\";i:56;s:5:\"2.8.6\";i:57;s:5:\"2.8.5\";i:58;s:5:\"2.8.4\";i:59;s:5:\"2.8.3\";i:60;s:5:\"2.8.2\";i:61;s:5:\"2.8.1\";i:62;s:5:\"2.8.0\";i:63;s:5:\"2.7.8\";i:64;s:5:\"2.7.7\";i:65;s:5:\"2.7.6\";i:66;s:5:\"2.7.5\";i:67;s:5:\"2.7.4\";i:68;s:5:\"2.7.3\";i:69;s:5:\"2.7.2\";i:70;s:5:\"2.7.1\";i:71;s:5:\"2.7.0\";i:72;s:5:\"2.6.4\";i:73;s:5:\"2.6.3\";i:74;s:5:\"2.6.2\";i:75;s:5:\"2.6.1\";i:76;s:5:\"2.6.0\";i:77;s:5:\"2.5.6\";i:78;s:5:\"2.5.5\";i:79;s:5:\"2.5.4\";i:80;s:5:\"2.5.3\";i:81;s:5:\"2.5.2\";i:82;s:5:\"2.5.1\";i:83;s:5:\"2.5.0\";i:84;s:6:\"2.4.13\";i:85;s:6:\"2.4.12\";i:86;s:6:\"2.4.11\";i:87;s:6:\"2.4.10\";i:88;s:5:\"2.4.9\";i:89;s:5:\"2.4.8\";i:90;s:5:\"2.4.6\";i:91;s:5:\"2.4.5\";i:92;s:5:\"2.4.4\";}}i:14;a:9:{s:4:\"name\";s:10:\"JetBooking\";s:4:\"slug\";s:27:\"jet-booking/jet-booking.php\";s:7:\"version\";s:5:\"3.0.0\";s:5:\"thumb\";s:74:\"https://account.crocoblock.com/free-download/images/jetlogo/jetbooking.svg\";s:9:\"thumb_alt\";s:78:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetbooking.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jetbooking/\";s:4:\"demo\";s:42:\"https://crocoblock.com/plugins/jetbooking/\";s:4:\"desc\";s:29:\"Complex booking functionality\";s:8:\"versions\";a:38:{i:0;s:5:\"3.0.0\";i:1;s:5:\"2.8.0\";i:2;s:5:\"2.7.2\";i:3;s:5:\"2.7.1\";i:4;s:5:\"2.7.0\";i:5;s:5:\"2.6.3\";i:6;s:5:\"2.6.2\";i:7;s:7:\"2.6.1.1\";i:8;s:5:\"2.6.1\";i:9;s:5:\"2.6.0\";i:10;s:5:\"2.5.5\";i:11;s:5:\"2.5.4\";i:12;s:5:\"2.5.3\";i:13;s:5:\"2.5.2\";i:14;s:5:\"2.5.1\";i:15;s:5:\"2.5.0\";i:16;s:5:\"2.4.6\";i:17;s:5:\"2.4.5\";i:18;s:5:\"2.4.4\";i:19;s:5:\"2.4.3\";i:20;s:5:\"2.4.2\";i:21;s:5:\"2.4.1\";i:22;s:5:\"2.4.0\";i:23;s:5:\"2.3.5\";i:24;s:5:\"2.3.4\";i:25;s:5:\"2.3.3\";i:26;s:5:\"2.3.2\";i:27;s:5:\"2.3.1\";i:28;s:5:\"2.3.0\";i:29;s:5:\"2.2.5\";i:30;s:5:\"2.2.4\";i:31;s:5:\"2.2.3\";i:32;s:5:\"2.2.1\";i:33;s:5:\"2.2.0\";i:34;s:5:\"2.1.1\";i:35;s:5:\"2.1.0\";i:36;s:5:\"2.0.2\";i:37;s:5:\"2.0.1\";}}i:15;a:9:{s:4:\"name\";s:15:\"JetStyleManager\";s:4:\"slug\";s:39:\"jet-style-manager/jet-style-manager.php\";s:7:\"version\";s:5:\"1.3.5\";s:5:\"thumb\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo/jetstylemanager.svg\";s:9:\"thumb_alt\";s:83:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetstylemanager.svg\";s:4:\"docs\";s:71:\"https://crocoblock.com/knowledge-base/article-category/jetstylemanager/\";s:4:\"demo\";s:47:\"https://crocoblock.com/plugins/jetstylemanager/\";s:4:\"desc\";s:36:\"Manage Elementor page style settings\";s:8:\"versions\";a:10:{i:0;s:5:\"1.3.2\";i:1;s:5:\"1.3.1\";i:2;s:5:\"1.2.0\";i:3;s:5:\"1.1.5\";i:4;s:5:\"1.1.4\";i:5;s:5:\"1.1.3\";i:6;s:5:\"1.1.2\";i:7;s:5:\"1.1.1\";i:8;s:5:\"1.1.0\";i:9;s:5:\"1.0.0\";}}i:16;a:9:{s:4:\"name\";s:14:\"JetAppointment\";s:4:\"slug\";s:53:\"jet-appointments-booking/jet-appointments-booking.php\";s:7:\"version\";s:5:\"2.0.3\";s:5:\"thumb\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo/jet-appointment.svg\";s:9:\"thumb_alt\";s:83:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jet-appointment.svg\";s:4:\"docs\";s:70:\"https://crocoblock.com/knowledge-base/article-category/jetappointment/\";s:4:\"demo\";s:46:\"https://crocoblock.com/plugins/jetappointment/\";s:4:\"desc\";s:31:\"Create custom appointment forms\";s:8:\"versions\";a:31:{i:0;s:5:\"2.0.3\";i:1;s:5:\"2.0.2\";i:2;s:5:\"2.0.1\";i:3;s:5:\"2.0.0\";i:4;s:6:\"1.6.10\";i:5;s:5:\"1.6.9\";i:6;s:5:\"1.6.8\";i:7;s:5:\"1.6.7\";i:8;s:5:\"1.6.6\";i:9;s:5:\"1.6.5\";i:10;s:5:\"1.6.4\";i:11;s:5:\"1.6.3\";i:12;s:5:\"1.6.2\";i:13;s:5:\"1.6.1\";i:14;s:5:\"1.6.0\";i:15;s:5:\"1.5.7\";i:16;s:5:\"1.5.6\";i:17;s:5:\"1.5.5\";i:18;s:5:\"1.5.1\";i:19;s:5:\"1.5.0\";i:20;s:5:\"1.4.0\";i:21;s:5:\"1.3.3\";i:22;s:5:\"1.3.2\";i:23;s:5:\"1.3.1\";i:24;s:5:\"1.3.0\";i:25;s:5:\"1.2.2\";i:26;s:5:\"1.2.1\";i:27;s:5:\"1.2.0\";i:28;s:5:\"1.1.1\";i:29;s:5:\"1.1.0\";i:30;s:5:\"1.0.0\";}}i:17;a:9:{s:4:\"name\";s:12:\"JetThemeCore\";s:4:\"slug\";s:33:\"jet-theme-core/jet-theme-core.php\";s:7:\"version\";s:5:\"2.1.2\";s:5:\"thumb\";s:76:\"https://account.crocoblock.com/free-download/images/jetlogo/jetthemecore.svg\";s:9:\"thumb_alt\";s:80:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetthemecore.svg\";s:4:\"docs\";s:67:\"https://crocoblock.com/knowledge-base/article-category/theme-parts/\";s:4:\"demo\";s:44:\"https://crocoblock.com/plugins/jetthemecore/\";s:4:\"desc\";s:65:\"Most powerful plugin created to make building websites super easy\";s:8:\"versions\";a:19:{i:0;s:5:\"2.1.2\";i:1;s:5:\"2.1.1\";i:2;s:5:\"2.1.0\";i:3;s:5:\"2.0.7\";i:4;s:5:\"2.0.6\";i:5;s:5:\"2.0.5\";i:6;s:5:\"2.0.4\";i:7;s:5:\"2.0.3\";i:8;s:5:\"2.0.2\";i:9;s:5:\"2.0.1\";i:10;s:5:\"2.0.0\";i:11;s:5:\"1.2.2\";i:12;s:5:\"1.2.1\";i:13;s:5:\"1.2.0\";i:14;s:6:\"1.1.25\";i:15;s:6:\"1.1.24\";i:16;s:6:\"1.1.23\";i:17;s:6:\"1.1.22\";i:18;s:6:\"1.1.21\";}}}","no");
INSERT INTO BXzlkOCF_options VALUES("287","_site_transient_timeout_jupiterx_managed_plugins","1695722522","no");
INSERT INTO BXzlkOCF_options VALUES("288","_site_transient_jupiterx_managed_plugins","a:25:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"Jupiter X Core\";s:4:\"slug\";s:13:\"jupiterx-core\";s:6:\"source\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/09/jupiterx-core-v3.5.6.zip\";s:7:\"version\";s:5:\"3.5.6\";s:8:\"required\";s:4:\"true\";s:3:\"pro\";s:5:\"false\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:22:\"Advanced Custom Fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:4:\"true\";s:3:\"pro\";s:5:\"false\";}i:2;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"Elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:4:\"true\";s:3:\"pro\";s:5:\"false\";}i:3;O:8:\"stdClass\":6:{s:4:\"name\";s:5:\"Raven\";s:4:\"slug\";s:5:\"raven\";s:6:\"source\";s:94:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2020/09/raven-v1.11.0.zip\";s:7:\"version\";s:6:\"1.11.0\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:4;O:8:\"stdClass\":6:{s:4:\"name\";s:12:\"Jet Elements\";s:4:\"slug\";s:12:\"jet-elements\";s:6:\"source\";s:103:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-elements-v2.6.12.1.zip\";s:7:\"version\";s:8:\"2.6.12.1\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:5;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"Jet Blog\";s:4:\"slug\";s:8:\"jet-blog\";s:6:\"source\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-blog-v2.3.4.zip\";s:7:\"version\";s:5:\"2.3.4\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:6;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"Jet Menu\";s:4:\"slug\";s:8:\"jet-menu\";s:6:\"source\";s:96:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-menu-v2.4.0.zip\";s:7:\"version\";s:5:\"2.4.0\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:7;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"Jet Popup\";s:4:\"slug\";s:9:\"jet-popup\";s:6:\"source\";s:97:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-popup-v2.0.1.zip\";s:7:\"version\";s:5:\"2.0.1\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:8;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"Jet Tabs\";s:4:\"slug\";s:8:\"jet-tabs\";s:6:\"source\";s:97:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-tabs-v2.1.23.zip\";s:7:\"version\";s:6:\"2.1.23\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:9;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"Jet WooBuilder\";s:4:\"slug\";s:15:\"jet-woo-builder\";s:6:\"source\";s:105:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-woo-builder-v2.1.6.1.zip\";s:7:\"version\";s:7:\"2.1.6.1\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:10;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"Jet Tricks\";s:4:\"slug\";s:10:\"jet-tricks\";s:6:\"source\";s:98:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-tricks-v1.4.4.zip\";s:7:\"version\";s:5:\"1.4.4\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:11;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"Jet Engine\";s:4:\"slug\";s:10:\"jet-engine\";s:6:\"source\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-engine-v3.2.3.2.zip\";s:7:\"version\";s:7:\"3.2.3.2\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:12;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"Jet SmartFilters\";s:4:\"slug\";s:17:\"jet-smart-filters\";s:6:\"source\";s:105:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jet-smart-filters-v3.2.0.zip\";s:7:\"version\";s:5:\"3.2.0\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:13;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"WPBakery Page Builder (Modified Version)\";s:4:\"slug\";s:17:\"js_composer_theme\";s:6:\"source\";s:111:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/09/jupiterx_js_composer_theme.7.0.zip\";s:7:\"version\";s:3:\"7.0\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:14;O:8:\"stdClass\":6:{s:4:\"name\";s:13:\"Jupiter Donut\";s:4:\"slug\";s:13:\"jupiter-donut\";s:6:\"source\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/jupiter-donut-v1.4.4.zip\";s:7:\"version\";s:5:\"1.4.4\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:15;O:8:\"stdClass\":6:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:6:\"source\";s:114:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/advanced-custom-fields-pro-v6.2.0.zip\";s:7:\"version\";s:5:\"6.2.0\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:16;O:8:\"stdClass\":6:{s:4:\"name\";s:23:\"Menu Icons by ThemeIsle\";s:4:\"slug\";s:10:\"menu-icons\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";}i:17;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"Slider Revolution\";s:4:\"slug\";s:9:\"revslider\";s:6:\"source\";s:98:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/09/revslider.v6.6.16.zip\";s:7:\"version\";s:6:\"6.6.16\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:18;O:8:\"stdClass\":6:{s:4:\"name\";s:13:\"Master Slider\";s:4:\"slug\";s:12:\"masterslider\";s:6:\"source\";s:100:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/masterslider-v3.6.5.zip\";s:7:\"version\";s:5:\"3.6.5\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:19;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"LayerSlider WP\";s:4:\"slug\";s:11:\"LayerSlider\";s:6:\"source\";s:101:\"https://d3fvlpdr5b7667.cloudfront.net/wp-content/uploads/dlm_uploads/2023/08/layersliderwp-v7.8.0.zip\";s:7:\"version\";s:5:\"7.8.0\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:4:\"true\";}i:20;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"WooCommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";}i:21;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"Customizer Export/Import\";s:4:\"slug\";s:24:\"customizer-export-import\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";}i:22;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"Customizer Reset\";s:4:\"slug\";s:26:\"customizer-reset-by-wpzoom\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";}i:23;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"WunderWP\";s:4:\"slug\";s:8:\"wunderwp\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";}i:24;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"Growmatik\";s:4:\"slug\";s:40:\"marketing-automation-and-personalization\";s:6:\"source\";s:7:\"wp-repo\";s:7:\"version\";s:7:\"wp-repo\";s:8:\"required\";s:5:\"false\";s:3:\"pro\";s:5:\"false\";}}","no");
INSERT INTO BXzlkOCF_options VALUES("289","_site_transient_update_plugins","O:8:\"stdClass\":1:{s:8:\"response\";a:8:{s:30:\"advanced-custom-fields/acf.php\";O:8:\"stdClass\":4:{s:4:\"slug\";s:22:\"advanced-custom-fields\";s:6:\"plugin\";s:30:\"advanced-custom-fields/acf.php\";s:11:\"new_version\";s:5:\"6.2.1\";s:7:\"package\";s:7:\"wp-repo\";}s:23:\"elementor/elementor.php\";O:8:\"stdClass\":4:{s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.16.4\";s:7:\"package\";s:7:\"wp-repo\";}s:8:\"wunderwp\";O:8:\"stdClass\":4:{s:4:\"slug\";s:8:\"wunderwp\";s:6:\"plugin\";s:8:\"wunderwp\";s:11:\"new_version\";s:5:\"1.6.1\";s:7:\"package\";s:7:\"wp-repo\";}s:11:\"woocommerce\";O:8:\"stdClass\":4:{s:4:\"slug\";s:11:\"woocommerce\";s:6:\"plugin\";s:11:\"woocommerce\";s:11:\"new_version\";s:5:\"8.1.1\";s:7:\"package\";s:7:\"wp-repo\";}s:40:\"marketing-automation-and-personalization\";O:8:\"stdClass\":4:{s:4:\"slug\";s:40:\"marketing-automation-and-personalization\";s:6:\"plugin\";s:40:\"marketing-automation-and-personalization\";s:11:\"new_version\";s:5:\"2.8.3\";s:7:\"package\";s:7:\"wp-repo\";}s:10:\"menu-icons\";O:8:\"stdClass\":4:{s:4:\"slug\";s:10:\"menu-icons\";s:6:\"plugin\";s:10:\"menu-icons\";s:11:\"new_version\";s:6:\"0.13.7\";s:7:\"package\";s:7:\"wp-repo\";}s:24:\"customizer-export-import\";O:8:\"stdClass\":4:{s:4:\"slug\";s:24:\"customizer-export-import\";s:6:\"plugin\";s:24:\"customizer-export-import\";s:11:\"new_version\";s:5:\"0.9.6\";s:7:\"package\";s:7:\"wp-repo\";}s:26:\"customizer-reset-by-wpzoom\";O:8:\"stdClass\":4:{s:4:\"slug\";s:26:\"customizer-reset-by-wpzoom\";s:6:\"plugin\";s:26:\"customizer-reset-by-wpzoom\";s:11:\"new_version\";s:5:\"1.1.1\";s:7:\"package\";s:7:\"wp-repo\";}}}","no");
INSERT INTO BXzlkOCF_options VALUES("290","_transient_timeout_jupiterx_core_cp_updates","1695722522","no");
INSERT INTO BXzlkOCF_options VALUES("291","_transient_jupiterx_core_cp_updates","a:0:{}","no");



CREATE TABLE `BXzlkOCF_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=855 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO BXzlkOCF_postmeta VALUES("1","2","_wp_page_template","default");
INSERT INTO BXzlkOCF_postmeta VALUES("2","3","_wp_page_template","default");
INSERT INTO BXzlkOCF_postmeta VALUES("3","5","_wp_attached_file","2020/01/logo-1.svg");
INSERT INTO BXzlkOCF_postmeta VALUES("4","5","_wp_attachment_metadata","a:3:{s:8:\"filesize\";i:5602;s:5:\"width\";d:142.54;s:6:\"height\";d:19.44;}");
INSERT INTO BXzlkOCF_postmeta VALUES("5","5","_wp_attachment_image_alt","logo");
INSERT INTO BXzlkOCF_postmeta VALUES("6","5","_wxr_import_user_slug","arda");
INSERT INTO BXzlkOCF_postmeta VALUES("7","6","_wp_attached_file","2020/01/logo.svg");
INSERT INTO BXzlkOCF_postmeta VALUES("8","6","_wp_attachment_metadata","a:3:{s:8:\"filesize\";i:5602;s:5:\"width\";d:142.54;s:6:\"height\";d:19.44;}");
INSERT INTO BXzlkOCF_postmeta VALUES("9","6","_wp_attachment_image_alt","logo");
INSERT INTO BXzlkOCF_postmeta VALUES("10","6","_wxr_import_user_slug","arda");
INSERT INTO BXzlkOCF_postmeta VALUES("11","7","_wp_attached_file","2020/01/blog-bg-1.png");
INSERT INTO BXzlkOCF_postmeta VALUES("12","7","_wp_attachment_metadata","a:6:{s:5:\"width\";i:792;s:6:\"height\";i:874;s:4:\"file\";s:21:\"2020/01/blog-bg-1.png\";s:8:\"filesize\";i:97657;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"blog-bg-1-272x300.png\";s:5:\"width\";i:272;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:98961;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"blog-bg-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35675;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:21:\"blog-bg-1-768x848.png\";s:5:\"width\";i:768;s:6:\"height\";i:848;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:461676;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:21:\"blog-bg-1-500x500.png\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:244749;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("13","7","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:938718;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:5:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:98961;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:35675;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:461676;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:244749;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:97657;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572613;}");
INSERT INTO BXzlkOCF_postmeta VALUES("14","7","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:792;s:6:\"height\";i:874;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("15","7","wpvivid_backup_image_meta","a:5:{i:0;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-bg-1-272x300.png\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-bg-1-272x300.png\";}i:1;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-bg-1-150x150.png\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-bg-1-150x150.png\";}i:2;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-bg-1-768x848.png\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-bg-1-768x848.png\";}i:3;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-bg-1-500x500.png\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-bg-1-500x500.png\";}i:4;a:2:{s:7:\"og_path\";s:67:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-bg-1.png\";s:11:\"backup_path\";s:100:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-bg-1.png\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("16","7","tiny_compress_images","a:5:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:105138;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:97657;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:792;s:6:\"height\";i:874;s:5:\"ratio\";d:0.9288;}s:3:\"end\";i:1580730516;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:98610;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:32411;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:272;s:6:\"height\";i:300;s:5:\"ratio\";d:0.3287;}s:3:\"end\";i:1580730520;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:34346;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:12956;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.3772;}s:3:\"end\";i:1580730518;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:458037;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:144509;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:768;s:6:\"height\";i:848;s:5:\"ratio\";d:0.3155;}s:3:\"end\";i:1580730523;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:247069;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:77535;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.3138;}s:3:\"end\";i:1580730526;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("17","7","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:2.81;s:5:\"bytes\";i:626023;s:7:\"percent\";d:74.43;s:11:\"size_before\";i:841061;s:10:\"size_after\";i:215038;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:4:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.12;s:5:\"bytes\";i:28076;s:7:\"percent\";d:78.7;s:11:\"size_before\";i:35675;s:10:\"size_after\";i:7599;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.12;s:5:\"bytes\";i:76360;s:7:\"percent\";d:77.16;s:11:\"size_before\";i:98961;s:10:\"size_after\";i:22601;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.36;s:5:\"bytes\";i:182900;s:7:\"percent\";d:74.73;s:11:\"size_before\";i:244749;s:10:\"size_after\";i:61849;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:2.21;s:5:\"bytes\";i:338687;s:7:\"percent\";d:73.36;s:11:\"size_before\";i:461676;s:10:\"size_after\";i:122989;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("18","7","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("19","8","_wp_attached_file","2020/01/blog-bg.png");
INSERT INTO BXzlkOCF_postmeta VALUES("20","8","_wp_attachment_metadata","a:6:{s:5:\"width\";i:792;s:6:\"height\";i:874;s:4:\"file\";s:19:\"2020/01/blog-bg.png\";s:8:\"filesize\";i:97657;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"blog-bg-272x300.png\";s:5:\"width\";i:272;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:98961;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"blog-bg-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35675;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"blog-bg-768x848.png\";s:5:\"width\";i:768;s:6:\"height\";i:848;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:461676;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:19:\"blog-bg-500x500.png\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:244749;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("21","8","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:938718;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:5:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:98961;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:35675;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:461676;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:244749;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:97657;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572402;}");
INSERT INTO BXzlkOCF_postmeta VALUES("22","8","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:792;s:6:\"height\";i:874;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("23","8","wpvivid_backup_image_meta","a:5:{i:0;a:2:{s:7:\"og_path\";s:73:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-bg-272x300.png\";s:11:\"backup_path\";s:106:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-bg-272x300.png\";}i:1;a:2:{s:7:\"og_path\";s:73:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-bg-150x150.png\";s:11:\"backup_path\";s:106:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-bg-150x150.png\";}i:2;a:2:{s:7:\"og_path\";s:73:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-bg-768x848.png\";s:11:\"backup_path\";s:106:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-bg-768x848.png\";}i:3;a:2:{s:7:\"og_path\";s:73:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-bg-500x500.png\";s:11:\"backup_path\";s:106:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-bg-500x500.png\";}i:4;a:2:{s:7:\"og_path\";s:65:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-bg.png\";s:11:\"backup_path\";s:98:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-bg.png\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("24","8","tiny_compress_images","a:5:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:105138;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:97657;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:792;s:6:\"height\";i:874;s:5:\"ratio\";d:0.9288;}s:3:\"end\";i:1580730516;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:98610;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:32411;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:272;s:6:\"height\";i:300;s:5:\"ratio\";d:0.3287;}s:3:\"end\";i:1580730520;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:34346;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:12956;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.3772;}s:3:\"end\";i:1580730518;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:458037;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:144509;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:768;s:6:\"height\";i:848;s:5:\"ratio\";d:0.3155;}s:3:\"end\";i:1580730523;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:247069;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:77535;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.3138;}s:3:\"end\";i:1580730526;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("25","8","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:2.4699999999999998;s:5:\"bytes\";i:626023;s:7:\"percent\";d:74.43;s:11:\"size_before\";i:841061;s:10:\"size_after\";i:215038;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:4:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.07;s:5:\"bytes\";i:28076;s:7:\"percent\";d:78.7;s:11:\"size_before\";i:35675;s:10:\"size_after\";i:7599;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.4;s:5:\"bytes\";i:76360;s:7:\"percent\";d:77.16;s:11:\"size_before\";i:98961;s:10:\"size_after\";i:22601;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.87;s:5:\"bytes\";i:338687;s:7:\"percent\";d:73.36;s:11:\"size_before\";i:461676;s:10:\"size_after\";i:122989;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:1.13;s:5:\"bytes\";i:182900;s:7:\"percent\";d:74.73;s:11:\"size_before\";i:244749;s:10:\"size_after\";i:61849;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("26","8","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("27","9","_wp_attached_file","2020/01/footer-bg-1.png");
INSERT INTO BXzlkOCF_postmeta VALUES("28","9","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:377;s:4:\"file\";s:23:\"2020/01/footer-bg-1.png\";s:8:\"filesize\";i:63597;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"footer-bg-1-300x59.png\";s:5:\"width\";i:300;s:6:\"height\";i:59;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14890;}s:5:\"large\";a:5:{s:4:\"file\";s:24:\"footer-bg-1-1024x201.png\";s:5:\"width\";i:1024;s:6:\"height\";i:201;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:112637;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:23:\"footer-bg-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14222;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:23:\"footer-bg-1-768x151.png\";s:5:\"width\";i:768;s:6:\"height\";i:151;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:71283;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:24:\"footer-bg-1-1536x302.png\";s:5:\"width\";i:1536;s:6:\"height\";i:302;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:199307;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:23:\"footer-bg-1-500x377.png\";s:5:\"width\";i:500;s:6:\"height\";i:377;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:32933;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("29","9","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:508869;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:7:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:14890;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:112637;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:14222;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:71283;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"1536x1536\";a:3:{s:7:\"og_size\";i:199307;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:32933;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:63597;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572615;}");
INSERT INTO BXzlkOCF_postmeta VALUES("30","9","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1920;s:6:\"height\";i:377;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("31","9","wpvivid_backup_image_meta","a:7:{i:0;a:2:{s:7:\"og_path\";s:76:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg-1-300x59.png\";s:11:\"backup_path\";s:109:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg-1-300x59.png\";}i:1;a:2:{s:7:\"og_path\";s:78:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg-1-1024x201.png\";s:11:\"backup_path\";s:111:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg-1-1024x201.png\";}i:2;a:2:{s:7:\"og_path\";s:77:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg-1-150x150.png\";s:11:\"backup_path\";s:110:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg-1-150x150.png\";}i:3;a:2:{s:7:\"og_path\";s:77:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg-1-768x151.png\";s:11:\"backup_path\";s:110:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg-1-768x151.png\";}i:4;a:2:{s:7:\"og_path\";s:78:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg-1-1536x302.png\";s:11:\"backup_path\";s:111:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg-1-1536x302.png\";}i:5;a:2:{s:7:\"og_path\";s:77:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg-1-500x377.png\";s:11:\"backup_path\";s:110:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg-1-500x377.png\";}i:6;a:2:{s:7:\"og_path\";s:69:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg-1.png\";s:11:\"backup_path\";s:102:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg-1.png\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("32","9","tiny_compress_images","a:7:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:66724;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:63597;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1920;s:6:\"height\";i:377;s:5:\"ratio\";d:0.9531;}s:3:\"end\";i:1580730511;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:14407;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:7858;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:300;s:6:\"height\";i:59;s:5:\"ratio\";d:0.5454;}s:3:\"end\";i:1580730514;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:99602;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:53185;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1024;s:6:\"height\";i:201;s:5:\"ratio\";d:0.534;}s:3:\"end\";i:1580730517;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:13077;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:7089;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.5421;}s:3:\"end\";i:1580730513;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:65377;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:33685;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:768;s:6:\"height\";i:151;s:5:\"ratio\";d:0.5152;}s:3:\"end\";i:1580730515;}s:9:\"1536x1536\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:170984;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:94220;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1536;s:6:\"height\";i:302;s:5:\"ratio\";d:0.551;}s:3:\"end\";i:1580730520;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:26256;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:15835;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:500;s:6:\"height\";i:377;s:5:\"ratio\";d:0.6031;}s:3:\"end\";i:1580730548;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("33","9","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:1.2399999999999998;s:5:\"bytes\";i:278979;s:7:\"percent\";d:62.65;s:11:\"size_before\";i:445272;s:10:\"size_after\";i:166293;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:6:{s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.02;s:5:\"bytes\";i:9038;s:7:\"percent\";d:60.7;s:11:\"size_before\";i:14890;s:10:\"size_after\";i:5852;}s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.04;s:5:\"bytes\";i:9033;s:7:\"percent\";d:63.51;s:11:\"size_before\";i:14222;s:10:\"size_after\";i:5189;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.37;s:5:\"bytes\";i:18453;s:7:\"percent\";d:56.03;s:11:\"size_before\";i:32933;s:10:\"size_after\";i:14480;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.24;s:5:\"bytes\";i:45627;s:7:\"percent\";d:64.01;s:11:\"size_before\";i:71283;s:10:\"size_after\";i:25656;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.18;s:5:\"bytes\";i:72190;s:7:\"percent\";d:64.09;s:11:\"size_before\";i:112637;s:10:\"size_after\";i:40447;}s:9:\"1536x1536\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.39;s:5:\"bytes\";i:124638;s:7:\"percent\";d:62.54;s:11:\"size_before\";i:199307;s:10:\"size_after\";i:74669;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("34","9","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("35","10","_wp_attached_file","2020/01/footer-bg.png");
INSERT INTO BXzlkOCF_postmeta VALUES("36","10","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:377;s:4:\"file\";s:21:\"2020/01/footer-bg.png\";s:8:\"filesize\";i:63597;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"footer-bg-300x59.png\";s:5:\"width\";i:300;s:6:\"height\";i:59;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14890;}s:5:\"large\";a:5:{s:4:\"file\";s:22:\"footer-bg-1024x201.png\";s:5:\"width\";i:1024;s:6:\"height\";i:201;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:112637;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"footer-bg-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14222;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:21:\"footer-bg-768x151.png\";s:5:\"width\";i:768;s:6:\"height\";i:151;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:71283;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:22:\"footer-bg-1536x302.png\";s:5:\"width\";i:1536;s:6:\"height\";i:302;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:199307;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:21:\"footer-bg-500x377.png\";s:5:\"width\";i:500;s:6:\"height\";i:377;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:32933;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("37","10","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:508869;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:7:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:14890;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:112637;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:14222;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:71283;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"1536x1536\";a:3:{s:7:\"og_size\";i:199307;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:32933;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:63597;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572405;}");
INSERT INTO BXzlkOCF_postmeta VALUES("38","10","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1920;s:6:\"height\";i:377;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("39","10","wpvivid_backup_image_meta","a:7:{i:0;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg-300x59.png\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg-300x59.png\";}i:1;a:2:{s:7:\"og_path\";s:76:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg-1024x201.png\";s:11:\"backup_path\";s:109:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg-1024x201.png\";}i:2;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg-150x150.png\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg-150x150.png\";}i:3;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg-768x151.png\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg-768x151.png\";}i:4;a:2:{s:7:\"og_path\";s:76:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg-1536x302.png\";s:11:\"backup_path\";s:109:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg-1536x302.png\";}i:5;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg-500x377.png\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg-500x377.png\";}i:6;a:2:{s:7:\"og_path\";s:67:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/footer-bg.png\";s:11:\"backup_path\";s:100:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/footer-bg.png\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("40","10","tiny_compress_images","a:7:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:66724;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:63597;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1920;s:6:\"height\";i:377;s:5:\"ratio\";d:0.9531;}s:3:\"end\";i:1580730511;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:14407;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:7858;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:300;s:6:\"height\";i:59;s:5:\"ratio\";d:0.5454;}s:3:\"end\";i:1580730514;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:99602;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:53185;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1024;s:6:\"height\";i:201;s:5:\"ratio\";d:0.534;}s:3:\"end\";i:1580730517;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:13077;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:7089;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.5421;}s:3:\"end\";i:1580730513;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:65377;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:33685;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:768;s:6:\"height\";i:151;s:5:\"ratio\";d:0.5152;}s:3:\"end\";i:1580730515;}s:9:\"1536x1536\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:170984;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:94220;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1536;s:6:\"height\";i:302;s:5:\"ratio\";d:0.551;}s:3:\"end\";i:1580730520;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:26256;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:15835;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:500;s:6:\"height\";i:377;s:5:\"ratio\";d:0.6031;}s:3:\"end\";i:1580730548;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("41","10","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:1.77;s:5:\"bytes\";i:278979;s:7:\"percent\";d:62.65;s:11:\"size_before\";i:445272;s:10:\"size_after\";i:166293;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.04;s:5:\"bytes\";i:9033;s:7:\"percent\";d:63.51;s:11:\"size_before\";i:14222;s:10:\"size_after\";i:5189;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.09;s:5:\"bytes\";i:9038;s:7:\"percent\";d:60.7;s:11:\"size_before\";i:14890;s:10:\"size_after\";i:5852;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.46;s:5:\"bytes\";i:18453;s:7:\"percent\";d:56.03;s:11:\"size_before\";i:32933;s:10:\"size_after\";i:14480;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.27;s:5:\"bytes\";i:45627;s:7:\"percent\";d:64.01;s:11:\"size_before\";i:71283;s:10:\"size_after\";i:25656;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.32;s:5:\"bytes\";i:72190;s:7:\"percent\";d:64.09;s:11:\"size_before\";i:112637;s:10:\"size_after\";i:40447;}s:9:\"1536x1536\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.59;s:5:\"bytes\";i:124638;s:7:\"percent\";d:62.54;s:11:\"size_before\";i:199307;s:10:\"size_after\";i:74669;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("42","10","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("43","11","_wp_attached_file","2020/01/hero-img-1.png");
INSERT INTO BXzlkOCF_postmeta VALUES("44","11","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:22:\"2020/01/hero-img-1.png\";s:8:\"filesize\";i:126757;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"hero-img-1-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:30353;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"hero-img-1-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:221094;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"hero-img-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13941;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"hero-img-1-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:142166;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:23:\"hero-img-1-1536x864.png\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:444394;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:22:\"hero-img-1-500x500.png\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:97640;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("45","11","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:2.23;s:5:\"bytes\";i:733467;s:7:\"percent\";d:77.24;s:11:\"size_before\";i:949588;s:10:\"size_after\";i:216121;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.03;s:5:\"bytes\";i:10984;s:7:\"percent\";d:78.79;s:11:\"size_before\";i:13941;s:10:\"size_after\";i:2957;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.2;s:5:\"bytes\";i:23325;s:7:\"percent\";d:76.85;s:11:\"size_before\";i:30353;s:10:\"size_after\";i:7028;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.22;s:5:\"bytes\";i:76344;s:7:\"percent\";d:78.19;s:11:\"size_before\";i:97640;s:10:\"size_after\";i:21296;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.28;s:5:\"bytes\";i:111004;s:7:\"percent\";d:78.08;s:11:\"size_before\";i:142166;s:10:\"size_after\";i:31162;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.5;s:5:\"bytes\";i:167975;s:7:\"percent\";d:75.97;s:11:\"size_before\";i:221094;s:10:\"size_after\";i:53119;}s:9:\"1536x1536\";O:8:\"stdClass\":5:{s:4:\"time\";d:1;s:5:\"bytes\";i:343835;s:7:\"percent\";d:77.37;s:11:\"size_before\";i:444394;s:10:\"size_after\";i:100559;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("46","11","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("47","11","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:342878;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:7:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:7028;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:53119;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:2957;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:31162;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"1536x1536\";a:3:{s:7:\"og_size\";i:100559;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:21296;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:126757;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572625;}");
INSERT INTO BXzlkOCF_postmeta VALUES("48","11","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("49","11","wpvivid_backup_image_meta","a:7:{i:0;a:2:{s:7:\"og_path\";s:76:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img-1-300x169.png\";s:11:\"backup_path\";s:109:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img-1-300x169.png\";}i:1;a:2:{s:7:\"og_path\";s:77:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img-1-1024x576.png\";s:11:\"backup_path\";s:110:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img-1-1024x576.png\";}i:2;a:2:{s:7:\"og_path\";s:76:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img-1-150x150.png\";s:11:\"backup_path\";s:109:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img-1-150x150.png\";}i:3;a:2:{s:7:\"og_path\";s:76:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img-1-768x432.png\";s:11:\"backup_path\";s:109:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img-1-768x432.png\";}i:4;a:2:{s:7:\"og_path\";s:77:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img-1-1536x864.png\";s:11:\"backup_path\";s:110:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img-1-1536x864.png\";}i:5;a:2:{s:7:\"og_path\";s:76:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img-1-500x500.png\";s:11:\"backup_path\";s:109:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img-1-500x500.png\";}i:6;a:2:{s:7:\"og_path\";s:68:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img-1.png\";s:11:\"backup_path\";s:101:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img-1.png\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("50","11","tiny_compress_images","a:7:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:129863;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:126757;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:5:\"ratio\";d:0.9761;}s:3:\"end\";i:1580730508;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:28567;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:11741;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:5:\"ratio\";d:0.411;}s:3:\"end\";i:1580730511;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:210765;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:74904;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:5:\"ratio\";d:0.3554;}s:3:\"end\";i:1580730523;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:12476;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:5825;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.4669;}s:3:\"end\";i:1580730509;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:134993;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:47573;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:5:\"ratio\";d:0.3524;}s:3:\"end\";i:1580730521;}s:9:\"1536x1536\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:398941;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:142517;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:5:\"ratio\";d:0.3572;}s:3:\"end\";i:1580730526;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:93861;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:33747;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.3595;}s:3:\"end\";i:1580730528;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("51","12","_wp_attached_file","2020/01/hero-img.png");
INSERT INTO BXzlkOCF_postmeta VALUES("52","12","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:4:\"file\";s:20:\"2020/01/hero-img.png\";s:8:\"filesize\";i:126757;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"hero-img-300x169.png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:30353;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"hero-img-1024x576.png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:221094;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"hero-img-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13941;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"hero-img-768x432.png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:142166;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:21:\"hero-img-1536x864.png\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:444394;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:20:\"hero-img-500x500.png\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:97640;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("53","12","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:1076345;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:7:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:30353;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:221094;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:13941;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:142166;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"1536x1536\";a:3:{s:7:\"og_size\";i:444394;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:97640;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:126757;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572409;}");
INSERT INTO BXzlkOCF_postmeta VALUES("54","12","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1920;s:6:\"height\";i:1080;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("55","12","wpvivid_backup_image_meta","a:7:{i:0;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img-300x169.png\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img-300x169.png\";}i:1;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img-1024x576.png\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img-1024x576.png\";}i:2;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img-150x150.png\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img-150x150.png\";}i:3;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img-768x432.png\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img-768x432.png\";}i:4;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img-1536x864.png\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img-1536x864.png\";}i:5;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img-500x500.png\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img-500x500.png\";}i:6;a:2:{s:7:\"og_path\";s:66:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/hero-img.png\";s:11:\"backup_path\";s:99:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/hero-img.png\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("56","12","tiny_compress_images","a:7:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:129863;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:126757;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1920;s:6:\"height\";i:1080;s:5:\"ratio\";d:0.9761;}s:3:\"end\";i:1580730508;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:28567;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:11741;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:5:\"ratio\";d:0.411;}s:3:\"end\";i:1580730511;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:210765;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:74904;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:5:\"ratio\";d:0.3554;}s:3:\"end\";i:1580730523;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:12476;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:5825;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.4669;}s:3:\"end\";i:1580730509;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:134993;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:47573;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:5:\"ratio\";d:0.3524;}s:3:\"end\";i:1580730521;}s:9:\"1536x1536\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:398941;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:142517;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1536;s:6:\"height\";i:864;s:5:\"ratio\";d:0.3572;}s:3:\"end\";i:1580730526;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:93861;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:33747;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.3595;}s:3:\"end\";i:1580730528;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("57","12","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:3.25;s:5:\"bytes\";i:733467;s:7:\"percent\";d:77.24;s:11:\"size_before\";i:949588;s:10:\"size_after\";i:216121;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.03;s:5:\"bytes\";i:10984;s:7:\"percent\";d:78.79;s:11:\"size_before\";i:13941;s:10:\"size_after\";i:2957;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.06;s:5:\"bytes\";i:23325;s:7:\"percent\";d:76.85;s:11:\"size_before\";i:30353;s:10:\"size_after\";i:7028;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.28;s:5:\"bytes\";i:76344;s:7:\"percent\";d:78.19;s:11:\"size_before\";i:97640;s:10:\"size_after\";i:21296;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.39;s:5:\"bytes\";i:111004;s:7:\"percent\";d:78.08;s:11:\"size_before\";i:142166;s:10:\"size_after\";i:31162;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:1.32;s:5:\"bytes\";i:167975;s:7:\"percent\";d:75.97;s:11:\"size_before\";i:221094;s:10:\"size_after\";i:53119;}s:9:\"1536x1536\";O:8:\"stdClass\":5:{s:4:\"time\";d:1.17;s:5:\"bytes\";i:343835;s:7:\"percent\";d:77.37;s:11:\"size_before\";i:444394;s:10:\"size_after\";i:100559;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("58","12","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("59","13","_wp_attached_file","2020/01/solution-bg-1.png");
INSERT INTO BXzlkOCF_postmeta VALUES("60","13","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:492;s:4:\"file\";s:25:\"2020/01/solution-bg-1.png\";s:8:\"filesize\";i:79085;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"solution-bg-1-300x77.png\";s:5:\"width\";i:300;s:6:\"height\";i:77;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:24573;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"solution-bg-1-1024x262.png\";s:5:\"width\";i:1024;s:6:\"height\";i:262;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:190691;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"solution-bg-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13390;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"solution-bg-1-768x197.png\";s:5:\"width\";i:768;s:6:\"height\";i:197;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:121154;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:26:\"solution-bg-1-1536x394.png\";s:5:\"width\";i:1536;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:328670;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:25:\"solution-bg-1-500x492.png\";s:5:\"width\";i:500;s:6:\"height\";i:492;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:62269;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("61","13","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:819832;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:7:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:24573;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:190691;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:13390;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:121154;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"1536x1536\";a:3:{s:7:\"og_size\";i:328670;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:62269;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:79085;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572627;}");
INSERT INTO BXzlkOCF_postmeta VALUES("62","13","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1920;s:6:\"height\";i:492;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("63","13","wpvivid_backup_image_meta","a:7:{i:0;a:2:{s:7:\"og_path\";s:78:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg-1-300x77.png\";s:11:\"backup_path\";s:111:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg-1-300x77.png\";}i:1;a:2:{s:7:\"og_path\";s:80:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg-1-1024x262.png\";s:11:\"backup_path\";s:113:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg-1-1024x262.png\";}i:2;a:2:{s:7:\"og_path\";s:79:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg-1-150x150.png\";s:11:\"backup_path\";s:112:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg-1-150x150.png\";}i:3;a:2:{s:7:\"og_path\";s:79:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg-1-768x197.png\";s:11:\"backup_path\";s:112:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg-1-768x197.png\";}i:4;a:2:{s:7:\"og_path\";s:80:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg-1-1536x394.png\";s:11:\"backup_path\";s:113:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg-1-1536x394.png\";}i:5;a:2:{s:7:\"og_path\";s:79:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg-1-500x492.png\";s:11:\"backup_path\";s:112:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg-1-500x492.png\";}i:6;a:2:{s:7:\"og_path\";s:71:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg-1.png\";s:11:\"backup_path\";s:104:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg-1.png\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("64","13","tiny_compress_images","a:7:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:80837;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:79085;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1920;s:6:\"height\";i:492;s:5:\"ratio\";d:0.9783;}s:3:\"end\";i:1580730506;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:23539;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:9538;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:300;s:6:\"height\";i:77;s:5:\"ratio\";d:0.4052;}s:3:\"end\";i:1580730509;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:196506;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:54703;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1024;s:6:\"height\";i:262;s:5:\"ratio\";d:0.2784;}s:3:\"end\";i:1580730513;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:13573;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:5442;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.4009;}s:3:\"end\";i:1580730507;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:120016;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:37105;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:768;s:6:\"height\";i:197;s:5:\"ratio\";d:0.3092;}s:3:\"end\";i:1580730511;}s:9:\"1536x1536\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:339424;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:94255;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1536;s:6:\"height\";i:394;s:5:\"ratio\";d:0.2777;}s:3:\"end\";i:1580730516;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:61491;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:18893;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:500;s:6:\"height\";i:492;s:5:\"ratio\";d:0.3072;}s:3:\"end\";i:1580730517;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("65","13","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:2.3600000000000003;s:5:\"bytes\";i:560894;s:7:\"percent\";d:75.72;s:11:\"size_before\";i:740747;s:10:\"size_after\";i:179853;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.04;s:5:\"bytes\";i:9493;s:7:\"percent\";d:70.9;s:11:\"size_before\";i:13390;s:10:\"size_after\";i:3897;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.07;s:5:\"bytes\";i:18360;s:7:\"percent\";d:74.72;s:11:\"size_before\";i:24573;s:10:\"size_after\";i:6213;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.47;s:5:\"bytes\";i:45336;s:7:\"percent\";d:72.81;s:11:\"size_before\";i:62269;s:10:\"size_after\";i:16933;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.22;s:5:\"bytes\";i:92191;s:7:\"percent\";d:76.09;s:11:\"size_before\";i:121154;s:10:\"size_after\";i:28963;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.78;s:5:\"bytes\";i:146968;s:7:\"percent\";d:77.07;s:11:\"size_before\";i:190691;s:10:\"size_after\";i:43723;}s:9:\"1536x1536\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.78;s:5:\"bytes\";i:248546;s:7:\"percent\";d:75.62;s:11:\"size_before\";i:328670;s:10:\"size_after\";i:80124;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("66","13","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("67","14","_wp_attached_file","2020/01/solution-bg.png");
INSERT INTO BXzlkOCF_postmeta VALUES("68","14","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:492;s:4:\"file\";s:23:\"2020/01/solution-bg.png\";s:8:\"filesize\";i:79085;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"solution-bg-300x77.png\";s:5:\"width\";i:300;s:6:\"height\";i:77;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:24573;}s:5:\"large\";a:5:{s:4:\"file\";s:24:\"solution-bg-1024x262.png\";s:5:\"width\";i:1024;s:6:\"height\";i:262;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:190691;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:23:\"solution-bg-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13390;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:23:\"solution-bg-768x197.png\";s:5:\"width\";i:768;s:6:\"height\";i:197;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:121154;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:24:\"solution-bg-1536x394.png\";s:5:\"width\";i:1536;s:6:\"height\";i:394;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:328670;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:23:\"solution-bg-500x492.png\";s:5:\"width\";i:500;s:6:\"height\";i:492;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:62269;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("69","14","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:819832;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:7:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:24573;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:190691;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:13390;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:121154;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"1536x1536\";a:3:{s:7:\"og_size\";i:328670;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:62269;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:79085;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572411;}");
INSERT INTO BXzlkOCF_postmeta VALUES("70","14","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1920;s:6:\"height\";i:492;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("71","14","wpvivid_backup_image_meta","a:7:{i:0;a:2:{s:7:\"og_path\";s:76:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg-300x77.png\";s:11:\"backup_path\";s:109:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg-300x77.png\";}i:1;a:2:{s:7:\"og_path\";s:78:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg-1024x262.png\";s:11:\"backup_path\";s:111:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg-1024x262.png\";}i:2;a:2:{s:7:\"og_path\";s:77:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg-150x150.png\";s:11:\"backup_path\";s:110:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg-150x150.png\";}i:3;a:2:{s:7:\"og_path\";s:77:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg-768x197.png\";s:11:\"backup_path\";s:110:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg-768x197.png\";}i:4;a:2:{s:7:\"og_path\";s:78:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg-1536x394.png\";s:11:\"backup_path\";s:111:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg-1536x394.png\";}i:5;a:2:{s:7:\"og_path\";s:77:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg-500x492.png\";s:11:\"backup_path\";s:110:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg-500x492.png\";}i:6;a:2:{s:7:\"og_path\";s:69:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/solution-bg.png\";s:11:\"backup_path\";s:102:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/solution-bg.png\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("72","14","tiny_compress_images","a:7:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:80837;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:79085;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1920;s:6:\"height\";i:492;s:5:\"ratio\";d:0.9783;}s:3:\"end\";i:1580730506;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:23539;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:9538;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:300;s:6:\"height\";i:77;s:5:\"ratio\";d:0.4052;}s:3:\"end\";i:1580730509;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:196506;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:54703;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1024;s:6:\"height\";i:262;s:5:\"ratio\";d:0.2784;}s:3:\"end\";i:1580730513;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:13573;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:5442;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.4009;}s:3:\"end\";i:1580730507;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:120016;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:37105;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:768;s:6:\"height\";i:197;s:5:\"ratio\";d:0.3092;}s:3:\"end\";i:1580730511;}s:9:\"1536x1536\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:339424;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:94255;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:1536;s:6:\"height\";i:394;s:5:\"ratio\";d:0.2777;}s:3:\"end\";i:1580730516;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:61491;s:4:\"type\";s:9:\"image/png\";}s:6:\"output\";a:5:{s:4:\"size\";i:18893;s:4:\"type\";s:9:\"image/png\";s:5:\"width\";i:500;s:6:\"height\";i:492;s:5:\"ratio\";d:0.3072;}s:3:\"end\";i:1580730517;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("73","14","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:1.25;s:5:\"bytes\";i:560894;s:7:\"percent\";d:75.72;s:11:\"size_before\";i:740747;s:10:\"size_after\";i:179853;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:6:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.05;s:5:\"bytes\";i:9493;s:7:\"percent\";d:70.9;s:11:\"size_before\";i:13390;s:10:\"size_after\";i:3897;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.05;s:5:\"bytes\";i:18360;s:7:\"percent\";d:74.72;s:11:\"size_before\";i:24573;s:10:\"size_after\";i:6213;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.12;s:5:\"bytes\";i:45336;s:7:\"percent\";d:72.81;s:11:\"size_before\";i:62269;s:10:\"size_after\";i:16933;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.16;s:5:\"bytes\";i:92191;s:7:\"percent\";d:76.09;s:11:\"size_before\";i:121154;s:10:\"size_after\";i:28963;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.29;s:5:\"bytes\";i:146968;s:7:\"percent\";d:77.07;s:11:\"size_before\";i:190691;s:10:\"size_after\";i:43723;}s:9:\"1536x1536\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.58;s:5:\"bytes\";i:248546;s:7:\"percent\";d:75.62;s:11:\"size_before\";i:328670;s:10:\"size_after\";i:80124;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("74","14","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("75","15","_wp_attached_file","2020/01/blog-1-1.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("76","15","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:760;s:4:\"file\";s:20:\"2020/01/blog-1-1.jpg\";s:8:\"filesize\";i:27906;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"blog-1-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4314;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"blog-1-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29557;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"blog-1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2503;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"blog-1-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18344;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:20:\"blog-1-1-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14230;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("77","15","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.65;s:5:\"bytes\";i:7016;s:7:\"percent\";d:10.18;s:11:\"size_before\";i:68948;s:10:\"size_after\";i:61932;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.03;s:5:\"bytes\";i:166;s:7:\"percent\";d:6.63;s:11:\"size_before\";i:2503;s:10:\"size_after\";i:2337;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.11;s:5:\"bytes\";i:276;s:7:\"percent\";d:6.4;s:11:\"size_before\";i:4314;s:10:\"size_after\";i:4038;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.07;s:5:\"bytes\";i:1174;s:7:\"percent\";d:8.25;s:11:\"size_before\";i:14230;s:10:\"size_after\";i:13056;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.27;s:5:\"bytes\";i:1842;s:7:\"percent\";d:10.04;s:11:\"size_before\";i:18344;s:10:\"size_after\";i:16502;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.17;s:5:\"bytes\";i:3558;s:7:\"percent\";d:12.04;s:11:\"size_before\";i:29557;s:10:\"size_after\";i:25999;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("78","15","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("79","15","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:89838;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:4038;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:25999;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:2337;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:16502;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:13056;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:27906;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572631;}");
INSERT INTO BXzlkOCF_postmeta VALUES("80","15","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:760;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("81","15","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-1-1-300x200.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-1-1-300x200.jpg\";}i:1;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-1-1-1024x683.jpg\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-1-1-1024x683.jpg\";}i:2;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-1-1-150x150.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-1-1-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-1-1-768x512.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-1-1-768x512.jpg\";}i:4;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-1-1-500x500.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-1-1-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:66:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-1-1.jpg\";s:11:\"backup_path\";s:99:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-1-1.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("82","15","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:31721;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:27914;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:760;s:5:\"ratio\";d:0.88;}s:3:\"end\";i:1580730504;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:4849;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:4506;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:5:\"ratio\";d:0.9293;}s:3:\"end\";i:1580730507;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:34327;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:24684;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:5:\"ratio\";d:0.7191;}s:3:\"end\";i:1580730513;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:2593;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:2447;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.9437;}s:3:\"end\";i:1580730506;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:21318;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:14349;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:5:\"ratio\";d:0.6731;}s:3:\"end\";i:1580730509;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:16489;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:9933;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.6024;}s:3:\"end\";i:1580730514;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("83","16","_wp_attached_file","2020/01/blog-1.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("84","16","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:760;s:4:\"file\";s:18:\"2020/01/blog-1.jpg\";s:8:\"filesize\";i:27914;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"blog-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4314;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"blog-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29557;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"blog-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2503;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"blog-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18344;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:18:\"blog-1-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14230;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("85","16","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.32999999999999996;s:5:\"bytes\";i:7016;s:7:\"percent\";d:10.18;s:11:\"size_before\";i:68948;s:10:\"size_after\";i:61932;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.01;s:5:\"bytes\";i:166;s:7:\"percent\";d:6.63;s:11:\"size_before\";i:2503;s:10:\"size_after\";i:2337;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.02;s:5:\"bytes\";i:276;s:7:\"percent\";d:6.4;s:11:\"size_before\";i:4314;s:10:\"size_after\";i:4038;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.05;s:5:\"bytes\";i:1174;s:7:\"percent\";d:8.25;s:11:\"size_before\";i:14230;s:10:\"size_after\";i:13056;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.15;s:5:\"bytes\";i:1842;s:7:\"percent\";d:10.04;s:11:\"size_before\";i:18344;s:10:\"size_after\";i:16502;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.1;s:5:\"bytes\";i:3558;s:7:\"percent\";d:12.04;s:11:\"size_before\";i:29557;s:10:\"size_after\";i:25999;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("86","16","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("87","16","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:89846;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:4038;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:25999;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:2337;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:16502;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:13056;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:27914;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572416;}");
INSERT INTO BXzlkOCF_postmeta VALUES("88","16","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:760;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("89","16","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-1-300x200.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-1-300x200.jpg\";}i:1;a:2:{s:7:\"og_path\";s:73:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-1-1024x683.jpg\";s:11:\"backup_path\";s:106:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-1-1024x683.jpg\";}i:2;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-1-150x150.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-1-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-1-768x512.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-1-768x512.jpg\";}i:4;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-1-500x500.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-1-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:64:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-1.jpg\";s:11:\"backup_path\";s:97:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-1.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("90","16","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:31721;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:27914;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:760;s:5:\"ratio\";d:0.88;}s:3:\"end\";i:1580730504;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:4849;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:4506;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:5:\"ratio\";d:0.9293;}s:3:\"end\";i:1580730507;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:34327;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:24684;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:5:\"ratio\";d:0.7191;}s:3:\"end\";i:1580730513;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:2593;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:2447;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.9437;}s:3:\"end\";i:1580730506;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:21318;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:14349;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:5:\"ratio\";d:0.6731;}s:3:\"end\";i:1580730509;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:16489;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:9933;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.6024;}s:3:\"end\";i:1580730514;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("91","17","_wp_attached_file","2020/01/blog-2-1.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("92","17","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:912;s:4:\"file\";s:20:\"2020/01/blog-2-1.jpg\";s:8:\"filesize\";i:40261;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"blog-2-1-300x240.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6673;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"blog-2-1-1024x819.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:819;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46102;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"blog-2-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3118;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"blog-2-1-768x614.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:614;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29523;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:20:\"blog-2-1-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19014;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("93","17","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:144691;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:6673;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:46102;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:3118;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:29523;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:19014;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:40261;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572633;}");
INSERT INTO BXzlkOCF_postmeta VALUES("94","17","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:912;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("95","17","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-2-1-300x240.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-2-1-300x240.jpg\";}i:1;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-2-1-1024x819.jpg\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-2-1-1024x819.jpg\";}i:2;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-2-1-150x150.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-2-1-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-2-1-768x614.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-2-1-768x614.jpg\";}i:4;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-2-1-500x500.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-2-1-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:66:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-2-1.jpg\";s:11:\"backup_path\";s:99:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-2-1.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("96","17","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:43003;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:40269;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:912;s:5:\"ratio\";d:0.9364;}s:3:\"end\";i:1580730494;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:7026;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:5945;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:5:\"ratio\";d:0.8461;}s:3:\"end\";i:1580730497;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:50642;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:33292;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:819;s:5:\"ratio\";d:0.6574;}s:3:\"end\";i:1580730502;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:3047;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:2841;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.9324;}s:3:\"end\";i:1580730495;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:32127;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:20127;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:614;s:5:\"ratio\";d:0.6265;}s:3:\"end\";i:1580730499;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:20713;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:13140;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.6344;}s:3:\"end\";i:1580730504;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("97","17","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.24000000000000002;s:5:\"bytes\";i:9591;s:7:\"percent\";d:9.18;s:11:\"size_before\";i:104430;s:10:\"size_after\";i:94839;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.01;s:5:\"bytes\";i:202;s:7:\"percent\";d:6.48;s:11:\"size_before\";i:3118;s:10:\"size_after\";i:2916;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.02;s:5:\"bytes\";i:474;s:7:\"percent\";d:7.1;s:11:\"size_before\";i:6673;s:10:\"size_after\";i:6199;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.05;s:5:\"bytes\";i:1519;s:7:\"percent\";d:7.99;s:11:\"size_before\";i:19014;s:10:\"size_after\";i:17495;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.06;s:5:\"bytes\";i:2607;s:7:\"percent\";d:8.83;s:11:\"size_before\";i:29523;s:10:\"size_after\";i:26916;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.1;s:5:\"bytes\";i:4789;s:7:\"percent\";d:10.39;s:11:\"size_before\";i:46102;s:10:\"size_after\";i:41313;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("98","17","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("99","18","_wp_attached_file","2020/01/blog-2.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("100","18","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:912;s:4:\"file\";s:18:\"2020/01/blog-2.jpg\";s:8:\"filesize\";i:40269;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"blog-2-300x240.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6673;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"blog-2-1024x819.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:819;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46102;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"blog-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3118;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"blog-2-768x614.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:614;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29523;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:18:\"blog-2-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19014;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("101","18","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:144699;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:6673;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:46102;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:3118;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:29523;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:19014;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:40269;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572418;}");
INSERT INTO BXzlkOCF_postmeta VALUES("102","18","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:912;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("103","18","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-2-300x240.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-2-300x240.jpg\";}i:1;a:2:{s:7:\"og_path\";s:73:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-2-1024x819.jpg\";s:11:\"backup_path\";s:106:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-2-1024x819.jpg\";}i:2;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-2-150x150.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-2-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-2-768x614.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-2-768x614.jpg\";}i:4;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-2-500x500.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-2-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:64:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-2.jpg\";s:11:\"backup_path\";s:97:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-2.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("104","18","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:43003;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:40269;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:912;s:5:\"ratio\";d:0.9364;}s:3:\"end\";i:1580730494;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:7026;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:5945;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:240;s:5:\"ratio\";d:0.8461;}s:3:\"end\";i:1580730497;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:50642;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:33292;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:819;s:5:\"ratio\";d:0.6574;}s:3:\"end\";i:1580730502;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:3047;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:2841;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.9324;}s:3:\"end\";i:1580730495;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:32127;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:20127;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:614;s:5:\"ratio\";d:0.6265;}s:3:\"end\";i:1580730499;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:20713;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:13140;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.6344;}s:3:\"end\";i:1580730504;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("105","18","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.21;s:5:\"bytes\";i:9591;s:7:\"percent\";d:9.18;s:11:\"size_before\";i:104430;s:10:\"size_after\";i:94839;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.01;s:5:\"bytes\";i:202;s:7:\"percent\";d:6.48;s:11:\"size_before\";i:3118;s:10:\"size_after\";i:2916;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.01;s:5:\"bytes\";i:474;s:7:\"percent\";d:7.1;s:11:\"size_before\";i:6673;s:10:\"size_after\";i:6199;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.06;s:5:\"bytes\";i:2607;s:7:\"percent\";d:8.83;s:11:\"size_before\";i:29523;s:10:\"size_after\";i:26916;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.1;s:5:\"bytes\";i:4789;s:7:\"percent\";d:10.39;s:11:\"size_before\";i:46102;s:10:\"size_after\";i:41313;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.03;s:5:\"bytes\";i:1519;s:7:\"percent\";d:7.99;s:11:\"size_before\";i:19014;s:10:\"size_after\";i:17495;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("106","18","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("107","19","_wp_attached_file","2020/01/blog-3-1.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("108","19","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:760;s:4:\"file\";s:20:\"2020/01/blog-3-1.jpg\";s:8:\"filesize\";i:167673;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"blog-3-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16735;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"blog-3-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:155445;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"blog-3-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7893;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"blog-3-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:94611;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:20:\"blog-3-1-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:72930;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("109","19","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:515287;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:16735;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:155445;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:7893;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:94611;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:72930;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:167673;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572635;}");
INSERT INTO BXzlkOCF_postmeta VALUES("110","19","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:760;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("111","19","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-3-1-300x200.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-3-1-300x200.jpg\";}i:1;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-3-1-1024x683.jpg\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-3-1-1024x683.jpg\";}i:2;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-3-1-150x150.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-3-1-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-3-1-768x512.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-3-1-768x512.jpg\";}i:4;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-3-1-500x500.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-3-1-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:66:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-3-1.jpg\";s:11:\"backup_path\";s:99:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-3-1.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("112","19","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:171351;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:167681;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:760;s:5:\"ratio\";d:0.9786;}s:3:\"end\";i:1580730493;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:14670;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:14670;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730496;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:150296;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:134156;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:5:\"ratio\";d:0.8926;}s:3:\"end\";i:1580730503;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:6781;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:6781;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730495;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:88188;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:88188;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730499;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:67600;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:67600;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730506;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("113","19","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.31999999999999995;s:5:\"bytes\";i:23181;s:7:\"percent\";d:6.67;s:11:\"size_before\";i:347614;s:10:\"size_after\";i:324433;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.01;s:5:\"bytes\";i:581;s:7:\"percent\";d:7.36;s:11:\"size_before\";i:7893;s:10:\"size_after\";i:7312;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.04;s:5:\"bytes\";i:1141;s:7:\"percent\";d:6.82;s:11:\"size_before\";i:16735;s:10:\"size_after\";i:15594;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.12;s:5:\"bytes\";i:4992;s:7:\"percent\";d:6.84;s:11:\"size_before\";i:72930;s:10:\"size_after\";i:67938;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.06;s:5:\"bytes\";i:6310;s:7:\"percent\";d:6.67;s:11:\"size_before\";i:94611;s:10:\"size_after\";i:88301;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.09;s:5:\"bytes\";i:10157;s:7:\"percent\";d:6.53;s:11:\"size_before\";i:155445;s:10:\"size_after\";i:145288;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("114","19","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("115","20","_wp_attached_file","2020/01/blog-3.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("116","20","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:760;s:4:\"file\";s:18:\"2020/01/blog-3.jpg\";s:8:\"filesize\";i:167681;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"blog-3-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16735;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"blog-3-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:155445;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"blog-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7893;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"blog-3-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:94611;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:18:\"blog-3-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:72930;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("117","20","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:515295;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:16735;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:155445;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:7893;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:94611;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:72930;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:167681;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572421;}");
INSERT INTO BXzlkOCF_postmeta VALUES("118","20","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:760;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("119","20","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-3-300x200.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-3-300x200.jpg\";}i:1;a:2:{s:7:\"og_path\";s:73:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-3-1024x683.jpg\";s:11:\"backup_path\";s:106:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-3-1024x683.jpg\";}i:2;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-3-150x150.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-3-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-3-768x512.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-3-768x512.jpg\";}i:4;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-3-500x500.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-3-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:64:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-3.jpg\";s:11:\"backup_path\";s:97:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-3.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("120","20","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:171351;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:167681;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:760;s:5:\"ratio\";d:0.9786;}s:3:\"end\";i:1580730493;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:14670;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:14670;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730496;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:150296;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:134156;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:5:\"ratio\";d:0.8926;}s:3:\"end\";i:1580730503;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:6781;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:6781;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730495;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:88188;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:88188;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730499;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:67600;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:67600;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730506;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("121","20","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.23;s:5:\"bytes\";i:23181;s:7:\"percent\";d:6.67;s:11:\"size_before\";i:347614;s:10:\"size_after\";i:324433;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.01;s:5:\"bytes\";i:581;s:7:\"percent\";d:7.36;s:11:\"size_before\";i:7893;s:10:\"size_after\";i:7312;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.02;s:5:\"bytes\";i:1141;s:7:\"percent\";d:6.82;s:11:\"size_before\";i:16735;s:10:\"size_after\";i:15594;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.05;s:5:\"bytes\";i:4992;s:7:\"percent\";d:6.84;s:11:\"size_before\";i:72930;s:10:\"size_after\";i:67938;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.06;s:5:\"bytes\";i:6310;s:7:\"percent\";d:6.67;s:11:\"size_before\";i:94611;s:10:\"size_after\";i:88301;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.09;s:5:\"bytes\";i:10157;s:7:\"percent\";d:6.53;s:11:\"size_before\";i:155445;s:10:\"size_after\";i:145288;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("122","20","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("123","21","_wp_attached_file","2020/01/blog-4-1.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("124","21","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:760;s:4:\"file\";s:20:\"2020/01/blog-4-1.jpg\";s:8:\"filesize\";i:33079;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"blog-4-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5847;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"blog-4-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33371;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"blog-4-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3754;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"blog-4-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21910;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:20:\"blog-4-1-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18715;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("125","21","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:116676;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:5847;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:33371;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:3754;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:21910;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:18715;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:33079;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572637;}");
INSERT INTO BXzlkOCF_postmeta VALUES("126","21","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:760;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("127","21","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-4-1-300x200.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-4-1-300x200.jpg\";}i:1;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-4-1-1024x683.jpg\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-4-1-1024x683.jpg\";}i:2;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-4-1-150x150.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-4-1-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-4-1-768x512.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-4-1-768x512.jpg\";}i:4;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-4-1-500x500.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-4-1-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:66:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-4-1.jpg\";s:11:\"backup_path\";s:99:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-4-1.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("128","21","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:36224;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:33087;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:760;s:5:\"ratio\";d:0.9134;}s:3:\"end\";i:1580730493;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:6983;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:6163;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:5:\"ratio\";d:0.8826;}s:3:\"end\";i:1580730496;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:40696;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:28238;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:5:\"ratio\";d:0.6939;}s:3:\"end\";i:1580730501;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:4221;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:4071;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.9645;}s:3:\"end\";i:1580730494;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:26838;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:18917;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:5:\"ratio\";d:0.7049;}s:3:\"end\";i:1580730498;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:23568;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:17716;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.7517;}s:3:\"end\";i:1580730503;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("129","21","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.2;s:5:\"bytes\";i:9083;s:7:\"percent\";d:10.87;s:11:\"size_before\";i:83597;s:10:\"size_after\";i:74514;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.01;s:5:\"bytes\";i:462;s:7:\"percent\";d:7.9;s:11:\"size_before\";i:5847;s:10:\"size_after\";i:5385;}s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.04;s:5:\"bytes\";i:217;s:7:\"percent\";d:5.78;s:11:\"size_before\";i:3754;s:10:\"size_after\";i:3537;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.03;s:5:\"bytes\";i:1428;s:7:\"percent\";d:7.63;s:11:\"size_before\";i:18715;s:10:\"size_after\";i:17287;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.05;s:5:\"bytes\";i:2443;s:7:\"percent\";d:11.15;s:11:\"size_before\";i:21910;s:10:\"size_after\";i:19467;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.07;s:5:\"bytes\";i:4533;s:7:\"percent\";d:13.58;s:11:\"size_before\";i:33371;s:10:\"size_after\";i:28838;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("130","21","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("131","22","_wp_attached_file","2020/01/blog-4.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("132","22","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:760;s:4:\"file\";s:18:\"2020/01/blog-4.jpg\";s:8:\"filesize\";i:33087;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"blog-4-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5847;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"blog-4-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33371;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"blog-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3754;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"blog-4-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21910;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:18:\"blog-4-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18715;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("133","22","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:116684;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:5847;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:33371;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:3754;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:21910;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:18715;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:33087;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572424;}");
INSERT INTO BXzlkOCF_postmeta VALUES("134","22","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:760;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("135","22","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-4-300x200.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-4-300x200.jpg\";}i:1;a:2:{s:7:\"og_path\";s:73:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-4-1024x683.jpg\";s:11:\"backup_path\";s:106:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-4-1024x683.jpg\";}i:2;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-4-150x150.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-4-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-4-768x512.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-4-768x512.jpg\";}i:4;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-4-500x500.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-4-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:64:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-4.jpg\";s:11:\"backup_path\";s:97:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-4.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("136","22","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:36224;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:33087;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:760;s:5:\"ratio\";d:0.9134;}s:3:\"end\";i:1580730493;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:6983;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:6163;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:5:\"ratio\";d:0.8826;}s:3:\"end\";i:1580730496;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:40696;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:28238;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:5:\"ratio\";d:0.6939;}s:3:\"end\";i:1580730501;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:4221;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:4071;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.9645;}s:3:\"end\";i:1580730494;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:26838;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:18917;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:5:\"ratio\";d:0.7049;}s:3:\"end\";i:1580730498;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:23568;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:17716;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.7517;}s:3:\"end\";i:1580730503;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("137","22","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.47000000000000003;s:5:\"bytes\";i:9083;s:7:\"percent\";d:10.87;s:11:\"size_before\";i:83597;s:10:\"size_after\";i:74514;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.04;s:5:\"bytes\";i:217;s:7:\"percent\";d:5.78;s:11:\"size_before\";i:3754;s:10:\"size_after\";i:3537;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.04;s:5:\"bytes\";i:462;s:7:\"percent\";d:7.9;s:11:\"size_before\";i:5847;s:10:\"size_after\";i:5385;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.12;s:5:\"bytes\";i:4533;s:7:\"percent\";d:13.58;s:11:\"size_before\";i:33371;s:10:\"size_after\";i:28838;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.07;s:5:\"bytes\";i:1428;s:7:\"percent\";d:7.63;s:11:\"size_before\";i:18715;s:10:\"size_after\";i:17287;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.2;s:5:\"bytes\";i:2443;s:7:\"percent\";d:11.15;s:11:\"size_before\";i:21910;s:10:\"size_after\";i:19467;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("138","22","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("139","23","_wp_attached_file","2020/01/blog-5-1.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("140","23","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:760;s:4:\"file\";s:20:\"2020/01/blog-5-1.jpg\";s:8:\"filesize\";i:39953;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"blog-5-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6796;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"blog-5-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43350;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"blog-5-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3937;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"blog-5-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27872;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:20:\"blog-5-1-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21725;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("141","23","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:143633;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:6796;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:43350;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:3937;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:27872;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:21725;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:39953;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572639;}");
INSERT INTO BXzlkOCF_postmeta VALUES("142","23","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:760;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("143","23","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-5-1-300x200.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-5-1-300x200.jpg\";}i:1;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-5-1-1024x683.jpg\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-5-1-1024x683.jpg\";}i:2;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-5-1-150x150.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-5-1-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-5-1-768x512.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-5-1-768x512.jpg\";}i:4;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-5-1-500x500.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-5-1-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:66:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-5-1.jpg\";s:11:\"backup_path\";s:99:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-5-1.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("144","23","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:45322;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:39961;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:760;s:5:\"ratio\";d:0.8817;}s:3:\"end\";i:1580730491;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:7253;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:6603;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:5:\"ratio\";d:0.9104;}s:3:\"end\";i:1580730494;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:48967;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:37197;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:5:\"ratio\";d:0.7596;}s:3:\"end\";i:1580730499;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:3987;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:3824;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.9591;}s:3:\"end\";i:1580730493;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:31621;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:25252;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:5:\"ratio\";d:0.7986;}s:3:\"end\";i:1580730497;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:24943;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:19117;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.7664;}s:3:\"end\";i:1580730501;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("145","23","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.27;s:5:\"bytes\";i:5933;s:7:\"percent\";d:5.72;s:11:\"size_before\";i:103680;s:10:\"size_after\";i:97747;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.01;s:5:\"bytes\";i:190;s:7:\"percent\";d:4.83;s:11:\"size_before\";i:3937;s:10:\"size_after\";i:3747;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.01;s:5:\"bytes\";i:293;s:7:\"percent\";d:4.31;s:11:\"size_before\";i:6796;s:10:\"size_after\";i:6503;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.03;s:5:\"bytes\";i:985;s:7:\"percent\";d:4.53;s:11:\"size_before\";i:21725;s:10:\"size_after\";i:20740;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.09;s:5:\"bytes\";i:1565;s:7:\"percent\";d:5.61;s:11:\"size_before\";i:27872;s:10:\"size_after\";i:26307;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.13;s:5:\"bytes\";i:2900;s:7:\"percent\";d:6.69;s:11:\"size_before\";i:43350;s:10:\"size_after\";i:40450;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("146","23","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("147","24","_wp_attached_file","2020/01/blog-5.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("148","24","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:760;s:4:\"file\";s:18:\"2020/01/blog-5.jpg\";s:8:\"filesize\";i:39961;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"blog-5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6796;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"blog-5-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43350;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"blog-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3937;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"blog-5-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27872;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:18:\"blog-5-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21725;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("149","24","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.36000000000000004;s:5:\"bytes\";i:5933;s:7:\"percent\";d:5.72;s:11:\"size_before\";i:103680;s:10:\"size_after\";i:97747;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.05;s:5:\"bytes\";i:293;s:7:\"percent\";d:4.31;s:11:\"size_before\";i:6796;s:10:\"size_after\";i:6503;}s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.05;s:5:\"bytes\";i:190;s:7:\"percent\";d:4.83;s:11:\"size_before\";i:3937;s:10:\"size_after\";i:3747;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.05;s:5:\"bytes\";i:985;s:7:\"percent\";d:4.53;s:11:\"size_before\";i:21725;s:10:\"size_after\";i:20740;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.07;s:5:\"bytes\";i:1565;s:7:\"percent\";d:5.61;s:11:\"size_before\";i:27872;s:10:\"size_after\";i:26307;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.14;s:5:\"bytes\";i:2900;s:7:\"percent\";d:6.69;s:11:\"size_before\";i:43350;s:10:\"size_after\";i:40450;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("150","24","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("151","24","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:137708;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:6503;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:40450;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:3747;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:26307;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:20740;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:39961;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572429;}");
INSERT INTO BXzlkOCF_postmeta VALUES("152","24","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:760;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("153","24","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-5-300x200.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-5-300x200.jpg\";}i:1;a:2:{s:7:\"og_path\";s:73:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-5-1024x683.jpg\";s:11:\"backup_path\";s:106:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-5-1024x683.jpg\";}i:2;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-5-150x150.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-5-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-5-768x512.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-5-768x512.jpg\";}i:4;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-5-500x500.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-5-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:64:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-5.jpg\";s:11:\"backup_path\";s:97:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-5.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("154","24","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:45322;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:39961;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:760;s:5:\"ratio\";d:0.8817;}s:3:\"end\";i:1580730491;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:7253;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:6603;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:5:\"ratio\";d:0.9104;}s:3:\"end\";i:1580730494;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:48967;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:37197;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:5:\"ratio\";d:0.7596;}s:3:\"end\";i:1580730499;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:3987;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:3824;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:0.9591;}s:3:\"end\";i:1580730493;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:31621;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:25252;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:5:\"ratio\";d:0.7986;}s:3:\"end\";i:1580730497;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:24943;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:19117;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.7664;}s:3:\"end\";i:1580730501;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("155","25","_wp_attached_file","2020/01/blog-6-1.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("156","25","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:760;s:4:\"file\";s:20:\"2020/01/blog-6-1.jpg\";s:8:\"filesize\";i:52100;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"blog-6-1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12883;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"blog-6-1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:70054;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"blog-6-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6904;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"blog-6-1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46699;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:20:\"blog-6-1-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36220;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("157","25","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.28;s:5:\"bytes\";i:7965;s:7:\"percent\";d:4.61;s:11:\"size_before\";i:172760;s:10:\"size_after\";i:164795;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.01;s:5:\"bytes\";i:379;s:7:\"percent\";d:5.49;s:11:\"size_before\";i:6904;s:10:\"size_after\";i:6525;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.02;s:5:\"bytes\";i:587;s:7:\"percent\";d:4.56;s:11:\"size_before\";i:12883;s:10:\"size_after\";i:12296;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.08;s:5:\"bytes\";i:1831;s:7:\"percent\";d:5.06;s:11:\"size_before\";i:36220;s:10:\"size_after\";i:34389;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.08;s:5:\"bytes\";i:2090;s:7:\"percent\";d:4.48;s:11:\"size_before\";i:46699;s:10:\"size_after\";i:44609;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.09;s:5:\"bytes\";i:3078;s:7:\"percent\";d:4.39;s:11:\"size_before\";i:70054;s:10:\"size_after\";i:66976;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("158","25","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("159","25","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:216895;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:12296;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:66976;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:6525;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:44609;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:34389;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:52100;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572644;}");
INSERT INTO BXzlkOCF_postmeta VALUES("160","25","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:760;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("161","25","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-6-1-300x200.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-6-1-300x200.jpg\";}i:1;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-6-1-1024x683.jpg\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-6-1-1024x683.jpg\";}i:2;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-6-1-150x150.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-6-1-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-6-1-768x512.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-6-1-768x512.jpg\";}i:4;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-6-1-500x500.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-6-1-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:66:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-6-1.jpg\";s:11:\"backup_path\";s:99:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-6-1.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("162","25","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:59575;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:52108;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:760;s:5:\"ratio\";d:0.8747;}s:3:\"end\";i:1580730479;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:11822;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:11822;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730482;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:66550;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:48074;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:5:\"ratio\";d:0.7224;}s:3:\"end\";i:1580730487;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:6106;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:6106;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730481;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:44289;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:34183;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:5:\"ratio\";d:0.7718;}s:3:\"end\";i:1580730485;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:34555;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:25960;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.7513;}s:3:\"end\";i:1580730489;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("163","26","_wp_attached_file","2020/01/blog-6.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("164","26","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:760;s:4:\"file\";s:18:\"2020/01/blog-6.jpg\";s:8:\"filesize\";i:52108;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"blog-6-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12883;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"blog-6-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:70054;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"blog-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6904;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"blog-6-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:46699;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:18:\"blog-6-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36220;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("165","26","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:224868;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:12883;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:70054;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:6904;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:46699;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:36220;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:52108;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572431;}");
INSERT INTO BXzlkOCF_postmeta VALUES("166","26","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:760;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("167","26","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-6-300x200.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-6-300x200.jpg\";}i:1;a:2:{s:7:\"og_path\";s:73:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-6-1024x683.jpg\";s:11:\"backup_path\";s:106:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-6-1024x683.jpg\";}i:2;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-6-150x150.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-6-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-6-768x512.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-6-768x512.jpg\";}i:4;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-6-500x500.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-6-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:64:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-6.jpg\";s:11:\"backup_path\";s:97:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-6.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("168","26","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:59575;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:52108;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:760;s:5:\"ratio\";d:0.8747;}s:3:\"end\";i:1580730479;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:11822;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:11822;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730482;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:66550;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:48074;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:5:\"ratio\";d:0.7224;}s:3:\"end\";i:1580730487;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:6106;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:6106;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730481;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:44289;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:34183;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:5:\"ratio\";d:0.7718;}s:3:\"end\";i:1580730485;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:34555;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:25960;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.7513;}s:3:\"end\";i:1580730489;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("169","26","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.65;s:5:\"bytes\";i:7965;s:7:\"percent\";d:4.61;s:11:\"size_before\";i:172760;s:10:\"size_after\";i:164795;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.01;s:5:\"bytes\";i:379;s:7:\"percent\";d:5.49;s:11:\"size_before\";i:6904;s:10:\"size_after\";i:6525;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.03;s:5:\"bytes\";i:587;s:7:\"percent\";d:4.56;s:11:\"size_before\";i:12883;s:10:\"size_after\";i:12296;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.06;s:5:\"bytes\";i:2090;s:7:\"percent\";d:4.48;s:11:\"size_before\";i:46699;s:10:\"size_after\";i:44609;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.16;s:5:\"bytes\";i:1831;s:7:\"percent\";d:5.06;s:11:\"size_before\";i:36220;s:10:\"size_after\";i:34389;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.39;s:5:\"bytes\";i:3078;s:7:\"percent\";d:4.39;s:11:\"size_before\";i:70054;s:10:\"size_after\";i:66976;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("170","26","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("171","27","_wp_attached_file","2020/01/blog-7-1.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("172","27","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:757;s:4:\"file\";s:20:\"2020/01/blog-7-1.jpg\";s:8:\"filesize\";i:77461;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"blog-7-1-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20130;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"blog-7-1-1024x680.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:680;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:112363;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"blog-7-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9256;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"blog-7-1-768x510.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:75672;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:20:\"blog-7-1-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:49516;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("173","27","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:344398;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:20130;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:112363;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:9256;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:75672;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:49516;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:77461;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572646;}");
INSERT INTO BXzlkOCF_postmeta VALUES("174","27","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:757;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("175","27","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-7-1-300x199.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-7-1-300x199.jpg\";}i:1;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-7-1-1024x680.jpg\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-7-1-1024x680.jpg\";}i:2;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-7-1-150x150.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-7-1-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-7-1-768x510.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-7-1-768x510.jpg\";}i:4;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-7-1-500x500.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-7-1-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:66:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-7-1.jpg\";s:11:\"backup_path\";s:99:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-7-1.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("176","27","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:85588;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:77469;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:757;s:5:\"ratio\";d:0.9051;}s:3:\"end\";i:1580730479;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:18563;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:18563;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730483;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:108291;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:69416;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:680;s:5:\"ratio\";d:0.641;}s:3:\"end\";i:1580730488;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:8247;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:8247;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730481;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:72660;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:64644;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:510;s:5:\"ratio\";d:0.8897;}s:3:\"end\";i:1580730485;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:47547;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:42550;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.8949;}s:3:\"end\";i:1580730490;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("177","27","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.3;s:5:\"bytes\";i:17104;s:7:\"percent\";d:6.41;s:11:\"size_before\";i:266937;s:10:\"size_after\";i:249833;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.04;s:5:\"bytes\";i:670;s:7:\"percent\";d:7.24;s:11:\"size_before\";i:9256;s:10:\"size_after\";i:8586;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.02;s:5:\"bytes\";i:1481;s:7:\"percent\";d:7.36;s:11:\"size_before\";i:20130;s:10:\"size_after\";i:18649;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.05;s:5:\"bytes\";i:3213;s:7:\"percent\";d:6.49;s:11:\"size_before\";i:49516;s:10:\"size_after\";i:46303;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.07;s:5:\"bytes\";i:5005;s:7:\"percent\";d:6.61;s:11:\"size_before\";i:75672;s:10:\"size_after\";i:70667;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.12;s:5:\"bytes\";i:6735;s:7:\"percent\";d:5.99;s:11:\"size_before\";i:112363;s:10:\"size_after\";i:105628;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("178","27","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("179","28","_wp_attached_file","2020/01/blog-7.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("180","28","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:757;s:4:\"file\";s:18:\"2020/01/blog-7.jpg\";s:8:\"filesize\";i:77469;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"blog-7-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20130;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"blog-7-1024x680.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:680;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:112363;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"blog-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9256;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"blog-7-768x510.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:75672;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:18:\"blog-7-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:49516;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("181","28","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:344406;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:20130;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:112363;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:9256;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:75672;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:49516;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:77469;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572434;}");
INSERT INTO BXzlkOCF_postmeta VALUES("182","28","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:757;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("183","28","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-7-300x199.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-7-300x199.jpg\";}i:1;a:2:{s:7:\"og_path\";s:73:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-7-1024x680.jpg\";s:11:\"backup_path\";s:106:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-7-1024x680.jpg\";}i:2;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-7-150x150.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-7-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-7-768x510.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-7-768x510.jpg\";}i:4;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-7-500x500.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-7-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:64:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-7.jpg\";s:11:\"backup_path\";s:97:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-7.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("184","28","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:85588;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:77469;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:757;s:5:\"ratio\";d:0.9051;}s:3:\"end\";i:1580730479;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:18563;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:18563;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730483;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:108291;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:69416;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:680;s:5:\"ratio\";d:0.641;}s:3:\"end\";i:1580730488;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:8247;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:8247;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730481;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:72660;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:64644;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:510;s:5:\"ratio\";d:0.8897;}s:3:\"end\";i:1580730485;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:47547;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:42550;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:0.8949;}s:3:\"end\";i:1580730490;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("185","28","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.25;s:5:\"bytes\";i:17104;s:7:\"percent\";d:6.41;s:11:\"size_before\";i:266937;s:10:\"size_after\";i:249833;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.01;s:5:\"bytes\";i:670;s:7:\"percent\";d:7.24;s:11:\"size_before\";i:9256;s:10:\"size_after\";i:8586;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.02;s:5:\"bytes\";i:1481;s:7:\"percent\";d:7.36;s:11:\"size_before\";i:20130;s:10:\"size_after\";i:18649;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.04;s:5:\"bytes\";i:3213;s:7:\"percent\";d:6.49;s:11:\"size_before\";i:49516;s:10:\"size_after\";i:46303;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.07;s:5:\"bytes\";i:5005;s:7:\"percent\";d:6.61;s:11:\"size_before\";i:75672;s:10:\"size_after\";i:70667;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.11;s:5:\"bytes\";i:6735;s:7:\"percent\";d:5.99;s:11:\"size_before\";i:112363;s:10:\"size_after\";i:105628;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("186","28","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("187","29","_wp_attached_file","2020/01/blog-8-1.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("188","29","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:640;s:4:\"file\";s:20:\"2020/01/blog-8-1.jpg\";s:8:\"filesize\";i:121123;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"blog-8-1-300x168.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10773;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"blog-8-1-1024x575.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:115900;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"blog-8-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6983;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"blog-8-1-768x431.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:431;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68118;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:20:\"blog-8-1-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:71014;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("189","29","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:393911;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:10773;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:115900;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:6983;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:68118;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:71014;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:121123;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572648;}");
INSERT INTO BXzlkOCF_postmeta VALUES("190","29","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:640;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("191","29","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-8-1-300x168.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-8-1-300x168.jpg\";}i:1;a:2:{s:7:\"og_path\";s:75:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-8-1-1024x575.jpg\";s:11:\"backup_path\";s:108:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-8-1-1024x575.jpg\";}i:2;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-8-1-150x150.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-8-1-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-8-1-768x431.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-8-1-768x431.jpg\";}i:4;a:2:{s:7:\"og_path\";s:74:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-8-1-500x500.jpg\";s:11:\"backup_path\";s:107:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-8-1-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:66:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-8-1.jpg\";s:11:\"backup_path\";s:99:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-8-1.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("192","29","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:128548;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:121131;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:640;s:5:\"ratio\";d:0.9423;}s:3:\"end\";i:1580730480;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:9378;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:9378;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730483;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:110316;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:101285;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:575;s:5:\"ratio\";d:0.9181;}s:3:\"end\";i:1580730488;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:5980;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:5980;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730481;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:62602;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:62602;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:431;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730485;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:66155;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:66155;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730491;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("193","29","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.47;s:5:\"bytes\";i:15460;s:7:\"percent\";d:5.67;s:11:\"size_before\";i:272788;s:10:\"size_after\";i:257328;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.01;s:5:\"bytes\";i:422;s:7:\"percent\";d:6.04;s:11:\"size_before\";i:6983;s:10:\"size_after\";i:6561;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.03;s:5:\"bytes\";i:546;s:7:\"percent\";d:5.07;s:11:\"size_before\";i:10773;s:10:\"size_after\";i:10227;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.25;s:5:\"bytes\";i:3851;s:7:\"percent\";d:5.42;s:11:\"size_before\";i:71014;s:10:\"size_after\";i:67163;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.05;s:5:\"bytes\";i:3967;s:7:\"percent\";d:5.82;s:11:\"size_before\";i:68118;s:10:\"size_after\";i:64151;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.13;s:5:\"bytes\";i:6674;s:7:\"percent\";d:5.76;s:11:\"size_before\";i:115900;s:10:\"size_after\";i:109226;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("194","29","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("195","30","_wp_attached_file","2020/01/blog-8.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("196","30","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:640;s:4:\"file\";s:18:\"2020/01/blog-8.jpg\";s:8:\"filesize\";i:121131;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"blog-8-300x168.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10773;}s:5:\"large\";a:5:{s:4:\"file\";s:19:\"blog-8-1024x575.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:575;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:115900;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"blog-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6983;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:18:\"blog-8-768x431.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:431;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68118;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:18:\"blog-8-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:71014;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("197","30","wpvivid_image_optimize_meta","a:3:{s:3:\"sum\";a:3:{s:7:\"og_size\";i:393919;s:8:\"opt_size\";i:0;s:7:\"options\";a:2:{s:4:\"mode\";s:8:\"lossless\";s:6:\"backup\";b:1;}}s:4:\"size\";a:6:{s:6:\"medium\";a:3:{s:7:\"og_size\";i:10773;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:5:\"large\";a:3:{s:7:\"og_size\";i:115900;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:9:\"thumbnail\";a:3:{s:7:\"og_size\";i:6983;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:12:\"medium_large\";a:3:{s:7:\"og_size\";i:68118;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:18:\"Image Size 500x500\";a:3:{s:7:\"og_size\";i:71014;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}s:2:\"og\";a:3:{s:7:\"og_size\";i:121131;s:8:\"opt_size\";i:0;s:10:\"opt_status\";i:0;}}s:16:\"last_update_time\";i:1695572436;}");
INSERT INTO BXzlkOCF_postmeta VALUES("198","30","wpvivid_image_og_pixel_meta","a:1:{s:14:\"og_image_pixel\";a:2:{s:5:\"width\";i:1140;s:6:\"height\";i:640;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("199","30","wpvivid_backup_image_meta","a:6:{i:0;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-8-300x168.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-8-300x168.jpg\";}i:1;a:2:{s:7:\"og_path\";s:73:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-8-1024x575.jpg\";s:11:\"backup_path\";s:106:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-8-1024x575.jpg\";}i:2;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-8-150x150.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-8-150x150.jpg\";}i:3;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-8-768x431.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-8-768x431.jpg\";}i:4;a:2:{s:7:\"og_path\";s:72:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-8-500x500.jpg\";s:11:\"backup_path\";s:105:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-8-500x500.jpg\";}i:5;a:2:{s:7:\"og_path\";s:64:\"/home/oouaeco1/public_html/wp-content/uploads/2020/01/blog-8.jpg\";s:11:\"backup_path\";s:97:\"/home/oouaeco1/public_html/wp-content/wpvivid_image_optimization/backup_image//2020/01/blog-8.jpg\";}}");
INSERT INTO BXzlkOCF_postmeta VALUES("200","30","tiny_compress_images","a:6:{i:0;a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:128548;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:121131;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1140;s:6:\"height\";i:640;s:5:\"ratio\";d:0.9423;}s:3:\"end\";i:1580730480;}s:6:\"medium\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:9378;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:9378;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:168;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730483;}s:5:\"large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:110316;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:101285;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:575;s:5:\"ratio\";d:0.9181;}s:3:\"end\";i:1580730488;}s:9:\"thumbnail\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:5980;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:5980;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730481;}s:12:\"medium_large\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:62602;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:62602;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:431;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730485;}s:18:\"Image Size 500x500\";a:3:{s:5:\"input\";a:2:{s:4:\"size\";i:66155;s:4:\"type\";s:10:\"image/jpeg\";}s:6:\"output\";a:5:{s:4:\"size\";i:66155;s:4:\"type\";s:10:\"image/jpeg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:5:\"ratio\";d:1;}s:3:\"end\";i:1580730491;}}");
INSERT INTO BXzlkOCF_postmeta VALUES("201","30","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.38000000000000006;s:5:\"bytes\";i:15460;s:7:\"percent\";d:5.67;s:11:\"size_before\";i:272788;s:10:\"size_after\";i:257328;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.02;s:5:\"bytes\";i:422;s:7:\"percent\";d:6.04;s:11:\"size_before\";i:6983;s:10:\"size_after\";i:6561;}s:6:\"medium\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.06;s:5:\"bytes\";i:546;s:7:\"percent\";d:5.07;s:11:\"size_before\";i:10773;s:10:\"size_after\";i:10227;}s:18:\"Image Size 500x500\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.06;s:5:\"bytes\";i:3851;s:7:\"percent\";d:5.42;s:11:\"size_before\";i:71014;s:10:\"size_after\";i:67163;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.16;s:5:\"bytes\";i:3967;s:7:\"percent\";d:5.82;s:11:\"size_before\";i:68118;s:10:\"size_after\";i:64151;}s:5:\"large\";O:8:\"stdClass\":5:{s:4:\"time\";d:0.08;s:5:\"bytes\";i:6674;s:7:\"percent\";d:5.76;s:11:\"size_before\";i:115900;s:10:\"size_after\";i:109226;}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("202","30","wp-smush-lossy","1");
INSERT INTO BXzlkOCF_postmeta VALUES("203","31","_wp_attached_file","2020/01/blog-9-1.jpg");
INSERT INTO BXzlkOCF_postmeta VALUES("204","31","_wp_attachment_metadata","a:6:{s:5:\"width\";i:1140;s:6:\"height\";i:762;s:4:\"file\";s:20:\"2020/01/blog-9-1.jpg\";s:8:\"filesize\";i:142812;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"blog-9-1-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:29270;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"blog-9-1-1024x684.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:684;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:189127;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"blog-9-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11991;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"blog-9-1-768x513.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:513;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:127391;}s:18:\"Image Size 500x500\";a:5:{s:4:\"file\";s:20:\"blog-9-1-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:84806;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO BXzlkOCF_postmeta VALUES("205","31","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:4:\"time\";d:0.48000000000000004;s:5:\"bytes\";i:40157;s:7:\"percent\";d:9.07;s:11:\"size_before\";i:442585;s:10:\"size_after\";i:402428;s:5:\"lossy\";i:1;s:9:\"keep_exif\";i:0;s:11:\"api_version\";s:3:\"1.0\";}s:5:\"sizes\";a:5:{s:6:\"medium\";O:8:\